// ThreadRender.h: interface for the ThreadRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_THREADRENDER_H__E9AA5A11_F12D_4B40_B390_6FE764DDBE87__INCLUDED_)
#define AFX_THREADRENDER_H__E9AA5A11_F12D_4B40_B390_6FE764DDBE87__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "effects.h"

class ThreadRender  
{
public:
	ThreadRender(HWND hwnd, HINSTANCE hinst, int w, int h);
	void Start();
	void Pause();
	void Stop();
	void NewData(TimedLevel *pLevels, HWND hwnd, int w, int h);
	void NewSong(char *song);
	bool IsDone();
	virtual ~ThreadRender();
	HWND hwnd;
	HINSTANCE hinst;
	bool bQuit;
	bool bPause;
	int surface_width;
	int surface_height;
	short data[2][512];
	int levels_state;
	RECT oldRect;
	char *songTitle;
	char *songUsed;
	static unsigned int __stdcall thefunc(void *pv);
private:
	HANDLE hThread;
	bool brun;
	bool done;
	CRITICAL_SECTION crsec;
	bool bUpdate;

};

#endif // !defined(AFX_THREADRENDER_H__E9AA5A11_F12D_4B40_B390_6FE764DDBE87__INCLUDED_)
