/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MOUSEUI_H
#define MOUSEUI_H

#include <QObject>
#include <QWidget>
#include <QFrame>
#include <QLabel>
#include <QVBoxLayout>
#include <QSpacerItem>
#include <QRadioButton>
#include <QSlider>
#include <QByteArray>
#include <QVariant>
#include <QApplication>
#include <QButtonGroup>
#include <QDebug>
#include <QToolButton>


#include "ukcccommon.h"
using namespace ukcc;

#include "titlelabel.h"
#include "switchwidget.h"
#include "sliderwidget.h"
#include "radiobuttonwidget.h"
#include "settinggroup.h"

#include "kslider.h"
#include "kswitchbutton.h"
using namespace kdk;

#define SMALLPOINTER 24
#define MEDIUMPOINTER 36
#define LARGEPOINTER 48

class DoubleClickTestLabel : public QLabel
{
    Q_OBJECT

public:
    DoubleClickTestLabel();
    ~DoubleClickTestLabel();

public:
    QDBusInterface * mDoubleClickTestDbus;

protected:
    void mouseDoubleClickEvent(QMouseEvent *event);
};

class MouseUI : public QWidget
{
    Q_OBJECT

public:
    explicit MouseUI(QWidget *parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    virtual ~MouseUI();

    void settingForIntel();

public:
    inline RadioButtonWidget *dominantHandWidget()
    {
        return mDominantHandWidget;
    }

    inline QRadioButton *dominantHandLeftRadio()
    {
        return mDominantHandLeftRadio;
    }

    inline QRadioButton *dominantHandRightRadio()
    {
        return mDominantHandRightRadio;
    }

    inline RadioButtonWidget *scrollDirectionWdiget()
    {
        return mScrollDirectionWdiget;
    }

    inline QRadioButton *scrollDirectionForwardRadio()
    {
        return mScrollDirectionForwardRadio;
    }

    inline QRadioButton *scrollDirectionReverseRadio()
    {
        return mScrollDirectionReverseRadio;
    }

    inline SliderWidget *wheelSpeedWidget()
    {
        return mWheelSpeedWidget;
    }

    inline SliderWidget *doubleClickIntervalWidget()
    {
        return mDoubleClickIntervalWidget;
    }

    inline SliderWidget *pointerSpeedWidget()
    {
        return mPointerSpeedWidget;
    }

    inline SwitchWidget *mouseAccelerationWidget()
    {
        return mMouseAccelerationWidget;
    }

    inline SwitchWidget *pointerPositionWidget()
    {
        return mPointerPositionWidget;
    }

    inline RadioButtonWidget *pointerSizeWidet()
    {
        return mPointerSizeWidet;
    }

    inline QRadioButton *pointerSizeSmallRadio()
    {
        return mPointerSizeSmallRadio;
    }

    inline QRadioButton *pointerSizeMediumRadio()
    {
        return mPointerSizeMediumRadio;
    }

    inline QRadioButton *pointerSizeLargeRadio()
    {
        return mPointerSizeLargeRadio;
    }

    inline SwitchWidget *blinkingCursorOnTextWidget()
    {
        return mBlinkingCursorOnTextWidget;
    }

    inline SliderWidget *cursorSpeedWidget()
    {
        return mCursorSpeedWidget;
    }

private:
    RadioButtonWidget *mDominantHandWidget;    // 惯用手
    RadioButtonWidget *mScrollDirectionWdiget; // 滚动方向
    SliderWidget *mWheelSpeedWidget;           // 滚轮速度
    SliderWidget *mDoubleClickIntervalWidget;  // 双击间隔时长
    SliderWidget *mPointerSpeedWidget;         // 指针速度
    SwitchWidget *mMouseAccelerationWidget;    // 鼠标加速
    SwitchWidget *mPointerPositionWidget;      // 按 ctrl 键时显示指针位置
    RadioButtonWidget *mPointerSizeWidet;      // 指针大小
    SwitchWidget *mBlinkingCursorOnTextWidget; // 文本区域闪烁光标
    SliderWidget *mCursorSpeedWidget;          // 光标速度

    TitleLabel *mMouseTitleLabel;
    TitleLabel *mPointerTitleLabel;
    TitleLabel *mCursorTitleLabel;

    QRadioButton *mDominantHandLeftRadio;
    QRadioButton *mDominantHandRightRadio;
    QRadioButton *mScrollDirectionForwardRadio;
    QRadioButton *mScrollDirectionReverseRadio;
    QRadioButton *mPointerSizeSmallRadio;
    QRadioButton *mPointerSizeMediumRadio;
    QRadioButton *mPointerSizeLargeRadio;

    QVBoxLayout *mVlayout;

private:
    void initUI();
    void setDominantHandFrame();
    void setScrollDirectionFrame();
    void setWheelSpeedFrame();
    void setDoubleClickFrame();
    void setPointerSpeedFrame();
    void setMouseAccelerationFrame();
    void setPointerPositionFrame();
    void setPointerSizeFrame();
    void setBlinkCursorFrame();
    void setCursorSpeedFrame();

};
#endif // MOUSEUI_H
