# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SyncGroupLogProperties(Model):
    """Properties of an Azure SQL Database sync group log.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar timestamp: Timestamp of the sync group log.
    :vartype timestamp: datetime
    :ivar type: Type of the sync group log. Possible values include: 'All',
     'Error', 'Warning', 'Success'
    :vartype type: str or :class:`SyncGroupLogType
     <azure.mgmt.sql.models.SyncGroupLogType>`
    :ivar source: Source of the sync group log.
    :vartype source: str
    :ivar details: Details of the sync group log.
    :vartype details: str
    :ivar tracing_id: TracingId of the sync group log.
    :vartype tracing_id: str
    :ivar operation_status: OperationStatus of the sync group log.
    :vartype operation_status: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'type': {'readonly': True},
        'source': {'readonly': True},
        'details': {'readonly': True},
        'tracing_id': {'readonly': True},
        'operation_status': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'tracing_id': {'key': 'tracingId', 'type': 'str'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
    }

    def __init__(self):
        self.timestamp = None
        self.type = None
        self.source = None
        self.details = None
        self.tracing_id = None
        self.operation_status = None
