# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientCertificateCommonName(Model):
    """Client certificate details using common name.

    :param is_admin: Is this certificate used for admin access from the
     client, if false , it is used or query only access
    :type is_admin: bool
    :param certificate_common_name: Certificate common name to be granted
     access; be carefull using wild card common names
    :type certificate_common_name: str
    :param certificate_issuer_thumbprint: Certificate issuer thumbprint
    :type certificate_issuer_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
        'certificate_common_name': {'required': True},
        'certificate_issuer_thumbprint': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'certificate_common_name': {'key': 'certificateCommonName', 'type': 'str'},
        'certificate_issuer_thumbprint': {'key': 'certificateIssuerThumbprint', 'type': 'str'},
    }

    def __init__(self, is_admin, certificate_common_name, certificate_issuer_thumbprint):
        self.is_admin = is_admin
        self.certificate_common_name = certificate_common_name
        self.certificate_issuer_thumbprint = certificate_issuer_thumbprint
