# Constants extracted from gphoto2's ptp.h

PTP_DL_BE = 0xF0
PTP_DL_LE = 0x0F
USB_CLASS_PTP = 6
PTP_USB_BULK_HS_MAX_PACKET_LEN_WRITE = 512
PTP_USB_BULK_HS_MAX_PACKET_LEN_READ = 512
PTP_USB_BULK_HDR_LEN = (2*4+2*2)
PTP_USB_BULK_PAYLOAD_LEN_WRITE = (PTP_USB_BULK_HS_MAX_PACKET_LEN_WRITE-PTP_USB_BULK_HDR_LEN)
PTP_USB_BULK_PAYLOAD_LEN_READ = (PTP_USB_BULK_HS_MAX_PACKET_LEN_READ-PTP_USB_BULK_HDR_LEN)
PTP_USB_BULK_REQ_LEN = (PTP_USB_BULK_HDR_LEN+5*4)
PTP_USB_CONTAINER_UNDEFINED = 0x0000
PTP_USB_CONTAINER_COMMAND = 0x0001
PTP_USB_CONTAINER_DATA = 0x0002
PTP_USB_CONTAINER_RESPONSE = 0x0003
PTP_USB_CONTAINER_EVENT = 0x0004
PTPIP_INIT_COMMAND_REQUEST = 1
PTPIP_INIT_COMMAND_ACK = 2
PTPIP_INIT_EVENT_REQUEST = 3
PTPIP_INIT_EVENT_ACK = 4
PTPIP_INIT_FAIL = 5
PTPIP_CMD_REQUEST = 6
PTPIP_CMD_RESPONSE = 7
PTPIP_EVENT = 8
PTPIP_START_DATA_PACKET = 9
PTPIP_DATA_PACKET = 10
PTPIP_CANCEL_TRANSACTION = 11
PTPIP_END_DATA_PACKET = 12
PTPIP_PING = 13
PTPIP_PONG = 14
PTP_VENDOR_EASTMAN_KODAK = 0x00000001
PTP_VENDOR_SEIKO_EPSON = 0x00000002
PTP_VENDOR_AGILENT = 0x00000003
PTP_VENDOR_POLAROID = 0x00000004
PTP_VENDOR_AGFA_GEVAERT = 0x00000005
PTP_VENDOR_MICROSOFT = 0x00000006
PTP_VENDOR_EQUINOX = 0x00000007
PTP_VENDOR_VIEWQUEST = 0x00000008
PTP_VENDOR_STMICROELECTRONICS = 0x00000009
PTP_VENDOR_NIKON = 0x0000000A
PTP_VENDOR_CANON = 0x0000000B
PTP_VENDOR_FOTONATION = 0x0000000C
PTP_VENDOR_PENTAX = 0x0000000D
PTP_VENDOR_FUJI = 0x0000000E
PTP_VENDOR_MTP = 0xffffffff
PTP_OC_Undefined = 0x1000
PTP_OC_GetDeviceInfo = 0x1001
PTP_OC_OpenSession = 0x1002
PTP_OC_CloseSession = 0x1003
PTP_OC_GetStorageIDs = 0x1004
PTP_OC_GetStorageInfo = 0x1005
PTP_OC_GetNumObjects = 0x1006
PTP_OC_GetObjectHandles = 0x1007
PTP_OC_GetObjectInfo = 0x1008
PTP_OC_GetObject = 0x1009
PTP_OC_GetThumb = 0x100A
PTP_OC_DeleteObject = 0x100B
PTP_OC_SendObjectInfo = 0x100C
PTP_OC_SendObject = 0x100D
PTP_OC_InitiateCapture = 0x100E
PTP_OC_FormatStore = 0x100F
PTP_OC_ResetDevice = 0x1010
PTP_OC_SelfTest = 0x1011
PTP_OC_SetObjectProtection = 0x1012
PTP_OC_PowerDown = 0x1013
PTP_OC_GetDevicePropDesc = 0x1014
PTP_OC_GetDevicePropValue = 0x1015
PTP_OC_SetDevicePropValue = 0x1016
PTP_OC_ResetDevicePropValue = 0x1017
PTP_OC_TerminateOpenCapture = 0x1018
PTP_OC_MoveObject = 0x1019
PTP_OC_CopyObject = 0x101A
PTP_OC_GetPartialObject = 0x101B
PTP_OC_InitiateOpenCapture = 0x101C
PTP_OC_StartEnumHandles = 0x101D
PTP_OC_EnumHandles = 0x101E
PTP_OC_StopEnumHandles = 0x101F
PTP_OC_GetVendorExtensionMaps = 0x1020
PTP_OC_GetVendorDeviceInfo = 0x1021
PTP_OC_GetResizedImageObject = 0x1022
PTP_OC_GetFilesystemManifest = 0x1023
PTP_OC_GetStreamInfo = 0x1024
PTP_OC_GetStream = 0x1025
PTP_OC_EK_GetSerial = 0x9003
PTP_OC_EK_SetSerial = 0x9004
PTP_OC_EK_SendFileObjectInfo = 0x9005
PTP_OC_EK_SendFileObject = 0x9006
PTP_OC_EK_SetText = 0x9008
PTP_OC_CANON_GetPartialObjectInfo = 0x9001
PTP_OC_CANON_SetObjectArchive = 0x9002
PTP_OC_CANON_KeepDeviceOn = 0x9003
PTP_OC_CANON_LockDeviceUI = 0x9004
PTP_OC_CANON_UnlockDeviceUI = 0x9005
PTP_OC_CANON_GetObjectHandleByName = 0x9006
PTP_OC_CANON_InitiateReleaseControl = 0x9008
PTP_OC_CANON_TerminateReleaseControl = 0x9009
PTP_OC_CANON_TerminatePlaybackMode = 0x900A
PTP_OC_CANON_ViewfinderOn = 0x900B
PTP_OC_CANON_ViewfinderOff = 0x900C
PTP_OC_CANON_DoAeAfAwb = 0x900D
PTP_OC_CANON_GetCustomizeSpec = 0x900E
PTP_OC_CANON_GetCustomizeItemInfo = 0x900F
PTP_OC_CANON_GetCustomizeData = 0x9010
PTP_OC_CANON_SetCustomizeData = 0x9011
PTP_OC_CANON_GetCaptureStatus = 0x9012
PTP_OC_CANON_CheckEvent = 0x9013
PTP_OC_CANON_FocusLock = 0x9014
PTP_OC_CANON_FocusUnlock = 0x9015
PTP_OC_CANON_GetLocalReleaseParam = 0x9016
PTP_OC_CANON_SetLocalReleaseParam = 0x9017
PTP_OC_CANON_AskAboutPcEvf = 0x9018
PTP_OC_CANON_SendPartialObject = 0x9019
PTP_OC_CANON_InitiateCaptureInMemory = 0x901A
PTP_OC_CANON_GetPartialObjectEx = 0x901B
PTP_OC_CANON_SetObjectTime = 0x901C
PTP_OC_CANON_GetViewfinderImage = 0x901D
PTP_OC_CANON_GetObjectAttributes = 0x901E
PTP_OC_CANON_ChangeUSBProtocol = 0x901F
PTP_OC_CANON_GetChanges = 0x9020
PTP_OC_CANON_GetObjectInfoEx = 0x9021
PTP_OC_CANON_InitiateDirectTransfer = 0x9022
PTP_OC_CANON_TerminateDirectTransfer = 0x9023
PTP_OC_CANON_SendObjectInfoByPath = 0x9024
PTP_OC_CANON_SendObjectByPath = 0x9025
PTP_OC_CANON_InitiateDirectTansferEx = 0x9026
PTP_OC_CANON_GetAncillaryObjectHandles = 0x9027
PTP_OC_CANON_GetTreeInfo = 0x9028
PTP_OC_CANON_GetTreeSize = 0x9029
PTP_OC_CANON_NotifyProgress = 0x902A
PTP_OC_CANON_NotifyCancelAccepted = 0x902B
PTP_OC_CANON_902C = 0x902C
PTP_OC_CANON_GetDirectory = 0x902D
PTP_OC_CANON_SetPairingInfo = 0x9030
PTP_OC_CANON_GetPairingInfo = 0x9031
PTP_OC_CANON_DeletePairingInfo = 0x9032
PTP_OC_CANON_GetMACAddress = 0x9033
PTP_OC_CANON_SetDisplayMonitor = 0x9034
PTP_OC_CANON_PairingComplete = 0x9035
PTP_OC_CANON_GetWirelessMAXChannel = 0x9036
PTP_OC_CANON_EOS_GetStorageIDs = 0x9101
PTP_OC_CANON_EOS_GetStorageInfo = 0x9102
PTP_OC_CANON_EOS_GetObjectInfo = 0x9103
PTP_OC_CANON_EOS_GetObject = 0x9104
PTP_OC_CANON_EOS_DeleteObject = 0x9105
PTP_OC_CANON_EOS_FormatStore = 0x9106
PTP_OC_CANON_EOS_GetPartialObject = 0x9107
PTP_OC_CANON_EOS_GetDeviceInfoEx = 0x9108
PTP_OC_CANON_EOS_GetObjectInfoEx = 0x9109
PTP_OC_CANON_EOS_GetThumbEx = 0x910A
PTP_OC_CANON_EOS_SendPartialObject = 0x910B
PTP_OC_CANON_EOS_SetObjectAttributes = 0x910C
PTP_OC_CANON_EOS_GetObjectTime = 0x910D
PTP_OC_CANON_EOS_SetObjectTime = 0x910E
PTP_OC_CANON_EOS_RemoteRelease = 0x910F
PTP_OC_CANON_EOS_SetDevicePropValueEx = 0x9110
PTP_OC_CANON_EOS_GetRemoteMode = 0x9113
PTP_OC_CANON_EOS_SetRemoteMode = 0x9114
PTP_OC_CANON_EOS_SetEventMode = 0x9115
PTP_OC_CANON_EOS_GetEvent = 0x9116
PTP_OC_CANON_EOS_TransferComplete = 0x9117
PTP_OC_CANON_EOS_CancelTransfer = 0x9118
PTP_OC_CANON_EOS_ResetTransfer = 0x9119
PTP_OC_CANON_EOS_PCHDDCapacity = 0x911A
PTP_OC_CANON_EOS_SetUILock = 0x911B
PTP_OC_CANON_EOS_ResetUILock = 0x911C
PTP_OC_CANON_EOS_KeepDeviceOn = 0x911D
PTP_OC_CANON_EOS_SetNullPacketMode = 0x911E
PTP_OC_CANON_EOS_UpdateFirmware = 0x911F
PTP_OC_CANON_EOS_TransferCompleteDT = 0x9120
PTP_OC_CANON_EOS_CancelTransferDT = 0x9121
PTP_OC_CANON_EOS_SetWftProfile = 0x9122
PTP_OC_CANON_EOS_GetWftProfile = 0x9122
PTP_OC_CANON_EOS_SetProfileToWft = 0x9124
PTP_OC_CANON_EOS_BulbStart = 0x9125
PTP_OC_CANON_EOS_BulbEnd = 0x9126
PTP_OC_CANON_EOS_RequestDevicePropValue = 0x9127
PTP_OC_CANON_EOS_RemoteReleaseOn = 0x9128
PTP_OC_CANON_EOS_RemoteReleaseOff = 0x9129
PTP_OC_CANON_EOS_InitiateViewfinder = 0x9151
PTP_OC_CANON_EOS_TerminateViewfinder = 0x9152
PTP_OC_CANON_EOS_GetViewFinderData = 0x9153
PTP_OC_CANON_EOS_DoAf = 0x9154
PTP_OC_CANON_EOS_DriveLens = 0x9155
PTP_OC_CANON_EOS_DepthOfFieldPreview = 0x9156
PTP_OC_CANON_EOS_ClickWB = 0x9157
PTP_OC_CANON_EOS_Zoom = 0x9158
PTP_OC_CANON_EOS_ZoomPosition = 0x9159
PTP_OC_CANON_EOS_SetLiveAfFrame = 0x915a
PTP_OC_CANON_EOS_AfCancel = 0x9160
PTP_OC_CANON_EOS_FAPIMessageTX = 0x91FE
PTP_OC_CANON_EOS_FAPIMessageRX = 0x91FF
PTP_OC_NIKON_GetProfileAllData = 0x9006
PTP_OC_NIKON_SendProfileData = 0x9007
PTP_OC_NIKON_DeleteProfile = 0x9008
PTP_OC_NIKON_SetProfileData = 0x9009
PTP_OC_NIKON_AdvancedTransfer = 0x9010
PTP_OC_NIKON_GetFileInfoInBlock = 0x9011
PTP_OC_NIKON_Capture = 0x90C0	# 1 param,   no data */
PTP_OC_NIKON_AfDrive = 0x90C1	# no params, no data */
PTP_OC_NIKON_SetControlMode = 0x90C2	# 1 param,   no data */
PTP_OC_NIKON_DelImageSDRAM = 0x90C3	# no params, no data */
PTP_OC_NIKON_GetLargeThumb = 0x90C4
PTP_OC_NIKON_CurveDownload = 0x90C5	# 1 param,   data in */
PTP_OC_NIKON_CurveUpload = 0x90C6	# 1 param,   data out */
PTP_OC_NIKON_CheckEvent = 0x90C7	# no params, data in */
PTP_OC_NIKON_DeviceReady = 0x90C8	# no params, no data */
PTP_OC_NIKON_SetPreWBData = 0x90C9	# 3 params,  data out */
PTP_OC_NIKON_GetVendorPropCodes = 0x90CA	# 0 params, data in */
PTP_OC_NIKON_AfCaptureSDRAM = 0x90CB	# no params, no data */
PTP_OC_NIKON_GetPictCtrlData = 0x90CC
PTP_OC_NIKON_SetPictCtrlData = 0x90CD
PTP_OC_NIKON_DelCstPicCtrl = 0x90CE
PTP_OC_NIKON_GetPicCtrlCapability = 0x90CF
PTP_OC_NIKON_GetPreviewImg = 0x9200
PTP_OC_NIKON_StartLiveView = 0x9201
PTP_OC_NIKON_EndLiveView = 0x9202
PTP_OC_NIKON_GetLiveViewImg = 0x9203
PTP_OC_NIKON_MfDrive = 0x9204
PTP_OC_NIKON_ChangeAfArea = 0x9205
PTP_OC_NIKON_AfDriveCancel = 0x9206
PTP_OC_NIKON_GetDevicePTPIPInfo = 0x90E0
PTP_OC_MTP_GetObjectPropsSupported = 0x9801
PTP_OC_MTP_GetObjectPropDesc = 0x9802
PTP_OC_MTP_GetObjectPropValue = 0x9803
PTP_OC_MTP_SetObjectPropValue = 0x9804
PTP_OC_MTP_GetObjPropList = 0x9805
PTP_OC_MTP_SetObjPropList = 0x9806
PTP_OC_MTP_GetInterdependendPropdesc = 0x9807
PTP_OC_MTP_SendObjectPropList = 0x9808
PTP_OC_MTP_GetObjectReferences = 0x9810
PTP_OC_MTP_SetObjectReferences = 0x9811
PTP_OC_MTP_UpdateDeviceFirmware = 0x9812
PTP_OC_MTP_Skip = 0x9820
PTP_OC_MTP_WMDRMPD_GetSecureTimeChallenge = 0x9101
PTP_OC_MTP_WMDRMPD_GetSecureTimeResponse = 0x9102
PTP_OC_MTP_WMDRMPD_SetLicenseResponse = 0x9103
PTP_OC_MTP_WMDRMPD_GetSyncList = 0x9104
PTP_OC_MTP_WMDRMPD_SendMeterChallengeQuery = 0x9105
PTP_OC_MTP_WMDRMPD_GetMeterChallenge = 0x9106
PTP_OC_MTP_WMDRMPD_SetMeterResponse = 0x9107
PTP_OC_MTP_WMDRMPD_CleanDataStore = 0x9108
PTP_OC_MTP_WMDRMPD_GetLicenseState = 0x9109
PTP_OC_MTP_WMDRMPD_SendWMDRMPDCommand = 0x910A
PTP_OC_MTP_WMDRMPD_SendWMDRMPDRequest = 0x910B
PTP_OC_MTP_WMDRMPD_SendWMDRMPDAppRequest = 0x9212
PTP_OC_MTP_WMDRMPD_GetWMDRMPDAppResponse = 0x9213
PTP_OC_MTP_WMDRMPD_EnableTrustedFilesOperations = 0x9214
PTP_OC_MTP_WMDRMPD_DisableTrustedFilesOperations = 0x9215
PTP_OC_MTP_WMDRMPD_EndTrustedAppSession = 0x9216
PTP_OC_MTP_AAVT_OpenMediaSession = 0x9170
PTP_OC_MTP_AAVT_CloseMediaSession = 0x9171
PTP_OC_MTP_AAVT_GetNextDataBlock = 0x9172
PTP_OC_MTP_AAVT_SetCurrentTimePosition = 0x9173
PTP_OC_MTP_WMDRMND_SendRegistrationRequest = 0x9180
PTP_OC_MTP_WMDRMND_GetRegistrationResponse = 0x9181
PTP_OC_MTP_WMDRMND_GetProximityChallenge = 0x9182
PTP_OC_MTP_WMDRMND_SendProximityResponse = 0x9183
PTP_OC_MTP_WMDRMND_SendWMDRMNDLicenseRequest = 0x9184
PTP_OC_MTP_WMDRMND_GetWMDRMNDLicenseResponse = 0x9185
PTP_OC_MTP_WMPPD_ReportAddedDeletedItems = 0x9201
PTP_OC_MTP_WMPPD_ReportAcquiredItems = 0x9202
PTP_OC_MTP_WMPPD_PlaylistObjectPref = 0x9203
PTP_OC_MTP_ZUNE_GETUNDEFINED001 = 0x9204
PTP_OC_MTP_WPDWCN_ProcessWFCObject = 0x9122
PTP_OC_EXTENSION_MASK = 0xF000
PTP_OC_EXTENSION = 0x9000
PTP_RC_Undefined = 0x2000
PTP_RC_OK = 0x2001
PTP_RC_GeneralError = 0x2002
PTP_RC_SessionNotOpen = 0x2003
PTP_RC_InvalidTransactionID = 0x2004
PTP_RC_OperationNotSupported = 0x2005
PTP_RC_ParameterNotSupported = 0x2006
PTP_RC_IncompleteTransfer = 0x2007
PTP_RC_InvalidStorageId = 0x2008
PTP_RC_InvalidObjectHandle = 0x2009
PTP_RC_DevicePropNotSupported = 0x200A
PTP_RC_InvalidObjectFormatCode = 0x200B
PTP_RC_StoreFull = 0x200C
PTP_RC_ObjectWriteProtected = 0x200D
PTP_RC_StoreReadOnly = 0x200E
PTP_RC_AccessDenied = 0x200F
PTP_RC_NoThumbnailPresent = 0x2010
PTP_RC_SelfTestFailed = 0x2011
PTP_RC_PartialDeletion = 0x2012
PTP_RC_StoreNotAvailable = 0x2013
PTP_RC_SpecificationByFormatUnsupported = 0x2014
PTP_RC_NoValidObjectInfo = 0x2015
PTP_RC_InvalidCodeFormat = 0x2016
PTP_RC_UnknownVendorCode = 0x2017
PTP_RC_CaptureAlreadyTerminated = 0x2018
PTP_RC_DeviceBusy = 0x2019
PTP_RC_InvalidParentObject = 0x201A
PTP_RC_InvalidDevicePropFormat = 0x201B
PTP_RC_InvalidDevicePropValue = 0x201C
PTP_RC_InvalidParameter = 0x201D
PTP_RC_SessionAlreadyOpened = 0x201E
PTP_RC_TransactionCanceled = 0x201F
PTP_RC_SpecificationOfDestinationUnsupported = 0x2020
PTP_RC_InvalidEnumHandle = 0x2021
PTP_RC_NoStreamEnabled = 0x2022
PTP_RC_InvalidDataSet = 0x2023
PTP_RC_EK_FilenameRequired = 0xA001
PTP_RC_EK_FilenameConflicts = 0xA002
PTP_RC_EK_FilenameInvalid = 0xA003
PTP_RC_NIKON_HardwareError = 0xA001
PTP_RC_NIKON_OutOfFocus = 0xA002
PTP_RC_NIKON_ChangeCameraModeFailed = 0xA003
PTP_RC_NIKON_InvalidStatus = 0xA004
PTP_RC_NIKON_SetPropertyNotSupported = 0xA005
PTP_RC_NIKON_WbResetError = 0xA006
PTP_RC_NIKON_DustReferenceError = 0xA007
PTP_RC_NIKON_ShutterSpeedBulb = 0xA008
PTP_RC_NIKON_MirrorUpSequence = 0xA009
PTP_RC_NIKON_CameraModeNotAdjustFNumber = 0xA00A
PTP_RC_NIKON_NotLiveView = 0xA00B
PTP_RC_NIKON_MfDriveStepEnd = 0xA00C
PTP_RC_NIKON_MfDriveStepInsufficiency = 0xA00E
PTP_RC_NIKON_AdvancedTransferCancel = 0xA022
PTP_RC_CANON_UNKNOWN_COMMAND = 0xA001
PTP_RC_CANON_OPERATION_REFUSED = 0xA005
PTP_RC_CANON_LENS_COVER = 0xA006
PTP_RC_CANON_BATTERY_LOW = 0xA101
PTP_RC_CANON_NOT_READY = 0xA102
PTP_RC_CANON_A009 = 0xA009
PTP_RC_MTP_Undefined = 0xA800
PTP_RC_MTP_Invalid_ObjectPropCode = 0xA801
PTP_RC_MTP_Invalid_ObjectProp_Format = 0xA802
PTP_RC_MTP_Invalid_ObjectProp_Value = 0xA803
PTP_RC_MTP_Invalid_ObjectReference = 0xA804
PTP_RC_MTP_Invalid_Dataset = 0xA806
PTP_RC_MTP_Specification_By_Group_Unsupported = 0xA807
PTP_RC_MTP_Specification_By_Depth_Unsupported = 0xA808
PTP_RC_MTP_Object_Too_Large = 0xA809
PTP_RC_MTP_ObjectProp_Not_Supported = 0xA80A
PTP_RC_MTP_Invalid_Media_Session_ID = 0xA170
PTP_RC_MTP_Media_Session_Limit_Reached = 0xA171
PTP_RC_MTP_No_More_Data = 0xA172
PTP_RC_MTP_Invalid_WFC_Syntax = 0xA121
PTP_RC_MTP_WFC_Version_Not_Supported = 0xA122
PTP_ERROR_IO = 0x02FF
PTP_ERROR_DATA_EXPECTED = 0x02FE
PTP_ERROR_RESP_EXPECTED = 0x02FD
PTP_ERROR_BADPARAM = 0x02FC
PTP_ERROR_CANCEL = 0x02FB
PTP_ERROR_TIMEOUT = 0x02FA
PTP_EC_Undefined = 0x4000
PTP_EC_CancelTransaction = 0x4001
PTP_EC_ObjectAdded = 0x4002
PTP_EC_ObjectRemoved = 0x4003
PTP_EC_StoreAdded = 0x4004
PTP_EC_StoreRemoved = 0x4005
PTP_EC_DevicePropChanged = 0x4006
PTP_EC_ObjectInfoChanged = 0x4007
PTP_EC_DeviceInfoChanged = 0x4008
PTP_EC_RequestObjectTransfer = 0x4009
PTP_EC_StoreFull = 0x400A
PTP_EC_DeviceReset = 0x400B
PTP_EC_StorageInfoChanged = 0x400C
PTP_EC_CaptureComplete = 0x400D
PTP_EC_UnreportedStatus = 0x400E
PTP_EC_CANON_ExtendedErrorcode = 0xC005	# ? */
PTP_EC_CANON_ObjectInfoChanged = 0xC008
PTP_EC_CANON_RequestObjectTransfer = 0xC009
PTP_EC_CANON_CameraModeChanged = 0xC00C
PTP_EC_CANON_ShutterButtonPressed = 0xC00E
PTP_EC_CANON_StartDirectTransfer = 0xC011
PTP_EC_CANON_StopDirectTransfer = 0xC013
PTP_EC_CANON_EOS_RequestGetEvent = 0xc101
PTP_EC_CANON_EOS_ObjectAddedEx = 0xc181
PTP_EC_CANON_EOS_ObjectRemoved = 0xc182
PTP_EC_CANON_EOS_RequestGetObjectInfoEx = 0xc183
PTP_EC_CANON_EOS_StorageStatusChanged = 0xc184
PTP_EC_CANON_EOS_StorageInfoChanged = 0xc185
PTP_EC_CANON_EOS_RequestObjectTransfer = 0xc186
PTP_EC_CANON_EOS_ObjectInfoChangedEx = 0xc187
PTP_EC_CANON_EOS_ObjectContentChanged = 0xc188
PTP_EC_CANON_EOS_PropValueChanged = 0xc189
PTP_EC_CANON_EOS_AvailListChanged = 0xc18a
PTP_EC_CANON_EOS_CameraStatusChanged = 0xc18b
PTP_EC_CANON_EOS_WillSoonShutdown = 0xc18d
PTP_EC_CANON_EOS_ShutdownTimerUpdated = 0xc18e
PTP_EC_CANON_EOS_RequestCancelTransfer = 0xc18f
PTP_EC_CANON_EOS_RequestObjectTransferDT = 0xc190
PTP_EC_CANON_EOS_RequestCancelTransferDT = 0xc191
PTP_EC_CANON_EOS_StoreAdded = 0xc192
PTP_EC_CANON_EOS_StoreRemoved = 0xc193
PTP_EC_CANON_EOS_BulbExposureTime = 0xc194
PTP_EC_CANON_EOS_RecordingTime = 0xc195
PTP_EC_CANON_EOS_RequestObjectTransferTS = 0xC1a2
PTP_EC_CANON_EOS_AfResult = 0xc1a3
PTP_EC_Nikon_ObjectAddedInSDRAM = 0xC101
PTP_EC_Nikon_CaptureCompleteRecInSdram = 0xC102
PTP_EC_Nikon_AdvancedTransfer = 0xC103
PTP_EC_Nikon_PreviewImageAdded = 0xC104
PTP_EC_MTP_ObjectPropChanged = 0xC801
PTP_EC_MTP_ObjectPropDescChanged = 0xC802
PTP_EC_MTP_ObjectReferencesChanged = 0xC803
PTP_GOH_ALL_STORAGE = 0xffffffff
PTP_GOH_ALL_FORMATS = 0x00000000
PTP_GOH_ALL_ASSOCS = 0x00000000
PTP_GOH_ROOT_PARENT = 0xffffffff
PTP_HANDLER_SPECIAL = 0xffffffff
PTP_HANDLER_ROOT = 0x00000000
PTP_MAXSTRLEN = 255
PTP_OFC_Undefined = 0x3000
PTP_OFC_Defined = 0x3800
PTP_OFC_Association = 0x3001
PTP_OFC_Script = 0x3002
PTP_OFC_Executable = 0x3003
PTP_OFC_Text = 0x3004
PTP_OFC_HTML = 0x3005
PTP_OFC_DPOF = 0x3006
PTP_OFC_AIFF = 0x3007
PTP_OFC_WAV = 0x3008
PTP_OFC_MP3 = 0x3009
PTP_OFC_AVI = 0x300A
PTP_OFC_MPEG = 0x300B
PTP_OFC_ASF = 0x300C
PTP_OFC_QT = 0x300D # guessing */
PTP_OFC_EXIF_JPEG = 0x3801
PTP_OFC_TIFF_EP = 0x3802
PTP_OFC_FlashPix = 0x3803
PTP_OFC_BMP = 0x3804
PTP_OFC_CIFF = 0x3805
PTP_OFC_Undefined_0x3806 = 0x3806
PTP_OFC_GIF = 0x3807
PTP_OFC_JFIF = 0x3808
PTP_OFC_PCD = 0x3809
PTP_OFC_PICT = 0x380A
PTP_OFC_PNG = 0x380B
PTP_OFC_Undefined_0x380C = 0x380C
PTP_OFC_TIFF = 0x380D
PTP_OFC_TIFF_IT = 0x380E
PTP_OFC_JP2 = 0x380F
PTP_OFC_JPX = 0x3810
PTP_OFC_DNG = 0x3811
PTP_OFC_EK_M3U = 0xb002
PTP_OFC_CANON_CRW = 0xb101
PTP_OFC_CANON_CRW3 = 0xb103
PTP_OFC_CANON_MOV = 0xb104
PTP_OFC_CANON_CHDK_CRW = 0xb1ff
PTP_OFC_MTP_MediaCard = 0xb211
PTP_OFC_MTP_MediaCardGroup = 0xb212
PTP_OFC_MTP_Encounter = 0xb213
PTP_OFC_MTP_EncounterBox = 0xb214
PTP_OFC_MTP_M4A = 0xb215
PTP_OFC_MTP_ZUNEUNDEFINED = 0xb217 # Unknown file type */
PTP_OFC_MTP_Firmware = 0xb802
PTP_OFC_MTP_WindowsImageFormat = 0xb881
PTP_OFC_MTP_UndefinedAudio = 0xb900
PTP_OFC_MTP_WMA = 0xb901
PTP_OFC_MTP_OGG = 0xb902
PTP_OFC_MTP_AAC = 0xb903
PTP_OFC_MTP_AudibleCodec = 0xb904
PTP_OFC_MTP_FLAC = 0xb906
PTP_OFC_MTP_SamsungPlaylist = 0xb909
PTP_OFC_MTP_UndefinedVideo = 0xb980
PTP_OFC_MTP_WMV = 0xb981
PTP_OFC_MTP_MP4 = 0xb982
PTP_OFC_MTP_MP2 = 0xb983
PTP_OFC_MTP_3GP = 0xb984
PTP_OFC_MTP_UndefinedCollection = 0xba00
PTP_OFC_MTP_AbstractMultimediaAlbum = 0xba01
PTP_OFC_MTP_AbstractImageAlbum = 0xba02
PTP_OFC_MTP_AbstractAudioAlbum = 0xba03
PTP_OFC_MTP_AbstractVideoAlbum = 0xba04
PTP_OFC_MTP_AbstractAudioVideoPlaylist = 0xba05
PTP_OFC_MTP_AbstractContactGroup = 0xba06
PTP_OFC_MTP_AbstractMessageFolder = 0xba07
PTP_OFC_MTP_AbstractChapteredProduction = 0xba08
PTP_OFC_MTP_AbstractAudioPlaylist = 0xba09
PTP_OFC_MTP_AbstractVideoPlaylist = 0xba0a
PTP_OFC_MTP_AbstractMediacast = 0xba0b
PTP_OFC_MTP_WPLPlaylist = 0xba10
PTP_OFC_MTP_M3UPlaylist = 0xba11
PTP_OFC_MTP_MPLPlaylist = 0xba12
PTP_OFC_MTP_ASXPlaylist = 0xba13
PTP_OFC_MTP_PLSPlaylist = 0xba14
PTP_OFC_MTP_UndefinedDocument = 0xba80
PTP_OFC_MTP_AbstractDocument = 0xba81
PTP_OFC_MTP_XMLDocument = 0xba82
PTP_OFC_MTP_MSWordDocument = 0xba83
PTP_OFC_MTP_MHTCompiledHTMLDocument = 0xba84
PTP_OFC_MTP_MSExcelSpreadsheetXLS = 0xba85
PTP_OFC_MTP_MSPowerpointPresentationPPT = 0xba86
PTP_OFC_MTP_UndefinedMessage = 0xbb00
PTP_OFC_MTP_AbstractMessage = 0xbb01
PTP_OFC_MTP_UndefinedContact = 0xbb80
PTP_OFC_MTP_AbstractContact = 0xbb81
PTP_OFC_MTP_vCard2 = 0xbb82
PTP_OFC_MTP_vCard3 = 0xbb83
PTP_OFC_MTP_UndefinedCalendarItem = 0xbe00
PTP_OFC_MTP_AbstractCalendarItem = 0xbe01
PTP_OFC_MTP_vCalendar1 = 0xbe02
PTP_OFC_MTP_vCalendar2 = 0xbe03
PTP_OFC_MTP_UndefinedWindowsExecutable = 0xbe80
PTP_OFC_MTP_MediaCast = 0xbe81
PTP_OFC_MTP_Section = 0xbe82
PTP_AT_Undefined = 0x0000
PTP_AT_GenericFolder = 0x0001
PTP_AT_Album = 0x0002
PTP_AT_TimeSequence = 0x0003
PTP_AT_HorizontalPanoramic = 0x0004
PTP_AT_VerticalPanoramic = 0x0005
PTP_AT_2DPanoramic = 0x0006
PTP_AT_AncillaryData = 0x0007
PTP_PS_NoProtection = 0x0000
PTP_PS_ReadOnly = 0x0001
PTP_PS_MTP_ReadOnlyData = 0x8002
PTP_PS_MTP_NonTransferableData = 0x8003
PTP_ST_Undefined = 0x0000
PTP_ST_FixedROM = 0x0001
PTP_ST_RemovableROM = 0x0002
PTP_ST_FixedRAM = 0x0003
PTP_ST_RemovableRAM = 0x0004
PTP_FST_Undefined = 0x0000
PTP_FST_GenericFlat = 0x0001
PTP_FST_GenericHierarchical = 0x0002
PTP_FST_DCF = 0x0003
PTP_AC_ReadWrite = 0x0000
PTP_AC_ReadOnly = 0x0001
PTP_AC_ReadOnly_with_Object_Deletion = 0x0002
PTP_CANON_FilenameBufferLen = 13
PTP_CANON_FolderEntryLen = 28
PTP_NIKON_MaxCurvePoints = 19
PTP_CANON_EOS_CHANGES_TYPE_UNKNOWN = 0
PTP_CANON_EOS_CHANGES_TYPE_OBJECTINFO = 1
PTP_CANON_EOS_CHANGES_TYPE_OBJECTTRANSFER = 2
PTP_CANON_EOS_CHANGES_TYPE_PROPERTY = 3
PTP_CANON_EOS_CHANGES_TYPE_CAMERASTATUS = 4
PTP_DTC_UNDEF = 0x0000
PTP_DTC_INT8 = 0x0001
PTP_DTC_UINT8 = 0x0002
PTP_DTC_INT16 = 0x0003
PTP_DTC_UINT16 = 0x0004
PTP_DTC_INT32 = 0x0005
PTP_DTC_UINT32 = 0x0006
PTP_DTC_INT64 = 0x0007
PTP_DTC_UINT64 = 0x0008
PTP_DTC_INT128 = 0x0009
PTP_DTC_UINT128 = 0x000A
PTP_DTC_ARRAY_MASK = 0x4000
PTP_DTC_AINT8 = (PTP_DTC_ARRAY_MASK | PTP_DTC_INT8)
PTP_DTC_AUINT8 = (PTP_DTC_ARRAY_MASK | PTP_DTC_UINT8)
PTP_DTC_AINT16 = (PTP_DTC_ARRAY_MASK | PTP_DTC_INT16)
PTP_DTC_AUINT16 = (PTP_DTC_ARRAY_MASK | PTP_DTC_UINT16)
PTP_DTC_AINT32 = (PTP_DTC_ARRAY_MASK | PTP_DTC_INT32)
PTP_DTC_AUINT32 = (PTP_DTC_ARRAY_MASK | PTP_DTC_UINT32)
PTP_DTC_AINT64 = (PTP_DTC_ARRAY_MASK | PTP_DTC_INT64)
PTP_DTC_AUINT64 = (PTP_DTC_ARRAY_MASK | PTP_DTC_UINT64)
PTP_DTC_AINT128 = (PTP_DTC_ARRAY_MASK | PTP_DTC_INT128)
PTP_DTC_AUINT128 = (PTP_DTC_ARRAY_MASK | PTP_DTC_UINT128)
PTP_DTC_STR = 0xFFFF
PTP_DPC_Undefined = 0x5000
PTP_DPC_BatteryLevel = 0x5001
PTP_DPC_FunctionalMode = 0x5002
PTP_DPC_ImageSize = 0x5003
PTP_DPC_CompressionSetting = 0x5004
PTP_DPC_WhiteBalance = 0x5005
PTP_DPC_RGBGain = 0x5006
PTP_DPC_FNumber = 0x5007
PTP_DPC_FocalLength = 0x5008
PTP_DPC_FocusDistance = 0x5009
PTP_DPC_FocusMode = 0x500A
PTP_DPC_ExposureMeteringMode = 0x500B
PTP_DPC_FlashMode = 0x500C
PTP_DPC_ExposureTime = 0x500D
PTP_DPC_ExposureProgramMode = 0x500E
PTP_DPC_ExposureIndex = 0x500F
PTP_DPC_ExposureBiasCompensation = 0x5010
PTP_DPC_DateTime = 0x5011
PTP_DPC_CaptureDelay = 0x5012
PTP_DPC_StillCaptureMode = 0x5013
PTP_DPC_Contrast = 0x5014
PTP_DPC_Sharpness = 0x5015
PTP_DPC_DigitalZoom = 0x5016
PTP_DPC_EffectMode = 0x5017
PTP_DPC_BurstNumber = 0x5018
PTP_DPC_BurstInterval = 0x5019
PTP_DPC_TimelapseNumber = 0x501A
PTP_DPC_TimelapseInterval = 0x501B
PTP_DPC_FocusMeteringMode = 0x501C
PTP_DPC_UploadURL = 0x501D
PTP_DPC_Artist = 0x501E
PTP_DPC_CopyrightInfo = 0x501F
PTP_DPC_SupportedStreams = 0x5020
PTP_DPC_EnabledStreams = 0x5021
PTP_DPC_VideoFormat = 0x5022
PTP_DPC_VideoResolution = 0x5023
PTP_DPC_VideoQuality = 0x5024
PTP_DPC_VideoFrameRate = 0x5025
PTP_DPC_VideoContrast = 0x5026
PTP_DPC_VideoBrightness = 0x5027
PTP_DPC_AudioFormat = 0x5028
PTP_DPC_AudioBitrate = 0x5029
PTP_DPC_AudioSamplingRate = 0x502A
PTP_DPC_AudioBitPerSample = 0x502B
PTP_DPC_AudioVolume = 0x502C
PTP_DPC_EXTENSION_MASK = 0xF000
PTP_DPC_EXTENSION = 0xD000
PTP_DPC_MTP_ZUNE_UNKNOWN1 = 0xD181
PTP_DPC_MTP_ZUNE_UNKNOWN2 = 0xD132
PTP_DPC_MTP_ZUNE_UNKNOWN3 = 0xD215
PTP_DPC_MTP_ZUNE_UNKNOWN4 = 0xD216
PTP_DPC_EK_ColorTemperature = 0xD001
PTP_DPC_EK_DateTimeStampFormat = 0xD002
PTP_DPC_EK_BeepMode = 0xD003
PTP_DPC_EK_VideoOut = 0xD004
PTP_DPC_EK_PowerSaving = 0xD005
PTP_DPC_EK_UI_Language = 0xD006
PTP_DPC_CANON_BeepMode = 0xD001
PTP_DPC_CANON_BatteryKind = 0xD002
PTP_DPC_CANON_BatteryStatus = 0xD003
PTP_DPC_CANON_UILockType = 0xD004
PTP_DPC_CANON_CameraMode = 0xD005
PTP_DPC_CANON_ImageQuality = 0xD006
PTP_DPC_CANON_FullViewFileFormat = 0xD007
PTP_DPC_CANON_ImageSize = 0xD008
PTP_DPC_CANON_SelfTime = 0xD009
PTP_DPC_CANON_FlashMode = 0xD00A
PTP_DPC_CANON_Beep = 0xD00B
PTP_DPC_CANON_ShootingMode = 0xD00C
PTP_DPC_CANON_ImageMode = 0xD00D
PTP_DPC_CANON_DriveMode = 0xD00E
PTP_DPC_CANON_EZoom = 0xD00F
PTP_DPC_CANON_MeteringMode = 0xD010
PTP_DPC_CANON_AFDistance = 0xD011
PTP_DPC_CANON_FocusingPoint = 0xD012
PTP_DPC_CANON_WhiteBalance = 0xD013
PTP_DPC_CANON_SlowShutterSetting = 0xD014
PTP_DPC_CANON_AFMode = 0xD015
PTP_DPC_CANON_ImageStabilization = 0xD016
PTP_DPC_CANON_Contrast = 0xD017
PTP_DPC_CANON_ColorGain = 0xD018
PTP_DPC_CANON_Sharpness = 0xD019
PTP_DPC_CANON_Sensitivity = 0xD01A
PTP_DPC_CANON_ParameterSet = 0xD01B
PTP_DPC_CANON_ISOSpeed = 0xD01C
PTP_DPC_CANON_Aperture = 0xD01D
PTP_DPC_CANON_ShutterSpeed = 0xD01E
PTP_DPC_CANON_ExpCompensation = 0xD01F
PTP_DPC_CANON_FlashCompensation = 0xD020
PTP_DPC_CANON_AEBExposureCompensation = 0xD021
PTP_DPC_CANON_AvOpen = 0xD023
PTP_DPC_CANON_AvMax = 0xD024
PTP_DPC_CANON_FocalLength = 0xD025
PTP_DPC_CANON_FocalLengthTele = 0xD026
PTP_DPC_CANON_FocalLengthWide = 0xD027
PTP_DPC_CANON_FocalLengthDenominator = 0xD028
PTP_DPC_CANON_CaptureTransferMode = 0xD029
CANON_TRANSFER_ENTIRE_IMAGE_TO_PC = 0x0002
CANON_TRANSFER_SAVE_THUMBNAIL_TO_DEVICE = 0x0004
CANON_TRANSFER_SAVE_IMAGE_TO_DEVICE = 0x0008
CANON_TRANSFER_MEMORY = (2|1)
CANON_TRANSFER_CARD = (8|4|1)
PTP_DPC_CANON_Zoom = 0xD02A
PTP_DPC_CANON_NamePrefix = 0xD02B
PTP_DPC_CANON_SizeQualityMode = 0xD02C
PTP_DPC_CANON_SupportedThumbSize = 0xD02D
PTP_DPC_CANON_SizeOfOutputDataFromCamera = 0xD02E
PTP_DPC_CANON_SizeOfInputDataToCamera = 0xD02F
PTP_DPC_CANON_RemoteAPIVersion = 0xD030
PTP_DPC_CANON_FirmwareVersion = 0xD031
PTP_DPC_CANON_CameraModel = 0xD032
PTP_DPC_CANON_CameraOwner = 0xD033
PTP_DPC_CANON_UnixTime = 0xD034
PTP_DPC_CANON_CameraBodyID = 0xD035
PTP_DPC_CANON_CameraOutput = 0xD036
PTP_DPC_CANON_DispAv = 0xD037
PTP_DPC_CANON_AvOpenApex = 0xD038
PTP_DPC_CANON_DZoomMagnification = 0xD039
PTP_DPC_CANON_MlSpotPos = 0xD03A
PTP_DPC_CANON_DispAvMax = 0xD03B
PTP_DPC_CANON_AvMaxApex = 0xD03C
PTP_DPC_CANON_EZoomStartPosition = 0xD03D
PTP_DPC_CANON_FocalLengthOfTele = 0xD03E
PTP_DPC_CANON_EZoomSizeOfTele = 0xD03F
PTP_DPC_CANON_PhotoEffect = 0xD040
PTP_DPC_CANON_AssistLight = 0xD041
PTP_DPC_CANON_FlashQuantityCount = 0xD042
PTP_DPC_CANON_RotationAngle = 0xD043
PTP_DPC_CANON_RotationScene = 0xD044
PTP_DPC_CANON_EventEmulateMode = 0xD045
PTP_DPC_CANON_DPOFVersion = 0xD046
PTP_DPC_CANON_TypeOfSupportedSlideShow = 0xD047
PTP_DPC_CANON_AverageFilesizes = 0xD048
PTP_DPC_CANON_ModelID = 0xD049
PTP_DPC_CANON_EOS_Aperture = 0xD101
PTP_DPC_CANON_EOS_ShutterSpeed = 0xD102
PTP_DPC_CANON_EOS_ISOSpeed = 0xD103
PTP_DPC_CANON_EOS_ExpCompensation = 0xD104
PTP_DPC_CANON_EOS_AutoExposureMode = 0xD105
PTP_DPC_CANON_EOS_DriveMode = 0xD106
PTP_DPC_CANON_EOS_MeteringMode = 0xD107
PTP_DPC_CANON_EOS_FocusMode = 0xD108
PTP_DPC_CANON_EOS_WhiteBalance = 0xD109
PTP_DPC_CANON_EOS_ColorTemperature = 0xD10A
PTP_DPC_CANON_EOS_WhiteBalanceAdjustA = 0xD10B
PTP_DPC_CANON_EOS_WhiteBalanceAdjustB = 0xD10C
PTP_DPC_CANON_EOS_WhiteBalanceXA = 0xD10D
PTP_DPC_CANON_EOS_WhiteBalanceXB = 0xD10E
PTP_DPC_CANON_EOS_ColorSpace = 0xD10F
PTP_DPC_CANON_EOS_PictureStyle = 0xD110
PTP_DPC_CANON_EOS_BatteryPower = 0xD111
PTP_DPC_CANON_EOS_BatterySelect = 0xD112
PTP_DPC_CANON_EOS_CameraTime = 0xD113
PTP_DPC_CANON_EOS_Owner = 0xD115
PTP_DPC_CANON_EOS_ModelID = 0xD116
PTP_DPC_CANON_EOS_PTPExtensionVersion = 0xD119
PTP_DPC_CANON_EOS_DPOFVersion = 0xD11A
PTP_DPC_CANON_EOS_AvailableShots = 0xD11B
PTP_CANON_EOS_CAPTUREDEST_HD = 4
PTP_DPC_CANON_EOS_CaptureDestination = 0xD11C
PTP_DPC_CANON_EOS_BracketMode = 0xD11D
PTP_DPC_CANON_EOS_CurrentStorage = 0xD11E
PTP_DPC_CANON_EOS_CurrentFolder = 0xD11F
PTP_DPC_CANON_EOS_ImageFormat = 0xD120	# file setting */
PTP_DPC_CANON_EOS_ImageFormatCF = 0xD121	# file setting CF */
PTP_DPC_CANON_EOS_ImageFormatSD = 0xD122	# file setting SD */
PTP_DPC_CANON_EOS_ImageFormatExtHD = 0xD123	# file setting exthd */
PTP_DPC_CANON_EOS_CompressionS = 0xD130
PTP_DPC_CANON_EOS_CompressionM1 = 0xD131
PTP_DPC_CANON_EOS_CompressionM2 = 0xD132
PTP_DPC_CANON_EOS_CompressionL = 0xD133
PTP_DPC_CANON_EOS_PCWhiteBalance1 = 0xD140
PTP_DPC_CANON_EOS_PCWhiteBalance2 = 0xD141
PTP_DPC_CANON_EOS_PCWhiteBalance3 = 0xD142
PTP_DPC_CANON_EOS_PCWhiteBalance4 = 0xD143
PTP_DPC_CANON_EOS_PCWhiteBalance5 = 0xD144
PTP_DPC_CANON_EOS_MWhiteBalance = 0xD145
PTP_DPC_CANON_EOS_PictureStyleStandard = 0xD150
PTP_DPC_CANON_EOS_PictureStylePortrait = 0xD151
PTP_DPC_CANON_EOS_PictureStyleLandscape = 0xD152
PTP_DPC_CANON_EOS_PictureStyleNeutral = 0xD153
PTP_DPC_CANON_EOS_PictureStyleFaithful = 0xD154
PTP_DPC_CANON_EOS_PictureStyleBlackWhite = 0xD155
PTP_DPC_CANON_EOS_PictureStyleUserSet1 = 0xD160
PTP_DPC_CANON_EOS_PictureStyleUserSet2 = 0xD161
PTP_DPC_CANON_EOS_PictureStyleUserSet3 = 0xD162
PTP_DPC_CANON_EOS_PictureStyleParam1 = 0xD170
PTP_DPC_CANON_EOS_PictureStyleParam2 = 0xD171
PTP_DPC_CANON_EOS_PictureStyleParam3 = 0xD172
PTP_DPC_CANON_EOS_FlavorLUTParams = 0xD17f
PTP_DPC_CANON_EOS_CustomFunc1 = 0xD180
PTP_DPC_CANON_EOS_CustomFunc2 = 0xD181
PTP_DPC_CANON_EOS_CustomFunc3 = 0xD182
PTP_DPC_CANON_EOS_CustomFunc4 = 0xD183
PTP_DPC_CANON_EOS_CustomFunc5 = 0xD184
PTP_DPC_CANON_EOS_CustomFunc6 = 0xD185
PTP_DPC_CANON_EOS_CustomFunc7 = 0xD186
PTP_DPC_CANON_EOS_CustomFunc8 = 0xD187
PTP_DPC_CANON_EOS_CustomFunc9 = 0xD188
PTP_DPC_CANON_EOS_CustomFunc10 = 0xD189
PTP_DPC_CANON_EOS_CustomFunc11 = 0xD18a
PTP_DPC_CANON_EOS_CustomFunc12 = 0xD18b
PTP_DPC_CANON_EOS_CustomFunc13 = 0xD18c
PTP_DPC_CANON_EOS_CustomFunc14 = 0xD18d
PTP_DPC_CANON_EOS_CustomFunc15 = 0xD18e
PTP_DPC_CANON_EOS_CustomFunc16 = 0xD18f
PTP_DPC_CANON_EOS_CustomFunc17 = 0xD190
PTP_DPC_CANON_EOS_CustomFunc18 = 0xD191
PTP_DPC_CANON_EOS_CustomFunc19 = 0xD192
PTP_DPC_CANON_EOS_CustomFunc19 = 0xD192
PTP_DPC_CANON_EOS_CustomFuncEx = 0xD1a0
PTP_DPC_CANON_EOS_MyMenu = 0xD1a1
PTP_DPC_CANON_EOS_MyMenuList = 0xD1a2
PTP_DPC_CANON_EOS_WftStatus = 0xD1a3
PTP_DPC_CANON_EOS_WftInputTransmission = 0xD1a4
PTP_DPC_CANON_EOS_HDDirectoryStructure = 0xD1a5
PTP_DPC_CANON_EOS_BatteryInfo = 0xD1a6
PTP_DPC_CANON_EOS_AdapterInfo = 0xD1a7
PTP_DPC_CANON_EOS_LensStatus = 0xD1a8
PTP_DPC_CANON_EOS_QuickReviewTime = 0xD1a9
PTP_DPC_CANON_EOS_CardExtension = 0xD1aa
PTP_DPC_CANON_EOS_TempStatus = 0xD1ab
PTP_DPC_CANON_EOS_ShutterCounter = 0xD1ac
PTP_DPC_CANON_EOS_SpecialOption = 0xD1ad
PTP_DPC_CANON_EOS_PhotoStudioMode = 0xD1ae
PTP_DPC_CANON_EOS_SerialNumber = 0xD1af
PTP_DPC_CANON_EOS_EVFOutputDevice = 0xD1b0
PTP_DPC_CANON_EOS_EVFMode = 0xD1b1
PTP_DPC_CANON_EOS_DepthOfFieldPreview = 0xD1b2
PTP_DPC_CANON_EOS_EVFSharpness = 0xD1b3
PTP_DPC_CANON_EOS_EVFWBMode = 0xD1b4
PTP_DPC_CANON_EOS_EVFClickWBCoeffs = 0xD1b5
PTP_DPC_CANON_EOS_EVFColorTemp = 0xD1b6
PTP_DPC_CANON_EOS_ExposureSimMode = 0xD1b7
PTP_DPC_CANON_EOS_EVFRecordStatus = 0xD1b8
PTP_DPC_CANON_EOS_LvAfSystem = 0xD1ba
PTP_DPC_CANON_EOS_MovSize = 0xD1bb
PTP_DPC_CANON_EOS_LvViewTypeSelect = 0xD1bc
PTP_DPC_CANON_EOS_Artist = 0xD1d0
PTP_DPC_CANON_EOS_Copyright = 0xD1d1
PTP_DPC_CANON_EOS_BracketValue = 0xD1d2
PTP_DPC_CANON_EOS_FocusInfoEx = 0xD1d3
PTP_DPC_CANON_EOS_DepthOfField = 0xD1d4
PTP_DPC_CANON_EOS_Brightness = 0xD1d5
PTP_DPC_CANON_EOS_LensAdjustParams = 0xD1d6
PTP_DPC_CANON_EOS_EFComp = 0xD1d7
PTP_DPC_CANON_EOS_LensName = 0xD1d8
PTP_DPC_CANON_EOS_AEB = 0xD1d9
PTP_DPC_CANON_EOS_StroboSetting = 0xD1da
PTP_DPC_CANON_EOS_StroboWirelessSetting = 0xD1db
PTP_DPC_CANON_EOS_StroboFiring = 0xD1dc
PTP_DPC_CANON_EOS_LensID = 0xD1dd
PTP_DPC_NIKON_ShootingBank = 0xD010
PTP_DPC_NIKON_ShootingBankNameA = 0xD011
PTP_DPC_NIKON_ShootingBankNameB = 0xD012
PTP_DPC_NIKON_ShootingBankNameC = 0xD013
PTP_DPC_NIKON_ShootingBankNameD = 0xD014
PTP_DPC_NIKON_ResetBank0 = 0xD015
PTP_DPC_NIKON_RawCompression = 0xD016
PTP_DPC_NIKON_WhiteBalanceAutoBias = 0xD017
PTP_DPC_NIKON_WhiteBalanceTungstenBias = 0xD018
PTP_DPC_NIKON_WhiteBalanceFluorescentBias = 0xD019
PTP_DPC_NIKON_WhiteBalanceDaylightBias = 0xD01A
PTP_DPC_NIKON_WhiteBalanceFlashBias = 0xD01B
PTP_DPC_NIKON_WhiteBalanceCloudyBias = 0xD01C
PTP_DPC_NIKON_WhiteBalanceShadeBias = 0xD01D
PTP_DPC_NIKON_WhiteBalanceColorTemperature = 0xD01E
PTP_DPC_NIKON_WhiteBalancePresetNo = 0xD01F
PTP_DPC_NIKON_WhiteBalancePresetName0 = 0xD020
PTP_DPC_NIKON_WhiteBalancePresetName1 = 0xD021
PTP_DPC_NIKON_WhiteBalancePresetName2 = 0xD022
PTP_DPC_NIKON_WhiteBalancePresetName3 = 0xD023
PTP_DPC_NIKON_WhiteBalancePresetName4 = 0xD024
PTP_DPC_NIKON_WhiteBalancePresetVal0 = 0xD025
PTP_DPC_NIKON_WhiteBalancePresetVal1 = 0xD026
PTP_DPC_NIKON_WhiteBalancePresetVal2 = 0xD027
PTP_DPC_NIKON_WhiteBalancePresetVal3 = 0xD028
PTP_DPC_NIKON_WhiteBalancePresetVal4 = 0xD029
PTP_DPC_NIKON_ImageSharpening = 0xD02A
PTP_DPC_NIKON_ToneCompensation = 0xD02B
PTP_DPC_NIKON_ColorModel = 0xD02C
PTP_DPC_NIKON_HueAdjustment = 0xD02D
PTP_DPC_NIKON_NonCPULensDataFocalLength = 0xD02E	# Set FMM Manual */
PTP_DPC_NIKON_NonCPULensDataMaximumAperture = 0xD02F	# Set F0 Manual */
PTP_DPC_NIKON_ShootingMode = 0xD030
PTP_DPC_NIKON_JPEG_Compression_Policy = 0xD031
PTP_DPC_NIKON_ColorSpace = 0xD032
PTP_DPC_NIKON_AutoDXCrop = 0xD033
PTP_DPC_NIKON_CSMMenuBankSelect = 0xD040
PTP_DPC_NIKON_MenuBankNameA = 0xD041
PTP_DPC_NIKON_MenuBankNameB = 0xD042
PTP_DPC_NIKON_MenuBankNameC = 0xD043
PTP_DPC_NIKON_MenuBankNameD = 0xD044
PTP_DPC_NIKON_ResetBank = 0xD045
PTP_DPC_NIKON_A1AFCModePriority = 0xD048
PTP_DPC_NIKON_A2AFSModePriority = 0xD049
PTP_DPC_NIKON_A3GroupDynamicAF = 0xD04A
PTP_DPC_NIKON_A4AFActivation = 0xD04B
PTP_DPC_NIKON_FocusAreaIllumManualFocus = 0xD04C
PTP_DPC_NIKON_FocusAreaIllumContinuous = 0xD04D
PTP_DPC_NIKON_FocusAreaIllumWhenSelected = 0xD04E
PTP_DPC_NIKON_FocusAreaWrap = 0xD04F # area sel */
PTP_DPC_NIKON_VerticalAFON = 0xD050
PTP_DPC_NIKON_AFLockOn = 0xD051
PTP_DPC_NIKON_FocusAreaZone = 0xD052
PTP_DPC_NIKON_EnableCopyright = 0xD053
PTP_DPC_NIKON_ISOAuto = 0xD054
PTP_DPC_NIKON_EVISOStep = 0xD055
PTP_DPC_NIKON_EVStep = 0xD056 # EV Step SS FN */
PTP_DPC_NIKON_EVStepExposureComp = 0xD057
PTP_DPC_NIKON_ExposureCompensation = 0xD058
PTP_DPC_NIKON_CenterWeightArea = 0xD059
PTP_DPC_NIKON_ExposureBaseMatrix = 0xD05A
PTP_DPC_NIKON_ExposureBaseCenter = 0xD05B
PTP_DPC_NIKON_ExposureBaseSpot = 0xD05C
PTP_DPC_NIKON_LiveViewAF = 0xD05D
PTP_DPC_NIKON_AELockMode = 0xD05E
PTP_DPC_NIKON_AELAFLMode = 0xD05F
PTP_DPC_NIKON_MeterOff = 0xD062
PTP_DPC_NIKON_SelfTimer = 0xD063
PTP_DPC_NIKON_MonitorOff = 0xD064
PTP_DPC_NIKON_ImgConfTime = 0xD065
PTP_DPC_NIKON_AngleLevel = 0xD067
PTP_DPC_NIKON_D1ShootingSpeed = 0xD068 # continous speed low */
PTP_DPC_NIKON_D2MaximumShots = 0xD069
PTP_DPC_NIKON_ExposureDelayMode = 0xD06A
PTP_DPC_NIKON_LongExposureNoiseReduction = 0xD06B
PTP_DPC_NIKON_FileNumberSequence = 0xD06C
PTP_DPC_NIKON_ControlPanelFinderRearControl = 0xD06D
PTP_DPC_NIKON_ControlPanelFinderViewfinder = 0xD06E
PTP_DPC_NIKON_D7Illumination = 0xD06F
PTP_DPC_NIKON_NrHighISO = 0xD070
PTP_DPC_NIKON_SHSET_CH_GUID_DISP = 0xD071
PTP_DPC_NIKON_ArtistName = 0xD072
PTP_DPC_NIKON_CopyrightInfo = 0xD073
PTP_DPC_NIKON_FlashSyncSpeed = 0xD074
PTP_DPC_NIKON_FlashShutterSpeed = 0xD075	# SB Low Limit */
PTP_DPC_NIKON_E3AAFlashMode = 0xD076
PTP_DPC_NIKON_E4ModelingFlash = 0xD077
PTP_DPC_NIKON_BracketSet = 0xD078	# Bracket Type? */
PTP_DPC_NIKON_E6ManualModeBracketing = 0xD079	# Bracket Factor? */
PTP_DPC_NIKON_BracketOrder = 0xD07A
PTP_DPC_NIKON_E8AutoBracketSelection = 0xD07B	# Bracket Method? */
PTP_DPC_NIKON_BracketingSet = 0xD07C
PTP_DPC_NIKON_F1CenterButtonShootingMode = 0xD080
PTP_DPC_NIKON_CenterButtonPlaybackMode = 0xD081
PTP_DPC_NIKON_F2Multiselector = 0xD082
PTP_DPC_NIKON_F3PhotoInfoPlayback = 0xD083	# MultiSelector Dir */
PTP_DPC_NIKON_F4AssignFuncButton = 0xD084  # CMD Dial Rotate */
PTP_DPC_NIKON_F5CustomizeCommDials = 0xD085  # CMD Dial Change */
PTP_DPC_NIKON_ReverseCommandDial = 0xD086  # CMD Dial FN Set */
PTP_DPC_NIKON_ApertureSetting = 0xD087  # CMD Dial Active */
PTP_DPC_NIKON_MenusAndPlayback = 0xD088  # CMD Dial Active */
PTP_DPC_NIKON_F6ButtonsAndDials = 0xD089  # Universal Mode? */
PTP_DPC_NIKON_NoCFCard = 0xD08A	# Enable Shutter? */
PTP_DPC_NIKON_CenterButtonZoomRatio = 0xD08B
PTP_DPC_NIKON_FunctionButton2 = 0xD08C
PTP_DPC_NIKON_AFAreaPoint = 0xD08D
PTP_DPC_NIKON_NormalAFOn = 0xD08E
PTP_DPC_NIKON_ImageCommentString = 0xD090
PTP_DPC_NIKON_ImageCommentEnable = 0xD091
PTP_DPC_NIKON_ImageRotation = 0xD092
PTP_DPC_NIKON_ManualSetLensNo = 0xD093
PTP_DPC_NIKON_MovScreenSize = 0xD0A0
PTP_DPC_NIKON_MovVoice = 0xD0A1
PTP_DPC_NIKON_Bracketing = 0xD0C0
PTP_DPC_NIKON_AutoExposureBracketStep = 0xD0C1
PTP_DPC_NIKON_AutoExposureBracketProgram = 0xD0C2
PTP_DPC_NIKON_AutoExposureBracketCount = 0xD0C3
PTP_DPC_NIKON_WhiteBalanceBracketStep = 0xD0C4
PTP_DPC_NIKON_WhiteBalanceBracketProgram = 0xD0C5
PTP_DPC_NIKON_LensID = 0xD0E0
PTP_DPC_NIKON_LensSort = 0xD0E1
PTP_DPC_NIKON_LensType = 0xD0E2
PTP_DPC_NIKON_FocalLengthMin = 0xD0E3
PTP_DPC_NIKON_FocalLengthMax = 0xD0E4
PTP_DPC_NIKON_MaxApAtMinFocalLength = 0xD0E5
PTP_DPC_NIKON_MaxApAtMaxFocalLength = 0xD0E6
PTP_DPC_NIKON_FinderISODisp = 0xD0F0
PTP_DPC_NIKON_AutoOffPhoto = 0xD0F2
PTP_DPC_NIKON_AutoOffMenu = 0xD0F3
PTP_DPC_NIKON_AutoOffInfo = 0xD0F4
PTP_DPC_NIKON_SelfTimerShootNum = 0xD0F5
PTP_DPC_NIKON_VignetteCtrl = 0xD0F7
PTP_DPC_NIKON_ExposureTime = 0xD100	# Shutter Speed */
PTP_DPC_NIKON_ACPower = 0xD101
PTP_DPC_NIKON_WarningStatus = 0xD102
PTP_DPC_NIKON_MaximumShots = 0xD103 # remain shots (in RAM buffer?) */
PTP_DPC_NIKON_AFLockStatus = 0xD104
PTP_DPC_NIKON_AELockStatus = 0xD105
PTP_DPC_NIKON_FVLockStatus = 0xD106
PTP_DPC_NIKON_AutofocusLCDTopMode2 = 0xD107
PTP_DPC_NIKON_AutofocusArea = 0xD108
PTP_DPC_NIKON_FlexibleProgram = 0xD109
PTP_DPC_NIKON_LightMeter = 0xD10A	# Exposure Status */
PTP_DPC_NIKON_RecordingMedia = 0xD10B	# Card or SDRAM */
PTP_DPC_NIKON_USBSpeed = 0xD10C
PTP_DPC_NIKON_CCDNumber = 0xD10D
PTP_DPC_NIKON_CameraOrientation = 0xD10E
PTP_DPC_NIKON_GroupPtnType = 0xD10F
PTP_DPC_NIKON_FNumberLock = 0xD110
PTP_DPC_NIKON_ExposureApertureLock = 0xD111	# shutterspeed lock*/
PTP_DPC_NIKON_TVLockSetting = 0xD112
PTP_DPC_NIKON_AVLockSetting = 0xD113
PTP_DPC_NIKON_IllumSetting = 0xD114
PTP_DPC_NIKON_FocusPointBright = 0xD115
PTP_DPC_NIKON_ExternalFlashAttached = 0xD120
PTP_DPC_NIKON_ExternalFlashStatus = 0xD121
PTP_DPC_NIKON_ExternalFlashSort = 0xD122
PTP_DPC_NIKON_ExternalFlashMode = 0xD123
PTP_DPC_NIKON_ExternalFlashCompensation = 0xD124
PTP_DPC_NIKON_NewExternalFlashMode = 0xD125
PTP_DPC_NIKON_FlashExposureCompensation = 0xD126
PTP_DPC_NIKON_OptimizeImage = 0xD140
PTP_DPC_NIKON_Saturation = 0xD142
PTP_DPC_NIKON_BW_FillerEffect = 0xD143
PTP_DPC_NIKON_BW_Sharpness = 0xD144
PTP_DPC_NIKON_BW_Contrast = 0xD145
PTP_DPC_NIKON_BW_Setting_Type = 0xD146
PTP_DPC_NIKON_Slot2SaveMode = 0xD148
PTP_DPC_NIKON_RawBitMode = 0xD149
PTP_DPC_NIKON_ISOAutoTime = 0xD14E
PTP_DPC_NIKON_FlourescentType = 0xD14F
PTP_DPC_NIKON_TuneColourTemperature = 0xD150
PTP_DPC_NIKON_TunePreset0 = 0xD151
PTP_DPC_NIKON_TunePreset1 = 0xD152
PTP_DPC_NIKON_TunePreset2 = 0xD153
PTP_DPC_NIKON_TunePreset3 = 0xD154
PTP_DPC_NIKON_TunePreset4 = 0xD155
PTP_DPC_NIKON_BeepOff = 0xD160
PTP_DPC_NIKON_AutofocusMode = 0xD161
PTP_DPC_NIKON_AFAssist = 0xD163
PTP_DPC_NIKON_PADVPMode = 0xD164	# iso auto time */
PTP_DPC_NIKON_ImageReview = 0xD165
PTP_DPC_NIKON_AFAreaIllumination = 0xD166
PTP_DPC_NIKON_FlashMode = 0xD167
PTP_DPC_NIKON_FlashCommanderMode = 0xD168
PTP_DPC_NIKON_FlashSign = 0xD169
PTP_DPC_NIKON_ISO_Auto = 0xD16A
PTP_DPC_NIKON_RemoteTimeout = 0xD16B
PTP_DPC_NIKON_GridDisplay = 0xD16C
PTP_DPC_NIKON_FlashModeManualPower = 0xD16D
PTP_DPC_NIKON_FlashModeCommanderPower = 0xD16E
PTP_DPC_NIKON_AutoFP = 0xD16F
PTP_DPC_NIKON_CSMMenu = 0xD180
PTP_DPC_NIKON_WarningDisplay = 0xD181
PTP_DPC_NIKON_BatteryCellKind = 0xD182
PTP_DPC_NIKON_ISOAutoHiLimit = 0xD183
PTP_DPC_NIKON_DynamicAFArea = 0xD184
PTP_DPC_NIKON_ContinuousSpeedHigh = 0xD186
PTP_DPC_NIKON_InfoDispSetting = 0xD187
PTP_DPC_NIKON_PreviewButton = 0xD189
PTP_DPC_NIKON_PreviewButton2 = 0xD18A
PTP_DPC_NIKON_AEAFLockButton2 = 0xD18B
PTP_DPC_NIKON_IndicatorDisp = 0xD18D
PTP_DPC_NIKON_CellKindPriority = 0xD18E
PTP_DPC_NIKON_BracketingFramesAndSteps = 0xD190
PTP_DPC_NIKON_LiveViewMode = 0xD1A0
PTP_DPC_NIKON_LiveViewDriveMode = 0xD1A1
PTP_DPC_NIKON_LiveViewStatus = 0xD1A2
PTP_DPC_NIKON_LiveViewImageZoomRatio = 0xD1A3
PTP_DPC_NIKON_LiveViewProhibitCondition = 0xD1A4
PTP_DPC_NIKON_ExposureDisplayStatus = 0xD1B0
PTP_DPC_NIKON_ExposureIndicateStatus = 0xD1B1
PTP_DPC_NIKON_InfoDispErrStatus = 0xD1B2
PTP_DPC_NIKON_ExposureIndicateLightup = 0xD1B3
PTP_DPC_NIKON_FlashOpen = 0xD1C0
PTP_DPC_NIKON_FlashCharged = 0xD1C1
PTP_DPC_NIKON_FlashMRepeatValue = 0xD1D0
PTP_DPC_NIKON_FlashMRepeatCount = 0xD1D1
PTP_DPC_NIKON_FlashMRepeatInterval = 0xD1D2
PTP_DPC_NIKON_FlashCommandChannel = 0xD1D3
PTP_DPC_NIKON_FlashCommandSelfMode = 0xD1D4
PTP_DPC_NIKON_FlashCommandSelfCompensation = 0xD1D5
PTP_DPC_NIKON_FlashCommandSelfValue = 0xD1D6
PTP_DPC_NIKON_FlashCommandAMode = 0xD1D7
PTP_DPC_NIKON_FlashCommandACompensation = 0xD1D8
PTP_DPC_NIKON_FlashCommandAValue = 0xD1D9
PTP_DPC_NIKON_FlashCommandBMode = 0xD1DA
PTP_DPC_NIKON_FlashCommandBCompensation = 0xD1DB
PTP_DPC_NIKON_FlashCommandBValue = 0xD1DC
PTP_DPC_NIKON_ActivePicCtrlItem = 0xD200
PTP_DPC_NIKON_ChangePicCtrlItem = 0xD201
PTP_DPC_FUJI_ColorTemperature = 0xD017
PTP_DPC_FUJI_Quality = 0xD018
PTP_DPC_FUJI_ReleaseMode = 0xD201
PTP_DPC_FUJI_FocusAreas = 0xD206
PTP_DPC_FUJI_AELock = 0xD213
PTP_DPC_FUJI_Aperture = 0xD218
PTP_DPC_FUJI_ShutterSpeed = 0xD219
PTP_DPC_MTP_SecureTime = 0xD101
PTP_DPC_MTP_DeviceCertificate = 0xD102
PTP_DPC_MTP_RevocationInfo = 0xD103
PTP_DPC_MTP_SynchronizationPartner = 0xD401
PTP_DPC_MTP_DeviceFriendlyName = 0xD402
PTP_DPC_MTP_VolumeLevel = 0xD403
PTP_DPC_MTP_DeviceIcon = 0xD405
PTP_DPC_MTP_SessionInitiatorInfo = 0xD406
PTP_DPC_MTP_PerceivedDeviceType = 0xD407
PTP_DPC_MTP_PlaybackRate = 0xD410
PTP_DPC_MTP_PlaybackObject = 0xD411
PTP_DPC_MTP_PlaybackContainerIndex = 0xD412
PTP_DPC_MTP_PlaybackPosition = 0xD413
PTP_DPC_MTP_PlaysForSureID = 0xD131
PTP_DPC_MTP_Zune_UnknownVersion = 0xD181
PTP_OPC_StorageID = 0xDC01
PTP_OPC_ObjectFormat = 0xDC02
PTP_OPC_ProtectionStatus = 0xDC03
PTP_OPC_ObjectSize = 0xDC04
PTP_OPC_AssociationType = 0xDC05
PTP_OPC_AssociationDesc = 0xDC06
PTP_OPC_ObjectFileName = 0xDC07
PTP_OPC_DateCreated = 0xDC08
PTP_OPC_DateModified = 0xDC09
PTP_OPC_Keywords = 0xDC0A
PTP_OPC_ParentObject = 0xDC0B
PTP_OPC_AllowedFolderContents = 0xDC0C
PTP_OPC_Hidden = 0xDC0D
PTP_OPC_SystemObject = 0xDC0E
PTP_OPC_PersistantUniqueObjectIdentifier = 0xDC41
PTP_OPC_SyncID = 0xDC42
PTP_OPC_PropertyBag = 0xDC43
PTP_OPC_Name = 0xDC44
PTP_OPC_CreatedBy = 0xDC45
PTP_OPC_Artist = 0xDC46
PTP_OPC_DateAuthored = 0xDC47
PTP_OPC_Description = 0xDC48
PTP_OPC_URLReference = 0xDC49
PTP_OPC_LanguageLocale = 0xDC4A
PTP_OPC_CopyrightInformation = 0xDC4B
PTP_OPC_Source = 0xDC4C
PTP_OPC_OriginLocation = 0xDC4D
PTP_OPC_DateAdded = 0xDC4E
PTP_OPC_NonConsumable = 0xDC4F
PTP_OPC_CorruptOrUnplayable = 0xDC50
PTP_OPC_ProducerSerialNumber = 0xDC51
PTP_OPC_RepresentativeSampleFormat = 0xDC81
PTP_OPC_RepresentativeSampleSize = 0xDC82
PTP_OPC_RepresentativeSampleHeight = 0xDC83
PTP_OPC_RepresentativeSampleWidth = 0xDC84
PTP_OPC_RepresentativeSampleDuration = 0xDC85
PTP_OPC_RepresentativeSampleData = 0xDC86
PTP_OPC_Width = 0xDC87
PTP_OPC_Height = 0xDC88
PTP_OPC_Duration = 0xDC89
PTP_OPC_Rating = 0xDC8A
PTP_OPC_Track = 0xDC8B
PTP_OPC_Genre = 0xDC8C
PTP_OPC_Credits = 0xDC8D
PTP_OPC_Lyrics = 0xDC8E
PTP_OPC_SubscriptionContentID = 0xDC8F
PTP_OPC_ProducedBy = 0xDC90
PTP_OPC_UseCount = 0xDC91
PTP_OPC_SkipCount = 0xDC92
PTP_OPC_LastAccessed = 0xDC93
PTP_OPC_ParentalRating = 0xDC94
PTP_OPC_MetaGenre = 0xDC95
PTP_OPC_Composer = 0xDC96
PTP_OPC_EffectiveRating = 0xDC97
PTP_OPC_Subtitle = 0xDC98
PTP_OPC_OriginalReleaseDate = 0xDC99
PTP_OPC_AlbumName = 0xDC9A
PTP_OPC_AlbumArtist = 0xDC9B
PTP_OPC_Mood = 0xDC9C
PTP_OPC_DRMStatus = 0xDC9D
PTP_OPC_SubDescription = 0xDC9E
PTP_OPC_IsCropped = 0xDCD1
PTP_OPC_IsColorCorrected = 0xDCD2
PTP_OPC_ImageBitDepth = 0xDCD3
PTP_OPC_Fnumber = 0xDCD4
PTP_OPC_ExposureTime = 0xDCD5
PTP_OPC_ExposureIndex = 0xDCD6
PTP_OPC_DisplayName = 0xDCE0
PTP_OPC_BodyText = 0xDCE1
PTP_OPC_Subject = 0xDCE2
PTP_OPC_Priority = 0xDCE3
PTP_OPC_GivenName = 0xDD00
PTP_OPC_MiddleNames = 0xDD01
PTP_OPC_FamilyName = 0xDD02
PTP_OPC_Prefix = 0xDD03
PTP_OPC_Suffix = 0xDD04
PTP_OPC_PhoneticGivenName = 0xDD05
PTP_OPC_PhoneticFamilyName = 0xDD06
PTP_OPC_EmailPrimary = 0xDD07
PTP_OPC_EmailPersonal1 = 0xDD08
PTP_OPC_EmailPersonal2 = 0xDD09
PTP_OPC_EmailBusiness1 = 0xDD0A
PTP_OPC_EmailBusiness2 = 0xDD0B
PTP_OPC_EmailOthers = 0xDD0C
PTP_OPC_PhoneNumberPrimary = 0xDD0D
PTP_OPC_PhoneNumberPersonal = 0xDD0E
PTP_OPC_PhoneNumberPersonal2 = 0xDD0F
PTP_OPC_PhoneNumberBusiness = 0xDD10
PTP_OPC_PhoneNumberBusiness2 = 0xDD11
PTP_OPC_PhoneNumberMobile = 0xDD12
PTP_OPC_PhoneNumberMobile2 = 0xDD13
PTP_OPC_FaxNumberPrimary = 0xDD14
PTP_OPC_FaxNumberPersonal = 0xDD15
PTP_OPC_FaxNumberBusiness = 0xDD16
PTP_OPC_PagerNumber = 0xDD17
PTP_OPC_PhoneNumberOthers = 0xDD18
PTP_OPC_PrimaryWebAddress = 0xDD19
PTP_OPC_PersonalWebAddress = 0xDD1A
PTP_OPC_BusinessWebAddress = 0xDD1B
PTP_OPC_InstantMessengerAddress = 0xDD1C
PTP_OPC_InstantMessengerAddress2 = 0xDD1D
PTP_OPC_InstantMessengerAddress3 = 0xDD1E
PTP_OPC_PostalAddressPersonalFull = 0xDD1F
PTP_OPC_PostalAddressPersonalFullLine1 = 0xDD20
PTP_OPC_PostalAddressPersonalFullLine2 = 0xDD21
PTP_OPC_PostalAddressPersonalFullCity = 0xDD22
PTP_OPC_PostalAddressPersonalFullRegion = 0xDD23
PTP_OPC_PostalAddressPersonalFullPostalCode = 0xDD24
PTP_OPC_PostalAddressPersonalFullCountry = 0xDD25
PTP_OPC_PostalAddressBusinessFull = 0xDD26
PTP_OPC_PostalAddressBusinessLine1 = 0xDD27
PTP_OPC_PostalAddressBusinessLine2 = 0xDD28
PTP_OPC_PostalAddressBusinessCity = 0xDD29
PTP_OPC_PostalAddressBusinessRegion = 0xDD2A
PTP_OPC_PostalAddressBusinessPostalCode = 0xDD2B
PTP_OPC_PostalAddressBusinessCountry = 0xDD2C
PTP_OPC_PostalAddressOtherFull = 0xDD2D
PTP_OPC_PostalAddressOtherLine1 = 0xDD2E
PTP_OPC_PostalAddressOtherLine2 = 0xDD2F
PTP_OPC_PostalAddressOtherCity = 0xDD30
PTP_OPC_PostalAddressOtherRegion = 0xDD31
PTP_OPC_PostalAddressOtherPostalCode = 0xDD32
PTP_OPC_PostalAddressOtherCountry = 0xDD33
PTP_OPC_OrganizationName = 0xDD34
PTP_OPC_PhoneticOrganizationName = 0xDD35
PTP_OPC_Role = 0xDD36
PTP_OPC_Birthdate = 0xDD37
PTP_OPC_MessageTo = 0xDD40
PTP_OPC_MessageCC = 0xDD41
PTP_OPC_MessageBCC = 0xDD42
PTP_OPC_MessageRead = 0xDD43
PTP_OPC_MessageReceivedTime = 0xDD44
PTP_OPC_MessageSender = 0xDD45
PTP_OPC_ActivityBeginTime = 0xDD50
PTP_OPC_ActivityEndTime = 0xDD51
PTP_OPC_ActivityLocation = 0xDD52
PTP_OPC_ActivityRequiredAttendees = 0xDD54
PTP_OPC_ActivityOptionalAttendees = 0xDD55
PTP_OPC_ActivityResources = 0xDD56
PTP_OPC_ActivityAccepted = 0xDD57
PTP_OPC_Owner = 0xDD5D
PTP_OPC_Editor = 0xDD5E
PTP_OPC_Webmaster = 0xDD5F
PTP_OPC_URLSource = 0xDD60
PTP_OPC_URLDestination = 0xDD61
PTP_OPC_TimeBookmark = 0xDD62
PTP_OPC_ObjectBookmark = 0xDD63
PTP_OPC_ByteBookmark = 0xDD64
PTP_OPC_LastBuildDate = 0xDD70
PTP_OPC_TimetoLive = 0xDD71
PTP_OPC_MediaGUID = 0xDD72
PTP_OPC_TotalBitRate = 0xDE91
PTP_OPC_BitRateType = 0xDE92
PTP_OPC_SampleRate = 0xDE93
PTP_OPC_NumberOfChannels = 0xDE94
PTP_OPC_AudioBitDepth = 0xDE95
PTP_OPC_ScanDepth = 0xDE97
PTP_OPC_AudioWAVECodec = 0xDE99
PTP_OPC_AudioBitRate = 0xDE9A
PTP_OPC_VideoFourCCCodec = 0xDE9B
PTP_OPC_VideoBitRate = 0xDE9C
PTP_OPC_FramesPerThousandSeconds = 0xDE9D
PTP_OPC_KeyFrameDistance = 0xDE9E
PTP_OPC_BufferSize = 0xDE9F
PTP_OPC_EncodingQuality = 0xDEA0
PTP_OPC_EncodingProfile = 0xDEA1
PTP_OPC_BuyFlag = 0xD901
PTP_OPC_WirelessConfigurationFile = 0xB104
PTP_DPFF_None = 0x00
PTP_DPFF_Range = 0x01
PTP_DPFF_Enumeration = 0x02
PTP_OPFF_None = 0x00
PTP_OPFF_Range = 0x01
PTP_OPFF_Enumeration = 0x02
PTP_OPFF_DateTime = 0x03
PTP_OPFF_FixedLengthArray = 0x04
PTP_OPFF_RegularExpression = 0x05
PTP_OPFF_ByteArray = 0x06
PTP_OPFF_LongString = 0xFF
PTP_DPGS_Get = 0x00
PTP_DPGS_GetSet = 0x01
PTPOBJECT_OBJECTINFO_LOADED = (1<<0)
PTPOBJECT_CANONFLAGS_LOADED = (1<<1)
PTPOBJECT_MTPPROPLIST_LOADED = (1<<2)
PTPOBJECT_DIRECTORY_LOADED = (1<<3)
PTPOBJECT_PARENTOBJECT_LOADED = (1<<4)
PTPOBJECT_STORAGEID_LOADED = (1<<5)
PTP_CANON_RESET_AE = 0x1
PTP_CANON_RESET_AF = 0x2
PTP_CANON_RESET_AWB = 0x4
