divert(-1)
#
#                             COPYRIGHT
# 
#   PCB, interactive printed circuit board design
#   Copyright (C) 1994,1995,1996 Thomas Nau
# 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#   Contact addresses for paper mail and Email:
#   Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
#   Thomas.Nau@rz.uni-ulm.de
# 
#   RCS: $Id$
#
define(`Description_7400_dil', ``4 dual-NAND'')
define(`Param1_7400_dil', 14)
define(`Param2_7400_dil', 300)
define(`PinList_7400_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3B',`3A',`4Y',`4B',`4A',`Vcc'')

define(`Description_7401_dil', ``4 dual-NAND OC'')
define(`Param1_7401_dil', 14)
define(`Param2_7401_dil', 300)
define(`PinList_7401_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_7402_dil', ``4 dual-NOR'')
define(`Param1_7402_dil', 14)
define(`Param2_7402_dil', 300)
define(`PinList_7402_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_7403_dil', ``4 dual-NAND OC'')
define(`Param1_7403_dil', 14)
define(`Param2_7403_dil', 300)
define(`PinList_7403_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7404_dil', ``6 inverters'')
define(`Param1_7404_dil', 14)
define(`Param2_7404_dil', 300)
define(`PinList_7404_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7405_dil', ``6 inverters OC'')
define(`Param1_7405_dil', 14)
define(`Param2_7405_dil', 300)
define(`PinList_7405_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7406_dil', ``6 inverters OC high-voltage'')
define(`Param1_7406_dil', 14)
define(`Param2_7406_dil', 300)
define(`PinList_7406_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7407_dil', ``6 buffers OC'')
define(`Param1_7407_dil', 14)
define(`Param2_7407_dil', 300)
define(`PinList_7407_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7408_dil', ``4 dual-AND'')
define(`Param1_7408_dil', 14)
define(`Param2_7408_dil', 300)
define(`PinList_7408_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7409_dil', ``4 dual-AND OC'')
define(`Param1_7409_dil', 14)
define(`Param2_7409_dil', 300)
define(`PinList_7409_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7410_dil', ``3 triple-NAND'')
define(`Param1_7410_dil', 14)
define(`Param2_7410_dil', 300)
define(`PinList_7410_dil', ``A1',`B1',`A2',`B2',`C2',`Y2',`Gnd',`Y3',`A3',`B3',`C3',`Y1',`C1',`Vcc'')

define(`Description_7411_dil', ``3 triple-AND'')
define(`Param1_7411_dil', 14)
define(`Param2_7411_dil', 300)
define(`PinList_7411_dil', ``A1',`B1',`A2',`B2',`C2',`Y2',`Gnd',`Y3',`A3',`B3',`C3',`Y1',`C1',`Vcc'')

define(`Description_7412_dil', ``3 triple-NAND OC'')
define(`Param1_7412_dil', 14)
define(`Param2_7412_dil', 300)
define(`PinList_7412_dil', ``A1',`B1',`A2',`B2',`C2',`Y2',`Gnd',`Y3',`A3',`B3',`C3',`Y1',`C1',`Vcc'')

define(`Description_7413_dil', ``2 quad-input NAND Schmitt trigger'')
define(`Param1_7413_dil', 14)
define(`Param2_7413_dil', 300)
define(`PinList_7413_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7414_dil', ``6 Schmitt trigger inverter'')
define(`Param1_7414_dil', 14)
define(`Param2_7414_dil', 300)
define(`PinList_7414_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7415_dil', ``3 triple-AND OC'')
define(`Param1_7415_dil', 14)
define(`Param2_7415_dil', 300)
define(`PinList_7415_dil', ``A1',`B1',`A2',`B2',`C2',`Y2',`Gnd',`Y3',`A3',`B3',`C3',`Y1',`C1',`Vcc'')

define(`Description_7416_dil', ``6 inverters OC high-voltage'')
define(`Param1_7416_dil', 14)
define(`Param2_7416_dil', 300)
define(`PinList_7416_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7418_dil', ``2 quad-NAND Schmitt trigger'')
define(`Param1_7418_dil', 14)
define(`Param2_7418_dil', 300)
define(`PinList_7418_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7419_dil', ``6 inverter Schmitt trigger'')
define(`Param1_7419_dil', 14)
define(`Param2_7419_dil', 300)
define(`PinList_7419_dil', ``1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7420_dil', ``2 quad-NAND'')
define(`Param1_7420_dil', 14)
define(`Param2_7420_dil', 300)
define(`PinList_7420_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7421_dil', ``2 quad-AND'')
define(`Param1_7421_dil', 14)
define(`Param2_7421_dil', 300)
define(`PinList_7421_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7422_dil', ``2 quad-NAND OC'')
define(`Param1_7422_dil', 14)
define(`Param2_7422_dil', 300)
define(`PinList_7422_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7423_dil', ``2 quad-NOR with strobe'')
define(`Param1_7423_dil', 16)
define(`Param2_7423_dil', 300)
define(`PinList_7423_dil', ``1X',`1A',`1B',`1G',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`2G',`2C',`2D',`/X',`Vcc'')

define(`Description_7424_dil', ``4 dual-NAND Schmitt trigger'')
define(`Param1_7424_dil', 14)
define(`Param2_7424_dil', 300)
define(`PinList_7424_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7425_dil', ``2 quad-NOR w. strobe'')
define(`Param1_7425_dil', 14)
define(`Param2_7425_dil', 300)
define(`PinList_7425_dil', ``1A',`1B',`1G',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`2G',`2C',`2D',`Vcc'')

define(`Description_7426_dil', ``4 dual NAND high-voltage'')
define(`Param1_7426_dil', 14)
define(`Param2_7426_dil', 300)
define(`PinList_7426_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7427_dil', ``3 triple-NOR'')
define(`Param1_7427_dil', 14)
define(`Param2_7427_dil', 300)
define(`PinList_7427_dil', ``1A',`1B',`2A',`2B',`2C',`2Y',`Gnd',`3Y',`3A',`3B',`3C',`1Y',`1C',`Vcc'')

define(`Description_7428_dil', ``4 dual-NOR buffer'')
define(`Param1_7428_dil', 14)
define(`Param2_7428_dil', 300)
define(`PinList_7428_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_7430_dil', ``octal-NAND'')
define(`Param1_7430_dil', 14)
define(`Param2_7430_dil', 300)
define(`PinList_7430_dil', ``A',`B',`C',`D',`E',`F',`Gnd',`Y',`NC',`NC',`G',`H',`NC',`Vcc'')

define(`Description_7431_dil', ``delay elements'')
define(`Param1_7431_dil', 16)
define(`Param2_7431_dil', 300)
define(`PinList_7431_dil', ``1A',`1Y',`2A',`2Y',`3A',`3B',`3Y',`Gnd',`4Y',`4A',`4B',`5Y',`5A',`6Y',`6A',`Vcc'')

define(`Description_7432_dil', ``4 dual-OR'')
define(`Param1_7432_dil', 14)
define(`Param2_7432_dil', 300)
define(`PinList_7432_dil', ``A1',`B1',`Y1',`A2',`B2',`Y2',`Gnd',`Y3',`A3',`B3',`Y4',`A4',`B4',`Vcc'')

define(`Description_7433_dil', ``4 dual-NOR buffer OC'')
define(`Param1_7433_dil', 14)
define(`Param2_7433_dil', 300)
define(`PinList_7433_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_7437_dil', ``4 dual-NAND buffer'')
define(`Param1_7437_dil', 14)
define(`Param2_7437_dil', 300)
define(`PinList_7437_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7438_dil', ``4 dual-NAND buffer OC'')
define(`Param1_7438_dil', 14)
define(`Param2_7438_dil', 300)
define(`PinList_7438_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7439_dil', ``4 dual-NAND buffer OC'')
define(`Param1_7439_dil', 14)
define(`Param2_7439_dil', 300)
define(`PinList_7439_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_7440_dil', ``2 quad-NAND buffer'')
define(`Param1_7440_dil', 14)
define(`Param2_7440_dil', 300)
define(`PinList_7440_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_7442_dil', ``4-to-10 decoder'')
define(`Param1_7442_dil', 16)
define(`Param2_7442_dil', 300)
define(`PinList_7442_dil', ``0',`1',`2',`3',`4',`5',`6',`Gnd',`7',`8',`9',`D',`C',`B',`A',`Vcc'')

define(`Description_7445_dil', ``BCD to decimal decoder/driver'')
define(`Param1_7445_dil', 16)
define(`Param2_7445_dil', 300)
define(`PinList_7445_dil', ``0',`1',`2',`3',`4',`5',`6',`Gnd',`7',`8',`9',`D',`C',`B',`A',`Vcc'')

define(`Description_7446_dil', ``BCD to 7-segment driver OC'')
define(`Param1_7446_dil', 16)
define(`Param2_7446_dil', 300)
define(`PinList_7446_dil', ``B',`C',`/LT',`/BI-/RBO',`/RBI',`D',`A',`Gnd',`e',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_7447_dil', ``BCD to 7-segment driver OC'')
define(`Param1_7447_dil', 16)
define(`Param2_7447_dil', 300)
define(`PinList_7447_dil', ``B',`C',`/LT',`/BI-/RBO',`/RBI',`D',`A',`Gnd',`e',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_7448_dil', ``BCD to 7-segment driver w. pullup'')
define(`Param1_7448_dil', 16)
define(`Param2_7448_dil', 300)
define(`PinList_7448_dil', ``B',`C',`/LT',`/BI-/RBO',`/RBI',`D',`A',`Gnd',`e',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_7449_dil', ``BCD to 7-segment driver OC w. blanking input'')
define(`Param1_7449_dil', 14)
define(`Param2_7449_dil', 300)
define(`PinList_7449_dil', ``B',`C',`/BI',`D',`A',`e',`Gnd',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_7450_dil', ``2 AND-OR inverters (2x2 inputs)'')
define(`Param1_7450_dil', 14)
define(`Param2_7450_dil', 300)
define(`PinList_7450_dil', ``1A',`2A',`2B',`2C',`2D',`2Y',`Gnd',`1Y',`1C',`1D',`1X',`1/X',`1B',`Vcc'')

define(`Description_7451L_dil', ``2 AND-OR inverters (2x2,2x3 inputs)'')
define(`Param1_7451L_dil', 14)
define(`Param2_7451L_dil', 300)
define(`PinList_7451L_dil', ``1A',`2A',`2B',`2C',`2D',`2Y',`Gnd',`1Y',`1D',`1E',`1F',`1B',`1C',`Vcc'')

define(`Description_7451S_dil', ``2 AND-OR inverters (2x2 inputs)'')
define(`Param1_7451S_dil', 14)
define(`Param2_7451S_dil', 300)
define(`PinList_7451S_dil', ``1A',`2A',`2B',`2C',`2D',`2Y',`Gnd',`1Y',`1C',`1D',`NC',`NC',`1B',`Vcc'')

define(`Description_7453_dil', ``AND-OR inverter (4x2 inputs)'')
define(`Param1_7453_dil', 14)
define(`Param2_7453_dil', 300)
define(`PinList_7453_dil', ``A',`C',`D',`E',`F',`NC',`Gnd',`Y',`G',`H',`X',`/X',`B',`Vcc'')

define(`Description_7454_dil', ``AND-OR inverter (4x2 inputs)'')
define(`Param1_7454_dil', 14)
define(`Param2_7454_dil', 300)
define(`PinList_7454_dil', ``A',`C',`D',`E',`F',`NC',`Gnd',`Y',`G',`H',`NC',`NC',`B',`Vcc'')

define(`Description_7455_dil', ``AND-OR inverter (2x4 inputs)'')
define(`Param1_7455_dil', 14)
define(`Param2_7455_dil', 300)
define(`PinList_7455_dil', ``A',`B',`C',`D',`NC',`NC',`Gnd',`Y',`NC',`E',`F',`G',`H',`Vcc'')

define(`Description_7457_dil', ``frequency divider'')
define(`Param1_7457_dil', 8)
define(`Param2_7457_dil', 300)
define(`PinList_7457_dil', ``ClkB',`Vcc',`Qa',`Gnd',`ClkA',`Clr',`Qb',`Qc'')

define(`Description_7464_dil', ``AND-OR inverter (4-2-3-2 inputs)'')
define(`Param1_7464_dil', 14)
define(`Param2_7464_dil', 300)
define(`PinList_7464_dil', ``A',`E',`F',`G',`H',`I',`Gnd',`Y',`J',`K',`B',`C',`D',`Vcc'')

define(`Description_7465_dil', ``AND-OR inverter OC (4-2-3-2 inputs)'')
define(`Param1_7465_dil', 14)
define(`Param2_7465_dil', 300)
define(`PinList_7465_dil', ``A',`E',`F',`G',`H',`I',`Gnd',`Y',`J',`K',`B',`C',`D',`Vcc'')

define(`Description_7468_dil', ``2 4bit decade counter'')
define(`Param1_7468_dil', 16)
define(`Param2_7468_dil', 300)
define(`PinList_7468_dil', ``1ClkA',`1Qb',`1Qd',`/1Clr',`2Qc',`NC',`2Qa',`Gnd',`2Clk',`2Qb',`/2Clr',`2Qd',`1Qc',`1Qa',`1ClkB',`Vcc'')

define(`Description_7469_dil', ``2 4bit binary counter'')
define(`Param1_7469_dil', 16)
define(`Param2_7469_dil', 300)
define(`PinList_7469_dil', ``1ClkA',`1Qb',`1Qd',`/1Clr',`2Qc',`NC',`2Qa',`Gnd',`2Clk',`2Qb',`/2Clr',`2Qd',`1Qc',`1Qa',`1ClkB',`Vcc'')

define(`Description_7470_dil', ``AND-gated JK pos-edge-FF w. preset/clear'')
define(`Param1_7470_dil', 14)
define(`Param2_7470_dil', 300)
define(`PinList_7470_dil', ``NC',`/Clr',`J1',`J2',`/J',`/Q',`Gnd',`Q',`/K',`K1',`K2',`Clk',`/Pre',`Vcc'')

define(`Description_7472_dil', ``AND-gated MS-FF w. preset/clear'')
define(`Param1_7472_dil', 14)
define(`Param2_7472_dil', 300)
define(`PinList_7472_dil', ``NC',`/Clr',`J1',`J2',`J3',`/Q',`Gnd',`Q',`K1',`K2',`K3',`Clk',`/Pre',`Vcc'')

define(`Description_7473_dil', ``2 JK FF w. clear'')
define(`Param1_7473_dil', 14)
define(`Param2_7473_dil', 300)
define(`PinList_7473_dil', ``1Clk',`/1Clr',`1K',`Vcc',`2Clk',`/2Clr',`2J',`/2Q',`2Q',`2K',`Gnd',`1Q',`/1Q',`1J'')

define(`Description_7474_dil', ``2 D-type pos-edge FF w. preset/clear'')
define(`Param1_7474_dil', 14)
define(`Param2_7474_dil', 300)
define(`PinList_7474_dil', ``/1Clr',`1D',`1Clk',`/1Pre',`1Q',`/1Q',`Gnd',`/2Q',`2Q',`/2Pre',`2Clk',`2D',`/2Clr',`Vcc'')

define(`Description_7475_dil', ``4bit bi-stable latch w. compl. outputs'')
define(`Param1_7475_dil', 16)
define(`Param2_7475_dil', 300)
define(`PinList_7475_dil', ``/1Q',`1D',`2D',`3C-4C',`Vcc',`3D',`4D',`/4Q',`4Q',`3Q',`/3Q',`Gnd',`1C-2C',`/2Q',`2Q',`1Q'')

define(`Description_7476_dil', ``2 JK FF w. preset/clear'')
define(`Param1_7476_dil', 16)
define(`Param2_7476_dil', 300)
define(`PinList_7476_dil', ``1Clk',`/1Pre',`/1Clr',`1J',`Vcc',`2Clk',`/2Pre',`/2Clr',`2J',`/2Q',`2Q',`2K',`Gnd',`/1Q',`1Q',`1K'')

define(`Description_7478_dil', ``2 JK FF w. preset and common Clk/Clr'')
define(`Param1_7478_dil', 14)
define(`Param2_7478_dil', 300)
define(`PinList_7478_dil', ``Clk',`/1Pre',`1J',`Vcc',`/Clr',`/2Pre',`2K',`2Q',`/2Q',`2J',`Gnd',`/1Q',`1Q',`1K'')

define(`Description_7483_dil', ``4bit binary adder w. fast carry'')
define(`Param1_7483_dil', 16)
define(`Param2_7483_dil', 300)
define(`PinList_7483_dil', ``A4',`Sum3',`A3',`B3',`Vcc',`Sum2',`B2',`A2',`Sum1',`A1',`B1',`Gnd',`C0',`C4',`Sum4',`B4'')

define(`Description_7485_dil', ``4bit magnitude comperator'')
define(`Param1_7485_dil', 16)
define(`Param2_7485_dil', 300)
define(`PinList_7485_dil', ``B3',`A<Bin',`A=Bin',`A>Bin',`A>Bout',`A=Bout',`A<Bout',`Gnd',`B0',`A0',`B1',`A1',`A2',`B2',`A3',`Vcc'')

define(`Description_7486_dil', ``4 dual-XOR'')
define(`Param1_7486_dil', 14)
define(`Param2_7486_dil', 300)
define(`PinList_7486_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_7490_dil', ``decade counter w. clear/set-to-9'')
define(`Param1_7490_dil', 14)
define(`Param2_7490_dil', 300)
define(`PinList_7490_dil', ``ClkB',`R0(1)',`R0(2)',`NC',`Vcc',`R9(1)',`R9(2)',`Qc',`Qb',`Gnd',`Qd',`Qa',`NC',`ClkA'')

define(`Description_7491_dil', ``8bit shift register'')
define(`Param1_7491_dil', 14)
define(`Param2_7491_dil', 300)
define(`PinList_7491_dil', ``NC',`NC',`NC',`NC',`Vcc',`NC',`NC',`NC',`Clk',`Gnd',`B',`A',`Q',`/Q'')

define(`Description_7492_dil', ``divide by 12 counter w. clear'')
define(`Param1_7492_dil', 14)
define(`Param2_7492_dil', 300)
define(`PinList_7492_dil', ``ClkB',`NC',`NC',`NC',`Vcc',`R0(1)',`R0(2)',`Qd',`Qc',`Gnd',`Qb',`Qa',`NC',`ClkA'')

define(`Description_7493_dil', ``4bit binary counter w. clear'')
define(`Param1_7493_dil', 14)
define(`Param2_7493_dil', 300)
define(`PinList_7493_dil', ``ClkB',`R0(1)',`R0(2)',`NC',`Vcc',`NC',`NC',`Qc',`Qb',`Gnd',`Qd',`Qa',`NC',`ClkA'')

define(`Description_7495_dil', ``4bit parallel-access shift register'')
define(`Param1_7495_dil', 14)
define(`Param2_7495_dil', 300)
define(`PinList_7495_dil', ``Ser',`A',`B',`C',`D',`Mode',`Gnd',`Clk2',`Clk1',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_7496_dil', ``5bit shift register'')
define(`Param1_7496_dil', 16)
define(`Param2_7496_dil', 300)
define(`PinList_7496_dil', ``Clk',`A',`B',`C',`Vcc',`D',`E',`Pre',`Ser',`Qe',`Qd',`Gnd',`Qc',`Qb',`Qa',`/Clr'')

define(`Description_7497_dil', ``syncronous 6bit binary rate multiplier'')
define(`Param1_7497_dil', 16)
define(`Param2_7497_dil', 300)
define(`PinList_7497_dil', ``B1',`B4',`B5',`B0',`Z',`Y',`ENout',`Gnd',`Clk',`StrB',`ENin',`Unity/CAS',`Clr',`B2',`B3',`Vcc'')

define(`Description_74107_dil', ``2 JK FF w. clear'')
define(`Param1_74107_dil', 14)
define(`Param2_74107_dil', 300)
define(`PinList_74107_dil', ``1J',`/1Q',`1Q',`1K',`2Q',`/2Q',`Gnd',`2J',`2Clk',`/2Clr',`2K',`1Clk',`/1Clr',`Vcc'')

define(`Description_74109_dil', ``2 J-/K pos-edge FF w. preset/clear'')
define(`Param1_74109_dil', 16)
define(`Param2_74109_dil', 300)
define(`PinList_74109_dil', ``/1Clr',`1J',`/1K',`1Clk',`/1Pre',`1Q',`/1Q',`Gnd',`/2Q',`2Q',`/2Pre',`2Clk',`/2K',`2J',`/2Clr',`Vcc'')

define(`Description_74111_dil', ``2 JK-MS FF w. data lockout'')
define(`Param1_74111_dil', 16)
define(`Param2_74111_dil', 300)
define(`PinList_74111_dil', ``1K',`/1Pre',`/1Clr',`1J',`1Clk',`/1Q',`1Q',`Gnd',`2Q',`/2Q',`2Clk',`2J',`/2Clr',`/2Pre',`2K',`Vcc'')

define(`Description_74112_dil', ``2 JK edge FF w. preset/clear'')
define(`Param1_74112_dil', 16)
define(`Param2_74112_dil', 300)
define(`PinList_74112_dil', ``1Clk',`1K',`1J',`/1Pre',`1Q',`/1Q',`/2Q',`Gnd',`2Q',`/2Pre',`2J',`2K',`2Clk',`/2Clr',`/1Clr',`Vcc'')

define(`Description_74113_dil', ``2 JK edge FF w. preset'')
define(`Param1_74113_dil', 14)
define(`Param2_74113_dil', 300)
define(`PinList_74113_dil', ``1Clk',`1K',`1J',`/1Pre',`1Q',`/1Q',`Gnd',`/2Q',`2Q',`/2Pre',`2J',`2K',`2Clk',`Vcc'')

define(`Description_74114_dil', ``2 JK edge FF w. preset and common Clr/Clk'')
define(`Param1_74114_dil', 14)
define(`Param2_74114_dil', 300)
define(`PinList_74114_dil', ``/Clr',`1K',`1J',`/1Pre',`1Q',`/1Q',`Gnd',`/2Q',`2Q',`/2Pre',`2J',`2K',`Clk',`Vcc'')

define(`Description_74116_dil', ``2 4bit lacthes w. clear'')
define(`Param1_74116_dil', 24)
define(`Param2_74116_dil', 300)
define(`PinList_74116_dil', ``/1Clr',`/1C1',`/1C2',`1D1',`1Q1',`1D2',`1Q2',`1D3',`1Q3',`1D4',`1Q4',`Gnd',`/2Clr',`/2C1',`/2C2',`2D1',`2Q1',`2D2',`2Q2',`2D3',`2Q3',`2D4',`2Q4',`Vcc'')

define(`Description_74120_dil', ``2 pulse synchronizer/driver'')
define(`Param1_74120_dil', 16)
define(`Param2_74120_dil', 300)
define(`PinList_74120_dil', ``1M',`/1S1',`/1S2',`/1R',`1C',`1Y',`/1Y',`Gnd',`/2Y',`2Y',`2C',`/2R',`/2S1',`/2S2',`2M',`Vcc'')

define(`Description_74121_dil', ``monostable multivibrator w. Schmitt trigger input'')
define(`Param1_74121_dil', 14)
define(`Param2_74121_dil', 300)
define(`PinList_74121_dil', ``/Q',`NC',`A1',`A2',`B',`Q',`Gnd',`NC',`Rint',`Cext',`Rext-Cext',`NC',`NC',`Vcc'')

define(`Description_74122_dil', ``retriggerable monostable multivibrator w. internal resistors'')
define(`Param1_74122_dil', 14)
define(`Param2_74122_dil', 300)
define(`PinList_74122_dil', ``A1',`A2',`B1',`B2',`/Clr',`/Q',`Gnd',`Q',`Rint',`NC',`Cext',`NC',`Rext-Cext',`Vcc'')

define(`Description_74123_dil', ``retriggerable monostable multivibrator'')
define(`Param1_74123_dil', 16)
define(`Param2_74123_dil', 300)
define(`PinList_74123_dil', ``1A',`1B',`/1Clr',`/1Q',`2Q',`2Cext',`2Rext-Cext',`Gnd',`2A',`2B',`/2Clr',`/2Q',`1Q',`1Cext',`1Rext-Cext',`Vcc'')

define(`Description_74124_dil', ``2 voltage controlled oszillators'')
define(`Param1_74124_dil', 16)
define(`Param2_74124_dil', 300)
define(`PinList_74124_dil', ``2FC',`1FC',`1Rng',`1CX1',`1CX2',`/1En',`1Y',`Osc-Gnd',`Gnd',`2Y',`/2En',`2CX1',`2CX2',`2Rng',`Osc-Vcc',`Vcc'')

define(`Description_74125_dil', ``4 bus buffers 3-state inverted control'')
define(`Param1_74125_dil', 14)
define(`Param2_74125_dil', 300)
define(`PinList_74125_dil', ``/1G',`1A',`1Y',`/2G',`2A',`2Y',`Gnd',`3Y',`3A',`/3G',`4Y',`4A',`/4G',`Vcc'')

define(`Description_74126_dil', ``4 buffers 3-state positive control'')
define(`Param1_74126_dil', 14)
define(`Param2_74126_dil', 300)
define(`PinList_74126_dil', ``1G',`1A',`1Y',`2G',`2A',`2Y',`Gnd',`3Y',`3A',`3G',`4Y',`4A',`4G',`Vcc'')

define(`Description_74128_dil', ``4 line drivers'')
define(`Param1_74128_dil', 14)
define(`Param2_74128_dil', 300)
define(`PinList_74128_dil', ``1Y',`1A',`1B',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4A',`4B',`4Y',`Vcc'')

define(`Description_74132_dil', ``4 dual NAND Schmitt trigger'')
define(`Param1_74132_dil', 14)
define(`Param2_74132_dil', 300)
define(`PinList_74132_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_74133_dil', ``13 input NAND'')
define(`Param1_74133_dil', 16)
define(`Param2_74133_dil', 300)
define(`PinList_74133_dil', ``A',`B',`C',`D',`E',`F',`G',`Gnd',`Y',`H',`I',`J',`K',`L',`M',`Vcc'')

define(`Description_74134_dil', ``12 input NAND 3-state'')
define(`Param1_74134_dil', 16)
define(`Param2_74134_dil', 300)
define(`PinList_74134_dil', ``A',`B',`C',`D',`E',`F',`G',`Gnd',`Y',`H',`I',`J',`K',`L',`/OC',`Vcc'')

define(`Description_74135_dil', ``4 dual-XOR-XNOR'')
define(`Param1_74135_dil', 16)
define(`Param2_74135_dil', 300)
define(`PinList_74135_dil', ``1A',`1B',`1Y',`1C-2C',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`3c-4c',`4Y',`4A',`4B',`Vcc'')

define(`Description_74136_dil', ``4 dual-XOR OC'')
define(`Param1_74136_dil', 14)
define(`Param2_74136_dil', 300)
define(`PinList_74136_dil', ``1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3A',`3B',`4Y',`4A',`4B',`Vcc'')

define(`Description_74137_dil', ``3-to-8 decoder w. address latch'')
define(`Param1_74137_dil', 16)
define(`Param2_74137_dil', 300)
define(`PinList_74137_dil', ``A',`B',`C',`/GL',`/G2',`G1',`Y7',`Gnd',`Y6',`Y5',`Y4',`Y3',`Y2',`Y1',`Y0',`Vcc'')

define(`Description_74138_dil', ``3-to-8 decoder'')
define(`Param1_74138_dil', 16)
define(`Param2_74138_dil', 300)
define(`PinList_74138_dil', ``A',`B',`C',`/G2A',`/G2B',`G1',`Y7',`Gnd',`Y6',`Y5',`Y4',`Y3',`Y2',`Y1',`Y0',`Vcc'')

define(`Description_74139_dil', ``2 2-to-4 decoder'')
define(`Param1_74139_dil', 16)
define(`Param2_74139_dil', 300)
define(`PinList_74139_dil', ``/G1',`A1',`B1',`Y10',`Y11',`Y12',`Y13',`Gnd',`Y23',`Y22',`Y21',`Y20',`B2',`A2',`/G2',`Vcc'')

define(`Description_74140_dil', ``2 quad-NAND 50Ohm driver'')
define(`Param1_74140_dil', 14)
define(`Param2_74140_dil', 300)
define(`PinList_74140_dil', ``1A',`1B',`NC',`1C',`1D',`1Y',`Gnd',`2Y',`2A',`2B',`NC',`2C',`2D',`Vcc'')

define(`Description_74143_dil', ``4bit counter/latch 7-segment driver'')
define(`Param1_74143_dil', 24)
define(`Param2_74143_dil', 300)
define(`PinList_74143_dil', ``/SCEI',`Clk',`/Clr',`/RBI',`BI',`/BI-/RBO',`Dp',`dp',`d',`f',`e',`Gnd',`g',`c',`a',`b',`Qa',`Qb',`Qc',`Qd',`/StrB',`Max',`/PECI',`Vcc'')

define(`Description_74145_dil', ``BCD to decimal decoder'')
define(`Param1_74145_dil', 16)
define(`Param2_74145_dil', 300)
define(`PinList_74145_dil', ``0',`1',`2',`3',`4',`5',`6',`Gnd',`7',`8',`9',`D',`C',`B',`A',`Vcc'')

define(`Description_74147_dil', ``10-to-4 encoder'')
define(`Param1_74147_dil', 16)
define(`Param2_74147_dil', 300)
define(`PinList_74147_dil', ``4',`5',`6',`7',`8',`C',`B',`Gnd',`A',`9',`1',`2',`3',`D',`NC',`Vcc'')

define(`Description_74148_dil', ``8-to-3 encoder'')
define(`Param1_74148_dil', 16)
define(`Param2_74148_dil', 300)
define(`PinList_74148_dil', ``4',`5',`6',`7',`/Ei',`A2',`A1',`Gnd',`A0',`0',`1',`2',`3',`/Gs',`/Eo',`Vcc'')

define(`Description_74150_dil', ``1-of-16 selector'')
define(`Param1_74150_dil', 24)
define(`Param2_74150_dil', 300)
define(`PinList_74150_dil', ``E7',`E6',`E5',`E4',`E3',`E2',`E1',`E0',`/G',`W',`D',`Gnd',`C',`B',`A',`E15',`E14',`E13',`E12',`E11',`E10',`E9',`E8',`Vcc'')

define(`Description_74151_dil', ``1-of-8 selector'')
define(`Param1_74151_dil', 16)
define(`Param2_74151_dil', 300)
define(`PinList_74151_dil', ``D3',`D2',`D1',`D0',`Y',`W',`/G',`Gnd',`C',`B',`A',`D7',`D6',`D5',`D4',`Vcc'')

define(`Description_74153_dil', ``2 4-to-1 selectors'')
define(`Param1_74153_dil', 16)
define(`Param2_74153_dil', 300)
define(`PinList_74153_dil', ``/1G',`B',`1C3',`1C2',`1C1',`1C0',`1Y',`Gnd',`2Y',`2C0',`2C1',`2C2',`2C3',`A',`/2G',`Vcc'')

define(`Description_74154_dil', ``4-to-16 decoder'')
define(`Param1_74154_dil', 24)
define(`Param2_74154_dil', 300)
define(`PinList_74154_dil', ``0',`1',`2',`3',`4',`5',`6',`7',`8',`9',`10',`Gnd',`11',`12',`13',`14',`15',`/G1',`/G2',`D',`C',`B',`A',`Vcc'')

define(`Description_74155_dil', ``2 2-to-4 decoder'')
define(`Param1_74155_dil', 16)
define(`Param2_74155_dil', 300)
define(`PinList_74155_dil', ``1C',`/1G',`B',`1Y3',`1Y2',`1Y1',`1Y0',`Gnd',`2Y0',`2Y1',`2Y2',`2Y3',`A',`/2G',`/2C',`Vcc'')

define(`Description_74156_dil', ``2 2-to-4 decoder OC'')
define(`Param1_74156_dil', 16)
define(`Param2_74156_dil', 300)
define(`PinList_74156_dil', ``1C',`/1G',`B',`1Y3',`1Y2',`1Y1',`1Y0',`Gnd',`2Y0',`2Y1',`2Y2',`2Y3',`A',`/2G',`/2C',`Vcc'')

define(`Description_74157_dil', ``4 2-to-1 selector'')
define(`Param1_74157_dil', 16)
define(`Param2_74157_dil', 300)
define(`PinList_74157_dil', ``/A-B',`1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3B',`3A',`4Y',`4Y',`4A',`/G',`Vcc'')

define(`Description_74158_dil', ``4 2-to-1 selector inverted output'')
define(`Param1_74158_dil', 16)
define(`Param2_74158_dil', 300)
define(`PinList_74158_dil', ``/A-B',`1A',`1B',`/1Y',`2A',`2B',`/2Y',`Gnd',`/3Y',`3B',`3A',`4Y',`/4Y',`4A',`/G',`Vcc'')

define(`Description_74159_dil', ``4-to-16 decoder OC'')
define(`Param1_74159_dil', 24)
define(`Param2_74159_dil', 300)
define(`PinList_74159_dil', ``0',`1',`2',`3',`4',`5',`6',`7',`8',`9',`10',`Gnd',`11',`12',`13',`14',`15',`/G1',`/G2',`D',`C',`B',`A',`Vcc'')

define(`Description_74160_dil', ``syncronous decade counter w. async. clear'')
define(`Param1_74160_dil', 16)
define(`Param2_74160_dil', 300)
define(`PinList_74160_dil', ``/Clr',`Clk',`A',`B',`C',`D',`ENP',`Gnd',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74161_dil', ``syncronous 4bit binary counter w. async. clear'')
define(`Param1_74161_dil', 16)
define(`Param2_74161_dil', 300)
define(`PinList_74161_dil', ``/Clr',`Clk',`A',`B',`C',`D',`ENP',`Gnd',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74162_dil', ``syncronous decade counter w. sync. clear'')
define(`Param1_74162_dil', 16)
define(`Param2_74162_dil', 300)
define(`PinList_74162_dil', ``/Clr',`Clk',`A',`B',`C',`D',`ENP',`Gnd',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74163_dil', ``syncronous 4bit binary counter w. sync. clear'')
define(`Param1_74163_dil', 16)
define(`Param2_74163_dil', 300)
define(`PinList_74163_dil', ``/Clr',`Clk',`A',`B',`C',`D',`ENP',`Gnd',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74164_dil', ``8bit parallel-out shift register'')
define(`Param1_74164_dil', 14)
define(`Param2_74164_dil', 300)
define(`PinList_74164_dil', ``A',`B',`Qa',`Qb',`Qc',`Qd',`Gnd',`Clk',`/Clr',`Qe',`Qf',`Qg',`Qh',`Vcc'')

define(`Description_74165_dil', ``parallel-load 8bit shift register'')
define(`Param1_74165_dil', 16)
define(`Param2_74165_dil', 300)
define(`PinList_74165_dil', ``SH-/LD',`Clk',`E',`F',`G',`H',`/Qh',`Gnd',`Qh',`SER',`A',`B',`C',`D',`Clk_Inh',`Vcc'')

define(`Description_74166_dil', ``parallel-load 8bit shift register'')
define(`Param1_74166_dil', 16)
define(`Param2_74166_dil', 300)
define(`PinList_74166_dil', ``SER',`A',`B',`C',`D',`Clk_Inh',`Clk',`Gnd',`/Clr',`E',`F',`G',`Qh',`H',`SH-/LD',`Vcc'')

define(`Description_74167_dil', ``syncronous decade rate multiplier'')
define(`Param1_74167_dil', 16)
define(`Param2_74167_dil', 300)
define(`PinList_74167_dil', ``NC',`B2',`B3',`Set-to-9',`Z',`Y',`ENout',`Gnd',`Clk',`StrB',`ENin',`Unity-CAS',`Clr',`Bo',`B1',`Vcc'')

define(`Description_74169_dil', ``sync. 4bit up/down counter'')
define(`Param1_74169_dil', 16)
define(`Param2_74169_dil', 300)
define(`PinList_74169_dil', ``U-/D',`Clk',`A',`B',`C',`D',`/ENP',`Gnd',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

define(`Description_74170_dil', ``4-by-4 register files OC'')
define(`Param1_74170_dil', 16)
define(`Param2_74170_dil', 300)
define(`PinList_74170_dil', ``D2',`D3',`D4',`Rb',`Ra',`Q4',`Q3',`Gnd',`Q2',`Q1',`/Gr',`/Gw',`Wb',`Wa',`D1',`Vcc'')

define(`Description_74171_dil', ``4 D-type FF w. clear'')
define(`Param1_74171_dil', 16)
define(`Param2_74171_dil', 300)
define(`PinList_74171_dil', ``/1Q',`/2Q',`2Q',`2D',`3D',`3Q',`/3Q',`Gnd',`/4Q',`4Q',`4D',`Clk',`/Clr',`1D',`1Q',`Vcc'')

define(`Description_74172_dil', ``16bit multiple-port register file 3-state'')
define(`Param1_74172_dil', 24)
define(`Param2_74172_dil', 300)
define(`PinList_74172_dil', ``1W1',`1W0',`/1Gw',`1DB',`2DB',`Clk',`1R2',`1R1',`1R0',`1Qb',`2Qb',`Gnd',`2Qa',`1Qa',`/1Gr',`/2Gr',`2W-R0',`2W-R1',`2W-R2',`/2Gw',`2Da',`1Da',`1W2',`Vcc'')

define(`Description_74173_dil', ``4bit D-type register 3-state'')
define(`Param1_74173_dil', 16)
define(`Param2_74173_dil', 300)
define(`PinList_74173_dil', ``M',`N',`1Q',`2Q',`3Q',`4Q',`Clk',`Gnd',`/G1',`/G2',`4D',`3D',`2D',`1D',`Clr',`Vcc'')

define(`Description_74174_dil', ``6 D-type FF single-rail output'')
define(`Param1_74174_dil', 16)
define(`Param2_74174_dil', 300)
define(`PinList_74174_dil', ``/Clr',`1Q',`1D',`2D',`2Q',`3D',`3Q',`Gnd',`Clk',`4Q',`4D',`5Q',`5D',`6D',`6Q',`Vcc'')

define(`Description_74175_dil', ``4 D-type FF double-rail output'')
define(`Param1_74175_dil', 16)
define(`Param2_74175_dil', 300)
define(`PinList_74175_dil', ``/Clr',`1Q',`/1Q',`1D',`2D',`/2Q',`2Q',`Gnd',`Clk',`3Q',`/3Q',`3D',`4D',`/4Q',`4Q',`Vcc'')

define(`Description_74176_dil', ``presettable decade counter/latch (divide by 2/5)'')
define(`Param1_74176_dil', 14)
define(`Param2_74176_dil', 300)
define(`PinList_74176_dil', ``/Load',`Qc',`C',`A',`Qa',`Clk2',`Gnd',`Clk1',`Qb',`B',`D',`Qd',`/Clr',`Vcc'')

define(`Description_74177_dil', ``presettable binary counter/latch (divide by 2/8)'')
define(`Param1_74177_dil', 14)
define(`Param2_74177_dil', 300)
define(`PinList_74177_dil', ``/Load',`Qc',`C',`A',`Qa',`Clk2',`Gnd',`Clk1',`Qb',`B',`D',`Qd',`/Clr',`Vcc'')

define(`Description_74178_dil', ``4bit parallel-access shift register'')
define(`Param1_74178_dil', 14)
define(`Param2_74178_dil', 300)
define(`PinList_74178_dil', ``B',`A',`SER',`Qa',`Clk',`Qb',`Gnd',`Qc',`Load',`Qd',`Shift',`D',`C',`Vcc'')

define(`Description_74180_dil', ``9bit /even/odd parity generator/checker'')
define(`Param1_74180_dil', 14)
define(`Param2_74180_dil', 300)
define(`PinList_74180_dil', ``G',`H',`Even',`Odd',`SumEven',`SumOdd',`Gnd',`A',`B',`C',`D',`E',`F',`Vcc'')

define(`Description_74181_dil', ``ALU function generator'')
define(`Param1_74181_dil', 24)
define(`Param2_74181_dil', 300)
define(`PinList_74181_dil', ``/B0',`/A0',`S3',`S2',`S1',`S0',`Cn',`M',`/F0',`/F1',`/F2',`Gnd',`/F3',`A=B',`/P',`/Cn+4',`/G',`/B3',`/A3',`/B2',`/A2',`/B1',`/A1',`Vcc'')

define(`Description_74182_dil', ``look-ahead carry generator'')
define(`Param1_74182_dil', 16)
define(`Param2_74182_dil', 300)
define(`PinList_74182_dil', ``/G1',`/P1',`/G0',`/P0',`/G3',`/P3',`/P',`Gnd',`Cn+Z',`/G',`Cn+Y',`Cn+X',`Cn',`/G2',`/P2',`Vcc'')

define(`Description_74183_dil', ``2 carry-save full adders'')
define(`Param1_74183_dil', 14)
define(`Param2_74183_dil', 300)
define(`PinList_74183_dil', ``1A',`NC',`1B',`1Cn',`1Cn+1',`1Sum',`Gnd',`2Sum',`NC',`2Cn+1',`2Cn',`2B',`2A',`Vcc'')

define(`Description_74190_dil', ``syncronous 4bit BCD up/down counter'')
define(`Param1_74190_dil', 16)
define(`Param2_74190_dil', 300)
define(`PinList_74190_dil', ``B',`Qb',`Qa',`/CTEN',`D-/U',`Qc',`Qd',`Gnd',`D',`C',`/Load',`Max-Min',`/RCO',`Clk',`A',`Vcc'')

define(`Description_74191_dil', ``syncronous 4bit binary up/down counter'')
define(`Param1_74191_dil', 16)
define(`Param2_74191_dil', 300)
define(`PinList_74191_dil', ``B',`Qb',`Qa',`/CTEN',`D-/U',`Qc',`Qd',`Gnd',`D',`C',`/Load',`Max-Min',`/RCO',`Clk',`A',`Vcc'')

define(`Description_74192_dil', ``syncronous 4bit BCD up/down counter w. dual-clock and clear'')
define(`Param1_74192_dil', 16)
define(`Param2_74192_dil', 300)
define(`PinList_74192_dil', ``B',`Qb',`Qa',`Down',`Up',`Qc',`Qd',`Gnd',`D',`C',`/Load',`/CO',`/BO',`Clr',`A',`Vcc'')

define(`Description_74193_dil', ``syncronous 4bit binary up/down counter w. dual-clock and clear'')
define(`Param1_74193_dil', 16)
define(`Param2_74193_dil', 300)
define(`PinList_74193_dil', ``B',`Qb',`Qa',`Down',`Up',`Qc',`Qd',`Gnd',`D',`C',`/Load',`/CO',`/BO',`Clr',`A',`Vcc'')

define(`Description_74194_dil', ``4bit bi-directional shift register'')
define(`Param1_74194_dil', 16)
define(`Param2_74194_dil', 300)
define(`PinList_74194_dil', ``/Clr',`SRSer',`A',`B',`C',`D',`SLSer',`Gnd',`S0',`S1',`Clk',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_74195_dil', ``4bit parallel-access shift register'')
define(`Param1_74195_dil', 16)
define(`Param2_74195_dil', 300)
define(`PinList_74195_dil', ``/Clr',`J',`/K',`A',`B',`C',`D',`Gnd',`SH-/Ld',`Clk',`/Qd',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_74196_dil', ``presettable decade counter/latch (divide by 2/5)'')
define(`Param1_74196_dil', 14)
define(`Param2_74196_dil', 300)
define(`PinList_74196_dil', ``/Load',`Qc',`C',`A',`Qa',`Clk2',`Gnd',`Clk1',`Qb',`B',`D',`Qd',`/Clr',`Vcc'')

define(`Description_74197_dil', ``presettable binary counter/latch (divide by 2/8)'')
define(`Param1_74197_dil', 14)
define(`Param2_74197_dil', 300)
define(`PinList_74197_dil', ``/Load',`Qc',`C',`A',`Qa',`Clk2',`Gnd',`Clk1',`Qb',`B',`D',`Qd',`/Clr',`Vcc'')

define(`Description_74198_dil', ``8bit shift register'')
define(`Param1_74198_dil', 24)
define(`Param2_74198_dil', 300)
define(`PinList_74198_dil', ``S0',`SPSer',`A',`Qa',`B',`Qb',`C',`Qc',`D',`Qd',`Clk',`Gnd',`/Clr',`Qe',`E',`Qf',`F',`Qg',`G',`Qh',`H',`SLSer',`S1',`Vcc'')

define(`Description_74199_dil', ``8bit shift register w. parallel input/output/JK-input'')
define(`Param1_74199_dil', 24)
define(`Param2_74199_dil', 300)
define(`PinList_74199_dil', ``/K',`J',`A',`Qa',`B',`Qb',`C',`Qc',`D',`Qd',`ClkInh',`Gnd',`Clk',`/Clr',`Qe',`E',`Qf',`F',`Qg',`G',`Qh',`H',`SH-/LD',`Vcc'')

define(`Description_74221_dil', ``2 monostable multivibrator w. Schmitt trigger input'')
define(`Param1_74221_dil', 16)
define(`Param2_74221_dil', 300)
define(`PinList_74221_dil', ``1A',`1A',`/1Clr',`/1Q',`2Q',`2Cext',`2Rext-Cext',`Gnd',`2A',`2B',`/2Clr',`/2Q',`1Q',`1Cext',`1Rext-Cext',`Vcc'')

define(`Description_74240_dil', ``8 buffer/driver 3-state w. inverted output'')
define(`Param1_74240_dil', 20)
define(`Param2_74240_dil', 300)
define(`PinList_74240_dil', ``/1G',`1A1',`2Y4',`1A2',`2Y3',`1A3',`2Y2',`1A4',`2Y1',`Gnd',`2A1',`1Y4',`2A2',`1Y3',`2A3',`1Y2',`2A4',`1Y1',`/2G',`Vcc'')

define(`Description_74241_dil', ``8 buffer/driver 3-state w. pos/neg enable'')
define(`Param1_74241_dil', 20)
define(`Param2_74241_dil', 300)
define(`PinList_74241_dil', ``/1G',`1A1',`2Y4',`1A2',`2Y3',`1A3',`2Y2',`1A4',`2Y1',`Gnd',`2A1',`1Y4',`2A2',`1Y3',`2A3',`1Y2',`2A4',`1Y1',`/2G',`Vcc'')

define(`Description_74242_dil', ``4 bus tranceiver'')
define(`Param1_74242_dil', 14)
define(`Param2_74242_dil', 300)
define(`PinList_74242_dil', ``/Gab',`NC',`A1',`A2',`A3',`A4',`Gnd',`B4',`B3',`B2',`B1',`NC',`Gba',`Vcc'')

define(`Description_74243_dil', ``4 bus tranceiver w. inverting outputs'')
define(`Param1_74243_dil', 14)
define(`Param2_74243_dil', 300)
define(`PinList_74243_dil', ``/Gab',`NC',`A1',`A2',`A3',`A4',`Gnd',`B4',`B3',`B2',`B1',`NC',`Gba',`Vcc'')

define(`Description_74244_dil', ``8 buffer/driver 3-state'')
define(`Param1_74244_dil', 20)
define(`Param2_74244_dil', 300)
define(`PinList_74244_dil', ``/1G',`1A1',`2Y4',`1A2',`2Y3',`1A3',`2Y2',`1A4',`2Y1',`Gnd',`2A1',`1Y4',`2A2',`1Y3',`2A3',`1Y2',`2A4',`1Y1',`/2G',`Vcc'')

define(`Description_74245_dil', ``8 bus tranceiver 3-state'')
define(`Param1_74245_dil', 20)
define(`Param2_74245_dil', 300)
define(`PinList_74245_dil', ``Dir',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`Vcc'')

define(`Description_74247_dil', ``BCD to 7-segment decoder/driver OC'')
define(`Param1_74247_dil', 16)
define(`Param2_74247_dil', 300)
define(`PinList_74247_dil', ``B',`C',`/LT',`/BI-/RBO',`/RBI',`D',`A',`Gnd',`e',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_74248_dil', ``BCD to 7-segment decoder/driver w. output pull-up'')
define(`Param1_74248_dil', 16)
define(`Param2_74248_dil', 300)
define(`PinList_74248_dil', ``B',`C',`/LT',`/BI-/RBO',`/RBI',`D',`A',`Gnd',`e',`d',`c',`b',`a',`g',`f',`Vcc'')

define(`Description_74251_dil', ``data selector/multiplexor 3-state'')
define(`Param1_74251_dil', 16)
define(`Param2_74251_dil', 300)
define(`PinList_74251_dil', ``D3',`D2',`D1',`D0',`Y',`W',`/G',`Gnd',`C',`B',`A',`D7',`D6',`D5',`D4',`Vcc'')

define(`Description_74253_dil', ``2 4-to-1 selector/multiplexor 3-state'')
define(`Param1_74253_dil', 16)
define(`Param2_74253_dil', 300)
define(`PinList_74253_dil', ``/1G',`N',`1C3',`1C2',`1C1',`1C0',`1Y',`Gnd',`2Y',`2C0',`2C1',`2C2',`2C3',`A',`/2G',`Vcc'')

define(`Description_74257_dil', ``4 2-to-1 selectors/demultiplexors'')
define(`Param1_74257_dil', 16)
define(`Param2_74257_dil', 300)
define(`PinList_74257_dil', ``/A-B',`1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3B',`3A',`4Y',`4B',`4A',`/G',`Vcc'')

define(`Description_74258_dil', ``4 2-to-1 selectors/demultiplexors w. inverting outputs'')
define(`Param1_74258_dil', 16)
define(`Param2_74258_dil', 300)
define(`PinList_74258_dil', ``/A-B',`1A',`1B',`1Y',`2A',`2B',`2Y',`Gnd',`3Y',`3B',`3A',`4Y',`4B',`4A',`/G',`Vcc'')

define(`Description_74259_dil', ``8bit addressable latches'')
define(`Param1_74259_dil', 16)
define(`Param2_74259_dil', 300)
define(`PinList_74259_dil', ``S0',`S1',`S2',`Q0',`Q1',`Q2',`Q3',`Gnd',`Q4',`Q5',`Q6',`Q7',`D',`/G',`/Clr',`Vcc'')

define(`Description_74260_dil', ``2 pent-NOR'')
define(`Param1_74260_dil', 14)
define(`Param2_74260_dil', 300)
define(`PinList_74260_dil', ``1A',`1B',`1C',`2A',`1Y',`2Y',`Gnd',`2B',`2C',`2D',`2E',`1D',`1E',`Vcc'')

define(`Description_74261_dil', ``2bit by 4bit parallel binary multiplexors'')
define(`Param1_74261_dil', 16)
define(`Param2_74261_dil', 300)
define(`PinList_74261_dil', ``B3',`B4',`C',`M2',`/Q4',`Q3',`Q2',`Gnd',`Q1',`Q0',`M0',`M1',`B0',`B1',`B2',`Vcc'')

define(`Description_74265_dil', ``4 complementary output gates'')
define(`Param1_74265_dil', 16)
define(`Param2_74265_dil', 300)
define(`PinList_74265_dil', ``1A',`1W',`1Y',`2A',`2B',`2W',`2Y',`Gnd',`3Y',`3W',`3A',`3B',`4Y',`4W',`4A',`Vcc'')

define(`Description_74266_dil', ``4 dual-XOR OC'')
define(`Param1_74266_dil', 14)
define(`Param2_74266_dil', 300)
define(`PinList_74266_dil', ``1A',`1B',`1Y',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4Y',`4A',`4B',`Vcc'')

define(`Description_74273_dil', ``8 D-type FF w. clear'')
define(`Param1_74273_dil', 20)
define(`Param2_74273_dil', 300)
define(`PinList_74273_dil', ``/Clr',`1Q',`1D',`2D',`2Q',`3Q',`3D',`4D',`4Q',`Gnd',`Clk',`5Q',`5D',`6D',`6Q',`7Q',`7D',`8D',`8Q',`Vcc'')

define(`Description_74276_dil', ``4 J-/K FF'')
define(`Param1_74276_dil', 20)
define(`Param2_74276_dil', 300)
define(`PinList_74276_dil', ``/Clr',`1J',`1Clk',`/1K',`1Q',`2Q',`/2K',`2Clk',`2J',`Gnd',`/Pre',`3J',`3Clk',`/3K',`3Q',`4Q',`/4K',`4Clk',`4J',`Vcc'')

define(`Description_74278_dil', ``4bit cascadable priority registers'')
define(`Param1_74278_dil', 14)
define(`Param2_74278_dil', 300)
define(`PinList_74278_dil', ``Strb',`D3',`D4',`P0',`P1',`Y4',`Gnd',`Y3',`Y2',`Y1',`NC',`D1',`D2',`Vcc'')

define(`Description_74279_dil', ``4 /S-/R latches'')
define(`Param1_74279_dil', 16)
define(`Param2_74279_dil', 300)
define(`PinList_74279_dil', ``/1R',`/1S1',`/1S2',`1Q',`/2R',`/2S',`2Q',`Gnd',`3Q',`/3R',`/3S1',`/3S2',`4Q',`/4R',`/4S',`Vcc'')

define(`Description_74280_dil', ``9bit odd/even parity generator/checker'')
define(`Param1_74280_dil', 14)
define(`Param2_74280_dil', 300)
define(`PinList_74280_dil', ``G',`H',`NC',`I',`SumEven',`SumOdd',`Gnd',`A',`B',`C',`D',`E',`F',`Vcc'')

define(`Description_74283_dil', ``4bit binary full adders w. fast carry'')
define(`Param1_74283_dil', 16)
define(`Param2_74283_dil', 300)
define(`PinList_74283_dil', ``Sum2',`B2',`A2',`Sum1',`A1',`B1',`C0',`Gnd',`C4',`Sum4',`B4',`A4',`Sum3',`A3',`B3',`Vcc'')

define(`Description_74285_dil', ``4bit by 4bit parallel binary multipliers'')
define(`Param1_74285_dil', 16)
define(`Param2_74285_dil', 300)
define(`PinList_74285_dil', ``2C',`2B',`2A',`1D',`1A',`1B',`1C',`Gnd',`Y3',`Y2',`Y1',`Y0',`/GB',`/GA',`2D',`Vcc'')

define(`Description_74290_dil', ``decade counter w. clear/set-to-9'')
define(`Param1_74290_dil', 14)
define(`Param2_74290_dil', 300)
define(`PinList_74290_dil', ``R9(1)',`NC',`R9(2)',`Qc',`Qb',`NC',`Gnd',`Qd',`Qa',`CKA',`CKB',`R0(1)',`R0(2)',`Vcc'')

define(`Description_74292_dil', ``programmable divider/timer (2 power 31)'')
define(`Param1_74292_dil', 16)
define(`Param2_74292_dil', 300)
define(`PinList_74292_dil', ``B',`E',`Tp1',`Clk1',`Clk2',`Tp2',`Q',`Gnd',`NC',`A',`/Clr',`NC',`Tp3',`D',`C',`Vcc'')

define(`Description_74293_dil', ``4bit binary counter w. clear'')
define(`Param1_74293_dil', 14)
define(`Param2_74293_dil', 300)
define(`PinList_74293_dil', ``NC',`NC',`NC',`Qc',`Qb',`NC',`Gnd',`Qd',`Qa',`CKA',`CKB',`R0(1)',`R0(2)',`Vcc'')

define(`Description_74294_dil', ``programmable divider/timer (2 power 15)'')
define(`Param1_74294_dil', 16)
define(`Param2_74294_dil', 300)
define(`PinList_74294_dil', ``B',`A',`Tp',`Clk1',`Clk2',`NC',`Q',`Gnd',`NC',`NC',`/Clr',`NC',`NC',`D',`C',`Vcc'')

define(`Description_74295_dil', ``4bit left/right-shift registers 3-state'')
define(`Param1_74295_dil', 14)
define(`Param2_74295_dil', 300)
define(`PinList_74295_dil', ``Ser',`A',`B',`C',`D',`LD-/SH',`Gnd',`OC',`Clk',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_74297_dil', ``digital PLL filters'')
define(`Param1_74297_dil', 16)
define(`Param2_74297_dil', 300)
define(`PinList_74297_dil', ``B',`A',`ENCTR',`K-Clk',`I-D-Clk',`d-/U',`I-D-Out',`Gnd',`Phase-A1',`Phase-B',`XORPD-Out',`ECPD-Out',`Pahse-A2',`D',`C',`Vcc'')

define(`Description_74298_dil', ``4 dual-input multiplexors w. storage'')
define(`Param1_74298_dil', 16)
define(`Param2_74298_dil', 300)
define(`PinList_74298_dil', ``B2',`A2',`A1',`B1',`C2',`D2',`D1',`Gnd',`C1',`WS',`Clk',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_74299_dil', ``8bit universal shift/storage registers'')
define(`Param1_74299_dil', 20)
define(`Param2_74299_dil', 300)
define(`PinList_74299_dil', ``S0',`/G1',`/G2',`G-Qg',`E-Qe',`C-Qc',`A-Qa',`Qa2',`/Clr',`Gnd',`SR',`Clk',`B-Qb',`D-Qd',`F-Qf',`H-Qh',`Qh2',`SL',`S1',`Vcc'')

define(`Description_74320_dil', ``crystal-controlled oscillator'')
define(`Param1_74320_dil', 16)
define(`Param2_74320_dil', 300)
define(`PinList_74320_dil', ``Tank1',`Tank2',`Gnd1',`FFQ',`FFD',`NC',`F',`Gnd2',`/F+',`F+',`Vcc+',`/F',`NC',`Xtal1',`Xtal2',`Vcc'')

define(`Description_74321_dil', ``crystal-controlled oscillator w. F/2,F/4 outputs'')
define(`Param1_74321_dil', 16)
define(`Param2_74321_dil', 300)
define(`PinList_74321_dil', ``Tank1',`Tank2',`Gnd1',`FFQ',`FFD',`F/4',`F',`Gnd2',`/F+',`F+',`Vcc+',`/F',`F/2',`Xtal1',`Xtal2',`Vcc'')

define(`Description_74322_dil', ``8bit shift register w. sign extend'')
define(`Param1_74322_dil', 20)
define(`Param2_74322_dil', 300)
define(`PinList_74322_dil', ``/G',`S-/P',`D0',`a-Qa',`C-Qc',`E-Qe',`G-Qg',`/OE',`/Clr',`Gnd',`Clk',`Qh+',`H-Qh',`F-Qf',`D-Qd',`B-Qb',`D1',`/SE',`DS',`Vcc'')

define(`Description_74323_dil', ``8bit universal shift/storage register'')
define(`Param1_74323_dil', 20)
define(`Param2_74323_dil', 300)
define(`PinList_74323_dil', ``S0',`/G1',`/G2',`G-Qg',`E-Qe',`C-Qc',`A-Qa',`Qa+',`/Clr',`Gnd',`SR',`Clk',`B-Qb',`D-Qd',`F-Qf',`H-Qh',`Qh+',`SL',`S1',`Vcc'')

define(`Description_74348_dil', ``8-to-3 priority encode 3-state'')
define(`Param1_74348_dil', 16)
define(`Param2_74348_dil', 300)
define(`PinList_74348_dil', ``4',`5',`6',`7',`W1',`A2',`A1',`Gnd',`A0',`0',`1',`2',`3',`GS',`E0',`Vcc'')

define(`Description_74352_dil', ``2 4-to-1 data selector/multiplexor'')
define(`Param1_74352_dil', 16)
define(`Param2_74352_dil', 300)
define(`PinList_74352_dil', ``/1G',`B',`1C3',`1C2',`1C1',`1C0',`1Y',`Gnd',`2Y',`2C0',`2C1',`2C2',`2C3',`A',`/2G',`Vcc'')

define(`Description_74353_dil', ``2 4-to-1 data selector/multiplexor 3-state'')
define(`Param1_74353_dil', 16)
define(`Param2_74353_dil', 300)
define(`PinList_74353_dil', ``/1G',`B',`1C3',`1C2',`1C1',`1C0',`1Y',`Gnd',`2Y',`2C0',`2C1',`2C2',`2C3',`A',`/2G',`Vcc'')

define(`Description_74354_dil', ``8-to-1 data selector/multiplexor/register transparent 3-state'')
define(`Param1_74354_dil', 20)
define(`Param2_74354_dil', 300)
define(`PinList_74354_dil', ``D7',`D6',`D5',`D4',`D3',`D2',`D1',`D0',`/DC',`Gnd',`/SC',`S2',`S1',`S0',`/G1',`/G2',`G3',`W',`Y',`Vcc'')

define(`Description_74355_dil', ``8-to-1 data selector/multiplexor/register transparent OC'')
define(`Param1_74355_dil', 20)
define(`Param2_74355_dil', 300)
define(`PinList_74355_dil', ``D7',`D6',`D5',`D4',`D3',`D2',`D1',`D0',`/DC',`Gnd',`/SC',`S2',`S1',`S0',`/G1',`/G2',`G3',`W',`Y',`Vcc'')

define(`Description_74356_dil', ``8-to-1 data selector/multiplexor/register edge-triggered 3-state'')
define(`Param1_74356_dil', 20)
define(`Param2_74356_dil', 300)
define(`PinList_74356_dil', ``D7',`D6',`D5',`D4',`D3',`D2',`D1',`D0',`Clk',`Gnd',`/SC',`S2',`S1',`S0',`/G1',`/G2',`G3',`W',`Y',`Vcc'')

define(`Description_74365_dil', ``6 bus drivers OC'')
define(`Param1_74365_dil', 16)
define(`Param2_74365_dil', 300)
define(`PinList_74365_dil', ``/G1',`1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`/G2',`Vcc'')

define(`Description_74366_dil', ``6 bus drivers OC w. inverting output'')
define(`Param1_74366_dil', 16)
define(`Param2_74366_dil', 300)
define(`PinList_74366_dil', ``/G1',`1A',`1Y',`2A',`2Y',`3A',`3Y',`Gnd',`4Y',`4A',`5Y',`5A',`6Y',`6A',`/G2',`Vcc'')

define(`Description_74367_dil', ``6 bus drivers OC'')
define(`Param1_74367_dil', 16)
define(`Param2_74367_dil', 300)
define(`PinList_74367_dil', ``/G1',`1A1',`1Y1',`1A2',`1Y2',`1A3',`1Y3',`Gnd',`1Y4',`1A4',`2Y1',`2A1',`2Y2',`2A2',`/G2',`Vcc'')

define(`Description_74368_dil', ``6 bus drivers OC w. inverting output'')
define(`Param1_74368_dil', 16)
define(`Param2_74368_dil', 300)
define(`PinList_74368_dil', ``/G1',`1A1',`1Y1',`1A2',`1Y2',`1A3',`1Y3',`Gnd',`1Y4',`1A4',`2Y1',`2A1',`2Y2',`2A2',`/G2',`Vcc'')

define(`Description_74373_dil', ``8 D-type transparent latches 3-state'')
define(`Param1_74373_dil', 20)
define(`Param2_74373_dil', 300)
define(`PinList_74373_dil', ``/OC',`1Q',`1D',`2D',`2Q',`3Q',`3D',`4D',`4Q',`Gnd',`C',`5Q',`5D',`6D',`6Q',`7Q',`7D',`8D',`8Q',`Vcc'')

define(`Description_74374_dil', ``8 edge FF 3-state'')
define(`Param1_74374_dil', 20)
define(`Param2_74374_dil', 300)
define(`PinList_74374_dil', ``/OC',`1Q',`1D',`2D',`2Q',`3Q',`3D',`4D',`4Q',`Gnd',`C',`5Q',`5D',`6D',`6Q',`7Q',`7D',`8D',`8Q',`Vcc'')

define(`Description_74375_dil', ``4bit bistable latch'')
define(`Param1_74375_dil', 16)
define(`Param2_74375_dil', 300)
define(`PinList_74375_dil', ``1D',`/1Q',`1Q',`1C-2C',`2Q',`/2Q',`2D',`Gnd',`3D',`/3Q',`3Q',`3C-4C',`4Q',`/4Q',`4D',`Vcc'')

define(`Description_74376_dil', ``4 JK FF'')
define(`Param1_74376_dil', 16)
define(`Param2_74376_dil', 300)
define(`PinList_74376_dil', ``/Clr',`1J',`/1K',`1Q',`2Q',`/2K',`2J',`Gnd',`Clk',`3J',`/3K',`3Q',`4Q',`/4K',`4J',`Vcc'')

define(`Description_74377_dil', ``8 FF w. single rail output'')
define(`Param1_74377_dil', 20)
define(`Param2_74377_dil', 300)
define(`PinList_74377_dil', ``/G',`1Q',`1D',`2D',`2Q',`3Q',`3D',`4D',`4Q',`Gnd',`Clk',`5Q',`5D',`6D',`6Q',`7Q',`7D',`8D',`8Q',`Vcc'')

define(`Description_74378_dil', ``6 FF w. single rail output'')
define(`Param1_74378_dil', 16)
define(`Param2_74378_dil', 300)
define(`PinList_74378_dil', ``/G',`1Q',`1D',`2D',`2Q',`3D',`3Q',`Gnd',`Clk',`4Q',`4D',`5Q',`5D',`6D',`6Q',`Vcc'')

define(`Description_74379_dil', ``4 FF w. double rail output'')
define(`Param1_74379_dil', 16)
define(`Param2_74379_dil', 300)
define(`PinList_74379_dil', ``/G',`1Q',`/1Q',`1D',`2D',`/2Q',`2Q',`Gnd',`Clk',`3Q',`/3Q',`3D',`4D',`/4Q',`4Q',`Vcc'')

define(`Description_74381_dil', ``ALU function generator w. look-ahead carry'')
define(`Param1_74381_dil', 20)
define(`Param2_74381_dil', 300)
define(`PinList_74381_dil', ``A1',`B1',`A0',`B0',`S0',`S1',`S2',`F0',`F1',`Gnd',`F2',`F3',`/G',`/P',`Cn',`B3',`A3',`B2',`A2',`Vcc'')

define(`Description_74382_dil', ``ALU function generator w. overflow/ripple-carry'')
define(`Param1_74382_dil', 20)
define(`Param2_74382_dil', 300)
define(`PinList_74382_dil', ``A1',`B1',`A0',`B0',`S0',`S1',`S2',`F0',`F1',`Gnd',`F2',`F3',`Ovr',`Cn+4',`Cn',`B3',`A3',`B2',`A2',`Vcc'')

define(`Description_74384_dil', ``8bit by 1bit twos-complement multiplier'')
define(`Param1_74384_dil', 16)
define(`Param2_74384_dil', 300)
define(`PinList_74384_dil', ``/Clr',`X3',`X2',`X1',`X0',`Prod',`Clk',`Gnd',`Mode',`K',`X7',`X6',`X5',`X4',`Y',`Vcc'')

define(`Description_74385_dil', ``4 serial adder/substractor'')
define(`Param1_74385_dil', 20)
define(`Param2_74385_dil', 300)
define(`PinList_74385_dil', ``Clk',`1Sum',`1S-/A',`1B',`1A',`2A',`2B',`2S-/A',`2Sum',`Gnd',`Clr',`3Sum',`3S-/A',`3B',`3A',`4A',`4B',`4S-/A',`4Sum',`Vcc'')

define(`Description_74386_dil', ``4 dual-XOR'')
define(`Param1_74386_dil', 14)
define(`Param2_74386_dil', 300)
define(`PinList_74386_dil', ``1A',`1B',`1Y',`2Y',`2A',`2B',`Gnd',`3A',`3B',`3Y',`4Y',`4A',`4B',`Vcc'')

define(`Description_74390_dil', ``2 decade counter w. individual clocks/clear (divide by 2/5)'')
define(`Param1_74390_dil', 16)
define(`Param2_74390_dil', 300)
define(`PinList_74390_dil', ``1ClkA',`1Clr',`1Qa',`1ClkB',`1Qb',`1Qc',`1Qd',`Gnd',`2Qd',`2Qc',`2Qb',`2ClkB',`2Qa',`2Clr',`2ClkA',`Vcc'')

define(`Description_74393_dil', ``2 4bit binary counter w. individual clocks/clear'')
define(`Param1_74393_dil', 14)
define(`Param2_74393_dil', 300)
define(`PinList_74393_dil', ``1Clk',`1Clr',`1Qa',`1Qb',`1Qc',`1Qd',`Gnd',`2Qd',`2Qc',`2Qb',`2Qa',`2Clr',`2Clk',`Vcc'')

define(`Description_74395_dil', ``4bit cascadable shift register 3-state'')
define(`Param1_74395_dil', 16)
define(`Param2_74395_dil', 300)
define(`PinList_74395_dil', ``/Clr',`Ser',`A',`B',`C',`D',`Ld-/Sh',`Gnd',`/OC',`Clk',`Qd+',`Qd',`Qc',`Qb',`Qa',`Vcc'')

define(`Description_74396_dil', ``8 storage register'')
define(`Param1_74396_dil', 16)
define(`Param2_74396_dil', 300)
define(`PinList_74396_dil', ``2Q1',`1Q1',`D1',`2Q2',`1Q2',`D2',`Clk',`Gnd',`D3',`1Q3',`2Q3',`D4',`1Q4',`2Q4',`/G',`Vcc'')

define(`Description_74399_dil', ``4 dual-input multiplexor w. storage'')
define(`Param1_74399_dil', 16)
define(`Param2_74399_dil', 300)
define(`PinList_74399_dil', ``WS',`Qa',`A1',`A2',`B2',`B1',`Qb',`Gnd',`Clk',`Qc',`C1',`C2',`D2',`D1',`Qd',`Vcc'')

define(`Description_74422_dil', ``retriggerable monostable multivibrator w. internal resistor'')
define(`Param1_74422_dil', 14)
define(`Param2_74422_dil', 300)
define(`PinList_74422_dil', ``A1',`A2',`B1',`B2',`/Clr',`/Q',`Gnd',`Q',`Rint',`NC',`Cext',`NC',`Rext-Cext',`Vcc'')

define(`Description_74423_dil', ``retriggerable monostable multivibrator'')
define(`Param1_74423_dil', 16)
define(`Param2_74423_dil', 300)
define(`PinList_74423_dil', ``1A',`1B',`/1Clr',`/1Q',`2Q',`2Cext',`2Rext-Cext',`Gnd',`2A',`2B',`/2Clr',`/2Q',`1Q',`1Cext',`1Rext-Cext',`Vcc'')

define(`Description_74440_dil', ``4 tridirectional bus tranceiver OC'')
define(`Param1_74440_dil', 20)
define(`Param2_74440_dil', 300)
define(`PinList_74440_dil', ``/CS',`B1',`C1',`C2',`B2',`B3',`C3',`C4',`B4',`Gnd',`S0',`S1',`A4',`A3',`A2',`A1',`/GA',`/GB',`/GC',`Vcc'')

define(`Description_74441_dil', ``4 tridirectional inverting bus tranceiver OC'')
define(`Param1_74441_dil', 20)
define(`Param2_74441_dil', 300)
define(`PinList_74441_dil', ``/CS',`B1',`C1',`C2',`B2',`B3',`C3',`C4',`B4',`Gnd',`S0',`S1',`A4',`A3',`A2',`A1',`/GA',`/GB',`/GC',`Vcc'')

define(`Description_74442_dil', ``4 tridirectional bus tranceiver 3-state'')
define(`Param1_74442_dil', 20)
define(`Param2_74442_dil', 300)
define(`PinList_74442_dil', ``/CS',`B1',`C1',`C2',`B2',`B3',`C3',`C4',`B4',`Gnd',`S0',`S1',`A4',`A3',`A2',`A1',`/GA',`/GB',`/GC',`Vcc'')

define(`Description_74443_dil', ``4 tridirectional inverting bus tranceiver 3-state'')
define(`Param1_74443_dil', 20)
define(`Param2_74443_dil', 300)
define(`PinList_74443_dil', ``/CS',`B1',`C1',`C2',`B2',`B3',`C3',`C4',`B4',`Gnd',`S0',`S1',`A4',`A3',`A2',`A1',`/GA',`/GB',`/GC',`Vcc'')

define(`Description_74444_dil', ``4 tridirectional true/inverting bus tranceiver 3-state'')
define(`Param1_74444_dil', 20)
define(`Param2_74444_dil', 300)
define(`PinList_74444_dil', ``/CS',`B1',`C1',`C2',`B2',`B3',`C3',`C4',`B4',`Gnd',`S0',`S1',`A4',`A3',`A2',`A1',`/GA',`/GB',`/GC',`Vcc'')

define(`Description_74446_dil', ``4 inverting bus tranceiver w. individual direction control'')
define(`Param1_74446_dil', 16)
define(`Param2_74446_dil', 300)
define(`PinList_74446_dil', ``/GBA',`A1',`Dir2',`A2',`A3',`Dir3',`A4',`Gnd',`B4',`Dir4',`B3',`B2',`Dir1',`B1',`/GAB',`Vcc'')

define(`Description_74449_dil', ``4 bus tranceiver w. individual direction control'')
define(`Param1_74449_dil', 16)
define(`Param2_74449_dil', 300)
define(`PinList_74449_dil', ``/GBA',`A1',`Dir2',`A2',`A3',`Dir3',`A4',`Gnd',`B4',`Dir4',`B3',`B2',`Dir1',`B1',`/GAB',`Vcc'')

define(`Description_74465_dil', ``8 buffer 3-state'')
define(`Param1_74465_dil', 20)
define(`Param2_74465_dil', 300)
define(`PinList_74465_dil', ``/G1',`A1',`Y1',`A2',`Y2',`A3',`Y3',`A4',`Y4',`Gnd',`Y5',`A5',`Y6',`A6',`Y7',`A7',`Y8',`A8',`/G2',`Vcc'')

define(`Description_74466_dil', ``8 invering buffer 3-state'')
define(`Param1_74466_dil', 20)
define(`Param2_74466_dil', 300)
define(`PinList_74466_dil', ``/G1',`A1',`Y1',`A2',`Y2',`A3',`Y3',`A4',`Y4',`Gnd',`Y5',`A5',`Y6',`A6',`Y7',`A7',`Y8',`A8',`/G2',`Vcc'')

define(`Description_74467_dil', ``8 buffer 3-state w. seperate enable signals'')
define(`Param1_74467_dil', 20)
define(`Param2_74467_dil', 300)
define(`PinList_74467_dil', ``/1G',`1A1',`1Y1',`1A2',`1Y2',`1A3',`1Y3',`1A4',`1Y4',`Gnd',`2Y1',`2A1',`2Y2',`2A2',`2Y3',`2A3',`2Y4',`2A4',`/2G',`Vcc'')

define(`Description_74468_dil', ``8 inverting buffer 3-state w. seperate enable signals'')
define(`Param1_74468_dil', 20)
define(`Param2_74468_dil', 300)
define(`PinList_74468_dil', ``/1G',`1A1',`1Y1',`1A2',`1Y2',`1A3',`1Y3',`1A4',`1Y4',`Gnd',`2Y1',`2A1',`2Y2',`2A2',`2Y3',`2A3',`2Y4',`2A4',`/2G',`Vcc'')

define(`Description_74490_dil', ``4 4bit decade counter'')
define(`Param1_74490_dil', 16)
define(`Param2_74490_dil', 300)
define(`PinList_74490_dil', ``1Clk',`1Clr',`1Qa',`1Set9',`1Qb',`1Qc',`1Qd',`Gnd',`2Qd',`2Qc',`2Qb',`2Set9',`2Qa',`2Clr',`2Clk',`Vcc'')

define(`Description_74518_dil', ``8bit identity comperator OC w. input pull-up'')
define(`Param1_74518_dil', 20)
define(`Param2_74518_dil', 300)
define(`PinList_74518_dil', ``/OEN',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`P=Q',`Vcc'')

define(`Description_74519_dil', ``8bit identity comperator OC'')
define(`Param1_74519_dil', 20)
define(`Param2_74519_dil', 300)
define(`PinList_74519_dil', ``/OEN',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`P=Q',`Vcc'')

define(`Description_74520_dil', ``8bit identity comperator w. input pull-up'')
define(`Param1_74520_dil', 20)
define(`Param2_74520_dil', 300)
define(`PinList_74520_dil', ``/OEN',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74521_dil', ``8bit identity comperator'')
define(`Param1_74521_dil', 20)
define(`Param2_74521_dil', 300)
define(`PinList_74521_dil', ``/OEN',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74522_dil', ``8bit identity comperator OC w. input pull-up'')
define(`Param1_74522_dil', 20)
define(`Param2_74522_dil', 300)
define(`PinList_74522_dil', ``/OEN',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74538_dil', ``3-to-8 decoder 3-state'')
define(`Param1_74538_dil', 20)
define(`Param2_74538_dil', 300)
define(`PinList_74538_dil', ``Y2',`Y1',`Y0',`/OE1',`/OE2',`A',`B',`Y5',`Y6',`Gnd',`Y7',`AL',`G1',`G2',`/G3',`/G4',`C',`Y4',`Y3',`Vcc'')

define(`Description_74540_dil', ``8 inverting buffer/driver 3-state'')
define(`Param1_74540_dil', 20)
define(`Param2_74540_dil', 300)
define(`PinList_74540_dil', ``/G1',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`Y8',`Y7',`Y6',`Y5',`Y4',`Y3',`Y2',`Y1',`/G2',`Vcc'')

define(`Description_74541_dil', ``8 buffer/driver 3-state'')
define(`Param1_74541_dil', 20)
define(`Param2_74541_dil', 300)
define(`PinList_74541_dil', ``/G1',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`Y8',`Y7',`Y6',`Y5',`Y4',`Y3',`Y2',`Y1',`/G2',`Vcc'')

define(`Description_74573_dil', ``8 D-type transparent latch 3-state'')
define(`Param1_74573_dil', 20)
define(`Param2_74573_dil', 300)
define(`PinList_74573_dil', ``/Oe',`1D',`2D',`3D',`4D',`5D',`6D',`7D',`8D',`Gnd',`Le',`8Q',`7Q',`6Q',`5Q',`4Q',`3Q',`2Q',`1Q',`Vcc'')

define(`Description_74574_dil', ``8 D-type edge FF 3-state'')
define(`Param1_74574_dil', 20)
define(`Param2_74574_dil', 300)
define(`PinList_74574_dil', ``/Oe',`1D',`2D',`3D',`4D',`5D',`6D',`7D',`8D',`Gnd',`Clk',`8Q',`7Q',`6Q',`5Q',`4Q',`3Q',`2Q',`1Q',`Vcc'')

define(`Description_74575_dil', ``8 D-type edge FF 3-state w. sync. clear'')
define(`Param1_74575_dil', 20)
define(`Param2_74575_dil', 300)
define(`PinList_74575_dil', ``/Oe',`1D',`2D',`3D',`4D',`5D',`6D',`7D',`8D',`Gnd',`Clk',`8Q',`7Q',`6Q',`5Q',`4Q',`3Q',`2Q',`1Q',`Vcc'')

define(`Description_74580_dil', ``8 D-type transparent latch 3-state w. inverted output'')
define(`Param1_74580_dil', 20)
define(`Param2_74580_dil', 300)
define(`PinList_74580_dil', ``/Oe',`1D',`2D',`3D',`4D',`5D',`6D',`7D',`8D',`Gnd',`Le',`8Q',`7Q',`6Q',`5Q',`4Q',`3Q',`2Q',`1Q',`Vcc'')

define(`Description_74590_dil', ``8bit binary counter w. output register 3-state'')
define(`Param1_74590_dil', 16)
define(`Param2_74590_dil', 300)
define(`PinList_74590_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`/RCO',`/CClr',`CCK',`/CCKEn',`RCK',`/G',`Qa',`Vcc'')

define(`Description_74591_dil', ``8bit binary counter w. output register OC'')
define(`Param1_74591_dil', 16)
define(`Param2_74591_dil', 300)
define(`PinList_74591_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`/RCO',`/CClr',`CCK',`/CCKEn',`RCK',`/G',`Qa',`Vcc'')

define(`Description_74592_dil', ``8bit counter w. load/clear'')
define(`Param1_74592_dil', 16)
define(`Param2_74592_dil', 300)
define(`PinList_74592_dil', ``B',`C',`D',`E',`F',`G',`H',`Gnd',`/Rc0',`/Clr',`Clk',`/ClkEn',`RClk',`/Load',`A',`Vcc'')

define(`Description_74593_dil', ``8bit binary counter w. load/clear and 3-state IO'')
define(`Param1_74593_dil', 20)
define(`Param2_74593_dil', 300)
define(`PinList_74593_dil', ``A-Qa',`B-Qb',`C-Qc',`D-Qd',`E-Qe',`F-Qf',`G-Qf',`H-Qh',`/CLoad',`Gnd',`/RCO',`/CClr',`CCK',`/CCKEn',`CCKEn',`RCK',`/RCKEn',`/G',`G',`Vcc'')

define(`Description_74594_dil', ``8bit shift register w. buffered output latch'')
define(`Param1_74594_dil', 16)
define(`Param2_74594_dil', 300)
define(`PinList_74594_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`Qh+',`/SRClr',`/SRCK',`RCK',`/RClr',`SER',`Qa',`Vcc'')

define(`Description_74595_dil', ``8bit shift register w. output latch 3-state'')
define(`Param1_74595_dil', 16)
define(`Param2_74595_dil', 300)
define(`PinList_74595_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`Qh+',`/SRClr',`SRCK',`RCK',`/G',`SER',`Qa',`Vcc'')

define(`Description_74596_dil', ``8bit shift register w. output latch OC'')
define(`Param1_74596_dil', 16)
define(`Param2_74596_dil', 300)
define(`PinList_74596_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`Qh+',`/SRClr',`SRCK',`RCK',`/G',`SER',`Qa',`Vcc'')

define(`Description_74597_dil', ``8bit shift register w. input latch'')
define(`Param1_74597_dil', 16)
define(`Param2_74597_dil', 300)
define(`PinList_74597_dil', ``B',`C',`D',`E',`F',`G',`H',`Gnd',`Qh+',`/SRClr',`SRCK',`RCK',`/SRLoad',`SER',`A',`Vcc'')

define(`Description_74598_dil', ``8bit shift register w. input register/parallel 3-state IO'')
define(`Param1_74598_dil', 20)
define(`Param2_74598_dil', 300)
define(`PinList_74598_dil', ``A-Qa',`B-Qb',`C-Qc',`D-Qd',`E-Qe',`F-Qf',`G-Qg',`H-Qh',`/SRLoad',`Gnd',`Qh+',`/SRClr',`SRCK',`/SRCKEn',`RCK',`/G',`Ser1',`Ser0',`DS',`Vcc'')

define(`Description_74599_dil', ``8bit shift register w. output latch OC'')
define(`Param1_74599_dil', 16)
define(`Param2_74599_dil', 300)
define(`PinList_74599_dil', ``Qb',`Qc',`Qd',`Qe',`Qf',`Qg',`Qh',`Gnd',`Qh+',`/SRClr',`/SRCK',`RCK',`/RClr',`SER',`Qa',`Vcc'')

define(`Description_74604_dil', ``8 2-input maximum speed multiplexed latch 3-state'')
define(`Param1_74604_dil', 28)
define(`Param2_74604_dil', 300)
define(`PinList_74604_dil', ``Clk',`A-/B',`A1',`B1',`A2',`B2',`A3',`B3',`A4',`B4',`Y4',`Y3',`Y2',`Gnd',`Y1',`Y5',`Y6',`Y7',`Y8',`B8',`A8',`B7',`A7',`B6',`A6',`B5',`A5',`Vcc'')

define(`Description_74606_dil', ``8 2-input glitch-free multiplexed latch 3-state'')
define(`Param1_74606_dil', 28)
define(`Param2_74606_dil', 300)
define(`PinList_74606_dil', ``Clk',`A-/B',`A1',`B1',`A2',`B2',`A3',`B3',`A4',`B4',`Y4',`Y3',`Y2',`Gnd',`Y1',`Y5',`Y6',`Y7',`Y8',`B8',`A8',`B7',`A7',`B6',`A6',`B5',`A5',`Vcc'')

define(`Description_74607_dil', ``8 2-input glitch-free multiplexed latch OC'')
define(`Param1_74607_dil', 28)
define(`Param2_74607_dil', 300)
define(`PinList_74607_dil', ``Clk',`A-/B',`A1',`B1',`A2',`B2',`A3',`B3',`A4',`B4',`Y4',`Y3',`Y2',`Gnd',`Y1',`Y5',`Y6',`Y7',`Y8',`B8',`A8',`B7',`A7',`B6',`A6',`B5',`A5',`Vcc'')

define(`Description_74620_dil', ``8 inverting bus tranceivers 3-state'')
define(`Param1_74620_dil', 20)
define(`Param2_74620_dil', 300)
define(`PinList_74620_dil', ``GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`Vcc'')

define(`Description_74621_dil', ``8 bus tranceivers OC'')
define(`Param1_74621_dil', 20)
define(`Param2_74621_dil', 300)
define(`PinList_74621_dil', ``GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`Vcc'')

define(`Description_74623_dil', ``8 bus tranceivers 3-state'')
define(`Param1_74623_dil', 20)
define(`Param2_74623_dil', 300)
define(`PinList_74623_dil', ``GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`Vcc'')

define(`Description_74624_dil', ``voltage controlled oscillator w. enable and complement output'')
define(`Param1_74624_dil', 14)
define(`Param2_74624_dil', 300)
define(`PinList_74624_dil', ``Osc-Gnd',`RNG',`CX1',`CX2',`/En',`Y',`Gnd',`Z',`Vcc',`NC',`NC',`NC',`FreqCont',`Osc-Vcc'')

define(`Description_74625_dil', ``2 voltage controlled oscillator w. complement output'')
define(`Param1_74625_dil', 16)
define(`Param2_74625_dil', 300)
define(`PinList_74625_dil', ``Gnd',`1Z',`1Y',`1CX1',`1CX2',`1FC',`1Osc-Vcc',`1Osc-Gnd',`2Osc-Gnd',`2Osc-Vcc',`2FC',`2CX2',`2CX1',`2Y',`2Z',`Vcc'')

define(`Description_74626_dil', ``2 voltage controlled oscillator w. enable and complement output'')
define(`Param1_74626_dil', 16)
define(`Param2_74626_dil', 300)
define(`PinList_74626_dil', ``Gnd',`1Z',`1Y',`/1EN',`1CX1',`1CX2',`Osc-Vcc',`Osc-Gnd',`1FC',`2FC',`2CX2',`2CX1',`/2EN',`2Y',`2Z',`Vcc'')

define(`Description_74627_dil', ``2 voltage controlled oscillator'')
define(`Param1_74627_dil', 14)
define(`Param2_74627_dil', 300)
define(`PinList_74627_dil', ``1Osc-Vcc',`1FC',`1CX1',`1CX2',`1Osc-Gnd',`1Y',`Gnd',`2Y',`2Osc-Gnd',`2CX2',`2CX1',`2FC',`2Osc-Vcc',`Vcc'')

define(`Description_74628_dil', ``voltage controlled oscillator w. enable and complement output'')
define(`Param1_74628_dil', 14)
define(`Param2_74628_dil', 300)
define(`PinList_74628_dil', ``Osc-Gnd',`RNG',`CX1',`CX2',`/EN',`Y',`Gnd',`Z',`Vcc',`NC',`RX',`RX',`FC',`Osc-Vcc'')

define(`Description_74629_dil', ``2 controlled oscillator w. enable'')
define(`Param1_74629_dil', 16)
define(`Param2_74629_dil', 300)
define(`PinList_74629_dil', ``2FC',`1FC',`1RNG',`1CX1',`1CX2',`/1EN',`1Y',`Osc-Gnd',`Gnd',`2Y',`/2EN',`2CX1',`2CX2',`2RNG',`Osc-Vcc',`Vcc'')

define(`Description_74630_dil', ``16bit parallel error detection/correction 3-state'')
define(`Param1_74630_dil', 28)
define(`Param2_74630_dil', 300)
define(`PinList_74630_dil', ``DEF',`DB0',`DB1',`DB2',`DB3',`DB4',`DB5',`DB6',`DB7',`DB8',`DB9',`DB10',`DB11',`Gnd',`DB12',`DB13',`DB14',`DB15',`CB5',`CB4',`CB3',`CB2',`CB1',`CB0',`S0',`S1',`SEF',`Vcc'')

define(`Description_74631_dil', ``16bit parallel error detection/correction OC'')
define(`Param1_74631_dil', 28)
define(`Param2_74631_dil', 300)
define(`PinList_74631_dil', ``DEF',`DB0',`DB1',`DB2',`DB3',`DB4',`DB5',`DB6',`DB7',`DB8',`DB9',`DB10',`DB11',`Gnd',`DB12',`DB13',`DB14',`DB15',`CB5',`CB4',`CB3',`CB2',`CB1',`CB0',`S0',`S1',`SEF',`Vcc'')

define(`Description_74636_dil', ``8bit parallel error detection/correction 3-state'')
define(`Param1_74636_dil', 20)
define(`Param2_74636_dil', 300)
define(`PinList_74636_dil', ``DEF',`DB0',`DB1',`DB2',`DB3',`DB4',`DB5',`DB6',`Db7',`Gnd',`CB4',`NC',`CB3',`CB2',`CB1',`CB0',`S0',`S1',`SEF',`Vcc'')

define(`Description_74637_dil', ``8bit parallel error detection/correction OC'')
define(`Param1_74637_dil', 20)
define(`Param2_74637_dil', 300)
define(`PinList_74637_dil', ``DEF',`DB0',`DB1',`DB2',`DB3',`DB4',`DB5',`DB6',`Db7',`Gnd',`CB4',`NC',`CB3',`CB2',`CB1',`CB0',`S0',`S1',`SEF',`Vcc'')

define(`Description_74638_dil', ``8 inverting bus tranceiver OC A-output, 3-state B-output'')
define(`Param1_74638_dil', 20)
define(`Param2_74638_dil', 300)
define(`PinList_74638_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`Vcc'')

define(`Description_74639_dil', ``8 bus tranceiver OC A-output, 3-state B-output'')
define(`Param1_74639_dil', 20)
define(`Param2_74639_dil', 300)
define(`PinList_74639_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`Vcc'')

define(`Description_74640_dil', ``8 bus tranceiver 3-state w. inverting logic'')
define(`Param1_74640_dil', 20)
define(`Param2_74640_dil', 300)
define(`PinList_74640_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/EN',`Vcc'')

define(`Description_74641_dil', ``8 bus tranceiver OC'')
define(`Param1_74641_dil', 20)
define(`Param2_74641_dil', 300)
define(`PinList_74641_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/EN',`Vcc'')

define(`Description_74642_dil', ``8 bus tranceiver OC w. inverting logic'')
define(`Param1_74642_dil', 20)
define(`Param2_74642_dil', 300)
define(`PinList_74642_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/EN',`Vcc'')

define(`Description_74644_dil', ``8 bus tranceiver OC w. inverting/normal logic'')
define(`Param1_74644_dil', 20)
define(`Param2_74644_dil', 300)
define(`PinList_74644_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/EN',`Vcc'')

define(`Description_74645_dil', ``8 bus tranceiver 3-state'')
define(`Param1_74645_dil', 20)
define(`Param2_74645_dil', 300)
define(`PinList_74645_dil', ``DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/EN',`Vcc'')

define(`Description_74646_dil', ``8 bus tranceiver/register 3-state'')
define(`Param1_74646_dil', 24)
define(`Param2_74646_dil', 300)
define(`PinList_74646_dil', ``CAB',`SAB',`DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`SBA',`CBA',`Vcc'')

define(`Description_74647_dil', ``8 bus tranceiver/register OC'')
define(`Param1_74647_dil', 24)
define(`Param2_74647_dil', 300)
define(`PinList_74647_dil', ``CAB',`SAB',`DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`SBA',`CBA',`Vcc'')

define(`Description_74648_dil', ``8 inverting bus tranceiver/register 3-state'')
define(`Param1_74648_dil', 24)
define(`Param2_74648_dil', 300)
define(`PinList_74648_dil', ``CAB',`SAB',`DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`SBA',`CBA',`Vcc'')

define(`Description_74649_dil', ``8 inverting bus tranceiver/register OC'')
define(`Param1_74649_dil', 24)
define(`Param2_74649_dil', 300)
define(`PinList_74649_dil', ``CAB',`SAB',`DIR',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/G',`SBA',`CBA',`Vcc'')

define(`Description_74651_dil', ``8 inverting bus tranceiver/register 3-state A-output, 3-state B-output'')
define(`Param1_74651_dil', 24)
define(`Param2_74651_dil', 300)
define(`PinList_74651_dil', ``CAB',`SAB',`GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`SA',`CBA',`Vcc'')

define(`Description_74652_dil', ``8 bus tranceiver/register 3-state A-output, 3-state B-output'')
define(`Param1_74652_dil', 24)
define(`Param2_74652_dil', 300)
define(`PinList_74652_dil', ``CAB',`SAB',`GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`SA',`CBA',`Vcc'')

define(`Description_74653_dil', ``8 inverting bus tranceiver/register OC A-output, 3-state B-output'')
define(`Param1_74653_dil', 24)
define(`Param2_74653_dil', 300)
define(`PinList_74653_dil', ``CAB',`SAB',`GAB',`A1',`A2',`A3',`A4',`A5',`A6',`A7',`A8',`Gnd',`B8',`B7',`B6',`B5',`B4',`B3',`B2',`B1',`/GBA',`SA',`CBA',`Vcc'')

define(`Description_74668_dil', ``4bit synchronous decade up/down counter'')
define(`Param1_74668_dil', 16)
define(`Param2_74668_dil', 300)
define(`PinList_74668_dil', ``U-/D',`Clk',`A',`B',`C',`D',`/ENP',`Gnd',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

define(`Description_74669_dil', ``4bit synchronous binary up/down counter'')
define(`Param1_74669_dil', 16)
define(`Param2_74669_dil', 300)
define(`PinList_74669_dil', ``U-/D',`Clk',`A',`B',`C',`D',`/ENP',`Gnd',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

define(`Description_74670_dil', ``4-by-4 register file 3-state'')
define(`Param1_74670_dil', 16)
define(`Param2_74670_dil', 300)
define(`PinList_74670_dil', ``D2',`D3',`D4',`Rb',`Ra',`Q4',`Q3',`Gnd',`Q2',`Q1',`/Gr',`/Gw',`Wb',`Wa',`D1',`Vcc'')

define(`Description_74671_dil', ``4bit universal shift register/latch 3-state w. direct clear'')
define(`Param1_74671_dil', 20)
define(`Param2_74671_dil', 300)
define(`PinList_74671_dil', ``Ser-R',`SRCK',`A',`B',`C',`D',`Ser-L',`/SRClr',`RCK',`Gnd',`R-/S',`/G',`S1',`S0',`Qd',`Qc',`Qb',`Qa',`CASC',`Vcc'')

define(`Description_74672_dil', ``4bit universal shift register/latch 3-state w. sync. clear'')
define(`Param1_74672_dil', 20)
define(`Param2_74672_dil', 300)
define(`PinList_74672_dil', ``Ser-R',`SRCK',`A',`B',`C',`D',`Ser-L',`/SRClr',`RCK',`Gnd',`R-/S',`/G',`S1',`S0',`Qd',`Qc',`Qb',`Qa',`CASC',`Vcc'')

define(`Description_74673_dil', ``16bit shift register w. 16bit parallel out'')
define(`Param1_74673_dil', 24)
define(`Param2_74673_dil', 300)
define(`PinList_74673_dil', ``/CS',`SH-Clk',`R-/W',`/StrClr',`Mode-StrClr',`SER/Q15',`Y0',`Y1',`Y2',`Y3',`Y4',`Gnd',`Y5',`Y6',`Y7',`Y8',`Y9',`Y10',`Y11',`Y12',`Y13',`Y14',`Y15',`Vcc'')

define(`Description_74674_dil', ``16bit shift register w. 16bit parallel in'')
define(`Param1_74674_dil', 24)
define(`Param2_74674_dil', 300)
define(`PinList_74674_dil', ``/CS',`Clk',`R-/W',`NC',`Mode',`SER/Q15',`P0',`P1',`P2',`P3',`P4',`Gnd',`P5',`P6',`P7',`P8',`P9',`P10',`P11',`P12',`P13',`P14',`P15',`Vcc'')

define(`Description_74681_dil', ``4bit parallel binary accumulator'')
define(`Param1_74681_dil', 20)
define(`Param2_74681_dil', 300)
define(`PinList_74681_dil', ``Clk',`RS2',`RS1',`RS0',`LI-RO',`Cn',`/G',`Cn+4',`/P',`Gnd',`I-O3',`I-O2',`I-O1',`I-O0',`M',`AS2',`AS1',`AS0',`RI-LO',`Vcc'')

define(`Description_74682_dil', ``8bit magnitute comperator w. input pull-up'')
define(`Param1_74682_dil', 20)
define(`Param2_74682_dil', 300)
define(`PinList_74682_dil', ``/P>Q',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74683_dil', ``8bit magnitute comperator OC w. input pull-up'')
define(`Param1_74683_dil', 20)
define(`Param2_74683_dil', 300)
define(`PinList_74683_dil', ``/P>Q',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74684_dil', ``8bit magnitute comperator'')
define(`Param1_74684_dil', 20)
define(`Param2_74684_dil', 300)
define(`PinList_74684_dil', ``/P>Q',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74685_dil', ``8bit magnitute comperator OC'')
define(`Param1_74685_dil', 20)
define(`Param2_74685_dil', 300)
define(`PinList_74685_dil', ``/P>Q',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74686_dil', ``8bit magnitute comperator w. enable'')
define(`Param1_74686_dil', 24)
define(`Param2_74686_dil', 300)
define(`PinList_74686_dil', ``/P>Q',`/G1',`P0',`Q0',`P1',`Q1',`NC',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`NC',`P7',`Q7',`/P=Q',`/G2',`Vcc'')

define(`Description_74687_dil', ``8bit magnitute comperator OC w. enable'')
define(`Param1_74687_dil', 24)
define(`Param2_74687_dil', 300)
define(`PinList_74687_dil', ``/P>Q',`/G1',`P0',`Q0',`P1',`Q1',`NC',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`NC',`P7',`Q7',`/P=Q',`/G2',`Vcc'')

define(`Description_74688_dil', ``8bit identity comperator'')
define(`Param1_74688_dil', 20)
define(`Param2_74688_dil', 300)
define(`PinList_74688_dil', ``/G',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74689_dil', ``8bit identity comperator OC'')
define(`Param1_74689_dil', 20)
define(`Param2_74689_dil', 300)
define(`PinList_74689_dil', ``/G',`P0',`Q0',`P1',`Q1',`P2',`Q2',`P3',`Q3',`Gnd',`P4',`Q4',`P5',`Q5',`P6',`Q6',`P7',`Q7',`/P=Q',`Vcc'')

define(`Description_74690_dil', ``4bit synchronous decade counter w. direct clear, output register 3-state'')
define(`Param1_74690_dil', 20)
define(`Param2_74690_dil', 300)
define(`PinList_74690_dil', ``/CClr',`CCK',`A',`B',`C',`D',`ENP',`/RClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74691_dil', ``4bit synchronous binary counter w. direct clear, output register 3-state'')
define(`Param1_74691_dil', 20)
define(`Param2_74691_dil', 300)
define(`PinList_74691_dil', ``/CClr',`CCK',`A',`B',`C',`D',`ENP',`/RClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74693_dil', ``4bit synchronous binary counter w. sync. clear, output register 3-state'')
define(`Param1_74693_dil', 20)
define(`Param2_74693_dil', 300)
define(`PinList_74693_dil', ``/CClr',`CCK',`A',`B',`C',`D',`ENP',`/RClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`ENT',`Qd',`Qc',`Qb',`Qa',`RCO',`Vcc'')

define(`Description_74696_dil', ``4bit synchronous decade counter w. direct clear 3-state'')
define(`Param1_74696_dil', 20)
define(`Param2_74696_dil', 300)
define(`PinList_74696_dil', ``U-/D',`CCK',`A',`B',`C',`D',`/ENP',`/CClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

define(`Description_74697_dil', ``4bit synchronous binary counter w. direct clear 3-state'')
define(`Param1_74697_dil', 20)
define(`Param2_74697_dil', 300)
define(`PinList_74697_dil', ``U-/D',`CCK',`A',`B',`C',`D',`/ENP',`/CClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

define(`Description_74699_dil', ``4bit synchronous binary counter w. sync. clear 3-state'')
define(`Param1_74699_dil', 20)
define(`Param2_74699_dil', 300)
define(`PinList_74699_dil', ``U-/D',`CCK',`A',`B',`C',`D',`/ENP',`/CClr',`RCK',`Gnd',`R-/C',`/G',`/Load',`/ENT',`Qd',`Qc',`Qb',`Qa',`/RCO',`Vcc'')

divert(0)dnl
