# Node Foundation TSC Meeting 2015-05-27

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-05-27
* **Public YouTube feed**: http://www.youtube.com/watch?v=0DPfLxulsbQ
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/41
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1-KlxiQGMsJFNJu3meok9e9XFsM39k_PMnQmY_9d_cy0

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/node-convergence-archive

* \[Converge\] timers: Avoid linear scan in `_unrefActive`. [#23](https://github.com/nodejs/node-convergence-archive/issues/23)
* \[Converge\] child_process argument type checking [#22](https://github.com/nodejs/node-convergence-archive/issues/22)
* \[Converge\] SSLv2/3 disable/enable related commits [#20](https://github.com/nodejs/node-convergence-archive/issues/20)
* doc: Add new working groups [#15](https://github.com/nodejs/node-convergence-archive/pull/15)

### nodejs/io.js

* Buffer implemented using Uint8Array [#1810](https://github.com/nodejs/io.js/issues/1810)
* \[Discussion\] FFI - Giving Buffer more low-level C functionality [#1750](https://github.com/nodejs/io.js/pull/1750)
* Chrome 43 released; time for V8 4.3! [#1735](https://github.com/nodejs/io.js/issues/1735)
* Deprecation Policy [#1704](https://github.com/nodejs/io.js/issues/1704)
* TSC needs to elect a board representative. [#1697](https://github.com/nodejs/io.js/issues/1697)
* V8 4.4 to remove indexed properties via external data [#1451](https://github.com/nodejs/io.js/issues/1451)

### joyent/node

## Present

* Alexis Campailla (TSC)
* Ben Noordhuis (TSC)
* Bert Belder (TSC)
* Brian White
* Chris Dickinson (TSC)
* Colin Ihrig (TSC)
* James M Snell (TSC)
* Jeremiah Senkpiel (TSC)
* Mikeal Rogers
* Michael Dawson (TSC)
* Mike Dolan (TSC)
* Rod Vagg (TSC)
* Shigeki Ohtsu
* Trevor Norris (TSC)

## Quick stand-up

* Rod: Working on combining the build, 3.0
* James: Working on repo convergence, triaging joyent/node issues, LTS policy drafting
* Shigeki: Investigating a slow tls test and SSL mitigations for a log jam attack. 
* Jeremiah: Lots of little things
* Colin: Libuv work for os.homedir()
* Chris: Removing sys, checking breakage; fixing bug I introduced in persistent history
* Bert: Looking at issues
* Alexis: Working on combining the build, fixing windows issues
* Trevor: Working on the new Buffer impl using Uint8Array
* Michael: Traging joyent/node, spun up the benchmarking WG, looking into adding powerpc build machines
* Brian: Almost done the pure JS dns resolver, all tests are passing
* Ben: 
 - Make require faster
 - Date.now() perf improvements

## Review of last meeting

* _Skipping_

## Minutes

### \[Converge\] timers: Avoid linear scan in `_unrefActive`. [#23](https://github.com/nodejs/node-convergence-archive/issues/23)

* James: conflicting approaches in both repos
* Ben: both are terrible under different workloads - do away with the code and start again
* Jeremiah: might have a go at it, working off an existing heap impl by Ben (ACTION)
* Bert: some problems with http - discussion happened about the implementation
* Chris: would be good to have Julien’s input since he was active on the joyent/node impl

### \[Converge\] child_process argument type checking [#22](https://github.com/nodejs/node-convergence-archive/issues/22)

* James: arg checking merged in 0.10 after the fork
* Discussion about why this wasn’t merged to io.js
* Defer back to GitHub discussion after no reason for not merging could be found on the call

### \[Converge\] SSLv2/3 disable/enable related commits [#20](https://github.com/nodejs/node-convergence-archive/issues/20)

* James: SSLv2/3 removed in io.js, merging these commits would involve reverting
* Jeremiah proposed 0.12 being the LTS for SSLv2/3 support
* Rod: are we happy killing this off?
* Michael: we don’t know how extensively it’s being used?
* James: pending research into that question we’ll leave this alone, come back if there’s a compelling reason to revert

### doc: Add new working groups [#15](https://github.com/nodejs/node-convergence-archive/pull/15)

* Michael: Benchmarking and Post Mortem Debugging working groups are ready and have started, i18n group needs a bit more work to get off the ground
* Group didn’t see any reason not to go forward with these groups, they have repos and can be in an “incubating” state for now


### Buffer implemented using Uint8Array [#1810](https://github.com/nodejs/io.js/issues/1810)

* Trevor: Buffer using Uint8Array is now working, all applicable tests pass, currently behind a flag:
* Trevor Questions:
  - Are we going with v8 4.3 or 4.4?
  - If we go v8 4.3, do we want to release behind a flag?
  - we still want an upper kMaxlength Buffer size limit?
* Ben: Buffer size limit should be safe to remove
* Rod: 4.3 and 4.4 both contain major breakage for native addons
* Discussed if we would like to delay 3.0 until v8 4.4
* Rod: no appetite here for delaying a 3.0 with 4.3, take discussion on that back to GitHub
* Ben: suggested we release new Buffer impl with a flag to revert to old impl, Jeremiah seconded
* Discussed how hard it would be to land and review
* Fedor: how does it work with 32bit numbers?
* Trevor: It acts the same as before

### \[Discussion\] FFI - Giving Buffer more low-level C functionality [#1750](https://github.com/nodejs/io.js/pull/1750)

* Trevor: concerns about being able to write to buffers and execute arbitrary code
* Rod: concerned about changing the nature of what Node _is_ and the safety it exposes
* Ben suggested that we move this new work to an ffi module rather than hanging it off Buffer
 - Group agreed to take this suggestion back to the issue for discussion

### Chrome 43 released; time for V8 4.3! [#1735](https://github.com/nodejs/io.js/issues/1735)

* Concerns about deps forcing semver-major, the C++ API changes are big enough to warrant this though

### Deprecation Policy [#1704](https://github.com/nodejs/io.js/issues/1704)

* Discussion dividing into two camps - conservative camp and those who want to test the size of the impact on the ecosystem
* Suggestion (Michael?) that we use LTS releases to determine when things get properly removed
* Discussed why we want a deprecation policy

### TSC needs to elect a board representative. [#1697](https://github.com/nodejs/io.js/issues/1697)

* Deferred till next meeting - need to nominate and vote someone in to this role and should discuss how we want to structure the role in terms of rotation

### V8 4.4 to remove indexed properties via external data [#1451](https://github.com/nodejs/io.js/issues/1451)

* Nothing to discuss, rolled up in to Buffer discussion earlier

## Next meeting

* June 3rd, 8PM UTC
