#!/usr/bin/python
# Copyright (C) 2005-2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Basic Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to demo the import of an external module or
external functions

"""

from mago import TestCase, TextTestRunner
import unittest
import gcalctool
import ooldtp

class TestGCalctool(TestCase):
    """Test Class for Gcalctool"""

    launcher = gcalctool.launcher
    launcher_args = []
    window_name = gcalctool.window_name
    #setupOnce = True

    def test_test01(self):
        """test01

        This method just call function2 included in the external module
        'gcalctool'
        """
        gcalctool.function1()

    def test_test02(self):
        """test02

        This method set a value is the entry field of the calculator is empty,
        then call function2 included in the external module 'gcalctool'
        """
        a = ooldtp.context('frmCalculator')
        if not a.gettextvalue('txt0'):
            a.settextvalue('txt0', '321')
        gcalctool.function2()

    def setUp(self):
        """setUp method

        We overload the setUp method to clear the calculator entry field at the
        start of the test.
        """
        super(TestGCalctool, self).setUp()
        gcalctool.clearscreen()

if __name__ == "__main__":
    unittest.main(testRunner=TextTestRunner)
