#include <pthread.h>
#include <fstream>
#include <iostream>
#include <unistd.h>
#include <cstdlib>
#include <cstring>

#include "vibrator.h"
#include "external/callback.h"
#include "logger.h"

using namespace std;

struct RunArg {
    Closure* c;
    int delay_micros;
    RunArg(Closure* c_, int d):c(c_), delay_micros(d){}
};

static void* RunFun(void *arg){
    RunArg* a = (RunArg*) arg;
    usleep(a->delay_micros);
    a->c->Run();
    delete a;
}

static void RunLater(Closure* c, int delay_micros){
    pthread_attr_t tattr;
    pthread_attr_init(&tattr);
    pthread_attr_setdetachstate(&tattr,PTHREAD_CREATE_DETACHED);
    pthread_t p;
    int err = pthread_create(&p, &tattr, RunFun, new RunArg(c, delay_micros));
    if (err != 0) {
	LOG(FATAL) << "pthread_create error: " << strerror(err);
    }
}

void Vibrator::SetVibTime(int time){
    vibtime = time;
}

void Vibrator::SetVibPower(int power){
    vibpower = power;
}

static void VibrateNow(int power, int time){
    LOG(INFO) << "VIB " << time << " " << power;
    ofstream fout("/sys/class/leds/neo1973:vibrator/brightness");
    if (!fout.good())
	return;
    fout << power <<endl;
    fout.flush();

    usleep(time *1000);

    fout << 0 << endl;
    fout.close();
} 

Vibrator::Vibrator(int time, int power):vibtime(time), vibpower(power){
}

void Vibrator::Vibrate(){
    RunLater(NewCallback(VibrateNow, vibpower, vibtime), 0);
}
