/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (C) 2023--2024 Intel Corporation */

#ifndef IPU6_PLATFORM_BUTTRESS_REGS_H
#define IPU6_PLATFORM_BUTTRESS_REGS_H

#include <linux/bits.h>

/* IS_WORKPOINT_REQ */
#define IPU6_BUTTRESS_REG_IS_FREQ_CTL		0x34
/* PS_WORKPOINT_REQ */
#define IPU6_BUTTRESS_REG_PS_FREQ_CTL		0x38

/* should be tuned for real silicon */
#define IPU6_IS_FREQ_CTL_DEFAULT_RATIO		0x08
#define IPU6SE_IS_FREQ_CTL_DEFAULT_RATIO	0x0a
#define IPU6_PS_FREQ_CTL_DEFAULT_RATIO		0x0d

#define IPU6_IS_FREQ_CTL_DEFAULT_QOS_FLOOR_RATIO	0x10
#define IPU6_PS_FREQ_CTL_DEFAULT_QOS_FLOOR_RATIO	0x0708

#define IPU6_BUTTRESS_PWR_STATE_IS_PWR_SHIFT	3
#define IPU6_BUTTRESS_PWR_STATE_IS_PWR_MASK	GENMASK(4, 3)

#define IPU6_BUTTRESS_PWR_STATE_PS_PWR_SHIFT	6
#define IPU6_BUTTRESS_PWR_STATE_PS_PWR_MASK	GENMASK(7, 6)

#define IPU6_BUTTRESS_PWR_STATE_DN_DONE		0x0
#define IPU6_BUTTRESS_PWR_STATE_UP_PROCESS	0x1
#define IPU6_BUTTRESS_PWR_STATE_DN_PROCESS	0x2
#define IPU6_BUTTRESS_PWR_STATE_UP_DONE		0x3

#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_0	0x270
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_1	0x274
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_2	0x278
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_3	0x27c
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_4	0x280
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_5	0x284
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_6	0x288
#define IPU6_BUTTRESS_REG_FPGA_SUPPORT_7	0x28c

#define BUTTRESS_REG_WDT			0x8
#define BUTTRESS_REG_BTRS_CTRL			0xc
#define BUTTRESS_REG_BTRS_CTRL_STALL_MODE_VC0	BIT(0)
#define BUTTRESS_REG_BTRS_CTRL_STALL_MODE_VC1	BIT(1)
#define BUTTRESS_REG_BTRS_CTRL_REF_CLK_IND	GENMASK(9, 8)

#define BUTTRESS_REG_FW_RESET_CTL	0x30
#define BUTTRESS_FW_RESET_CTL_START	BIT(0)
#define BUTTRESS_FW_RESET_CTL_DONE	BIT(1)

#define BUTTRESS_REG_IS_FREQ_CTL	0x34
#define BUTTRESS_REG_PS_FREQ_CTL	0x38

#define BUTTRESS_FREQ_CTL_START		BIT(31)
#define BUTTRESS_FREQ_CTL_ICCMAX_LEVEL		GENMASK(19, 16)
#define BUTTRESS_FREQ_CTL_QOS_FLOOR_MASK	GENMASK(15, 8)
#define BUTTRESS_FREQ_CTL_RATIO_MASK	GENMASK(7, 0)

#define BUTTRESS_REG_PWR_STATE	0x5c

#define BUTTRESS_PWR_STATE_RESET		0x0
#define BUTTRESS_PWR_STATE_PWR_ON_DONE		0x1
#define BUTTRESS_PWR_STATE_PWR_RDY		0x3
#define BUTTRESS_PWR_STATE_PWR_IDLE		0x4

#define BUTTRESS_PWR_STATE_HH_STATUS_MASK	GENMASK(12, 11)

enum {
	BUTTRESS_PWR_STATE_HH_STATE_IDLE,
	BUTTRESS_PWR_STATE_HH_STATE_IN_PRGS,
	BUTTRESS_PWR_STATE_HH_STATE_DONE,
	BUTTRESS_PWR_STATE_HH_STATE_ERR,
};

#define BUTTRESS_PWR_STATE_IS_PWR_FSM_MASK	GENMASK(23, 19)

#define BUTTRESS_PWR_STATE_IS_PWR_FSM_IDLE			0x0
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PLL_CMP		0x1
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_CLKACK		0x2
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PG_ACK		0x3
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_ASSRT_CYCLES		0x4
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_STOP_CLK_CYCLES1		0x5
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_STOP_CLK_CYCLES2		0x6
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_DEASSRT_CYCLES	0x7
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_FUSE_WR_CMP	0x8
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_BRK_POINT			0x9
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_IS_RDY			0xa
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_HALT_HALTED		0xb
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_DURATION_CNT3		0xc
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_CLKACK_PD		0xd
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_PD_BRK_POINT		0xe
#define BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PD_PG_ACK0		0xf

#define BUTTRESS_PWR_STATE_PS_PWR_FSM_MASK	GENMASK(28, 24)

#define BUTTRESS_PWR_STATE_PS_PWR_FSM_IDLE			0x0
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_PLL_IP_RDY	0x1
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_RO_PRE_CNT_EXH	0x2
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_VGI_PWRGOOD	0x3
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_RO_POST_CNT_EXH	0x4
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WR_PLL_RATIO		0x5
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_PLL_CMP		0x6
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_CLKACK		0x7
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_RST_ASSRT_CYCLES		0x8
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_STOP_CLK_CYCLES1		0x9
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_STOP_CLK_CYCLES2		0xa
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_RST_DEASSRT_CYCLES	0xb
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_PU_BRK_PNT		0xc
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_FUSE_ACCPT		0xd
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_PS_PWR_UP			0xf
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_4_HALTED		0x10
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_RESET_CNT3		0x11
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PD_CLKACK		0x12
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PD_OFF_IND		0x13
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_PH4		0x14
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_PLL_CMP		0x15
#define BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_CLKACK		0x16

#define BUTTRESS_REG_SECURITY_CTL	0x300
#define BUTTRESS_REG_SKU		0x314
#define BUTTRESS_REG_SECURITY_TOUCH	0x318
#define BUTTRESS_REG_CAMERA_MASK	0x84

#define BUTTRESS_SECURITY_CTL_FW_SECURE_MODE	BIT(16)
#define BUTTRESS_SECURITY_CTL_FW_SETUP_MASK	GENMASK(4, 0)

#define BUTTRESS_SECURITY_CTL_FW_SETUP_DONE		BIT(0)
#define BUTTRESS_SECURITY_CTL_AUTH_DONE			BIT(1)
#define BUTTRESS_SECURITY_CTL_AUTH_FAILED		BIT(3)

#define BUTTRESS_REG_FW_SOURCE_BASE_LO	0x78
#define BUTTRESS_REG_FW_SOURCE_BASE_HI	0x7C
#define BUTTRESS_REG_FW_SOURCE_SIZE	0x80

#define BUTTRESS_REG_ISR_STATUS		0x90
#define BUTTRESS_REG_ISR_ENABLED_STATUS	0x94
#define BUTTRESS_REG_ISR_ENABLE		0x98
#define BUTTRESS_REG_ISR_CLEAR		0x9C

#define BUTTRESS_ISR_IS_IRQ			BIT(0)
#define BUTTRESS_ISR_PS_IRQ			BIT(1)
#define BUTTRESS_ISR_IPC_EXEC_DONE_BY_CSE	BIT(2)
#define BUTTRESS_ISR_IPC_EXEC_DONE_BY_ISH	BIT(3)
#define BUTTRESS_ISR_IPC_FROM_CSE_IS_WAITING	BIT(4)
#define BUTTRESS_ISR_IPC_FROM_ISH_IS_WAITING	BIT(5)
#define BUTTRESS_ISR_CSE_CSR_SET		BIT(6)
#define BUTTRESS_ISR_ISH_CSR_SET		BIT(7)
#define BUTTRESS_ISR_SPURIOUS_CMP		BIT(8)
#define BUTTRESS_ISR_WATCHDOG_EXPIRED		BIT(9)
#define BUTTRESS_ISR_PUNIT_2_IUNIT_IRQ		BIT(10)
#define BUTTRESS_ISR_SAI_VIOLATION		BIT(11)
#define BUTTRESS_ISR_HW_ASSERTION		BIT(12)
#define BUTTRESS_ISR_IS_CORRECTABLE_MEM_ERR	BIT(13)
#define BUTTRESS_ISR_IS_FATAL_MEM_ERR		BIT(14)
#define BUTTRESS_ISR_IS_NON_FATAL_MEM_ERR	BIT(15)
#define BUTTRESS_ISR_PS_CORRECTABLE_MEM_ERR	BIT(16)
#define BUTTRESS_ISR_PS_FATAL_MEM_ERR		BIT(17)
#define BUTTRESS_ISR_PS_NON_FATAL_MEM_ERR	BIT(18)
#define BUTTRESS_ISR_PS_FAST_THROTTLE		BIT(19)
#define BUTTRESS_ISR_UFI_ERROR			BIT(20)

#define BUTTRESS_REG_IU2CSEDB0	0x100

#define BUTTRESS_IU2CSEDB0_BUSY		BIT(31)
#define BUTTRESS_IU2CSEDB0_IPC_CLIENT_ID_VAL	2

#define BUTTRESS_REG_IU2CSEDATA0	0x104

#define BUTTRESS_IU2CSEDATA0_IPC_BOOT_LOAD		1
#define BUTTRESS_IU2CSEDATA0_IPC_AUTH_RUN		2
#define BUTTRESS_IU2CSEDATA0_IPC_AUTH_REPLACE		3
#define BUTTRESS_IU2CSEDATA0_IPC_UPDATE_SECURE_TOUCH	16

#define BUTTRESS_CSE2IUDATA0_IPC_BOOT_LOAD_DONE			BIT(0)
#define BUTTRESS_CSE2IUDATA0_IPC_AUTH_RUN_DONE			BIT(1)
#define BUTTRESS_CSE2IUDATA0_IPC_AUTH_REPLACE_DONE		BIT(2)
#define BUTTRESS_CSE2IUDATA0_IPC_UPDATE_SECURE_TOUCH_DONE	BIT(4)

#define BUTTRESS_REG_IU2CSECSR		0x108

#define BUTTRESS_IU2CSECSR_IPC_PEER_COMP_ACTIONS_RST_PHASE1		BIT(0)
#define BUTTRESS_IU2CSECSR_IPC_PEER_COMP_ACTIONS_RST_PHASE2		BIT(1)
#define BUTTRESS_IU2CSECSR_IPC_PEER_QUERIED_IP_COMP_ACTIONS_RST_PHASE	BIT(2)
#define BUTTRESS_IU2CSECSR_IPC_PEER_ASSERTED_REG_VALID_REQ		BIT(3)
#define BUTTRESS_IU2CSECSR_IPC_PEER_ACKED_REG_VALID			BIT(4)
#define BUTTRESS_IU2CSECSR_IPC_PEER_DEASSERTED_REG_VALID_REQ		BIT(5)

#define BUTTRESS_REG_CSE2IUDB0		0x304
#define BUTTRESS_REG_CSE2IUCSR		0x30C
#define BUTTRESS_REG_CSE2IUDATA0	0x308

/* 0x20 == NACK, 0xf == unknown command */
#define BUTTRESS_CSE2IUDATA0_IPC_NACK      0xf20
#define BUTTRESS_CSE2IUDATA0_IPC_NACK_MASK GENMASK(15, 0)

#define BUTTRESS_REG_ISH2IUCSR		0x50
#define BUTTRESS_REG_ISH2IUDB0		0x54
#define BUTTRESS_REG_ISH2IUDATA0	0x58

#define BUTTRESS_REG_IU2ISHDB0		0x10C
#define BUTTRESS_REG_IU2ISHDATA0	0x110
#define BUTTRESS_REG_IU2ISHDATA1	0x114
#define BUTTRESS_REG_IU2ISHCSR		0x118

#define BUTTRESS_REG_FABRIC_CMD		0x88

#define BUTTRESS_FABRIC_CMD_START_TSC_SYNC	BIT(0)
#define BUTTRESS_FABRIC_CMD_IS_DRAIN		BIT(4)

#define BUTTRESS_REG_TSW_CTL		0x120
#define BUTTRESS_TSW_CTL_SOFT_RESET	BIT(8)

#define BUTTRESS_REG_TSC_LO	0x164
#define BUTTRESS_REG_TSC_HI	0x168

#define BUTTRESS_IRQS		(BUTTRESS_ISR_IPC_FROM_CSE_IS_WAITING | \
				 BUTTRESS_ISR_IPC_EXEC_DONE_BY_CSE |    \
				 BUTTRESS_ISR_IS_IRQ | BUTTRESS_ISR_PS_IRQ)

#define BUTTRESS_EVENT		 (BUTTRESS_ISR_IPC_FROM_CSE_IS_WAITING | \
				  BUTTRESS_ISR_IPC_EXEC_DONE_BY_CSE |    \
				  BUTTRESS_ISR_SAI_VIOLATION)
#endif /* IPU6_PLATFORM_BUTTRESS_REGS_H */
