#include <zlib.h>
#include <stdio.h>
#include <KayaAPI.h>

#include "zlib_glue.h"

void* compressBuffer(void* vmptr, void* in, int len, KayaValue buflen)
{
    VMState* vm = (VMState*)vmptr;
    uLong outlen = compressBound(len);
    uLong inlen = len;
    Byte* out = (Byte*)KayaAlloc(outlen);
    int err = compress(out, &outlen, (Byte*)in, inlen); 
    if (err == Z_BUF_ERROR || err == Z_MEM_ERROR) {
      vm->kaya_internalError(241);
    }
    //    printf("compressed %d to %d (%d)\n",len, outlen, err);

    KayaSetInt(buflen,outlen);
    return (void*)out;
}

void* uncompressBuffer(void* vmptr, void* in, int len, KayaValue outlen)
{
    VMState* vm = (VMState*)vmptr;
    uLong blen = KayaGetInt(outlen);
    Byte* out = (Byte*)KayaAlloc(blen);
    int err = uncompress(out, &blen, (Byte*)in, len);
    if (err == Z_BUF_ERROR || err == Z_MEM_ERROR || err == Z_DATA_ERROR) {
      vm->kaya_internalError(240);
    }
    //    printf("uncompressed %d to %d (%d)\n",len,blen, err);

    KayaSetInt(outlen,blen);
    return (void*)out;    
}

