/*
    SPDX-FileCopyrightText: 1998-2009 Sebastian Trueg <trueg@k3b.org>
    SPDX-License-Identifier: GPL-2.0-or-later
*/
#ifndef _K3B_GROWISOFS_HANDLER_H_
#define _K3B_GROWISOFS_HANDLER_H_

#include "k3bdevice.h"

#include <QObject>

namespace K3b {
    namespace Device {
        class Device;
        class DeviceHandler;
    }


    /**
     * This class handles the output parsing for growisofs
     * We put it in an extra class since we have two classes
     * using growisofs: the writer and the imager.
     */
    class GrowisofsHandler : public QObject
    {
        Q_OBJECT

    public:
        explicit GrowisofsHandler( QObject* parent = 0 );
        ~GrowisofsHandler() override;

        enum ErrorType {
            ERROR_UNKNOWN,
            ERROR_MEDIA,
            ERROR_OVERSIZE,
            ERROR_SPEED_SET_FAILED,
            ERROR_OPC,
            ERROR_MEMLOCK,
            ERROR_WRITE_FAILED
        };

        int error() const { return m_error; }

        void setMediaType(Device::MediaType mediaType);

    public Q_SLOTS:
        /**
         * This will basically reset the error type
         * @param dao was growisofs called with DAO?
         */
        void reset( K3b::Device::Device* = 0, bool dao = false );

        void handleStart();
        void handleLine( const QString& );
        void handleExit( int exitCode );

    Q_SIGNALS:
        void infoMessage( const QString&, int );
        void newSubTask( const QString& );
        void buffer( int );
        void deviceBuffer( int );

        /**
         * We need this to know when the writing finished to update the progress
         */
        void flushingCache();

    private Q_SLOTS:
        void slotCheckBufferStatus();
        void slotCheckBufferStatusDone( Device::DeviceHandler* );

    private:
        class Private;
        Private* d;

        int m_error;
        bool m_dao;
        Device::Device* m_device;
        Device::MediaType m_mediaType;
    };
}

#endif
