# Section C - What are the myths of capitalist economics?

Within capitalism, economics plays an important ideological role. Economics
has been used to construct a theory from which exploitation and oppression are
excluded, by definition. We will attempt here to explain why capitalism is
deeply exploitative. Elsewhere, in [section B](secBcon.md), we have
indicated why capitalism is oppressive and will not repeat ourselves here.

In many ways economics plays the role within capitalism that religion played
in the Middle Ages, namely to provide justification for the dominant social
system and hierarchies. _"The priest keeps you docile and subjected,"_ argued
Malatesta, _"telling you everything is God's will; the economist say it's the
law of nature."_ They _"end up saying that no one is responsible for poverty,
so there's no point rebelling against it."_ [**Fra Contadini**, p. 21] Even
worse, they usually argue that collective action by working class people is
counterproductive and, like the priest, urge us to tolerate current oppression
and exploitation with promises of a better future (in heaven for the priest,
for the economist it is an unspecified "long run"). It would be no
generalisation to state that if you want to find someone to rationalise and
justify an obvious injustice or form of oppression then you should turn to an
economist (preferably a "free market" one).

That is not the only similarity between the "science" of economics and
religion. Like religion, its basis in science is usually lacking and its
theories more based upon "leaps of faith" than empirical fact. Indeed, it is
hard to find a "science" more unconcerned about empirical evidence or building
realistic models than economics. Just looking at the assumptions made in
"perfect competition" shows that (see [section C.1](secC1.md) for details).
This means that economics is immune to such trivialities as evidence and fact,
although that does not stop economics being used to rationalise and justify
certain of these facts (such as exploitation and inequality). A classic
example is the various ways economists have sought to explain what anarchists
and other socialists have tended to call **_"surplus value"_** (i.e. profits,
interest and rent). Rather than seek to explain its origin by an empirical
study of the society it exists in (capitalism), economists have preferred to
invent "just-so" stories, little a-historic parables about a past which never
existed is used to illustrate (and so defend) a present class system and its
inequalities and injustices. The lessons of a fairy tale about a society that
has never existed are used as a guide for one which does and, by some strange
co-incidence, they happen to justify the existing class system and its
distribution of income. Hence the love of Robinson Crusoe in economics.

Ironically, this favouring of theory (ideology would be a better term) is
selective as their exposure as fundamentally flawed does not stop them being
repeated. As we discuss in [section C.2](secC2.md), the neoclassical theory
of capital was proven to be incorrect by left-wing economists. This was
admitted by their opponents: _"The question that confronts us is not whether
the Cambridge Criticism is theoretically valid. It is. Rather the question is
an empirical or econometric one: is there sufficient substitutability within
the system to establish neo-classical results?"_ Yet this did not stop this
theory being taught to this day and the successful critique forgotten. Nor has
econometrics successfully refuted the analysis, as capital specified in terms
of money cannot reflect a theoretical substance (neo-classical "capital")
which could not exist in reality. However, that is unimportant for _"[u]ntil
the econometricians have the answer for us, placing reliance upon neo-
classical economic theory is a matter of faith,"_ which, of course, he had [C.
E. Ferguson, **The Neo-classical Theory of Production and Distribution**, p.
266 and p. xvii]

Little wonder that Joan Robinson, one of the left-wing economists who helped
expose the bankruptcy of the neo-classical theory of capital, stated that
economics was _"back where it was, a branch of theology."_ [**Collected
Economic Papers**, Vol. 4, p. 127] It remains there more than thirty years
later:

> _ "Economics is not a science. Many economists -- particularly those who
believe that decisions on whether to get married can be reduced to an equation
-- see the world as a complex organism that can be understood using the right
differential calculus. Yet everything we know about economics suggests that it
is a branch and not a particularly advanced one, of witchcraft."_ [Larry
Elliot and Dan Atkinson, **The Age of Insecurity**, p. 226]

The weakness of economics is even acknowledged by some within the profession
itself. According to Paul Ormerod, _"orthodox economics is in many ways an
empty box. Its understanding of the world is similar to that of the physical
sciences in the Middle Ages. A few insights have been obtained which stand the
test of time, but they are very few indeed, and the whole basis of
conventional economics is deeply flawed."_ Moreover, he notes the
_"overwhelming empirical evidence against the validity of its theories."_ It
is rare to see an economist be so honest. The majority of economists seem
happy to go on with their theories, trying to squeeze life into the
Procrustean bed of their models. And, like the priests of old, make it hard
for non-academics to question their dogmas as _"economics is often
intimidating. Its practitioners . . . have erected around the discipline a
barrier of jargon and mathematics which makes the subject difficult to
penetrate for the non-initiated."_ [**The Death of Economics**, p. ix, p. 67
and p. ix]

So in this section of our FAQ, we will try to get to the heart of modern
capitalism, cutting through the ideological myths that supporters of the
system have created around it. This will be a difficult task, as the
divergence of the reality of capitalism and the economics that is used to
explain (justify, more correctly) it is large. For example, the preferred
model used in neo-classical economics is that of "perfect competition" which
is based on a multitude of small firms producing homogenous products in a
market which none of them are big enough to influence (i.e. have no market
power). This theory was developed in the late 19th century when the real
economy was marked by the rise of big business, a dominance which continues to
this day. Nor can it be said that even small firms produce identical products
-- product differentiation and brand loyalty are key factors for any business.
In other words, the model reflected (and still reflects) the exact opposite of
reality.

In spite of the theoretical models of economics having little or no relation
to reality, they are used to both explain and justify the current system. As
for the former, the truly staggering aspect of economics for those who value
the scientific method is the immunity of its doctrines to empirical refutation
(and, in some cases, theoretical refutation). The latter is the key to not
only understanding why economics is in such a bad state but also why it stays
like that. While economists like to portray themselves as objective
scientists, merely analysing the system, the development of their "science"
has always been marked with apologetics, with rationalising the injustices of
the existing system. This can be seen best in attempts by economists to show
that Chief Executive Officers (CEOs) of firms, capitalists and landlords all
deserve their riches while workers should be grateful for what they get. As
such, economics has never been value free simply because what it says affects
people and society. This produces a market for economic ideology in which
those economists who supply the demand will prosper. Thus we find many
_"fields of economics and economic policy where the responses of important
economic professionals and the publicity given economic findings are
correlated with the increased market demand for specific conclusions and a
particular ideology."_ [Edward S. Herman, _"The Selling of Market Economics,"_
pp. 173-199, **New Ways of Knowing**, Marcus G. Raskin and Herbert J.
Bernstein (eds.), p.192]

Even if we assume the impossible, namely that economists and their ideology
can truly be objective in the face of market demand for their services, there
is a root problem with capitalist economics. This is that it the specific
social relations and classes produced by capitalism have become embedded into
the theory. Thus, as an example, the concepts of the marginal productivity of
land and capital are assumed to universal in spite the fact that neither makes
any sense outside an economy where one class of people owns the means of life
while another sells their labour to them. Thus in an artisan/peasant society
or one based around co-operatives, there would be no need for such concepts
for in such societies, the distinction between wages and profits has no
meaning and, as a result, there is no income to the owners of machinery and
land and no need to explain it in terms of the "marginal productivity" of
either. Thus mainstream economics takes the class structure of capitalism as a
natural, eternal, fact and builds up from there. Anarchists, like other
socialists, stress the opposite, namely that capitalism is a specific
historical phase and, consequently, there are no universal economic laws and
if you change the system the laws of economics change. Unless you are a
capitalist economist, of course, when the same laws apply no matter what.

In our discussion, it is important to remember that capitalist economics is
**not** the same as the capitalist economy. The latter exists quite
independently of the former (and, ironically, usually flourishes best when the
policy makers ignore it). Dissident economist Steve Keen provides a telling
analogy between economics and meteorology. Just as _"the climate would exist
even if there were no intellectual discipline of meteorology, the economy
itself would exist whether or not the intellectual pursuit of economics
existed."_ Both share _"a fundamental raison d'etre,"_ namely _"that of
attempting to understand a complex system."_ However, there are differences.
Like weather forecasters, _"economists frequently get their forecasts of the
economic future wrong. But in fact, though weather forecasts are sometimes
incorrect, overall meteorologists have an enviable record of accurate
prediction -- whereas the economic record is tragically bad."_ This means it
is impossible to ignore economics (_"to treat it and its practitioners as we
these days treat astrologers"_) as it is a social discipline and so what we
_"believe about economics therefore has an impact upon human society and the
way we relate to one another."_ Despite _"the abysmal predictive record of
their discipline,"_ economists _"are forever recommending ways in which the
institutional environment should be altered to make the economy work better."_
By that they mean make the real economy more like their models, as _"the
hypothetical pure market performs better than the mixed economy in which we
live."_ [**Debunking Economics**, pp. 6-8] Whether this actually makes the
world a better place is irrelevant (indeed, economics has been so developed as
to make such questions irrelevant as what happens on the market is, by
definition, for the best).

Here we expose the apologetics for what they are, expose the ideological role
of economics as a means to justify, indeed ignore, exploitation and
oppression. In the process of our discussion we will often expose the
ideological apologetics that capitalist economics create to defend the status
quo and the system of oppression and exploitation it produces. We will also
attempt to show the deep flaws in the internal inconsistencies of mainstream
economics. In addition, we will show how important reality is when evaluating
the claims of economics.

That this needs to be done can be seen by comparing the promise of economics
with its actual results when applied in reality. Mainstream economics argues
that it is based on the idea of "utility" in consumption, i.e. the subjective
pleasure of individuals. Thus production is, it is claimed, aimed at meeting
the demands of consumers. Yet for a system supposedly based on maximising
individual happiness ("utility"), capitalism produces a hell of a lot of
unhappy people. Some radical economists have tried to indicate this and have
created an all-embracing measure of well-being called the Index of Sustainable
Economic Welfare (ISEW). Their conclusions, as summarised by Elliot and
Atkinson, are significant:

> _ "In the 1950s and 1960s the ISEW rose in tandem with per capita GDP. It
was a time not just of rising incomes, but of greater social equity, low
crime, full employment and expanding welfare states. But from the mid-1970s
onwards the two measures started to move apart. GDP per head continued its
inexorable rise, but the ISEW started to decline as a result of lengthening
dole queues, social exclusion, the explosion in crime, habitat loss,
environmental degradation and the growth of environment- and stress-related
illness. By the start of the 1990s, the ISEW was almost back to the levels at
which it started in the early 1950s."_ [Larry Elliot and Dan Atkinson, **Op.
Cit.**, p. 248]

So while capitalism continues to produce more and more goods and, presumably,
maximises more and more individual utility, actual real people are being
"irrational" and not realising they are, in fact, better off and happier.
Ironically, when such unhappiness is pointed out most defenders of capitalism
dismiss people's expressed woe's as irrelevant. Apparently **some** subjective
evaluations are considered more important than others!

Given that the mid-1970s marked the start of neo-liberalism, the promotion of
the market and the reduction of government interference in the economy, this
is surely significant. After all, the _"global economy of the early 21st
century looks a lot more like the economic textbook ideal that did the world
of the 1950s . . . All these changes have followed the advance of economists
that the unfettered market is the best way to allocate resources, and that
well-intentioned interventions which oppose market forces will actually do
more harm than good."_ As such, _"[w]ith the market so much more in control of
the global economy now than fifty years ago, then if economists are right, the
world **should be** a manifestly better place: it should be growing faster,
with more stability, and income should go to those who deserve it."_ However,
_"[u]nfortunately, the world refuses to dance the expected tune. In
particularly, the final ten years of the 20th century were marked, not by
tranquil growth, but by crises."_ [Steve Keen, **Op. Cit.**, p. 2]

These problems and the general unhappiness with the way society is going is
related to various factors, most of which are impossible to reflect in
mainstream economic analysis. They flow from the fact that capitalism is a
system marked by inequalities of wealth and power and so how it develops is
based on them, not the subjective evaluations of atomised individuals that
economics starts with. This in itself is enough to suggest that capitalist
economics is deeply flawed and presents a distinctly flawed picture of
capitalism and how it actually works.

Anarchists argue that this is unsurprising as economics, rather than being a
science is, in fact, little more than an ideology whose main aim is to justify
and rationalise the existing system. We agree with libertarian Marxist Paul
Mattick's summation that economics is _"actually no more than a sophisticated
apology for the social and economic **status quo**"_ and hence the _"growing
discrepancy between [its] theories and reality."_ [**Economics, Politics and
the Age of Inflation**, p. vii] Anarchists, unsurprisingly, see capitalism as
a fundamentally exploitative system rooted in inequalities of power and wealth
dominated by hierarchical structures (capitalist firms). In the sections that
follow, the exploitative nature of capitalism is explained in greater detail.
We would like to point out that for anarchists, exploitation is not more
important than domination. Anarchists are opposed to both equally and consider
them to be two sides of the same coin. You cannot have domination without
exploitation nor exploitation without domination. As Emma Goldman pointed out,
under capitalism:

> _ "wealth means power; the power to subdue, to crush, to exploit, the power
to enslave, to outrage, to degrade . . . Nor is this the only crime . . .
Still more fatal is the crime of turning the producer into a mere particle of
a machine, with less will and decision than his master of steel and iron. Man
is being robbed not merely of the products of his labour, but of the power of
free initiative, of originality, and the interest in, or desire for, the
things he is making."_ [**Red Emma Speaks**, pp. 66-7]

Needless to say, it would be impossible to discuss or refute **every** issue
covered in a standard economics book or every school of economics. As
economist Nicholas Kaldor notes, _"[e]ach year new fashions sweep the
'politico-economic complex' only to disappear again with equal suddenness . .
. These sudden bursts of fashion are a sure sign of the 'pre-scientific' stage
[economics is in], where any crazy idea can get a hearing simply because
nothing is known with sufficient confidence to rule it out."_ [**The Essential
Kaldor**, p. 377] We will have to concentrate on key issues like the flaws in
mainstream economics, why capitalism is exploitative, the existence and role
of economic power, the business cycle, unemployment and inequality.

Nor do we wish to suggest that all forms of economics are useless or equally
bad. Our critique of capitalist economics does not suggest that no economist
has contributed worthwhile and important work to social knowledge or our
understanding of the economy. Far from it. As Bakunin put it, property _"is a
god"_ and has _"its metaphysics. It is the science of the bourgeois
economists. Like any metaphysics it is a sort of twilight, a compromise
between truth and falsehood, with the latter benefiting from it. It seeks to
give falsehood the appearance of truth and leads truth to falsehood."_ [**The
Political Philosophy of Bakunin**, p. 179] How far this is true varies form
school to school, economist to economist. Some have a better understanding of
certain aspects of capitalism than others. Some are more prone to apologetics
than others. Some are aware of the problems of modern economics and _"some of
the most committed economists have concluded that, if economics is to become
less of a religion and more of a science, then the foundations of economics
should be torn down and replaced"_ (although, _"left to [their] own devices"_,
economists _"would continue to build an apparently grand edifice upon rotten
foundations."_). [Keen, **Op. Cit.**, p. 19]

As a rule of thumb, the more free market a particular economist or school of
economics is, the more likely they will be prone to apologetics and
unrealistic assumptions and models. Nor are we suggesting that if someone has
made a positive contribution in one or more areas of economic analysis that
their opinions on other subjects are correct or compatible with anarchist
ideas. It is possible to present a correct analysis of capitalism or
capitalist economics while, at the same time, being blind to the problems of
Keynesian economics or the horrors of Stalinism. As such, our quoting of
certain critical economists does not imply agreement with their political
opinions or policy suggestions.

Then there is the issue of what do we mean by the term "capitalist economics"?
Basically, any form of economic theory which seeks to rationalise and defend
capitalism. This can go from the extreme of free market capitalist economics
(such as the so-called "Austrian" school and Monetarists) to those who
advocate state intervention to keep capitalism going (Keynesian economists).
We will not be discussing those economists who advocate state capitalism. As a
default, we will take "capitalist economics" to refer to the mainstream
"neoclassical" school as this is the dominant form of the ideology and many of
its key features are accepted by the others. This seems applicable, given that
the current version of capitalism being promoted is neo-liberalism where state
intervention is minimised and, when it does happen, directed towards
benefiting the ruling elite.

Lastly, one of the constant refrains of economists is the notion that the
public is ignorant of economics. The implicit assumption behind this bemoaning
of ignorance by economists is that the world should be run either by
economists or on their recommendations. In [section C.11](secC11.md) we
present a case study of a nation, Chile, unlucky enough to have that fate
subjected upon it. Unsurprisingly, this rule by economists could only be
imposed as a result of a military coup and subsequent dictatorship. As would
be expected, given the biases of economics, the wealthy did very well, workers
less so (to put it mildly), in this experiment. Equally unsurprising, the
system was proclaimed an economic miracle -- before it promptly collapsed.

So this section of the FAQ is our modest contribution to making economists
happier by making working class people less ignorant of their subject. As Joan
Robinson put it:

> _ "In short, no economic theory gives us ready-made answers. Any theory that
we follow blindly will lead us astray. To make good use of an economic theory,
we must first sort out the relations of the propagandist and the scientific
elements in it, then by checking with experience, see how far the scientific
element appears convincing, and finally recombine it with our own political
views. The purpose of studying economics is not to acquire a set of ready-made
answers to economic questions, but to learn how to avoid being deceived by
economists."_ [**Contributions to Modern Economics**, p. 75]



[‹ Section C - What are the myths of capitalist economics?](secCcon.md "Go
to previous page" ) [up](secCcon.md "Go to parent page" ) [C.1 What is wrong
with economics? ›](secC1.md "Go to next page" )

