!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_vxc
!! NAME
!! calc_vxc
!! 
!! FUNCTION
!! Compute exchange-correlation potential*r from input density
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  den(meshsz)= input density*4*pi*r^2
!!  densz = dimension of the radial mesh (from 0 to infinity)
!!  iexp1 = the derivatives are exponentially damped below r(iexp1)
!!  pawdata
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %log_step= Logarithmic step corresponding to radial mesh
!!  usdata
!!    %exfact= USpp s code number for the exchange-correlation
!!  un_log= Unit number for log file (comments)
!! 
!! OUTPUT
!!  rvxc(meshsz)= r*exchange-correlation potential
!!
!! SIDE EFFECTS
!!
!!
!! NOTES
!!  This routine comes from Vanderbilt ultrasoft code (uspp)
!!
!! PARENTS
!!      calc_vhtnzc
!!
!! CHILDREN
!!      ctrap,deriv
!!
!! SOURCE

 subroutine calc_vxc(den,densz,iexp1,pawdata,pshead,rvxc,usdata,un_log)

 use defs_basis
 use defs_pawps

 implicit none
 
!Arguments ---------------------------------------------
 integer :: densz,iexp1,un_log
 real(dp) :: den(densz),rvxc(densz)

!These types are defined in defs_pawps
 type(pawdata_type) :: pawdata
 type(pshead_type)  :: pshead
 type(usdata_type)  :: usdata

!Local variables ---------------------------------------
 integer :: iexp2,ir,nneg
 real(dp) :: coef1,coef2,exc,excc,rhoc1,rhoc2,uxc,uxcc
 real(dp), allocatable :: den1(:),fu(:),rab(:),xi(:),xj(:)

!-------------------------------------------------------
 
!Need to translate rad_ into rab for compatibility
 allocate(rab(densz))
 rab(1:densz)=pawdata%rad_(1:densz)*pshead%log_step

!Take measures to ensure that den is greater than zero
 nneg=0
 do ir=2,densz
  if (den(ir)<1.d-30) then
   if (den(ir)<-1.d-30) then
    nneg=nneg+1
   endif
  endif
 enddo
 if (nneg/=0) then
  write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (calc_vxc):'
  write(un_log,'(a,i4,a)')   '    Negative density at',nneg,' r-values !'
  stop 'Program stopped before end'
 endif

!Compute total charge density ->fu()
 allocate(fu(densz))
 do ir=2,densz
  fu(ir)=den(ir)/(four_pi*pawdata%rad(ir)**2)
 enddo
 fu(1)=fu(3) -(fu(4)-fu(2))/2.d0/pawdata%rad_(3)/pshead%log_step&
&             *(pawdata%rad(3)-pawdata%rad(1))

!Specify cutoff density below which the derivatives are exponentially damped
!NOT USED HERE
 rhoc1 = 1.d-10
!Specify cutoff density below which the derivatives are zero
 rhoc2 = 1.d-20

 do ir=2,densz
  if (fu(ir) > rhoc1) iexp1 = ir
  if (fu(ir) > rhoc2) iexp2 = ir
 enddo

 allocate(den1(densz),xi(densz),xj(densz))
 do ir=2,densz
  den1(ir)=den(ir)*pawdata%rad_(ir)
 enddo
 do ir=1,densz
  call ctrap(ir,den1(1:ir),pshead%log_step,xj(ir))
 enddo

!Compute the 1. derivative ->xi
 call deriv(fu,xi,pawdata%rad(1:densz),rab,densz,densz)

!Compute the 2. derivative ->xj
 call deriv(xi,xj,pawdata%rad(1:densz),rab,densz,densz)

!Put the density to zero beyond r(iexp2)
 do ir=iexp2,densz
  xi(ir) = zero
  xj(ir) = zero
 enddo
      
 call xctype(usdata%exfact,rhoc2,0.d0,0.d0,pawdata%rad(iexp2),uxcc,excc)

 coef1 = ( 3.d0 * excc - uxcc ) / rhoc2
 coef2 = (-2.d0 * excc + uxcc ) / rhoc2**2

!Compute exchange-correlation related to total charge density
 rvxc(1)=zero
 do ir=2,densz
  if (fu(ir)>rhoc2) then
   call xctype(usdata%exfact,fu(ir),xi(ir),xj(ir),pawdata%rad(ir),uxc,exc)
  else
   uxc = 2.d0*coef1*fu(ir) + 3.d0*coef2*fu(ir)**2
  endif
  rvxc(ir)=pawdata%rad(ir)*uxc/2.d0
  enddo

 deallocate(fu,xi,xj,rab,den1)

 end subroutine
!!***
