/* EntryMultiCompletion.c generated by valac 0.40.4, the Vala compiler
 * generated from EntryMultiCompletion.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Entry completion for values separated by separators (e.g. comma in the case of tags)*/
/* Partly inspired by the class of the same name in gtkmm-utils by Marko Anastasov*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_ENTRY_MULTI_COMPLETION (entry_multi_completion_get_type ())
#define ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion))
#define ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))
#define IS_ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENTRY_MULTI_COMPLETION))
#define IS_ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENTRY_MULTI_COMPLETION))
#define ENTRY_MULTI_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))

typedef struct _EntryMultiCompletion EntryMultiCompletion;
typedef struct _EntryMultiCompletionClass EntryMultiCompletionClass;
typedef struct _EntryMultiCompletionPrivate EntryMultiCompletionPrivate;
enum  {
	ENTRY_MULTI_COMPLETION_0_PROPERTY,
	ENTRY_MULTI_COMPLETION_NUM_PROPERTIES
};
static GParamSpec* entry_multi_completion_properties[ENTRY_MULTI_COMPLETION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EntryMultiCompletion {
	GtkEntryCompletion parent_instance;
	EntryMultiCompletionPrivate * priv;
};

struct _EntryMultiCompletionClass {
	GtkEntryCompletionClass parent_class;
};

struct _EntryMultiCompletionPrivate {
	gchar* delimiter;
};


static gpointer entry_multi_completion_parent_class = NULL;

GType entry_multi_completion_get_type (void) G_GNUC_CONST;
#define ENTRY_MULTI_COMPLETION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionPrivate))
EntryMultiCompletion* entry_multi_completion_new (GeeCollection* completion_list,
                                                  const gchar* delimiter);
EntryMultiCompletion* entry_multi_completion_construct (GType object_type,
                                                        GeeCollection* completion_list,
                                                        const gchar* delimiter);
static GtkListStore* entry_multi_completion_create_completion_store (GeeCollection* completion_list);
static gboolean entry_multi_completion_match_func (EntryMultiCompletion* self,
                                            GtkEntryCompletion* completion,
                                            const gchar* key,
                                            GtkTreeIter* iter);
static gboolean _entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                             const gchar* key,
                                                                             GtkTreeIter* iter,
                                                                             gpointer self);
static gchar* entry_multi_completion_get_last_part (const gchar* s,
                                             const gchar* delimiter);
static gboolean entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                                     GtkTreeModel* model,
                                                     GtkTreeIter* iter);
static void entry_multi_completion_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean
_entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                    const gchar* key,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self)
{
	gboolean result;
	result = entry_multi_completion_match_func ((EntryMultiCompletion*) self, completion, key, iter);
#line 19 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 102 "EntryMultiCompletion.c"
}


EntryMultiCompletion*
entry_multi_completion_construct (GType object_type,
                                  GeeCollection* completion_list,
                                  const gchar* delimiter)
{
	EntryMultiCompletion * self = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (completion_list), NULL);
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = (EntryMultiCompletion*) g_object_new (object_type, NULL);
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (delimiter == NULL) {
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp0_ = TRUE;
#line 124 "EntryMultiCompletion.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp1_ = strlen (delimiter);
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp2_ = _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp0_ = _tmp2_ == 1;
#line 134 "EntryMultiCompletion.c"
	}
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_vala_assert (_tmp0_, "delimiter == null || delimiter.length == 1");
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = g_strdup (delimiter);
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (self->priv->delimiter);
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self->priv->delimiter = _tmp3_;
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp4_ = entry_multi_completion_create_completion_store (completion_list);
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = _tmp4_;
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_model_get_type (), GtkTreeModel));
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (_tmp5_);
#line 18 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_text_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), 0);
#line 19 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_match_func (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), _entry_multi_completion_match_func_gtk_entry_completion_match_func, g_object_ref (self), g_object_unref);
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return self;
#line 158 "EntryMultiCompletion.c"
}


EntryMultiCompletion*
entry_multi_completion_new (GeeCollection* completion_list,
                            const gchar* delimiter)
{
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return entry_multi_completion_construct (TYPE_ENTRY_MULTI_COMPLETION, completion_list, delimiter);
#line 168 "EntryMultiCompletion.c"
}


static GtkListStore*
entry_multi_completion_create_completion_store (GeeCollection* completion_list)
{
	GtkListStore* result = NULL;
	GtkListStore* completion_store = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter store_iter = {0};
	GeeIterator* completion_iter = NULL;
	GeeIterator* _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (completion_list), NULL);
#line 23 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
#line 23 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	completion_store = _tmp0_;
#line 25 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (completion_list, GEE_TYPE_ITERABLE, GeeIterable));
#line 25 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	completion_iter = _tmp1_;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	while (TRUE) {
#line 193 "EntryMultiCompletion.c"
		GeeIterator* _tmp2_;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp2_ = completion_iter;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (!gee_iterator_next (_tmp2_)) {
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			break;
#line 208 "EntryMultiCompletion.c"
		}
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp3_ = completion_store;
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		gtk_list_store_append (_tmp3_, &_tmp4_);
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		store_iter = _tmp4_;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp5_ = completion_store;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp6_ = store_iter;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp7_ = completion_iter;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp8_ = gee_iterator_get (_tmp7_);
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9_ = (gchar*) _tmp8_;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		gtk_list_store_set (_tmp5_, &_tmp6_, 0, _tmp9_, -1, -1);
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp9_);
#line 230 "EntryMultiCompletion.c"
	}
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	result = completion_store;
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (completion_iter);
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 238 "EntryMultiCompletion.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return self ? g_object_ref (self) : NULL;
#line 247 "EntryMultiCompletion.c"
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 272 "EntryMultiCompletion.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 292 "EntryMultiCompletion.c"
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1055 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1056 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1056 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1058 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1058 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 315 "EntryMultiCompletion.c"
		gchar* _tmp2_;
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1059 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 323 "EntryMultiCompletion.c"
	} else {
#line 1061 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1061 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 329 "EntryMultiCompletion.c"
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 348 "EntryMultiCompletion.c"
}


static gboolean
entry_multi_completion_match_func (EntryMultiCompletion* self,
                                   GtkEntryCompletion* completion,
                                   const gchar* key,
                                   GtkTreeIter* iter)
{
	gboolean result = FALSE;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	gchar* possible_match = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* normed_key = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (IS_ENTRY_MULTI_COMPLETION (self), FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GTK_IS_ENTRY_COMPLETION (completion), FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = gtk_entry_completion_get_model (completion);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	model = _tmp1_;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp2_ = model;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = *iter;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_tree_model_get (_tmp2_, &_tmp3_, 0, &possible_match, -1);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp4_ = possible_match;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp6_ = _tmp5_;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp7_ = g_utf8_normalize (_tmp6_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (possible_match);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	possible_match = _tmp7_;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp6_);
#line 44 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp8_ = g_utf8_normalize (key, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 44 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	normed_key = _tmp8_;
#line 46 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp9_ = self->priv->delimiter;
#line 46 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp9_ == NULL) {
#line 414 "EntryMultiCompletion.c"
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = possible_match;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp11_ = normed_key;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp12_ = string_strip (_tmp11_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp13_ = _tmp12_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp14_ = g_str_has_prefix (_tmp10_, _tmp13_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp13_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp14_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (normed_key);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (possible_match);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_object_unref0 (model);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 442 "EntryMultiCompletion.c"
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* last_part = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gboolean _tmp36_;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp15_ = normed_key;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp16_ = self->priv->delimiter;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (string_contains (_tmp15_, _tmp16_)) {
#line 467 "EntryMultiCompletion.c"
			gint offset = 0;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint position = 0;
			GtkWidget* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp17_ = normed_key;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp18_ = normed_key;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp19_ = self->priv->delimiter;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			offset = g_utf8_strlen (_tmp17_, (gssize) string_last_index_of_char (_tmp18_, (gunichar) string_get (_tmp19_, (glong) 0), 0));
#line 52 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp20_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
#line 52 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			position = gtk_editable_get_position (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_entry_get_type (), GtkEntry), gtk_editable_get_type (), GtkEditable));
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp21_ = position;
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp22_ = offset;
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			if (_tmp21_ <= _tmp22_) {
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				result = FALSE;
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_free0 (normed_key);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_free0 (possible_match);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_object_unref0 (model);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				return result;
#line 504 "EntryMultiCompletion.c"
			}
		}
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp23_ = normed_key;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp24_ = string_strip (_tmp23_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp25_ = _tmp24_;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp26_ = self->priv->delimiter;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp27_ = entry_multi_completion_get_last_part (_tmp25_, _tmp26_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp28_ = _tmp27_;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp25_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		last_part = _tmp28_;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp29_ = last_part;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp30_ = strlen (_tmp29_);
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp31_ = _tmp30_;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (_tmp31_ == 0) {
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			result = FALSE;
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (last_part);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (normed_key);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (possible_match);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_object_unref0 (model);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			return result;
#line 543 "EntryMultiCompletion.c"
		}
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp32_ = possible_match;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp33_ = last_part;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp34_ = string_strip (_tmp33_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp35_ = _tmp34_;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp36_ = g_str_has_prefix (_tmp32_, _tmp35_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp35_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp36_;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (last_part);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (normed_key);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (possible_match);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_object_unref0 (model);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 569 "EntryMultiCompletion.c"
	}
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (normed_key);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (possible_match);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (model);
#line 577 "EntryMultiCompletion.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 601 "EntryMultiCompletion.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 610 "EntryMultiCompletion.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 631 "EntryMultiCompletion.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 635 "EntryMultiCompletion.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 641 "EntryMultiCompletion.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 651 "EntryMultiCompletion.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 655 "EntryMultiCompletion.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 663 "EntryMultiCompletion.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 670 "EntryMultiCompletion.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 674 "EntryMultiCompletion.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 680 "EntryMultiCompletion.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 692 "EntryMultiCompletion.c"
}


static gboolean
entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                            GtkTreeModel* model,
                                            GtkTreeIter* iter)
{
	EntryMultiCompletion * self;
	gboolean result = FALSE;
	gchar* match = NULL;
	GtkTreeIter _tmp0_;
	GtkEntry* entry = NULL;
	GtkWidget* _tmp1_;
	GtkEntry* _tmp2_;
	gchar* old_text = NULL;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	gchar* new_text = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkEntry* _tmp31_;
	GtkEntry* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), FALSE);
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 68 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = *iter;
#line 68 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_tree_model_get (model, &_tmp0_, 0, &match, -1);
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_entry_get_type (), GtkEntry));
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	entry = _tmp2_;
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = entry;
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp4_ = gtk_entry_get_text (_tmp3_);
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = g_utf8_normalize (_tmp4_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	old_text = _tmp5_;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp6_ = old_text;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp7_ = strlen (_tmp6_);
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp8_ = _tmp7_;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp8_ > 0) {
#line 763 "EntryMultiCompletion.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9_ = old_text;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = self->priv->delimiter;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (string_contains (_tmp9_, _tmp10_)) {
#line 772 "EntryMultiCompletion.c"
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp12_ = self->priv->delimiter;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			if (g_strcmp0 (_tmp12_, " ") != 0) {
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_tmp11_ = " ";
#line 787 "EntryMultiCompletion.c"
			} else {
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_tmp11_ = "";
#line 791 "EntryMultiCompletion.c"
			}
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp13_ = old_text;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp14_ = old_text;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp15_ = self->priv->delimiter;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp16_ = string_substring (_tmp13_, (glong) 0, (glong) (string_last_index_of_char (_tmp14_, (gunichar) string_get (_tmp15_, (glong) 0), 0) + 1));
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp17_ = _tmp16_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp18_ = g_strconcat (_tmp17_, _tmp11_, NULL);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (old_text);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			old_text = _tmp18_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (_tmp17_);
#line 811 "EntryMultiCompletion.c"
		} else {
			gchar* _tmp19_;
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp19_ = g_strdup ("");
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (old_text);
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			old_text = _tmp19_;
#line 820 "EntryMultiCompletion.c"
		}
	}
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp21_ = self->priv->delimiter;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (g_strcmp0 (_tmp21_, " ") != 0) {
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp20_ = " ";
#line 829 "EntryMultiCompletion.c"
	} else {
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp20_ = "";
#line 833 "EntryMultiCompletion.c"
	}
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp22_ = old_text;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp23_ = match;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp25_ = _tmp24_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp26_ = self->priv->delimiter;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp28_ = _tmp27_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp29_ = g_strconcat (_tmp28_, _tmp20_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp30_ = _tmp29_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp28_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp25_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	new_text = _tmp30_;
#line 81 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp31_ = entry;
#line 81 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_set_text (_tmp31_, new_text);
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp32_ = entry;
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp33_ = strlen (new_text);
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp34_ = _tmp33_;
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_editable_set_position (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_editable_get_type (), GtkEditable), (gint) _tmp34_);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	result = TRUE;
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (new_text);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (old_text);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (entry);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (match);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 883 "EntryMultiCompletion.c"
}


static gchar*
entry_multi_completion_get_last_part (const gchar* s,
                                      const gchar* delimiter)
{
	gchar* result = NULL;
	gchar** split = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint split_length1;
	gint _split_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (delimiter != NULL, NULL);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = _tmp0_ = g_strsplit (s, delimiter, 0);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split = _tmp1_;
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split_length1 = _vala_array_length (_tmp0_);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_split_size_ = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = split;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3__length1 = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp3_ != NULL) {
#line 918 "EntryMultiCompletion.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4_ = split;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4__length1 = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp5_ = _tmp4_[0];
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp2_ = _tmp5_ != NULL;
#line 930 "EntryMultiCompletion.c"
	} else {
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp2_ = FALSE;
#line 934 "EntryMultiCompletion.c"
	}
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp2_) {
#line 938 "EntryMultiCompletion.c"
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp6_ = split;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp6__length1 = split_length1;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp7_ = split;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp7__length1 = split_length1;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp8_ = _tmp6_[_tmp7__length1 - 1];
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp9_;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 963 "EntryMultiCompletion.c"
	} else {
		gchar* _tmp10_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = g_strdup ("");
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp10_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 974 "EntryMultiCompletion.c"
	}
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 978 "EntryMultiCompletion.c"
}


static void
entry_multi_completion_class_init (EntryMultiCompletionClass * klass)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	entry_multi_completion_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_type_class_add_private (klass, sizeof (EntryMultiCompletionPrivate));
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	((GtkEntryCompletionClass *) klass)->match_selected = (gboolean (*) (GtkEntryCompletion *, GtkTreeModel*, GtkTreeIter*)) entry_multi_completion_real_match_selected;
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	G_OBJECT_CLASS (klass)->finalize = entry_multi_completion_finalize;
#line 993 "EntryMultiCompletion.c"
}


static void
entry_multi_completion_instance_init (EntryMultiCompletion * self)
{
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self->priv = ENTRY_MULTI_COMPLETION_GET_PRIVATE (self);
#line 1002 "EntryMultiCompletion.c"
}


static void
entry_multi_completion_finalize (GObject * obj)
{
	EntryMultiCompletion * self;
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
#line 11 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (self->priv->delimiter);
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	G_OBJECT_CLASS (entry_multi_completion_parent_class)->finalize (obj);
#line 1016 "EntryMultiCompletion.c"
}


GType
entry_multi_completion_get_type (void)
{
	static volatile gsize entry_multi_completion_type_id__volatile = 0;
	if (g_once_init_enter (&entry_multi_completion_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EntryMultiCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) entry_multi_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EntryMultiCompletion), 0, (GInstanceInitFunc) entry_multi_completion_instance_init, NULL };
		GType entry_multi_completion_type_id;
		entry_multi_completion_type_id = g_type_register_static (gtk_entry_completion_get_type (), "EntryMultiCompletion", &g_define_type_info, 0);
		g_once_init_leave (&entry_multi_completion_type_id__volatile, entry_multi_completion_type_id);
	}
	return entry_multi_completion_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



