/* Dimensions.c generated by valac 0.40.4, the Vala compiler
 * generated from Dimensions.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ZOOM_STATE (zoom_state_get_type ())
typedef struct _ZoomState ZoomState;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ZoomState {
	Dimensions content_dimensions;
	Dimensions viewport_dimensions;
	gdouble zoom_factor;
	gdouble interpolation_factor;
	gdouble min_factor;
	gdouble max_factor;
	GdkPoint viewport_center;
};



GType scale_constraint_get_type (void) G_GNUC_CONST;
gchar* scale_constraint_to_string (ScaleConstraint self);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
void dimensions_for_allocation (GtkAllocation* allocation,
                                Dimensions* result);
void dimensions_for_widget_allocation (GtkWidget* widget,
                                       Dimensions* result);
void dimensions_for_rectangle (GdkRectangle* rect,
                               Dimensions* result);
gboolean dimensions_has_area (Dimensions *self);
void dimensions_floor (Dimensions *self,
                       Dimensions* min,
                       Dimensions* result);
gchar* dimensions_to_string (Dimensions *self);
gboolean dimensions_equals (Dimensions *self,
                            Dimensions* dim);
gboolean dimensions_approx_equals (Dimensions *self,
                                   Dimensions* dim,
                                   gint fudge);
gboolean dimensions_approx_scaled (Dimensions *self,
                                   gint scale,
                                   gint fudge);
gint dimensions_major_axis (Dimensions *self);
gint dimensions_minor_axis (Dimensions *self);
void dimensions_with_min (Dimensions *self,
                          gint min_width,
                          gint min_height,
                          Dimensions* result);
void dimensions_with_max (Dimensions *self,
                          gint max_width,
                          gint max_height,
                          Dimensions* result);
void dimensions_get_scaled (Dimensions *self,
                            gint scale,
                            gboolean scale_up,
                            Dimensions* result);
void dimensions_get_scaled_by_width (Dimensions *self,
                                     gint scale,
                                     Dimensions* result);
void dimensions_get_scaled_by_height (Dimensions *self,
                                      gint scale,
                                      Dimensions* result);
void dimensions_get_scale_ratios (Dimensions *self,
                                  Dimensions* scaled,
                                  gdouble* width_ratio,
                                  gdouble* height_ratio);
gdouble dimensions_get_aspect_ratio (Dimensions *self);
void dimensions_get_scaled_proportional (Dimensions *self,
                                         Dimensions* viewport,
                                         Dimensions* result);
void dimensions_get_scaled_to_fill_viewport (Dimensions *self,
                                             Dimensions* viewport,
                                             Dimensions* result);
void dimensions_get_scaled_rectangle (Dimensions *self,
                                      Dimensions* scaled,
                                      GdkRectangle* rect,
                                      GdkRectangle* result);
void dimensions_get_scaled_similar (Dimensions *self,
                                    Dimensions* original,
                                    Dimensions* scaled,
                                    Dimensions* result);
void dimensions_get_scaled_by_constraint (Dimensions *self,
                                          gint scale,
                                          ScaleConstraint constraint,
                                          Dimensions* result);
GType scaling_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
#define SCALING_NO_SCALE 0
static void scaling_init (Scaling *self,
                   ScaleConstraint constraint,
                   gint scale,
                   Dimensions* viewport,
                   gboolean scale_up);
void scaling_for_original (Scaling* result);
void scaling_for_screen (GtkWindow* window,
                         gboolean scale_up,
                         Scaling* result);
void scaling_for_viewport (Dimensions* viewport,
                           gboolean scale_up,
                           Scaling* result);
static void scaling_get_screen_dimensions (GtkWindow* window,
                                    Dimensions* result);
void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
void scaling_for_widget (GtkWidget* widget,
                         gboolean scale_up,
                         Scaling* result);
void scaling_to_fill_viewport (Dimensions* viewport,
                               Scaling* result);
void scaling_to_fill_screen (GtkWindow* window,
                             Scaling* result);
void scaling_for_constraint (ScaleConstraint constraint,
                             gint scale,
                             gboolean scale_up,
                             Scaling* result);
static gint scaling_scale_to_pixels (Scaling *self);
gboolean scaling_is_unscaled (Scaling *self);
gboolean scaling_is_best_fit (Scaling *self,
                              Dimensions* original,
                              gint* pixels);
gboolean scaling_is_best_fit_dimensions (Scaling *self,
                                         Dimensions* original,
                                         Dimensions* scaled);
gboolean scaling_is_for_viewport (Scaling *self,
                                  Dimensions* original,
                                  Dimensions* scaled);
gboolean scaling_is_fill_viewport (Scaling *self,
                                   Dimensions* original,
                                   Dimensions* scaled);
void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
gchar* scaling_to_string (Scaling *self);
gboolean scaling_equals (Scaling *self,
                         Scaling* scaling);
GType zoom_state_get_type (void) G_GNUC_CONST;
ZoomState* zoom_state_dup (const ZoomState* self);
void zoom_state_free (ZoomState* self);
void zoom_state_init (ZoomState *self,
                      Dimensions* content_dimensions,
                      Dimensions* viewport_dimensions,
                      gdouble slider_val,
                      GdkPoint* viewport_center);
static void zoom_state_compute_zoom_factors (ZoomState *self);
static void zoom_state_center_viewport (ZoomState *self);
static void zoom_state_clamp_viewport_center (ZoomState *self);
void zoom_state_init_rescale (ZoomState *self,
                              ZoomState* existing,
                              gdouble new_slider_val);
void zoom_state_init_rescale_to_isomorphic (ZoomState *self,
                                            ZoomState* existing);
void zoom_state_init_pan (ZoomState *self,
                          ZoomState* existing,
                          GdkPoint* new_viewport_center);
gint zoom_state_get_zoomed_width (ZoomState *self);
gint zoom_state_get_zoomed_height (ZoomState *self);
gdouble zoom_state_get_interpolation_factor (ZoomState *self);
void zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self,
                                                   GdkRectangle* result);
void zoom_state_get_viewing_rectangle_wrt_screen (ZoomState *self,
                                                  GdkRectangle* result);
void zoom_state_get_viewing_rectangle_projection (ZoomState *self,
                                                  GdkPixbuf* for_pixbuf,
                                                  GdkRectangle* result);
gdouble zoom_state_get_zoom_factor (ZoomState *self);
void zoom_state_get_viewport_center (ZoomState *self,
                                     GdkPoint* result);
gchar* zoom_state_to_string (ZoomState *self);
gboolean zoom_state_is_min (ZoomState *self);
gboolean zoom_state_is_default (ZoomState *self);
gboolean zoom_state_is_isomorphic (ZoomState *self);
gboolean zoom_state_is_max (ZoomState *self);
gboolean zoom_state_equals (ZoomState *self,
                            ZoomState* other);


gchar*
scale_constraint_to_string (ScaleConstraint self)
{
	gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (self) {
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 258 "Dimensions.c"
		{
			gchar* _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp0_ = g_strdup (_ ("Original size"));
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 267 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_DIMENSIONS:
#line 271 "Dimensions.c"
		{
			gchar* _tmp1_;
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = g_strdup (_ ("Longest edge"));
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp1_;
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 280 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_WIDTH:
#line 284 "Dimensions.c"
		{
			gchar* _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = g_strdup (_ ("Width"));
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 293 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_HEIGHT:
#line 297 "Dimensions.c"
		{
			gchar* _tmp3_;
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = g_strdup (_ ("Height"));
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp3_;
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 306 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 310 "Dimensions.c"
		{
			gchar* _tmp4_;
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = g_strdup ("Fill Viewport");
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp4_;
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 319 "Dimensions.c"
		}
		default:
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		break;
#line 324 "Dimensions.c"
	}
#line 33 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_warn_if_reached ();
#line 35 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = NULL;
#line 35 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 332 "Dimensions.c"
}


GType
scale_constraint_get_type (void)
{
	static volatile gsize scale_constraint_type_id__volatile = 0;
	if (g_once_init_enter (&scale_constraint_type_id__volatile)) {
		static const GEnumValue values[] = {{SCALE_CONSTRAINT_ORIGINAL, "SCALE_CONSTRAINT_ORIGINAL", "original"}, {SCALE_CONSTRAINT_DIMENSIONS, "SCALE_CONSTRAINT_DIMENSIONS", "dimensions"}, {SCALE_CONSTRAINT_WIDTH, "SCALE_CONSTRAINT_WIDTH", "width"}, {SCALE_CONSTRAINT_HEIGHT, "SCALE_CONSTRAINT_HEIGHT", "height"}, {SCALE_CONSTRAINT_FILL_VIEWPORT, "SCALE_CONSTRAINT_FILL_VIEWPORT", "fill-viewport"}, {0, NULL, NULL}};
		GType scale_constraint_type_id;
		scale_constraint_type_id = g_enum_register_static ("ScaleConstraint", values);
		g_once_init_leave (&scale_constraint_type_id__volatile, scale_constraint_type_id);
	}
	return scale_constraint_type_id__volatile;
}


void
dimensions_init (Dimensions *self,
                 gint width,
                 gint height)
{
	gboolean _tmp0_ = FALSE;
#line 43 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (Dimensions));
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (width < 0) {
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = TRUE;
#line 362 "Dimensions.c"
	} else {
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = height < 0;
#line 366 "Dimensions.c"
	}
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 45 "/home/jens/Source/shotwell/src/Dimensions.vala"
		g_warning ("Dimensions.vala:45: Tried to construct a Dimensions object with negati" \
"ve width or height - forcing sensible default values.");
#line 372 "Dimensions.c"
	}
#line 47 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).width = CLAMP (width, 0, width);
#line 48 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).height = CLAMP (height, 0, height);
#line 378 "Dimensions.c"
}


void
dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                       Dimensions* result)
{
	Dimensions _tmp0_ = {0};
#line 51 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp0_, gdk_pixbuf_get_width (pixbuf), gdk_pixbuf_get_height (pixbuf));
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp0_;
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 395 "Dimensions.c"
}


void
dimensions_for_allocation (GtkAllocation* allocation,
                           Dimensions* result)
{
	GtkAllocation _tmp0_;
	gint _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
#line 55 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (allocation != NULL);
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *allocation;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *allocation;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.height;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 424 "Dimensions.c"
}


void
dimensions_for_widget_allocation (GtkWidget* widget,
                                  Dimensions* result)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_ = {0};
#line 59 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 61 "/home/jens/Source/shotwell/src/Dimensions.vala"
	gtk_widget_get_allocation (widget, &_tmp0_);
#line 61 "/home/jens/Source/shotwell/src/Dimensions.vala"
	allocation = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = allocation;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _tmp1_.width;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = allocation;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.height;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp5_;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 459 "Dimensions.c"
}


void
dimensions_for_rectangle (GdkRectangle* rect,
                          Dimensions* result)
{
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
#line 66 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (rect != NULL);
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *rect;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *rect;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.height;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 488 "Dimensions.c"
}


gboolean
dimensions_has_area (Dimensions *self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ > 0) {
#line 502 "Dimensions.c"
		gint _tmp2_;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).height;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_ > 0;
#line 508 "Dimensions.c"
	} else {
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 512 "Dimensions.c"
	}
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 518 "Dimensions.c"
}


void
dimensions_floor (Dimensions *self,
                  Dimensions* min,
                  Dimensions* result)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	gint _tmp7_ = 0;
	gint _tmp8_;
	Dimensions _tmp9_;
	gint _tmp10_;
	Dimensions _tmp14_ = {0};
#line 74 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (min != NULL);
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *min;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ > _tmp3_) {
#line 546 "Dimensions.c"
		gint _tmp4_;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_;
#line 552 "Dimensions.c"
	} else {
		Dimensions _tmp5_;
		gint _tmp6_;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *min;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp6_;
#line 562 "Dimensions.c"
	}
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = (*self).height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = *min;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp8_ > _tmp10_) {
#line 572 "Dimensions.c"
		gint _tmp11_;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = (*self).height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp11_;
#line 578 "Dimensions.c"
	} else {
		Dimensions _tmp12_;
		gint _tmp13_;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = *min;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = _tmp12_.height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp13_;
#line 588 "Dimensions.c"
	}
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp14_, _tmp0_, _tmp7_);
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp14_;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 596 "Dimensions.c"
}


gchar*
dimensions_to_string (Dimensions *self)
{
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = g_strdup_printf ("%dx%d", _tmp0_, _tmp1_);
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp2_;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 617 "Dimensions.c"
}


gboolean
dimensions_equals (Dimensions *self,
                   Dimensions* dim)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
#line 83 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (dim != NULL, FALSE);
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *dim;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ == _tmp3_) {
#line 640 "Dimensions.c"
		gint _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).height;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *dim;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.height;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_ == _tmp6_;
#line 652 "Dimensions.c"
	} else {
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 656 "Dimensions.c"
	}
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 662 "Dimensions.c"
}


gboolean
dimensions_approx_equals (Dimensions *self,
                          Dimensions* dim,
                          gint fudge)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
#line 88 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (dim != NULL, FALSE);
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *dim;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (abs (_tmp1_ - _tmp3_) <= fudge) {
#line 686 "Dimensions.c"
		gint _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).height;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *dim;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.height;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = abs (_tmp4_ - _tmp6_) <= fudge;
#line 698 "Dimensions.c"
	} else {
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 702 "Dimensions.c"
	}
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 708 "Dimensions.c"
}


gboolean
dimensions_approx_scaled (Dimensions *self,
                          gint scale,
                          gint fudge)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ <= (scale + fudge)) {
#line 724 "Dimensions.c"
		gint _tmp2_;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).height;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_ <= (scale + fudge);
#line 730 "Dimensions.c"
	} else {
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 734 "Dimensions.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 740 "Dimensions.c"
}


gint
dimensions_major_axis (Dimensions *self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = MAX (_tmp0_, _tmp1_);
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 758 "Dimensions.c"
}


gint
dimensions_minor_axis (Dimensions *self)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = MIN (_tmp0_, _tmp1_);
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 776 "Dimensions.c"
}


void
dimensions_with_min (Dimensions *self,
                     gint min_width,
                     gint min_height,
                     Dimensions* result)
{
	gint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_ = {0};
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, MAX (_tmp0_, min_width), MAX (_tmp1_, min_height));
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 799 "Dimensions.c"
}


void
dimensions_with_max (Dimensions *self,
                     gint max_width,
                     gint max_height,
                     Dimensions* result)
{
	gint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_ = {0};
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, MIN (_tmp0_, max_width), MIN (_tmp1_, max_height));
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp2_;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 822 "Dimensions.c"
}


void
dimensions_get_scaled (Dimensions *self,
                       gint scale,
                       gboolean scale_up,
                       Dimensions* result)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp10_ = FALSE;
	gint _tmp17_;
	gint _tmp18_;
#line 113 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (scale > 0, "scale > 0");
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).width;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_ == scale) {
#line 844 "Dimensions.c"
		gint _tmp3_;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = (*self).height;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = _tmp3_ < scale;
#line 850 "Dimensions.c"
	} else {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = FALSE;
#line 854 "Dimensions.c"
	}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = TRUE;
#line 860 "Dimensions.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gint _tmp5_;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).height;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp5_ == scale) {
#line 868 "Dimensions.c"
			gint _tmp6_;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = (*self).width;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = _tmp6_ < scale;
#line 874 "Dimensions.c"
		} else {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = FALSE;
#line 878 "Dimensions.c"
		}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_;
#line 882 "Dimensions.c"
	}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 886 "Dimensions.c"
		gint _tmp7_;
		gint _tmp8_;
		Dimensions _tmp9_ = {0};
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).width;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = (*self).height;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_init (&_tmp9_, _tmp7_, _tmp8_);
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp9_;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 900 "Dimensions.c"
	}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!scale_up) {
#line 904 "Dimensions.c"
		gboolean _tmp11_ = FALSE;
		gint _tmp12_;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = (*self).width;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp12_ < scale) {
#line 911 "Dimensions.c"
			gint _tmp13_;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp13_ = (*self).height;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp11_ = _tmp13_ < scale;
#line 917 "Dimensions.c"
		} else {
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp11_ = FALSE;
#line 921 "Dimensions.c"
		}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = _tmp11_;
#line 925 "Dimensions.c"
	} else {
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = FALSE;
#line 929 "Dimensions.c"
	}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp10_) {
#line 933 "Dimensions.c"
		gint _tmp14_;
		gint _tmp15_;
		Dimensions _tmp16_ = {0};
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = (*self).width;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = (*self).height;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_init (&_tmp16_, _tmp14_, _tmp15_);
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp16_;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 947 "Dimensions.c"
	}
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = (*self).width;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = (*self).height;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if ((_tmp17_ - scale) > (_tmp18_ - scale)) {
#line 955 "Dimensions.c"
		Dimensions _tmp19_ = {0};
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_get_scaled_by_width (&(*self), scale, &_tmp19_);
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp19_;
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 963 "Dimensions.c"
	} else {
		Dimensions _tmp20_ = {0};
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_get_scaled_by_height (&(*self), scale, &_tmp20_);
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp20_;
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 972 "Dimensions.c"
	}
}


void
dimensions_get_scale_ratios (Dimensions *self,
                             Dimensions* scaled,
                             gdouble* width_ratio,
                             gdouble* height_ratio)
{
	gdouble _vala_width_ratio = 0.0;
	gdouble _vala_height_ratio = 0.0;
	Dimensions _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Dimensions _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).width;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_width_ratio = ((gdouble) _tmp1_) / ((gdouble) _tmp2_);
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *scaled;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.height;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = (*self).height;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_height_ratio = ((gdouble) _tmp4_) / ((gdouble) _tmp5_);
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (width_ratio) {
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*width_ratio = _vala_width_ratio;
#line 1013 "Dimensions.c"
	}
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (height_ratio) {
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*height_ratio = _vala_height_ratio;
#line 1019 "Dimensions.c"
	}
}


gdouble
dimensions_get_aspect_ratio (Dimensions *self)
{
	gdouble result = 0.0;
	gint _tmp0_;
	gint _tmp1_;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = ((gdouble) _tmp0_) / _tmp1_;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 1038 "Dimensions.c"
}


void
dimensions_get_scaled_proportional (Dimensions *self,
                                    Dimensions* viewport,
                                    Dimensions* result)
{
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	gdouble _tmp3_;
	gdouble _tmp4_;
	Dimensions scaled = {0};
	gdouble _tmp13_;
	gdouble _tmp14_;
	Dimensions _tmp15_ = {0};
	Dimensions _tmp16_ = {0};
	Dimensions _tmp17_ = {0};
	Dimensions _tmp18_;
	gint _tmp19_;
	Dimensions _tmp20_;
	gint _tmp21_;
	Dimensions _tmp22_;
	gint _tmp23_;
	Dimensions _tmp24_;
	gint _tmp25_;
#line 138 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	width_ratio = _tmp1_;
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	height_ratio = _tmp2_;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = width_ratio;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = height_ratio;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_ < _tmp4_) {
#line 1086 "Dimensions.c"
		Dimensions _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gdouble _tmp8_;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *viewport;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.width;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = (gdouble) _tmp6_;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).height;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = width_ratio;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = ((gdouble) _tmp7_) * _tmp8_;
#line 1103 "Dimensions.c"
	} else {
		gint _tmp9_;
		gdouble _tmp10_;
		Dimensions _tmp11_;
		gint _tmp12_;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = (*self).width;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = height_ratio;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = ((gdouble) _tmp9_) * _tmp10_;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = *viewport;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = _tmp11_.height;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = (gdouble) _tmp12_;
#line 1121 "Dimensions.c"
	}
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = scaled_width;
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = scaled_height;
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp15_, (gint) round (_tmp13_), (gint) round (_tmp14_));
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp16_, 1, 1);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp15_, &_tmp16_, &_tmp17_);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp17_;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = scaled;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = _tmp18_.height;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = *viewport;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = _tmp20_.height;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp19_ <= _tmp21_, "scaled.height <= viewport.height");
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = scaled;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_.width;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = *viewport;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.width;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp23_ <= _tmp25_, "scaled.width <= viewport.width");
#line 156 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled;
#line 156 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1159 "Dimensions.c"
}


void
dimensions_get_scaled_to_fill_viewport (Dimensions *self,
                                        Dimensions* viewport,
                                        Dimensions* result)
{
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	Dimensions _tmp5_;
	gint _tmp6_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	Dimensions _tmp33_ = {0};
	Dimensions _tmp34_ = {0};
	Dimensions _tmp35_ = {0};
#line 159 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	width_ratio = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	height_ratio = _tmp2_;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).width;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = *viewport;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.width;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_ < _tmp6_) {
#line 1202 "Dimensions.c"
		gint _tmp7_;
		Dimensions _tmp8_;
		gint _tmp9_;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).height;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = *viewport;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.height;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = _tmp7_ >= _tmp9_;
#line 1214 "Dimensions.c"
	} else {
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = FALSE;
#line 1218 "Dimensions.c"
	}
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_) {
#line 1222 "Dimensions.c"
		Dimensions _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gdouble _tmp13_;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = *viewport;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = _tmp10_.width;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = (gdouble) _tmp11_;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = (*self).height;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = width_ratio;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = ((gdouble) _tmp12_) * _tmp13_;
#line 1239 "Dimensions.c"
	} else {
		gboolean _tmp14_ = FALSE;
		gint _tmp15_;
		Dimensions _tmp16_;
		gint _tmp17_;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = (*self).width;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = *viewport;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = _tmp16_.width;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp15_ >= _tmp17_) {
#line 1253 "Dimensions.c"
			gint _tmp18_;
			Dimensions _tmp19_;
			gint _tmp20_;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp18_ = (*self).height;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp19_ = *viewport;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp20_ = _tmp19_.height;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp14_ = _tmp18_ < _tmp20_;
#line 1265 "Dimensions.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp14_ = FALSE;
#line 1269 "Dimensions.c"
		}
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp14_) {
#line 1273 "Dimensions.c"
			gint _tmp21_;
			gdouble _tmp22_;
			Dimensions _tmp23_;
			gint _tmp24_;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp21_ = (*self).width;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp22_ = height_ratio;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_width = ((gdouble) _tmp21_) * _tmp22_;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp23_ = *viewport;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp24_ = _tmp23_.height;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_height = (gdouble) _tmp24_;
#line 1290 "Dimensions.c"
		} else {
			gdouble ratio = 0.0;
			gdouble _tmp25_;
			gdouble _tmp26_;
			gint _tmp27_;
			gdouble _tmp28_;
			gint _tmp29_;
			gdouble _tmp30_;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp25_ = width_ratio;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp26_ = height_ratio;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			ratio = MAX (_tmp25_, _tmp26_);
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp27_ = (*self).width;
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp28_ = ratio;
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_width = ((gdouble) _tmp27_) * _tmp28_;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp29_ = (*self).height;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp30_ = ratio;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_height = ((gdouble) _tmp29_) * _tmp30_;
#line 1317 "Dimensions.c"
		}
	}
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = scaled_width;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = scaled_height;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp33_, (gint) round (_tmp31_), (gint) round (_tmp32_));
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp34_, 1, 1);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp33_, &_tmp34_, &_tmp35_);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp35_;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1334 "Dimensions.c"
}


void
dimensions_get_scaled_rectangle (Dimensions *self,
                                 Dimensions* scaled,
                                 GdkRectangle* rect,
                                 GdkRectangle* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GdkRectangle scaled_rect = {0};
	GdkRectangle _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gdouble _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_;
	gdouble _tmp11_;
	GdkRectangle _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_;
	GdkRectangle _tmp17_;
	gint _tmp18_;
#line 183 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 183 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (rect != NULL);
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	x_scale = _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	y_scale = _tmp2_;
#line 187 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&scaled_rect, 0, sizeof (GdkRectangle));
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *rect;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.x;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = x_scale;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.x = (gint) round (((gdouble) _tmp4_) * _tmp5_);
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *rect;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _tmp6_.y;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = y_scale;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.y = (gint) round (((gdouble) _tmp7_) * _tmp8_);
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = *rect;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.width;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = x_scale;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.width = (gint) round (((gdouble) _tmp10_) * _tmp11_);
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = *rect;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = _tmp12_.height;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = y_scale;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.height = (gint) round (((gdouble) _tmp13_) * _tmp14_);
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = scaled_rect;
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.width;
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp16_ <= 0) {
#line 194 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_rect.width = 1;
#line 1420 "Dimensions.c"
	}
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = scaled_rect;
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = _tmp17_.height;
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp18_ <= 0) {
#line 197 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_rect.height = 1;
#line 1430 "Dimensions.c"
	}
#line 199 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled_rect;
#line 199 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1436 "Dimensions.c"
}


void
dimensions_get_scaled_similar (Dimensions *self,
                               Dimensions* original,
                               Dimensions* scaled,
                               Dimensions* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scale = 0.0;
	gint _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_ = {0};
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
#line 203 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (original != NULL);
#line 203 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (original, &_tmp0_, &_tmp1_, &_tmp2_);
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	x_scale = _tmp1_;
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	y_scale = _tmp2_;
#line 207 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scale = MIN (x_scale, y_scale);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = (*self).width;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).height;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp5_, (gint) round (((gdouble) _tmp3_) * scale), (gint) round (((gdouble) _tmp4_) * scale));
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, 1, 1);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp5_, &_tmp6_, &_tmp7_);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp7_;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1485 "Dimensions.c"
}


void
dimensions_get_scaled_by_width (Dimensions *self,
                                gint scale,
                                Dimensions* result)
{
	gdouble ratio = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	Dimensions _tmp4_ = {0};
#line 214 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (scale > 0, "scale > 0");
#line 216 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 216 "/home/jens/Source/shotwell/src/Dimensions.vala"
	ratio = ((gdouble) scale) / ((gdouble) _tmp0_);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, scale, (gint) round (((gdouble) _tmp1_) * ratio));
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp3_, 1, 1);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp2_, &_tmp3_, &_tmp4_);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1518 "Dimensions.c"
}


void
dimensions_get_scaled_by_height (Dimensions *self,
                                 gint scale,
                                 Dimensions* result)
{
	gdouble ratio = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	Dimensions _tmp4_ = {0};
#line 222 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (scale > 0, "scale > 0");
#line 224 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).height;
#line 224 "/home/jens/Source/shotwell/src/Dimensions.vala"
	ratio = ((gdouble) scale) / ((gdouble) _tmp0_);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, (gint) round (((gdouble) _tmp1_) * ratio), scale);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp3_, 1, 1);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp2_, &_tmp3_, &_tmp4_);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1551 "Dimensions.c"
}


void
dimensions_get_scaled_by_constraint (Dimensions *self,
                                     gint scale,
                                     ScaleConstraint constraint,
                                     Dimensions* result)
{
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (constraint) {
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 1565 "Dimensions.c"
		{
			gint _tmp0_;
			gint _tmp1_;
			Dimensions _tmp2_ = {0};
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp0_ = (*self).width;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = (*self).height;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_init (&_tmp2_, _tmp0_, _tmp1_);
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp2_;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1580 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_DIMENSIONS:
#line 1584 "Dimensions.c"
		{
			Dimensions _tmp3_ = {0};
			gint _tmp4_;
			gint _tmp5_;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = (*self).width;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = (*self).height;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp4_ >= _tmp5_) {
#line 1595 "Dimensions.c"
				Dimensions _tmp6_ = {0};
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_by_width (&(*self), scale, &_tmp6_);
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = _tmp6_;
#line 1601 "Dimensions.c"
			} else {
				Dimensions _tmp7_ = {0};
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_by_height (&(*self), scale, &_tmp7_);
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = _tmp7_;
#line 1608 "Dimensions.c"
			}
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp3_;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1614 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_WIDTH:
#line 1618 "Dimensions.c"
		{
			Dimensions _tmp8_ = {0};
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_width (&(*self), scale, &_tmp8_);
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp8_;
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1627 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_HEIGHT:
#line 1631 "Dimensions.c"
		{
			Dimensions _tmp9_ = {0};
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_height (&(*self), scale, &_tmp9_);
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp9_;
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1640 "Dimensions.c"
		}
		default:
		{
#line 244 "/home/jens/Source/shotwell/src/Dimensions.vala"
			g_error ("Dimensions.vala:244: Bad constraint: %d", (gint) constraint);
#line 1646 "Dimensions.c"
		}
	}
}


Dimensions*
dimensions_dup (const Dimensions* self)
{
	Dimensions* dup;
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (Dimensions, 1);
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (Dimensions));
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 1662 "Dimensions.c"
}


void
dimensions_free (Dimensions* self)
{
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 1671 "Dimensions.c"
}


GType
dimensions_get_type (void)
{
	static volatile gsize dimensions_type_id__volatile = 0;
	if (g_once_init_enter (&dimensions_type_id__volatile)) {
		GType dimensions_type_id;
		dimensions_type_id = g_boxed_type_register_static ("Dimensions", (GBoxedCopyFunc) dimensions_dup, (GBoxedFreeFunc) dimensions_free);
		g_once_init_leave (&dimensions_type_id__volatile, dimensions_type_id);
	}
	return dimensions_type_id__volatile;
}


static void
scaling_init (Scaling *self,
              ScaleConstraint constraint,
              gint scale,
              Dimensions* viewport,
              gboolean scale_up)
{
	Dimensions _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 257 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (Scaling));
#line 258 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).constraint = constraint;
#line 259 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).scale = scale;
#line 260 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 260 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport = _tmp0_;
#line 261 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).scale_up = scale_up;
#line 1710 "Dimensions.c"
}


void
scaling_for_original (Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp0_, 0, 0);
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_ORIGINAL, SCALING_NO_SCALE, &_tmp0_, FALSE);
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1727 "Dimensions.c"
}


void
scaling_for_screen (GtkWindow* window,
                    gboolean scale_up,
                    Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 268 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_get_screen_dimensions (window, &_tmp0_);
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_for_viewport (&_tmp0_, scale_up, &_tmp1_);
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1748 "Dimensions.c"
}


void
scaling_for_best_fit (gint pixels,
                      gboolean scale_up,
                      Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 273 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (pixels > 0, "pixels > 0");
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp0_, 0, 0);
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_DIMENSIONS, pixels, &_tmp0_, scale_up);
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1769 "Dimensions.c"
}


void
scaling_for_viewport (Dimensions* viewport,
                      gboolean scale_up,
                      Scaling* result)
{
	Dimensions _tmp0_;
	Scaling _tmp1_ = {0};
#line 278 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 279 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (dimensions_has_area (viewport), "viewport.has_area()");
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp0_, scale_up);
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1792 "Dimensions.c"
}


void
scaling_for_widget (GtkWidget* widget,
                    gboolean scale_up,
                    Scaling* result)
{
	Dimensions viewport = {0};
	Dimensions _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	gint _tmp3_;
	Dimensions _tmp7_;
	Scaling _tmp8_ = {0};
#line 284 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 285 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_for_widget_allocation (widget, &_tmp0_);
#line 285 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport = _tmp0_;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = viewport;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_ <= 1) {
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = TRUE;
#line 1822 "Dimensions.c"
	} else {
		Dimensions _tmp4_;
		gint _tmp5_;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = viewport;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = _tmp4_.height;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = _tmp5_ <= 1;
#line 1832 "Dimensions.c"
	}
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 1836 "Dimensions.c"
		Scaling _tmp6_ = {0};
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaling_for_original (&_tmp6_);
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp6_;
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 1844 "Dimensions.c"
	}
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = viewport;
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp8_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp7_, scale_up);
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp8_;
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1854 "Dimensions.c"
}


void
scaling_to_fill_viewport (Dimensions* viewport,
                          Scaling* result)
{
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_;
	gint _tmp2_;
	Dimensions _tmp6_;
	Scaling _tmp7_ = {0};
#line 301 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *viewport;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _tmp1_.width;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_ <= 1) {
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = TRUE;
#line 1877 "Dimensions.c"
	} else {
		Dimensions _tmp3_;
		gint _tmp4_;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = *viewport;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = _tmp3_.height;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 1887 "Dimensions.c"
	}
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 1891 "Dimensions.c"
		Scaling _tmp5_ = {0};
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaling_for_original (&_tmp5_);
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp5_;
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 1899 "Dimensions.c"
	}
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *viewport;
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp7_, SCALE_CONSTRAINT_FILL_VIEWPORT, SCALING_NO_SCALE, &_tmp6_, TRUE);
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp7_;
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1909 "Dimensions.c"
}


void
scaling_to_fill_screen (GtkWindow* window,
                        Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 310 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_get_screen_dimensions (window, &_tmp0_);
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_to_fill_viewport (&_tmp0_, &_tmp1_);
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1929 "Dimensions.c"
}


void
scaling_for_constraint (ScaleConstraint constraint,
                        gint scale,
                        gboolean scale_up,
                        Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp0_, 0, 0);
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp1_, constraint, scale, &_tmp0_, scale_up);
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1949 "Dimensions.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return self ? g_object_ref (self) : NULL;
#line 1958 "Dimensions.c"
}


static void
scaling_get_screen_dimensions (GtkWindow* window,
                               Dimensions* result)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	Dimensions _tmp2_ = {0};
#line 318 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = gtk_window_get_screen (window);
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	screen = _tmp1_;
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, gdk_screen_get_width (screen), gdk_screen_get_height (screen));
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp2_;
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_g_object_unref0 (screen);
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1986 "Dimensions.c"
}


static gint
scaling_scale_to_pixels (Scaling *self)
{
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).scale;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ >= 0) {
#line 2000 "Dimensions.c"
		gint _tmp2_;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).scale;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_;
#line 2006 "Dimensions.c"
	} else {
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = 0;
#line 2010 "Dimensions.c"
	}
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2016 "Dimensions.c"
}


gboolean
scaling_is_unscaled (Scaling *self)
{
	gboolean result = FALSE;
	ScaleConstraint _tmp0_;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == SCALE_CONSTRAINT_ORIGINAL;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2031 "Dimensions.c"
}


gboolean
scaling_is_best_fit (Scaling *self,
                     Dimensions* original,
                     gint* pixels)
{
	gint _vala_pixels = 0;
	gboolean result = FALSE;
	gint _tmp0_;
	ScaleConstraint _tmp1_;
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 333 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_pixels = 0;
#line 335 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 335 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALING_NO_SCALE) {
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (pixels) {
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*pixels = _vala_pixels;
#line 2058 "Dimensions.c"
		}
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2062 "Dimensions.c"
	}
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2072 "Dimensions.c"
		{
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (pixels) {
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*pixels = _vala_pixels;
#line 2080 "Dimensions.c"
			}
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2084 "Dimensions.c"
		}
		default:
		{
			gint _tmp2_;
#line 344 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_pixels = scaling_scale_to_pixels (&(*self));
#line 345 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = _vala_pixels;
#line 345 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (_tmp2_ > 0, "pixels > 0");
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (pixels) {
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*pixels = _vala_pixels;
#line 2101 "Dimensions.c"
			}
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2105 "Dimensions.c"
		}
	}
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (pixels) {
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*pixels = _vala_pixels;
#line 2112 "Dimensions.c"
	}
}


gboolean
scaling_is_best_fit_dimensions (Scaling *self,
                                Dimensions* original,
                                Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	gint _tmp0_;
	ScaleConstraint _tmp1_;
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 352 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 354 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 354 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALING_NO_SCALE) {
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2140 "Dimensions.c"
		}
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2144 "Dimensions.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2154 "Dimensions.c"
		{
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2162 "Dimensions.c"
			}
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2166 "Dimensions.c"
		}
		default:
		{
			gint pixels = 0;
			gint _tmp2_;
			gint _tmp3_;
			ScaleConstraint _tmp4_;
			Dimensions _tmp5_ = {0};
#line 363 "/home/jens/Source/shotwell/src/Dimensions.vala"
			pixels = scaling_scale_to_pixels (&(*self));
#line 364 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = pixels;
#line 364 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (_tmp2_ > 0, "pixels > 0");
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = pixels;
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = (*self).constraint;
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_constraint (original, _tmp3_, _tmp4_, &_tmp5_);
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_scaled = _tmp5_;
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2195 "Dimensions.c"
			}
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2199 "Dimensions.c"
		}
	}
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2206 "Dimensions.c"
	}
}


gboolean
scaling_is_for_viewport (Scaling *self,
                         Dimensions* original,
                         Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	gint _tmp0_;
	ScaleConstraint _tmp1_;
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 373 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 375 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 375 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ != SCALING_NO_SCALE) {
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2234 "Dimensions.c"
		}
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2238 "Dimensions.c"
	}
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2248 "Dimensions.c"
		{
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2256 "Dimensions.c"
			}
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2260 "Dimensions.c"
		}
		default:
		{
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_;
#line 384 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (dimensions_has_area (&(*self).viewport), "viewport.has_area()");
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = (*self).scale_up;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (!_tmp4_) {
#line 2273 "Dimensions.c"
				Dimensions _tmp5_;
				gint _tmp6_;
				Dimensions _tmp7_;
				gint _tmp8_;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp5_ = *original;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp6_ = _tmp5_.width;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp7_ = (*self).viewport;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp8_ = _tmp7_.width;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = _tmp6_ < _tmp8_;
#line 2288 "Dimensions.c"
			} else {
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = FALSE;
#line 2292 "Dimensions.c"
			}
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp3_) {
#line 2296 "Dimensions.c"
				Dimensions _tmp9_;
				gint _tmp10_;
				Dimensions _tmp11_;
				gint _tmp12_;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp9_ = *original;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp10_ = _tmp9_.height;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp11_ = (*self).viewport;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp12_ = _tmp11_.height;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp2_ = _tmp10_ < _tmp12_;
#line 2311 "Dimensions.c"
			} else {
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp2_ = FALSE;
#line 2315 "Dimensions.c"
			}
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp2_) {
#line 2319 "Dimensions.c"
				Dimensions _tmp13_;
#line 387 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp13_ = *original;
#line 387 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_vala_scaled = _tmp13_;
#line 2325 "Dimensions.c"
			} else {
				Dimensions _tmp14_;
				Dimensions _tmp15_ = {0};
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp14_ = (*self).viewport;
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_proportional (original, &_tmp14_, &_tmp15_);
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_vala_scaled = _tmp15_;
#line 2335 "Dimensions.c"
			}
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2343 "Dimensions.c"
			}
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2347 "Dimensions.c"
		}
	}
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2354 "Dimensions.c"
	}
}


gboolean
scaling_is_fill_viewport (Scaling *self,
                          Dimensions* original,
                          Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	ScaleConstraint _tmp0_;
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
#line 395 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 396 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 398 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 398 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ != SCALE_CONSTRAINT_FILL_VIEWPORT) {
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2383 "Dimensions.c"
		}
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2387 "Dimensions.c"
	}
#line 401 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (dimensions_has_area (&(*self).viewport), "viewport.has_area()");
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).viewport;
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scaled_to_fill_viewport (original, &_tmp1_, &_tmp2_);
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_scaled = _tmp2_;
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = TRUE;
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2403 "Dimensions.c"
	}
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2407 "Dimensions.c"
}


void
scaling_get_scaled_dimensions (Scaling *self,
                               Dimensions* original,
                               Dimensions* result)
{
	Dimensions scaled = {0};
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	gboolean _tmp3_;
	Dimensions _tmp4_;
	Dimensions _tmp5_ = {0};
	gboolean _tmp6_;
	gboolean is_viewport = FALSE;
	Dimensions _tmp7_;
	Dimensions _tmp8_ = {0};
	gboolean _tmp9_;
	gboolean _tmp10_;
#line 407 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (original != NULL);
#line 408 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaling_is_unscaled (&(*self))) {
#line 2432 "Dimensions.c"
		Dimensions _tmp0_;
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = *original;
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp0_;
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2440 "Dimensions.c"
	}
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *original;
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = scaling_is_fill_viewport (&(*self), &_tmp1_, &_tmp2_);
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp2_;
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_) {
#line 413 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = scaled;
#line 413 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2454 "Dimensions.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = *original;
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = scaling_is_best_fit_dimensions (&(*self), &_tmp4_, &_tmp5_);
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp5_;
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_) {
#line 416 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = scaled;
#line 416 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2468 "Dimensions.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = *original;
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = scaling_is_for_viewport (&(*self), &_tmp7_, &_tmp8_);
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp8_;
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	is_viewport = _tmp9_;
#line 419 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = is_viewport;
#line 419 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp10_, "is_viewport");
#line 421 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled;
#line 421 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 2486 "Dimensions.c"
}


GdkPixbuf*
scaling_perform_on_pixbuf (Scaling *self,
                           GdkPixbuf* pixbuf,
                           GdkInterpType interp,
                           gboolean scale_up)
{
	GdkPixbuf* result = NULL;
	Dimensions pixbuf_dim = {0};
	Dimensions _tmp1_ = {0};
	gint pixels = 0;
	Dimensions _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	Dimensions scaled = {0};
	Dimensions _tmp7_;
	Dimensions _tmp8_ = {0};
	gboolean _tmp9_;
	gboolean is_viewport = FALSE;
	Dimensions _tmp12_;
	Dimensions _tmp13_ = {0};
	gboolean _tmp14_;
	gboolean _tmp15_;
	Dimensions _tmp16_;
	GdkPixbuf* _tmp17_;
#line 424 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 425 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaling_is_unscaled (&(*self))) {
#line 2518 "Dimensions.c"
		GdkPixbuf* _tmp0_;
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _g_object_ref0 (pixbuf);
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp0_;
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2526 "Dimensions.c"
	}
#line 428 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_for_pixbuf (pixbuf, &_tmp1_);
#line 428 "/home/jens/Source/shotwell/src/Dimensions.vala"
	pixbuf_dim = _tmp1_;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = pixbuf_dim;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = scaling_is_best_fit (&(*self), &_tmp2_, &_tmp3_);
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	pixels = _tmp3_;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_) {
#line 2540 "Dimensions.c"
		gint _tmp5_;
		GdkPixbuf* _tmp6_;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = pixels;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = scale_pixbuf (pixbuf, _tmp5_, interp, scale_up);
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp6_;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2551 "Dimensions.c"
	}
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = pixbuf_dim;
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = scaling_is_fill_viewport (&(*self), &_tmp7_, &_tmp8_);
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp8_;
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp9_) {
#line 2561 "Dimensions.c"
		Dimensions _tmp10_;
		GdkPixbuf* _tmp11_;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = scaled;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = resize_pixbuf (pixbuf, &_tmp10_, interp);
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp11_;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2572 "Dimensions.c"
	}
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = pixbuf_dim;
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = scaling_is_for_viewport (&(*self), &_tmp12_, &_tmp13_);
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp13_;
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	is_viewport = _tmp14_;
#line 439 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = is_viewport;
#line 439 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp15_, "is_viewport");
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = scaled;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = resize_pixbuf (pixbuf, &_tmp16_, interp);
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp17_;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2594 "Dimensions.c"
}


gchar*
scaling_to_string (Scaling *self)
{
	gchar* result = NULL;
	ScaleConstraint _tmp0_;
#line 445 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 445 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALE_CONSTRAINT_ORIGINAL) {
#line 2607 "Dimensions.c"
		gchar* _tmp1_;
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = g_strdup ("scaling: UNSCALED");
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp1_;
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2615 "Dimensions.c"
	} else {
		ScaleConstraint _tmp2_;
#line 447 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).constraint;
#line 447 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp2_ == SCALE_CONSTRAINT_FILL_VIEWPORT) {
#line 2622 "Dimensions.c"
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = dimensions_to_string (&(*self).viewport);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = _tmp3_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = g_strdup_printf ("scaling: fill viewport %s", _tmp4_);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = _tmp5_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_g_free0 (_tmp4_);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp6_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2641 "Dimensions.c"
		} else {
			gint _tmp7_;
#line 449 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = (*self).scale;
#line 449 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp7_ != SCALING_NO_SCALE) {
#line 2648 "Dimensions.c"
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_;
				ScaleConstraint _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp9_ = (*self).scale_up;
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
				if (_tmp9_) {
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp8_ = "scaled up";
#line 2662 "Dimensions.c"
				} else {
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp8_ = "not scaled up";
#line 2666 "Dimensions.c"
				}
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp10_ = (*self).constraint;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp11_ = scale_constraint_to_string (_tmp10_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp12_ = _tmp11_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp13_ = g_strdup_printf ("scaling: best-fit (%s %d pixels %s)", _tmp12_, scaling_scale_to_pixels (&(*self)), _tmp8_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp14_ = _tmp13_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_g_free0 (_tmp12_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				result = _tmp14_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				return result;
#line 2684 "Dimensions.c"
			} else {
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp16_ = (*self).scale_up;
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
				if (_tmp16_) {
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp15_ = "scaled up";
#line 2698 "Dimensions.c"
				} else {
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp15_ = "not scaled up";
#line 2702 "Dimensions.c"
				}
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp17_ = dimensions_to_string (&(*self).viewport);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp18_ = _tmp17_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp19_ = g_strdup_printf ("scaling: viewport %s (%s)", _tmp18_, _tmp15_);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp20_ = _tmp19_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_g_free0 (_tmp18_);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				result = _tmp20_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				return result;
#line 2718 "Dimensions.c"
			}
		}
	}
}


gboolean
scaling_equals (Scaling *self,
                Scaling* scaling)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ScaleConstraint _tmp2_;
	Scaling _tmp3_;
	ScaleConstraint _tmp4_;
#line 457 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).constraint;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *scaling;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.constraint;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_ == _tmp4_) {
#line 2745 "Dimensions.c"
		gint _tmp5_;
		Scaling _tmp6_;
		gint _tmp7_;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).scale;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = *scaling;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp6_.scale;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 2757 "Dimensions.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = FALSE;
#line 2761 "Dimensions.c"
	}
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 2765 "Dimensions.c"
		Scaling _tmp8_;
		Dimensions _tmp9_;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = *scaling;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.viewport;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = dimensions_equals (&(*self).viewport, &_tmp9_);
#line 2774 "Dimensions.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 2778 "Dimensions.c"
	}
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2784 "Dimensions.c"
}


Scaling*
scaling_dup (const Scaling* self)
{
	Scaling* dup;
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (Scaling, 1);
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (Scaling));
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 2798 "Dimensions.c"
}


void
scaling_free (Scaling* self)
{
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 2807 "Dimensions.c"
}


GType
scaling_get_type (void)
{
	static volatile gsize scaling_type_id__volatile = 0;
	if (g_once_init_enter (&scaling_type_id__volatile)) {
		GType scaling_type_id;
		scaling_type_id = g_boxed_type_register_static ("Scaling", (GBoxedCopyFunc) scaling_dup, (GBoxedFreeFunc) scaling_free);
		g_once_init_leave (&scaling_type_id__volatile, scaling_type_id);
	}
	return scaling_type_id__volatile;
}


void
zoom_state_init (ZoomState *self,
                 Dimensions* content_dimensions,
                 Dimensions* viewport_dimensions,
                 gdouble slider_val,
                 GdkPoint* viewport_center)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (content_dimensions != NULL);
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport_dimensions != NULL);
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 474 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *content_dimensions;
#line 474 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp0_;
#line 475 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *viewport_dimensions;
#line 475 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp1_;
#line 476 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = slider_val;
#line 478 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (viewport_center == NULL) {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = TRUE;
#line 2857 "Dimensions.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gint _tmp5_;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*viewport_center).x;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp5_ == 0) {
#line 2865 "Dimensions.c"
			gint _tmp6_;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = (*viewport_center).y;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = _tmp6_ == 0;
#line 2871 "Dimensions.c"
		} else {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = FALSE;
#line 2875 "Dimensions.c"
		}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = _tmp4_;
#line 2879 "Dimensions.c"
	}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_) {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = TRUE;
#line 2885 "Dimensions.c"
	} else {
#line 481 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = slider_val == 0.0;
#line 2889 "Dimensions.c"
	}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_) {
#line 482 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 2895 "Dimensions.c"
	} else {
#line 484 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center = *viewport_center;
#line 485 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 2901 "Dimensions.c"
	}
}


void
zoom_state_init_rescale (ZoomState *self,
                         ZoomState* existing,
                         gdouble new_slider_val)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
#line 489 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 489 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 492 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = new_slider_val;
#line 494 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 496 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (new_slider_val == 0.0) {
#line 497 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 2939 "Dimensions.c"
	} else {
		gdouble _tmp4_;
		ZoomState _tmp5_;
		GdkPoint _tmp6_;
		gint _tmp7_;
		ZoomState _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		ZoomState _tmp11_;
		GdkPoint _tmp12_;
		gint _tmp13_;
		ZoomState _tmp14_;
		gdouble _tmp15_;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).zoom_factor;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *existing;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.viewport_center;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp6_.x;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = *existing;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.zoom_factor;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.x = (gint) (_tmp4_ * (_tmp7_ / _tmp9_));
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = (*self).zoom_factor;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = *existing;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = _tmp11_.viewport_center;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = _tmp12_.y;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = *existing;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = _tmp14_.zoom_factor;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.y = (gint) (_tmp10_ * (_tmp13_ / _tmp15_));
#line 503 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 2983 "Dimensions.c"
	}
}


void
zoom_state_init_rescale_to_isomorphic (ZoomState *self,
                                       ZoomState* existing)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	ZoomState _tmp4_;
	gdouble _tmp5_;
	ZoomState _tmp6_;
	gdouble _tmp7_;
	ZoomState _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
#line 507 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 507 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.min_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _tmp6_.max_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = _tmp8_.min_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = log (1.0 / _tmp5_) / log (_tmp7_ / _tmp9_);
#line 513 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 515 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = (*self).interpolation_factor;
#line 515 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp10_ == 0.0) {
#line 516 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 3041 "Dimensions.c"
	} else {
		gdouble _tmp11_;
		ZoomState _tmp12_;
		GdkPoint _tmp13_;
		gint _tmp14_;
		ZoomState _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		ZoomState _tmp18_;
		GdkPoint _tmp19_;
		gint _tmp20_;
		ZoomState _tmp21_;
		gdouble _tmp22_;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = (*self).zoom_factor;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = *existing;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = _tmp12_.viewport_center;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = _tmp13_.x;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = *existing;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = _tmp15_.zoom_factor;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.x = (gint) (_tmp11_ * (_tmp14_ / _tmp16_));
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = (*self).zoom_factor;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = *existing;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = _tmp18_.viewport_center;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp20_ = _tmp19_.y;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp21_ = *existing;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp22_ = _tmp21_.zoom_factor;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.y = (gint) (_tmp17_ * (_tmp20_ / _tmp22_));
#line 522 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 3085 "Dimensions.c"
	}
}


void
zoom_state_init_pan (ZoomState *self,
                     ZoomState* existing,
                     GdkPoint* new_viewport_center)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	ZoomState _tmp4_;
	gdouble _tmp5_;
	GdkPoint _tmp6_;
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (new_viewport_center != NULL);
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = *existing;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.interpolation_factor;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = _tmp5_;
#line 531 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 533 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *new_viewport_center;
#line 533 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center = _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_clamp_viewport_center (&(*self));
#line 3134 "Dimensions.c"
}


static void
zoom_state_clamp_viewport_center (ZoomState *self)
{
	gint zoomed_width = 0;
	gint zoomed_height = 0;
	GdkPoint _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_;
	gint _tmp5_;
	GdkPoint _tmp6_;
	gint _tmp7_;
	Dimensions _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_;
	gint _tmp11_;
#line 539 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = zoom_state_get_zoomed_width (&(*self));
#line 540 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = zoom_state_get_zoomed_height (&(*self));
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_center;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.x;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).viewport_dimensions;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).viewport_dimensions;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.width;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.x = CLAMP (_tmp1_, _tmp3_ / 2, (zoomed_width - (_tmp5_ / 2)) - 1);
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).viewport_center;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _tmp6_.y;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = (*self).viewport_dimensions;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = _tmp8_.height;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = (*self).viewport_dimensions;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _tmp10_.height;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.y = CLAMP (_tmp7_, _tmp9_ / 2, (zoomed_height - (_tmp11_ / 2)) - 1);
#line 3187 "Dimensions.c"
}


static void
zoom_state_center_viewport (ZoomState *self)
{
#line 549 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.x = zoom_state_get_zoomed_width (&(*self)) / 2;
#line 550 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.y = zoom_state_get_zoomed_height (&(*self)) / 2;
#line 3198 "Dimensions.c"
}


static void
zoom_state_compute_zoom_factors (ZoomState *self)
{
	gdouble viewport_to_content_x = 0.0;
	gdouble viewport_to_content_y = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
#line 554 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).max_factor = 2.0;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_dimensions;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self).content_dimensions, &_tmp0_, &_tmp1_, &_tmp2_);
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport_to_content_x = _tmp1_;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport_to_content_y = _tmp2_;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = viewport_to_content_x;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = viewport_to_content_y;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).min_factor = MIN (_tmp3_, _tmp4_);
#line 561 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = (*self).min_factor;
#line 561 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp5_ > 1.0) {
#line 562 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).min_factor = 1.0;
#line 3239 "Dimensions.c"
	}
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).min_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = (*self).max_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = (*self).min_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = (*self).interpolation_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).zoom_factor = _tmp6_ * pow (_tmp7_ / _tmp8_, _tmp9_);
#line 3251 "Dimensions.c"
}


gdouble
zoom_state_get_interpolation_factor (ZoomState *self)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).interpolation_factor;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3266 "Dimensions.c"
}


void
zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self,
                                              GdkRectangle* result)
{
	gint zoomed_width = 0;
	gint zoomed_height = 0;
	GdkRectangle _result_ = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GdkRectangle _tmp22_;
	gint _tmp23_;
	gint right = 0;
	GdkRectangle _tmp24_;
	gint _tmp25_;
	Dimensions _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp31_;
	GdkRectangle _tmp32_;
	gint _tmp33_;
	gint bottom = 0;
	GdkRectangle _tmp34_;
	gint _tmp35_;
	Dimensions _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp41_;
	GdkRectangle _tmp42_;
	gint _tmp43_;
	GdkRectangle _tmp44_;
	gint _tmp45_;
	GdkRectangle _tmp46_;
	gint _tmp47_;
#line 573 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = zoom_state_get_zoomed_width (&(*self));
#line 574 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = zoom_state_get_zoomed_height (&(*self));
#line 576 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_dimensions;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = zoomed_width;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ < _tmp2_) {
#line 3325 "Dimensions.c"
		GdkPoint _tmp3_;
		gint _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = (*self).viewport_center;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = _tmp3_.x;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).viewport_dimensions;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.width;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = _tmp4_ - (_tmp6_ / 2);
#line 3340 "Dimensions.c"
	} else {
		gint _tmp7_;
		Dimensions _tmp8_;
		gint _tmp9_;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = zoomed_width;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = (*self).viewport_dimensions;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.width;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = (_tmp7_ - _tmp9_) / 2;
#line 3353 "Dimensions.c"
	}
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _result_;
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _tmp10_.x;
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp11_ < 0) {
#line 584 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = 0;
#line 3363 "Dimensions.c"
	}
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = (*self).viewport_dimensions;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = _tmp12_.height;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = zoomed_height;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp13_ < _tmp14_) {
#line 3373 "Dimensions.c"
		GdkPoint _tmp15_;
		gint _tmp16_;
		Dimensions _tmp17_;
		gint _tmp18_;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = (*self).viewport_center;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = _tmp15_.y;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = (*self).viewport_dimensions;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = _tmp17_.height;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = _tmp16_ - (_tmp18_ / 2);
#line 3388 "Dimensions.c"
	} else {
		gint _tmp19_;
		Dimensions _tmp20_;
		gint _tmp21_;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = zoomed_height;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp20_ = (*self).viewport_dimensions;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp21_ = _tmp20_.height;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = (_tmp19_ - _tmp21_) / 2;
#line 3401 "Dimensions.c"
	}
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = _result_;
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_.y;
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp23_ < 0) {
#line 592 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = 0;
#line 3411 "Dimensions.c"
	}
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = _result_;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.x;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = (*self).viewport_dimensions;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.width;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = _tmp25_ + _tmp27_;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = right;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = zoomed_width;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp28_ > _tmp29_) {
#line 3429 "Dimensions.c"
		gint _tmp30_;
#line 596 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp30_ = zoomed_width;
#line 596 "/home/jens/Source/shotwell/src/Dimensions.vala"
		right = _tmp30_;
#line 3435 "Dimensions.c"
	}
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = right;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = _result_;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = _tmp32_.x;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp31_ - _tmp33_;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = _result_;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = _tmp34_.y;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = (*self).viewport_dimensions;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp37_ = _tmp36_.height;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = _tmp35_ + _tmp37_;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp38_ = bottom;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp39_ = zoomed_height;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp38_ > _tmp39_) {
#line 3461 "Dimensions.c"
		gint _tmp40_;
#line 601 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp40_ = zoomed_height;
#line 601 "/home/jens/Source/shotwell/src/Dimensions.vala"
		bottom = _tmp40_;
#line 3467 "Dimensions.c"
	}
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp41_ = bottom;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp42_ = _result_;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp43_ = _tmp42_.y;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp41_ - _tmp43_;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp44_ = _result_;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp45_ = _tmp44_.width;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = CLAMP (_tmp45_, 1, G_MAXINT);
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp46_ = _result_;
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp47_ = _tmp46_.height;
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = CLAMP (_tmp47_, 1, G_MAXINT);
#line 607 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 607 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3493 "Dimensions.c"
}


void
zoom_state_get_viewing_rectangle_wrt_screen (ZoomState *self,
                                             GdkRectangle* result)
{
	GdkRectangle wrt_content = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _result_ = {0};
	Dimensions _tmp1_;
	gint _tmp2_;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	Dimensions _tmp7_;
	gint _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_;
	GdkRectangle _tmp11_;
	gint _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_;
#line 613 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp0_);
#line 613 "/home/jens/Source/shotwell/src/Dimensions.vala"
	wrt_content = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).viewport_dimensions;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _tmp1_.width;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = wrt_content;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.width;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = (_tmp2_ / 2) - (_tmp4_ / 2);
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _result_;
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.x;
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_ < 0) {
#line 618 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = 0;
#line 3544 "Dimensions.c"
	}
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = (*self).viewport_dimensions;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.height;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = wrt_content;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.height;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = (_tmp8_ / 2) - (_tmp10_ / 2);
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _result_;
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.y;
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp12_ < 0) {
#line 621 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = 0;
#line 3564 "Dimensions.c"
	}
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = wrt_content;
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.width;
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp14_;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = wrt_content;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.height;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp16_;
#line 625 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 625 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3582 "Dimensions.c"
}


void
zoom_state_get_viewing_rectangle_projection (ZoomState *self,
                                             GdkPixbuf* for_pixbuf,
                                             GdkRectangle* result)
{
	gdouble zoomed_width = 0.0;
	gdouble zoomed_height = 0.0;
	gdouble horiz_scale = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble vert_scale = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble scale = 0.0;
	GdkRectangle viewing_rectangle = {0};
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _result_ = {0};
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GdkRectangle _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkRectangle _tmp11_;
	gint _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint right = 0;
	GdkRectangle _tmp17_;
	gint _tmp18_;
	GdkRectangle _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint bottom = 0;
	GdkRectangle _tmp24_;
	gint _tmp25_;
	GdkRectangle _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GdkRectangle _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GdkRectangle _tmp35_;
	gint _tmp36_;
#line 629 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GDK_IS_PIXBUF (for_pixbuf));
#line 630 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = (gdouble) zoom_state_get_zoomed_width (&(*self));
#line 631 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = (gdouble) zoom_state_get_zoomed_height (&(*self));
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = gdk_pixbuf_get_width (for_pixbuf);
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_;
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	horiz_scale = _tmp1_ / zoomed_width;
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = gdk_pixbuf_get_height (for_pixbuf);
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_;
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	vert_scale = _tmp3_ / zoomed_height;
#line 635 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scale = (horiz_scale + vert_scale) / 2.0;
#line 637 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp4_);
#line 637 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewing_rectangle = _tmp4_;
#line 639 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = viewing_rectangle;
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.x;
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = (gint) (_tmp6_ * scale);
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _result_;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.x;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = gdk_pixbuf_get_width (for_pixbuf);
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = CLAMP (_tmp8_, 0, _tmp10_);
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = viewing_rectangle;
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.y;
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = (gint) (_tmp12_ * scale);
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = _result_;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.y;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = gdk_pixbuf_get_height (for_pixbuf);
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = CLAMP (_tmp14_, 0, _tmp16_);
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = viewing_rectangle;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = _tmp17_.x;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = viewing_rectangle;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = _tmp19_.width;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = (gint) ((_tmp18_ + _tmp20_) * scale);
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = right;
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = gdk_pixbuf_get_width (for_pixbuf);
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_;
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = CLAMP (_tmp21_, 0, _tmp23_);
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = viewing_rectangle;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.y;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = viewing_rectangle;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.height;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = (gint) ((_tmp25_ + _tmp27_) * scale);
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = bottom;
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = gdk_pixbuf_get_height (for_pixbuf);
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp30_ = _tmp29_;
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = CLAMP (_tmp28_, 0, _tmp30_);
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = right;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = _result_;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = _tmp32_.x;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp31_ - _tmp33_;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = bottom;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = _result_;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = _tmp35_.y;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp34_ - _tmp36_;
#line 651 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 651 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3751 "Dimensions.c"
}


gdouble
zoom_state_get_zoom_factor (ZoomState *self)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3766 "Dimensions.c"
}


gint
zoom_state_get_zoomed_width (ZoomState *self)
{
	gint result = 0;
	Dimensions _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).content_dimensions;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).zoom_factor;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = (gint) (_tmp1_ * _tmp2_);
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3787 "Dimensions.c"
}


gint
zoom_state_get_zoomed_height (ZoomState *self)
{
	gint result = 0;
	Dimensions _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).content_dimensions;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.height;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).zoom_factor;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = (gint) (_tmp1_ * _tmp2_);
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3808 "Dimensions.c"
}


void
zoom_state_get_viewport_center (ZoomState *self,
                                GdkPoint* result)
{
	GdkPoint _tmp0_;
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_center;
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp0_;
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3823 "Dimensions.c"
}


gchar*
zoom_state_to_string (ZoomState *self)
{
	gchar* result = NULL;
	gchar* named_modes = NULL;
	gchar* _tmp0_;
	const gchar* _tmp17_;
	GdkRectangle viewing_rect = {0};
	GdkRectangle _tmp19_ = {0};
	Dimensions _tmp20_;
	gint _tmp21_;
	Dimensions _tmp22_;
	gint _tmp23_;
	Dimensions _tmp24_;
	gint _tmp25_;
	Dimensions _tmp26_;
	gint _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	const gchar* _tmp31_;
	GdkRectangle _tmp32_;
	gint _tmp33_;
	GdkRectangle _tmp34_;
	gint _tmp35_;
	GdkRectangle _tmp36_;
	gint _tmp37_;
	GdkRectangle _tmp38_;
	gint _tmp39_;
	GdkPoint _tmp40_;
	gint _tmp41_;
	GdkPoint _tmp42_;
	gint _tmp43_;
	gchar* _tmp44_;
#line 672 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = g_strdup ("");
#line 672 "/home/jens/Source/shotwell/src/Dimensions.vala"
	named_modes = _tmp0_;
#line 673 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (zoom_state_is_min (&(*self))) {
#line 3867 "Dimensions.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = named_modes;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp2_, "") == 0) {
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = "MIN";
#line 3878 "Dimensions.c"
		} else {
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = ", MIN";
#line 3882 "Dimensions.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = named_modes;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = g_strconcat (_tmp3_, _tmp1_, NULL);
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp4_;
#line 3892 "Dimensions.c"
	}
#line 675 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (zoom_state_is_default (&(*self))) {
#line 3896 "Dimensions.c"
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = named_modes;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp6_, "") == 0) {
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = "DEFAULT";
#line 3907 "Dimensions.c"
		} else {
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = ", DEFAULT";
#line 3911 "Dimensions.c"
		}
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = named_modes;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = g_strconcat (_tmp7_, _tmp5_, NULL);
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp8_;
#line 3921 "Dimensions.c"
	}
#line 677 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (zoom_state_is_isomorphic (&(*self))) {
#line 3925 "Dimensions.c"
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = named_modes;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp10_, "") == 0) {
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp9_ = "ISOMORPHIC";
#line 3936 "Dimensions.c"
		} else {
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp9_ = ", ISOMORPHIC";
#line 3940 "Dimensions.c"
		}
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = named_modes;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = g_strconcat (_tmp11_, _tmp9_, NULL);
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp12_;
#line 3950 "Dimensions.c"
	}
#line 679 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (zoom_state_is_max (&(*self))) {
#line 3954 "Dimensions.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = named_modes;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp14_, "") == 0) {
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp13_ = "MAX";
#line 3965 "Dimensions.c"
		} else {
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp13_ = ", MAX";
#line 3969 "Dimensions.c"
		}
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = named_modes;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = g_strconcat (_tmp15_, _tmp13_, NULL);
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp16_;
#line 3979 "Dimensions.c"
	}
#line 681 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = named_modes;
#line 681 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (g_strcmp0 (_tmp17_, "") == 0) {
#line 3985 "Dimensions.c"
		gchar* _tmp18_;
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = g_strdup ("(none)");
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp18_;
#line 3993 "Dimensions.c"
	}
#line 684 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp19_);
#line 684 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewing_rect = _tmp19_;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = (*self).content_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = _tmp20_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = (*self).content_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = (*self).viewport_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = (*self).viewport_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = (*self).min_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = (*self).max_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp30_ = (*self).zoom_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = named_modes;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = _tmp32_.x;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = _tmp34_.y;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp37_ = _tmp36_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp38_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp39_ = _tmp38_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp40_ = (*self).viewport_center;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp41_ = _tmp40_.x;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp42_ = (*self).viewport_center;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp43_ = _tmp42_.y;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp44_ = g_strdup_printf ("ZoomState {\n" \
"    content dimensions = %d x %d;\n" \
"    viewport dimensions = " "%d x %d;\n" \
"    min factor = %f;\n" \
"    max factor = %f;\n" \
"    current factor = %f;" "\n" \
"    zoomed width = %d;\n" \
"    zoomed height = %d;\n" \
"    named modes = %s;" "\n    viewing rectangle = { x: %d, y: %d, width: %d, height: %d };" "\n    viewport center = (%d, %d);\n}\n", _tmp21_, _tmp23_, _tmp25_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, zoom_state_get_zoomed_width (&(*self)), zoom_state_get_zoomed_height (&(*self)), _tmp31_, _tmp33_, _tmp35_, _tmp37_, _tmp39_, _tmp41_, _tmp43_);
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp44_;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_g_free0 (named_modes);
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4055 "Dimensions.c"
}


gboolean
zoom_state_is_min (ZoomState *self)
{
	gboolean result = FALSE;
	gdouble _tmp0_;
	gdouble _tmp1_;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).min_factor;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == _tmp1_;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4073 "Dimensions.c"
}


gboolean
zoom_state_is_default (ZoomState *self)
{
	gboolean result = FALSE;
#line 702 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = zoom_state_is_min (&(*self));
#line 702 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4085 "Dimensions.c"
}


gboolean
zoom_state_is_max (ZoomState *self)
{
	gboolean result = FALSE;
	gdouble _tmp0_;
	gdouble _tmp1_;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).max_factor;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == _tmp1_;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4103 "Dimensions.c"
}


gboolean
zoom_state_is_isomorphic (ZoomState *self)
{
	gboolean result = FALSE;
	gdouble _tmp0_;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == 1.0;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4118 "Dimensions.c"
}


gboolean
zoom_state_equals (ZoomState *self,
                   ZoomState* other)
{
	gboolean result = FALSE;
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	gdouble _tmp4_;
	ZoomState _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	ZoomState _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	ZoomState _tmp11_;
	gdouble _tmp12_;
	GdkPoint _tmp13_;
	gint _tmp14_;
	ZoomState _tmp15_;
	GdkPoint _tmp16_;
	gint _tmp17_;
	GdkPoint _tmp18_;
	gint _tmp19_;
	ZoomState _tmp20_;
	GdkPoint _tmp21_;
	gint _tmp22_;
#line 713 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (other != NULL, FALSE);
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *other;
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!dimensions_equals (&(*self).content_dimensions, &_tmp1_)) {
#line 715 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 715 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4162 "Dimensions.c"
	}
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *other;
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!dimensions_equals (&(*self).viewport_dimensions, &_tmp3_)) {
#line 717 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 717 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4174 "Dimensions.c"
	}
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).zoom_factor;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = *other;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.zoom_factor;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_ != _tmp6_) {
#line 719 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 719 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4188 "Dimensions.c"
	}
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = (*self).min_factor;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = *other;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = _tmp8_.min_factor;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp7_ != _tmp9_) {
#line 721 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 721 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4202 "Dimensions.c"
	}
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = (*self).max_factor;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = *other;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.max_factor;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp10_ != _tmp12_) {
#line 723 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 723 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4216 "Dimensions.c"
	}
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = (*self).viewport_center;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.x;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = *other;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.viewport_center;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = _tmp16_.x;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp14_ != _tmp17_) {
#line 725 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 725 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4234 "Dimensions.c"
	}
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = (*self).viewport_center;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = _tmp18_.y;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = *other;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = _tmp20_.viewport_center;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = _tmp21_.y;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp19_ != _tmp22_) {
#line 727 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 727 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4252 "Dimensions.c"
	}
#line 729 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = TRUE;
#line 729 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4258 "Dimensions.c"
}


ZoomState*
zoom_state_dup (const ZoomState* self)
{
	ZoomState* dup;
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (ZoomState, 1);
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (ZoomState));
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 4272 "Dimensions.c"
}


void
zoom_state_free (ZoomState* self)
{
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 4281 "Dimensions.c"
}


GType
zoom_state_get_type (void)
{
	static volatile gsize zoom_state_type_id__volatile = 0;
	if (g_once_init_enter (&zoom_state_type_id__volatile)) {
		GType zoom_state_type_id;
		zoom_state_type_id = g_boxed_type_register_static ("ZoomState", (GBoxedCopyFunc) zoom_state_dup, (GBoxedFreeFunc) zoom_state_free);
		g_once_init_leave (&zoom_state_type_id__volatile, zoom_state_type_id);
	}
	return zoom_state_type_id__volatile;
}



