/**
 * DefaultSet.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente <code>Set</code> d'une facon modele, pour etre
 * etendue par des vraies classes - i.e. non abstraites.
 *
 * @author Nicolae
 */
public abstract class DefaultSet implements Set {

	public abstract boolean contains(double re, double im);

	public Fonction charact() {
		return new Characteristic(this);
	}

	public Set complement() {
		return new Complement(this);
	}

	public Set union(Set A) {
		return new Union(A, this);
	}
	
	public Set inter(Set A) {
		return new Intersection(A, this);
	}

	public Set symmDiff(Set A) {
		return new SymmDiff(this, A);
	}

	public Set minus(Set A) {
		return new Difference(this, A);
	}
}
