/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.impl.drda.ReEncodedInputStream;
import org.apache.derby.impl.jdbc.Util;

class EXTDTAInputStream
extends InputStream {
    private InputStream binaryInputStream = null;
    EngineResultSet rs;
    int columnNumber;
    int ndrdaType;

    private EXTDTAInputStream(ResultSet resultSet, int n, int n2) {
        this.rs = (EngineResultSet)resultSet;
        this.columnNumber = n;
        this.ndrdaType = n2;
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet resultSet, int n, int n2) {
        int n3 = n2 | 1;
        return new EXTDTAInputStream(resultSet, n, n3);
    }

    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    public void close() throws IOException {
        if (this.binaryInputStream != null) {
            this.binaryInputStream.close();
        }
        this.binaryInputStream = null;
    }

    public boolean equals(Object object) {
        return this.binaryInputStream.equals(object);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    public void mark(int n) {
        this.binaryInputStream.mark(n);
    }

    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    public int read(byte[] byArray) throws IOException {
        return this.binaryInputStream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.binaryInputStream.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        return this.binaryInputStream.skip(l);
    }

    protected boolean isEmptyStream() throws SQLException {
        return this.rs.getLength(this.columnNumber) == 0;
    }

    public void initInputStream() throws SQLException {
        InputStream inputStream = null;
        Reader reader = null;
        if (this.ndrdaType == 201) {
            inputStream = this.rs.getBinaryStream(this.columnNumber);
            if (inputStream == null) {
                return;
            }
        } else if (this.ndrdaType == 207) {
            try {
                reader = this.rs.getCharacterStream(this.columnNumber);
                if (reader == null) {
                    return;
                }
                inputStream = new ReEncodedInputStream(reader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw Util.javaException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw Util.javaException(iOException);
            }
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.binaryInputStream = inputStream;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isNull() throws SQLException {
        return this.rs.isNull(this.columnNumber);
    }
}

