// SPDX-FileCopyrightText: 2006-2024 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2024 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-header for the \cond DEV \link utility_parallel Utility / Parallel submodule \endlink \endcond.
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 */

//!\cond DEV

/*!\defgroup utility_parallel Parallel
 * \brief This module contains types and utilities for concurrent execution of algorithms in SeqAn.
 * \ingroup utility
 * \see utility
 *
 * \details
 *
 * ### Execution policies
 *
 * Here are currently only implementations which are part of detail and therefore not of interest for the common user.
 *
 * ### Concurrency support
 *
 * This module contains helper classes to synchronise threads in concurrent environments.
 */
//!\endcond

#pragma once

#include <seqan3/core/platform.hpp>
