#include "rheolef/mixed_solver.h"
#include "cahouet-chabart.h"
using namespace std;
int navier_stokes_solve0 (Float Re, Float delta_t, field f0h, field& uh, field& ph,
    size_t& max_iter, Float& tol, std::ostream *p_cerr, std::string label = "navier-stokes0") {
  const space& Vh = uh.get_space();
  const space& Qh = ph.get_space();
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "2D_D");
  a = a + (Re/delta_t)*m;
  ssk<Float> fact_a = ldlt(a.uu);
  form b (Vh, Qh, "div"); b = -b;
  cahouet_chabart preconditioner (Qh, Re/delta_t);
  if (p_cerr != 0) *p_cerr << "[" << label << "] #n |du/dt|" << endl;
  Float residual_prec = 1;
  for (size_t n = 0; true; n++) { 
    field uh_prec = uh;
    geomap X (Vh, -delta_t*uh);
    field  fh = f0h + (Re/delta_t)*compose (uh, X);
    size_t gs_max_iter = 500;
    Float  gs_tol      = 1e-15;
    int status = pcg_abtb (a.uu, b.uu, uh.u, ph.u, (m*fh).u - a.ub*uh.b, -(b.ub*uh.b),
      preconditioner, fact_a, gs_max_iter, gs_tol);
    if (status != 0) warning_macro ("solve generalized stokes: precision not reached: tol = " << tol)
    field duh_dt = (uh - uh_prec)/delta_t;
    Float residual = sqrt(m(duh_dt,duh_dt));
    if (p_cerr != 0) *p_cerr << "[" << label << "] "<< n << " " << residual << endl;
    if (residual < tol) {
      tol = residual;
      max_iter = n;
      return 0;
    }
    if (n > 0 && residual > 100*residual_prec) {
        warning_macro ("algorithm diverges: stop with previous iterate restaured");
	orheostream res ("du_dt", "mfield");
  	res << catchmark("du_dt") << duh_dt
  	    << catchmark("u_prec") << uh_prec
  	    << catchmark("u") << uh
            ;
	uh = uh_prec;
        tol = residual_prec;
        max_iter = n-1;
	return 1;
    }
    if (n == max_iter-1) {
      tol = residual;
      return 1;
    }
    residual_prec = residual;
  }
}
