package org.red5.server.net.rtsp;

/*
 * RED5 Open Source Flash Server - http://www.osflash.org/red5
 * 
 * Copyright (c) 2006-2008 by respective authors (see below). All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU Lesser General Public License as published by the Free Software 
 * Foundation; either version 2.1 of the License, or (at your option) any later 
 * version. 
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along 
 * with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

/**
 * RTSP Status codes.
 * 
 * @author Matteo Merli (matteo.merli@gmail.com)
 */
public enum RTSPCode {

	Continue(100),

	OK(200), Created(201), LowOnStorageSpace(250, "Low on Storage Space"),

	MultipleChoices(300, "Multiple Choices"), MovedPermanently(301,
			"Multiple Choices"), MovedTemporarily(302, "Moved Temporarily"), SeeOther(
			303, "See Other"), NotModified(304, "Not Modified"), UseProxy(305,
			"Not Modified"),

	BadRequest(400, "Bad Request"), Unauthorized(401), PaymentRequired(402,
			"Payment Required"), Forbidden(403), NotFound(404, "Not Found"), MethodNotAllowed(
			405, "Method Not Allowed"), NotAcceptable(406, "Not Acceptable"), ProxyAuthenticationRequired(
			407, "Proxy Authentication Required"), RequestTimeOut(408,
			"Request Time-out"), Gone(410), LengthRequired(411,
			"Length Required"), PreconditionFailed(412, "Precondition Failed"), RequestEntityTooLarge(
			413, "Request Entity Too Large"), RequestUriTooLarge(414,
			"Request-URI Too Large"), UnsupportedMediaType(415,
			"Unsupported Media Type"), ParameterNotUnderstood(451,
			"Parameter Not Understood"), ConferenceNotFound(452,
			"Conference Not Found"), NotEnoughBandwidth(453,
			"Not Enough Bandwidth"), SessionNotFound(454, "Session Not Found"), MethodNotValidInThisState(
			455, "Method Not Valid in This State"), HeaderFieldNotValidForResource(
			456, "Header Field Not Valid for Resource"), InvalidRange(457,
			"Invalid Range"), ParameterIsReadOnly(458, "Parameter Is Read-Only"), AggregateOperationNotAllowed(
			459, "Aggregate operation not allowed"), OnlyAggregateOperationAllowed(
			460, "Only aggregate operation allowed"), UnsupportedTransport(461,
			"Unsupported transport"), DestinationUnreachable(464,
			"Destination unreachable"),

	InternalServerError(500, "Internal Server Error"), NotImplemented(501,
			"Not Implemented"), BadGateway(502, "Bad Gateway"), ServiceUnavailable(
			503, "Service Unavailable"), GatewayTimeOut(504, "Gateway Time-out"), RTSPVersionNotSupported(
			505, "RTSP Version not supported"), OptionNotSupported(551,
			"Option not supported");

	private final int value;

	private final String description;

	private RTSPCode(int value, String description) {
		this.value = value;
		this.description = description;
	}

	private RTSPCode(int value) {
		this.value = value;
		this.description = null;
	}

	/**
	 * @return the numeric value of the RTSP code
	 */
	public int value() {
		return this.value;
	}

	/**
	 * @return the human-readable description of the RTSP code
	 */
	public String description() {
		if (description != null)
			return description;
		else
			return name();
	}

	/**
	 * Try to translare a numeric RTSP status code to the corresponding enum
	 * value.
	 * 
	 * @param strCode
	 *            numeric code (as a string)
	 * @return enum values
	 */
	public static RTSPCode fromString(String strCode) {
		int intCode = Integer.valueOf(strCode);
		for (RTSPCode code : RTSPCode.values()) {
			if (code.value() == intCode)
				return code;
		}
		return RTSPCode.BadRequest;
	}
}
