% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medTree.R
\name{medTree}
\alias{medTree}
\title{Geometric median tree function}
\usage{
medTree(x, groups = NULL, lambda = 0, weights = NULL,
  emphasise.tips = NULL, emphasise.weight = 2,
  return.lambda.function = FALSE, save.memory = FALSE)
}
\arguments{
\item{x}{A list of trees of the class multiPhylo, for which the median tree will be computed, \cr
OR a matrix of tree vectors as given by \code{treescape$vectors}.}

\item{groups}{an optional factor defining groups of trees; if provided, one median tree will be found for each group.}

\item{lambda}{a number in [0,1] which specifies the extent to which topology (default, with lambda=0)  or branch lengths (lambda=1) are emphasised. This argument is ignored if \code{return.lambda.function=TRUE} or if the vectors are already supplied as the object \code{x}.}

\item{weights}{A vector of weights for the trees. Defaults to a vector of 1's so that all trees are equally weighted, but can be used to encode likelihood, posterior probabilities or other characteristics.}

\item{emphasise.tips}{an optional list of tips whose entries in the tree vectors should be emphasised. Defaults to \code{NULL}.}

\item{emphasise.weight}{applicable only if a list is supplied to \code{emphasise.tips}, this value (default 2) is the number by which vector entries corresponding to those tips are emphasised.}

\item{return.lambda.function}{If true, a function that can be invoked with different lambda values is returned.
This function returns the vector of metric values for the given lambda. Ignored if the tree vectors are already supplied as the object \code{x}.}

\item{save.memory}{A flag that saves a lot of memory but increases the execution time (not compatible with return.lambda.function=TRUE). Ignored if the tree vectors are already supplied as the object \code{x}.}
}
\value{
A list of five objects: 
\itemize{
\item $centre is the "central vector", that is, the (weighted) mean of the tree vectors (which typically does not correspond to a tree itself); 
\item $distances gives the distance of each tree from the central vector; 
\item $mindist is the minimum of these distances; 
\item $treenumbers gives the numbers (and, if supplied, names) of the "median tree(s)", that is, the tree(s) which achieve this minimum distance to the centre; 
\item $trees if trees were supplied then this returns the median trees as a multiPhylo object. 
}
If groups are provided, then one list is returned for each group.
If \code{return.lambda.function=TRUE} then a function is returned that produces this list for a given value of lambda.
}
\description{
Finds the geometric median of a set of trees according to the Kendall Colijn metric.
}
\examples{

## EXAMPLE WITH WOODMICE DATA
data(woodmiceTrees)

## LOOKING FOR A SINGLE MEDIAN
## get median tree(s)
res <- medTree(woodmiceTrees)
res

## plot first tree
med.tree <- res$trees[[1]]
plot(med.tree)

## LOOKING FOR MEDIANS IN SEVERAL CLUSTERS
## identify 6 clusters
groves <- findGroves(woodmiceTrees, nf=3, nclust=6)

## find median trees
res.with.grp <- medTree(woodmiceTrees, groves$groups)

## there is one output per cluster
names(res.with.grp)

## get the first median of each
med.trees <- lapply(res.with.grp, function(e) ladderize(e$trees[[1]]))

## plot trees
par(mfrow=c(2,3))
for(i in 1:length(med.trees)) plot(med.trees[[i]], main=paste("cluster",i))

## highlight the differences between a pair of median trees
plotTreeDiff(med.trees[[1]],med.trees[[5]])

}
\author{
Jacob Almagro-Garcia \email{nativecoder@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Thibaut Jombart \email{thibautjombart@gmail.com}
}

