% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimreduc.R
\name{CreateDimReducObject}
\alias{CreateDimReducObject}
\alias{SetDimReduction}
\title{Create a DimReduc object}
\usage{
CreateDimReducObject(
  embeddings = new(Class = "matrix"),
  loadings = new(Class = "matrix"),
  projected = new(Class = "matrix"),
  assay = NULL,
  stdev = numeric(),
  key = NULL,
  global = FALSE,
  jackstraw = NULL,
  misc = list()
)
}
\arguments{
\item{embeddings}{A matrix with the cell embeddings}

\item{loadings}{A matrix with the feature loadings}

\item{projected}{A matrix with the projected feature loadings}

\item{assay}{Assay used to calculate this dimensional reduction}

\item{stdev}{Standard deviation (if applicable) for the dimensional reduction}

\item{key}{A character string to facilitate looking up features from a
specific DimReduc}

\item{global}{Specify this as a global reduction (useful for visualizations)}

\item{jackstraw}{Results from the JackStraw function}

\item{misc}{list for the user to store any additional information associated
with the dimensional reduction}
}
\value{
A \code{\link{DimReduc}} object
}
\description{
Create a DimReduc object
}
\examples{
data <- GetAssayData(pbmc_small[["RNA"]], slot = "scale.data")
pcs <- prcomp(x = data)
pca.dr <- CreateDimReducObject(
  embeddings = pcs$rotation,
  loadings = pcs$x,
  stdev = pcs$sdev,
  key = "PC",
  assay = "RNA"
)

}
\seealso{
Dimensional reduction object, validity, and interaction methods
\code{\link{DimReduc-class}},
\code{\link{DimReduc-validity}},
\code{\link{[.DimReduc}()},
\code{\link{[[.DimReduc}()},
\code{\link{dim.DimReduc}()},
\code{\link{merge.DimReduc}()},
\code{\link{print.DimReduc}()},
\code{\link{subset.DimReduc}()}
}
\concept{dimreduc}
