# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class ClusterScopeSettings(ProxyResource):
    """Extension scope settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar allow_multiple_instances: Describes if multiple instances of the extension are allowed.
    :vartype allow_multiple_instances: bool
    :ivar default_release_namespace: Default extension release namespace.
    :vartype default_release_namespace: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allow_multiple_instances": {"key": "properties.allowMultipleInstances", "type": "bool"},
        "default_release_namespace": {"key": "properties.defaultReleaseNamespace", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_multiple_instances: Optional[bool] = None,
        default_release_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_multiple_instances: Describes if multiple instances of the extension are
         allowed.
        :paramtype allow_multiple_instances: bool
        :keyword default_release_namespace: Default extension release namespace.
        :paramtype default_release_namespace: str
        """
        super().__init__(**kwargs)
        self.allow_multiple_instances = allow_multiple_instances
        self.default_release_namespace = default_release_namespace


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtensionType(ProxyResource):
    """The Extension Type object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ExtensionTypeProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ExtensionTypeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ExtensionTypeProperties(_serialization.Model):
    """ExtensionTypeProperties.

    :ivar is_system_extension: Is this Extension Type a system extension.
    :vartype is_system_extension: bool
    :ivar is_managed_identity_required: Should an identity for this cluster resource be created.
    :vartype is_managed_identity_required: bool
    :ivar description: Description of the extension type.
    :vartype description: str
    :ivar publisher: Name of the publisher for the Extension Type.
    :vartype publisher: str
    :ivar plan_info: Plan information only for the Marketplace Extension Type.
    :vartype plan_info:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypePropertiesPlanInfo
    :ivar supported_cluster_types: Cluster Types supported for this Extension Type.
    :vartype supported_cluster_types: list[str]
    :ivar supported_scopes: Supported Kubernetes Scopes for this Extension Type.
    :vartype supported_scopes:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypePropertiesSupportedScopes
    """

    _attribute_map = {
        "is_system_extension": {"key": "isSystemExtension", "type": "bool"},
        "is_managed_identity_required": {"key": "isManagedIdentityRequired", "type": "bool"},
        "description": {"key": "description", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "plan_info": {"key": "planInfo", "type": "ExtensionTypePropertiesPlanInfo"},
        "supported_cluster_types": {"key": "supportedClusterTypes", "type": "[str]"},
        "supported_scopes": {"key": "supportedScopes", "type": "ExtensionTypePropertiesSupportedScopes"},
    }

    def __init__(
        self,
        *,
        is_system_extension: Optional[bool] = None,
        is_managed_identity_required: Optional[bool] = None,
        description: Optional[str] = None,
        publisher: Optional[str] = None,
        plan_info: Optional["_models.ExtensionTypePropertiesPlanInfo"] = None,
        supported_cluster_types: Optional[List[str]] = None,
        supported_scopes: Optional["_models.ExtensionTypePropertiesSupportedScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_system_extension: Is this Extension Type a system extension.
        :paramtype is_system_extension: bool
        :keyword is_managed_identity_required: Should an identity for this cluster resource be created.
        :paramtype is_managed_identity_required: bool
        :keyword description: Description of the extension type.
        :paramtype description: str
        :keyword publisher: Name of the publisher for the Extension Type.
        :paramtype publisher: str
        :keyword plan_info: Plan information only for the Marketplace Extension Type.
        :paramtype plan_info:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypePropertiesPlanInfo
        :keyword supported_cluster_types: Cluster Types supported for this Extension Type.
        :paramtype supported_cluster_types: list[str]
        :keyword supported_scopes: Supported Kubernetes Scopes for this Extension Type.
        :paramtype supported_scopes:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypePropertiesSupportedScopes
        """
        super().__init__(**kwargs)
        self.is_system_extension = is_system_extension
        self.is_managed_identity_required = is_managed_identity_required
        self.description = description
        self.publisher = publisher
        self.plan_info = plan_info
        self.supported_cluster_types = supported_cluster_types
        self.supported_scopes = supported_scopes


class ExtensionTypePropertiesPlanInfo(_serialization.Model):
    """Plan information only for the Marketplace Extension Type.

    :ivar publisher_id: Publisher ID of the Marketplace Extension Type.
    :vartype publisher_id: str
    :ivar plan_id: Plan ID of the Marketplace Extension Type.
    :vartype plan_id: str
    :ivar offer_id: Offer or Product ID of the Marketplace Extension Type.
    :vartype offer_id: str
    """

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_id: Publisher ID of the Marketplace Extension Type.
        :paramtype publisher_id: str
        :keyword plan_id: Plan ID of the Marketplace Extension Type.
        :paramtype plan_id: str
        :keyword offer_id: Offer or Product ID of the Marketplace Extension Type.
        :paramtype offer_id: str
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.plan_id = plan_id
        self.offer_id = offer_id


class ExtensionTypePropertiesSupportedScopes(_serialization.Model):
    """Supported Kubernetes Scopes for this Extension Type.

    :ivar default_scope: The default scope of the extension type. This scope will be used if the
     user does not provide a scope while creating an extension.
    :vartype default_scope: str
    :ivar cluster_scope_settings: Extension scope settings.
    :vartype cluster_scope_settings:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ClusterScopeSettings
    """

    _attribute_map = {
        "default_scope": {"key": "defaultScope", "type": "str"},
        "cluster_scope_settings": {"key": "clusterScopeSettings", "type": "ClusterScopeSettings"},
    }

    def __init__(
        self,
        *,
        default_scope: Optional[str] = None,
        cluster_scope_settings: Optional["_models.ClusterScopeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_scope: The default scope of the extension type. This scope will be used if the
         user does not provide a scope while creating an extension.
        :paramtype default_scope: str
        :keyword cluster_scope_settings: Extension scope settings.
        :paramtype cluster_scope_settings:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ClusterScopeSettings
        """
        super().__init__(**kwargs)
        self.default_scope = default_scope
        self.cluster_scope_settings = cluster_scope_settings


class ExtensionTypesList(_serialization.Model):
    """List Extension Types. It contains a list of ExtensionType objects and a URL link to get the
    next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extension Types.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionType]
    :ivar next_link: URL to get the next set of extension type objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ExtensionType"]] = None
        self.next_link: Optional[str] = None


class ExtensionTypeVersionForReleaseTrain(ProxyResource):
    """The Extension Type Version object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionForReleaseTrainProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ExtensionTypeVersionForReleaseTrainProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ExtensionTypeVersionForReleaseTrainProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionForReleaseTrainProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ExtensionTypeVersionForReleaseTrainProperties(_serialization.Model):  # pylint: disable=name-too-long
    """ExtensionTypeVersionForReleaseTrainProperties.

    :ivar version: The version number for the extension type.
    :vartype version: str
    :ivar unsupported_kubernetes_versions: The list of supported Kubernetes cluster versions for
     this extension type.
    :vartype unsupported_kubernetes_versions:
     ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionForReleaseTrainPropertiesUnsupportedKubernetesVersions
    :ivar supported_cluster_types: A list of supported cluster types for this version of the
     Extension Type.
    :vartype supported_cluster_types: list[str]
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "unsupported_kubernetes_versions": {
            "key": "unsupportedKubernetesVersions",
            "type": "ExtensionTypeVersionForReleaseTrainPropertiesUnsupportedKubernetesVersions",
        },
        "supported_cluster_types": {"key": "supportedClusterTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        unsupported_kubernetes_versions: Optional[
            "_models.ExtensionTypeVersionForReleaseTrainPropertiesUnsupportedKubernetesVersions"
        ] = None,
        supported_cluster_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The version number for the extension type.
        :paramtype version: str
        :keyword unsupported_kubernetes_versions: The list of supported Kubernetes cluster versions for
         this extension type.
        :paramtype unsupported_kubernetes_versions:
         ~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionForReleaseTrainPropertiesUnsupportedKubernetesVersions
        :keyword supported_cluster_types: A list of supported cluster types for this version of the
         Extension Type.
        :paramtype supported_cluster_types: list[str]
        """
        super().__init__(**kwargs)
        self.version = version
        self.unsupported_kubernetes_versions = unsupported_kubernetes_versions
        self.supported_cluster_types = supported_cluster_types


class ExtensionTypeVersionForReleaseTrainPropertiesUnsupportedKubernetesVersions(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The list of supported Kubernetes cluster versions for this extension type.

    :ivar connected_cluster:
    :vartype connected_cluster:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
    :ivar appliances:
    :vartype appliances:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
    :ivar provisioned_cluster:
    :vartype provisioned_cluster:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
    :ivar managed_cluster:
    :vartype managed_cluster:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
    """

    _attribute_map = {
        "connected_cluster": {
            "key": "connectedCluster",
            "type": "[ExtensionTypeVersionUnsupportedKubernetesMatrixItem]",
        },
        "appliances": {"key": "appliances", "type": "[ExtensionTypeVersionUnsupportedKubernetesMatrixItem]"},
        "provisioned_cluster": {
            "key": "provisionedCluster",
            "type": "[ExtensionTypeVersionUnsupportedKubernetesMatrixItem]",
        },
        "managed_cluster": {"key": "managedCluster", "type": "[ExtensionTypeVersionUnsupportedKubernetesMatrixItem]"},
    }

    def __init__(
        self,
        *,
        connected_cluster: Optional[List["_models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem"]] = None,
        appliances: Optional[List["_models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem"]] = None,
        provisioned_cluster: Optional[List["_models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem"]] = None,
        managed_cluster: Optional[List["_models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connected_cluster:
        :paramtype connected_cluster:
         list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
        :keyword appliances:
        :paramtype appliances:
         list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
        :keyword provisioned_cluster:
        :paramtype provisioned_cluster:
         list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
        :keyword managed_cluster:
        :paramtype managed_cluster:
         list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionUnsupportedKubernetesMatrixItem]
        """
        super().__init__(**kwargs)
        self.connected_cluster = connected_cluster
        self.appliances = appliances
        self.provisioned_cluster = provisioned_cluster
        self.managed_cluster = managed_cluster


class ExtensionTypeVersionsList(_serialization.Model):
    """List Extension Type Versions. It contains a list of ExtensionTypeVersionForReleaseTrain
    objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extension Type Versions for an Extension Type in a Release Train.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.extensiontypes.models.ExtensionTypeVersionForReleaseTrain]
    :ivar next_link: URL to get the next set of extension objects, if any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionTypeVersionForReleaseTrain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ExtensionTypeVersionForReleaseTrain"]] = None
        self.next_link: Optional[str] = None


class ExtensionTypeVersionUnsupportedKubernetesMatrixItem(_serialization.Model):  # pylint: disable=name-too-long
    """The list of Kubernetes Distribution and Versions that are not supported by this version of this
    Extension Type.

    :ivar distributions: The list of Kubernetes Cluster Distribution Names not supported.
    :vartype distributions: list[str]
    :ivar unsupported_versions: The list of Kubernetes Versions not supported by the list of
     Kubernetes Cluster Distribution names in this object.
    :vartype unsupported_versions: list[str]
    """

    _attribute_map = {
        "distributions": {"key": "distributions", "type": "[str]"},
        "unsupported_versions": {"key": "unsupportedVersions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        distributions: Optional[List[str]] = None,
        unsupported_versions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword distributions: The list of Kubernetes Cluster Distribution Names not supported.
        :paramtype distributions: list[str]
        :keyword unsupported_versions: The list of Kubernetes Versions not supported by the list of
         Kubernetes Cluster Distribution names in this object.
        :paramtype unsupported_versions: list[str]
        """
        super().__init__(**kwargs)
        self.distributions = distributions
        self.unsupported_versions = unsupported_versions
