#!/usr/bin/python
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: ImportExportDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import Pmw
from RadioSelectDialog import RadioSelectDialog
from InputWidgets import TextComboEdit

class ImportExportDialog(RadioSelectDialog):

    # exporttargets e.g.: [("csv","Comma Separated Values"),("latex","LaTeX)] 
    def __init__(self, master, exporttargets,
                 title="", headline=""):
        RadioSelectDialog.__init__(self, master, exporttargets, title, headline)

        self.combo = TextComboEdit(self.interior(), labelpos="w",
            label_text="Encoding: ", nomanualedit=True)
        self.combo.setlist([
            "UTF-8",
            "UTF-16",
            "ISO-8859-1",
            "ISO-8859-2",
            "ISO-8859-3",
            "ISO-8859-4",
            "ISO-8859-5",
            "ISO-8859-6",
            "ISO-8859-7",
            "ISO-8859-8",
            "ISO-8859-9",
            "ISO-8859-10",
            "ISO-8859-13",
            "ISO-8859-14",
            "ISO-8859-15",
            "Base64",
            "Quoted-Printable"
            ])
        self.combo.set("UTF-8")
        self.combo.grid(padx=2, pady=2)
            
    def getvalue(self):
        "Return selected RadioButton and Encoding as Tuple"
        return (self.targetvar.get(), self.combo.get())
        

if __name__ == "__main__":
    # Unit Test:
    tk = Tk()
    exporttargets = [("csv","Comma Separated Values"),
            ("dat","Future Data Format")]
    dlg = ImportExportDialog(tk, exporttargets, title="Test", headline="Export To:")
    print dlg.activate()
    tk.destroy()
