/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "listemessage.h"

Resultat listetexte_initialisation(ListeTexte **listetexte)
{ 
	*listetexte=NULL;
	return RESULTAT_OK;
}

Resultat listetexte_ajout_texte(ListeTexte **listetexte , Chaine texte , TypeTexte type)
{ 
	DEBUTZONESECURISEE
	if((*listetexte)==NULL)
	{
		if(((*listetexte)=(ListeTexte*)(malloc(sizeof(ListeTexte))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*listetexte)->texte=texte;
		(*listetexte)->type=type;
		(*listetexte)->suivant=NULL;
	}
	else
	{
		SECURISE(listetexte_ajout_texte(&((*listetexte)->suivant),texte,type));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listetexte_destruction(ListeTexte **listetexte)
{ 
	DEBUTZONESECURISEE
	if((*listetexte)==NULL)
		return RESULTAT_OK;
	SECURISE(listetexte_destruction(&((*listetexte)->suivant)));
	free((*listetexte)->texte);
	free(*listetexte);
	*listetexte=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listemessage_initialisation(ListeMessage **listemessage)
{ 
	*listemessage=NULL;
	return RESULTAT_OK;
}

Resultat listeparametre_initialisation(ListeParametre **listeparametre)
{ 
	*listeparametre=NULL;
	return RESULTAT_OK;
}

Resultat listeparametre_ajout_parametre(ListeParametre **listeparametre , Entier parametre , TypeParametre typeparametre)
{ 
	DEBUTZONESECURISEE
	if((*listeparametre)==NULL)
	{
		if(((*listeparametre)=(ListeParametre*)(malloc(sizeof(ListeParametre))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*listeparametre)->parametre=parametre;
		(*listeparametre)->typeparametre=typeparametre;
		(*listeparametre)->suivant=NULL;
	}
	else
	{
		SECURISE(listeparametre_ajout_parametre(&((*listeparametre)->suivant),parametre,typeparametre));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listeparametre_destruction(ListeParametre **listeparametre)
{ 
	DEBUTZONESECURISEE
	if((*listeparametre)==NULL)
		return RESULTAT_OK;
	SECURISE(listeparametre_destruction(&((*listeparametre)->suivant)));
	free(*listeparametre);
	*listeparametre=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listemessage_ajout_message(ListeMessage **listemessage , Chaine message , ListeTexte *texte , ListeParametre *parametre)
{ 
	DEBUTZONESECURISEE
	if((*listemessage)==NULL)
	{
		if(((*listemessage)=(ListeMessage*)(malloc(sizeof(ListeMessage))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*listemessage)->message=message;
		(*listemessage)->texte=texte;
		(*listemessage)->parametre=parametre;
		(*listemessage)->suivant=NULL;
	}
	else
	{
		SECURISE(listemessage_ajout_message(&((*listemessage)->suivant),message,texte,parametre));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listemessage_destruction(ListeMessage **listemessage)
{ 
	DEBUTZONESECURISEE
	if((*listemessage)==NULL)
		return RESULTAT_OK;
	SECURISE(listemessage_destruction(&((*listemessage)->suivant)));
	SECURISE(listetexte_destruction(&((*listemessage)->texte)));
	SECURISE(listeparametre_destruction(&((*listemessage)->parametre)));
	free((*listemessage)->message);
	free(*listemessage);
	*listemessage=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listecharset_initialisation(ListeCharset **listecharset)
{ 
	*listecharset=NULL;
	return RESULTAT_OK;
}

Resultat listecharset_ajout_charset(ListeCharset **listecharset , Chaine charset , ListeMessage *message)
{ 
	DEBUTZONESECURISEE
	if((*listecharset)==NULL)
	{
		if(((*listecharset)=(ListeCharset*)(malloc(sizeof(ListeCharset))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*listecharset)->charset=charset;
		(*listecharset)->message=message;
		(*listecharset)->suivant=NULL;
	}
	else
	{
		SECURISE(listecharset_ajout_charset(&((*listecharset)->suivant),charset,message));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listecharset_destruction(ListeCharset **listecharset)
{ 
	DEBUTZONESECURISEE
	if((*listecharset)==NULL)
		return RESULTAT_OK;
	SECURISE(listecharset_destruction(&((*listecharset)->suivant)));
	SECURISE(listemessage_destruction(&((*listecharset)->message)));
	free((*listecharset)->charset);
	free(*listecharset);
	*listecharset=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listelangue_initialisation(ListeLangue **listelangue)
{ 
	*listelangue=NULL;
	return RESULTAT_OK;
}

Resultat listelangue_ajout_langue(ListeLangue **listelangue , Chaine langue , ListeCharset *charset)
{ 
	DEBUTZONESECURISEE
	if((*listelangue)==NULL)
	{
		if(((*listelangue)=(ListeLangue*)(malloc(sizeof(ListeLangue))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*listelangue)->langue=langue;
		(*listelangue)->charset=charset;
		(*listelangue)->suivant=NULL;
	}
	else
	{
		SECURISE(listelangue_ajout_langue(&((*listelangue)->suivant),langue,charset));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat listelangue_destruction(ListeLangue **listelangue)
{ 
	DEBUTZONESECURISEE
	if((*listelangue)==NULL)
		return RESULTAT_OK;
	SECURISE(listelangue_destruction(&((*listelangue)->suivant)));
	SECURISE(listecharset_destruction(&((*listelangue)->charset)));
	free((*listelangue)->langue);
	free(*listelangue);
	*listelangue=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

