#! /sbin/sh

# Start or stop the Plan Network Server
# Michel Bourget Mon Feb 17 10:57:14 EST 1997
# "$Revision: 1.0 $"

IS_ON=/sbin/chkconfig

if $IS_ON verbose ; then       # For a verbose startup and shutdown
	ECHO=echo
	VERBOSE=-v
else                            # For a quiet startup and shutdown
	ECHO=:
	VERBOSE=
fi

DIR=/usr/local/lib
DB=$DIR/netplan.dir
DEBUG=0
DBGFILE=/var/tmp/netplan.dbg

case "$1" in
  'start')
	if $IS_ON netplan ; then
		if test -x $DIR/netplan ; then
			:
		else
			echo "Netplan : $DIR/netplan : missing or wrong permissions."
			exit 1
		fi
		killall netplan 1>/dev/null 2>&1
		sleep 1
		killall netplan 1>/dev/null 2>&1
		sleep 1
		$ECHO -n "Netplan: "

                if [ ! -d $DB -a ! -l $DB ] ; then
                        rm -f $DB 2>/dev/null
                        mkdir $DB
                        $ECHO -n "(Creating $DB directory) "
                fi
                chown nobody.nobody $DB
                chmod 1700 $DB

		if [ $DEBUG -ne 0 ] ; then
			$DIR/netplan -dv > $DBGFILE 2>&1 &
			$ECHO "started in debug mode on $DBGFILE ."
		else
			$DIR/netplan > /dev/null 2>&1
			$ECHO "started."
		fi
	fi
	;;

  'stop')
	killall netplan 2>&1
	sleep 1
	killall netplan 2>&1
	sleep 1
	$ECHO "Netplan: stopped."
	;;

  *)
	echo "usage: $0 {start|stop}"
	;;
esac
