/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_DRAWABLE_H__
#define __PGM_GLES_DRAWABLE_H__

/* pgmglesdrawable.h and pgmglviewport.h include eachother */
typedef struct _PgmGlesDrawable      PgmGlesDrawable;
typedef struct _PgmGlesDrawableClass PgmGlesDrawableClass;

#include <pgm/pgm.h>
#include "pgmglesdefs.h"
#include "pgmglesviewport.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_DRAWABLE (pgm_gles_drawable_get_type())
#define PGM_GLES_DRAWABLE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_DRAWABLE, PgmGlesDrawable))
#define PGM_GLES_DRAWABLE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_DRAWABLE, PgmGlesDrawableClass))
#define PGM_IS_GLES_DRAWABLE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_DRAWABLE))
#define PGM_IS_GLES_DRAWABLE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_DRAWABLE))
#define PGM_GLES_DRAWABLE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_DRAWABLE, PgmGlesDrawableClass))

/* (1/255) and (1/255)^2 to avoid successive divisions during conversions */
#define INV_255     0.003921568627f
#define SQR_INV_255 0.0000153787f

/* Flags */
typedef enum {
  PGM_GLES_DRAWABLE_IDENTITY_MATRIX = (1 << 0)
} PgmGlesDrawableFlags;

struct _PgmGlesDrawable {
  GstObject parent;

  /* Generic drawable to reflect */
  PgmDrawable *drawable;

  /* GlViewport container */
  PgmGlesViewport *glesviewport;

  /* Transformation */
  PgmMat4x4 *transformation_matrix;

  /* Id of the handler connected to the "PgmDrawable::changed" signal */
  guint change_handler;

  /* Position and size in viewport coordinates */
  gfloat width, height;
  gfloat x, y, z;

  /* Background vertex arrays */
  PgmGlesFloat bg_color[16];
  PgmGlesFloat bg_vertex[12];

  /* Flags */
  PgmGlesDrawableFlags flags;
};

struct _PgmGlesDrawableClass {
  GstObjectClass parent_class;

  /* virtual methods for subclasses */
  void (*sync)                      (PgmGlesDrawable *glesdrawable);
  void (*draw)                      (PgmGlesDrawable *glesdrawable);
  void (*regenerate)                (PgmGlesDrawable *glesdrawable);
  void (*update_projection)         (PgmGlesDrawable *glesdrawable);
  void (*set_visibility)            (PgmGlesDrawable *glesdrawable);
  void (*set_size)                  (PgmGlesDrawable *glesdrawable);
  void (*set_position)              (PgmGlesDrawable *glesdrawable);
  void (*set_transformation_matrix) (PgmGlesDrawable *glesdrawable);
  void (*set_fg_color)              (PgmGlesDrawable *glesdrawable);
  void (*set_bg_color)              (PgmGlesDrawable *glesdrawable);
  void (*set_opacity)               (PgmGlesDrawable *glesdrawable);
};

GType pgm_gles_drawable_get_type                  (void) G_GNUC_CONST;

void  pgm_gles_drawable_register                  (GTypeModule *module);

void  pgm_gles_drawable_sync                      (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_draw                      (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_regenerate                (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_update_projection         (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_visibility            (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_size                  (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_position              (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_transformation_matrix (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_fg_color              (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_bg_color              (PgmGlesDrawable *glesdrawable);
void  pgm_gles_drawable_set_opacity               (PgmGlesDrawable *glesdrawable);

G_END_DECLS

#endif /* __PGM_GLES_DRAWABLE_H__ */
