/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_PROGRAM_H__
#define __PGM_PROGRAM_H__

#include "pgmgldefs.h"

G_BEGIN_DECLS

typedef struct _PgmProgram PgmProgram;

/* Program names */
typedef enum {
  PGM_PROGRAM_PER_PLANE_I420_RGB = 0,
  PGM_PROGRAM_PER_PLANE_YV12_RGB,
  PGM_PROGRAM_NAME_LAST
} PgmProgramName;

struct _PgmProgram {
  /* Program string */
  gchar *string;
  guint  string_len;

  /* Program id */
  guint id;
};

/* Create the fragment programs */
gboolean    pgm_program_create (PgmContext *context);

/* Delete the fragment programs */
void        pgm_program_delete (void);

/* Get a program given its name */
PgmProgram *pgm_program_get    (PgmProgramName name);

/* Bind a program and enable the fragment program mode */
void        pgm_program_bind   (PgmProgram *program);

/* Disable the fragment program mode */
void        pgm_program_unbind (void);

G_END_DECLS

#endif /* __PGM_PROGRAM_H__ */
