EXEC_PROGRAM(${CMAKE_Fortran_COMPILER} ARGS ${CMAKE_BOOT_Fortran_FLAGS} -v OUTPUT_VARIABLE CMAKE_COMPILER_OUTPUT RETURN_VALUE CMAKE_COMPILER_RETURN)
MESSAGE( STATUS "Intel Fortran Compiler found, ${CMAKE_COMPILER_OUTPUT}")

IF(DEFINED CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)
ELSE(DEFINED CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)
    MESSAGE(STATUS "Checking whether ${CMAKE_Fortran_COMPILER} supports Fortran 2003")
    FILE(WRITE ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testFortranCompilerF2K3.f90 "
      PROGRAM TESTFortran2K3
          USE, INTRINSIC :: ISO_C_BINDING
          PRINT *, 'OK'
      END PROGRAM TESTFortran2K3
  ")
    TRY_COMPILE(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3 ${CMAKE_BINARY_DIR}
      ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testFortranCompilerF2K3.f90
      OUTPUT_VARIABLE OUTPUT)
    IF(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)
      MESSAGE(STATUS "Checking whether ${CMAKE_Fortran_COMPILER} supports Fortran 2003 -- yes")
      SET(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3 1 CACHE INTERNAL "")
    ELSE(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)
      MESSAGE(FATAL_ERROR "Checking whether ${CMAKE_Fortran_COMPILER} supports Fortran 2003 -- no")
      SET(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3 0 CACHE INTERNAL "")
    ENDIF(CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)
ENDIF(DEFINED CMAKE_Fortran_COMPILER_SUPPORTS_F2K3)

GET_FILENAME_COMPONENT(FORTRAN_BIN_DIR ${CMAKE_Fortran_COMPILER} PATH)
SET(FORTRAN_LIB_DIR "${FORTRAN_BIN_DIR}/../lib")

SET (CMAKE_Fortran_FLAGS_INIT "-fpp1")
SET (CMAKE_Fortran_FLAGS_DEBUG "-g")

SET(CMAKE_DL_LIBS "dl")
SET(CMAKE_SHARED_LIBRARY_Fortran_FLAGS "-KPIC")        
SET(CMAKE_SHARED_LIBRARY_CREATE_Fortran_FLAGS "-shared")
SET(CMAKE_SHARED_LIBRARY_LINK_Fortran_FLAGS "-i_dynamic")  
SET(CMAKE_SHARED_LIBRARY_RUNTIME_Fortran_FLAG "-Wl,-rpath,")
SET(CMAKE_SHARED_LIBRARY_RUNTIME_Fortran_FLAG_SEP ":")
SET(CMAKE_SHARED_LIBRARY_SONAME_Fortran_FLAG "-Wl,-soname,")
#SET (CMAKE_Fortran_FLAGS "-rounding-mode chopped")