"""
Panflute: pandoc filters made simple
====================================

Panflute is a Python package that makes `Pandoc <http://pandoc.org/>`_
filters fun to write. (`Installation <install.html>`_)
"""

from .utils import debug

from .containers import ListContainer, DictContainer

from .base import Element, Block, Inline, MetaValue

# These elements are not part of pandoc-types
from .elements import (
    Doc, Citation, ListItem,
    DefinitionItem, Definition, LineItem)

from .elements import (
    Null, HorizontalRule, Space, SoftBreak, LineBreak, Str,
    Code, BlockQuote, Note, Div, Plain, Para, Emph, Strong, Underline,
    Strikeout, Superscript, Subscript, SmallCaps, Span, RawBlock, RawInline,
    Math, CodeBlock, Link, Image, BulletList, OrderedList, DefinitionList,
    LineBlock, Figure, Header, Quoted, Cite)

from .table_elements import (
    Table, TableHead, TableFoot, TableBody,
    TableRow, TableCell, Caption)

from .elements import (
    MetaList, MetaMap, MetaString, MetaBool, MetaInlines, MetaBlocks)

from .io import load, dump, run_filter, run_filters
from .io import toJSONFilter, toJSONFilters  # Wrappers

from .tools import (
    stringify, yaml_filter, shell, run_pandoc, convert_text, get_option)

from .autofilter import main, panfl, get_filter_dirs, stdio

from .version import __version__
