/*
 * Decompiled with CFR 0.152.
 */
package org.helios.helpers;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.helios.helpers.BeanHelper;
import org.helios.helpers.NVP;
import org.helios.jmx.dynamic.annotations.JMXAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXHelperExtended {
    public static MBeanServerConnection getLocalMBeanServer(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            if (!server.getDefaultDomain().equals(domain)) continue;
            return server;
        }
        throw new RuntimeException("No MBeanServer located for domain [" + domain + "]");
    }

    public static ObjectName objectName(String on) {
        try {
            return new ObjectName(on);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Object Name", e);
        }
    }

    public static MBeanInfo mbeanInfo(MBeanServerConnection server, ObjectName on) {
        try {
            return server.getMBeanInfo(on);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get MBeanInfo", e);
        }
    }

    public static void setAttribute(ObjectName on, MBeanServerConnection server, String name, Object value) {
        try {
            server.setAttribute(on, new Attribute(name, value));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set Attribute", e);
        }
    }

    public static Map<String, Object> setAttributesWithRet(ObjectName on, MBeanServerConnection server, Object ... attributes) {
        HashMap<String, Object> returnValues = new HashMap<String, Object>(attributes.length);
        Collection<NVP> list = NVP.generate(attributes);
        for (NVP nvp : list) {
            try {
                JMXHelperExtended.setAttribute(on, server, nvp.getName(), nvp.getValue());
                returnValues.put(nvp.getName(), nvp.getValue());
            }
            catch (Exception e) {}
        }
        return returnValues;
    }

    public static Map<String, Object> getAttributes(ObjectName on, MBeanServerConnection server, String ... attributes) {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>(attributes.length);
            AttributeList attributeList = server.getAttributes(on, attributes);
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute at = (Attribute)attributeList.get(i);
                if (!JMXHelperExtended.isIn(at.getName(), attributes)) continue;
                attrs.put(at.getName(), at.getValue());
            }
            return attrs;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getAttributes on [" + on + "]", e);
        }
    }

    public static boolean isIn(String name, String[] array) {
        if (array == null || name == null) {
            return false;
        }
        for (String s : array) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> setAttributes(ObjectName on, MBeanServerConnection server, Object ... attributes) {
        HashMap<String, Object> returnValues = new HashMap<String, Object>(attributes.length);
        Collection<NVP> list = NVP.generate(attributes);
        for (NVP nvp : list) {
            JMXHelperExtended.setAttribute(on, server, nvp.getName(), nvp.getValue());
            returnValues.put(nvp.getName(), nvp.getValue());
        }
        return returnValues;
    }

    public static Object getAttribute(ObjectName on, MBeanServerConnection server, String name) {
        try {
            return server.getAttribute(on, name);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get attribute", e);
        }
    }

    public static Object invoke(ObjectName on, MBeanServerConnection server, String action, Object[] args, String[] signature) {
        try {
            return server.invoke(on, action, args, signature);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke operation", e);
        }
    }

    public static Map<String, Boolean> getAttributeIs(Object pojo) {
        HashMap<String, Boolean> isms = new HashMap<String, Boolean>();
        for (PropertyDescriptor pd : JMXHelperExtended.getPropertyDescriptors(pojo)) {
            if (pd.getReadMethod() != null) {
                if (pd.getReadMethod().getName().startsWith("is")) {
                    isms.put(JMXHelperExtended.getAttributeName(pd), Boolean.TRUE);
                    continue;
                }
                isms.put(JMXHelperExtended.getAttributeName(pd), Boolean.FALSE);
                continue;
            }
            isms.put(JMXHelperExtended.getAttributeName(pd), Boolean.FALSE);
        }
        return isms;
    }

    public static String getAttributeName(PropertyDescriptor pd) {
        Method getMethod = pd.getReadMethod();
        Method setMethod = pd.getWriteMethod();
        if (getMethod != null && getMethod.isAnnotationPresent(JMXAttribute.class)) {
            return getMethod.getAnnotation(JMXAttribute.class).name();
        }
        if (setMethod != null && setMethod.isAnnotationPresent(JMXAttribute.class)) {
            return setMethod.getAnnotation(JMXAttribute.class).name();
        }
        return pd.getName();
    }

    public static Map<String, boolean[]> getAttributeMutability(Object pojo) {
        HashMap<String, boolean[]> mutabilities = new HashMap<String, boolean[]>();
        boolean[] mutability = null;
        String name = null;
        for (PropertyDescriptor pd : JMXHelperExtended.getPropertyDescriptors(pojo)) {
            mutability = new boolean[2];
            name = pd.getName();
            mutability[0] = pd.getReadMethod() != null;
            mutability[1] = pd.getWriteMethod() != null;
            mutabilities.put(JMXHelperExtended.getAttributeName(pd), mutability);
        }
        return mutabilities;
    }

    public static List<String> getPojoAttributes(Object pojo) {
        BeanInfo bi = JMXHelperExtended.getBeanInfo(pojo);
        ArrayList<String> list = new ArrayList<String>();
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            Method getMethod = null;
            Method setMethod = null;
            JMXAttribute getAttribute = null;
            JMXAttribute setAttribute = null;
            String getName = null;
            String setName = null;
            getMethod = pd.getReadMethod();
            setMethod = pd.getWriteMethod();
            if (getMethod != null) {
                getAttribute = getMethod.getAnnotation(JMXAttribute.class);
            }
            if (setMethod != null) {
                setAttribute = setMethod.getAnnotation(JMXAttribute.class);
            }
            if (getAttribute != null) {
                getName = getAttribute.name();
            }
            if (setAttribute != null) {
                setName = setAttribute.name();
            }
            if (getName == null && setName == null) {
                list.add(pd.getName());
                continue;
            }
            if (getName != null && !list.contains(getName)) {
                list.add(getName);
            }
            if (setName == null || list.contains(setName)) continue;
            list.add(setName);
        }
        return list;
    }

    public static String[] getSortedAttributeNames(Object pojo) {
        String[] attrs = null;
        List<String> list = JMXHelperExtended.getPojoAttributes(pojo);
        List<String> objList = JMXHelperExtended.getPojoAttributes(new Object());
        list.removeAll(objList);
        Collections.sort(list);
        attrs = list.toArray(new String[list.size()]);
        return attrs;
    }

    public static String[] getSortedAttributeDescriptions(Object pojo) {
        String[] attrDescs = null;
        List list = BeanHelper.getPojoBeanAttributes((Object)pojo);
        attrDescs = new String[list.size()];
        PropertyDescriptor pd = null;
        Class<?> clazz = pojo.getClass();
        for (int i = 0; i < attrDescs.length; ++i) {
            pd = BeanHelper.getPropertyDescriptor(clazz, (String)((String)list.get(i)));
            attrDescs[i] = JMXHelperExtended.getAttributeDescription(pd);
        }
        return (String[])JMXHelperExtended.sortArray(String.class, attrDescs);
    }

    public static String getAttributeDescription(PropertyDescriptor pd) {
        Method getMethod = pd.getReadMethod();
        Method setMethod = pd.getWriteMethod();
        JMXAttribute jmxAttribute = null;
        if (getMethod != null && getMethod.isAnnotationPresent(JMXAttribute.class)) {
            jmxAttribute = getMethod.getAnnotation(JMXAttribute.class);
            return jmxAttribute.description();
        }
        if (setMethod != null && setMethod.isAnnotationPresent(JMXAttribute.class)) {
            jmxAttribute = setMethod.getAnnotation(JMXAttribute.class);
            return jmxAttribute.description();
        }
        return "MBean Attribute";
    }

    public static Object[] sortArray(Object ... args) {
        ArrayList<Comparable> list = new ArrayList<Comparable>(args.length);
        for (Object o : args) {
            list.add((Comparable)o);
        }
        Collections.sort(list);
        return list.toArray(new Object[list.size()]);
    }

    public static List<PropertyDescriptor> getPropertyDescriptors(Object pojo) {
        List<PropertyDescriptor> list = JMXHelperExtended.getAllPropertyDescriptors(pojo);
        List<PropertyDescriptor> objList = JMXHelperExtended.getAllPropertyDescriptors(new Object());
        list.removeAll(objList);
        return list;
    }

    public static List<PropertyDescriptor> getAllPropertyDescriptors(Object pojo) {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        BeanInfo bi = JMXHelperExtended.getBeanInfo(pojo);
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            list.add(pd);
        }
        return list;
    }

    public static BeanInfo getBeanInfo(Object pojo) {
        try {
            return Introspector.getBeanInfo(pojo.getClass());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create bean info", e);
        }
    }
}

