
enum M6UnicodeProperty : uint8
{
	kLETTER			= 0,
	kNUMBER			= 1,
	kCOMBININGMARK	= 2,
	kPUNCTUATION	= 3,
	kSYMBOL			= 4,
	kSEPARATOR		= 5,
	kCONTROL		= 6,
	kOTHER			= 7
};

struct M6UnicodeInfoAtom
{
	unsigned int	ccc		: 8;	// canonical combining class
	unsigned int	prop	: 3;	// unicode property
	unsigned int	lower	: 20;
};

// BOOST_STATIC_ASSERT(sizeof(M6UnicodeInfoAtom) == sizeof(uint32));

typedef M6UnicodeInfoAtom	M6UnicodeInfoPage[256];

struct M6UnicodeInfo {
	int16				page_index[4352];
	M6UnicodeInfoPage	data[110];
} kM6UnicodeInfo = {
	{
		  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
		 16, 17, 18, 19, 20, 17, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
		 31, 32, 33, 34, 35, 33, 33, 36, 33, 37, 33, 38, 39, 40, 41, 42,
		 43, 44, 45, 33, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 46, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 47,
		 17, 17, 17, 17, 48, 17, 49, 50, 51, 52, 53, 54, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 55, 56, 57, 57, 58, 56, 57, 57, 59,
		 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 59, 17, 60, 61, 17, 62, 63, 64,
		 65, 66, 67, 68, 69, 57, 57, 57, 70, 71, 72, 73, 74, 57, 75, 57,
		 76, 77, 57, 57, 57, 57, 78, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 17, 17, 17, 79, 80, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 17, 17, 17, 17, 81, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, 82, 57, 57, 57, 57, 83,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 84, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 85, 86, 87, 88, 89, 90, 91, 92, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 93, 57,
		 94, 95, 96, 97, 98, 99,100,101, 57, 57, 57, 57, 57, 57, 57, 57,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
		 17, 17, 17, 17, 17, 17,102,103, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57,104,105, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 17, 17,106, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		107,108, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,109,
		 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
		 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,109,
	},
	{
// page 0
		{
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00061 },
			{0, kLETTER, 0x00062 },
			{0, kLETTER, 0x00063 },
			{0, kLETTER, 0x00064 },
			{0, kLETTER, 0x00065 },
			{0, kLETTER, 0x00066 },
			{0, kLETTER, 0x00067 },
			{0, kLETTER, 0x00068 },
			{0, kLETTER, 0x00069 },
			{0, kLETTER, 0x0006a },
			{0, kLETTER, 0x0006b },
			{0, kLETTER, 0x0006c },
			{0, kLETTER, 0x0006d },
			{0, kLETTER, 0x0006e },
			{0, kLETTER, 0x0006f },
			{0, kLETTER, 0x00070 },
			{0, kLETTER, 0x00071 },
			{0, kLETTER, 0x00072 },
			{0, kLETTER, 0x00073 },
			{0, kLETTER, 0x00074 },
			{0, kLETTER, 0x00075 },
			{0, kLETTER, 0x00076 },
			{0, kLETTER, 0x00077 },
			{0, kLETTER, 0x00078 },
			{0, kLETTER, 0x00079 },
			{0, kLETTER, 0x0007a },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x003bc },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x000e0 },
			{0, kLETTER, 0x000e1 },
			{0, kLETTER, 0x000e2 },
			{0, kLETTER, 0x000e3 },
			{0, kLETTER, 0x000e4 },
			{0, kLETTER, 0x000e5 },
			{0, kLETTER, 0x000e6 },
			{0, kLETTER, 0x000e7 },
			{0, kLETTER, 0x000e8 },
			{0, kLETTER, 0x000e9 },
			{0, kLETTER, 0x000ea },
			{0, kLETTER, 0x000eb },
			{0, kLETTER, 0x000ec },
			{0, kLETTER, 0x000ed },
			{0, kLETTER, 0x000ee },
			{0, kLETTER, 0x000ef },
			{0, kLETTER, 0x000f0 },
			{0, kLETTER, 0x000f1 },
			{0, kLETTER, 0x000f2 },
			{0, kLETTER, 0x000f3 },
			{0, kLETTER, 0x000f4 },
			{0, kLETTER, 0x000f5 },
			{0, kLETTER, 0x000f6 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x000f8 },
			{0, kLETTER, 0x000f9 },
			{0, kLETTER, 0x000fa },
			{0, kLETTER, 0x000fb },
			{0, kLETTER, 0x000fc },
			{0, kLETTER, 0x000fd },
			{0, kLETTER, 0x000fe },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 1
		{
			{0, kLETTER, 0x00101 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00103 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00105 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00107 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00109 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0010b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0010d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0010f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00111 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00113 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00115 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00117 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00119 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0011b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0011d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0011f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00121 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00123 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00125 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00127 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00129 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0012b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0012d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0012f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00133 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00135 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00137 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0013a },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0013c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0013e },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00140 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00142 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00144 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00146 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00148 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x0014b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0014d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0014f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00151 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00153 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00155 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00157 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00159 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0015b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0015d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0015f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00161 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00163 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00165 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00167 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00169 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0016b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0016d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0016f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00171 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00173 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00175 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00177 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x000ff },
			{0, kLETTER, 0x0017a },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0017c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0017e },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00073 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00253 },
			{0, kLETTER, 0x00183 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00185 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00254 },
			{0, kLETTER, 0x00188 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00256 },
			{0, kLETTER, 0x00257 },
			{0, kLETTER, 0x0018c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001dd },
			{0, kLETTER, 0x00259 },
			{0, kLETTER, 0x0025b },
			{0, kLETTER, 0x00192 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00260 },
			{0, kLETTER, 0x00263 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00269 },
			{0, kLETTER, 0x00268 },
			{0, kLETTER, 0x00199 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0026f },
			{0, kLETTER, 0x00272 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00275 },
			{0, kLETTER, 0x001a1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001a3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001a5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00280 },
			{0, kLETTER, 0x001a8 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00283 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001ad },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00288 },
			{0, kLETTER, 0x001b0 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0028a },
			{0, kLETTER, 0x0028b },
			{0, kLETTER, 0x001b4 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001b6 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00292 },
			{0, kLETTER, 0x001b9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001bd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001c6 },
			{0, kLETTER, 0x001c6 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001c9 },
			{0, kLETTER, 0x001c9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001cc },
			{0, kLETTER, 0x001cc },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001ce },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001d0 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001d2 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001d4 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001d6 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001d8 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001da },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001dc },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001df },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001e1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001e3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001e5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001e7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001e9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001eb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001ed },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001ef },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x001f3 },
			{0, kLETTER, 0x001f3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001f5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00195 },
			{0, kLETTER, 0x001bf },
			{0, kLETTER, 0x001f9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001fb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001fd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x001ff },
			{0, kLETTER, 0x00000 },
		},
// page 2
		{
			{0, kLETTER, 0x00201 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00203 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00205 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00207 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00209 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0020b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0020d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0020f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00211 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00213 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00215 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00217 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00219 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0021b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0021d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0021f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0019e },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00223 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00225 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00227 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00229 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0022b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0022d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0022f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00231 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00233 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c65 },
			{0, kLETTER, 0x0023c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0019a },
			{0, kLETTER, 0x02c66 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00242 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00180 },
			{0, kLETTER, 0x00289 },
			{0, kLETTER, 0x0028c },
			{0, kLETTER, 0x00247 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00249 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0024b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0024d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0024f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 3
		{
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{232, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{232, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{202, kCOMBININGMARK, 0x00000 },
			{202, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{202, kCOMBININGMARK, 0x00000 },
			{202, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{240, kCOMBININGMARK, 0x003b9 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{232, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{233, kCOMBININGMARK, 0x00000 },
			{234, kCOMBININGMARK, 0x00000 },
			{234, kCOMBININGMARK, 0x00000 },
			{233, kCOMBININGMARK, 0x00000 },
			{234, kCOMBININGMARK, 0x00000 },
			{234, kCOMBININGMARK, 0x00000 },
			{233, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00371 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00373 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00377 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x003ac },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x003ad },
			{0, kLETTER, 0x003ae },
			{0, kLETTER, 0x003af },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x003cc },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x003cd },
			{0, kLETTER, 0x003ce },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x003b1 },
			{0, kLETTER, 0x003b2 },
			{0, kLETTER, 0x003b3 },
			{0, kLETTER, 0x003b4 },
			{0, kLETTER, 0x003b5 },
			{0, kLETTER, 0x003b6 },
			{0, kLETTER, 0x003b7 },
			{0, kLETTER, 0x003b8 },
			{0, kLETTER, 0x003b9 },
			{0, kLETTER, 0x003ba },
			{0, kLETTER, 0x003bb },
			{0, kLETTER, 0x003bc },
			{0, kLETTER, 0x003bd },
			{0, kLETTER, 0x003be },
			{0, kLETTER, 0x003bf },
			{0, kLETTER, 0x003c0 },
			{0, kLETTER, 0x003c1 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x003c3 },
			{0, kLETTER, 0x003c4 },
			{0, kLETTER, 0x003c5 },
			{0, kLETTER, 0x003c6 },
			{0, kLETTER, 0x003c7 },
			{0, kLETTER, 0x003c8 },
			{0, kLETTER, 0x003c9 },
			{0, kLETTER, 0x003ca },
			{0, kLETTER, 0x003cb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003c3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003d7 },
			{0, kLETTER, 0x003b2 },
			{0, kLETTER, 0x003b8 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003c6 },
			{0, kLETTER, 0x003c0 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003d9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003db },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003dd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003df },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003e1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003e3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003e5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003e7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003e9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003eb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003ed },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003ef },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003ba },
			{0, kLETTER, 0x003c1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003b8 },
			{0, kLETTER, 0x003b5 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x003f8 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x003f2 },
			{0, kLETTER, 0x003fb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0037b },
			{0, kLETTER, 0x0037c },
			{0, kLETTER, 0x0037d },
		},
// page 4
		{
			{0, kLETTER, 0x00450 },
			{0, kLETTER, 0x00451 },
			{0, kLETTER, 0x00452 },
			{0, kLETTER, 0x00453 },
			{0, kLETTER, 0x00454 },
			{0, kLETTER, 0x00455 },
			{0, kLETTER, 0x00456 },
			{0, kLETTER, 0x00457 },
			{0, kLETTER, 0x00458 },
			{0, kLETTER, 0x00459 },
			{0, kLETTER, 0x0045a },
			{0, kLETTER, 0x0045b },
			{0, kLETTER, 0x0045c },
			{0, kLETTER, 0x0045d },
			{0, kLETTER, 0x0045e },
			{0, kLETTER, 0x0045f },
			{0, kLETTER, 0x00430 },
			{0, kLETTER, 0x00431 },
			{0, kLETTER, 0x00432 },
			{0, kLETTER, 0x00433 },
			{0, kLETTER, 0x00434 },
			{0, kLETTER, 0x00435 },
			{0, kLETTER, 0x00436 },
			{0, kLETTER, 0x00437 },
			{0, kLETTER, 0x00438 },
			{0, kLETTER, 0x00439 },
			{0, kLETTER, 0x0043a },
			{0, kLETTER, 0x0043b },
			{0, kLETTER, 0x0043c },
			{0, kLETTER, 0x0043d },
			{0, kLETTER, 0x0043e },
			{0, kLETTER, 0x0043f },
			{0, kLETTER, 0x00440 },
			{0, kLETTER, 0x00441 },
			{0, kLETTER, 0x00442 },
			{0, kLETTER, 0x00443 },
			{0, kLETTER, 0x00444 },
			{0, kLETTER, 0x00445 },
			{0, kLETTER, 0x00446 },
			{0, kLETTER, 0x00447 },
			{0, kLETTER, 0x00448 },
			{0, kLETTER, 0x00449 },
			{0, kLETTER, 0x0044a },
			{0, kLETTER, 0x0044b },
			{0, kLETTER, 0x0044c },
			{0, kLETTER, 0x0044d },
			{0, kLETTER, 0x0044e },
			{0, kLETTER, 0x0044f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00461 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00463 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00465 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00467 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00469 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0046b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0046d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0046f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00471 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00473 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00475 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00477 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00479 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0047b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0047d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0047f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00481 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x0048b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0048d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0048f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00491 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00493 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00495 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00497 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00499 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0049b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0049d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0049f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004a1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004a3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004a5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004a7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004a9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ab },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ad },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004af },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004b1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004b3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004b5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004b7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004b9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004bb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004bd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004bf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004cf },
			{0, kLETTER, 0x004c2 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004c4 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004c6 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004c8 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ca },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004cc },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ce },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004d1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004d3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004d5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004d7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004d9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004db },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004dd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004df },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004e1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004e3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004e5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004e7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004e9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004eb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ed },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ef },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004f1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004f3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004f5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004f7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004f9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004fb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004fd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x004ff },
			{0, kLETTER, 0x00000 },
		},
// page 5
		{
			{0, kLETTER, 0x00501 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00503 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00505 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00507 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00509 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0050b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0050d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0050f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00511 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00513 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00515 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00517 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00519 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0051b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0051d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0051f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00521 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00523 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00525 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00527 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00561 },
			{0, kLETTER, 0x00562 },
			{0, kLETTER, 0x00563 },
			{0, kLETTER, 0x00564 },
			{0, kLETTER, 0x00565 },
			{0, kLETTER, 0x00566 },
			{0, kLETTER, 0x00567 },
			{0, kLETTER, 0x00568 },
			{0, kLETTER, 0x00569 },
			{0, kLETTER, 0x0056a },
			{0, kLETTER, 0x0056b },
			{0, kLETTER, 0x0056c },
			{0, kLETTER, 0x0056d },
			{0, kLETTER, 0x0056e },
			{0, kLETTER, 0x0056f },
			{0, kLETTER, 0x00570 },
			{0, kLETTER, 0x00571 },
			{0, kLETTER, 0x00572 },
			{0, kLETTER, 0x00573 },
			{0, kLETTER, 0x00574 },
			{0, kLETTER, 0x00575 },
			{0, kLETTER, 0x00576 },
			{0, kLETTER, 0x00577 },
			{0, kLETTER, 0x00578 },
			{0, kLETTER, 0x00579 },
			{0, kLETTER, 0x0057a },
			{0, kLETTER, 0x0057b },
			{0, kLETTER, 0x0057c },
			{0, kLETTER, 0x0057d },
			{0, kLETTER, 0x0057e },
			{0, kLETTER, 0x0057f },
			{0, kLETTER, 0x00580 },
			{0, kLETTER, 0x00581 },
			{0, kLETTER, 0x00582 },
			{0, kLETTER, 0x00583 },
			{0, kLETTER, 0x00584 },
			{0, kLETTER, 0x00585 },
			{0, kLETTER, 0x00586 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{222, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{222, kCOMBININGMARK, 0x00000 },
			{228, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{10, kCOMBININGMARK, 0x00000 },
			{11, kCOMBININGMARK, 0x00000 },
			{12, kCOMBININGMARK, 0x00000 },
			{13, kCOMBININGMARK, 0x00000 },
			{14, kCOMBININGMARK, 0x00000 },
			{15, kCOMBININGMARK, 0x00000 },
			{16, kCOMBININGMARK, 0x00000 },
			{17, kCOMBININGMARK, 0x00000 },
			{18, kCOMBININGMARK, 0x00000 },
			{19, kCOMBININGMARK, 0x00000 },
			{19, kCOMBININGMARK, 0x00000 },
			{20, kCOMBININGMARK, 0x00000 },
			{21, kCOMBININGMARK, 0x00000 },
			{22, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{23, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{24, kCOMBININGMARK, 0x00000 },
			{25, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{18, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 6
		{
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{30, kCOMBININGMARK, 0x00000 },
			{31, kCOMBININGMARK, 0x00000 },
			{32, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{27, kCOMBININGMARK, 0x00000 },
			{28, kCOMBININGMARK, 0x00000 },
			{29, kCOMBININGMARK, 0x00000 },
			{30, kCOMBININGMARK, 0x00000 },
			{31, kCOMBININGMARK, 0x00000 },
			{32, kCOMBININGMARK, 0x00000 },
			{33, kCOMBININGMARK, 0x00000 },
			{34, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{35, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 7
		{
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{36, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 8
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{27, kCOMBININGMARK, 0x00000 },
			{28, kCOMBININGMARK, 0x00000 },
			{29, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 9
		{
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 10
		{
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 11
		{
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 12
		{
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{84, kCOMBININGMARK, 0x00000 },
			{91, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 13
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 14
		{
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{103, kCOMBININGMARK, 0x00000 },
			{103, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{107, kCOMBININGMARK, 0x00000 },
			{107, kCOMBININGMARK, 0x00000 },
			{107, kCOMBININGMARK, 0x00000 },
			{107, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{118, kCOMBININGMARK, 0x00000 },
			{118, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{122, kCOMBININGMARK, 0x00000 },
			{122, kCOMBININGMARK, 0x00000 },
			{122, kCOMBININGMARK, 0x00000 },
			{122, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 15
		{
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{129, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{132, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{130, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 16
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x02d00 },
			{0, kLETTER, 0x02d01 },
			{0, kLETTER, 0x02d02 },
			{0, kLETTER, 0x02d03 },
			{0, kLETTER, 0x02d04 },
			{0, kLETTER, 0x02d05 },
			{0, kLETTER, 0x02d06 },
			{0, kLETTER, 0x02d07 },
			{0, kLETTER, 0x02d08 },
			{0, kLETTER, 0x02d09 },
			{0, kLETTER, 0x02d0a },
			{0, kLETTER, 0x02d0b },
			{0, kLETTER, 0x02d0c },
			{0, kLETTER, 0x02d0d },
			{0, kLETTER, 0x02d0e },
			{0, kLETTER, 0x02d0f },
			{0, kLETTER, 0x02d10 },
			{0, kLETTER, 0x02d11 },
			{0, kLETTER, 0x02d12 },
			{0, kLETTER, 0x02d13 },
			{0, kLETTER, 0x02d14 },
			{0, kLETTER, 0x02d15 },
			{0, kLETTER, 0x02d16 },
			{0, kLETTER, 0x02d17 },
			{0, kLETTER, 0x02d18 },
			{0, kLETTER, 0x02d19 },
			{0, kLETTER, 0x02d1a },
			{0, kLETTER, 0x02d1b },
			{0, kLETTER, 0x02d1c },
			{0, kLETTER, 0x02d1d },
			{0, kLETTER, 0x02d1e },
			{0, kLETTER, 0x02d1f },
			{0, kLETTER, 0x02d20 },
			{0, kLETTER, 0x02d21 },
			{0, kLETTER, 0x02d22 },
			{0, kLETTER, 0x02d23 },
			{0, kLETTER, 0x02d24 },
			{0, kLETTER, 0x02d25 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x02d27 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x02d2d },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 17
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 18
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 19
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 20
		{
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 21
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 22
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 23
		{
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{228, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 24
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{222, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 25
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 26
		{
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
		},
// page 27
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 28
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{234, kCOMBININGMARK, 0x00000 },
			{214, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{202, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{233, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
		},
// page 29
		{
			{0, kLETTER, 0x01e01 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e03 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e05 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e07 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e09 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e0b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e0d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e0f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e11 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e13 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e15 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e17 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e19 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e1b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e1d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e1f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e21 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e23 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e25 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e27 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e29 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e2b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e2d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e2f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e31 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e33 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e35 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e37 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e39 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e3b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e3d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e3f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e41 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e43 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e45 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e47 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e49 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e4b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e4d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e4f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e51 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e53 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e55 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e57 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e59 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e5b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e5d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e5f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e61 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e63 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e65 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e67 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e69 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e6b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e6d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e6f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e71 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e73 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e75 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e77 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e79 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e7b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e7d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e7f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e81 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e83 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e85 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e87 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e89 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e8b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e8d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e8f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e91 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e93 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01e95 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01e61 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ea1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ea3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ea5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ea7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ea9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eab },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ead },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eaf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eb1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eb3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eb5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eb7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eb9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ebb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ebd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ebf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ec1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ec3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ec5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ec7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ec9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ecb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ecd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ecf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ed1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ed3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ed5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ed7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ed9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01edb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01edd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01edf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ee1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ee3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ee5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ee7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ee9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eeb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eed },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eef },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ef1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ef3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ef5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ef7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01ef9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01efb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01efd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01eff },
			{0, kLETTER, 0x00000 },
		},
// page 30
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01f00 },
			{0, kLETTER, 0x01f01 },
			{0, kLETTER, 0x01f02 },
			{0, kLETTER, 0x01f03 },
			{0, kLETTER, 0x01f04 },
			{0, kLETTER, 0x01f05 },
			{0, kLETTER, 0x01f06 },
			{0, kLETTER, 0x01f07 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f10 },
			{0, kLETTER, 0x01f11 },
			{0, kLETTER, 0x01f12 },
			{0, kLETTER, 0x01f13 },
			{0, kLETTER, 0x01f14 },
			{0, kLETTER, 0x01f15 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01f20 },
			{0, kLETTER, 0x01f21 },
			{0, kLETTER, 0x01f22 },
			{0, kLETTER, 0x01f23 },
			{0, kLETTER, 0x01f24 },
			{0, kLETTER, 0x01f25 },
			{0, kLETTER, 0x01f26 },
			{0, kLETTER, 0x01f27 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01f30 },
			{0, kLETTER, 0x01f31 },
			{0, kLETTER, 0x01f32 },
			{0, kLETTER, 0x01f33 },
			{0, kLETTER, 0x01f34 },
			{0, kLETTER, 0x01f35 },
			{0, kLETTER, 0x01f36 },
			{0, kLETTER, 0x01f37 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f40 },
			{0, kLETTER, 0x01f41 },
			{0, kLETTER, 0x01f42 },
			{0, kLETTER, 0x01f43 },
			{0, kLETTER, 0x01f44 },
			{0, kLETTER, 0x01f45 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f51 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f53 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f55 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x01f57 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01f60 },
			{0, kLETTER, 0x01f61 },
			{0, kLETTER, 0x01f62 },
			{0, kLETTER, 0x01f63 },
			{0, kLETTER, 0x01f64 },
			{0, kLETTER, 0x01f65 },
			{0, kLETTER, 0x01f66 },
			{0, kLETTER, 0x01f67 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01fb0 },
			{0, kLETTER, 0x01fb1 },
			{0, kLETTER, 0x01f70 },
			{0, kLETTER, 0x01f71 },
			{0, kLETTER, 0x00001 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x003b9 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01f72 },
			{0, kLETTER, 0x01f73 },
			{0, kLETTER, 0x01f74 },
			{0, kLETTER, 0x01f75 },
			{0, kLETTER, 0x00001 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01fd0 },
			{0, kLETTER, 0x01fd1 },
			{0, kLETTER, 0x01f76 },
			{0, kLETTER, 0x01f77 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01fe0 },
			{0, kLETTER, 0x01fe1 },
			{0, kLETTER, 0x01f7a },
			{0, kLETTER, 0x01f7b },
			{0, kLETTER, 0x01fe5 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x01f78 },
			{0, kLETTER, 0x01f79 },
			{0, kLETTER, 0x01f7c },
			{0, kLETTER, 0x01f7d },
			{0, kLETTER, 0x00001 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 31
		{
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSEPARATOR, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 32
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x003c9 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x0006b },
			{0, kLETTER, 0x000e5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0214e },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x02170 },
			{0, kNUMBER, 0x02171 },
			{0, kNUMBER, 0x02172 },
			{0, kNUMBER, 0x02173 },
			{0, kNUMBER, 0x02174 },
			{0, kNUMBER, 0x02175 },
			{0, kNUMBER, 0x02176 },
			{0, kNUMBER, 0x02177 },
			{0, kNUMBER, 0x02178 },
			{0, kNUMBER, 0x02179 },
			{0, kNUMBER, 0x0217a },
			{0, kNUMBER, 0x0217b },
			{0, kNUMBER, 0x0217c },
			{0, kNUMBER, 0x0217d },
			{0, kNUMBER, 0x0217e },
			{0, kNUMBER, 0x0217f },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x02184 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 33
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 34
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 35
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x024d0 },
			{0, kSYMBOL, 0x024d1 },
			{0, kSYMBOL, 0x024d2 },
			{0, kSYMBOL, 0x024d3 },
			{0, kSYMBOL, 0x024d4 },
			{0, kSYMBOL, 0x024d5 },
			{0, kSYMBOL, 0x024d6 },
			{0, kSYMBOL, 0x024d7 },
			{0, kSYMBOL, 0x024d8 },
			{0, kSYMBOL, 0x024d9 },
			{0, kSYMBOL, 0x024da },
			{0, kSYMBOL, 0x024db },
			{0, kSYMBOL, 0x024dc },
			{0, kSYMBOL, 0x024dd },
			{0, kSYMBOL, 0x024de },
			{0, kSYMBOL, 0x024df },
			{0, kSYMBOL, 0x024e0 },
			{0, kSYMBOL, 0x024e1 },
			{0, kSYMBOL, 0x024e2 },
			{0, kSYMBOL, 0x024e3 },
			{0, kSYMBOL, 0x024e4 },
			{0, kSYMBOL, 0x024e5 },
			{0, kSYMBOL, 0x024e6 },
			{0, kSYMBOL, 0x024e7 },
			{0, kSYMBOL, 0x024e8 },
			{0, kSYMBOL, 0x024e9 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
		},
// page 36
		{
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 37
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 38
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 39
		{
			{0, kLETTER, 0x02c30 },
			{0, kLETTER, 0x02c31 },
			{0, kLETTER, 0x02c32 },
			{0, kLETTER, 0x02c33 },
			{0, kLETTER, 0x02c34 },
			{0, kLETTER, 0x02c35 },
			{0, kLETTER, 0x02c36 },
			{0, kLETTER, 0x02c37 },
			{0, kLETTER, 0x02c38 },
			{0, kLETTER, 0x02c39 },
			{0, kLETTER, 0x02c3a },
			{0, kLETTER, 0x02c3b },
			{0, kLETTER, 0x02c3c },
			{0, kLETTER, 0x02c3d },
			{0, kLETTER, 0x02c3e },
			{0, kLETTER, 0x02c3f },
			{0, kLETTER, 0x02c40 },
			{0, kLETTER, 0x02c41 },
			{0, kLETTER, 0x02c42 },
			{0, kLETTER, 0x02c43 },
			{0, kLETTER, 0x02c44 },
			{0, kLETTER, 0x02c45 },
			{0, kLETTER, 0x02c46 },
			{0, kLETTER, 0x02c47 },
			{0, kLETTER, 0x02c48 },
			{0, kLETTER, 0x02c49 },
			{0, kLETTER, 0x02c4a },
			{0, kLETTER, 0x02c4b },
			{0, kLETTER, 0x02c4c },
			{0, kLETTER, 0x02c4d },
			{0, kLETTER, 0x02c4e },
			{0, kLETTER, 0x02c4f },
			{0, kLETTER, 0x02c50 },
			{0, kLETTER, 0x02c51 },
			{0, kLETTER, 0x02c52 },
			{0, kLETTER, 0x02c53 },
			{0, kLETTER, 0x02c54 },
			{0, kLETTER, 0x02c55 },
			{0, kLETTER, 0x02c56 },
			{0, kLETTER, 0x02c57 },
			{0, kLETTER, 0x02c58 },
			{0, kLETTER, 0x02c59 },
			{0, kLETTER, 0x02c5a },
			{0, kLETTER, 0x02c5b },
			{0, kLETTER, 0x02c5c },
			{0, kLETTER, 0x02c5d },
			{0, kLETTER, 0x02c5e },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x02c61 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0026b },
			{0, kLETTER, 0x01d7d },
			{0, kLETTER, 0x0027d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c68 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c6a },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c6c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00251 },
			{0, kLETTER, 0x00271 },
			{0, kLETTER, 0x00250 },
			{0, kLETTER, 0x00252 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c73 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c76 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0023f },
			{0, kLETTER, 0x00240 },
			{0, kLETTER, 0x02c81 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c83 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c85 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c87 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c89 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c8b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c8d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c8f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c91 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c93 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c95 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c97 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c99 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c9b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c9d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02c9f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ca1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ca3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ca5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ca7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ca9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cab },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cad },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02caf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cb1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cb3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cb5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cb7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cb9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cbb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cbd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cbf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cc1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cc3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cc5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cc7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cc9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ccb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ccd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ccf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cd1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cd3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cd5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cd7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cd9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cdb },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cdd },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cdf },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ce1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02ce3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x02cec },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x02cee },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x02cf3 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
		},
// page 40
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
		},
// page 41
		{
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 42
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 43
		{
			{0, kSEPARATOR, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{218, kCOMBININGMARK, 0x00000 },
			{228, kCOMBININGMARK, 0x00000 },
			{232, kCOMBININGMARK, 0x00000 },
			{222, kCOMBININGMARK, 0x00000 },
			{224, kCOMBININGMARK, 0x00000 },
			{224, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{8, kCOMBININGMARK, 0x00000 },
			{8, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 44
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 45
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 46
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 47
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 48
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
		},
// page 49
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x0a641 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a643 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a645 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a647 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a649 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a64b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a64d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a64f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a651 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a653 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a655 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a657 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a659 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a65b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a65d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a65f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a661 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a663 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a665 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a667 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a669 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a66b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a66d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a681 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a683 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a685 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a687 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a689 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a68b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a68d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a68f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a691 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a693 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a695 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a697 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 50
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x0a723 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a725 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a727 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a729 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a72b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a72d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a72f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a733 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a735 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a737 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a739 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a73b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a73d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a73f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a741 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a743 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a745 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a747 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a749 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a74b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a74d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a74f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a751 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a753 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a755 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a757 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a759 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a75b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a75d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a75f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a761 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a763 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a765 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a767 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a769 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a76b },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a76d },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a76f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a77a },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a77c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x01d79 },
			{0, kLETTER, 0x0a77f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a781 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a783 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a785 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a787 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x0a78c },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00265 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x0a791 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a793 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x0a7a1 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a7a3 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a7a5 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a7a7 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x0a7a9 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00266 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 51
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 52
		{
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 53
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 54
		{
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 55
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 56
		{
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 57
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 58
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
		},
// page 59
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
		},
// page 60
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 61
		{
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kLETTER, 0x00001 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{26, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 62
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 63
		{
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
		},
// page 64
		{
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x0ff41 },
			{0, kLETTER, 0x0ff42 },
			{0, kLETTER, 0x0ff43 },
			{0, kLETTER, 0x0ff44 },
			{0, kLETTER, 0x0ff45 },
			{0, kLETTER, 0x0ff46 },
			{0, kLETTER, 0x0ff47 },
			{0, kLETTER, 0x0ff48 },
			{0, kLETTER, 0x0ff49 },
			{0, kLETTER, 0x0ff4a },
			{0, kLETTER, 0x0ff4b },
			{0, kLETTER, 0x0ff4c },
			{0, kLETTER, 0x0ff4d },
			{0, kLETTER, 0x0ff4e },
			{0, kLETTER, 0x0ff4f },
			{0, kLETTER, 0x0ff50 },
			{0, kLETTER, 0x0ff51 },
			{0, kLETTER, 0x0ff52 },
			{0, kLETTER, 0x0ff53 },
			{0, kLETTER, 0x0ff54 },
			{0, kLETTER, 0x0ff55 },
			{0, kLETTER, 0x0ff56 },
			{0, kLETTER, 0x0ff57 },
			{0, kLETTER, 0x0ff58 },
			{0, kLETTER, 0x0ff59 },
			{0, kLETTER, 0x0ff5a },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 65
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 66
		{
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 67
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 68
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 69
		{
			{0, kLETTER, 0x10428 },
			{0, kLETTER, 0x10429 },
			{0, kLETTER, 0x1042a },
			{0, kLETTER, 0x1042b },
			{0, kLETTER, 0x1042c },
			{0, kLETTER, 0x1042d },
			{0, kLETTER, 0x1042e },
			{0, kLETTER, 0x1042f },
			{0, kLETTER, 0x10430 },
			{0, kLETTER, 0x10431 },
			{0, kLETTER, 0x10432 },
			{0, kLETTER, 0x10433 },
			{0, kLETTER, 0x10434 },
			{0, kLETTER, 0x10435 },
			{0, kLETTER, 0x10436 },
			{0, kLETTER, 0x10437 },
			{0, kLETTER, 0x10438 },
			{0, kLETTER, 0x10439 },
			{0, kLETTER, 0x1043a },
			{0, kLETTER, 0x1043b },
			{0, kLETTER, 0x1043c },
			{0, kLETTER, 0x1043d },
			{0, kLETTER, 0x1043e },
			{0, kLETTER, 0x1043f },
			{0, kLETTER, 0x10440 },
			{0, kLETTER, 0x10441 },
			{0, kLETTER, 0x10442 },
			{0, kLETTER, 0x10443 },
			{0, kLETTER, 0x10444 },
			{0, kLETTER, 0x10445 },
			{0, kLETTER, 0x10446 },
			{0, kLETTER, 0x10447 },
			{0, kLETTER, 0x10448 },
			{0, kLETTER, 0x10449 },
			{0, kLETTER, 0x1044a },
			{0, kLETTER, 0x1044b },
			{0, kLETTER, 0x1044c },
			{0, kLETTER, 0x1044d },
			{0, kLETTER, 0x1044e },
			{0, kLETTER, 0x1044f },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 70
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 71
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 72
		{
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 73
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 74
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 75
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 76
		{
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 77
		{
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 78
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{9, kCOMBININGMARK, 0x00000 },
			{7, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 79
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 80
		{
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kPUNCTUATION, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 81
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 82
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 83
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 84
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 85
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 86
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{1, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{226, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{216, kCOMBININGMARK, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{220, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 87
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{230, kCOMBININGMARK, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 88
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 89
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 90
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 91
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
		},
// page 92
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
		},
// page 93
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 94
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 95
		{
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kNUMBER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 96
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 97
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 98
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 99
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
		},
// page 100
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 101
		{
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kSYMBOL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 102
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 103
		{
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 104
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 105
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 106
		{
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kLETTER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 107
		{
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 108
		{
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kCOMBININGMARK, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},
// page 109
		{
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kCONTROL, 0x00000 },
			{0, kOTHER, 0x00000 },
			{0, kOTHER, 0x00000 },
		},

	}
};

typedef uint16				M6NormalisedForm[2];
typedef M6NormalisedForm	M6NormalisedPage[256];

struct M6NormalisationInfo
{
	int16				page_index[4352];
	M6NormalisedPage	data[32];
} kM6NormalisationInfo = {
	{
		  0,  1,  2,  3,  4,  5,  6,  5,  5,  7,  8,  9, 10, 11,  5, 12,
		 13,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 14,  5,  5, 15, 16,
		 17, 18, 19, 20,  5,  5,  5,  5,  5,  5, 21,  5,  5,  5,  5,  5,
		 22,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5, 23, 24, 25,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		 26, 27,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5, 28,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5, 29, 30, 31,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
		  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
	},
	{
// page 0
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 65, 768 },
			 { 65, 769 },
			 { 65, 770 },
			 { 65, 771 },
			 { 65, 776 },
			 { 65, 778 },
			 { 0, 0 },
			 { 67, 807 },
			 { 69, 768 },
			 { 69, 769 },
			 { 69, 770 },
			 { 69, 776 },
			 { 73, 768 },
			 { 73, 769 },
			 { 73, 770 },
			 { 73, 776 },
			 { 0, 0 },
			 { 78, 771 },
			 { 79, 768 },
			 { 79, 769 },
			 { 79, 770 },
			 { 79, 771 },
			 { 79, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 85, 768 },
			 { 85, 769 },
			 { 85, 770 },
			 { 85, 776 },
			 { 89, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 97, 768 },
			 { 97, 769 },
			 { 97, 770 },
			 { 97, 771 },
			 { 97, 776 },
			 { 97, 778 },
			 { 0, 0 },
			 { 99, 807 },
			 { 101, 768 },
			 { 101, 769 },
			 { 101, 770 },
			 { 101, 776 },
			 { 105, 768 },
			 { 105, 769 },
			 { 105, 770 },
			 { 105, 776 },
			 { 0, 0 },
			 { 110, 771 },
			 { 111, 768 },
			 { 111, 769 },
			 { 111, 770 },
			 { 111, 771 },
			 { 111, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 117, 768 },
			 { 117, 769 },
			 { 117, 770 },
			 { 117, 776 },
			 { 121, 769 },
			 { 0, 0 },
			 { 121, 776 },
		},
// page 1
		{
			 { 65, 772 },
			 { 97, 772 },
			 { 65, 774 },
			 { 97, 774 },
			 { 65, 808 },
			 { 97, 808 },
			 { 67, 769 },
			 { 99, 769 },
			 { 67, 770 },
			 { 99, 770 },
			 { 67, 775 },
			 { 99, 775 },
			 { 67, 780 },
			 { 99, 780 },
			 { 68, 780 },
			 { 100, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 69, 772 },
			 { 101, 772 },
			 { 69, 774 },
			 { 101, 774 },
			 { 69, 775 },
			 { 101, 775 },
			 { 69, 808 },
			 { 101, 808 },
			 { 69, 780 },
			 { 101, 780 },
			 { 71, 770 },
			 { 103, 770 },
			 { 71, 774 },
			 { 103, 774 },
			 { 71, 775 },
			 { 103, 775 },
			 { 71, 807 },
			 { 103, 807 },
			 { 72, 770 },
			 { 104, 770 },
			 { 0, 0 },
			 { 0, 0 },
			 { 73, 771 },
			 { 105, 771 },
			 { 73, 772 },
			 { 105, 772 },
			 { 73, 774 },
			 { 105, 774 },
			 { 73, 808 },
			 { 105, 808 },
			 { 73, 775 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 74, 770 },
			 { 106, 770 },
			 { 75, 807 },
			 { 107, 807 },
			 { 0, 0 },
			 { 76, 769 },
			 { 108, 769 },
			 { 76, 807 },
			 { 108, 807 },
			 { 76, 780 },
			 { 108, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 78, 769 },
			 { 110, 769 },
			 { 78, 807 },
			 { 110, 807 },
			 { 78, 780 },
			 { 110, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 79, 772 },
			 { 111, 772 },
			 { 79, 774 },
			 { 111, 774 },
			 { 79, 779 },
			 { 111, 779 },
			 { 0, 0 },
			 { 0, 0 },
			 { 82, 769 },
			 { 114, 769 },
			 { 82, 807 },
			 { 114, 807 },
			 { 82, 780 },
			 { 114, 780 },
			 { 83, 769 },
			 { 115, 769 },
			 { 83, 770 },
			 { 115, 770 },
			 { 83, 807 },
			 { 115, 807 },
			 { 83, 780 },
			 { 115, 780 },
			 { 84, 807 },
			 { 116, 807 },
			 { 84, 780 },
			 { 116, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 85, 771 },
			 { 117, 771 },
			 { 85, 772 },
			 { 117, 772 },
			 { 85, 774 },
			 { 117, 774 },
			 { 85, 778 },
			 { 117, 778 },
			 { 85, 779 },
			 { 117, 779 },
			 { 85, 808 },
			 { 117, 808 },
			 { 87, 770 },
			 { 119, 770 },
			 { 89, 770 },
			 { 121, 770 },
			 { 89, 776 },
			 { 90, 769 },
			 { 122, 769 },
			 { 90, 775 },
			 { 122, 775 },
			 { 90, 780 },
			 { 122, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 79, 795 },
			 { 111, 795 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 85, 795 },
			 { 117, 795 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 65, 780 },
			 { 97, 780 },
			 { 73, 780 },
			 { 105, 780 },
			 { 79, 780 },
			 { 111, 780 },
			 { 85, 780 },
			 { 117, 780 },
			 { 220, 772 },
			 { 252, 772 },
			 { 220, 769 },
			 { 252, 769 },
			 { 220, 780 },
			 { 252, 780 },
			 { 220, 768 },
			 { 252, 768 },
			 { 0, 0 },
			 { 196, 772 },
			 { 228, 772 },
			 { 550, 772 },
			 { 551, 772 },
			 { 198, 772 },
			 { 230, 772 },
			 { 0, 0 },
			 { 0, 0 },
			 { 71, 780 },
			 { 103, 780 },
			 { 75, 780 },
			 { 107, 780 },
			 { 79, 808 },
			 { 111, 808 },
			 { 490, 772 },
			 { 491, 772 },
			 { 439, 780 },
			 { 658, 780 },
			 { 106, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 71, 769 },
			 { 103, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 78, 768 },
			 { 110, 768 },
			 { 197, 769 },
			 { 229, 769 },
			 { 198, 769 },
			 { 230, 769 },
			 { 216, 769 },
			 { 248, 769 },
		},
// page 2
		{
			 { 65, 783 },
			 { 97, 783 },
			 { 65, 785 },
			 { 97, 785 },
			 { 69, 783 },
			 { 101, 783 },
			 { 69, 785 },
			 { 101, 785 },
			 { 73, 783 },
			 { 105, 783 },
			 { 73, 785 },
			 { 105, 785 },
			 { 79, 783 },
			 { 111, 783 },
			 { 79, 785 },
			 { 111, 785 },
			 { 82, 783 },
			 { 114, 783 },
			 { 82, 785 },
			 { 114, 785 },
			 { 85, 783 },
			 { 117, 783 },
			 { 85, 785 },
			 { 117, 785 },
			 { 83, 806 },
			 { 115, 806 },
			 { 84, 806 },
			 { 116, 806 },
			 { 0, 0 },
			 { 0, 0 },
			 { 72, 780 },
			 { 104, 780 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 65, 775 },
			 { 97, 775 },
			 { 69, 807 },
			 { 101, 807 },
			 { 214, 772 },
			 { 246, 772 },
			 { 213, 772 },
			 { 245, 772 },
			 { 79, 775 },
			 { 111, 775 },
			 { 558, 772 },
			 { 559, 772 },
			 { 89, 772 },
			 { 121, 772 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 3
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 768, 0 },
			 { 769, 0 },
			 { 0, 0 },
			 { 787, 0 },
			 { 776, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 697, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 59, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 168, 769 },
			 { 913, 769 },
			 { 183, 0 },
			 { 917, 769 },
			 { 919, 769 },
			 { 921, 769 },
			 { 0, 0 },
			 { 927, 769 },
			 { 0, 0 },
			 { 933, 769 },
			 { 937, 769 },
			 { 970, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 921, 776 },
			 { 933, 776 },
			 { 945, 769 },
			 { 949, 769 },
			 { 951, 769 },
			 { 953, 769 },
			 { 971, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 953, 776 },
			 { 965, 776 },
			 { 959, 769 },
			 { 965, 769 },
			 { 969, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 978, 769 },
			 { 978, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 4
		{
			 { 1045, 768 },
			 { 1045, 776 },
			 { 0, 0 },
			 { 1043, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1030, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1050, 769 },
			 { 1048, 768 },
			 { 1059, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1048, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1080, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1077, 768 },
			 { 1077, 776 },
			 { 0, 0 },
			 { 1075, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1110, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1082, 769 },
			 { 1080, 768 },
			 { 1091, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1140, 783 },
			 { 1141, 783 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1046, 774 },
			 { 1078, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1040, 774 },
			 { 1072, 774 },
			 { 1040, 776 },
			 { 1072, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1045, 774 },
			 { 1077, 774 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1240, 776 },
			 { 1241, 776 },
			 { 1046, 776 },
			 { 1078, 776 },
			 { 1047, 776 },
			 { 1079, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1048, 772 },
			 { 1080, 772 },
			 { 1048, 776 },
			 { 1080, 776 },
			 { 1054, 776 },
			 { 1086, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1256, 776 },
			 { 1257, 776 },
			 { 1069, 776 },
			 { 1101, 776 },
			 { 1059, 772 },
			 { 1091, 772 },
			 { 1059, 776 },
			 { 1091, 776 },
			 { 1059, 779 },
			 { 1091, 779 },
			 { 1063, 776 },
			 { 1095, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1067, 776 },
			 { 1099, 776 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 5
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 6
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1575, 1619 },
			 { 1575, 1620 },
			 { 1608, 1620 },
			 { 1575, 1621 },
			 { 1610, 1620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1749, 1620 },
			 { 0, 0 },
			 { 1729, 1620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1746, 1620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 7
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2344, 2364 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2352, 2364 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2355, 2364 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2325, 2364 },
			 { 2326, 2364 },
			 { 2327, 2364 },
			 { 2332, 2364 },
			 { 2337, 2364 },
			 { 2338, 2364 },
			 { 2347, 2364 },
			 { 2351, 2364 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2503, 2494 },
			 { 2503, 2519 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2465, 2492 },
			 { 2466, 2492 },
			 { 0, 0 },
			 { 2479, 2492 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 8
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2610, 2620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2616, 2620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2582, 2620 },
			 { 2583, 2620 },
			 { 2588, 2620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2603, 2620 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 9
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2887, 2902 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2887, 2878 },
			 { 2887, 2903 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2849, 2876 },
			 { 2850, 2876 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 2962, 3031 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3014, 3006 },
			 { 3015, 3006 },
			 { 3014, 3031 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 10
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3142, 3158 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3263, 3285 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3270, 3285 },
			 { 3270, 3286 },
			 { 0, 0 },
			 { 3270, 3266 },
			 { 3274, 3285 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 11
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3398, 3390 },
			 { 3399, 3390 },
			 { 3398, 3415 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3545, 3530 },
			 { 0, 0 },
			 { 3545, 3535 },
			 { 3548, 3530 },
			 { 3545, 3551 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 12
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3906, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3916, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3921, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3926, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3931, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3904, 4021 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3953, 3954 },
			 { 0, 0 },
			 { 3953, 3956 },
			 { 4018, 3968 },
			 { 0, 0 },
			 { 4019, 3968 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3953, 3968 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3986, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3996, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4001, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4006, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4011, 4023 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 3984, 4021 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 13
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4133, 4142 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 14
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 6917, 6965 },
			 { 0, 0 },
			 { 6919, 6965 },
			 { 0, 0 },
			 { 6921, 6965 },
			 { 0, 0 },
			 { 6923, 6965 },
			 { 0, 0 },
			 { 6925, 6965 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 6929, 6965 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 6970, 6965 },
			 { 0, 0 },
			 { 6972, 6965 },
			 { 0, 0 },
			 { 0, 0 },
			 { 6974, 6965 },
			 { 6975, 6965 },
			 { 0, 0 },
			 { 6978, 6965 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 15
		{
			 { 65, 805 },
			 { 97, 805 },
			 { 66, 775 },
			 { 98, 775 },
			 { 66, 803 },
			 { 98, 803 },
			 { 66, 817 },
			 { 98, 817 },
			 { 199, 769 },
			 { 231, 769 },
			 { 68, 775 },
			 { 100, 775 },
			 { 68, 803 },
			 { 100, 803 },
			 { 68, 817 },
			 { 100, 817 },
			 { 68, 807 },
			 { 100, 807 },
			 { 68, 813 },
			 { 100, 813 },
			 { 274, 768 },
			 { 275, 768 },
			 { 274, 769 },
			 { 275, 769 },
			 { 69, 813 },
			 { 101, 813 },
			 { 69, 816 },
			 { 101, 816 },
			 { 552, 774 },
			 { 553, 774 },
			 { 70, 775 },
			 { 102, 775 },
			 { 71, 772 },
			 { 103, 772 },
			 { 72, 775 },
			 { 104, 775 },
			 { 72, 803 },
			 { 104, 803 },
			 { 72, 776 },
			 { 104, 776 },
			 { 72, 807 },
			 { 104, 807 },
			 { 72, 814 },
			 { 104, 814 },
			 { 73, 816 },
			 { 105, 816 },
			 { 207, 769 },
			 { 239, 769 },
			 { 75, 769 },
			 { 107, 769 },
			 { 75, 803 },
			 { 107, 803 },
			 { 75, 817 },
			 { 107, 817 },
			 { 76, 803 },
			 { 108, 803 },
			 { 7734, 772 },
			 { 7735, 772 },
			 { 76, 817 },
			 { 108, 817 },
			 { 76, 813 },
			 { 108, 813 },
			 { 77, 769 },
			 { 109, 769 },
			 { 77, 775 },
			 { 109, 775 },
			 { 77, 803 },
			 { 109, 803 },
			 { 78, 775 },
			 { 110, 775 },
			 { 78, 803 },
			 { 110, 803 },
			 { 78, 817 },
			 { 110, 817 },
			 { 78, 813 },
			 { 110, 813 },
			 { 213, 769 },
			 { 245, 769 },
			 { 213, 776 },
			 { 245, 776 },
			 { 332, 768 },
			 { 333, 768 },
			 { 332, 769 },
			 { 333, 769 },
			 { 80, 769 },
			 { 112, 769 },
			 { 80, 775 },
			 { 112, 775 },
			 { 82, 775 },
			 { 114, 775 },
			 { 82, 803 },
			 { 114, 803 },
			 { 7770, 772 },
			 { 7771, 772 },
			 { 82, 817 },
			 { 114, 817 },
			 { 83, 775 },
			 { 115, 775 },
			 { 83, 803 },
			 { 115, 803 },
			 { 346, 775 },
			 { 347, 775 },
			 { 352, 775 },
			 { 353, 775 },
			 { 7778, 775 },
			 { 7779, 775 },
			 { 84, 775 },
			 { 116, 775 },
			 { 84, 803 },
			 { 116, 803 },
			 { 84, 817 },
			 { 116, 817 },
			 { 84, 813 },
			 { 116, 813 },
			 { 85, 804 },
			 { 117, 804 },
			 { 85, 816 },
			 { 117, 816 },
			 { 85, 813 },
			 { 117, 813 },
			 { 360, 769 },
			 { 361, 769 },
			 { 362, 776 },
			 { 363, 776 },
			 { 86, 771 },
			 { 118, 771 },
			 { 86, 803 },
			 { 118, 803 },
			 { 87, 768 },
			 { 119, 768 },
			 { 87, 769 },
			 { 119, 769 },
			 { 87, 776 },
			 { 119, 776 },
			 { 87, 775 },
			 { 119, 775 },
			 { 87, 803 },
			 { 119, 803 },
			 { 88, 775 },
			 { 120, 775 },
			 { 88, 776 },
			 { 120, 776 },
			 { 89, 775 },
			 { 121, 775 },
			 { 90, 770 },
			 { 122, 770 },
			 { 90, 803 },
			 { 122, 803 },
			 { 90, 817 },
			 { 122, 817 },
			 { 104, 817 },
			 { 116, 776 },
			 { 119, 778 },
			 { 121, 778 },
			 { 0, 0 },
			 { 383, 775 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 65, 803 },
			 { 97, 803 },
			 { 65, 777 },
			 { 97, 777 },
			 { 194, 769 },
			 { 226, 769 },
			 { 194, 768 },
			 { 226, 768 },
			 { 194, 777 },
			 { 226, 777 },
			 { 194, 771 },
			 { 226, 771 },
			 { 7840, 770 },
			 { 7841, 770 },
			 { 258, 769 },
			 { 259, 769 },
			 { 258, 768 },
			 { 259, 768 },
			 { 258, 777 },
			 { 259, 777 },
			 { 258, 771 },
			 { 259, 771 },
			 { 7840, 774 },
			 { 7841, 774 },
			 { 69, 803 },
			 { 101, 803 },
			 { 69, 777 },
			 { 101, 777 },
			 { 69, 771 },
			 { 101, 771 },
			 { 202, 769 },
			 { 234, 769 },
			 { 202, 768 },
			 { 234, 768 },
			 { 202, 777 },
			 { 234, 777 },
			 { 202, 771 },
			 { 234, 771 },
			 { 7864, 770 },
			 { 7865, 770 },
			 { 73, 777 },
			 { 105, 777 },
			 { 73, 803 },
			 { 105, 803 },
			 { 79, 803 },
			 { 111, 803 },
			 { 79, 777 },
			 { 111, 777 },
			 { 212, 769 },
			 { 244, 769 },
			 { 212, 768 },
			 { 244, 768 },
			 { 212, 777 },
			 { 244, 777 },
			 { 212, 771 },
			 { 244, 771 },
			 { 7884, 770 },
			 { 7885, 770 },
			 { 416, 769 },
			 { 417, 769 },
			 { 416, 768 },
			 { 417, 768 },
			 { 416, 777 },
			 { 417, 777 },
			 { 416, 771 },
			 { 417, 771 },
			 { 416, 803 },
			 { 417, 803 },
			 { 85, 803 },
			 { 117, 803 },
			 { 85, 777 },
			 { 117, 777 },
			 { 431, 769 },
			 { 432, 769 },
			 { 431, 768 },
			 { 432, 768 },
			 { 431, 777 },
			 { 432, 777 },
			 { 431, 771 },
			 { 432, 771 },
			 { 431, 803 },
			 { 432, 803 },
			 { 89, 768 },
			 { 121, 768 },
			 { 89, 803 },
			 { 121, 803 },
			 { 89, 777 },
			 { 121, 777 },
			 { 89, 771 },
			 { 121, 771 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 16
		{
			 { 945, 787 },
			 { 945, 788 },
			 { 7936, 768 },
			 { 7937, 768 },
			 { 7936, 769 },
			 { 7937, 769 },
			 { 7936, 834 },
			 { 7937, 834 },
			 { 913, 787 },
			 { 913, 788 },
			 { 7944, 768 },
			 { 7945, 768 },
			 { 7944, 769 },
			 { 7945, 769 },
			 { 7944, 834 },
			 { 7945, 834 },
			 { 949, 787 },
			 { 949, 788 },
			 { 7952, 768 },
			 { 7953, 768 },
			 { 7952, 769 },
			 { 7953, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 917, 787 },
			 { 917, 788 },
			 { 7960, 768 },
			 { 7961, 768 },
			 { 7960, 769 },
			 { 7961, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 951, 787 },
			 { 951, 788 },
			 { 7968, 768 },
			 { 7969, 768 },
			 { 7968, 769 },
			 { 7969, 769 },
			 { 7968, 834 },
			 { 7969, 834 },
			 { 919, 787 },
			 { 919, 788 },
			 { 7976, 768 },
			 { 7977, 768 },
			 { 7976, 769 },
			 { 7977, 769 },
			 { 7976, 834 },
			 { 7977, 834 },
			 { 953, 787 },
			 { 953, 788 },
			 { 7984, 768 },
			 { 7985, 768 },
			 { 7984, 769 },
			 { 7985, 769 },
			 { 7984, 834 },
			 { 7985, 834 },
			 { 921, 787 },
			 { 921, 788 },
			 { 7992, 768 },
			 { 7993, 768 },
			 { 7992, 769 },
			 { 7993, 769 },
			 { 7992, 834 },
			 { 7993, 834 },
			 { 959, 787 },
			 { 959, 788 },
			 { 8000, 768 },
			 { 8001, 768 },
			 { 8000, 769 },
			 { 8001, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 927, 787 },
			 { 927, 788 },
			 { 8008, 768 },
			 { 8009, 768 },
			 { 8008, 769 },
			 { 8009, 769 },
			 { 0, 0 },
			 { 0, 0 },
			 { 965, 787 },
			 { 965, 788 },
			 { 8016, 768 },
			 { 8017, 768 },
			 { 8016, 769 },
			 { 8017, 769 },
			 { 8016, 834 },
			 { 8017, 834 },
			 { 0, 0 },
			 { 933, 788 },
			 { 0, 0 },
			 { 8025, 768 },
			 { 0, 0 },
			 { 8025, 769 },
			 { 0, 0 },
			 { 8025, 834 },
			 { 969, 787 },
			 { 969, 788 },
			 { 8032, 768 },
			 { 8033, 768 },
			 { 8032, 769 },
			 { 8033, 769 },
			 { 8032, 834 },
			 { 8033, 834 },
			 { 937, 787 },
			 { 937, 788 },
			 { 8040, 768 },
			 { 8041, 768 },
			 { 8040, 769 },
			 { 8041, 769 },
			 { 8040, 834 },
			 { 8041, 834 },
			 { 945, 768 },
			 { 940, 0 },
			 { 949, 768 },
			 { 941, 0 },
			 { 951, 768 },
			 { 942, 0 },
			 { 953, 768 },
			 { 943, 0 },
			 { 959, 768 },
			 { 972, 0 },
			 { 965, 768 },
			 { 973, 0 },
			 { 969, 768 },
			 { 974, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 7936, 837 },
			 { 7937, 837 },
			 { 7938, 837 },
			 { 7939, 837 },
			 { 7940, 837 },
			 { 7941, 837 },
			 { 7942, 837 },
			 { 7943, 837 },
			 { 7944, 837 },
			 { 7945, 837 },
			 { 7946, 837 },
			 { 7947, 837 },
			 { 7948, 837 },
			 { 7949, 837 },
			 { 7950, 837 },
			 { 7951, 837 },
			 { 7968, 837 },
			 { 7969, 837 },
			 { 7970, 837 },
			 { 7971, 837 },
			 { 7972, 837 },
			 { 7973, 837 },
			 { 7974, 837 },
			 { 7975, 837 },
			 { 7976, 837 },
			 { 7977, 837 },
			 { 7978, 837 },
			 { 7979, 837 },
			 { 7980, 837 },
			 { 7981, 837 },
			 { 7982, 837 },
			 { 7983, 837 },
			 { 8032, 837 },
			 { 8033, 837 },
			 { 8034, 837 },
			 { 8035, 837 },
			 { 8036, 837 },
			 { 8037, 837 },
			 { 8038, 837 },
			 { 8039, 837 },
			 { 8040, 837 },
			 { 8041, 837 },
			 { 8042, 837 },
			 { 8043, 837 },
			 { 8044, 837 },
			 { 8045, 837 },
			 { 8046, 837 },
			 { 8047, 837 },
			 { 945, 774 },
			 { 945, 772 },
			 { 8048, 837 },
			 { 945, 837 },
			 { 940, 837 },
			 { 0, 0 },
			 { 945, 834 },
			 { 8118, 837 },
			 { 913, 774 },
			 { 913, 772 },
			 { 913, 768 },
			 { 902, 0 },
			 { 913, 837 },
			 { 0, 0 },
			 { 953, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 168, 834 },
			 { 8052, 837 },
			 { 951, 837 },
			 { 942, 837 },
			 { 0, 0 },
			 { 951, 834 },
			 { 8134, 837 },
			 { 917, 768 },
			 { 904, 0 },
			 { 919, 768 },
			 { 905, 0 },
			 { 919, 837 },
			 { 8127, 768 },
			 { 8127, 769 },
			 { 8127, 834 },
			 { 953, 774 },
			 { 953, 772 },
			 { 970, 768 },
			 { 912, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 953, 834 },
			 { 970, 834 },
			 { 921, 774 },
			 { 921, 772 },
			 { 921, 768 },
			 { 906, 0 },
			 { 0, 0 },
			 { 8190, 768 },
			 { 8190, 769 },
			 { 8190, 834 },
			 { 965, 774 },
			 { 965, 772 },
			 { 971, 768 },
			 { 944, 0 },
			 { 961, 787 },
			 { 961, 788 },
			 { 965, 834 },
			 { 971, 834 },
			 { 933, 774 },
			 { 933, 772 },
			 { 933, 768 },
			 { 910, 0 },
			 { 929, 788 },
			 { 168, 768 },
			 { 901, 0 },
			 { 96, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8060, 837 },
			 { 969, 837 },
			 { 974, 837 },
			 { 0, 0 },
			 { 969, 834 },
			 { 8182, 837 },
			 { 927, 768 },
			 { 908, 0 },
			 { 937, 768 },
			 { 911, 0 },
			 { 937, 837 },
			 { 180, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 17
		{
			 { 8194, 0 },
			 { 8195, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 18
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 937, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 75, 0 },
			 { 197, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8592, 824 },
			 { 8594, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8596, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8656, 824 },
			 { 8660, 824 },
			 { 8658, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 19
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8707, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8712, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8715, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8739, 824 },
			 { 0, 0 },
			 { 8741, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8764, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8771, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8773, 824 },
			 { 0, 0 },
			 { 8776, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 61, 824 },
			 { 0, 0 },
			 { 8801, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8781, 824 },
			 { 60, 824 },
			 { 62, 824 },
			 { 8804, 824 },
			 { 8805, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8818, 824 },
			 { 8819, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8822, 824 },
			 { 8823, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8826, 824 },
			 { 8827, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8834, 824 },
			 { 8835, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8838, 824 },
			 { 8839, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8866, 824 },
			 { 8872, 824 },
			 { 8873, 824 },
			 { 8875, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8828, 824 },
			 { 8829, 824 },
			 { 8849, 824 },
			 { 8850, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 8882, 824 },
			 { 8883, 824 },
			 { 8884, 824 },
			 { 8885, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 20
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12296, 0 },
			 { 12297, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 21
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 10973, 824 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 22
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12363, 12441 },
			 { 0, 0 },
			 { 12365, 12441 },
			 { 0, 0 },
			 { 12367, 12441 },
			 { 0, 0 },
			 { 12369, 12441 },
			 { 0, 0 },
			 { 12371, 12441 },
			 { 0, 0 },
			 { 12373, 12441 },
			 { 0, 0 },
			 { 12375, 12441 },
			 { 0, 0 },
			 { 12377, 12441 },
			 { 0, 0 },
			 { 12379, 12441 },
			 { 0, 0 },
			 { 12381, 12441 },
			 { 0, 0 },
			 { 12383, 12441 },
			 { 0, 0 },
			 { 12385, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12388, 12441 },
			 { 0, 0 },
			 { 12390, 12441 },
			 { 0, 0 },
			 { 12392, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12399, 12441 },
			 { 12399, 12442 },
			 { 0, 0 },
			 { 12402, 12441 },
			 { 12402, 12442 },
			 { 0, 0 },
			 { 12405, 12441 },
			 { 12405, 12442 },
			 { 0, 0 },
			 { 12408, 12441 },
			 { 12408, 12442 },
			 { 0, 0 },
			 { 12411, 12441 },
			 { 12411, 12442 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12358, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12445, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12459, 12441 },
			 { 0, 0 },
			 { 12461, 12441 },
			 { 0, 0 },
			 { 12463, 12441 },
			 { 0, 0 },
			 { 12465, 12441 },
			 { 0, 0 },
			 { 12467, 12441 },
			 { 0, 0 },
			 { 12469, 12441 },
			 { 0, 0 },
			 { 12471, 12441 },
			 { 0, 0 },
			 { 12473, 12441 },
			 { 0, 0 },
			 { 12475, 12441 },
			 { 0, 0 },
			 { 12477, 12441 },
			 { 0, 0 },
			 { 12479, 12441 },
			 { 0, 0 },
			 { 12481, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12484, 12441 },
			 { 0, 0 },
			 { 12486, 12441 },
			 { 0, 0 },
			 { 12488, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12495, 12441 },
			 { 12495, 12442 },
			 { 0, 0 },
			 { 12498, 12441 },
			 { 12498, 12442 },
			 { 0, 0 },
			 { 12501, 12441 },
			 { 12501, 12442 },
			 { 0, 0 },
			 { 12504, 12441 },
			 { 12504, 12442 },
			 { 0, 0 },
			 { 12507, 12441 },
			 { 12507, 12442 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12454, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12527, 12441 },
			 { 12528, 12441 },
			 { 12529, 12441 },
			 { 12530, 12441 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 12541, 12441 },
			 { 0, 0 },
		},
// page 23
		{
			 { 35912, 0 },
			 { 26356, 0 },
			 { 36554, 0 },
			 { 36040, 0 },
			 { 28369, 0 },
			 { 20018, 0 },
			 { 21477, 0 },
			 { 40860, 0 },
			 { 40860, 0 },
			 { 22865, 0 },
			 { 37329, 0 },
			 { 21895, 0 },
			 { 22856, 0 },
			 { 25078, 0 },
			 { 30313, 0 },
			 { 32645, 0 },
			 { 34367, 0 },
			 { 34746, 0 },
			 { 35064, 0 },
			 { 37007, 0 },
			 { 27138, 0 },
			 { 27931, 0 },
			 { 28889, 0 },
			 { 29662, 0 },
			 { 33853, 0 },
			 { 37226, 0 },
			 { 39409, 0 },
			 { 20098, 0 },
			 { 21365, 0 },
			 { 27396, 0 },
			 { 29211, 0 },
			 { 34349, 0 },
			 { 40478, 0 },
			 { 23888, 0 },
			 { 28651, 0 },
			 { 34253, 0 },
			 { 35172, 0 },
			 { 25289, 0 },
			 { 33240, 0 },
			 { 34847, 0 },
			 { 24266, 0 },
			 { 26391, 0 },
			 { 28010, 0 },
			 { 29436, 0 },
			 { 37070, 0 },
			 { 20358, 0 },
			 { 20919, 0 },
			 { 21214, 0 },
			 { 25796, 0 },
			 { 27347, 0 },
			 { 29200, 0 },
			 { 30439, 0 },
			 { 32769, 0 },
			 { 34310, 0 },
			 { 34396, 0 },
			 { 36335, 0 },
			 { 38706, 0 },
			 { 39791, 0 },
			 { 40442, 0 },
			 { 30860, 0 },
			 { 31103, 0 },
			 { 32160, 0 },
			 { 33737, 0 },
			 { 37636, 0 },
			 { 40575, 0 },
			 { 35542, 0 },
			 { 22751, 0 },
			 { 24324, 0 },
			 { 31840, 0 },
			 { 32894, 0 },
			 { 29282, 0 },
			 { 30922, 0 },
			 { 36034, 0 },
			 { 38647, 0 },
			 { 22744, 0 },
			 { 23650, 0 },
			 { 27155, 0 },
			 { 28122, 0 },
			 { 28431, 0 },
			 { 32047, 0 },
			 { 32311, 0 },
			 { 38475, 0 },
			 { 21202, 0 },
			 { 32907, 0 },
			 { 20956, 0 },
			 { 20940, 0 },
			 { 31260, 0 },
			 { 32190, 0 },
			 { 33777, 0 },
			 { 38517, 0 },
			 { 35712, 0 },
			 { 25295, 0 },
			 { 27138, 0 },
			 { 35582, 0 },
			 { 20025, 0 },
			 { 23527, 0 },
			 { 24594, 0 },
			 { 29575, 0 },
			 { 30064, 0 },
			 { 21271, 0 },
			 { 30971, 0 },
			 { 20415, 0 },
			 { 24489, 0 },
			 { 19981, 0 },
			 { 27852, 0 },
			 { 25976, 0 },
			 { 32034, 0 },
			 { 21443, 0 },
			 { 22622, 0 },
			 { 30465, 0 },
			 { 33865, 0 },
			 { 35498, 0 },
			 { 27578, 0 },
			 { 36784, 0 },
			 { 27784, 0 },
			 { 25342, 0 },
			 { 33509, 0 },
			 { 25504, 0 },
			 { 30053, 0 },
			 { 20142, 0 },
			 { 20841, 0 },
			 { 20937, 0 },
			 { 26753, 0 },
			 { 31975, 0 },
			 { 33391, 0 },
			 { 35538, 0 },
			 { 37327, 0 },
			 { 21237, 0 },
			 { 21570, 0 },
			 { 22899, 0 },
			 { 24300, 0 },
			 { 26053, 0 },
			 { 28670, 0 },
			 { 31018, 0 },
			 { 38317, 0 },
			 { 39530, 0 },
			 { 40599, 0 },
			 { 40654, 0 },
			 { 21147, 0 },
			 { 26310, 0 },
			 { 27511, 0 },
			 { 36706, 0 },
			 { 24180, 0 },
			 { 24976, 0 },
			 { 25088, 0 },
			 { 25754, 0 },
			 { 28451, 0 },
			 { 29001, 0 },
			 { 29833, 0 },
			 { 31178, 0 },
			 { 32244, 0 },
			 { 32879, 0 },
			 { 36646, 0 },
			 { 34030, 0 },
			 { 36899, 0 },
			 { 37706, 0 },
			 { 21015, 0 },
			 { 21155, 0 },
			 { 21693, 0 },
			 { 28872, 0 },
			 { 35010, 0 },
			 { 35498, 0 },
			 { 24265, 0 },
			 { 24565, 0 },
			 { 25467, 0 },
			 { 27566, 0 },
			 { 31806, 0 },
			 { 29557, 0 },
			 { 20196, 0 },
			 { 22265, 0 },
			 { 23527, 0 },
			 { 23994, 0 },
			 { 24604, 0 },
			 { 29618, 0 },
			 { 29801, 0 },
			 { 32666, 0 },
			 { 32838, 0 },
			 { 37428, 0 },
			 { 38646, 0 },
			 { 38728, 0 },
			 { 38936, 0 },
			 { 20363, 0 },
			 { 31150, 0 },
			 { 37300, 0 },
			 { 38584, 0 },
			 { 24801, 0 },
			 { 20102, 0 },
			 { 20698, 0 },
			 { 23534, 0 },
			 { 23615, 0 },
			 { 26009, 0 },
			 { 27138, 0 },
			 { 29134, 0 },
			 { 30274, 0 },
			 { 34044, 0 },
			 { 36988, 0 },
			 { 40845, 0 },
			 { 26248, 0 },
			 { 38446, 0 },
			 { 21129, 0 },
			 { 26491, 0 },
			 { 26611, 0 },
			 { 27969, 0 },
			 { 28316, 0 },
			 { 29705, 0 },
			 { 30041, 0 },
			 { 30827, 0 },
			 { 32016, 0 },
			 { 39006, 0 },
			 { 20845, 0 },
			 { 25134, 0 },
			 { 38520, 0 },
			 { 20523, 0 },
			 { 23833, 0 },
			 { 28138, 0 },
			 { 36650, 0 },
			 { 24459, 0 },
			 { 24900, 0 },
			 { 26647, 0 },
			 { 29575, 0 },
			 { 38534, 0 },
			 { 21033, 0 },
			 { 21519, 0 },
			 { 23653, 0 },
			 { 26131, 0 },
			 { 26446, 0 },
			 { 26792, 0 },
			 { 27877, 0 },
			 { 29702, 0 },
			 { 30178, 0 },
			 { 32633, 0 },
			 { 35023, 0 },
			 { 35041, 0 },
			 { 37324, 0 },
			 { 38626, 0 },
			 { 21311, 0 },
			 { 28346, 0 },
			 { 21533, 0 },
			 { 29136, 0 },
			 { 29848, 0 },
			 { 34298, 0 },
			 { 38563, 0 },
			 { 40023, 0 },
			 { 40607, 0 },
			 { 26519, 0 },
			 { 28107, 0 },
			 { 33256, 0 },
			 { 31435, 0 },
			 { 31520, 0 },
			 { 31890, 0 },
			 { 29376, 0 },
			 { 28825, 0 },
			 { 35672, 0 },
			 { 20160, 0 },
			 { 33590, 0 },
			 { 21050, 0 },
		},
// page 24
		{
			 { 20999, 0 },
			 { 24230, 0 },
			 { 25299, 0 },
			 { 31958, 0 },
			 { 23429, 0 },
			 { 27934, 0 },
			 { 26292, 0 },
			 { 36667, 0 },
			 { 34892, 0 },
			 { 38477, 0 },
			 { 35211, 0 },
			 { 24275, 0 },
			 { 20800, 0 },
			 { 21952, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 22618, 0 },
			 { 0, 0 },
			 { 26228, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 20958, 0 },
			 { 29482, 0 },
			 { 30410, 0 },
			 { 31036, 0 },
			 { 31070, 0 },
			 { 31077, 0 },
			 { 31119, 0 },
			 { 38742, 0 },
			 { 31934, 0 },
			 { 32701, 0 },
			 { 0, 0 },
			 { 34322, 0 },
			 { 0, 0 },
			 { 35576, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 36920, 0 },
			 { 37117, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 39151, 0 },
			 { 39164, 0 },
			 { 39208, 0 },
			 { 40372, 0 },
			 { 37086, 0 },
			 { 38583, 0 },
			 { 20398, 0 },
			 { 20711, 0 },
			 { 20813, 0 },
			 { 21193, 0 },
			 { 21220, 0 },
			 { 21329, 0 },
			 { 21917, 0 },
			 { 22022, 0 },
			 { 22120, 0 },
			 { 22592, 0 },
			 { 22696, 0 },
			 { 23652, 0 },
			 { 23662, 0 },
			 { 24724, 0 },
			 { 24936, 0 },
			 { 24974, 0 },
			 { 25074, 0 },
			 { 25935, 0 },
			 { 26082, 0 },
			 { 26257, 0 },
			 { 26757, 0 },
			 { 28023, 0 },
			 { 28186, 0 },
			 { 28450, 0 },
			 { 29038, 0 },
			 { 29227, 0 },
			 { 29730, 0 },
			 { 30865, 0 },
			 { 31038, 0 },
			 { 31049, 0 },
			 { 31048, 0 },
			 { 31056, 0 },
			 { 31062, 0 },
			 { 31069, 0 },
			 { 31117, 0 },
			 { 31118, 0 },
			 { 31296, 0 },
			 { 31361, 0 },
			 { 31680, 0 },
			 { 32244, 0 },
			 { 32265, 0 },
			 { 32321, 0 },
			 { 32626, 0 },
			 { 32773, 0 },
			 { 33261, 0 },
			 { 33401, 0 },
			 { 33401, 0 },
			 { 33879, 0 },
			 { 35088, 0 },
			 { 35222, 0 },
			 { 35585, 0 },
			 { 35641, 0 },
			 { 36051, 0 },
			 { 36104, 0 },
			 { 36790, 0 },
			 { 36920, 0 },
			 { 38627, 0 },
			 { 38911, 0 },
			 { 38971, 0 },
			 { 24693, 0 },
			 { 9262, 0 },
			 { 33304, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 20006, 0 },
			 { 20917, 0 },
			 { 20840, 0 },
			 { 20352, 0 },
			 { 20805, 0 },
			 { 20864, 0 },
			 { 21191, 0 },
			 { 21242, 0 },
			 { 21917, 0 },
			 { 21845, 0 },
			 { 21913, 0 },
			 { 21986, 0 },
			 { 22618, 0 },
			 { 22707, 0 },
			 { 22852, 0 },
			 { 22868, 0 },
			 { 23138, 0 },
			 { 23336, 0 },
			 { 24274, 0 },
			 { 24281, 0 },
			 { 24425, 0 },
			 { 24493, 0 },
			 { 24792, 0 },
			 { 24910, 0 },
			 { 24840, 0 },
			 { 24974, 0 },
			 { 24928, 0 },
			 { 25074, 0 },
			 { 25140, 0 },
			 { 25540, 0 },
			 { 25628, 0 },
			 { 25682, 0 },
			 { 25942, 0 },
			 { 26228, 0 },
			 { 26391, 0 },
			 { 26395, 0 },
			 { 26454, 0 },
			 { 27513, 0 },
			 { 27578, 0 },
			 { 27969, 0 },
			 { 28379, 0 },
			 { 28363, 0 },
			 { 28450, 0 },
			 { 28702, 0 },
			 { 29038, 0 },
			 { 30631, 0 },
			 { 29237, 0 },
			 { 29359, 0 },
			 { 29482, 0 },
			 { 29809, 0 },
			 { 29958, 0 },
			 { 30011, 0 },
			 { 30237, 0 },
			 { 30239, 0 },
			 { 30410, 0 },
			 { 30427, 0 },
			 { 30452, 0 },
			 { 30538, 0 },
			 { 30528, 0 },
			 { 30924, 0 },
			 { 31409, 0 },
			 { 31680, 0 },
			 { 31867, 0 },
			 { 32091, 0 },
			 { 32244, 0 },
			 { 32574, 0 },
			 { 32773, 0 },
			 { 33618, 0 },
			 { 33775, 0 },
			 { 34681, 0 },
			 { 35137, 0 },
			 { 35206, 0 },
			 { 35222, 0 },
			 { 35519, 0 },
			 { 35576, 0 },
			 { 35531, 0 },
			 { 35585, 0 },
			 { 35582, 0 },
			 { 35565, 0 },
			 { 35641, 0 },
			 { 35722, 0 },
			 { 36104, 0 },
			 { 36664, 0 },
			 { 36978, 0 },
			 { 37273, 0 },
			 { 37494, 0 },
			 { 38524, 0 },
			 { 38627, 0 },
			 { 38742, 0 },
			 { 38875, 0 },
			 { 38911, 0 },
			 { 38923, 0 },
			 { 38971, 0 },
			 { 39698, 0 },
			 { 40860, 0 },
			 { 8836, 0 },
			 { 8836, 0 },
			 { 9021, 0 },
			 { 15261, 0 },
			 { 16408, 0 },
			 { 16441, 0 },
			 { 9508, 0 },
			 { 9677, 0 },
			 { 10221, 0 },
			 { 40771, 0 },
			 { 40846, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 25
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1497, 1460 },
			 { 0, 0 },
			 { 1522, 1463 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 1513, 1473 },
			 { 1513, 1474 },
			 { 64329, 1473 },
			 { 64329, 1474 },
			 { 1488, 1463 },
			 { 1488, 1464 },
			 { 1488, 1468 },
			 { 1489, 1468 },
			 { 1490, 1468 },
			 { 1491, 1468 },
			 { 1492, 1468 },
			 { 1493, 1468 },
			 { 1494, 1468 },
			 { 0, 0 },
			 { 1496, 1468 },
			 { 1497, 1468 },
			 { 1498, 1468 },
			 { 1499, 1468 },
			 { 1500, 1468 },
			 { 0, 0 },
			 { 1502, 1468 },
			 { 0, 0 },
			 { 1504, 1468 },
			 { 1505, 1468 },
			 { 0, 0 },
			 { 1507, 1468 },
			 { 1508, 1468 },
			 { 0, 0 },
			 { 1510, 1468 },
			 { 1511, 1468 },
			 { 1512, 1468 },
			 { 1513, 1468 },
			 { 1514, 1468 },
			 { 1493, 1465 },
			 { 1489, 1471 },
			 { 1499, 1471 },
			 { 1508, 1471 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 26
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4361, 0 },
			 { 0, 0 },
			 { 4361, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4362, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 27
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 4371, 0 },
			 { 4371, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 28
		{
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 7445, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 7451, 0 },
			 { 7451, 0 },
			 { 7451, 0 },
			 { 7451, 0 },
			 { 7451, 0 },
			 { 7451, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},
// page 29
		{
			 { 20029, 0 },
			 { 20024, 0 },
			 { 20033, 0 },
			 { 8210, 0 },
			 { 20320, 0 },
			 { 20398, 0 },
			 { 20411, 0 },
			 { 20482, 0 },
			 { 20602, 0 },
			 { 20633, 0 },
			 { 20711, 0 },
			 { 20687, 0 },
			 { 13470, 0 },
			 { 8291, 0 },
			 { 20813, 0 },
			 { 20820, 0 },
			 { 20836, 0 },
			 { 20855, 0 },
			 { 8273, 0 },
			 { 13497, 0 },
			 { 20839, 0 },
			 { 20877, 0 },
			 { 8276, 0 },
			 { 20887, 0 },
			 { 20900, 0 },
			 { 20172, 0 },
			 { 20908, 0 },
			 { 20917, 0 },
			 { 10525, 0 },
			 { 20981, 0 },
			 { 20995, 0 },
			 { 13535, 0 },
			 { 21051, 0 },
			 { 21062, 0 },
			 { 21106, 0 },
			 { 21111, 0 },
			 { 13589, 0 },
			 { 21191, 0 },
			 { 21193, 0 },
			 { 21220, 0 },
			 { 21242, 0 },
			 { 21253, 0 },
			 { 21254, 0 },
			 { 21271, 0 },
			 { 21321, 0 },
			 { 21329, 0 },
			 { 21338, 0 },
			 { 21363, 0 },
			 { 21373, 0 },
			 { 21375, 0 },
			 { 21375, 0 },
			 { 21375, 0 },
			 { 8354, 0 },
			 { 28784, 0 },
			 { 21450, 0 },
			 { 21471, 0 },
			 { 8374, 0 },
			 { 21483, 0 },
			 { 21489, 0 },
			 { 21510, 0 },
			 { 21662, 0 },
			 { 21560, 0 },
			 { 21576, 0 },
			 { 21608, 0 },
			 { 21666, 0 },
			 { 21750, 0 },
			 { 21776, 0 },
			 { 21843, 0 },
			 { 21859, 0 },
			 { 21892, 0 },
			 { 21892, 0 },
			 { 21913, 0 },
			 { 21931, 0 },
			 { 21939, 0 },
			 { 21954, 0 },
			 { 22294, 0 },
			 { 22022, 0 },
			 { 22295, 0 },
			 { 22097, 0 },
			 { 22132, 0 },
			 { 20999, 0 },
			 { 22766, 0 },
			 { 22478, 0 },
			 { 22516, 0 },
			 { 22541, 0 },
			 { 22411, 0 },
			 { 22578, 0 },
			 { 22577, 0 },
			 { 22700, 0 },
			 { 8526, 0 },
			 { 22770, 0 },
			 { 22775, 0 },
			 { 22790, 0 },
			 { 22810, 0 },
			 { 22818, 0 },
			 { 22882, 0 },
			 { 8554, 0 },
			 { 8558, 0 },
			 { 23020, 0 },
			 { 23067, 0 },
			 { 23079, 0 },
			 { 23000, 0 },
			 { 23142, 0 },
			 { 14062, 0 },
			 { 14076, 0 },
			 { 23304, 0 },
			 { 23358, 0 },
			 { 23358, 0 },
			 { 8604, 0 },
			 { 23491, 0 },
			 { 23512, 0 },
			 { 23527, 0 },
			 { 23539, 0 },
			 { 8625, 0 },
			 { 23551, 0 },
			 { 23558, 0 },
			 { 24403, 0 },
			 { 23586, 0 },
			 { 14209, 0 },
			 { 23648, 0 },
			 { 23662, 0 },
			 { 23744, 0 },
			 { 23693, 0 },
			 { 8670, 0 },
			 { 23875, 0 },
			 { 8670, 0 },
			 { 23918, 0 },
			 { 23915, 0 },
			 { 23932, 0 },
			 { 24033, 0 },
			 { 24034, 0 },
			 { 14383, 0 },
			 { 24061, 0 },
			 { 24104, 0 },
			 { 24125, 0 },
			 { 24169, 0 },
			 { 14434, 0 },
			 { 8728, 0 },
			 { 14460, 0 },
			 { 24240, 0 },
			 { 24243, 0 },
			 { 24246, 0 },
			 { 24266, 0 },
			 { 10809, 0 },
			 { 24318, 0 },
			 { 8755, 0 },
			 { 8755, 0 },
			 { 33281, 0 },
			 { 24354, 0 },
			 { 24354, 0 },
			 { 14535, 0 },
			 { 9003, 0 },
			 { 9757, 0 },
			 { 24418, 0 },
			 { 24427, 0 },
			 { 14563, 0 },
			 { 24474, 0 },
			 { 24525, 0 },
			 { 24535, 0 },
			 { 24569, 0 },
			 { 24705, 0 },
			 { 14650, 0 },
			 { 14620, 0 },
			 { 24724, 0 },
			 { 8813, 0 },
			 { 24775, 0 },
			 { 24904, 0 },
			 { 24908, 0 },
			 { 24910, 0 },
			 { 24908, 0 },
			 { 24954, 0 },
			 { 24974, 0 },
			 { 25010, 0 },
			 { 24996, 0 },
			 { 25007, 0 },
			 { 25054, 0 },
			 { 25074, 0 },
			 { 25078, 0 },
			 { 25104, 0 },
			 { 25115, 0 },
			 { 25181, 0 },
			 { 25265, 0 },
			 { 25300, 0 },
			 { 25424, 0 },
			 { 8880, 0 },
			 { 25405, 0 },
			 { 25340, 0 },
			 { 25448, 0 },
			 { 25475, 0 },
			 { 25572, 0 },
			 { 8895, 0 },
			 { 25634, 0 },
			 { 25541, 0 },
			 { 25513, 0 },
			 { 14894, 0 },
			 { 25705, 0 },
			 { 25726, 0 },
			 { 25757, 0 },
			 { 25719, 0 },
			 { 14956, 0 },
			 { 25935, 0 },
			 { 25964, 0 },
			 { 8960, 0 },
			 { 26083, 0 },
			 { 26360, 0 },
			 { 26185, 0 },
			 { 15129, 0 },
			 { 26257, 0 },
			 { 15112, 0 },
			 { 15076, 0 },
			 { 20882, 0 },
			 { 20885, 0 },
			 { 26368, 0 },
			 { 26268, 0 },
			 { 32941, 0 },
			 { 17369, 0 },
			 { 26391, 0 },
			 { 26395, 0 },
			 { 26401, 0 },
			 { 26462, 0 },
			 { 26451, 0 },
			 { 9020, 0 },
			 { 15177, 0 },
			 { 26618, 0 },
			 { 26501, 0 },
			 { 26706, 0 },
			 { 26757, 0 },
			 { 9030, 0 },
			 { 26766, 0 },
			 { 26655, 0 },
			 { 26900, 0 },
			 { 15261, 0 },
			 { 26946, 0 },
			 { 27043, 0 },
			 { 27114, 0 },
			 { 27304, 0 },
			 { 9066, 0 },
			 { 27355, 0 },
			 { 15384, 0 },
			 { 27425, 0 },
			 { 9098, 0 },
			 { 27476, 0 },
			 { 15438, 0 },
			 { 27506, 0 },
			 { 27551, 0 },
			 { 27578, 0 },
			 { 27579, 0 },
			 { 9128, 0 },
			 { 8656, 0 },
			 { 9135, 0 },
			 { 27726, 0 },
			 { 9163, 0 },
			 { 27839, 0 },
			 { 27853, 0 },
			 { 27751, 0 },
			 { 27926, 0 },
		},
// page 30
		{
			 { 27966, 0 },
			 { 28023, 0 },
			 { 27969, 0 },
			 { 28009, 0 },
			 { 28024, 0 },
			 { 28037, 0 },
			 { 9169, 0 },
			 { 27956, 0 },
			 { 28207, 0 },
			 { 28270, 0 },
			 { 15667, 0 },
			 { 28363, 0 },
			 { 28359, 0 },
			 { 9197, 0 },
			 { 28153, 0 },
			 { 28526, 0 },
			 { 9205, 0 },
			 { 9208, 0 },
			 { 28614, 0 },
			 { 28729, 0 },
			 { 28702, 0 },
			 { 28699, 0 },
			 { 15766, 0 },
			 { 28746, 0 },
			 { 28797, 0 },
			 { 28791, 0 },
			 { 28845, 0 },
			 { 8274, 0 },
			 { 28997, 0 },
			 { 9254, 0 },
			 { 29084, 0 },
			 { 9274, 0 },
			 { 29224, 0 },
			 { 29237, 0 },
			 { 29264, 0 },
			 { 9312, 0 },
			 { 29312, 0 },
			 { 29333, 0 },
			 { 9331, 0 },
			 { 9345, 0 },
			 { 29562, 0 },
			 { 29579, 0 },
			 { 16044, 0 },
			 { 29605, 0 },
			 { 16056, 0 },
			 { 16056, 0 },
			 { 29767, 0 },
			 { 29788, 0 },
			 { 29809, 0 },
			 { 29829, 0 },
			 { 29898, 0 },
			 { 16155, 0 },
			 { 29988, 0 },
			 { 9411, 0 },
			 { 30014, 0 },
			 { 9417, 0 },
			 { 30064, 0 },
			 { 8729, 0 },
			 { 30224, 0 },
			 { 9466, 0 },
			 { 9467, 0 },
			 { 9476, 0 },
			 { 16380, 0 },
			 { 16392, 0 },
			 { 30452, 0 },
			 { 9487, 0 },
			 { 9487, 0 },
			 { 9489, 0 },
			 { 9491, 0 },
			 { 30494, 0 },
			 { 30495, 0 },
			 { 30495, 0 },
			 { 30538, 0 },
			 { 16441, 0 },
			 { 30603, 0 },
			 { 16454, 0 },
			 { 16534, 0 },
			 { 9537, 0 },
			 { 30798, 0 },
			 { 30860, 0 },
			 { 30924, 0 },
			 { 16611, 0 },
			 { 9570, 0 },
			 { 31062, 0 },
			 { 9577, 0 },
			 { 9580, 0 },
			 { 31119, 0 },
			 { 31211, 0 },
			 { 16687, 0 },
			 { 31296, 0 },
			 { 31306, 0 },
			 { 31311, 0 },
			 { 9623, 0 },
			 { 9642, 0 },
			 { 9642, 0 },
			 { 31470, 0 },
			 { 16898, 0 },
			 { 9658, 0 },
			 { 31686, 0 },
			 { 31689, 0 },
			 { 16935, 0 },
			 { 9672, 0 },
			 { 31954, 0 },
			 { 17056, 0 },
			 { 31976, 0 },
			 { 31971, 0 },
			 { 32000, 0 },
			 { 9720, 0 },
			 { 32099, 0 },
			 { 17153, 0 },
			 { 32199, 0 },
			 { 32258, 0 },
			 { 32325, 0 },
			 { 17204, 0 },
			 { 9762, 0 },
			 { 9764, 0 },
			 { 17241, 0 },
			 { 9773, 0 },
			 { 32634, 0 },
			 { 9779, 0 },
			 { 32661, 0 },
			 { 32762, 0 },
			 { 32773, 0 },
			 { 9805, 0 },
			 { 9810, 0 },
			 { 32864, 0 },
			 { 9818, 0 },
			 { 32880, 0 },
			 { 9013, 0 },
			 { 17365, 0 },
			 { 32946, 0 },
			 { 33027, 0 },
			 { 17419, 0 },
			 { 33086, 0 },
			 { 23221, 0 },
			 { 9850, 0 },
			 { 9851, 0 },
			 { 9017, 0 },
			 { 9017, 0 },
			 { 33281, 0 },
			 { 33284, 0 },
			 { 36766, 0 },
			 { 17515, 0 },
			 { 33425, 0 },
			 { 33419, 0 },
			 { 33437, 0 },
			 { 21171, 0 },
			 { 33457, 0 },
			 { 33459, 0 },
			 { 33469, 0 },
			 { 33510, 0 },
			 { 9907, 0 },
			 { 33509, 0 },
			 { 33565, 0 },
			 { 33635, 0 },
			 { 33709, 0 },
			 { 33571, 0 },
			 { 33725, 0 },
			 { 33767, 0 },
			 { 33879, 0 },
			 { 33619, 0 },
			 { 33738, 0 },
			 { 33740, 0 },
			 { 33756, 0 },
			 { 9923, 0 },
			 { 9942, 0 },
			 { 9933, 0 },
			 { 17707, 0 },
			 { 34033, 0 },
			 { 34035, 0 },
			 { 34070, 0 },
			 { 10044, 0 },
			 { 34148, 0 },
			 { 9970, 0 },
			 { 17757, 0 },
			 { 17761, 0 },
			 { 9979, 0 },
			 { 9997, 0 },
			 { 17771, 0 },
			 { 34384, 0 },
			 { 34396, 0 },
			 { 34407, 0 },
			 { 34409, 0 },
			 { 34473, 0 },
			 { 34440, 0 },
			 { 34574, 0 },
			 { 34530, 0 },
			 { 34681, 0 },
			 { 34600, 0 },
			 { 34667, 0 },
			 { 34694, 0 },
			 { 17879, 0 },
			 { 34785, 0 },
			 { 34817, 0 },
			 { 17913, 0 },
			 { 34912, 0 },
			 { 34915, 0 },
			 { 10086, 0 },
			 { 35031, 0 },
			 { 35038, 0 },
			 { 17973, 0 },
			 { 35066, 0 },
			 { 13499, 0 },
			 { 10122, 0 },
			 { 10134, 0 },
			 { 18110, 0 },
			 { 18119, 0 },
			 { 35488, 0 },
			 { 35565, 0 },
			 { 35722, 0 },
			 { 35925, 0 },
			 { 10186, 0 },
			 { 36011, 0 },
			 { 36033, 0 },
			 { 36123, 0 },
			 { 36215, 0 },
			 { 10226, 0 },
			 { 8320, 0 },
			 { 36299, 0 },
			 { 36284, 0 },
			 { 36336, 0 },
			 { 8333, 0 },
			 { 36564, 0 },
			 { 36664, 0 },
			 { 10333, 0 },
			 { 10334, 0 },
			 { 37012, 0 },
			 { 37105, 0 },
			 { 37137, 0 },
			 { 10354, 0 },
			 { 37147, 0 },
			 { 37432, 0 },
			 { 37591, 0 },
			 { 37592, 0 },
			 { 37500, 0 },
			 { 37881, 0 },
			 { 37909, 0 },
			 { 10431, 0 },
			 { 38283, 0 },
			 { 18837, 0 },
			 { 38327, 0 },
			 { 10455, 0 },
			 { 18918, 0 },
			 { 38595, 0 },
			 { 23986, 0 },
			 { 38691, 0 },
			 { 10516, 0 },
			 { 10529, 0 },
			 { 19054, 0 },
			 { 19062, 0 },
			 { 38880, 0 },
			 { 10560, 0 },
			 { 19122, 0 },
			 { 10569, 0 },
			 { 38923, 0 },
			 { 38923, 0 },
		},
// page 31
		{
			 { 38953, 0 },
			 { 10587, 0 },
			 { 39138, 0 },
			 { 19251, 0 },
			 { 39209, 0 },
			 { 39335, 0 },
			 { 39362, 0 },
			 { 39422, 0 },
			 { 19406, 0 },
			 { 10675, 0 },
			 { 39698, 0 },
			 { 40000, 0 },
			 { 40189, 0 },
			 { 19662, 0 },
			 { 19693, 0 },
			 { 40295, 0 },
			 { 10764, 0 },
			 { 19704, 0 },
			 { 10768, 0 },
			 { 10784, 0 },
			 { 10793, 0 },
			 { 40635, 0 },
			 { 19798, 0 },
			 { 40697, 0 },
			 { 40702, 0 },
			 { 40709, 0 },
			 { 40719, 0 },
			 { 40726, 0 },
			 { 40763, 0 },
			 { 10848, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
			 { 0, 0 },
		},

	}
};

struct M6FullCaseFold
{
	uint32			uc;
	uint32			folded[3];
} kM6FullCaseFolds[] = {
	0x000df, { 0x0073, 0x0073 },
	0x00130, { 0x0069, 0x0307 },
	0x00149, { 0x02BC, 0x006E },
	0x001f0, { 0x006A, 0x030C },
	0x00390, { 0x03B9, 0x0308, 0x0301 },
	0x003b0, { 0x03C5, 0x0308, 0x0301 },
	0x00587, { 0x0565, 0x0582 },
	0x01e96, { 0x0068, 0x0331 },
	0x01e97, { 0x0074, 0x0308 },
	0x01e98, { 0x0077, 0x030A },
	0x01e99, { 0x0079, 0x030A },
	0x01e9a, { 0x0061, 0x02BE },
	0x01e9e, { 0x0073, 0x0073 },
	0x01f50, { 0x03C5, 0x0313 },
	0x01f52, { 0x03C5, 0x0313, 0x0300 },
	0x01f54, { 0x03C5, 0x0313, 0x0301 },
	0x01f56, { 0x03C5, 0x0313, 0x0342 },
	0x01f80, { 0x1F00, 0x03B9 },
	0x01f81, { 0x1F01, 0x03B9 },
	0x01f82, { 0x1F02, 0x03B9 },
	0x01f83, { 0x1F03, 0x03B9 },
	0x01f84, { 0x1F04, 0x03B9 },
	0x01f85, { 0x1F05, 0x03B9 },
	0x01f86, { 0x1F06, 0x03B9 },
	0x01f87, { 0x1F07, 0x03B9 },
	0x01f88, { 0x1F00, 0x03B9 },
	0x01f89, { 0x1F01, 0x03B9 },
	0x01f8a, { 0x1F02, 0x03B9 },
	0x01f8b, { 0x1F03, 0x03B9 },
	0x01f8c, { 0x1F04, 0x03B9 },
	0x01f8d, { 0x1F05, 0x03B9 },
	0x01f8e, { 0x1F06, 0x03B9 },
	0x01f8f, { 0x1F07, 0x03B9 },
	0x01f90, { 0x1F20, 0x03B9 },
	0x01f91, { 0x1F21, 0x03B9 },
	0x01f92, { 0x1F22, 0x03B9 },
	0x01f93, { 0x1F23, 0x03B9 },
	0x01f94, { 0x1F24, 0x03B9 },
	0x01f95, { 0x1F25, 0x03B9 },
	0x01f96, { 0x1F26, 0x03B9 },
	0x01f97, { 0x1F27, 0x03B9 },
	0x01f98, { 0x1F20, 0x03B9 },
	0x01f99, { 0x1F21, 0x03B9 },
	0x01f9a, { 0x1F22, 0x03B9 },
	0x01f9b, { 0x1F23, 0x03B9 },
	0x01f9c, { 0x1F24, 0x03B9 },
	0x01f9d, { 0x1F25, 0x03B9 },
	0x01f9e, { 0x1F26, 0x03B9 },
	0x01f9f, { 0x1F27, 0x03B9 },
	0x01fa0, { 0x1F60, 0x03B9 },
	0x01fa1, { 0x1F61, 0x03B9 },
	0x01fa2, { 0x1F62, 0x03B9 },
	0x01fa3, { 0x1F63, 0x03B9 },
	0x01fa4, { 0x1F64, 0x03B9 },
	0x01fa5, { 0x1F65, 0x03B9 },
	0x01fa6, { 0x1F66, 0x03B9 },
	0x01fa7, { 0x1F67, 0x03B9 },
	0x01fa8, { 0x1F60, 0x03B9 },
	0x01fa9, { 0x1F61, 0x03B9 },
	0x01faa, { 0x1F62, 0x03B9 },
	0x01fab, { 0x1F63, 0x03B9 },
	0x01fac, { 0x1F64, 0x03B9 },
	0x01fad, { 0x1F65, 0x03B9 },
	0x01fae, { 0x1F66, 0x03B9 },
	0x01faf, { 0x1F67, 0x03B9 },
	0x01fb2, { 0x1F70, 0x03B9 },
	0x01fb3, { 0x03B1, 0x03B9 },
	0x01fb4, { 0x03AC, 0x03B9 },
	0x01fb6, { 0x03B1, 0x0342 },
	0x01fb7, { 0x03B1, 0x0342, 0x03B9 },
	0x01fbc, { 0x03B1, 0x03B9 },
	0x01fc2, { 0x1F74, 0x03B9 },
	0x01fc3, { 0x03B7, 0x03B9 },
	0x01fc4, { 0x03AE, 0x03B9 },
	0x01fc6, { 0x03B7, 0x0342 },
	0x01fc7, { 0x03B7, 0x0342, 0x03B9 },
	0x01fcc, { 0x03B7, 0x03B9 },
	0x01fd2, { 0x03B9, 0x0308, 0x0300 },
	0x01fd3, { 0x03B9, 0x0308, 0x0301 },
	0x01fd6, { 0x03B9, 0x0342 },
	0x01fd7, { 0x03B9, 0x0308, 0x0342 },
	0x01fe2, { 0x03C5, 0x0308, 0x0300 },
	0x01fe3, { 0x03C5, 0x0308, 0x0301 },
	0x01fe4, { 0x03C1, 0x0313 },
	0x01fe6, { 0x03C5, 0x0342 },
	0x01fe7, { 0x03C5, 0x0308, 0x0342 },
	0x01ff2, { 0x1F7C, 0x03B9 },
	0x01ff3, { 0x03C9, 0x03B9 },
	0x01ff4, { 0x03CE, 0x03B9 },
	0x01ff6, { 0x03C9, 0x0342 },
	0x01ff7, { 0x03C9, 0x0342, 0x03B9 },
	0x01ffc, { 0x03C9, 0x03B9 },
	0x0fb00, { 0x0066, 0x0066 },
	0x0fb01, { 0x0066, 0x0069 },
	0x0fb02, { 0x0066, 0x006C },
	0x0fb03, { 0x0066, 0x0066, 0x0069 },
	0x0fb04, { 0x0066, 0x0066, 0x006C },
	0x0fb05, { 0x0073, 0x0074 },
	0x0fb06, { 0x0073, 0x0074 },
	0x0fb13, { 0x0574, 0x0576 },
	0x0fb14, { 0x0574, 0x0565 },
	0x0fb15, { 0x0574, 0x056B },
	0x0fb16, { 0x057E, 0x0576 },
	0x0fb17, { 0x0574, 0x056D },
};
