/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconFactory_H
#define IconFactory_H

#include <string>

using namespace std;

class IconObject;
class IconClass;
class IconInfo;
class Folder;
class Request;

class IconFactory
{
public:
    IconFactory(const string& name);
    virtual ~IconFactory();

    virtual IconObject* make(Folder* parent, const IconClass& kind,
                             const string& name, IconInfo* info) = 0;

    static IconObject* create(Folder* parent, const string& name, const IconClass&, IconInfo*);
    static IconObject* createTemporary(IconObject*, const Request&, const IconClass* = 0);
    static IconObject* create(Folder* parent, const string& name, const IconClass&);
    static IconObject* create(Folder* parent, const string& name, const IconClass& kind, int x, int y);
    static IconObject* create(Folder* parent, const string& name, int x, int y);
    static IconObject* create(Folder* parent, const string& name);
    static IconObject* create(const string& name, const IconClass&);

    //We should never call this
    static IconObject* create(IconObject*, const Request&, const IconClass* = 0);

    static IconObject* create(Folder*, const Request&, int x, int y);

private:
    // No copy allowed
    IconFactory(const IconFactory&);
    IconFactory& operator=(const IconFactory&);
};

template <class T>
class IconMaker : public IconFactory
{
    IconObject* make(Folder* parent, const IconClass& kind,
                     const string& name, IconInfo* info)
    {
        return new T(parent, kind, name, info);
    }

public:
    IconMaker(const string& name) :
        IconFactory(name) {}
};


#endif
