/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MotifDrop.h
// Baudouin Raoult - ECMWF Jun 00

#ifndef MotifDrop_H
#define MotifDrop_H

#include <string>
using std::string;

class DropSite;

#ifndef Runnable_H
#include "Runnable.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif

class MotifDrop : public Runnable, public Dropping {
public:

// -- Exceptions
	// None

// -- Contructors

	MotifDrop(DropSite*);

// -- Destructor

	~MotifDrop(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators

// -- Methods

	int x() const;
	int y() const;
	void drop(const string&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	static void addSite(DropSite*,Widget);
	static void removeSite(DropSite*);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MotifDrop(const MotifDrop&);
	MotifDrop& operator=(const MotifDrop&);

// -- Members

	DropSite*    owner_;
	string       name_;

// -- Methods
	// None

// -- Overridden methods

	// From Runnable
	virtual void run();

	// From Dropping

	virtual IconObject* object(DropSite&);
	virtual bool copy();


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MotifDrop& p)
	//	{ p.print(s); return s; }

};

inline void destroy(MotifDrop**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MotifDrop);
//#endif

#endif
