/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorToolFactory_H
#include "EditorToolFactory.h"
#endif

#ifndef EditorTool_H
#include "EditorTool.h"
#endif

typedef multimap<int,EditorToolFactory*> Map;

static Map *makers= 0;

EditorToolFactory::EditorToolFactory(const string& name,int n):
	name_(name)
{
	if(makers == 0)
		makers = new Map();

	makers->insert(Map::value_type(n,this));
}

EditorToolFactory::~EditorToolFactory()
{
	// Not called
}

map<string,EditorTool*> EditorToolFactory::create(Editor *e)
{
	map<string,EditorTool*> m;
	for(Map::iterator j = makers->begin(); j != makers->end(); ++j)
	{
		string name = (*j).second->name_;
		EditorTool* d = (*j).second->make(e,name);
		if(d != 0) m[name] = d;
	}
	return m;
}
