#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
**Project Name:**      MakeHuman

**Product Home Page:** http://www.makehuman.org/

**Code Home Page:**    https://bitbucket.org/MakeHuman/makehuman/

**Authors:**           Thomas Larsson

**Copyright(c):**      MakeHuman Team 2001-2017

**Licensing:**         AGPL3

    This file is part of MakeHuman (www.makehuman.org).

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


Abstract
--------

Fake UVs for helper geometry. For UV projection.
"""

from mathutils import Vector as V

TexFaces = {
    13378: (V((0.1255,0.152434)), V((0.1204,0.157276)), V((0.1168,0.152336)), V((0.1223,0.146537)), ),
    13379: (V((0.1295,0.159231)), V((0.1248,0.163272)), V((0.1204,0.157276)), V((0.1255,0.152434)), ),
    13380: (V((0.1624,0.136645)), V((0.1645,0.146680)), V((0.1618,0.146990)), V((0.1591,0.136827)), ),
    13381: (V((0.1591,0.136827)), V((0.1618,0.146990)), V((0.1572,0.149727)), V((0.1541,0.139019)), ),
    13382: (V((0.1645,0.146680)), V((0.1624,0.136645)), V((0.1663,0.137728)), V((0.1677,0.147726)), ),
    13383: (V((0.1248,0.163272)), V((0.1311,0.172681)), V((0.1251,0.176897)), V((0.1193,0.167736)), ),
    13384: (V((0.1624,0.136645)), V((0.1604,0.128607)), V((0.1647,0.129443)), V((0.1663,0.137728)), ),
    13385: (V((0.1604,0.128607)), V((0.1624,0.136645)), V((0.1591,0.136827)), V((0.1551,0.129562)), ),
    13386: (V((0.1551,0.129562)), V((0.1591,0.136827)), V((0.1541,0.139019)), V((0.1496,0.131845)), ),
    13387: (V((0.1600,0.121370)), V((0.1648,0.121855)), V((0.1647,0.129443)), V((0.1604,0.128607)), ),
    13388: (V((0.1729,0.133931)), V((0.1697,0.131608)), V((0.1694,0.122769)), V((0.1737,0.124284)), ),
    13389: (V((0.1782,0.145195)), V((0.1734,0.142287)), V((0.1729,0.133931)), V((0.1768,0.136237)), ),
    13390: (V((0.1114,0.165650)), V((0.1157,0.161792)), V((0.1193,0.167736)), V((0.1141,0.171660)), ),
    13391: (V((0.1021,0.174050)), V((0.1063,0.170267)), V((0.1095,0.176336)), V((0.1052,0.179219)), ),
    13392: (V((0.1063,0.170267)), V((0.1114,0.165650)), V((0.1141,0.171660)), V((0.1095,0.176336)), ),
    13393: (V((0.1078,0.161587)), V((0.1110,0.157687)), V((0.1157,0.161792)), V((0.1114,0.165650)), ),
    13394: (V((0.0977,0.169584)), V((0.1026,0.165933)), V((0.1063,0.170267)), V((0.1021,0.174050)), ),
    13395: (V((0.1026,0.165933)), V((0.1078,0.161587)), V((0.1114,0.165650)), V((0.1063,0.170267)), ),
    13396: (V((0.1248,0.163272)), V((0.1193,0.167736)), V((0.1157,0.161792)), V((0.1204,0.157276)), ),
    13397: (V((0.1768,0.136237)), V((0.1729,0.133931)), V((0.1737,0.124284)), V((0.1771,0.126439)), ),
    13398: (V((0.1204,0.157276)), V((0.1157,0.161792)), V((0.1110,0.157687)), V((0.1168,0.152336)), ),
    13399: (V((0.1551,0.129562)), V((0.1496,0.131845)), V((0.1476,0.124297)), V((0.1537,0.122240)), ),
    13400: (V((0.1734,0.142287)), V((0.1687,0.139285)), V((0.1697,0.131608)), V((0.1729,0.133931)), ),
    13401: (V((0.1604,0.128607)), V((0.1551,0.129562)), V((0.1537,0.122240)), V((0.1600,0.121370)), ),
    13402: (V((0.1541,0.139019)), V((0.1572,0.149727)), V((0.1537,0.151817)), V((0.1490,0.142344)), ),
    13403: (V((0.1813,0.129221)), V((0.1817,0.138742)), V((0.1768,0.136237)), V((0.1771,0.126439)), ),
    13404: (V((0.1817,0.138742)), V((0.1834,0.147762)), V((0.1782,0.145195)), V((0.1768,0.136237)), ),
    13405: (V((0.1813,0.129221)), V((0.1862,0.130689)), V((0.1864,0.138528)), V((0.1817,0.138742)), ),
    13406: (V((0.1817,0.138742)), V((0.1864,0.138528)), V((0.1878,0.147001)), V((0.1834,0.147762)), ),
    13407: (V((0.1694,0.122769)), V((0.1697,0.131608)), V((0.1647,0.129443)), V((0.1648,0.121855)), ),
    13408: (V((0.1663,0.137728)), V((0.1647,0.129443)), V((0.1697,0.131608)), V((0.1687,0.139285)), ),
    13409: (V((0.1490,0.142344)), V((0.1447,0.134579)), V((0.1496,0.131845)), V((0.1541,0.139019)), ),
    13410: (V((0.1476,0.124297)), V((0.1496,0.131845)), V((0.1447,0.134579)), V((0.1415,0.127717)), ),
    13411: (V((0.0977,0.169584)), V((0.1021,0.174050)), V((0.0978,0.176721)), V((0.0935,0.172852)), ),
    13412: (V((0.1021,0.174050)), V((0.1052,0.179219)), V((0.1009,0.181337)), V((0.0978,0.176721)), ),
    13413: (V((0.1279,0.139807)), V((0.1350,0.133211)), V((0.1383,0.138825)), V((0.1324,0.146053)), ),
    13414: (V((0.1428,0.146732)), V((0.1361,0.152878)), V((0.1324,0.146053)), V((0.1383,0.138825)), ),
    13415: (V((0.1361,0.152878)), V((0.1428,0.146732)), V((0.1480,0.156907)), V((0.1422,0.162395)), ),
    13416: (V((0.1537,0.151817)), V((0.1480,0.156907)), V((0.1428,0.146732)), V((0.1490,0.142344)), ),
    13417: (V((0.1490,0.142344)), V((0.1428,0.146732)), V((0.1383,0.138825)), V((0.1447,0.134579)), ),
    13418: (V((0.1350,0.133211)), V((0.1415,0.127717)), V((0.1447,0.134579)), V((0.1383,0.138825)), ),
    13419: (V((0.1255,0.152434)), V((0.1324,0.146053)), V((0.1361,0.152878)), V((0.1295,0.159231)), ),
    13420: (V((0.1223,0.146537)), V((0.1279,0.139807)), V((0.1324,0.146053)), V((0.1255,0.152434)), ),
    13421: (V((0.1516,0.114552)), V((0.1478,0.107459)), V((0.1566,0.105982)), V((0.1588,0.113876)), ),
    13422: (V((0.1645,0.113582)), V((0.1642,0.104434)), V((0.1701,0.104663)), V((0.1698,0.114576)), ),
    13423: (V((0.1943,0.105564)), V((0.2000,0.110343)), V((0.1963,0.113056)), V((0.1902,0.107250)), ),
    13424: (V((0.2085,0.042728)), V((0.2087,0.049783)), V((0.2033,0.049701)), V((0.2049,0.043956)), ),
    13425: (V((0.1795,0.114914)), V((0.1813,0.106159)), V((0.1902,0.107250)), V((0.1849,0.117826)), ),
    13426: (V((0.2056,0.116000)), V((0.2120,0.121011)), V((0.2091,0.124064)), V((0.2029,0.119181)), ),
    13427: (V((0.2036,0.107866)), V((0.1987,0.103897)), V((0.2023,0.102340)), V((0.2051,0.105500)), ),
    13428: (V((0.2083,0.112975)), V((0.2036,0.107866)), V((0.2051,0.105500)), V((0.2115,0.112041)), ),
    13429: (V((0.2139,0.118454)), V((0.2083,0.112975)), V((0.2115,0.112041)), V((0.2152,0.115745)), ),
    13430: (V((0.2260,0.140551)), V((0.2232,0.133201)), V((0.2256,0.132034)), V((0.2290,0.139811)), ),
    13431: (V((0.2298,0.150908)), V((0.2260,0.140551)), V((0.2290,0.139811)), V((0.2313,0.103738)), ),
    13432: (V((0.1105,0.121736)), V((0.1084,0.126500)), V((0.1053,0.126312)), V((0.1064,0.121135)), ),
    13433: (V((0.1123,0.114176)), V((0.1105,0.121736)), V((0.1064,0.121135)), V((0.1066,0.114393)), ),
    13434: (V((0.1128,0.133443)), V((0.1117,0.126436)), V((0.1143,0.122768)), V((0.1228,0.132560)), ),
    13435: (V((0.2197,0.144719)), V((0.2224,0.143407)), V((0.2265,0.153109)), V((0.2213,0.151086)), ),
    13436: (V((0.2159,0.137818)), V((0.2195,0.135804)), V((0.2224,0.143407)), V((0.2197,0.144719)), ),
    13437: (V((0.2000,0.110343)), V((0.2056,0.116000)), V((0.2029,0.119181)), V((0.1963,0.113056)), ),
    13438: (V((0.2012,0.036564)), V((0.1991,0.041132)), V((0.1967,0.036416)), V((0.1985,0.033800)), ),
    13439: (V((0.1746,0.104460)), V((0.1813,0.106159)), V((0.1795,0.114914)), V((0.1755,0.113332)), ),
    13440: (V((0.1394,0.109094)), V((0.1478,0.107459)), V((0.1516,0.114552)), V((0.1436,0.117185)), ),
    13441: (V((0.1143,0.122768)), V((0.1182,0.114747)), V((0.1288,0.124843)), V((0.1228,0.132560)), ),
    13442: (V((0.1920,0.122591)), V((0.2029,0.119181)), V((0.2091,0.124064)), V((0.2042,0.127227)), ),
    13443: (V((0.1148,0.046900)), V((0.1046,0.055400)), V((0.1031,0.056212)), V((0.0816,0.049567)), ),
    13444: (V((0.1902,0.107250)), V((0.1963,0.113056)), V((0.1904,0.123647)), V((0.1849,0.117826)), ),
    13445: (V((0.2029,0.119181)), V((0.1920,0.122591)), V((0.1904,0.123647)), V((0.1963,0.113056)), ),
    13446: (V((0.0955,0.120058)), V((0.0941,0.115391)), V((0.1010,0.114467)), V((0.1016,0.119457)), ),
    13447: (V((0.0979,0.125854)), V((0.0955,0.120058)), V((0.1016,0.119457)), V((0.1026,0.125974)), ),
    13448: (V((0.2263,0.115120)), V((0.2222,0.105583)), V((0.2278,0.104505)), V((0.2296,0.111836)), ),
    13449: (V((0.1991,0.041132)), V((0.2012,0.036564)), V((0.2023,0.038938)), V((0.1991,0.044099)), ),
    13450: (V((0.0809,0.124534)), V((0.0787,0.120649)), V((0.0837,0.118588)), V((0.0851,0.125794)), ),
    13451: (V((0.2115,0.112041)), V((0.2051,0.105500)), V((0.2098,0.106293)), V((0.2153,0.106046)), ),
    13452: (V((0.2152,0.115745)), V((0.2115,0.112041)), V((0.2153,0.106046)), V((0.2194,0.117044)), ),
    13453: (V((0.1662,0.020200)), V((0.1661,0.026527)), V((0.1635,0.028000)), V((0.1649,0.020100)), ),
    13454: (V((0.1066,0.114393)), V((0.1064,0.121135)), V((0.1016,0.119457)), V((0.1010,0.114467)), ),
    13455: (V((0.1064,0.121135)), V((0.1053,0.126312)), V((0.1026,0.125974)), V((0.1016,0.119457)), ),
    13456: (V((0.2313,0.103738)), V((0.2339,0.113157)), V((0.2296,0.111836)), V((0.2278,0.104505)), ),
    13457: (V((0.2339,0.113157)), V((0.2256,0.132034)), V((0.2263,0.115120)), V((0.2296,0.111836)), ),
    13458: (V((0.2042,0.127227)), V((0.2091,0.124064)), V((0.2147,0.128820)), V((0.2104,0.132224)), ),
    13459: (V((0.2176,0.125630)), V((0.2120,0.121011)), V((0.2139,0.118454)), V((0.2194,0.121024)), ),
    13460: (V((0.2139,0.118454)), V((0.2152,0.115745)), V((0.2194,0.117044)), V((0.2194,0.121024)), ),
    13461: (V((0.0674,0.054268)), V((0.0650,0.048927)), V((0.0685,0.050600)), V((0.0820,0.051795)), ),
    13462: (V((0.1661,0.026527)), V((0.1662,0.020200)), V((0.1985,0.033800)), V((0.1967,0.036416)), ),
    13463: (V((0.0650,0.048927)), V((0.0674,0.054268)), V((0.0541,0.057900)), V((0.0506,0.052083)), ),
    13464: (V((0.0443,0.073540)), V((0.0401,0.068524)), V((0.0506,0.052083)), V((0.0541,0.057900)), ),
    13465: (V((0.1341,0.031100)), V((0.1328,0.027500)), V((0.1649,0.020100)), V((0.1635,0.028000)), ),
    13466: (V((0.1042,0.055993)), V((0.1148,0.046900)), V((0.1325,0.029000)), V((0.1162,0.046800)), ),
    13467: (V((0.0816,0.049567)), V((0.1031,0.056212)), V((0.0820,0.051795)), V((0.0685,0.050600)), ),
    13468: (V((0.1345,0.032577)), V((0.1322,0.028400)), V((0.1328,0.027500)), V((0.1341,0.031100)), ),
    13469: (V((0.2047,0.042493)), V((0.2016,0.048512)), V((0.2007,0.047702)), V((0.2042,0.040511)), ),
    13470: (V((0.1991,0.044099)), V((0.2023,0.038938)), V((0.2042,0.040511)), V((0.2007,0.047702)), ),
    13471: (V((0.1162,0.046800)), V((0.1325,0.029000)), V((0.1322,0.028400)), V((0.1345,0.032577)), ),
    13472: (V((0.1066,0.063094)), V((0.1042,0.055993)), V((0.1162,0.046800)), V((0.1093,0.062757)), ),
    13473: (V((0.1376,0.040455)), V((0.1341,0.031100)), V((0.1635,0.028000)), V((0.1401,0.037300)), ),
    13474: (V((0.0571,0.082507)), V((0.0443,0.073540)), V((0.0541,0.057900)), V((0.0647,0.077313)), ),
    13475: (V((0.0674,0.054268)), V((0.0773,0.071496)), V((0.0647,0.077313)), V((0.0541,0.057900)), ),
    13476: (V((0.1645,0.039428)), V((0.1661,0.026527)), V((0.1967,0.036416)), V((0.1859,0.047765)), ),
    13477: (V((0.0773,0.071496)), V((0.0674,0.054268)), V((0.0820,0.051795)), V((0.0984,0.064600)), ),
    13478: (V((0.1661,0.026527)), V((0.1645,0.039428)), V((0.1401,0.037300)), V((0.1635,0.028000)), ),
    13479: (V((0.1898,0.051817)), V((0.1991,0.041132)), V((0.1991,0.044099)), V((0.1917,0.056025)), ),
    13480: (V((0.1046,0.055400)), V((0.1043,0.063669)), V((0.1037,0.064644)), V((0.1031,0.056212)), ),
    13481: (V((0.1991,0.041132)), V((0.1898,0.051817)), V((0.1859,0.047765)), V((0.1967,0.036416)), ),
    13482: (V((0.2087,0.049783)), V((0.2041,0.063633)), V((0.1984,0.063070)), V((0.2033,0.049701)), ),
    13483: (V((0.1093,0.062757)), V((0.1162,0.046800)), V((0.1345,0.032577)), V((0.1223,0.052233)), ),
    13484: (V((0.1917,0.056025)), V((0.1991,0.044099)), V((0.2007,0.047702)), V((0.1942,0.060849)), ),
    13485: (V((0.2016,0.048512)), V((0.1959,0.061586)), V((0.1942,0.060849)), V((0.2007,0.047702)), ),
    13486: (V((0.1223,0.052233)), V((0.1345,0.032577)), V((0.1341,0.031100)), V((0.1376,0.040455)), ),
    13487: (V((0.1031,0.056212)), V((0.1037,0.064644)), V((0.0984,0.064600)), V((0.0820,0.051795)), ),
    13488: (V((0.1173,0.074057)), V((0.1093,0.062757)), V((0.1223,0.052233)), V((0.1252,0.070506)), ),
    13489: (V((0.2041,0.063633)), V((0.2037,0.073952)), V((0.1965,0.072705)), V((0.1984,0.063070)), ),
    13490: (V((0.1898,0.051817)), V((0.1820,0.064329)), V((0.1741,0.062074)), V((0.1859,0.047765)), ),
    13491: (V((0.1043,0.063669)), V((0.1104,0.079910)), V((0.1070,0.081237)), V((0.1037,0.064644)), ),
    13492: (V((0.1820,0.064329)), V((0.1898,0.051817)), V((0.1917,0.056025)), V((0.1858,0.067334)), ),
    13493: (V((0.1645,0.039428)), V((0.1630,0.060487)), V((0.1514,0.058774)), V((0.1401,0.037300)), ),
    13494: (V((0.0834,0.083404)), V((0.0773,0.071496)), V((0.0984,0.064600)), V((0.0978,0.082344)), ),
    13495: (V((0.1630,0.060487)), V((0.1645,0.039428)), V((0.1859,0.047765)), V((0.1741,0.062074)), ),
    13496: (V((0.0773,0.071496)), V((0.0834,0.083404)), V((0.0704,0.087722)), V((0.0647,0.077313)), ),
    13497: (V((0.0649,0.089691)), V((0.0571,0.082507)), V((0.0647,0.077313)), V((0.0704,0.087722)), ),
    13498: (V((0.1370,0.063806)), V((0.1376,0.040455)), V((0.1401,0.037300)), V((0.1514,0.058774)), ),
    13499: (V((0.1136,0.078251)), V((0.1066,0.063094)), V((0.1093,0.062757)), V((0.1173,0.074057)), ),
    13500: (V((0.1037,0.064644)), V((0.1070,0.081237)), V((0.0978,0.082344)), V((0.0984,0.064600)), ),
    13501: (V((0.1252,0.070506)), V((0.1223,0.052233)), V((0.1376,0.040455)), V((0.1370,0.063806)), ),
    13502: (V((0.1959,0.061586)), V((0.1935,0.071749)), V((0.1913,0.070925)), V((0.1942,0.060849)), ),
    13503: (V((0.1858,0.067334)), V((0.1917,0.056025)), V((0.1942,0.060849)), V((0.1913,0.070925)), ),
    13504: (V((0.1400,0.081900)), V((0.1370,0.063806)), V((0.1514,0.058774)), V((0.1513,0.078436)), ),
    13505: (V((0.0680,0.100886)), V((0.0649,0.089691)), V((0.0704,0.087722)), V((0.0754,0.097530)), ),
    13506: (V((0.1820,0.064329)), V((0.1778,0.077647)), V((0.1731,0.077117)), V((0.1741,0.062074)), ),
    13507: (V((0.1701,0.104663)), V((0.1746,0.104460)), V((0.1755,0.113332)), V((0.1698,0.114576)), ),
    13508: (V((0.1639,0.076781)), V((0.1630,0.060487)), V((0.1741,0.062074)), V((0.1731,0.077117)), ),
    13509: (V((0.0889,0.094780)), V((0.0834,0.083404)), V((0.0978,0.082344)), V((0.1003,0.094468)), ),
    13510: (V((0.1234,0.088629)), V((0.1173,0.074057)), V((0.1252,0.070506)), V((0.1302,0.085669)), ),
    13511: (V((0.1778,0.077647)), V((0.1820,0.064329)), V((0.1858,0.067334)), V((0.1843,0.081104)), ),
    13512: (V((0.1104,0.079910)), V((0.1110,0.094002)), V((0.1060,0.094408)), V((0.1070,0.081237)), ),
    13513: (V((0.1935,0.071749)), V((0.1923,0.084009)), V((0.1893,0.084150)), V((0.1913,0.070925)), ),
    13514: (V((0.2037,0.073952)), V((0.1984,0.083341)), V((0.1983,0.083943)), V((0.1965,0.072705)), ),
    13515: (V((0.1159,0.093469)), V((0.1136,0.078251)), V((0.1173,0.074057)), V((0.1234,0.088629)), ),
    13516: (V((0.1843,0.081104)), V((0.1858,0.067334)), V((0.1913,0.070925)), V((0.1893,0.084150)), ),
    13517: (V((0.0834,0.083404)), V((0.0889,0.094780)), V((0.0754,0.097530)), V((0.0704,0.087722)), ),
    13518: (V((0.1302,0.085669)), V((0.1252,0.070506)), V((0.1370,0.063806)), V((0.1400,0.081900)), ),
    13519: (V((0.1070,0.081237)), V((0.1060,0.094408)), V((0.1003,0.094468)), V((0.0978,0.082344)), ),
    13520: (V((0.1394,0.109094)), V((0.1436,0.117185)), V((0.1366,0.119900)), V((0.1302,0.111801)), ),
    13521: (V((0.1630,0.060487)), V((0.1639,0.076781)), V((0.1513,0.078436)), V((0.1514,0.058774)), ),
    13522: (V((0.1923,0.084009)), V((0.1918,0.095002)), V((0.1885,0.096321)), V((0.1893,0.084150)), ),
    13523: (V((0.1832,0.093884)), V((0.1843,0.081104)), V((0.1893,0.084150)), V((0.1885,0.096321)), ),
    13524: (V((0.1259,0.101736)), V((0.1234,0.088629)), V((0.1302,0.085669)), V((0.1340,0.099445)), ),
    13525: (V((0.1984,0.083341)), V((0.1983,0.092711)), V((0.1956,0.093755)), V((0.1983,0.083943)), ),
    13526: (V((0.1778,0.077647)), V((0.1769,0.092447)), V((0.1704,0.092376)), V((0.1731,0.077117)), ),
    13527: (V((0.1110,0.094002)), V((0.1104,0.104799)), V((0.1067,0.104734)), V((0.1060,0.094408)), ),
    13528: (V((0.1769,0.092447)), V((0.1778,0.077647)), V((0.1843,0.081104)), V((0.1832,0.093884)), ),
    13529: (V((0.1639,0.076781)), V((0.1635,0.092877)), V((0.1541,0.094507)), V((0.1513,0.078436)), ),
    13530: (V((0.0916,0.105746)), V((0.0889,0.094780)), V((0.1003,0.094468)), V((0.1006,0.104917)), ),
    13531: (V((0.1588,0.113876)), V((0.1566,0.105982)), V((0.1642,0.104434)), V((0.1645,0.113582)), ),
    13532: (V((0.1635,0.092877)), V((0.1639,0.076781)), V((0.1731,0.077117)), V((0.1704,0.092376)), ),
    13533: (V((0.0889,0.094780)), V((0.0916,0.105746)), V((0.0806,0.108099)), V((0.0754,0.097530)), ),
    13534: (V((0.0851,0.125794)), V((0.0837,0.118588)), V((0.0941,0.115391)), V((0.0955,0.120058)), ),
    13535: (V((0.0955,0.120058)), V((0.0979,0.125854)), V((0.0912,0.125438)), V((0.0851,0.125794)), ),
    13536: (V((0.2222,0.105583)), V((0.2263,0.115120)), V((0.2194,0.117044)), V((0.2153,0.106046)), ),
    13537: (V((0.2194,0.121024)), V((0.2194,0.117044)), V((0.2263,0.115120)), V((0.2256,0.132034)), ),
    13538: (V((0.2176,0.125630)), V((0.2194,0.121024)), V((0.2256,0.132034)), V((0.2232,0.133201)), ),
    13539: (V((0.2195,0.135804)), V((0.2159,0.137818)), V((0.2104,0.132224)), V((0.2147,0.128820)), ),
    13540: (V((0.0733,0.109861)), V((0.0680,0.100886)), V((0.0754,0.097530)), V((0.0806,0.108099)), ),
    13541: (V((0.1432,0.097210)), V((0.1400,0.081900)), V((0.1513,0.078436)), V((0.1541,0.094507)), ),
    13542: (V((0.1160,0.104958)), V((0.1159,0.093469)), V((0.1234,0.088629)), V((0.1259,0.101736)), ),
    13543: (V((0.1060,0.094408)), V((0.1067,0.104734)), V((0.1006,0.104917)), V((0.1003,0.094468)), ),
    13544: (V((0.1340,0.099445)), V((0.1302,0.085669)), V((0.1400,0.081900)), V((0.1432,0.097210)), ),
    13545: (V((0.1746,0.104460)), V((0.1769,0.092447)), V((0.1832,0.093884)), V((0.1813,0.106159)), ),
    13546: (V((0.1769,0.092447)), V((0.1746,0.104460)), V((0.1701,0.104663)), V((0.1704,0.092376)), ),
    13547: (V((0.1588,0.113876)), V((0.1645,0.113582)), V((0.1648,0.121855)), V((0.1600,0.121370)), ),
    13548: (V((0.1600,0.121370)), V((0.1537,0.122240)), V((0.1516,0.114552)), V((0.1588,0.113876)), ),
    13549: (V((0.1645,0.113582)), V((0.1698,0.114576)), V((0.1694,0.122769)), V((0.1648,0.121855)), ),
    13550: (V((0.1737,0.124284)), V((0.1694,0.122769)), V((0.1698,0.114576)), V((0.1755,0.113332)), ),
    13551: (V((0.1537,0.122240)), V((0.1476,0.124297)), V((0.1436,0.117185)), V((0.1516,0.114552)), ),
    13552: (V((0.1366,0.119900)), V((0.1436,0.117185)), V((0.1476,0.124297)), V((0.1415,0.127717)), ),
    13553: (V((0.1350,0.133211)), V((0.1279,0.139807)), V((0.1228,0.132560)), V((0.1288,0.124843)), ),
    13554: (V((0.1128,0.133443)), V((0.1228,0.132560)), V((0.1279,0.139807)), V((0.1223,0.146537)), ),
    13555: (V((0.1079,0.140003)), V((0.1128,0.133443)), V((0.1223,0.146537)), V((0.1168,0.152336)), ),
    13556: (V((0.1771,0.126439)), V((0.1737,0.124284)), V((0.1755,0.113332)), V((0.1795,0.114914)), ),
    13557: (V((0.1813,0.129221)), V((0.1771,0.126439)), V((0.1795,0.114914)), V((0.1849,0.117826)), ),
    13558: (V((0.1849,0.117826)), V((0.1904,0.123647)), V((0.1862,0.130689)), V((0.1813,0.129221)), ),
    13559: (V((0.0881,0.165438)), V((0.0870,0.163370)), V((0.0977,0.169584)), V((0.0935,0.172852)), ),
    13560: (V((0.0870,0.163370)), V((0.0920,0.154010)), V((0.1026,0.165933)), V((0.0977,0.169584)), ),
    13561: (V((0.1168,0.152336)), V((0.1110,0.157687)), V((0.1025,0.146786)), V((0.1079,0.140003)), ),
    13562: (V((0.0920,0.154010)), V((0.0974,0.150707)), V((0.1078,0.161587)), V((0.1026,0.165933)), ),
    13563: (V((0.0787,0.120649)), V((0.0733,0.109861)), V((0.0806,0.108099)), V((0.0837,0.118588)), ),
    13564: (V((0.1182,0.114747)), V((0.1160,0.104958)), V((0.1259,0.101736)), V((0.1302,0.111801)), ),
    13565: (V((0.0916,0.105746)), V((0.0941,0.115391)), V((0.0837,0.118588)), V((0.0806,0.108099)), ),
    13566: (V((0.0941,0.115391)), V((0.0916,0.105746)), V((0.1006,0.104917)), V((0.1010,0.114467)), ),
    13567: (V((0.1394,0.109094)), V((0.1340,0.099445)), V((0.1432,0.097210)), V((0.1478,0.107459)), ),
    13568: (V((0.1104,0.104799)), V((0.1123,0.114176)), V((0.1066,0.114393)), V((0.1067,0.104734)), ),
    13569: (V((0.1302,0.111801)), V((0.1259,0.101736)), V((0.1340,0.099445)), V((0.1394,0.109094)), ),
    13570: (V((0.1067,0.104734)), V((0.1066,0.114393)), V((0.1010,0.114467)), V((0.1006,0.104917)), ),
    13571: (V((0.1478,0.107459)), V((0.1432,0.097210)), V((0.1541,0.094507)), V((0.1566,0.105982)), ),
    13572: (V((0.1635,0.092877)), V((0.1642,0.104434)), V((0.1566,0.105982)), V((0.1541,0.094507)), ),
    13573: (V((0.1983,0.092711)), V((0.2023,0.102340)), V((0.1987,0.103897)), V((0.1956,0.093755)), ),
    13574: (V((0.1918,0.095002)), V((0.1943,0.105564)), V((0.1902,0.107250)), V((0.1885,0.096321)), ),
    13575: (V((0.1642,0.104434)), V((0.1635,0.092877)), V((0.1704,0.092376)), V((0.1701,0.104663)), ),
    13576: (V((0.1813,0.106159)), V((0.1832,0.093884)), V((0.1885,0.096321)), V((0.1902,0.107250)), ),
    13577: (V((0.1415,0.127717)), V((0.1350,0.133211)), V((0.1288,0.124843)), V((0.1366,0.119900)), ),
    13578: (V((0.1302,0.111801)), V((0.1366,0.119900)), V((0.1288,0.124843)), V((0.1182,0.114747)), ),
    13579: (V((0.2055,0.039800)), V((0.2042,0.040511)), V((0.2023,0.038938)), V((0.2012,0.036564)), ),
    13580: (V((0.1148,0.046900)), V((0.1322,0.028400)), V((0.1322,0.028400)), V((0.1325,0.029000)), ),
    13581: (V((0.1662,0.020200)), V((0.1662,0.020200)), V((0.1682,0.019900)), V((0.1985,0.033800)), ),
    13582: (V((0.1328,0.027500)), V((0.1643,0.020000)), V((0.1649,0.020100)), V((0.1649,0.020100)), ),
    13583: (V((0.1662,0.020200)), V((0.1662,0.020200)), V((0.1649,0.020100)), V((0.1649,0.020100)), ),
    13584: (V((0.2012,0.036564)), V((0.1985,0.033800)), V((0.1682,0.019900)), V((0.2055,0.039800)), ),
    13585: (V((0.1322,0.028400)), V((0.1643,0.020000)), V((0.1328,0.027500)), V((0.1322,0.028400)), ),
    13586: (V((0.2030,0.033683)), V((0.2047,0.042493)), V((0.2042,0.040511)), V((0.2055,0.039800)), ),
    13587: (V((0.1148,0.046900)), V((0.0816,0.049567)), V((0.1298,0.030456)), V((0.1310,0.028800)), ),
    13588: (V((0.1649,0.020100)), V((0.1643,0.020000)), V((0.1682,0.019900)), V((0.1662,0.020200)), ),
    13589: (V((0.0551,0.051255)), V((0.0503,0.052355)), V((0.1682,0.019900)), V((0.1643,0.020000)), ),
    13590: (V((0.0551,0.051255)), V((0.1310,0.028800)), V((0.1298,0.030456)), V((0.0650,0.048927)), ),
    13591: (V((0.0543,0.063618)), V((0.0556,0.052355)), V((0.0506,0.052083)), V((0.0401,0.068524)), ),
    13592: (V((0.0974,0.150707)), V((0.1025,0.146786)), V((0.1110,0.157687)), V((0.1078,0.161587)), ),
    13593: (V((0.3003,0.766334)), V((0.2782,0.763821)), V((0.2848,0.749628)), V((0.3030,0.750769)), ),
    13594: (V((0.2782,0.763821)), V((0.2649,0.761587)), V((0.2713,0.747165)), V((0.2848,0.749628)), ),
    13595: (V((0.2649,0.761587)), V((0.2524,0.757746)), V((0.2587,0.743598)), V((0.2713,0.747165)), ),
    13596: (V((0.2524,0.757746)), V((0.2404,0.748376)), V((0.2470,0.736109)), V((0.2587,0.743598)), ),
    13597: (V((0.1819,0.889348)), V((0.1750,0.892721)), V((0.1716,0.881950)), V((0.1780,0.878895)), ),
    13598: (V((0.1855,0.900938)), V((0.1785,0.903557)), V((0.1750,0.892721)), V((0.1819,0.889348)), ),
    13599: (V((0.1803,0.856693)), V((0.1804,0.852230)), V((0.1928,0.856838)), V((0.1868,0.861967)), ),
    13600: (V((0.1928,0.856838)), V((0.1993,0.865217)), V((0.1925,0.870962)), V((0.1868,0.861967)), ),
    13601: (V((0.3250,0.765121)), V((0.3251,0.752023)), V((0.3401,0.751994)), V((0.3401,0.766020)), ),
    13602: (V((0.3066,0.740151)), V((0.2907,0.738529)), V((0.2952,0.728074)), V((0.3092,0.729813)), ),
    13603: (V((0.2907,0.738529)), V((0.2776,0.735920)), V((0.2824,0.725764)), V((0.2952,0.728074)), ),
    13604: (V((0.2776,0.735920)), V((0.2645,0.731724)), V((0.2702,0.721935)), V((0.2824,0.725764)), ),
    13605: (V((0.2645,0.731724)), V((0.2524,0.727251)), V((0.2581,0.718086)), V((0.2702,0.721935)), ),
    13606: (V((0.3251,0.741545)), V((0.3066,0.740151)), V((0.3092,0.729813)), V((0.3250,0.731569)), ),
    13607: (V((0.2505,0.814061)), V((0.2591,0.820527)), V((0.2543,0.828786)), V((0.2450,0.822796)), ),
    13608: (V((0.2450,0.822796)), V((0.2543,0.828786)), V((0.2486,0.836573)), V((0.2393,0.832453)), ),
    13609: (V((0.2393,0.832453)), V((0.2486,0.836573)), V((0.2411,0.848707)), V((0.2327,0.843547)), ),
    13610: (V((0.1967,0.880383)), V((0.1896,0.884912)), V((0.1859,0.875081)), V((0.1925,0.870962)), ),
    13611: (V((0.2080,0.660627)), V((0.2082,0.653607)), V((0.2194,0.654861)), V((0.2184,0.662040)), ),
    13612: (V((0.2031,0.893367)), V((0.1933,0.897851)), V((0.1896,0.884912)), V((0.1967,0.880383)), ),
    13613: (V((0.2549,0.802328)), V((0.2657,0.809033)), V((0.2591,0.820527)), V((0.2505,0.814061)), ),
    13614: (V((0.2396,0.807274)), V((0.2505,0.814061)), V((0.2450,0.822796)), V((0.2358,0.816389)), ),
    13615: (V((0.2358,0.816389)), V((0.2450,0.822796)), V((0.2393,0.832453)), V((0.2304,0.825998)), ),
    13616: (V((0.2304,0.825998)), V((0.2393,0.832453)), V((0.2327,0.843547)), V((0.2260,0.834920)), ),
    13617: (V((0.2261,0.800885)), V((0.2396,0.807274)), V((0.2358,0.816389)), V((0.2229,0.809403)), ),
    13618: (V((0.2018,0.700736)), V((0.2035,0.695793)), V((0.2135,0.697623)), V((0.2103,0.702832)), ),
    13619: (V((0.2229,0.809403)), V((0.2358,0.816389)), V((0.2304,0.825998)), V((0.2195,0.816900)), ),
    13620: (V((0.2195,0.816900)), V((0.2304,0.825998)), V((0.2260,0.834920)), V((0.2171,0.825178)), ),
    13621: (V((0.2130,0.795045)), V((0.2261,0.800885)), V((0.2229,0.809403)), V((0.2101,0.803691)), ),
    13622: (V((0.2101,0.803691)), V((0.2229,0.809403)), V((0.2195,0.816900)), V((0.2086,0.812450)), ),
    13623: (V((0.2086,0.812450)), V((0.2195,0.816900)), V((0.2171,0.825178)), V((0.2069,0.821440)), ),
    13624: (V((0.1717,0.667696)), V((0.1721,0.662818)), V((0.1803,0.663646)), V((0.1801,0.668685)), ),
    13625: (V((0.1988,0.790280)), V((0.2130,0.795045)), V((0.2101,0.803691)), V((0.1972,0.799416)), ),
    13626: (V((0.1972,0.799416)), V((0.2101,0.803691)), V((0.2086,0.812450)), V((0.1961,0.808270)), ),
    13627: (V((0.1961,0.808270)), V((0.2086,0.812450)), V((0.2069,0.821440)), V((0.1943,0.817137)), ),
    13628: (V((0.2371,0.729951)), V((0.2415,0.722135)), V((0.2524,0.727251)), V((0.2470,0.736109)), ),
    13629: (V((0.1755,0.783775)), V((0.1851,0.786347)), V((0.1836,0.795448)), V((0.1738,0.793038)), ),
    13630: (V((0.2002,0.707536)), V((0.2031,0.721380)), V((0.1957,0.720984)), V((0.1957,0.707527)), ),
    13631: (V((0.1738,0.793038)), V((0.1836,0.795448)), V((0.1840,0.804205)), V((0.1731,0.800863)), ),
    13632: (V((0.1731,0.800863)), V((0.1840,0.804205)), V((0.1838,0.813921)), V((0.1731,0.809878)), ),
    13633: (V((0.1637,0.780089)), V((0.1755,0.783775)), V((0.1738,0.793038)), V((0.1616,0.789548)), ),
    13634: (V((0.1957,0.707527)), V((0.1957,0.720984)), V((0.1876,0.719730)), V((0.1890,0.706336)), ),
    13635: (V((0.1616,0.789548)), V((0.1738,0.793038)), V((0.1731,0.800863)), V((0.1604,0.797466)), ),
    13636: (V((0.1604,0.797466)), V((0.1731,0.800863)), V((0.1731,0.809878)), V((0.1602,0.805344)), ),
    13637: (V((0.2645,0.731724)), V((0.2587,0.743598)), V((0.2470,0.736109)), V((0.2524,0.727251)), ),
    13638: (V((0.2587,0.743598)), V((0.2645,0.731724)), V((0.2776,0.735920)), V((0.2713,0.747165)), ),
    13639: (V((0.2713,0.747165)), V((0.2776,0.735920)), V((0.2907,0.738529)), V((0.2848,0.749628)), ),
    13640: (V((0.2804,0.697979)), V((0.2777,0.704762)), V((0.2668,0.701133)), V((0.2692,0.694143)), ),
    13641: (V((0.2848,0.749628)), V((0.2907,0.738529)), V((0.3066,0.740151)), V((0.3030,0.750769)), ),
    13642: (V((0.2404,0.748376)), V((0.2295,0.740258)), V((0.2371,0.729951)), V((0.2470,0.736109)), ),
    13643: (V((0.3251,0.752023)), V((0.3251,0.741545)), V((0.3401,0.741976)), V((0.3401,0.751994)), ),
    13644: (V((0.2524,0.727251)), V((0.2415,0.722135)), V((0.2457,0.713548)), V((0.2581,0.718086)), ),
    13645: (V((0.2444,0.796597)), V((0.2549,0.802328)), V((0.2505,0.814061)), V((0.2396,0.807274)), ),
    13646: (V((0.2315,0.790814)), V((0.2444,0.796597)), V((0.2396,0.807274)), V((0.2261,0.800885)), ),
    13647: (V((0.2261,0.800885)), V((0.2130,0.795045)), V((0.2172,0.785374)), V((0.2315,0.790814)), ),
    13648: (V((0.2027,0.779616)), V((0.2172,0.785374)), V((0.2130,0.795045)), V((0.1988,0.790280)), ),
    13649: (V((0.1798,0.770539)), V((0.1893,0.773564)), V((0.1851,0.786347)), V((0.1755,0.783775)), ),
    13650: (V((0.1755,0.783775)), V((0.1637,0.780089)), V((0.1682,0.766248)), V((0.1798,0.770539)), ),
    13651: (V((0.1804,0.852230)), V((0.1961,0.843806)), V((0.2034,0.849405)), V((0.1928,0.856838)), ),
    13652: (V((0.3263,0.704864)), V((0.3258,0.712956)), V((0.3136,0.712255)), V((0.3153,0.704920)), ),
    13653: (V((0.3153,0.704920)), V((0.3136,0.712255)), V((0.3009,0.710597)), V((0.3027,0.704145)), ),
    13654: (V((0.3027,0.704145)), V((0.3009,0.710597)), V((0.2878,0.707808)), V((0.2911,0.701238)), ),
    13655: (V((0.2911,0.701238)), V((0.2878,0.707808)), V((0.2777,0.704762)), V((0.2804,0.697979)), ),
    13656: (V((0.1789,0.703232)), V((0.1767,0.717055)), V((0.1619,0.713353)), V((0.1665,0.697645)), ),
    13657: (V((0.1378,0.780999)), V((0.1486,0.784932)), V((0.1476,0.792874)), V((0.1365,0.789459)), ),
    13658: (V((0.1365,0.789459)), V((0.1476,0.792874)), V((0.1462,0.800335)), V((0.1348,0.796558)), ),
    13659: (V((0.1437,0.757769)), V((0.1551,0.762285)), V((0.1509,0.775036)), V((0.1395,0.771940)), ),
    13660: (V((0.1584,0.874440)), V((0.1681,0.872037)), V((0.1716,0.881950)), V((0.1621,0.885587)), ),
    13661: (V((0.1395,0.771940)), V((0.1509,0.775036)), V((0.1486,0.784932)), V((0.1378,0.780999)), ),
    13662: (V((0.1268,0.785596)), V((0.1365,0.789459)), V((0.1348,0.796558)), V((0.1253,0.792610)), ),
    13663: (V((0.1335,0.755074)), V((0.1437,0.757769)), V((0.1395,0.771940)), V((0.1300,0.768522)), ),
    13664: (V((0.1300,0.768522)), V((0.1395,0.771940)), V((0.1378,0.780999)), V((0.1285,0.777155)), ),
    13665: (V((0.1665,0.697645)), V((0.1619,0.713353)), V((0.1504,0.710222)), V((0.1572,0.695458)), ),
    13666: (V((0.1285,0.777155)), V((0.1378,0.780999)), V((0.1365,0.789459)), V((0.1268,0.785596)), ),
    13667: (V((0.1719,0.669951)), V((0.1717,0.667696)), V((0.1801,0.668685)), V((0.1800,0.671547)), ),
    13668: (V((0.1800,0.671547)), V((0.1801,0.668685)), V((0.1881,0.669872)), V((0.1878,0.673057)), ),
    13669: (V((0.1978,0.665527)), V((0.1971,0.671129)), V((0.1881,0.669872)), V((0.1890,0.664595)), ),
    13670: (V((0.2044,0.677993)), V((0.2066,0.672535)), V((0.2168,0.673844)), V((0.2169,0.679669)), ),
    13671: (V((0.2716,0.816477)), V((0.2644,0.826415)), V((0.2591,0.820527)), V((0.2657,0.809033)), ),
    13672: (V((0.2590,0.833525)), V((0.2530,0.841986)), V((0.2486,0.836573)), V((0.2543,0.828786)), ),
    13673: (V((0.3312,0.664695)), V((0.3319,0.649261)), V((0.3401,0.649536)), V((0.3401,0.665634)), ),
    13674: (V((0.3250,0.765121)), V((0.3401,0.766020)), V((0.3401,0.776801)), V((0.3247,0.776830)), ),
    13675: (V((0.1181,0.781200)), V((0.1268,0.785596)), V((0.1253,0.792610)), V((0.1160,0.788251)), ),
    13676: (V((0.1249,0.752454)), V((0.1335,0.755074)), V((0.1300,0.768522)), V((0.1219,0.765095)), ),
    13677: (V((0.2692,0.694143)), V((0.2668,0.701133)), V((0.2533,0.695078)), V((0.2546,0.689342)), ),
    13678: (V((0.1978,0.665527)), V((0.1985,0.659603)), V((0.2080,0.660627)), V((0.2075,0.666670)), ),
    13679: (V((0.1219,0.765095)), V((0.1300,0.768522)), V((0.1285,0.777155)), V((0.1198,0.773440)), ),
    13680: (V((0.1486,0.692672)), V((0.1572,0.695458)), V((0.1504,0.710222)), V((0.1410,0.708159)), ),
    13681: (V((0.1198,0.773440)), V((0.1285,0.777155)), V((0.1268,0.785596)), V((0.1181,0.781200)), ),
    13682: (V((0.1971,0.671129)), V((0.1978,0.665527)), V((0.2075,0.666670)), V((0.2066,0.672535)), ),
    13683: (V((0.1810,0.866051)), V((0.1747,0.869411)), V((0.1715,0.862361)), V((0.1765,0.860107)), ),
    13684: (V((0.1922,0.416903)), V((0.1824,0.418082)), V((0.1810,0.399791)), V((0.1900,0.399316)), ),
    13685: (V((0.2046,0.690264)), V((0.2051,0.684138)), V((0.2164,0.685531)), V((0.2154,0.691719)), ),
    13686: (V((0.7541,0.896646)), V((0.7703,0.893406)), V((0.7717,0.901075)), V((0.7550,0.906152)), ),
    13687: (V((0.0119,0.724004)), V((0.0265,0.733769)), V((0.0238,0.739179)), V((0.0090,0.728292)), ),
    13688: (V((0.0265,0.733769)), V((0.0378,0.742338)), V((0.0346,0.749063)), V((0.0238,0.739179)), ),
    13689: (V((0.0465,0.759905)), V((0.0346,0.749063)), V((0.0378,0.742338)), V((0.0498,0.751661)), ),
    13690: (V((0.0952,0.752750)), V((0.1040,0.757899)), V((0.0995,0.764813)), V((0.0906,0.759821)), ),
    13691: (V((0.1203,0.687581)), V((0.1280,0.687339)), V((0.1238,0.702244)), V((0.1153,0.700303)), ),
    13692: (V((0.0906,0.759821)), V((0.0995,0.764813)), V((0.0953,0.770725)), V((0.0873,0.765850)), ),
    13693: (V((0.0873,0.765850)), V((0.0953,0.770725)), V((0.0922,0.776168)), V((0.0845,0.771558)), ),
    13694: (V((0.1021,0.745085)), V((0.1111,0.747959)), V((0.1040,0.757899)), V((0.0952,0.752750)), ),
    13695: (V((0.0498,0.751661)), V((0.0625,0.759795)), V((0.0601,0.767843)), V((0.0465,0.759905)), ),
    13696: (V((0.1123,0.814813)), V((0.1134,0.806414)), V((0.1230,0.811033)), V((0.1224,0.819277)), ),
    13697: (V((0.0625,0.759795)), V((0.0746,0.766635)), V((0.0723,0.774382)), V((0.0601,0.767843)), ),
    13698: (V((0.1546,0.208059)), V((0.1596,0.231831)), V((0.1504,0.233894)), V((0.1476,0.209308)), ),
    13699: (V((0.1097,0.687202)), V((0.1203,0.687581)), V((0.1153,0.700303)), V((0.1060,0.700354)), ),
    13700: (V((0.0801,0.755669)), V((0.0906,0.759821)), V((0.0873,0.765850)), V((0.0773,0.761122)), ),
    13701: (V((0.0773,0.761122)), V((0.0873,0.765850)), V((0.0845,0.771558)), V((0.0746,0.766635)), ),
    13702: (V((0.0903,0.742483)), V((0.1021,0.745085)), V((0.0952,0.752750)), V((0.0839,0.750157)), ),
    13703: (V((0.0723,0.774382)), V((0.0746,0.766635)), V((0.0845,0.771558)), V((0.0817,0.779055)), ),
    13704: (V((0.1242,0.801737)), V((0.1230,0.811033)), V((0.1134,0.806414)), V((0.1149,0.797165)), ),
    13705: (V((0.0817,0.779055)), V((0.0845,0.771558)), V((0.0922,0.776168)), V((0.0895,0.783856)), ),
    13706: (V((0.1596,0.231831)), V((0.1634,0.250367)), V((0.1529,0.251138)), V((0.1504,0.233894)), ),
    13707: (V((0.1634,0.250367)), V((0.1667,0.265702)), V((0.1559,0.266416)), V((0.1529,0.251138)), ),
    13708: (V((0.0839,0.750157)), V((0.0952,0.752750)), V((0.0906,0.759821)), V((0.0801,0.755669)), ),
    13709: (V((0.0646,0.754968)), V((0.0773,0.761122)), V((0.0746,0.766635)), V((0.0625,0.759795)), ),
    13710: (V((0.0764,0.737792)), V((0.0903,0.742483)), V((0.0839,0.750157)), V((0.0712,0.744132)), ),
    13711: (V((0.1349,0.814906)), V((0.1328,0.822324)), V((0.1224,0.819277)), V((0.1230,0.811033)), ),
    13712: (V((0.1280,0.687339)), V((0.1381,0.688729)), V((0.1328,0.704767)), V((0.1238,0.702244)), ),
    13713: (V((0.1667,0.265702)), V((0.1699,0.279830)), V((0.1586,0.281780)), V((0.1559,0.266416)), ),
    13714: (V((0.0712,0.744132)), V((0.0839,0.750157)), V((0.0801,0.755669)), V((0.0678,0.749439)), ),
    13715: (V((0.0952,0.685709)), V((0.1097,0.687202)), V((0.1060,0.700354)), V((0.0921,0.699782)), ),
    13716: (V((0.0678,0.749439)), V((0.0801,0.755669)), V((0.0773,0.761122)), V((0.0646,0.754968)), ),
    13717: (V((0.0620,0.730383)), V((0.0764,0.737792)), V((0.0712,0.744132)), V((0.0573,0.736949)), ),
    13718: (V((0.1230,0.811033)), V((0.1242,0.801737)), V((0.1350,0.805370)), V((0.1349,0.814906)), ),
    13719: (V((0.1744,0.304196)), V((0.1757,0.315343)), V((0.1650,0.315818)), V((0.1638,0.306278)), ),
    13720: (V((0.0573,0.736949)), V((0.0712,0.744132)), V((0.0678,0.749439)), V((0.0546,0.741577)), ),
    13721: (V((0.0790,0.685500)), V((0.0952,0.685709)), V((0.0921,0.699782)), V((0.0772,0.697285)), ),
    13722: (V((0.0546,0.741577)), V((0.0678,0.749439)), V((0.0646,0.754968)), V((0.0520,0.746384)), ),
    13723: (V((0.0520,0.746384)), V((0.0646,0.754968)), V((0.0625,0.759795)), V((0.0498,0.751661)), ),
    13724: (V((0.1328,0.822324)), V((0.1349,0.814906)), V((0.1469,0.819149)), V((0.1461,0.826454)), ),
    13725: (V((0.1149,0.797165)), V((0.1160,0.788251)), V((0.1253,0.792610)), V((0.1242,0.801737)), ),
    13726: (V((0.1757,0.315343)), V((0.1781,0.326332)), V((0.1677,0.326234)), V((0.1650,0.315818)), ),
    13727: (V((0.0440,0.728793)), V((0.0573,0.736949)), V((0.0546,0.741577)), V((0.0418,0.733461)), ),
    13728: (V((0.0629,0.684516)), V((0.0790,0.685500)), V((0.0772,0.697285)), V((0.0627,0.694838)), ),
    13729: (V((0.0418,0.733461)), V((0.0546,0.741577)), V((0.0520,0.746384)), V((0.0395,0.737567)), ),
    13730: (V((0.0395,0.737567)), V((0.0520,0.746384)), V((0.0498,0.751661)), V((0.0378,0.742338)), ),
    13731: (V((0.0481,0.722640)), V((0.0620,0.730383)), V((0.0573,0.736949)), V((0.0440,0.728793)), ),
    13732: (V((0.1242,0.801737)), V((0.1253,0.792610)), V((0.1348,0.796558)), V((0.1350,0.805370)), ),
    13733: (V((0.0324,0.720942)), V((0.0440,0.728793)), V((0.0418,0.733461)), V((0.0307,0.725711)), ),
    13734: (V((0.0511,0.682486)), V((0.0629,0.684516)), V((0.0627,0.694838)), V((0.0502,0.692097)), ),
    13735: (V((0.0307,0.725711)), V((0.0418,0.733461)), V((0.0395,0.737567)), V((0.0286,0.728913)), ),
    13736: (V((0.0286,0.728913)), V((0.0395,0.737567)), V((0.0378,0.742338)), V((0.0265,0.733769)), ),
    13737: (V((0.0360,0.715752)), V((0.0481,0.722640)), V((0.0440,0.728793)), V((0.0324,0.720942)), ),
    13738: (V((0.1350,0.805370)), V((0.1348,0.796558)), V((0.1462,0.800335)), V((0.1469,0.809720)), ),
    13739: (V((0.1349,0.814906)), V((0.1350,0.805370)), V((0.1469,0.809720)), V((0.1469,0.819149)), ),
    13740: (V((0.1789,0.703232)), V((0.1890,0.706336)), V((0.1876,0.719730)), V((0.1767,0.717055)), ),
    13741: (V((0.1687,0.830459)), V((0.1636,0.835213)), V((0.1564,0.830915)), V((0.1595,0.825436)), ),
    13742: (V((0.0183,0.712264)), V((0.0324,0.720942)), V((0.0307,0.725711)), V((0.0168,0.715447)), ),
    13743: (V((0.0329,0.680974)), V((0.0511,0.682486)), V((0.0502,0.692097)), V((0.0315,0.685740)), ),
    13744: (V((0.0168,0.715447)), V((0.0307,0.725711)), V((0.0286,0.728913)), V((0.0141,0.720030)), ),
    13745: (V((0.0141,0.720030)), V((0.0286,0.728913)), V((0.0265,0.733769)), V((0.0119,0.724004)), ),
    13746: (V((0.0211,0.707307)), V((0.0360,0.715752)), V((0.0324,0.720942)), V((0.0183,0.712264)), ),
    13747: (V((0.1595,0.825436)), V((0.1564,0.830915)), V((0.1461,0.826454)), V((0.1469,0.819149)), ),
    13748: (V((0.1469,0.819149)), V((0.1469,0.809720)), V((0.1610,0.815442)), V((0.1595,0.825436)), ),
    13749: (V((0.1731,0.809878)), V((0.1725,0.820025)), V((0.1610,0.815442)), V((0.1602,0.805344)), ),
    13750: (V((0.1784,0.834770)), V((0.1691,0.838626)), V((0.1636,0.835213)), V((0.1687,0.830459)), ),
    13751: (V((0.7753,0.807498)), V((0.7793,0.818823)), V((0.7760,0.822628)), V((0.7549,0.802302)), ),
    13752: (V((0.7528,0.875239)), V((0.7690,0.875778)), V((0.7696,0.885400)), V((0.7540,0.887863)), ),
    13753: (V((0.7540,0.887863)), V((0.7696,0.885400)), V((0.7703,0.893406)), V((0.7541,0.896646)), ),
    13754: (V((0.7530,0.856638)), V((0.7687,0.858357)), V((0.7687,0.869036)), V((0.7527,0.867109)), ),
    13755: (V((0.1725,0.820025)), V((0.1731,0.809878)), V((0.1838,0.813921)), V((0.1825,0.824663)), ),
    13756: (V((0.1462,0.800335)), V((0.1602,0.805344)), V((0.1610,0.815442)), V((0.1469,0.809720)), ),
    13757: (V((0.7527,0.867109)), V((0.7687,0.869036)), V((0.7690,0.875778)), V((0.7528,0.875239)), ),
    13758: (V((0.7703,0.836972)), V((0.7691,0.846631)), V((0.7533,0.844930)), V((0.7503,0.825972)), ),
    13759: (V((0.7727,0.828667)), V((0.7703,0.836972)), V((0.7503,0.825972)), V((0.7486,0.810050)), ),
    13760: (V((0.0239,0.701636)), V((0.0266,0.696662)), V((0.0448,0.703863)), V((0.0393,0.711188)), ),
    13761: (V((0.0575,0.708316)), V((0.0521,0.717422)), V((0.0393,0.711188)), V((0.0448,0.703863)), ),
    13762: (V((0.0484,0.697174)), V((0.0448,0.703863)), V((0.0266,0.696662)), V((0.0296,0.691313)), ),
    13763: (V((0.0609,0.700562)), V((0.0575,0.708316)), V((0.0448,0.703863)), V((0.0484,0.697174)), ),
    13764: (V((0.0575,0.708316)), V((0.0609,0.700562)), V((0.0754,0.703647)), V((0.0719,0.712868)), ),
    13765: (V((0.0719,0.712868)), V((0.0668,0.724272)), V((0.0521,0.717422)), V((0.0575,0.708316)), ),
    13766: (V((0.0903,0.706740)), V((0.0874,0.717185)), V((0.0719,0.712868)), V((0.0754,0.703647)), ),
    13767: (V((0.1042,0.709457)), V((0.1009,0.721889)), V((0.0874,0.717185)), V((0.0903,0.706740)), ),
    13768: (V((0.1136,0.710569)), V((0.1087,0.724179)), V((0.1009,0.721889)), V((0.1042,0.709457)), ),
    13769: (V((0.1189,0.712607)), V((0.1172,0.727853)), V((0.1087,0.724179)), V((0.1136,0.710569)), ),
    13770: (V((0.1004,0.800680)), V((0.0998,0.807100)), V((0.0869,0.799501)), V((0.0877,0.793637)), ),
    13771: (V((0.0874,0.717185)), V((0.0820,0.730995)), V((0.0668,0.724272)), V((0.0719,0.712868)), ),
    13772: (V((0.1005,0.789136)), V((0.1004,0.800680)), V((0.0877,0.793637)), V((0.0895,0.783856)), ),
    13773: (V((0.1009,0.721889)), V((0.0959,0.735371)), V((0.0820,0.730995)), V((0.0874,0.717185)), ),
    13774: (V((0.1087,0.724179)), V((0.1054,0.737744)), V((0.0959,0.735371)), V((0.1009,0.721889)), ),
    13775: (V((0.1054,0.737744)), V((0.1087,0.724179)), V((0.1172,0.727853)), V((0.1114,0.739307)), ),
    13776: (V((0.0922,0.776168)), V((0.1026,0.781791)), V((0.1005,0.789136)), V((0.0895,0.783856)), ),
    13777: (V((0.0953,0.770725)), V((0.1056,0.776070)), V((0.1026,0.781791)), V((0.0922,0.776168)), ),
    13778: (V((0.1457,0.720731)), V((0.1411,0.732771)), V((0.1304,0.729093)), V((0.1357,0.717059)), ),
    13779: (V((0.2143,0.868325)), V((0.2054,0.875137)), V((0.1993,0.865217)), V((0.2092,0.857857)), ),
    13780: (V((0.2179,0.878565)), V((0.2106,0.886041)), V((0.2054,0.875137)), V((0.2143,0.868325)), ),
    13781: (V((0.1796,0.339462)), V((0.1814,0.352268)), V((0.1728,0.352893)), V((0.1704,0.340075)), ),
    13782: (V((0.1942,0.433175)), V((0.1839,0.435003)), V((0.1824,0.418082)), V((0.1922,0.416903)), ),
    13783: (V((0.1980,0.458239)), V((0.1985,0.467705)), V((0.1850,0.470148)), V((0.1849,0.460067)), ),
    13784: (V((0.1730,0.499651)), V((0.1705,0.485725)), V((0.1833,0.482240)), V((0.1835,0.495586)), ),
    13785: (V((0.2009,0.576213)), V((0.1984,0.564044)), V((0.2071,0.561665)), V((0.2098,0.574101)), ),
    13786: (V((0.1993,0.653053)), V((0.2000,0.645220)), V((0.2089,0.645612)), V((0.2082,0.653607)), ),
    13787: (V((0.2002,0.636024)), V((0.2006,0.623582)), V((0.2096,0.623044)), V((0.2090,0.635320)), ),
    13788: (V((0.2000,0.645220)), V((0.2002,0.636024)), V((0.2090,0.635320)), V((0.2089,0.645612)), ),
    13789: (V((0.1747,0.869411)), V((0.1681,0.872037)), V((0.1653,0.864551)), V((0.1715,0.862361)), ),
    13790: (V((0.1868,0.861967)), V((0.1810,0.866051)), V((0.1765,0.860107)), V((0.1803,0.856693)), ),
    13791: (V((0.1985,0.659603)), V((0.1993,0.653053)), V((0.2082,0.653607)), V((0.2080,0.660627)), ),
    13792: (V((0.1971,0.674447)), V((0.1971,0.671129)), V((0.2066,0.672535)), V((0.2044,0.677993)), ),
    13793: (V((0.2103,0.702832)), V((0.2027,0.706944)), V((0.2018,0.703805)), V((0.2018,0.700736)), ),
    13794: (V((0.1928,0.856838)), V((0.2034,0.849405)), V((0.2092,0.857857)), V((0.1993,0.865217)), ),
    13795: (V((0.1568,0.724286)), V((0.1514,0.737107)), V((0.1411,0.732771)), V((0.1457,0.720731)), ),
    13796: (V((0.1721,0.727866)), V((0.1658,0.740974)), V((0.1514,0.737107)), V((0.1568,0.724286)), ),
    13797: (V((0.1476,0.792874)), V((0.1604,0.797466)), V((0.1602,0.805344)), V((0.1462,0.800335)), ),
    13798: (V((0.1486,0.784932)), V((0.1616,0.789548)), V((0.1604,0.797466)), V((0.1476,0.792874)), ),
    13799: (V((0.1993,0.732359)), V((0.1961,0.747179)), V((0.1811,0.744308)), V((0.1861,0.729832)), ),
    13800: (V((0.1961,0.747179)), V((0.1993,0.732359)), V((0.2138,0.734292)), V((0.2099,0.750538)), ),
    13801: (V((0.1411,0.732771)), V((0.1369,0.744831)), V((0.1262,0.742789)), V((0.1304,0.729093)), ),
    13802: (V((0.2187,0.754476)), V((0.2099,0.750538)), V((0.2138,0.734292)), V((0.2295,0.740258)), ),
    13803: (V((0.1514,0.737107)), V((0.1476,0.748439)), V((0.1369,0.744831)), V((0.1411,0.732771)), ),
    13804: (V((0.2187,0.754476)), V((0.2295,0.740258)), V((0.2404,0.748376)), V((0.2319,0.762077)), ),
    13805: (V((0.1658,0.740974)), V((0.1596,0.753324)), V((0.1476,0.748439)), V((0.1514,0.737107)), ),
    13806: (V((0.1509,0.775036)), V((0.1637,0.780089)), V((0.1616,0.789548)), V((0.1486,0.784932)), ),
    13807: (V((0.1551,0.762285)), V((0.1682,0.766248)), V((0.1637,0.780089)), V((0.1509,0.775036)), ),
    13808: (V((0.1961,0.747179)), V((0.1854,0.761746)), V((0.1733,0.756968)), V((0.1811,0.744308)), ),
    13809: (V((0.2524,0.757746)), V((0.2445,0.769774)), V((0.2319,0.762077)), V((0.2404,0.748376)), ),
    13810: (V((0.1854,0.761746)), V((0.1961,0.747179)), V((0.2099,0.750538)), V((0.1961,0.764792)), ),
    13811: (V((0.2445,0.769774)), V((0.2524,0.757746)), V((0.2649,0.761587)), V((0.2578,0.773935)), ),
    13812: (V((0.2084,0.769247)), V((0.1961,0.764792)), V((0.2099,0.750538)), V((0.2187,0.754476)), ),
    13813: (V((0.2084,0.769247)), V((0.2187,0.754476)), V((0.2319,0.762077)), V((0.2233,0.775158)), ),
    13814: (V((0.2445,0.769774)), V((0.2369,0.781154)), V((0.2233,0.775158)), V((0.2319,0.762077)), ),
    13815: (V((0.1821,0.651949)), V((0.1833,0.644495)), V((0.1918,0.644924)), V((0.1907,0.652473)), ),
    13816: (V((0.2082,0.653607)), V((0.2089,0.645612)), V((0.2201,0.645684)), V((0.2194,0.654861)), ),
    13817: (V((0.1735,0.651410)), V((0.1747,0.644164)), V((0.1833,0.644495)), V((0.1821,0.651949)), ),
    13818: (V((0.1833,0.644495)), V((0.1848,0.635380)), V((0.1926,0.635760)), V((0.1918,0.644924)), ),
    13819: (V((0.2089,0.645612)), V((0.2090,0.635320)), V((0.2198,0.634923)), V((0.2201,0.645684)), ),
    13820: (V((0.1747,0.644164)), V((0.1767,0.634968)), V((0.1848,0.635380)), V((0.1833,0.644495)), ),
    13821: (V((0.1848,0.635380)), V((0.1860,0.623924)), V((0.1938,0.623986)), V((0.1926,0.635760)), ),
    13822: (V((0.2090,0.635320)), V((0.2096,0.623044)), V((0.2206,0.622152)), V((0.2198,0.634923)), ),
    13823: (V((0.1767,0.634968)), V((0.1789,0.623892)), V((0.1860,0.623924)), V((0.1848,0.635380)), ),
    13824: (V((0.2627,0.626428)), V((0.2784,0.626959)), V((0.2790,0.641922)), V((0.2628,0.639495)), ),
    13825: (V((0.2897,0.659731)), V((0.2907,0.644674)), V((0.3032,0.646731)), V((0.3019,0.663459)), ),
    13826: (V((0.2907,0.644674)), V((0.2911,0.628354)), V((0.3037,0.629312)), V((0.3032,0.646731)), ),
    13827: (V((0.2628,0.639495)), V((0.2790,0.641922)), V((0.2776,0.656466)), V((0.2621,0.652879)), ),
    13828: (V((0.3142,0.647762)), V((0.3148,0.630583)), V((0.3243,0.631068)), V((0.3235,0.648789)), ),
    13829: (V((0.3319,0.649261)), V((0.3323,0.631158)), V((0.3401,0.631002)), V((0.3401,0.649536)), ),
    13830: (V((0.2797,0.672597)), V((0.2762,0.676947)), V((0.2596,0.670067)), V((0.2611,0.662671)), ),
    13831: (V((0.3128,0.662394)), V((0.3142,0.647762)), V((0.3235,0.648789)), V((0.3227,0.663829)), ),
    13832: (V((0.2578,0.773935)), V((0.2649,0.761587)), V((0.2782,0.763821)), V((0.2694,0.776863)), ),
    13833: (V((0.2897,0.659731)), V((0.2776,0.656466)), V((0.2790,0.641922)), V((0.2907,0.644674)), ),
    13834: (V((0.2911,0.628354)), V((0.2907,0.644674)), V((0.2790,0.641922)), V((0.2784,0.626959)), ),
    13835: (V((0.3128,0.662394)), V((0.3019,0.663459)), V((0.3032,0.646731)), V((0.3142,0.647762)), ),
    13836: (V((0.3032,0.646731)), V((0.3037,0.629312)), V((0.3148,0.630583)), V((0.3142,0.647762)), ),
    13837: (V((0.1798,0.610580)), V((0.1800,0.596749)), V((0.1861,0.595526)), V((0.1866,0.610414)), ),
    13838: (V((0.1866,0.610414)), V((0.1861,0.595526)), V((0.1940,0.592339)), V((0.1929,0.610667)), ),
    13839: (V((0.2015,0.608980)), V((0.1929,0.610667)), V((0.1940,0.592339)), V((0.2021,0.590381)), ),
    13840: (V((0.2111,0.589632)), V((0.2111,0.603467)), V((0.2015,0.608980)), V((0.2021,0.590381)), ),
    13841: (V((0.2111,0.603467)), V((0.2111,0.589632)), V((0.2204,0.587784)), V((0.2203,0.602447)), ),
    13842: (V((0.2642,0.606803)), V((0.2645,0.587550)), V((0.2778,0.590276)), V((0.2778,0.608553)), ),
    13843: (V((0.2902,0.590991)), V((0.2911,0.609657)), V((0.2778,0.608553)), V((0.2778,0.590276)), ),
    13844: (V((0.3030,0.591444)), V((0.3033,0.610967)), V((0.2911,0.609657)), V((0.2902,0.590991)), ),
    13845: (V((0.3148,0.591808)), V((0.3150,0.611347)), V((0.3033,0.610967)), V((0.3030,0.591444)), ),
    13846: (V((0.3250,0.592022)), V((0.3248,0.611647)), V((0.3150,0.611347)), V((0.3148,0.591808)), ),
    13847: (V((0.2772,0.574087)), V((0.2766,0.558818)), V((0.2891,0.557858)), V((0.2897,0.573836)), ),
    13848: (V((0.3143,0.573320)), V((0.3139,0.556285)), V((0.3240,0.555388)), V((0.3239,0.573303)), ),
    13849: (V((0.2897,0.573836)), V((0.2891,0.557858)), V((0.3017,0.556932)), V((0.3024,0.573403)), ),
    13850: (V((0.2645,0.573452)), V((0.2648,0.560024)), V((0.2766,0.558818)), V((0.2772,0.574087)), ),
    13851: (V((0.3024,0.573403)), V((0.3017,0.556932)), V((0.3139,0.556285)), V((0.3143,0.573320)), ),
    13852: (V((0.2645,0.587550)), V((0.2645,0.573452)), V((0.2772,0.574087)), V((0.2778,0.590276)), ),
    13853: (V((0.1784,0.583885)), V((0.1768,0.573246)), V((0.1840,0.570020)), V((0.1861,0.581072)), ),
    13854: (V((0.1861,0.581072)), V((0.1840,0.570020)), V((0.1908,0.566792)), V((0.1925,0.578575)), ),
    13855: (V((0.2897,0.573836)), V((0.2902,0.590991)), V((0.2778,0.590276)), V((0.2772,0.574087)), ),
    13856: (V((0.2098,0.574101)), V((0.2071,0.561665)), V((0.2188,0.560057)), V((0.2200,0.572584)), ),
    13857: (V((0.1471,0.508423)), V((0.1361,0.493195)), V((0.1440,0.488330)), V((0.1540,0.505872)), ),
    13858: (V((0.1540,0.505872)), V((0.1440,0.488330)), V((0.1587,0.489504)), V((0.1627,0.503464)), ),
    13859: (V((0.1835,0.495586)), V((0.1833,0.482240)), V((0.1983,0.477934)), V((0.1987,0.489965)), ),
    13860: (V((0.1402,0.526257)), V((0.1346,0.528912)), V((0.1252,0.513748)), V((0.1328,0.512712)), ),
    13861: (V((0.1537,0.522120)), V((0.1465,0.524661)), V((0.1392,0.510582)), V((0.1471,0.508423)), ),
    13862: (V((0.1537,0.522120)), V((0.1471,0.508423)), V((0.1540,0.505872)), V((0.1602,0.519953)), ),
    13863: (V((0.3320,0.494192)), V((0.3401,0.492831)), V((0.3401,0.511954)), V((0.3315,0.513331)), ),
    13864: (V((0.3334,0.477758)), V((0.3399,0.476496)), V((0.3401,0.492831)), V((0.3320,0.494192)), ),
    13865: (V((0.1602,0.519953)), V((0.1540,0.505872)), V((0.1627,0.503464)), V((0.1685,0.516686)), ),
    13866: (V((0.1769,0.513093)), V((0.1685,0.516686)), V((0.1627,0.503464)), V((0.1730,0.499651)), ),
    13867: (V((0.1580,0.569984)), V((0.1534,0.571636)), V((0.1484,0.558907)), V((0.1522,0.556694)), ),
    13868: (V((0.1713,0.561099)), V((0.1644,0.565114)), V((0.1594,0.552953)), V((0.1660,0.549053)), ),
    13869: (V((0.1713,0.561099)), V((0.1660,0.549053)), V((0.1728,0.545396)), V((0.1784,0.557306)), ),
    13870: (V((0.1784,0.557306)), V((0.1728,0.545396)), V((0.1801,0.541762)), V((0.1857,0.554093)), ),
    13871: (V((0.1937,0.551324)), V((0.1857,0.554093)), V((0.1801,0.541762)), V((0.1880,0.538893)), ),
    13872: (V((0.1967,0.536479)), V((0.2021,0.549236)), V((0.1937,0.551324)), V((0.1880,0.538893)), ),
    13873: (V((0.2021,0.549236)), V((0.1967,0.536479)), V((0.2107,0.534204)), V((0.2147,0.547516)), ),
    13874: (V((0.3240,0.497079)), V((0.3231,0.516146)), V((0.3138,0.519830)), V((0.3143,0.499988)), ),
    13875: (V((0.3143,0.499988)), V((0.3138,0.519830)), V((0.3008,0.521619)), V((0.2998,0.501977)), ),
    13876: (V((0.2998,0.501977)), V((0.3008,0.521619)), V((0.2875,0.523273)), V((0.2871,0.504917)), ),
    13877: (V((0.2871,0.504917)), V((0.2875,0.523273)), V((0.2746,0.524892)), V((0.2737,0.507054)), ),
    13878: (V((0.2588,0.508941)), V((0.2737,0.507054)), V((0.2746,0.524892)), V((0.2601,0.528172)), ),
    13879: (V((0.3268,0.478798)), V((0.3240,0.497079)), V((0.3143,0.499988)), V((0.3148,0.480300)), ),
    13880: (V((0.3148,0.480300)), V((0.3143,0.499988)), V((0.2998,0.501977)), V((0.3000,0.484800)), ),
    13881: (V((0.3000,0.484800)), V((0.2998,0.501977)), V((0.2871,0.504917)), V((0.2858,0.487800)), ),
    13882: (V((0.2858,0.487800)), V((0.2871,0.504917)), V((0.2737,0.507054)), V((0.2721,0.489438)), ),
    13883: (V((0.2737,0.507054)), V((0.2588,0.508941)), V((0.2560,0.491094)), V((0.2721,0.489438)), ),
    13884: (V((0.1835,0.495586)), V((0.1864,0.509380)), V((0.1769,0.513093)), V((0.1730,0.499651)), ),
    13885: (V((0.1864,0.509380)), V((0.1835,0.495586)), V((0.1987,0.489965)), V((0.2020,0.504084)), ),
    13886: (V((0.1632,0.579893)), V((0.1585,0.583806)), V((0.1534,0.571636)), V((0.1580,0.569984)), ),
    13887: (V((0.1768,0.573246)), V((0.1694,0.576772)), V((0.1644,0.565114)), V((0.1713,0.561099)), ),
    13888: (V((0.1768,0.573246)), V((0.1713,0.561099)), V((0.1784,0.557306)), V((0.1840,0.570020)), ),
    13889: (V((0.1919,0.828867)), V((0.1943,0.817137)), V((0.2069,0.821440)), V((0.2026,0.832776)), ),
    13890: (V((0.1840,0.570020)), V((0.1784,0.557306)), V((0.1857,0.554093)), V((0.1908,0.566792)), ),
    13891: (V((0.1984,0.564044)), V((0.1908,0.566792)), V((0.1857,0.554093)), V((0.1937,0.551324)), ),
    13892: (V((0.2021,0.549236)), V((0.2071,0.561665)), V((0.1984,0.564044)), V((0.1937,0.551324)), ),
    13893: (V((0.2071,0.561665)), V((0.2021,0.549236)), V((0.2147,0.547516)), V((0.2188,0.560057)), ),
    13894: (V((0.7486,0.810050)), V((0.7549,0.802302)), V((0.7760,0.822628)), V((0.7727,0.828667)), ),
    13895: (V((0.0296,0.691313)), V((0.0315,0.685740)), V((0.0502,0.692097)), V((0.0484,0.697174)), ),
    13896: (V((0.0484,0.697174)), V((0.0502,0.692097)), V((0.0627,0.694838)), V((0.0609,0.700562)), ),
    13897: (V((0.0609,0.700562)), V((0.0627,0.694838)), V((0.0772,0.697285)), V((0.0754,0.703647)), ),
    13898: (V((0.0921,0.699782)), V((0.0903,0.706740)), V((0.0754,0.703647)), V((0.0772,0.697285)), ),
    13899: (V((0.1060,0.700354)), V((0.1042,0.709457)), V((0.0903,0.706740)), V((0.0921,0.699782)), ),
    13900: (V((0.2026,0.832776)), V((0.2069,0.821440)), V((0.2171,0.825178)), V((0.2115,0.838264)), ),
    13901: (V((0.1925,0.870962)), V((0.1859,0.875081)), V((0.1810,0.866051)), V((0.1868,0.861967)), ),
    13902: (V((0.1907,0.652473)), V((0.1918,0.644924)), V((0.2000,0.645220)), V((0.1993,0.653053)), ),
    13903: (V((0.1918,0.644924)), V((0.1926,0.635760)), V((0.2002,0.636024)), V((0.2000,0.645220)), ),
    13904: (V((0.1926,0.635760)), V((0.1938,0.623986)), V((0.2006,0.623582)), V((0.2002,0.636024)), ),
    13905: (V((0.3325,0.591689)), V((0.3323,0.611486)), V((0.3248,0.611647)), V((0.3250,0.592022)), ),
    13906: (V((0.3024,0.573403)), V((0.3030,0.591444)), V((0.2902,0.590991)), V((0.2897,0.573836)), ),
    13907: (V((0.3143,0.573320)), V((0.3148,0.591808)), V((0.3030,0.591444)), V((0.3024,0.573403)), ),
    13908: (V((0.1925,0.578575)), V((0.1908,0.566792)), V((0.1984,0.564044)), V((0.2009,0.576213)), ),
    13909: (V((0.1967,0.536479)), V((0.1918,0.522923)), V((0.2062,0.518877)), V((0.2107,0.534204)), ),
    13910: (V((0.1918,0.522923)), V((0.1864,0.509380)), V((0.2020,0.504084)), V((0.2062,0.518877)), ),
    13911: (V((0.1705,0.485725)), V((0.1730,0.499651)), V((0.1627,0.503464)), V((0.1587,0.489504)), ),
    13912: (V((0.2933,0.458631)), V((0.2975,0.471426)), V((0.2828,0.475067)), V((0.2789,0.461968)), ),
    13913: (V((0.2975,0.471426)), V((0.2933,0.458631)), V((0.3064,0.454110)), V((0.3148,0.465748)), ),
    13914: (V((0.2544,0.477814)), V((0.2522,0.465715)), V((0.2647,0.464467)), V((0.2698,0.476780)), ),
    13915: (V((0.2789,0.461968)), V((0.2828,0.475067)), V((0.2698,0.476780)), V((0.2647,0.464467)), ),
    13916: (V((0.3255,0.439591)), V((0.3285,0.443458)), V((0.3219,0.455587)), V((0.3173,0.447298)), ),
    13917: (V((0.3297,0.432242)), V((0.3316,0.435363)), V((0.3285,0.443458)), V((0.3255,0.439591)), ),
    13918: (V((0.1287,0.482212)), V((0.1338,0.474936)), V((0.1440,0.488330)), V((0.1361,0.493195)), ),
    13919: (V((0.1619,0.470645)), V((0.1634,0.458566)), V((0.1745,0.459903)), V((0.1728,0.471446)), ),
    13920: (V((0.1849,0.460067)), V((0.1850,0.470148)), V((0.1728,0.471446)), V((0.1745,0.459903)), ),
    13921: (V((0.2830,0.433360)), V((0.2881,0.445994)), V((0.2753,0.450803)), V((0.2709,0.438690)), ),
    13922: (V((0.1042,0.709457)), V((0.1060,0.700354)), V((0.1153,0.700303)), V((0.1136,0.710569)), ),
    13923: (V((0.1496,0.467767)), V((0.1525,0.454079)), V((0.1634,0.458566)), V((0.1619,0.470645)), ),
    13924: (V((0.3113,0.414927)), V((0.3187,0.427784)), V((0.3095,0.434130)), V((0.3032,0.421764)), ),
    13925: (V((0.1136,0.710569)), V((0.1153,0.700303)), V((0.1238,0.702244)), V((0.1189,0.712607)), ),
    13926: (V((0.2709,0.438690)), V((0.2753,0.450803)), V((0.2633,0.453592)), V((0.2596,0.443439)), ),
    13927: (V((0.3204,0.409301)), V((0.3251,0.421391)), V((0.3187,0.427784)), V((0.3113,0.414927)), ),
    13928: (V((0.2881,0.445994)), V((0.2830,0.433360)), V((0.2933,0.428118)), V((0.2995,0.441249)), ),
    13929: (V((0.2492,0.456519)), V((0.2470,0.447734)), V((0.2596,0.443439)), V((0.2633,0.453592)), ),
    13930: (V((0.1384,0.461601)), V((0.1426,0.449759)), V((0.1525,0.454079)), V((0.1496,0.467767)), ),
    13931: (V((0.3005,0.392471)), V((0.2922,0.398466)), V((0.2850,0.384082)), V((0.2938,0.378260)), ),
    13932: (V((0.3090,0.387960)), V((0.3005,0.392471)), V((0.2938,0.378260)), V((0.3021,0.374201)), ),
    13933: (V((0.3090,0.387960)), V((0.3021,0.374201)), V((0.3102,0.370113)), V((0.3172,0.383770)), ),
    13934: (V((0.1839,0.435003)), V((0.1727,0.434931)), V((0.1725,0.417825)), V((0.1824,0.418082)), ),
    13935: (V((0.1328,0.704767)), V((0.1274,0.714009)), V((0.1189,0.712607)), V((0.1238,0.702244)), ),
    13936: (V((0.1357,0.717059)), V((0.1274,0.714009)), V((0.1328,0.704767)), V((0.1410,0.708159)), ),
    13937: (V((0.1504,0.710222)), V((0.1457,0.720731)), V((0.1357,0.717059)), V((0.1410,0.708159)), ),
    13938: (V((0.1457,0.720731)), V((0.1504,0.710222)), V((0.1619,0.713353)), V((0.1568,0.724286)), ),
    13939: (V((0.2403,0.325281)), V((0.2434,0.337251)), V((0.2361,0.340845)), V((0.2325,0.327934)), ),
    13940: (V((0.1767,0.717055)), V((0.1721,0.727866)), V((0.1568,0.724286)), V((0.1619,0.713353)), ),
    13941: (V((0.1475,0.354591)), V((0.1444,0.343868)), V((0.1522,0.342074)), V((0.1557,0.354187)), ),
    13942: (V((0.2635,0.311117)), V((0.2680,0.321606)), V((0.2602,0.327186)), V((0.2557,0.316643)), ),
    13943: (V((0.1876,0.719730)), V((0.1861,0.729832)), V((0.1721,0.727866)), V((0.1767,0.717055)), ),
    13944: (V((0.2325,0.327934)), V((0.2361,0.340845)), V((0.2281,0.343547)), V((0.2254,0.329816)), ),
    13945: (V((0.2719,0.307284)), V((0.2755,0.317270)), V((0.2680,0.321606)), V((0.2635,0.311117)), ),
    13946: (V((0.2434,0.337251)), V((0.2403,0.325281)), V((0.2470,0.322564)), V((0.2510,0.333220)), ),
    13947: (V((0.2188,0.345669)), V((0.2158,0.332929)), V((0.2254,0.329816)), V((0.2281,0.343547)), ),
    13948: (V((0.1385,0.355212)), V((0.1356,0.345835)), V((0.1444,0.343868)), V((0.1475,0.354591)), ),
    13949: (V((0.1557,0.354187)), V((0.1522,0.342074)), V((0.1610,0.341322)), V((0.1639,0.353223)), ),
    13950: (V((0.1704,0.340075)), V((0.1728,0.352893)), V((0.1639,0.353223)), V((0.1610,0.341322)), ),
    13951: (V((0.2403,0.325281)), V((0.2361,0.312762)), V((0.2424,0.308549)), V((0.2470,0.322564)), ),
    13952: (V((0.2424,0.308549)), V((0.2505,0.302107)), V((0.2557,0.316643)), V((0.2470,0.322564)), ),
    13953: (V((0.2582,0.296734)), V((0.2635,0.311117)), V((0.2557,0.316643)), V((0.2505,0.302107)), ),
    13954: (V((0.2652,0.291816)), V((0.2719,0.307284)), V((0.2635,0.311117)), V((0.2582,0.296734)), ),
    13955: (V((0.2800,0.303758)), V((0.2719,0.307284)), V((0.2652,0.291816)), V((0.2731,0.287311)), ),
    13956: (V((0.1161,0.334711)), V((0.1239,0.331868)), V((0.1281,0.348098)), V((0.1210,0.350805)), ),
    13957: (V((0.1239,0.331868)), V((0.1317,0.330081)), V((0.1356,0.345835)), V((0.1281,0.348098)), ),
    13958: (V((0.2612,0.280657)), V((0.2652,0.291816)), V((0.2582,0.296734)), V((0.2533,0.284880)), ),
    13959: (V((0.2361,0.312762)), V((0.2329,0.301015)), V((0.2382,0.297523)), V((0.2424,0.308549)), ),
    13960: (V((0.2117,0.320679)), V((0.2089,0.309279)), V((0.2206,0.306573)), V((0.2226,0.317951)), ),
    13961: (V((0.1317,0.330081)), V((0.1284,0.318712)), V((0.1371,0.318169)), V((0.1402,0.328998)), ),
    13962: (V((0.1487,0.328536)), V((0.1462,0.317337)), V((0.1549,0.316720)), V((0.1575,0.327678)), ),
    13963: (V((0.1650,0.315818)), V((0.1677,0.326234)), V((0.1575,0.327678)), V((0.1549,0.316720)), ),
    13964: (V((0.2329,0.301015)), V((0.2361,0.312762)), V((0.2292,0.315833)), V((0.2265,0.304374)), ),
    13965: (V((0.1957,0.720984)), V((0.1993,0.732359)), V((0.1861,0.729832)), V((0.1876,0.719730)), ),
    13966: (V((0.1402,0.328998)), V((0.1371,0.318169)), V((0.1462,0.317337)), V((0.1487,0.328536)), ),
    13967: (V((0.2533,0.284880)), V((0.2582,0.296734)), V((0.2505,0.302107)), V((0.2459,0.290226)), ),
    13968: (V((0.1993,0.732359)), V((0.1957,0.720984)), V((0.2031,0.721380)), V((0.2138,0.734292)), ),
    13969: (V((0.2265,0.304374)), V((0.2292,0.315833)), V((0.2226,0.317951)), V((0.2206,0.306573)), ),
    13970: (V((0.1638,0.306278)), V((0.1650,0.315818)), V((0.1549,0.316720)), V((0.1524,0.305977)), ),
    13971: (V((0.2296,0.287940)), V((0.2329,0.301015)), V((0.2265,0.304374)), V((0.2245,0.291952)), ),
    13972: (V((0.2138,0.734292)), V((0.2031,0.721380)), V((0.2150,0.714738)), V((0.2255,0.723485)), ),
    13973: (V((0.1371,0.318169)), V((0.1344,0.306224)), V((0.1431,0.306461)), V((0.1462,0.317337)), ),
    13974: (V((0.2485,0.272765)), V((0.2533,0.284880)), V((0.2459,0.290226)), V((0.2415,0.277832)), ),
    13975: (V((0.2255,0.723485)), V((0.2150,0.714738)), V((0.2201,0.707848)), V((0.2304,0.715388)), ),
    13976: (V((0.2245,0.291952)), V((0.2265,0.304374)), V((0.2206,0.306573)), V((0.2180,0.295385)), ),
    13977: (V((0.2562,0.268549)), V((0.2612,0.280657)), V((0.2533,0.284880)), V((0.2485,0.272765)), ),
    13978: (V((0.2329,0.301015)), V((0.2296,0.287940)), V((0.2348,0.283818)), V((0.2382,0.297523)), ),
    13979: (V((0.2089,0.309279)), V((0.2068,0.298412)), V((0.2180,0.295385)), V((0.2206,0.306573)), ),
    13980: (V((0.1284,0.318712)), V((0.1251,0.306344)), V((0.1344,0.306224)), V((0.1371,0.318169)), ),
    13981: (V((0.1462,0.317337)), V((0.1431,0.306461)), V((0.1524,0.305977)), V((0.1549,0.316720)), ),
    13982: (V((0.2304,0.715388)), V((0.2201,0.707848)), V((0.2231,0.701782)), V((0.2335,0.708121)), ),
    13983: (V((0.2231,0.701782)), V((0.2248,0.695295)), V((0.2357,0.699745)), V((0.2335,0.708121)), ),
    13984: (V((0.2259,0.688638)), V((0.2387,0.691602)), V((0.2357,0.699745)), V((0.2248,0.695295)), ),
    13985: (V((0.2402,0.684493)), V((0.2387,0.691602)), V((0.2259,0.688638)), V((0.2271,0.681971)), ),
    13986: (V((0.2402,0.684493)), V((0.2271,0.681971)), V((0.2287,0.675531)), V((0.2419,0.677980)), ),
    13987: (V((0.2130,0.249345)), V((0.2176,0.264432)), V((0.2108,0.269087)), V((0.2063,0.253388)), ),
    13988: (V((0.2366,0.231625)), V((0.2443,0.243862)), V((0.2372,0.247784)), V((0.2304,0.235090)), ),
    13989: (V((0.2223,0.260075)), V((0.2179,0.245330)), V((0.2215,0.241991)), V((0.2267,0.256122)), ),
    13990: (V((0.2014,0.273083)), V((0.1979,0.257654)), V((0.2063,0.253388)), V((0.2108,0.269087)), ),
    13991: (V((0.1207,0.280291)), V((0.1186,0.265997)), V((0.1275,0.266194)), V((0.1293,0.280448)), ),
    13992: (V((0.1373,0.281111)), V((0.1359,0.266781)), V((0.1452,0.267022)), V((0.1472,0.280938)), ),
    13993: (V((0.1559,0.266416)), V((0.1586,0.281780)), V((0.1472,0.280938)), V((0.1452,0.267022)), ),
    13994: (V((0.2179,0.245330)), V((0.2223,0.260075)), V((0.2176,0.264432)), V((0.2130,0.249345)), ),
    13995: (V((0.2287,0.675531)), V((0.2302,0.669353)), V((0.2434,0.671761)), V((0.2419,0.677980)), ),
    13996: (V((0.1293,0.280448)), V((0.1275,0.266194)), V((0.1359,0.266781)), V((0.1373,0.281111)), ),
    13997: (V((0.2304,0.235090)), V((0.2372,0.247784)), V((0.2314,0.251895)), V((0.2255,0.238612)), ),
    13998: (V((0.1186,0.265997)), V((0.1177,0.250771)), V((0.1262,0.251637)), V((0.1275,0.266194)), ),
    13999: (V((0.1359,0.266781)), V((0.1337,0.252108)), V((0.1427,0.252003)), V((0.1452,0.267022)), ),
    14000: (V((0.1529,0.251138)), V((0.1559,0.266416)), V((0.1452,0.267022)), V((0.1427,0.252003)), ),
    14001: (V((0.2127,0.230115)), V((0.2179,0.245330)), V((0.2130,0.249345)), V((0.2084,0.232970)), ),
    14002: (V((0.2446,0.665368)), V((0.2434,0.671761)), V((0.2302,0.669353)), V((0.2313,0.662907)), ),
    14003: (V((0.1275,0.266194)), V((0.1262,0.251637)), V((0.1337,0.252108)), V((0.1359,0.266781)), ),
    14004: (V((0.2238,0.221862)), V((0.2304,0.235090)), V((0.2255,0.238612)), V((0.2195,0.224945)), ),
    14005: (V((0.2329,0.655463)), V((0.2458,0.658048)), V((0.2446,0.665368)), V((0.2313,0.662907)), ),
    14006: (V((0.2084,0.232970)), V((0.2130,0.249345)), V((0.2063,0.253388)), V((0.2023,0.236545)), ),
    14007: (V((0.2290,0.218906)), V((0.2366,0.231625)), V((0.2304,0.235090)), V((0.2238,0.221862)), ),
    14008: (V((0.2179,0.245330)), V((0.2127,0.230115)), V((0.2160,0.227645)), V((0.2215,0.241991)), ),
    14009: (V((0.1979,0.257654)), V((0.1935,0.241326)), V((0.2023,0.236545)), V((0.2063,0.253388)), ),
    14010: (V((0.2165,0.208364)), V((0.2238,0.221862)), V((0.2195,0.224945)), V((0.2130,0.210629)), ),
    14011: (V((0.2458,0.658048)), V((0.2329,0.655463)), V((0.2335,0.646897)), V((0.2471,0.648796)), ),
    14012: (V((0.2031,0.216287)), V((0.2084,0.232970)), V((0.2023,0.236545)), V((0.1968,0.219130)), ),
    14013: (V((0.2218,0.205960)), V((0.2290,0.218906)), V((0.2238,0.221862)), V((0.2165,0.208364)), ),
    14014: (V((0.2127,0.230115)), V((0.2069,0.214467)), V((0.2099,0.212636)), V((0.2160,0.227645)), ),
    14015: (V((0.1935,0.241326)), V((0.1888,0.222790)), V((0.1968,0.219130)), V((0.2023,0.236545)), ),
    14016: (V((0.1177,0.250771)), V((0.1177,0.233786)), V((0.1245,0.235768)), V((0.1262,0.251637)), ),
    14017: (V((0.1337,0.252108)), V((0.1319,0.236264)), V((0.1400,0.235453)), V((0.1427,0.252003)), ),
    14018: (V((0.1504,0.233894)), V((0.1529,0.251138)), V((0.1427,0.252003)), V((0.1400,0.235453)), ),
    14019: (V((0.2069,0.214467)), V((0.2127,0.230115)), V((0.2084,0.232970)), V((0.2031,0.216287)), ),
    14020: (V((0.2326,0.635794)), V((0.2491,0.637305)), V((0.2471,0.648796)), V((0.2335,0.646897)), ),
    14021: (V((0.1262,0.251637)), V((0.1245,0.235768)), V((0.1319,0.236264)), V((0.1337,0.252108)), ),
    14022: (V((0.1888,0.222790)), V((0.1841,0.202110)), V((0.1907,0.201240)), V((0.1968,0.219130)), ),
    14023: (V((0.1177,0.233786)), V((0.1167,0.214274)), V((0.1257,0.216112)), V((0.1245,0.235768)), ),
    14024: (V((0.1319,0.236264)), V((0.1320,0.215251)), V((0.1386,0.211250)), V((0.1400,0.235453)), ),
    14025: (V((0.1476,0.209308)), V((0.1504,0.233894)), V((0.1400,0.235453)), V((0.1386,0.211250)), ),
    14026: (V((0.1994,0.197156)), V((0.2069,0.214467)), V((0.2031,0.216287)), V((0.1962,0.198298)), ),
    14027: (V((0.2329,0.625231)), V((0.2505,0.627759)), V((0.2491,0.637305)), V((0.2326,0.635794)), ),
    14028: (V((0.1245,0.235768)), V((0.1257,0.216112)), V((0.1320,0.215251)), V((0.1319,0.236264)), ),
    14029: (V((0.2093,0.193069)), V((0.2165,0.208364)), V((0.2130,0.210629)), V((0.2059,0.194722)), ),
    14030: (V((0.1962,0.198298)), V((0.2031,0.216287)), V((0.1968,0.219130)), V((0.1907,0.201240)), ),
    14031: (V((0.2147,0.190799)), V((0.2218,0.205960)), V((0.2165,0.208364)), V((0.2093,0.193069)), ),
    14032: (V((0.2069,0.214467)), V((0.1994,0.197156)), V((0.2026,0.195993)), V((0.2099,0.212636)), ),
    14033: (V((0.2494,0.604340)), V((0.2329,0.604804)), V((0.2339,0.587295)), V((0.2490,0.585421)), ),
    14034: (V((0.2490,0.585421)), V((0.2339,0.587295)), V((0.2333,0.573217)), V((0.2484,0.571890)), ),
    14035: (V((0.2484,0.571890)), V((0.2333,0.573217)), V((0.2317,0.559507)), V((0.2474,0.559427)), ),
    14036: (V((0.1142,0.184100)), V((0.1195,0.180311)), V((0.1320,0.215251)), V((0.1257,0.216112)), ),
    14037: (V((0.1097,0.187081)), V((0.1142,0.184100)), V((0.1257,0.216112)), V((0.1167,0.214274)), ),
    14038: (V((0.1034,0.205604)), V((0.1022,0.191596)), V((0.1053,0.189735)), V((0.1098,0.213373)), ),
    14039: (V((0.2093,0.193069)), V((0.2059,0.194722)), V((0.1702,0.149390)), V((0.1744,0.152210)), ),
    14040: (V((0.2474,0.559427)), V((0.2317,0.559507)), V((0.2286,0.545769)), V((0.2447,0.545085)), ),
    14041: (V((0.2250,0.531682)), V((0.2422,0.530616)), V((0.2447,0.545085)), V((0.2286,0.545769)), ),
    14042: (V((0.2099,0.212636)), V((0.2026,0.195993)), V((0.2059,0.194722)), V((0.2130,0.210629)), ),
    14043: (V((0.2422,0.530616)), V((0.2250,0.531682)), V((0.2214,0.515721)), V((0.2389,0.512016)), ),
    14044: (V((0.2389,0.512016)), V((0.2214,0.515721)), V((0.2204,0.499035)), V((0.2377,0.494855)), ),
    14045: (V((0.1026,0.230800)), V((0.1034,0.205604)), V((0.1098,0.213373)), V((0.1099,0.232207)), ),
    14046: (V((0.1919,0.828867)), V((0.1825,0.824663)), V((0.1838,0.813921)), V((0.1943,0.817137)), ),
    14047: (V((0.1840,0.804205)), V((0.1961,0.808270)), V((0.1943,0.817137)), V((0.1838,0.813921)), ),
    14048: (V((0.2130,0.210629)), V((0.2195,0.224945)), V((0.2160,0.227645)), V((0.2099,0.212636)), ),
    14049: (V((0.1099,0.232207)), V((0.1097,0.249136)), V((0.1016,0.247761)), V((0.1026,0.230800)), ),
    14050: (V((0.1009,0.264375)), V((0.1016,0.247761)), V((0.1097,0.249136)), V((0.1104,0.265431)), ),
    14051: (V((0.2215,0.241991)), V((0.2160,0.227645)), V((0.2195,0.224945)), V((0.2255,0.238612)), ),
    14052: (V((0.2267,0.256122)), V((0.2215,0.241991)), V((0.2255,0.238612)), V((0.2314,0.251895)), ),
    14053: (V((0.1017,0.280455)), V((0.1009,0.264375)), V((0.1104,0.265431)), V((0.1121,0.280554)), ),
    14054: (V((0.5277,0.305977)), V((0.5163,0.306278)), V((0.5215,0.281780)), V((0.5329,0.280938)), ),
    14055: (V((0.1167,0.307746)), V((0.1205,0.320356)), V((0.1122,0.323562)), V((0.1072,0.310335)), ),
    14056: (V((0.2382,0.297523)), V((0.2348,0.283818)), V((0.2415,0.277832)), V((0.2459,0.290226)), ),
    14057: (V((0.2424,0.308549)), V((0.2382,0.297523)), V((0.2459,0.290226)), V((0.2505,0.302107)), ),
    14058: (V((0.1161,0.334711)), V((0.1122,0.323562)), V((0.1205,0.320356)), V((0.1239,0.331868)), ),
    14059: (V((0.1356,0.345835)), V((0.1317,0.330081)), V((0.1402,0.328998)), V((0.1444,0.343868)), ),
    14060: (V((0.1444,0.343868)), V((0.1402,0.328998)), V((0.1487,0.328536)), V((0.1522,0.342074)), ),
    14061: (V((0.1522,0.342074)), V((0.1487,0.328536)), V((0.1575,0.327678)), V((0.1610,0.341322)), ),
    14062: (V((0.2510,0.333220)), V((0.2470,0.322564)), V((0.2557,0.316643)), V((0.2602,0.327186)), ),
    14063: (V((0.1677,0.326234)), V((0.1704,0.340075)), V((0.1610,0.341322)), V((0.1575,0.327678)), ),
    14064: (V((0.1281,0.348098)), V((0.1304,0.356957)), V((0.1233,0.359162)), V((0.1210,0.350805)), ),
    14065: (V((0.1836,0.795448)), V((0.1972,0.799416)), V((0.1961,0.808270)), V((0.1840,0.804205)), ),
    14066: (V((0.2377,0.494855)), V((0.2204,0.499035)), V((0.2185,0.483675)), V((0.2360,0.479703)), ),
    14067: (V((0.2360,0.479703)), V((0.2185,0.483675)), V((0.2180,0.472598)), V((0.2347,0.468498)), ),
    14068: (V((0.2995,0.441249)), V((0.2933,0.428118)), V((0.3032,0.421764)), V((0.3095,0.434130)), ),
    14069: (V((0.3148,0.465748)), V((0.3064,0.454110)), V((0.3173,0.447298)), V((0.3219,0.455587)), ),
    14070: (V((0.2648,0.560024)), V((0.2612,0.543722)), V((0.2761,0.543586)), V((0.2766,0.558818)), ),
    14071: (V((0.1694,0.576772)), V((0.1768,0.573246)), V((0.1784,0.583885)), V((0.1716,0.586836)), ),
    14072: (V((0.1192,0.450236)), V((0.1249,0.440106)), V((0.1334,0.444798)), V((0.1284,0.456059)), ),
    14073: (V((0.1219,0.469118)), V((0.1177,0.473712)), V((0.1064,0.469417)), V((0.1105,0.463734)), ),
    14074: (V((0.2382,0.889307)), V((0.2310,0.892759)), V((0.2296,0.869451)), V((0.2388,0.870973)), ),
    14075: (V((0.1098,0.213373)), V((0.1053,0.189735)), V((0.1097,0.187081)), V((0.1167,0.214274)), ),
    14076: (V((0.1167,0.214274)), V((0.1177,0.233786)), V((0.1099,0.232207)), V((0.1098,0.213373)), ),
    14077: (V((0.2218,0.205960)), V((0.2147,0.190799)), V((0.2157,0.189625)), V((0.2273,0.203449)), ),
    14078: (V((0.2290,0.218906)), V((0.2218,0.205960)), V((0.2273,0.203449)), V((0.2347,0.216143)), ),
    14079: (V((0.1177,0.233786)), V((0.1177,0.250771)), V((0.1097,0.249136)), V((0.1099,0.232207)), ),
    14080: (V((0.1177,0.250771)), V((0.1186,0.265997)), V((0.1104,0.265431)), V((0.1097,0.249136)), ),
    14081: (V((0.2366,0.231625)), V((0.2290,0.218906)), V((0.2347,0.216143)), V((0.2433,0.227828)), ),
    14082: (V((0.2443,0.243862)), V((0.2366,0.231625)), V((0.2433,0.227828)), V((0.2519,0.239625)), ),
    14083: (V((0.1186,0.265997)), V((0.1207,0.280291)), V((0.1121,0.280554)), V((0.1104,0.265431)), ),
    14084: (V((0.5163,0.306278)), V((0.5057,0.304196)), V((0.5102,0.279830)), V((0.5215,0.281780)), ),
    14085: (V((0.4997,0.278675)), V((0.5102,0.279830)), V((0.5057,0.304196)), V((0.4949,0.302269)), ),
    14086: (V((0.1205,0.320356)), V((0.1167,0.307746)), V((0.1251,0.306344)), V((0.1284,0.318712)), ),
    14087: (V((0.1284,0.318712)), V((0.1317,0.330081)), V((0.1239,0.331868)), V((0.1205,0.320356)), ),
    14088: (V((0.1704,0.340075)), V((0.1677,0.326234)), V((0.1781,0.326332)), V((0.1796,0.339462)), ),
    14089: (V((0.1781,0.326332)), V((0.1887,0.324739)), V((0.1906,0.337705)), V((0.1796,0.339462)), ),
    14090: (V((0.1356,0.345835)), V((0.1385,0.355212)), V((0.1304,0.356957)), V((0.1281,0.348098)), ),
    14091: (V((0.1284,0.456059)), V((0.1334,0.444798)), V((0.1426,0.449759)), V((0.1384,0.461601)), ),
    14092: (V((0.1177,0.473712)), V((0.1219,0.469118)), V((0.1338,0.474936)), V((0.1287,0.482212)), ),
    14093: (V((0.2179,0.878565)), V((0.2227,0.896529)), V((0.2142,0.900777)), V((0.2106,0.886041)), ),
    14094: (V((0.2031,0.893367)), V((0.2106,0.886041)), V((0.2142,0.900777)), V((0.2053,0.904853)), ),
    14095: (V((0.2031,0.893367)), V((0.2053,0.904853)), V((0.1967,0.908412)), V((0.1933,0.897851)), ),
    14096: (V((0.3345,0.424324)), V((0.3353,0.426706)), V((0.3316,0.435363)), V((0.3297,0.432242)), ),
    14097: (V((0.3251,0.421391)), V((0.3204,0.409301)), V((0.3281,0.405659)), V((0.3316,0.416170)), ),
    14098: (V((0.2618,0.415454)), V((0.2526,0.419689)), V((0.2470,0.406366)), V((0.2561,0.401680)), ),
    14099: (V((0.2722,0.409404)), V((0.2618,0.415454)), V((0.2561,0.401680)), V((0.2663,0.395630)), ),
    14100: (V((0.2755,0.317270)), V((0.2719,0.307284)), V((0.2800,0.303758)), V((0.2838,0.312832)), ),
    14101: (V((0.2335,0.460429)), V((0.2347,0.468498)), V((0.2180,0.472598)), V((0.2170,0.464369)), ),
    14102: (V((0.2154,0.455106)), V((0.2318,0.451150)), V((0.2335,0.460429)), V((0.2170,0.464369)), ),
    14103: (V((0.2652,0.291816)), V((0.2612,0.280657)), V((0.2689,0.276753)), V((0.2731,0.287311)), ),
    14104: (V((0.2612,0.280657)), V((0.2562,0.268549)), V((0.2641,0.264632)), V((0.2689,0.276753)), ),
    14105: (V((0.4887,0.276724)), V((0.4997,0.278675)), V((0.4949,0.302269)), V((0.4837,0.300648)), ),
    14106: (V((0.4837,0.300648)), V((0.4733,0.298412)), V((0.4787,0.273083)), V((0.4887,0.276724)), ),
    14107: (V((0.2226,0.361977)), V((0.2188,0.345669)), V((0.2281,0.343547)), V((0.2321,0.358787)), ),
    14108: (V((0.1851,0.786347)), V((0.1988,0.790280)), V((0.1972,0.799416)), V((0.1836,0.795448)), ),
    14109: (V((0.1893,0.773564)), V((0.2027,0.779616)), V((0.1988,0.790280)), V((0.1851,0.786347)), ),
    14110: (V((0.2663,0.395630)), V((0.2561,0.401680)), V((0.2509,0.386397)), V((0.2605,0.380693)), ),
    14111: (V((0.2561,0.401680)), V((0.2470,0.406366)), V((0.2424,0.390416)), V((0.2509,0.386397)), ),
    14112: (V((0.2316,0.393130)), V((0.2424,0.390416)), V((0.2470,0.406366)), V((0.2368,0.409629)), ),
    14113: (V((0.1824,0.418082)), V((0.1725,0.417825)), V((0.1718,0.399463)), V((0.1810,0.399791)), ),
    14114: (V((0.1636,0.398334)), V((0.1718,0.399463)), V((0.1725,0.417825)), V((0.1642,0.416092)), ),
    14115: (V((0.1556,0.397343)), V((0.1636,0.398334)), V((0.1642,0.416092)), V((0.1562,0.413811)), ),
    14116: (V((0.1472,0.396338)), V((0.1556,0.397343)), V((0.1562,0.413811)), V((0.1474,0.411446)), ),
    14117: (V((0.1390,0.395607)), V((0.1472,0.396338)), V((0.1474,0.411446)), V((0.1401,0.409562)), ),
    14118: (V((0.1401,0.409562)), V((0.1336,0.408811)), V((0.1325,0.396082)), V((0.1390,0.395607)), ),
    14119: (V((0.3102,0.370113)), V((0.3021,0.374201)), V((0.2948,0.358487)), V((0.3031,0.354679)), ),
    14120: (V((0.3021,0.374201)), V((0.2938,0.378260)), V((0.2866,0.363237)), V((0.2948,0.358487)), ),
    14121: (V((0.2938,0.378260)), V((0.2850,0.384082)), V((0.2782,0.369133)), V((0.2866,0.363237)), ),
    14122: (V((0.2696,0.375806)), V((0.2782,0.369133)), V((0.2850,0.384082)), V((0.2766,0.389665)), ),
    14123: (V((0.2605,0.380693)), V((0.2696,0.375806)), V((0.2766,0.389665)), V((0.2663,0.395630)), ),
    14124: (V((0.2663,0.395630)), V((0.2766,0.389665)), V((0.2819,0.404308)), V((0.2722,0.409404)), ),
    14125: (V((0.2850,0.384082)), V((0.2922,0.398466)), V((0.2819,0.404308)), V((0.2766,0.389665)), ),
    14126: (V((0.4486,0.393130)), V((0.4377,0.390416)), V((0.4480,0.358787)), V((0.4575,0.361977)), ),
    14127: (V((0.1401,0.409562)), V((0.1390,0.422244)), V((0.1322,0.420363)), V((0.1336,0.408811)), ),
    14128: (V((0.1474,0.411446)), V((0.1464,0.425190)), V((0.1390,0.422244)), V((0.1401,0.409562)), ),
    14129: (V((0.1474,0.411446)), V((0.1562,0.413811)), V((0.1548,0.428968)), V((0.1464,0.425190)), ),
    14130: (V((0.1562,0.413811)), V((0.1642,0.416092)), V((0.1634,0.432605)), V((0.1548,0.428968)), ),
    14131: (V((0.1642,0.416092)), V((0.1725,0.417825)), V((0.1727,0.434931)), V((0.1634,0.432605)), ),
    14132: (V((0.4629,0.395266)), V((0.4486,0.393130)), V((0.4575,0.361977)), V((0.4709,0.363460)), ),
    14133: (V((0.2369,0.781154)), V((0.2445,0.769774)), V((0.2578,0.773935)), V((0.2493,0.786064)), ),
    14134: (V((0.2493,0.786064)), V((0.2578,0.773935)), V((0.2694,0.776863)), V((0.2611,0.790446)), ),
    14135: (V((0.1642,0.205716)), V((0.1737,0.203960)), V((0.1792,0.226222)), V((0.1693,0.229121)), ),
    14136: (V((0.2368,0.409629)), V((0.2470,0.406366)), V((0.2526,0.419689)), V((0.2408,0.423956)), ),
    14137: (V((0.4709,0.363460)), V((0.4848,0.365512)), V((0.4774,0.397671)), V((0.4629,0.395266)), ),
    14138: (V((0.4848,0.365512)), V((0.4959,0.366554)), V((0.4902,0.399316)), V((0.4774,0.397671)), ),
    14139: (V((0.3179,0.685718)), V((0.3169,0.692679)), V((0.3063,0.691979)), V((0.3084,0.684739)), ),
    14140: (V((0.3128,0.662394)), V((0.3098,0.676901)), V((0.2999,0.675812)), V((0.3019,0.663459)), ),
    14141: (V((0.2611,0.790446)), V((0.2694,0.776863)), V((0.2842,0.780464)), V((0.2728,0.797284)), ),
    14142: (V((0.2803,0.806285)), V((0.2728,0.797284)), V((0.2842,0.780464)), V((0.2921,0.788143)), ),
    14143: (V((0.1967,0.908412)), V((0.1886,0.911395)), V((0.1855,0.900938)), V((0.1933,0.897851)), ),
    14144: (V((0.1817,0.913702)), V((0.1785,0.903557)), V((0.1855,0.900938)), V((0.1886,0.911395)), ),
    14145: (V((0.2115,0.838264)), V((0.2171,0.825178)), V((0.2260,0.834920)), V((0.2175,0.847288)), ),
    14146: (V((0.2327,0.843547)), V((0.2234,0.857984)), V((0.2175,0.847288)), V((0.2260,0.834920)), ),
    14147: (V((0.1819,0.889348)), V((0.1896,0.884912)), V((0.1933,0.897851)), V((0.1855,0.900938)), ),
    14148: (V((0.1780,0.878895)), V((0.1859,0.875081)), V((0.1896,0.884912)), V((0.1819,0.889348)), ),
    14149: (V((0.1859,0.875081)), V((0.1780,0.878895)), V((0.1747,0.869411)), V((0.1810,0.866051)), ),
    14150: (V((0.2035,0.695793)), V((0.2046,0.690264)), V((0.2154,0.691719)), V((0.2135,0.697623)), ),
    14151: (V((0.2694,0.776863)), V((0.2782,0.763821)), V((0.3003,0.766334)), V((0.2842,0.780464)), ),
    14152: (V((0.2842,0.780464)), V((0.3003,0.766334)), V((0.3067,0.775889)), V((0.2921,0.788143)), ),
    14153: (V((0.1839,0.245153)), V((0.1735,0.248453)), V((0.1693,0.229121)), V((0.1792,0.226222)), ),
    14154: (V((0.1735,0.248453)), V((0.1839,0.245153)), V((0.1881,0.261663)), V((0.1772,0.264425)), ),
    14155: (V((0.2457,0.713548)), V((0.2501,0.705230)), V((0.2628,0.709455)), V((0.2581,0.718086)), ),
    14156: (V((0.2745,0.712756)), V((0.2702,0.721935)), V((0.2581,0.718086)), V((0.2628,0.709455)), ),
    14157: (V((0.2702,0.721935)), V((0.2745,0.712756)), V((0.2857,0.714453)), V((0.2824,0.725764)), ),
    14158: (V((0.2644,0.826415)), V((0.2590,0.833525)), V((0.2543,0.828786)), V((0.2591,0.820527)), ),
    14159: (V((0.1719,0.669951)), V((0.1640,0.669119)), V((0.1636,0.667318)), V((0.1717,0.667696)), ),
    14160: (V((0.3255,0.720632)), V((0.3250,0.731569)), V((0.3092,0.729813)), V((0.3118,0.719462)), ),
    14161: (V((0.2530,0.841986)), V((0.2479,0.851525)), V((0.2411,0.848707)), V((0.2486,0.836573)), ),
    14162: (V((0.1639,0.662350)), V((0.1721,0.662818)), V((0.1717,0.667696)), V((0.1636,0.667318)), ),
    14163: (V((0.1914,0.276724)), V((0.1804,0.278675)), V((0.1772,0.264425)), V((0.1881,0.261663)), ),
    14164: (V((0.3284,0.685231)), V((0.3272,0.692872)), V((0.3169,0.692679)), V((0.3179,0.685718)), ),
    14165: (V((0.2882,0.681295)), V((0.2850,0.686706)), V((0.2744,0.682284)), V((0.2762,0.676947)), ),
    14166: (V((0.1812,0.658088)), V((0.1821,0.651949)), V((0.1907,0.652473)), V((0.1898,0.658845)), ),
    14167: (V((0.2295,0.740258)), V((0.2138,0.734292)), V((0.2255,0.723485)), V((0.2371,0.729951)), ),
    14168: (V((0.2762,0.676947)), V((0.2744,0.682284)), V((0.2579,0.676434)), V((0.2596,0.670067)), ),
    14169: (V((0.1985,0.659603)), V((0.1978,0.665527)), V((0.1890,0.664595)), V((0.1898,0.658845)), ),
    14170: (V((0.3227,0.663829)), V((0.3191,0.677844)), V((0.3098,0.676901)), V((0.3128,0.662394)), ),
    14171: (V((0.2231,0.701782)), V((0.2135,0.697623)), V((0.2154,0.691719)), V((0.2248,0.695295)), ),
    14172: (V((0.1726,0.657495)), V((0.1735,0.651410)), V((0.1821,0.651949)), V((0.1812,0.658088)), ),
    14173: (V((0.1726,0.657495)), V((0.1721,0.662818)), V((0.1639,0.662350)), V((0.1643,0.657007)), ),
    14174: (V((0.2066,0.672535)), V((0.2075,0.666670)), V((0.2182,0.668074)), V((0.2168,0.673844)), ),
    14175: (V((0.4733,0.298412)), V((0.4621,0.295385)), V((0.4693,0.269087)), V((0.4787,0.273083)), ),
    14176: (V((0.1801,0.668685)), V((0.1803,0.663646)), V((0.1890,0.664595)), V((0.1881,0.669872)), ),
    14177: (V((0.2976,0.683347)), V((0.2953,0.690013)), V((0.2850,0.686706)), V((0.2882,0.681295)), ),
    14178: (V((0.1898,0.658845)), V((0.1907,0.652473)), V((0.1993,0.653053)), V((0.1985,0.659603)), ),
    14179: (V((0.2952,0.728074)), V((0.2983,0.717852)), V((0.3118,0.719462)), V((0.3092,0.729813)), ),
    14180: (V((0.2824,0.725764)), V((0.2857,0.714453)), V((0.2983,0.717852)), V((0.2952,0.728074)), ),
    14181: (V((0.2668,0.701133)), V((0.2628,0.709455)), V((0.2501,0.705230)), V((0.2533,0.695078)), ),
    14182: (V((0.2201,0.707848)), V((0.2103,0.702832)), V((0.2135,0.697623)), V((0.2231,0.701782)), ),
    14183: (V((0.3084,0.684739)), V((0.3063,0.691979)), V((0.2953,0.690013)), V((0.2976,0.683347)), ),
    14184: (V((0.1654,0.650878)), V((0.1735,0.651410)), V((0.1726,0.657495)), V((0.1643,0.657007)), ),
    14185: (V((0.4621,0.295385)), V((0.4556,0.291952)), V((0.4626,0.264432)), V((0.4693,0.269087)), ),
    14186: (V((0.3019,0.663459)), V((0.2999,0.675812)), V((0.2891,0.674661)), V((0.2897,0.659731)), ),
    14187: (V((0.3312,0.664695)), V((0.3304,0.676129)), V((0.3191,0.677844)), V((0.3227,0.663829)), ),
    14188: (V((0.2897,0.659731)), V((0.2891,0.674661)), V((0.2797,0.672597)), V((0.2776,0.656466)), ),
    14189: (V((0.1735,0.651410)), V((0.1654,0.650878)), V((0.1670,0.643339)), V((0.1747,0.644164)), ),
    14190: (V((0.1852,0.302269)), V((0.1964,0.300648)), V((0.1986,0.311508)), V((0.1867,0.313740)), ),
    14191: (V((0.2776,0.656466)), V((0.2797,0.672597)), V((0.2611,0.662671)), V((0.2621,0.652879)), ),
    14192: (V((0.3322,0.554710)), V((0.3323,0.571530)), V((0.3239,0.573303)), V((0.3240,0.555388)), ),
    14193: (V((0.2744,0.682284)), V((0.2717,0.688032)), V((0.2560,0.682297)), V((0.2579,0.676434)), ),
    14194: (V((0.1740,0.842868)), V((0.1691,0.838626)), V((0.1784,0.834770)), V((0.1863,0.839255)), ),
    14195: (V((0.2008,0.322826)), V((0.1887,0.324739)), V((0.1867,0.313740)), V((0.1986,0.311508)), ),
    14196: (V((0.2027,0.335925)), V((0.1906,0.337705)), V((0.1887,0.324739)), V((0.2008,0.322826)), ),
    14197: (V((0.2103,0.702832)), V((0.2201,0.707848)), V((0.2150,0.714738)), V((0.2027,0.706944)), ),
    14198: (V((0.2002,0.707536)), V((0.2027,0.706944)), V((0.2150,0.714738)), V((0.2031,0.721380)), ),
    14199: (V((0.2075,0.666670)), V((0.2080,0.660627)), V((0.2184,0.662040)), V((0.2182,0.668074)), ),
    14200: (V((0.1681,0.872037)), V((0.1747,0.869411)), V((0.1780,0.878895)), V((0.1716,0.881950)), ),
    14201: (V((0.1803,0.663646)), V((0.1812,0.658088)), V((0.1898,0.658845)), V((0.1890,0.664595)), ),
    14202: (V((0.1721,0.662818)), V((0.1726,0.657495)), V((0.1812,0.658088)), V((0.1803,0.663646)), ),
    14203: (V((0.1747,0.644164)), V((0.1670,0.643339)), V((0.1689,0.634423)), V((0.1767,0.634968)), ),
    14204: (V((0.1767,0.634968)), V((0.1689,0.634423)), V((0.1714,0.623214)), V((0.1789,0.623892)), ),
    14205: (V((0.2850,0.686706)), V((0.2827,0.692209)), V((0.2717,0.688032)), V((0.2744,0.682284)), ),
    14206: (V((0.2878,0.707808)), V((0.2857,0.714453)), V((0.2745,0.712756)), V((0.2777,0.704762)), ),
    14207: (V((0.3009,0.710597)), V((0.2983,0.717852)), V((0.2857,0.714453)), V((0.2878,0.707808)), ),
    14208: (V((0.3136,0.712255)), V((0.3118,0.719462)), V((0.2983,0.717852)), V((0.3009,0.710597)), ),
    14209: (V((0.3258,0.712956)), V((0.3255,0.720632)), V((0.3118,0.719462)), V((0.3136,0.712255)), ),
    14210: (V((0.2891,0.674661)), V((0.2882,0.681295)), V((0.2762,0.676947)), V((0.2797,0.672597)), ),
    14211: (V((0.2953,0.690013)), V((0.2932,0.695253)), V((0.2827,0.692209)), V((0.2850,0.686706)), ),
    14212: (V((0.3063,0.691979)), V((0.3047,0.697790)), V((0.2932,0.695253)), V((0.2953,0.690013)), ),
    14213: (V((0.3169,0.692679)), V((0.3162,0.698405)), V((0.3047,0.697790)), V((0.3063,0.691979)), ),
    14214: (V((0.3272,0.692872)), V((0.3267,0.699317)), V((0.3162,0.698405)), V((0.3169,0.692679)), ),
    14215: (V((0.3098,0.676901)), V((0.3084,0.684739)), V((0.2976,0.683347)), V((0.2999,0.675812)), ),
    14216: (V((0.3304,0.676129)), V((0.3284,0.685231)), V((0.3179,0.685718)), V((0.3191,0.677844)), ),
    14217: (V((0.2999,0.675812)), V((0.2976,0.683347)), V((0.2882,0.681295)), V((0.2891,0.674661)), ),
    14218: (V((0.3191,0.677844)), V((0.3179,0.685718)), V((0.3084,0.684739)), V((0.3098,0.676901)), ),
    14219: (V((0.2777,0.704762)), V((0.2745,0.712756)), V((0.2628,0.709455)), V((0.2668,0.701133)), ),
    14220: (V((0.2234,0.857984)), V((0.2327,0.843547)), V((0.2411,0.848707)), V((0.2296,0.869451)), ),
    14221: (V((0.2479,0.851525)), V((0.2388,0.870973)), V((0.2296,0.869451)), V((0.2411,0.848707)), ),
    14222: (V((0.1804,0.852230)), V((0.1740,0.842868)), V((0.1863,0.839255)), V((0.1961,0.843806)), ),
    14223: (V((0.1993,0.865217)), V((0.2054,0.875137)), V((0.1967,0.880383)), V((0.1925,0.870962)), ),
    14224: (V((0.2106,0.886041)), V((0.2031,0.893367)), V((0.1967,0.880383)), V((0.2054,0.875137)), ),
    14225: (V((0.2421,0.901206)), V((0.2474,0.909032)), V((0.2389,0.914231)), V((0.2346,0.905541)), ),
    14226: (V((0.2261,0.908447)), V((0.2296,0.918838)), V((0.2208,0.922331)), V((0.2175,0.912022)), ),
    14227: (V((0.2087,0.915492)), V((0.2053,0.904853)), V((0.2142,0.900777)), V((0.2175,0.912022)), ),
    14228: (V((0.2087,0.915492)), V((0.2117,0.925606)), V((0.2026,0.928438)), V((0.1997,0.918606)), ),
    14229: (V((0.1997,0.918606)), V((0.2026,0.928438)), V((0.1939,0.930894)), V((0.1914,0.921179)), ),
    14230: (V((0.1842,0.923244)), V((0.1817,0.913702)), V((0.1886,0.911395)), V((0.1914,0.921179)), ),
    14231: (V((0.1557,0.667919)), V((0.1514,0.669248)), V((0.1475,0.665728)), V((0.1553,0.666551)), ),
    14232: (V((0.1558,0.661469)), V((0.1639,0.662350)), V((0.1636,0.667318)), V((0.1553,0.666551)), ),
    14233: (V((0.1558,0.661469)), V((0.1478,0.660542)), V((0.1490,0.654241)), V((0.1567,0.655982)), ),
    14234: (V((0.1579,0.649802)), V((0.1654,0.650878)), V((0.1643,0.657007)), V((0.1567,0.655982)), ),
    14235: (V((0.1579,0.649802)), V((0.1506,0.648105)), V((0.1526,0.640852)), V((0.1592,0.642436)), ),
    14236: (V((0.1592,0.642436)), V((0.1526,0.640852)), V((0.1548,0.632267)), V((0.1615,0.633277)), ),
    14237: (V((0.1615,0.633277)), V((0.1548,0.632267)), V((0.1574,0.620812)), V((0.1642,0.622297)), ),
    14238: (V((0.1659,0.610545)), V((0.1592,0.609637)), V((0.1599,0.598681)), V((0.1671,0.597948)), ),
    14239: (V((0.3239,0.573303)), V((0.3250,0.592022)), V((0.3148,0.591808)), V((0.3143,0.573320)), ),
    14240: (V((0.3323,0.571530)), V((0.3325,0.591689)), V((0.3250,0.592022)), V((0.3239,0.573303)), ),
    14241: (V((0.1657,0.588424)), V((0.1600,0.589820)), V((0.1585,0.583806)), V((0.1632,0.579893)), ),
    14242: (V((0.2885,0.542011)), V((0.2891,0.557858)), V((0.2766,0.558818)), V((0.2761,0.543586)), ),
    14243: (V((0.3012,0.540082)), V((0.3017,0.556932)), V((0.2891,0.557858)), V((0.2885,0.542011)), ),
    14244: (V((0.2761,0.543586)), V((0.2612,0.543722)), V((0.2601,0.528172)), V((0.2746,0.524892)), ),
    14245: (V((0.2875,0.523273)), V((0.2885,0.542011)), V((0.2761,0.543586)), V((0.2746,0.524892)), ),
    14246: (V((0.1918,0.522923)), V((0.1967,0.536479)), V((0.1880,0.538893)), V((0.1819,0.526111)), ),
    14247: (V((0.1880,0.538893)), V((0.1801,0.541762)), V((0.1738,0.529031)), V((0.1819,0.526111)), ),
    14248: (V((0.1864,0.509380)), V((0.1918,0.522923)), V((0.1819,0.526111)), V((0.1769,0.513093)), ),
    14249: (V((0.1819,0.526111)), V((0.1738,0.529031)), V((0.1685,0.516686)), V((0.1769,0.513093)), ),
    14250: (V((0.2560,0.491094)), V((0.2544,0.477814)), V((0.2698,0.476780)), V((0.2721,0.489438)), ),
    14251: (V((0.2828,0.475067)), V((0.2858,0.487800)), V((0.2721,0.489438)), V((0.2698,0.476780)), ),
    14252: (V((0.1279,0.503001)), V((0.1293,0.496080)), V((0.1392,0.510582)), V((0.1328,0.512712)), ),
    14253: (V((0.1120,0.490380)), V((0.1173,0.487651)), V((0.1293,0.496080)), V((0.1279,0.503001)), ),
    14254: (V((0.1120,0.490380)), V((0.1119,0.497237)), V((0.1007,0.489007)), V((0.1037,0.486105)), ),
    14255: (V((0.0953,0.481678)), V((0.0969,0.479151)), V((0.1062,0.484769)), V((0.1037,0.486105)), ),
    14256: (V((0.3387,0.428901)), V((0.3400,0.428711)), V((0.3401,0.440124)), V((0.3383,0.439304)), ),
    14257: (V((0.3383,0.439304)), V((0.3401,0.440124)), V((0.3401,0.451650)), V((0.3370,0.451442)), ),
    14258: (V((0.3356,0.463860)), V((0.3315,0.463180)), V((0.3349,0.450854)), V((0.3370,0.451442)), ),
    14259: (V((0.3344,0.471182)), V((0.3289,0.471943)), V((0.3315,0.463180)), V((0.3356,0.463860)), ),
    14260: (V((0.3334,0.477758)), V((0.3268,0.478798)), V((0.3289,0.471943)), V((0.3344,0.471182)), ),
    14261: (V((0.1667,0.532240)), V((0.1602,0.519953)), V((0.1685,0.516686)), V((0.1738,0.529031)), ),
    14262: (V((0.1598,0.535519)), V((0.1537,0.522120)), V((0.1602,0.519953)), V((0.1667,0.532240)), ),
    14263: (V((0.1728,0.545396)), V((0.1667,0.532240)), V((0.1738,0.529031)), V((0.1801,0.541762)), ),
    14264: (V((0.1660,0.549053)), V((0.1598,0.535519)), V((0.1667,0.532240)), V((0.1728,0.545396)), ),
    14265: (V((0.3008,0.521619)), V((0.3012,0.540082)), V((0.2885,0.542011)), V((0.2875,0.523273)), ),
    14266: (V((0.3138,0.519830)), V((0.3133,0.538398)), V((0.3012,0.540082)), V((0.3008,0.521619)), ),
    14267: (V((0.3133,0.538398)), V((0.3139,0.556285)), V((0.3017,0.556932)), V((0.3012,0.540082)), ),
    14268: (V((0.3232,0.536358)), V((0.3240,0.555388)), V((0.3139,0.556285)), V((0.3133,0.538398)), ),
    14269: (V((0.2111,0.589632)), V((0.2098,0.574101)), V((0.2200,0.572584)), V((0.2204,0.587784)), ),
    14270: (V((0.2098,0.574101)), V((0.2111,0.589632)), V((0.2021,0.590381)), V((0.2009,0.576213)), ),
    14271: (V((0.2009,0.576213)), V((0.2021,0.590381)), V((0.1940,0.592339)), V((0.1925,0.578575)), ),
    14272: (V((0.1925,0.578575)), V((0.1940,0.592339)), V((0.1861,0.595526)), V((0.1861,0.581072)), ),
    14273: (V((0.1861,0.581072)), V((0.1861,0.595526)), V((0.1800,0.596749)), V((0.1784,0.583885)), ),
    14274: (V((0.1798,0.610580)), V((0.1726,0.610548)), V((0.1725,0.597376)), V((0.1800,0.596749)), ),
    14275: (V((0.1784,0.583885)), V((0.1800,0.596749)), V((0.1725,0.597376)), V((0.1716,0.586836)), ),
    14276: (V((0.1671,0.597948)), V((0.1657,0.588424)), V((0.1716,0.586836)), V((0.1725,0.597376)), ),
    14277: (V((0.3318,0.534624)), V((0.3401,0.533877)), V((0.3401,0.554120)), V((0.3322,0.554710)), ),
    14278: (V((0.3231,0.516146)), V((0.3232,0.536358)), V((0.3133,0.538398)), V((0.3138,0.519830)), ),
    14279: (V((0.3315,0.513331)), V((0.3318,0.534624)), V((0.3232,0.536358)), V((0.3231,0.516146)), ),
    14280: (V((0.1660,0.549053)), V((0.1594,0.552953)), V((0.1531,0.538650)), V((0.1598,0.535519)), ),
    14281: (V((0.1522,0.556694)), V((0.1453,0.543037)), V((0.1531,0.538650)), V((0.1594,0.552953)), ),
    14282: (V((0.1598,0.535519)), V((0.1531,0.538650)), V((0.1465,0.524661)), V((0.1537,0.522120)), ),
    14283: (V((0.1402,0.526257)), V((0.1453,0.543037)), V((0.1426,0.544144)), V((0.1346,0.528912)), ),
    14284: (V((0.2975,0.471426)), V((0.3000,0.484800)), V((0.2858,0.487800)), V((0.2828,0.475067)), ),
    14285: (V((0.3148,0.465748)), V((0.3148,0.480300)), V((0.3000,0.484800)), V((0.2975,0.471426)), ),
    14286: (V((0.1293,0.496080)), V((0.1361,0.493195)), V((0.1471,0.508423)), V((0.1392,0.510582)), ),
    14287: (V((0.1173,0.487651)), V((0.1287,0.482212)), V((0.1361,0.493195)), V((0.1293,0.496080)), ),
    14288: (V((0.1062,0.484769)), V((0.1177,0.473712)), V((0.1287,0.482212)), V((0.1173,0.487651)), ),
    14289: (V((0.0969,0.479151)), V((0.1064,0.469417)), V((0.1177,0.473712)), V((0.1062,0.484769)), ),
    14290: (V((0.3353,0.426706)), V((0.3377,0.428975)), V((0.3352,0.439490)), V((0.3316,0.435363)), ),
    14291: (V((0.3316,0.435363)), V((0.3352,0.439490)), V((0.3349,0.450854)), V((0.3285,0.443458)), ),
    14292: (V((0.3285,0.443458)), V((0.3349,0.450854)), V((0.3315,0.463180)), V((0.3219,0.455587)), ),
    14293: (V((0.3289,0.471943)), V((0.3148,0.465748)), V((0.3219,0.455587)), V((0.3315,0.463180)), ),
    14294: (V((0.3289,0.471943)), V((0.3268,0.478798)), V((0.3148,0.480300)), V((0.3148,0.465748)), ),
    14295: (V((0.3003,0.766334)), V((0.3030,0.750769)), V((0.3251,0.752023)), V((0.3250,0.765121)), ),
    14296: (V((0.3401,0.741976)), V((0.3251,0.741545)), V((0.3250,0.731569)), V((0.3401,0.732653)), ),
    14297: (V((0.3030,0.750769)), V((0.3066,0.740151)), V((0.3251,0.741545)), V((0.3251,0.752023)), ),
    14298: (V((0.3405,0.704581)), V((0.3401,0.712648)), V((0.3258,0.712956)), V((0.3263,0.704864)), ),
    14299: (V((0.3227,0.663829)), V((0.3235,0.648789)), V((0.3319,0.649261)), V((0.3312,0.664695)), ),
    14300: (V((0.3003,0.766334)), V((0.3250,0.765121)), V((0.3247,0.776830)), V((0.3067,0.775889)), ),
    14301: (V((0.3235,0.648789)), V((0.3243,0.631068)), V((0.3323,0.631158)), V((0.3319,0.649261)), ),
    14302: (V((0.1465,0.524661)), V((0.1402,0.526257)), V((0.1328,0.512712)), V((0.1392,0.510582)), ),
    14303: (V((0.3240,0.497079)), V((0.3320,0.494192)), V((0.3315,0.513331)), V((0.3231,0.516146)), ),
    14304: (V((0.3268,0.478798)), V((0.3334,0.477758)), V((0.3320,0.494192)), V((0.3240,0.497079)), ),
    14305: (V((0.1644,0.565114)), V((0.1580,0.569984)), V((0.1522,0.556694)), V((0.1594,0.552953)), ),
    14306: (V((0.1694,0.576772)), V((0.1632,0.579893)), V((0.1580,0.569984)), V((0.1644,0.565114)), ),
    14307: (V((0.3388,0.592243)), V((0.3401,0.611631)), V((0.3323,0.611486)), V((0.3325,0.591689)), ),
    14308: (V((0.3401,0.720732)), V((0.3401,0.732653)), V((0.3250,0.731569)), V((0.3255,0.720632)), ),
    14309: (V((0.3401,0.684766)), V((0.3401,0.693350)), V((0.3272,0.692872)), V((0.3284,0.685231)), ),
    14310: (V((0.3401,0.665634)), V((0.3401,0.676685)), V((0.3304,0.676129)), V((0.3312,0.664695)), ),
    14311: (V((0.3401,0.554120)), V((0.3401,0.576364)), V((0.3323,0.571530)), V((0.3322,0.554710)), ),
    14312: (V((0.3401,0.712648)), V((0.3401,0.720732)), V((0.3255,0.720632)), V((0.3258,0.712956)), ),
    14313: (V((0.3401,0.693350)), V((0.3401,0.699559)), V((0.3267,0.699317)), V((0.3272,0.692872)), ),
    14314: (V((0.3401,0.676685)), V((0.3401,0.684766)), V((0.3284,0.685231)), V((0.3304,0.676129)), ),
    14315: (V((0.2382,0.889307)), V((0.2421,0.901206)), V((0.2346,0.905541)), V((0.2310,0.892759)), ),
    14316: (V((0.2227,0.896529)), V((0.2261,0.908447)), V((0.2175,0.912022)), V((0.2142,0.900777)), ),
    14317: (V((0.2117,0.925606)), V((0.2087,0.915492)), V((0.2175,0.912022)), V((0.2208,0.922331)), ),
    14318: (V((0.2053,0.904853)), V((0.2087,0.915492)), V((0.1997,0.918606)), V((0.1967,0.908412)), ),
    14319: (V((0.1967,0.908412)), V((0.1997,0.918606)), V((0.1914,0.921179)), V((0.1886,0.911395)), ),
    14320: (V((0.1864,0.932554)), V((0.1842,0.923244)), V((0.1914,0.921179)), V((0.1939,0.930894)), ),
    14321: (V((0.1640,0.669119)), V((0.1557,0.667919)), V((0.1553,0.666551)), V((0.1636,0.667318)), ),
    14322: (V((0.1478,0.660542)), V((0.1558,0.661469)), V((0.1553,0.666551)), V((0.1475,0.665728)), ),
    14323: (V((0.1639,0.662350)), V((0.1558,0.661469)), V((0.1567,0.655982)), V((0.1643,0.657007)), ),
    14324: (V((0.1506,0.648105)), V((0.1579,0.649802)), V((0.1567,0.655982)), V((0.1490,0.654241)), ),
    14325: (V((0.1654,0.650878)), V((0.1579,0.649802)), V((0.1592,0.642436)), V((0.1670,0.643339)), ),
    14326: (V((0.1670,0.643339)), V((0.1592,0.642436)), V((0.1615,0.633277)), V((0.1689,0.634423)), ),
    14327: (V((0.1689,0.634423)), V((0.1615,0.633277)), V((0.1642,0.622297)), V((0.1714,0.623214)), ),
    14328: (V((0.1726,0.610548)), V((0.1659,0.610545)), V((0.1671,0.597948)), V((0.1725,0.597376)), ),
    14329: (V((0.3401,0.576364)), V((0.3388,0.592243)), V((0.3325,0.591689)), V((0.3323,0.571530)), ),
    14330: (V((0.1716,0.586836)), V((0.1657,0.588424)), V((0.1632,0.579893)), V((0.1694,0.576772)), ),
    14331: (V((0.1193,0.504422)), V((0.1279,0.503001)), V((0.1328,0.512712)), V((0.1252,0.513748)), ),
    14332: (V((0.1119,0.497237)), V((0.1120,0.490380)), V((0.1279,0.503001)), V((0.1193,0.504422)), ),
    14333: (V((0.1173,0.487651)), V((0.1120,0.490380)), V((0.1037,0.486105)), V((0.1062,0.484769)), ),
    14334: (V((0.0934,0.485195)), V((0.0953,0.481678)), V((0.1037,0.486105)), V((0.1007,0.489007)), ),
    14335: (V((0.3377,0.428975)), V((0.3387,0.428901)), V((0.3383,0.439304)), V((0.3352,0.439490)), ),
    14336: (V((0.3352,0.439490)), V((0.3383,0.439304)), V((0.3370,0.451442)), V((0.3349,0.450854)), ),
    14337: (V((0.3401,0.464817)), V((0.3356,0.463860)), V((0.3370,0.451442)), V((0.3401,0.451650)), ),
    14338: (V((0.3401,0.470848)), V((0.3344,0.471182)), V((0.3356,0.463860)), V((0.3401,0.464817)), ),
    14339: (V((0.3399,0.476496)), V((0.3334,0.477758)), V((0.3344,0.471182)), V((0.3401,0.470848)), ),
    14340: (V((0.1599,0.598681)), V((0.1600,0.589820)), V((0.1657,0.588424)), V((0.1671,0.597948)), ),
    14341: (V((0.3232,0.536358)), V((0.3318,0.534624)), V((0.3322,0.554710)), V((0.3240,0.555388)), ),
    14342: (V((0.3401,0.511954)), V((0.3401,0.533877)), V((0.3318,0.534624)), V((0.3315,0.513331)), ),
    14343: (V((0.1484,0.558907)), V((0.1426,0.544144)), V((0.1453,0.543037)), V((0.1522,0.556694)), ),
    14344: (V((0.1465,0.524661)), V((0.1531,0.538650)), V((0.1453,0.543037)), V((0.1402,0.526257)), ),
    14345: (V((0.2371,0.729951)), V((0.2255,0.723485)), V((0.2304,0.715388)), V((0.2415,0.722135)), ),
    14346: (V((0.2415,0.722135)), V((0.2304,0.715388)), V((0.2335,0.708121)), V((0.2457,0.713548)), ),
    14347: (V((0.2457,0.713548)), V((0.2335,0.708121)), V((0.2357,0.699745)), V((0.2501,0.705230)), ),
    14348: (V((0.2387,0.691602)), V((0.2533,0.695078)), V((0.2501,0.705230)), V((0.2357,0.699745)), ),
    14349: (V((0.2546,0.689342)), V((0.2402,0.684493)), V((0.2419,0.677980)), V((0.2560,0.682297)), ),
    14350: (V((0.2434,0.671761)), V((0.2579,0.676434)), V((0.2560,0.682297)), V((0.2419,0.677980)), ),
    14351: (V((0.2579,0.676434)), V((0.2434,0.671761)), V((0.2446,0.665368)), V((0.2596,0.670067)), ),
    14352: (V((0.2458,0.658048)), V((0.2611,0.662671)), V((0.2596,0.670067)), V((0.2446,0.665368)), ),
    14353: (V((0.2611,0.662671)), V((0.2458,0.658048)), V((0.2471,0.648796)), V((0.2621,0.652879)), ),
    14354: (V((0.2621,0.652879)), V((0.2471,0.648796)), V((0.2491,0.637305)), V((0.2628,0.639495)), ),
    14355: (V((0.2628,0.639495)), V((0.2491,0.637305)), V((0.2505,0.627759)), V((0.2627,0.626428)), ),
    14356: (V((0.2642,0.606803)), V((0.2494,0.604340)), V((0.2490,0.585421)), V((0.2645,0.587550)), ),
    14357: (V((0.2645,0.587550)), V((0.2490,0.585421)), V((0.2484,0.571890)), V((0.2645,0.573452)), ),
    14358: (V((0.2645,0.573452)), V((0.2484,0.571890)), V((0.2474,0.559427)), V((0.2648,0.560024)), ),
    14359: (V((0.2648,0.560024)), V((0.2474,0.559427)), V((0.2447,0.545085)), V((0.2612,0.543722)), ),
    14360: (V((0.2422,0.530616)), V((0.2601,0.528172)), V((0.2612,0.543722)), V((0.2447,0.545085)), ),
    14361: (V((0.2601,0.528172)), V((0.2422,0.530616)), V((0.2389,0.512016)), V((0.2588,0.508941)), ),
    14362: (V((0.2588,0.508941)), V((0.2389,0.512016)), V((0.2377,0.494855)), V((0.2560,0.491094)), ),
    14363: (V((0.2560,0.491094)), V((0.2377,0.494855)), V((0.2360,0.479703)), V((0.2544,0.477814)), ),
    14364: (V((0.2544,0.477814)), V((0.2360,0.479703)), V((0.2347,0.468498)), V((0.2522,0.465715)), ),
    14365: (V((0.2492,0.456519)), V((0.2335,0.460429)), V((0.2318,0.451150)), V((0.2470,0.447734)), ),
    14366: (V((0.4992,0.399790)), V((0.4902,0.399316)), V((0.4959,0.366554)), V((0.5044,0.367100)), ),
    14367: (V((0.5083,0.399463)), V((0.4992,0.399790)), V((0.5044,0.367100)), V((0.5131,0.367355)), ),
    14368: (V((0.2408,0.423956)), V((0.2261,0.427130)), V((0.2220,0.411965)), V((0.2368,0.409629)), ),
    14369: (V((0.2368,0.409629)), V((0.2220,0.411965)), V((0.2172,0.395266)), V((0.2316,0.393130)), ),
    14370: (V((0.2188,0.345669)), V((0.2059,0.347998)), V((0.2027,0.335925)), V((0.2158,0.332929)), ),
    14371: (V((0.2158,0.332929)), V((0.2027,0.335925)), V((0.2008,0.322826)), V((0.2117,0.320679)), ),
    14372: (V((0.2158,0.332929)), V((0.2117,0.320679)), V((0.2226,0.317951)), V((0.2254,0.329816)), ),
    14373: (V((0.2117,0.320679)), V((0.2008,0.322826)), V((0.1986,0.311508)), V((0.2089,0.309279)), ),
    14374: (V((0.2089,0.309279)), V((0.1986,0.311508)), V((0.1964,0.300648)), V((0.2068,0.298412)), ),
    14375: (V((0.4556,0.291952)), V((0.4505,0.287940)), V((0.4578,0.260075)), V((0.4626,0.264432)), ),
    14376: (V((0.4505,0.287940)), V((0.4453,0.283818)), V((0.4534,0.256122)), V((0.4578,0.260075)), ),
    14377: (V((0.2014,0.273083)), V((0.1914,0.276724)), V((0.1881,0.261663)), V((0.1979,0.257654)), ),
    14378: (V((0.1804,0.278675)), V((0.1699,0.279830)), V((0.1667,0.265702)), V((0.1772,0.264425)), ),
    14379: (V((0.4488,0.251895)), V((0.4534,0.256122)), V((0.4453,0.283818)), V((0.4386,0.277832)), ),
    14380: (V((0.4386,0.277832)), V((0.4316,0.272765)), V((0.4429,0.247784)), V((0.4488,0.251895)), ),
    14381: (V((0.1867,0.313740)), V((0.1757,0.315343)), V((0.1744,0.304196)), V((0.1852,0.302269)), ),
    14382: (V((0.1887,0.324739)), V((0.1781,0.326332)), V((0.1757,0.315343)), V((0.1867,0.313740)), ),
    14383: (V((0.2292,0.315833)), V((0.2325,0.327934)), V((0.2254,0.329816)), V((0.2226,0.317951)), ),
    14384: (V((0.2361,0.312762)), V((0.2403,0.325281)), V((0.2325,0.327934)), V((0.2292,0.315833)), ),
    14385: (V((0.1796,0.339462)), V((0.1906,0.337705)), V((0.1929,0.350550)), V((0.1814,0.352268)), ),
    14386: (V((0.2434,0.337251)), V((0.2501,0.350603)), V((0.2402,0.355715)), V((0.2361,0.340845)), ),
    14387: (V((0.2068,0.413771)), V((0.1922,0.416903)), V((0.1900,0.399316)), V((0.2027,0.397671)), ),
    14388: (V((0.2103,0.429421)), V((0.1942,0.433175)), V((0.1922,0.416903)), V((0.2068,0.413771)), ),
    14389: (V((0.5377,0.367902)), V((0.5460,0.369688)), V((0.5411,0.395607)), V((0.5329,0.396338)), ),
    14390: (V((0.5329,0.396338)), V((0.5245,0.397343)), V((0.5291,0.367290)), V((0.5377,0.367902)), ),
    14391: (V((0.2170,0.464369)), V((0.1985,0.467705)), V((0.1980,0.458239)), V((0.2154,0.455106)), ),
    14392: (V((0.2185,0.483675)), V((0.1987,0.489965)), V((0.1983,0.477934)), V((0.2180,0.472598)), ),
    14393: (V((0.2204,0.499035)), V((0.2020,0.504084)), V((0.1987,0.489965)), V((0.2185,0.483675)), ),
    14394: (V((0.2214,0.515721)), V((0.2062,0.518877)), V((0.2020,0.504084)), V((0.2204,0.499035)), ),
    14395: (V((0.2250,0.531682)), V((0.2107,0.534204)), V((0.2062,0.518877)), V((0.2214,0.515721)), ),
    14396: (V((0.2107,0.534204)), V((0.2250,0.531682)), V((0.2286,0.545769)), V((0.2147,0.547516)), ),
    14397: (V((0.2317,0.559507)), V((0.2188,0.560057)), V((0.2147,0.547516)), V((0.2286,0.545769)), ),
    14398: (V((0.2333,0.573217)), V((0.2200,0.572584)), V((0.2188,0.560057)), V((0.2317,0.559507)), ),
    14399: (V((0.2339,0.587295)), V((0.2204,0.587784)), V((0.2200,0.572584)), V((0.2333,0.573217)), ),
    14400: (V((0.2329,0.604804)), V((0.2203,0.602447)), V((0.2204,0.587784)), V((0.2339,0.587295)), ),
    14401: (V((0.2206,0.622152)), V((0.2329,0.625231)), V((0.2326,0.635794)), V((0.2198,0.634923)), ),
    14402: (V((0.2198,0.634923)), V((0.2326,0.635794)), V((0.2335,0.646897)), V((0.2201,0.645684)), ),
    14403: (V((0.2329,0.655463)), V((0.2194,0.654861)), V((0.2201,0.645684)), V((0.2335,0.646897)), ),
    14404: (V((0.2194,0.654861)), V((0.2329,0.655463)), V((0.2313,0.662907)), V((0.2184,0.662040)), ),
    14405: (V((0.2302,0.669353)), V((0.2182,0.668074)), V((0.2184,0.662040)), V((0.2313,0.662907)), ),
    14406: (V((0.2182,0.668074)), V((0.2302,0.669353)), V((0.2287,0.675531)), V((0.2168,0.673844)), ),
    14407: (V((0.2271,0.681971)), V((0.2169,0.679669)), V((0.2168,0.673844)), V((0.2287,0.675531)), ),
    14408: (V((0.2164,0.685531)), V((0.2259,0.688638)), V((0.2248,0.695295)), V((0.2154,0.691719)), ),
    14409: (V((0.0995,0.764813)), V((0.1090,0.769456)), V((0.1056,0.776070)), V((0.0953,0.770725)), ),
    14410: (V((0.1040,0.757899)), V((0.1124,0.761575)), V((0.1090,0.769456)), V((0.0995,0.764813)), ),
    14411: (V((0.0895,0.783856)), V((0.0877,0.793637)), V((0.0790,0.788378)), V((0.0817,0.779055)), ),
    14412: (V((0.0817,0.779055)), V((0.0790,0.788378)), V((0.0696,0.783130)), V((0.0723,0.774382)), ),
    14413: (V((0.0723,0.774382)), V((0.0696,0.783130)), V((0.0570,0.777173)), V((0.0601,0.767843)), ),
    14414: (V((0.0601,0.767843)), V((0.0570,0.777173)), V((0.0432,0.768940)), V((0.0465,0.759905)), ),
    14415: (V((0.0465,0.759905)), V((0.0432,0.768940)), V((0.0292,0.757553)), V((0.0346,0.749063)), ),
    14416: (V((0.0346,0.749063)), V((0.0292,0.757553)), V((0.0180,0.746252)), V((0.0238,0.739179)), ),
    14417: (V((0.0238,0.739179)), V((0.0180,0.746252)), V((0.0046,0.735553)), V((0.0090,0.728292)), ),
    14418: (V((0.7717,0.901075)), V((0.7757,0.909964)), V((0.7589,0.910987)), V((0.7550,0.906152)), ),
    14419: (V((0.1111,0.747959)), V((0.1177,0.750234)), V((0.1124,0.761575)), V((0.1040,0.757899)), ),
    14420: (V((0.1185,0.740742)), V((0.1177,0.750234)), V((0.1111,0.747959)), V((0.1114,0.739307)), ),
    14421: (V((0.0779,0.794123)), V((0.0790,0.788378)), V((0.0877,0.793637)), V((0.0869,0.799501)), ),
    14422: (V((0.0790,0.788378)), V((0.0779,0.794123)), V((0.0678,0.789824)), V((0.0696,0.783130)), ),
    14423: (V((0.0543,0.784135)), V((0.0570,0.777173)), V((0.0696,0.783130)), V((0.0678,0.789824)), ),
    14424: (V((0.0397,0.775214)), V((0.0432,0.768940)), V((0.0570,0.777173)), V((0.0543,0.784135)), ),
    14425: (V((0.0259,0.763378)), V((0.0292,0.757553)), V((0.0432,0.768940)), V((0.0397,0.775214)), ),
    14426: (V((0.0163,0.753259)), V((0.0180,0.746252)), V((0.0292,0.757553)), V((0.0259,0.763378)), ),
    14427: (V((0.0053,0.745937)), V((0.0046,0.735553)), V((0.0180,0.746252)), V((0.0163,0.753259)), ),
    14428: (V((0.7757,0.909964)), V((0.7747,0.916113)), V((0.7612,0.916845)), V((0.7589,0.910987)), ),
    14429: (V((0.1733,0.756968)), V((0.1682,0.766248)), V((0.1551,0.762285)), V((0.1596,0.753324)), ),
    14430: (V((0.1595,0.825436)), V((0.1610,0.815442)), V((0.1725,0.820025)), V((0.1687,0.830459)), ),
    14431: (V((0.1687,0.830459)), V((0.1725,0.820025)), V((0.1825,0.824663)), V((0.1784,0.834770)), ),
    14432: (V((0.1784,0.834770)), V((0.1825,0.824663)), V((0.1919,0.828867)), V((0.1863,0.839255)), ),
    14433: (V((0.1863,0.839255)), V((0.1919,0.828867)), V((0.2026,0.832776)), V((0.1961,0.843806)), ),
    14434: (V((0.1961,0.843806)), V((0.2026,0.832776)), V((0.2115,0.838264)), V((0.2034,0.849405)), ),
    14435: (V((0.2034,0.849405)), V((0.2115,0.838264)), V((0.2175,0.847288)), V((0.2092,0.857857)), ),
    14436: (V((0.2234,0.857984)), V((0.2143,0.868325)), V((0.2092,0.857857)), V((0.2175,0.847288)), ),
    14437: (V((0.2296,0.869451)), V((0.2179,0.878565)), V((0.2143,0.868325)), V((0.2234,0.857984)), ),
    14438: (V((0.2179,0.878565)), V((0.2296,0.869451)), V((0.2310,0.892759)), V((0.2227,0.896529)), ),
    14439: (V((0.2346,0.905541)), V((0.2261,0.908447)), V((0.2227,0.896529)), V((0.2310,0.892759)), ),
    14440: (V((0.2261,0.908447)), V((0.2346,0.905541)), V((0.2389,0.914231)), V((0.2296,0.918838)), ),
    14441: (V((0.1979,0.257654)), V((0.1881,0.261663)), V((0.1839,0.245153)), V((0.1935,0.241326)), ),
    14442: (V((0.1935,0.241326)), V((0.1839,0.245153)), V((0.1792,0.226222)), V((0.1888,0.222790)), ),
    14443: (V((0.1737,0.203960)), V((0.1841,0.202110)), V((0.1888,0.222790)), V((0.1792,0.226222)), ),
    14444: (V((0.2657,0.809033)), V((0.2728,0.797284)), V((0.2803,0.806285)), V((0.2716,0.816477)), ),
    14445: (V((0.2549,0.802328)), V((0.2611,0.790446)), V((0.2728,0.797284)), V((0.2657,0.809033)), ),
    14446: (V((0.2444,0.796597)), V((0.2493,0.786064)), V((0.2611,0.790446)), V((0.2549,0.802328)), ),
    14447: (V((0.2315,0.790814)), V((0.2369,0.781154)), V((0.2493,0.786064)), V((0.2444,0.796597)), ),
    14448: (V((0.2369,0.781154)), V((0.2315,0.790814)), V((0.2172,0.785374)), V((0.2233,0.775158)), ),
    14449: (V((0.2027,0.779616)), V((0.2084,0.769247)), V((0.2233,0.775158)), V((0.2172,0.785374)), ),
    14450: (V((0.1893,0.773564)), V((0.1961,0.764792)), V((0.2084,0.769247)), V((0.2027,0.779616)), ),
    14451: (V((0.1798,0.770539)), V((0.1854,0.761746)), V((0.1961,0.764792)), V((0.1893,0.773564)), ),
    14452: (V((0.1854,0.761746)), V((0.1798,0.770539)), V((0.1682,0.766248)), V((0.1733,0.756968)), ),
    14453: (V((0.1721,0.727866)), V((0.1861,0.729832)), V((0.1811,0.744308)), V((0.1658,0.740974)), ),
    14454: (V((0.1733,0.756968)), V((0.1596,0.753324)), V((0.1658,0.740974)), V((0.1811,0.744308)), ),
    14455: (V((0.1596,0.753324)), V((0.1551,0.762285)), V((0.1437,0.757769)), V((0.1476,0.748439)), ),
    14456: (V((0.1476,0.748439)), V((0.1437,0.757769)), V((0.1335,0.755074)), V((0.1369,0.744831)), ),
    14457: (V((0.1369,0.744831)), V((0.1335,0.755074)), V((0.1249,0.752454)), V((0.1262,0.742789)), ),
    14458: (V((0.1185,0.740742)), V((0.1114,0.739307)), V((0.1172,0.727853)), V((0.1241,0.728468)), ),
    14459: (V((0.1189,0.712607)), V((0.1274,0.714009)), V((0.1241,0.728468)), V((0.1172,0.727853)), ),
    14460: (V((0.1021,0.745085)), V((0.1054,0.737744)), V((0.1114,0.739307)), V((0.1111,0.747959)), ),
    14461: (V((0.1054,0.737744)), V((0.1021,0.745085)), V((0.0903,0.742483)), V((0.0959,0.735371)), ),
    14462: (V((0.0959,0.735371)), V((0.0903,0.742483)), V((0.0764,0.737792)), V((0.0820,0.730995)), ),
    14463: (V((0.0820,0.730995)), V((0.0764,0.737792)), V((0.0620,0.730383)), V((0.0668,0.724272)), ),
    14464: (V((0.0481,0.722640)), V((0.0521,0.717422)), V((0.0668,0.724272)), V((0.0620,0.730383)), ),
    14465: (V((0.0360,0.715752)), V((0.0393,0.711188)), V((0.0521,0.717422)), V((0.0481,0.722640)), ),
    14466: (V((0.0211,0.707307)), V((0.0239,0.701636)), V((0.0393,0.711188)), V((0.0360,0.715752)), ),
    14467: (V((0.7691,0.846631)), V((0.7687,0.858357)), V((0.7530,0.856638)), V((0.7533,0.844930)), ),
    14468: (V((0.2933,0.458631)), V((0.2881,0.445994)), V((0.2995,0.441249)), V((0.3064,0.454110)), ),
    14469: (V((0.2881,0.445994)), V((0.2933,0.458631)), V((0.2789,0.461968)), V((0.2753,0.450803)), ),
    14470: (V((0.2753,0.450803)), V((0.2789,0.461968)), V((0.2647,0.464467)), V((0.2633,0.453592)), ),
    14471: (V((0.2522,0.465715)), V((0.2492,0.456519)), V((0.2633,0.453592)), V((0.2647,0.464467)), ),
    14472: (V((0.2347,0.468498)), V((0.2335,0.460429)), V((0.2492,0.456519)), V((0.2522,0.465715)), ),
    14473: (V((0.1906,0.337705)), V((0.2027,0.335925)), V((0.2059,0.347998)), V((0.1929,0.350550)), ),
    14474: (V((0.2059,0.347998)), V((0.2092,0.363460)), V((0.1953,0.365512)), V((0.1929,0.350550)), ),
    14475: (V((0.1983,0.477934)), V((0.1985,0.467705)), V((0.2170,0.464369)), V((0.2180,0.472598)), ),
    14476: (V((0.1833,0.482240)), V((0.1850,0.470148)), V((0.1985,0.467705)), V((0.1983,0.477934)), ),
    14477: (V((0.1850,0.470148)), V((0.1833,0.482240)), V((0.1705,0.485725)), V((0.1728,0.471446)), ),
    14478: (V((0.1587,0.489504)), V((0.1619,0.470645)), V((0.1728,0.471446)), V((0.1705,0.485725)), ),
    14479: (V((0.1440,0.488330)), V((0.1496,0.467767)), V((0.1619,0.470645)), V((0.1587,0.489504)), ),
    14480: (V((0.1338,0.474936)), V((0.1384,0.461601)), V((0.1496,0.467767)), V((0.1440,0.488330)), ),
    14481: (V((0.1219,0.469118)), V((0.1284,0.456059)), V((0.1384,0.461601)), V((0.1338,0.474936)), ),
    14482: (V((0.1284,0.456059)), V((0.1219,0.469118)), V((0.1105,0.463734)), V((0.1192,0.450236)), ),
    14483: (V((0.3316,0.416170)), V((0.3345,0.424324)), V((0.3297,0.432242)), V((0.3251,0.421391)), ),
    14484: (V((0.3251,0.421391)), V((0.3297,0.432242)), V((0.3255,0.439591)), V((0.3187,0.427784)), ),
    14485: (V((0.3187,0.427784)), V((0.3255,0.439591)), V((0.3173,0.447298)), V((0.3095,0.434130)), ),
    14486: (V((0.3095,0.434130)), V((0.3173,0.447298)), V((0.3064,0.454110)), V((0.2995,0.441249)), ),
    14487: (V((0.2361,0.340845)), V((0.2402,0.355715)), V((0.2321,0.358787)), V((0.2281,0.343547)), ),
    14488: (V((0.2092,0.363460)), V((0.2059,0.347998)), V((0.2188,0.345669)), V((0.2226,0.361977)), ),
    14489: (V((0.1757,0.367100)), V((0.1728,0.352893)), V((0.1814,0.352268)), V((0.1843,0.366554)), ),
    14490: (V((0.1591,0.367586)), V((0.1557,0.354187)), V((0.1639,0.353223)), V((0.1670,0.367355)), ),
    14491: (V((0.1424,0.367902)), V((0.1385,0.355212)), V((0.1475,0.354591)), V((0.1510,0.367290)), ),
    14492: (V((0.1304,0.356957)), V((0.1341,0.369688)), V((0.1264,0.371451)), V((0.1233,0.359162)), ),
    14493: (V((0.2755,0.317270)), V((0.2804,0.331019)), V((0.2733,0.335537)), V((0.2680,0.321606)), ),
    14494: (V((0.2602,0.327186)), V((0.2666,0.340806)), V((0.2575,0.347023)), V((0.2510,0.333220)), ),
    14495: (V((0.2501,0.350603)), V((0.2434,0.337251)), V((0.2510,0.333220)), V((0.2575,0.347023)), ),
    14496: (V((0.2680,0.321606)), V((0.2733,0.335537)), V((0.2666,0.340806)), V((0.2602,0.327186)), ),
    14497: (V((0.2838,0.312832)), V((0.2897,0.326481)), V((0.2804,0.331019)), V((0.2755,0.317270)), ),
    14498: (V((0.1341,0.369688)), V((0.1304,0.356957)), V((0.1385,0.355212)), V((0.1424,0.367902)), ),
    14499: (V((0.1510,0.367290)), V((0.1475,0.354591)), V((0.1557,0.354187)), V((0.1591,0.367586)), ),
    14500: (V((0.1728,0.352893)), V((0.1757,0.367100)), V((0.1670,0.367355)), V((0.1639,0.353223)), ),
    14501: (V((0.1929,0.350550)), V((0.1953,0.365512)), V((0.1843,0.366554)), V((0.1814,0.352268)), ),
    14502: (V((0.1772,0.264425)), V((0.1667,0.265702)), V((0.1634,0.250367)), V((0.1735,0.248453)), ),
    14503: (V((0.1735,0.248453)), V((0.1634,0.250367)), V((0.1596,0.231831)), V((0.1693,0.229121)), ),
    14504: (V((0.1546,0.208059)), V((0.1642,0.205716)), V((0.1693,0.229121)), V((0.1596,0.231831)), ),
    14505: (V((0.2827,0.692209)), V((0.2804,0.697979)), V((0.2692,0.694143)), V((0.2717,0.688032)), ),
    14506: (V((0.3267,0.699317)), V((0.3263,0.704864)), V((0.3153,0.704920)), V((0.3162,0.698405)), ),
    14507: (V((0.3162,0.698405)), V((0.3153,0.704920)), V((0.3027,0.704145)), V((0.3047,0.697790)), ),
    14508: (V((0.3047,0.697790)), V((0.3027,0.704145)), V((0.2911,0.701238)), V((0.2932,0.695253)), ),
    14509: (V((0.2932,0.695253)), V((0.2911,0.701238)), V((0.2804,0.697979)), V((0.2827,0.692209)), ),
    14510: (V((0.1971,0.671129)), V((0.1971,0.674447)), V((0.1878,0.673057)), V((0.1881,0.669872)), ),
    14511: (V((0.2220,0.411965)), V((0.2068,0.413771)), V((0.2027,0.397671)), V((0.2172,0.395266)), ),
    14512: (V((0.1785,0.903557)), V((0.1690,0.907247)), V((0.1656,0.896167)), V((0.1750,0.892721)), ),
    14513: (V((0.1750,0.892721)), V((0.1656,0.896167)), V((0.1621,0.885587)), V((0.1716,0.881950)), ),
    14514: (V((0.2051,0.684138)), V((0.2044,0.677993)), V((0.2169,0.679669)), V((0.2164,0.685531)), ),
    14515: (V((0.2261,0.427130)), V((0.2103,0.429421)), V((0.2068,0.413771)), V((0.2220,0.411965)), ),
    14516: (V((0.2717,0.688032)), V((0.2692,0.694143)), V((0.2546,0.689342)), V((0.2560,0.682297)), ),
    14517: (V((0.1681,0.872037)), V((0.1584,0.874440)), V((0.1588,0.866344)), V((0.1653,0.864551)), ),
    14518: (V((0.1785,0.903557)), V((0.1817,0.913702)), V((0.1720,0.916577)), V((0.1690,0.907247)), ),
    14519: (V((0.1842,0.923244)), V((0.1864,0.932554)), V((0.1804,0.933745)), V((0.1741,0.925460)), ),
    14520: (V((0.3401,0.699559)), V((0.3405,0.704581)), V((0.3263,0.704864)), V((0.3267,0.699317)), ),
    14521: (V((0.1817,0.913702)), V((0.1842,0.923244)), V((0.1741,0.925460)), V((0.1720,0.916577)), ),
    14522: (V((0.2533,0.695078)), V((0.2387,0.691602)), V((0.2402,0.684493)), V((0.2546,0.689342)), ),
    14523: (V((0.2259,0.688638)), V((0.2164,0.685531)), V((0.2169,0.679669)), V((0.2271,0.681971)), ),
    14524: (V((0.1262,0.742789)), V((0.1185,0.740742)), V((0.1241,0.728468)), V((0.1304,0.729093)), ),
    14525: (V((0.1274,0.714009)), V((0.1357,0.717059)), V((0.1304,0.729093)), V((0.1241,0.728468)), ),
    14526: (V((0.1249,0.752454)), V((0.1177,0.750234)), V((0.1185,0.740742)), V((0.1262,0.742789)), ),
    14527: (V((0.1177,0.750234)), V((0.1249,0.752454)), V((0.1219,0.765095)), V((0.1124,0.761575)), ),
    14528: (V((0.1124,0.761575)), V((0.1219,0.765095)), V((0.1198,0.773440)), V((0.1090,0.769456)), ),
    14529: (V((0.1090,0.769456)), V((0.1198,0.773440)), V((0.1181,0.781200)), V((0.1056,0.776070)), ),
    14530: (V((0.1056,0.776070)), V((0.1181,0.781200)), V((0.1160,0.788251)), V((0.1026,0.781791)), ),
    14531: (V((0.1026,0.781791)), V((0.1160,0.788251)), V((0.1149,0.797165)), V((0.1005,0.789136)), ),
    14532: (V((0.1005,0.789136)), V((0.1149,0.797165)), V((0.1134,0.806414)), V((0.1004,0.800680)), ),
    14533: (V((0.1123,0.814813)), V((0.0998,0.807100)), V((0.1004,0.800680)), V((0.1134,0.806414)), ),
    14534: (V((0.1381,0.688729)), V((0.1486,0.692672)), V((0.1410,0.708159)), V((0.1328,0.704767)), ),
    14535: (V((0.5245,0.397343)), V((0.5165,0.398334)), V((0.5210,0.367586)), V((0.5291,0.367290)), ),
    14536: (V((0.5165,0.398334)), V((0.5083,0.399463)), V((0.5131,0.367355)), V((0.5210,0.367586)), ),
    14537: (V((0.2474,0.909032)), V((0.2421,0.901206)), V((0.2509,0.896890)), V((0.2548,0.904159)), ),
    14538: (V((0.2479,0.851525)), V((0.2530,0.841986)), V((0.2612,0.846744)), V((0.2551,0.856576)), ),
    14539: (V((0.2421,0.901206)), V((0.2382,0.889307)), V((0.2481,0.885100)), V((0.2509,0.896890)), ),
    14540: (V((0.2388,0.870973)), V((0.2479,0.851525)), V((0.2551,0.856576)), V((0.2497,0.870796)), ),
    14541: (V((0.2382,0.889307)), V((0.2388,0.870973)), V((0.2497,0.870796)), V((0.2481,0.885100)), ),
    14542: (V((0.2548,0.904159)), V((0.2509,0.896890)), V((0.2600,0.892559)), V((0.2627,0.899668)), ),
    14543: (V((0.2551,0.856576)), V((0.2612,0.846744)), V((0.2698,0.850928)), V((0.2648,0.858705)), ),
    14544: (V((0.2509,0.896890)), V((0.2481,0.885100)), V((0.2582,0.881464)), V((0.2600,0.892559)), ),
    14545: (V((0.2481,0.885100)), V((0.2497,0.870796)), V((0.2604,0.868682)), V((0.2582,0.881464)), ),
    14546: (V((0.2497,0.870796)), V((0.2551,0.856576)), V((0.2648,0.858705)), V((0.2604,0.868682)), ),
    14547: (V((0.2627,0.899668)), V((0.2600,0.892559)), V((0.2690,0.887475)), V((0.2716,0.893509)), ),
    14548: (V((0.2648,0.858705)), V((0.2698,0.850928)), V((0.2797,0.854037)), V((0.2751,0.860140)), ),
    14549: (V((0.2600,0.892559)), V((0.2582,0.881464)), V((0.2682,0.877837)), V((0.2690,0.887475)), ),
    14550: (V((0.2582,0.881464)), V((0.2604,0.868682)), V((0.2710,0.868046)), V((0.2682,0.877837)), ),
    14551: (V((0.2604,0.868682)), V((0.2648,0.858705)), V((0.2751,0.860140)), V((0.2710,0.868046)), ),
    14552: (V((0.2716,0.893509)), V((0.2690,0.887475)), V((0.2770,0.882332)), V((0.2774,0.887159)), ),
    14553: (V((0.2751,0.860140)), V((0.2797,0.854037)), V((0.2881,0.857366)), V((0.2839,0.862863)), ),
    14554: (V((0.2690,0.887475)), V((0.2682,0.877837)), V((0.2768,0.875190)), V((0.2770,0.882332)), ),
    14555: (V((0.2682,0.877837)), V((0.2710,0.868046)), V((0.2809,0.867741)), V((0.2768,0.875190)), ),
    14556: (V((0.2710,0.868046)), V((0.2751,0.860140)), V((0.2839,0.862863)), V((0.2809,0.867741)), ),
    14557: (V((0.2774,0.887159)), V((0.2770,0.882332)), V((0.2820,0.880004)), V((0.2818,0.883420)), ),
    14558: (V((0.2839,0.862863)), V((0.2881,0.857366)), V((0.2930,0.859603)), V((0.2900,0.863251)), ),
    14559: (V((0.2770,0.882332)), V((0.2768,0.875190)), V((0.2830,0.875509)), V((0.2820,0.880004)), ),
    14560: (V((0.2768,0.875190)), V((0.2809,0.867741)), V((0.2859,0.869366)), V((0.2830,0.875509)), ),
    14561: (V((0.2809,0.867741)), V((0.2839,0.862863)), V((0.2900,0.863251)), V((0.2859,0.869366)), ),
    14562: (V((0.3067,0.775889)), V((0.3247,0.776830)), V((0.3255,0.789985)), V((0.3114,0.793247)), ),
    14563: (V((0.2803,0.806285)), V((0.2921,0.788143)), V((0.2999,0.801668)), V((0.2877,0.812772)), ),
    14564: (V((0.2921,0.788143)), V((0.3067,0.775889)), V((0.3114,0.793247)), V((0.2999,0.801668)), ),
    14565: (V((0.3247,0.776830)), V((0.3401,0.776801)), V((0.3396,0.791067)), V((0.3255,0.789985)), ),
    14566: (V((0.3114,0.793247)), V((0.3255,0.789985)), V((0.3271,0.802827)), V((0.3157,0.805903)), ),
    14567: (V((0.3255,0.789985)), V((0.3396,0.791067)), V((0.3401,0.803126)), V((0.3271,0.802827)), ),
    14568: (V((0.2877,0.812772)), V((0.2999,0.801668)), V((0.3030,0.812876)), V((0.2940,0.820020)), ),
    14569: (V((0.2999,0.801668)), V((0.3114,0.793247)), V((0.3157,0.805903)), V((0.3030,0.812876)), ),
    14570: (V((0.2940,0.820020)), V((0.3030,0.812876)), V((0.3070,0.821693)), V((0.2999,0.827675)), ),
    14571: (V((0.3030,0.812876)), V((0.3157,0.805903)), V((0.3170,0.817132)), V((0.3070,0.821693)), ),
    14572: (V((0.3157,0.805903)), V((0.3271,0.802827)), V((0.3280,0.814505)), V((0.3170,0.817132)), ),
    14573: (V((0.3271,0.802827)), V((0.3401,0.803126)), V((0.3401,0.813443)), V((0.3280,0.814505)), ),
    14574: (V((0.3170,0.817132)), V((0.3280,0.814505)), V((0.3292,0.822884)), V((0.3173,0.825029)), ),
    14575: (V((0.3280,0.814505)), V((0.3401,0.813443)), V((0.3401,0.821829)), V((0.3292,0.822884)), ),
    14576: (V((0.2999,0.827675)), V((0.3070,0.821693)), V((0.3094,0.830495)), V((0.3036,0.835509)), ),
    14577: (V((0.3070,0.821693)), V((0.3170,0.817132)), V((0.3173,0.825029)), V((0.3094,0.830495)), ),
    14578: (V((0.3094,0.830495)), V((0.3173,0.825029)), V((0.3183,0.830354)), V((0.3117,0.837073)), ),
    14579: (V((0.3173,0.825029)), V((0.3292,0.822884)), V((0.3290,0.827884)), V((0.3183,0.830354)), ),
    14580: (V((0.3292,0.822884)), V((0.3401,0.821829)), V((0.3401,0.829754)), V((0.3290,0.827884)), ),
    14581: (V((0.3036,0.835509)), V((0.3094,0.830495)), V((0.3117,0.837073)), V((0.3065,0.842370)), ),
    14582: (V((0.2590,0.833525)), V((0.2644,0.826415)), V((0.2723,0.830938)), V((0.2665,0.839572)), ),
    14583: (V((0.2644,0.826415)), V((0.2716,0.816477)), V((0.2795,0.822209)), V((0.2723,0.830938)), ),
    14584: (V((0.2665,0.839572)), V((0.2723,0.830938)), V((0.2809,0.836112)), V((0.2749,0.844157)), ),
    14585: (V((0.2723,0.830938)), V((0.2795,0.822209)), V((0.2866,0.827542)), V((0.2809,0.836112)), ),
    14586: (V((0.2749,0.844157)), V((0.2809,0.836112)), V((0.2878,0.842314)), V((0.2830,0.848612)), ),
    14587: (V((0.2809,0.836112)), V((0.2866,0.827542)), V((0.2933,0.834161)), V((0.2878,0.842314)), ),
    14588: (V((0.2830,0.848612)), V((0.2878,0.842314)), V((0.2935,0.847230)), V((0.2907,0.852467)), ),
    14589: (V((0.2878,0.842314)), V((0.2933,0.834161)), V((0.2973,0.842377)), V((0.2935,0.847230)), ),
    14590: (V((0.2907,0.852467)), V((0.2935,0.847230)), V((0.2988,0.851824)), V((0.2958,0.855373)), ),
    14591: (V((0.2935,0.847230)), V((0.2973,0.842377)), V((0.3020,0.847909)), V((0.2988,0.851824)), ),
    14592: (V((0.2795,0.822209)), V((0.2716,0.816477)), V((0.2803,0.806285)), V((0.2877,0.812772)), ),
    14593: (V((0.2940,0.820020)), V((0.2866,0.827542)), V((0.2795,0.822209)), V((0.2877,0.812772)), ),
    14594: (V((0.2999,0.827675)), V((0.2933,0.834161)), V((0.2866,0.827542)), V((0.2940,0.820020)), ),
    14595: (V((0.3036,0.835509)), V((0.2973,0.842377)), V((0.2933,0.834161)), V((0.2999,0.827675)), ),
    14596: (V((0.3065,0.842370)), V((0.3020,0.847909)), V((0.2973,0.842377)), V((0.3036,0.835509)), ),
    14597: (V((0.2881,0.857366)), V((0.2907,0.852467)), V((0.2958,0.855373)), V((0.2930,0.859603)), ),
    14598: (V((0.2797,0.854037)), V((0.2830,0.848612)), V((0.2907,0.852467)), V((0.2881,0.857366)), ),
    14599: (V((0.2698,0.850928)), V((0.2749,0.844157)), V((0.2830,0.848612)), V((0.2797,0.854037)), ),
    14600: (V((0.2612,0.846744)), V((0.2665,0.839572)), V((0.2749,0.844157)), V((0.2698,0.850928)), ),
    14601: (V((0.2590,0.833525)), V((0.2665,0.839572)), V((0.2612,0.846744)), V((0.2530,0.841986)), ),
    14602: (V((0.1295,0.159231)), V((0.1354,0.168100)), V((0.1311,0.172681)), V((0.1248,0.163272)), ),
    14603: (V((0.1142,0.184100)), V((0.1095,0.176336)), V((0.1141,0.171660)), V((0.1195,0.180311)), ),
    14604: (V((0.1734,0.142287)), V((0.1744,0.152210)), V((0.1702,0.149390)), V((0.1687,0.139285)), ),
    14605: (V((0.1782,0.145195)), V((0.1794,0.155076)), V((0.1744,0.152210)), V((0.1734,0.142287)), ),
    14606: (V((0.1097,0.187081)), V((0.1052,0.179219)), V((0.1095,0.176336)), V((0.1142,0.184100)), ),
    14607: (V((0.1195,0.180311)), V((0.1141,0.171660)), V((0.1193,0.167736)), V((0.1251,0.176897)), ),
    14608: (V((0.1878,0.147001)), V((0.1907,0.158195)), V((0.1878,0.159315)), V((0.1834,0.147762)), ),
    14609: (V((0.1687,0.139285)), V((0.1702,0.149390)), V((0.1677,0.147726)), V((0.1663,0.137728)), ),
    14610: (V((0.1052,0.179219)), V((0.1097,0.187081)), V((0.1053,0.189735)), V((0.1009,0.181337)), ),
    14611: (V((0.1794,0.155076)), V((0.1782,0.145195)), V((0.1834,0.147762)), V((0.1878,0.159315)), ),
    14612: (V((0.1295,0.159231)), V((0.1361,0.152878)), V((0.1422,0.162395)), V((0.1354,0.168100)), ),
    14613: (V((0.1546,0.208059)), V((0.1476,0.209308)), V((0.1311,0.172681)), V((0.1354,0.168100)), ),
    14614: (V((0.1476,0.209308)), V((0.1386,0.211250)), V((0.1251,0.176897)), V((0.1311,0.172681)), ),
    14615: (V((0.1195,0.180311)), V((0.1251,0.176897)), V((0.1386,0.211250)), V((0.1320,0.215251)), ),
    14616: (V((0.2147,0.190799)), V((0.2093,0.193069)), V((0.1744,0.152210)), V((0.1794,0.155076)), ),
    14617: (V((0.2026,0.195993)), V((0.1677,0.147726)), V((0.1702,0.149390)), V((0.2059,0.194722)), ),
    14618: (V((0.1537,0.151817)), V((0.1572,0.149727)), V((0.1907,0.201240)), V((0.1841,0.202110)), ),
    14619: (V((0.1962,0.198298)), V((0.1907,0.201240)), V((0.1572,0.149727)), V((0.1618,0.146990)), ),
    14620: (V((0.1994,0.197156)), V((0.1962,0.198298)), V((0.1618,0.146990)), V((0.1645,0.146680)), ),
    14621: (V((0.1645,0.146680)), V((0.1677,0.147726)), V((0.2026,0.195993)), V((0.1994,0.197156)), ),
    14622: (V((0.2147,0.190799)), V((0.1794,0.155076)), V((0.1878,0.159315)), V((0.2157,0.189625)), ),
    14623: (V((0.1737,0.203960)), V((0.1642,0.205716)), V((0.1422,0.162395)), V((0.1480,0.156907)), ),
    14624: (V((0.1841,0.202110)), V((0.1737,0.203960)), V((0.1480,0.156907)), V((0.1537,0.151817)), ),
    14625: (V((0.1642,0.205716)), V((0.1546,0.208059)), V((0.1354,0.168100)), V((0.1422,0.162395)), ),
    14626: (V((0.2036,0.107866)), V((0.2083,0.112975)), V((0.2056,0.116000)), V((0.2000,0.110343)), ),
    14627: (V((0.2049,0.043956)), V((0.2033,0.049701)), V((0.2016,0.048512)), V((0.2047,0.042493)), ),
    14628: (V((0.1983,0.083943)), V((0.1956,0.093755)), V((0.1918,0.095002)), V((0.1923,0.084009)), ),
    14629: (V((0.2224,0.143407)), V((0.2195,0.135804)), V((0.2232,0.133201)), V((0.2260,0.140551)), ),
    14630: (V((0.1643,0.020000)), V((0.1322,0.028400)), V((0.1310,0.028800)), V((0.0551,0.051255)), ),
    14631: (V((0.2033,0.049701)), V((0.1984,0.063070)), V((0.1959,0.061586)), V((0.2016,0.048512)), ),
    14632: (V((0.1984,0.063070)), V((0.1965,0.072705)), V((0.1935,0.071749)), V((0.1959,0.061586)), ),
    14633: (V((0.2083,0.112975)), V((0.2139,0.118454)), V((0.2120,0.121011)), V((0.2056,0.116000)), ),
    14634: (V((0.2265,0.153109)), V((0.2224,0.143407)), V((0.2260,0.140551)), V((0.2298,0.150908)), ),
    14635: (V((0.1956,0.093755)), V((0.1987,0.103897)), V((0.1943,0.105564)), V((0.1918,0.095002)), ),
    14636: (V((0.1042,0.055993)), V((0.1066,0.063094)), V((0.1043,0.063669)), V((0.1046,0.055400)), ),
    14637: (V((0.1965,0.072705)), V((0.1983,0.083943)), V((0.1923,0.084009)), V((0.1935,0.071749)), ),
    14638: (V((0.1136,0.078251)), V((0.1159,0.093469)), V((0.1110,0.094002)), V((0.1104,0.079910)), ),
    14639: (V((0.2147,0.128820)), V((0.2091,0.124064)), V((0.2120,0.121011)), V((0.2176,0.125630)), ),
    14640: (V((0.1148,0.046900)), V((0.1148,0.046900)), V((0.1310,0.028800)), V((0.1322,0.028400)), ),
    14641: (V((0.1066,0.063094)), V((0.1136,0.078251)), V((0.1104,0.079910)), V((0.1043,0.063669)), ),
    14642: (V((0.1148,0.046900)), V((0.1042,0.055993)), V((0.1046,0.055400)), V((0.1148,0.046900)), ),
    14643: (V((0.1160,0.104958)), V((0.1182,0.114747)), V((0.1123,0.114176)), V((0.1104,0.104799)), ),
    14644: (V((0.2055,0.039800)), V((0.1682,0.019900)), V((0.1874,0.023417)), V((0.2030,0.033683)), ),
    14645: (V((0.1159,0.093469)), V((0.1160,0.104958)), V((0.1104,0.104799)), V((0.1110,0.094002)), ),
    14646: (V((0.1987,0.103897)), V((0.2036,0.107866)), V((0.2000,0.110343)), V((0.1943,0.105564)), ),
    14647: (V((0.1182,0.114747)), V((0.1143,0.122768)), V((0.1105,0.121736)), V((0.1123,0.114176)), ),
    14648: (V((0.2147,0.128820)), V((0.2176,0.125630)), V((0.2232,0.133201)), V((0.2195,0.135804)), ),
    14649: (V((0.0650,0.048927)), V((0.0506,0.052083)), V((0.0503,0.052355)), V((0.0551,0.051255)), ),
    14650: (V((0.2085,0.042728)), V((0.2049,0.043956)), V((0.2047,0.042493)), V((0.2030,0.033683)), ),
    14651: (V((0.1143,0.122768)), V((0.1117,0.126436)), V((0.1084,0.126500)), V((0.1105,0.121736)), ),
    14652: (V((0.3248,0.611647)), V((0.3243,0.631068)), V((0.3148,0.630583)), V((0.3150,0.611347)), ),
    14653: (V((0.3323,0.611486)), V((0.3323,0.631158)), V((0.3243,0.631068)), V((0.3248,0.611647)), ),
    14654: (V((0.3323,0.631158)), V((0.3323,0.611486)), V((0.3401,0.611631)), V((0.3401,0.631002)), ),
    14655: (V((0.1659,0.610545)), V((0.1642,0.622297)), V((0.1574,0.620812)), V((0.1592,0.609637)), ),
    14656: (V((0.1642,0.622297)), V((0.1659,0.610545)), V((0.1726,0.610548)), V((0.1714,0.623214)), ),
    14657: (V((0.1714,0.623214)), V((0.1726,0.610548)), V((0.1798,0.610580)), V((0.1789,0.623892)), ),
    14658: (V((0.1789,0.623892)), V((0.1798,0.610580)), V((0.1866,0.610414)), V((0.1860,0.623924)), ),
    14659: (V((0.1860,0.623924)), V((0.1866,0.610414)), V((0.1929,0.610667)), V((0.1938,0.623986)), ),
    14660: (V((0.2015,0.608980)), V((0.2006,0.623582)), V((0.1938,0.623986)), V((0.1929,0.610667)), ),
    14661: (V((0.2111,0.603467)), V((0.2096,0.623044)), V((0.2006,0.623582)), V((0.2015,0.608980)), ),
    14662: (V((0.2096,0.623044)), V((0.2111,0.603467)), V((0.2203,0.602447)), V((0.2206,0.622152)), ),
    14663: (V((0.2206,0.622152)), V((0.2203,0.602447)), V((0.2329,0.604804)), V((0.2329,0.625231)), ),
    14664: (V((0.2494,0.604340)), V((0.2505,0.627759)), V((0.2329,0.625231)), V((0.2329,0.604804)), ),
    14665: (V((0.2505,0.627759)), V((0.2494,0.604340)), V((0.2642,0.606803)), V((0.2627,0.626428)), ),
    14666: (V((0.2627,0.626428)), V((0.2642,0.606803)), V((0.2778,0.608553)), V((0.2784,0.626959)), ),
    14667: (V((0.2911,0.609657)), V((0.2911,0.628354)), V((0.2784,0.626959)), V((0.2778,0.608553)), ),
    14668: (V((0.3033,0.610967)), V((0.3037,0.629312)), V((0.2911,0.628354)), V((0.2911,0.609657)), ),
    14669: (V((0.3037,0.629312)), V((0.3033,0.610967)), V((0.3150,0.611347)), V((0.3148,0.630583)), ),
    14670: (V((0.5503,0.155734)), V((0.5535,0.149837)), V((0.5590,0.155636)), V((0.5555,0.160573)), ),
    14671: (V((0.5463,0.162445)), V((0.5503,0.155734)), V((0.5555,0.160573)), V((0.5511,0.166484)), ),
    14672: (V((0.5135,0.139867)), V((0.5168,0.140117)), V((0.5141,0.150232)), V((0.5114,0.149945)), ),
    14673: (V((0.5168,0.140117)), V((0.5217,0.142319)), V((0.5187,0.152999)), V((0.5141,0.150232)), ),
    14674: (V((0.5114,0.149945)), V((0.5082,0.150948)), V((0.5095,0.140991)), V((0.5135,0.139867)), ),
    14675: (V((0.5511,0.166484)), V((0.5566,0.171038)), V((0.5508,0.180197)), V((0.5448,0.175936)), ),
    14676: (V((0.5135,0.139867)), V((0.5095,0.140991)), V((0.5111,0.132722)), V((0.5155,0.131897)), ),
    14677: (V((0.5155,0.131897)), V((0.5208,0.132862)), V((0.5168,0.140117)), V((0.5135,0.139867)), ),
    14678: (V((0.5208,0.132862)), V((0.5263,0.135145)), V((0.5217,0.142319)), V((0.5168,0.140117)), ),
    14679: (V((0.5159,0.124670)), V((0.5155,0.131897)), V((0.5111,0.132722)), V((0.5110,0.125141)), ),
    14680: (V((0.5030,0.137231)), V((0.5021,0.127552)), V((0.5065,0.126069)), V((0.5062,0.134866)), ),
    14681: (V((0.4977,0.148495)), V((0.4991,0.139537)), V((0.5030,0.137231)), V((0.5025,0.145501)), ),
    14682: (V((0.5645,0.168945)), V((0.5618,0.174863)), V((0.5566,0.171038)), V((0.5602,0.165008)), ),
    14683: (V((0.5738,0.177350)), V((0.5707,0.182519)), V((0.5664,0.179633)), V((0.5696,0.173567)), ),
    14684: (V((0.5696,0.173567)), V((0.5664,0.179633)), V((0.5618,0.174863)), V((0.5645,0.168945)), ),
    14685: (V((0.5681,0.164887)), V((0.5645,0.168945)), V((0.5602,0.165008)), V((0.5648,0.160987)), ),
    14686: (V((0.5782,0.172884)), V((0.5738,0.177350)), V((0.5696,0.173567)), V((0.5733,0.169233)), ),
    14687: (V((0.5733,0.169233)), V((0.5696,0.173567)), V((0.5645,0.168945)), V((0.5681,0.164887)), ),
    14688: (V((0.5511,0.166484)), V((0.5555,0.160573)), V((0.5602,0.165008)), V((0.5566,0.171038)), ),
    14689: (V((0.4991,0.139537)), V((0.4987,0.129690)), V((0.5021,0.127552)), V((0.5030,0.137231)), ),
    14690: (V((0.5555,0.160573)), V((0.5590,0.155636)), V((0.5648,0.160987)), V((0.5602,0.165008)), ),
    14691: (V((0.5208,0.132862)), V((0.5221,0.125540)), V((0.5283,0.127597)), V((0.5263,0.135145)), ),
    14692: (V((0.5025,0.145501)), V((0.5030,0.137231)), V((0.5062,0.134866)), V((0.5071,0.142485)), ),
    14693: (V((0.5155,0.131897)), V((0.5159,0.124670)), V((0.5221,0.125540)), V((0.5208,0.132862)), ),
    14694: (V((0.5217,0.142319)), V((0.5269,0.145579)), V((0.5222,0.155092)), V((0.5187,0.152999)), ),
    14695: (V((0.4946,0.132518)), V((0.4987,0.129690)), V((0.4991,0.139537)), V((0.4941,0.142042)), ),
    14696: (V((0.4941,0.142042)), V((0.4991,0.139537)), V((0.4977,0.148495)), V((0.4925,0.151062)), ),
    14697: (V((0.4946,0.132518)), V((0.4941,0.142042)), V((0.4895,0.141824)), V((0.4896,0.133937)), ),
    14698: (V((0.4941,0.142042)), V((0.4925,0.151062)), V((0.4881,0.150205)), V((0.4895,0.141824)), ),
    14699: (V((0.5065,0.126069)), V((0.5110,0.125141)), V((0.5111,0.132722)), V((0.5062,0.134866)), ),
    14700: (V((0.5095,0.140991)), V((0.5071,0.142485)), V((0.5062,0.134866)), V((0.5111,0.132722)), ),
    14701: (V((0.5269,0.145579)), V((0.5217,0.142319)), V((0.5263,0.135145)), V((0.5312,0.137879)), ),
    14702: (V((0.5283,0.127597)), V((0.5344,0.131017)), V((0.5312,0.137879)), V((0.5263,0.135145)), ),
    14703: (V((0.5782,0.172884)), V((0.5824,0.176152)), V((0.5781,0.180021)), V((0.5738,0.177350)), ),
    14704: (V((0.5738,0.177350)), V((0.5781,0.180021)), V((0.5749,0.184637)), V((0.5707,0.182519)), ),
    14705: (V((0.5480,0.143107)), V((0.5435,0.149346)), V((0.5375,0.142122)), V((0.5408,0.136433)), ),
    14706: (V((0.5331,0.150033)), V((0.5375,0.142122)), V((0.5435,0.149346)), V((0.5398,0.156144)), ),
    14707: (V((0.5398,0.156144)), V((0.5337,0.165695)), V((0.5279,0.160207)), V((0.5331,0.150033)), ),
    14708: (V((0.5222,0.155092)), V((0.5269,0.145579)), V((0.5331,0.150033)), V((0.5279,0.160207)), ),
    14709: (V((0.5269,0.145579)), V((0.5312,0.137879)), V((0.5375,0.142122)), V((0.5331,0.150033)), ),
    14710: (V((0.5408,0.136433)), V((0.5375,0.142122)), V((0.5312,0.137879)), V((0.5344,0.131017)), ),
    14711: (V((0.5503,0.155734)), V((0.5463,0.162445)), V((0.5398,0.156144)), V((0.5435,0.149346)), ),
    14712: (V((0.5535,0.149837)), V((0.5503,0.155734)), V((0.5435,0.149346)), V((0.5480,0.143107)), ),
    14713: (V((0.5243,0.117805)), V((0.5171,0.117131)), V((0.5192,0.109249)), V((0.5280,0.110719)), ),
    14714: (V((0.5113,0.116882)), V((0.5061,0.117875)), V((0.5058,0.107929)), V((0.5116,0.107734)), ),
    14715: (V((0.4816,0.108838)), V((0.4857,0.110483)), V((0.4796,0.116320)), V((0.4759,0.113594)), ),
    14716: (V((0.4673,0.046028)), V((0.4710,0.047140)), V((0.4726,0.052957)), V((0.4672,0.053033)), ),
    14717: (V((0.4963,0.118214)), V((0.4910,0.121080)), V((0.4857,0.110483)), V((0.4946,0.109459)), ),
    14718: (V((0.4703,0.119278)), V((0.4730,0.122416)), V((0.4667,0.127338)), V((0.4639,0.124249)), ),
    14719: (V((0.4723,0.111170)), V((0.4708,0.108800)), V((0.4736,0.105581)), V((0.4772,0.107178)), ),
    14720: (V((0.4676,0.116235)), V((0.4644,0.115255)), V((0.4708,0.108800)), V((0.4723,0.111170)), ),
    14721: (V((0.4620,0.121754)), V((0.4607,0.119027)), V((0.4644,0.115255)), V((0.4676,0.116235)), ),
    14722: (V((0.4499,0.143773)), V((0.4469,0.143111)), V((0.4502,0.135334)), V((0.4527,0.136501)), ),
    14723: (V((0.4460,0.154208)), V((0.4446,0.107038)), V((0.4469,0.143111)), V((0.4499,0.143773)), ),
    14724: (V((0.5654,0.124988)), V((0.5695,0.124424)), V((0.5706,0.129612)), V((0.5674,0.129747)), ),
    14725: (V((0.5636,0.117476)), V((0.5692,0.117659)), V((0.5695,0.124424)), V((0.5654,0.124988)), ),
    14726: (V((0.5630,0.136743)), V((0.5531,0.135860)), V((0.5616,0.126028)), V((0.5642,0.129636)), ),
    14727: (V((0.4562,0.148019)), V((0.4545,0.154380)), V((0.4493,0.156409)), V((0.4534,0.146707)), ),
    14728: (V((0.4600,0.141118)), V((0.4562,0.148019)), V((0.4534,0.146707)), V((0.4564,0.139104)), ),
    14729: (V((0.4759,0.113594)), V((0.4796,0.116320)), V((0.4730,0.122416)), V((0.4703,0.119278)), ),
    14730: (V((0.4746,0.039864)), V((0.4774,0.037100)), V((0.4792,0.039701)), V((0.4768,0.044432)), ),
    14731: (V((0.5013,0.107716)), V((0.5003,0.116609)), V((0.4963,0.118214)), V((0.4946,0.109459)), ),
    14732: (V((0.5365,0.112306)), V((0.5323,0.120407)), V((0.5243,0.117805)), V((0.5280,0.110719)), ),
    14733: (V((0.5616,0.126028)), V((0.5531,0.135860)), V((0.5470,0.128114)), V((0.5577,0.117989)), ),
    14734: (V((0.4838,0.125891)), V((0.4717,0.130527)), V((0.4667,0.127338)), V((0.4730,0.122416)), ),
    14735: (V((0.5611,0.050200)), V((0.5942,0.052867)), V((0.5728,0.059510)), V((0.5713,0.058700)), ),
    14736: (V((0.4857,0.110483)), V((0.4910,0.121080)), V((0.4855,0.126947)), V((0.4796,0.116320)), ),
    14737: (V((0.4730,0.122416)), V((0.4796,0.116320)), V((0.4855,0.126947)), V((0.4838,0.125891)), ),
    14738: (V((0.5803,0.123278)), V((0.5742,0.122757)), V((0.5749,0.117738)), V((0.5818,0.118634)), ),
    14739: (V((0.5780,0.129154)), V((0.5733,0.129274)), V((0.5742,0.122757)), V((0.5803,0.123278)), ),
    14740: (V((0.4496,0.118334)), V((0.4463,0.115106)), V((0.4481,0.107805)), V((0.4537,0.108783)), ),
    14741: (V((0.4768,0.044432)), V((0.4768,0.047372)), V((0.4735,0.042222)), V((0.4746,0.039864)), ),
    14742: (V((0.5950,0.127834)), V((0.5907,0.129093)), V((0.5922,0.121788)), V((0.5972,0.123949)), ),
    14743: (V((0.4644,0.115255)), V((0.4606,0.109346)), V((0.4661,0.109513)), V((0.4708,0.108800)), ),
    14744: (V((0.4607,0.119027)), V((0.4565,0.120344)), V((0.4606,0.109346)), V((0.4644,0.115255)), ),
    14745: (V((0.5096,0.023500)), V((0.5110,0.023300)), V((0.5124,0.031300)), V((0.5097,0.029827)), ),
    14746: (V((0.5692,0.117659)), V((0.5749,0.117738)), V((0.5742,0.122757)), V((0.5695,0.124424)), ),
    14747: (V((0.5695,0.124424)), V((0.5742,0.122757)), V((0.5733,0.129274)), V((0.5706,0.129612)), ),
    14748: (V((0.4446,0.107038)), V((0.4481,0.107805)), V((0.4463,0.115106)), V((0.4419,0.116357)), ),
    14749: (V((0.4419,0.116357)), V((0.4463,0.115106)), V((0.4496,0.118334)), V((0.4502,0.135334)), ),
    14750: (V((0.4717,0.130527)), V((0.4654,0.135524)), V((0.4611,0.132099)), V((0.4667,0.127338)), ),
    14751: (V((0.4583,0.128848)), V((0.4565,0.124324)), V((0.4620,0.121754)), V((0.4639,0.124249)), ),
    14752: (V((0.4620,0.121754)), V((0.4565,0.124324)), V((0.4565,0.120344)), V((0.4607,0.119027)), ),
    14753: (V((0.6085,0.057568)), V((0.5939,0.055078)), V((0.6073,0.053900)), V((0.6109,0.052227)), ),
    14754: (V((0.5097,0.029827)), V((0.4792,0.039701)), V((0.4774,0.037100)), V((0.5096,0.023500)), ),
    14755: (V((0.6109,0.052227)), V((0.6253,0.055383)), V((0.6218,0.061200)), V((0.6085,0.057568)), ),
    14756: (V((0.6316,0.076840)), V((0.6218,0.061200)), V((0.6253,0.055383)), V((0.6358,0.071775)), ),
    14757: (V((0.5417,0.034400)), V((0.5124,0.031300)), V((0.5110,0.023300)), V((0.5430,0.030800)), ),
    14758: (V((0.5716,0.059293)), V((0.5597,0.050000)), V((0.5434,0.032300)), V((0.5611,0.050200)), ),
    14759: (V((0.5942,0.052867)), V((0.6073,0.053900)), V((0.5939,0.055078)), V((0.5728,0.059510)), ),
    14760: (V((0.5413,0.035877)), V((0.5417,0.034400)), V((0.5430,0.030800)), V((0.5436,0.031600)), ),
    14761: (V((0.4711,0.045706)), V((0.4717,0.043711)), V((0.4752,0.051002)), V((0.4743,0.051812)), ),
    14762: (V((0.4768,0.047372)), V((0.4752,0.051002)), V((0.4717,0.043711)), V((0.4735,0.042222)), ),
    14763: (V((0.5597,0.050000)), V((0.5413,0.035877)), V((0.5436,0.031600)), V((0.5434,0.032300)), ),
    14764: (V((0.5693,0.066394)), V((0.5666,0.066022)), V((0.5597,0.050000)), V((0.5716,0.059293)), ),
    14765: (V((0.5382,0.043745)), V((0.5358,0.040500)), V((0.5124,0.031300)), V((0.5417,0.034400)), ),
    14766: (V((0.6188,0.085707)), V((0.6112,0.080534)), V((0.6218,0.061200)), V((0.6316,0.076840)), ),
    14767: (V((0.6085,0.057568)), V((0.6218,0.061200)), V((0.6112,0.080534)), V((0.5985,0.074781)), ),
    14768: (V((0.5114,0.042728)), V((0.4900,0.051034)), V((0.4792,0.039701)), V((0.5097,0.029827)), ),
    14769: (V((0.5985,0.074781)), V((0.5774,0.067900)), V((0.5939,0.055078)), V((0.6085,0.057568)), ),
    14770: (V((0.5097,0.029827)), V((0.5124,0.031300)), V((0.5358,0.040500)), V((0.5114,0.042728)), ),
    14771: (V((0.4860,0.055078)), V((0.4842,0.059303)), V((0.4768,0.047372)), V((0.4768,0.044432)), ),
    14772: (V((0.5713,0.058700)), V((0.5728,0.059510)), V((0.5721,0.067944)), V((0.5715,0.066969)), ),
    14773: (V((0.4768,0.044432)), V((0.4792,0.039701)), V((0.4900,0.051034)), V((0.4860,0.055078)), ),
    14774: (V((0.4672,0.053033)), V((0.4726,0.052957)), V((0.4774,0.066370)), V((0.4718,0.066933)), ),
    14775: (V((0.5666,0.066022)), V((0.5535,0.055537)), V((0.5413,0.035877)), V((0.5597,0.050000)), ),
    14776: (V((0.4842,0.059303)), V((0.4817,0.064104)), V((0.4752,0.051002)), V((0.4768,0.047372)), ),
    14777: (V((0.4743,0.051812)), V((0.4752,0.051002)), V((0.4817,0.064104)), V((0.4800,0.064846)), ),
    14778: (V((0.5535,0.055537)), V((0.5382,0.043745)), V((0.5417,0.034400)), V((0.5413,0.035877)), ),
    14779: (V((0.5728,0.059510)), V((0.5939,0.055078)), V((0.5774,0.067900)), V((0.5721,0.067944)), ),
    14780: (V((0.5586,0.077357)), V((0.5507,0.073806)), V((0.5535,0.055537)), V((0.5666,0.066022)), ),
    14781: (V((0.4718,0.066933)), V((0.4774,0.066370)), V((0.4794,0.076005)), V((0.4722,0.077252)), ),
    14782: (V((0.4860,0.055078)), V((0.4900,0.051034)), V((0.5017,0.065374)), V((0.4939,0.067629)), ),
    14783: (V((0.5715,0.066969)), V((0.5721,0.067944)), V((0.5689,0.084537)), V((0.5655,0.083210)), ),
    14784: (V((0.4939,0.067629)), V((0.4901,0.070634)), V((0.4842,0.059303)), V((0.4860,0.055078)), ),
    14785: (V((0.5114,0.042728)), V((0.5358,0.040500)), V((0.5244,0.062074)), V((0.5129,0.063735)), ),
    14786: (V((0.5925,0.086704)), V((0.5780,0.085644)), V((0.5774,0.067900)), V((0.5985,0.074781)), ),
    14787: (V((0.5129,0.063735)), V((0.5017,0.065374)), V((0.4900,0.051034)), V((0.5114,0.042728)), ),
    14788: (V((0.5985,0.074781)), V((0.6112,0.080534)), V((0.6054,0.090976)), V((0.5925,0.086704)), ),
    14789: (V((0.6110,0.092991)), V((0.6054,0.090976)), V((0.6112,0.080534)), V((0.6188,0.085707)), ),
    14790: (V((0.5389,0.067106)), V((0.5244,0.062074)), V((0.5358,0.040500)), V((0.5382,0.043745)), ),
    14791: (V((0.5623,0.081551)), V((0.5586,0.077357)), V((0.5666,0.066022)), V((0.5693,0.066394)), ),
    14792: (V((0.5721,0.067944)), V((0.5774,0.067900)), V((0.5780,0.085644)), V((0.5689,0.084537)), ),
    14793: (V((0.5507,0.073806)), V((0.5389,0.067106)), V((0.5382,0.043745)), V((0.5535,0.055537)), ),
    14794: (V((0.4800,0.064846)), V((0.4817,0.064104)), V((0.4846,0.074211)), V((0.4824,0.075043)), ),
    14795: (V((0.4901,0.070634)), V((0.4846,0.074211)), V((0.4817,0.064104)), V((0.4842,0.059303)), ),
    14796: (V((0.5359,0.085200)), V((0.5246,0.081666)), V((0.5244,0.062074)), V((0.5389,0.067106)), ),
    14797: (V((0.6079,0.104186)), V((0.6005,0.100803)), V((0.6054,0.090976)), V((0.6110,0.092991)), ),
    14798: (V((0.4939,0.067629)), V((0.5017,0.065374)), V((0.5027,0.080324)), V((0.4981,0.080945)), ),
    14799: (V((0.5058,0.107929)), V((0.5061,0.117875)), V((0.5003,0.116609)), V((0.5013,0.107716)), ),
    14800: (V((0.5120,0.080081)), V((0.5027,0.080324)), V((0.5017,0.065374)), V((0.5129,0.063735)), ),
    14801: (V((0.5870,0.098026)), V((0.5756,0.097705)), V((0.5780,0.085644)), V((0.5925,0.086704)), ),
    14802: (V((0.5525,0.091861)), V((0.5456,0.088969)), V((0.5507,0.073806)), V((0.5586,0.077357)), ),
    14803: (V((0.4981,0.080945)), V((0.4916,0.084404)), V((0.4901,0.070634)), V((0.4939,0.067629)), ),
    14804: (V((0.5655,0.083210)), V((0.5689,0.084537)), V((0.5698,0.097671)), V((0.5649,0.097258)), ),
    14805: (V((0.4824,0.075043)), V((0.4846,0.074211)), V((0.4866,0.087450)), V((0.4836,0.087309)), ),
    14806: (V((0.4722,0.077252)), V((0.4794,0.076005)), V((0.4776,0.087243)), V((0.4775,0.086641)), ),
    14807: (V((0.5600,0.096715)), V((0.5525,0.091861)), V((0.5586,0.077357)), V((0.5623,0.081551)), ),
    14808: (V((0.4916,0.084404)), V((0.4866,0.087450)), V((0.4846,0.074211)), V((0.4901,0.070634)), ),
    14809: (V((0.5925,0.086704)), V((0.6054,0.090976)), V((0.6005,0.100803)), V((0.5870,0.098026)), ),
    14810: (V((0.5456,0.088969)), V((0.5359,0.085200)), V((0.5389,0.067106)), V((0.5507,0.073806)), ),
    14811: (V((0.5689,0.084537)), V((0.5780,0.085644)), V((0.5756,0.097705)), V((0.5698,0.097671)), ),
    14812: (V((0.5365,0.112306)), V((0.5456,0.115101)), V((0.5393,0.123192)), V((0.5323,0.120407)), ),
    14813: (V((0.5129,0.063735)), V((0.5244,0.062074)), V((0.5246,0.081666)), V((0.5120,0.080081)), ),
    14814: (V((0.4836,0.087309)), V((0.4866,0.087450)), V((0.4874,0.099621)), V((0.4841,0.098302)), ),
    14815: (V((0.4927,0.097184)), V((0.4874,0.099621)), V((0.4866,0.087450)), V((0.4916,0.084404)), ),
    14816: (V((0.5499,0.105036)), V((0.5419,0.102678)), V((0.5456,0.088969)), V((0.5525,0.091861)), ),
    14817: (V((0.4775,0.086641)), V((0.4776,0.087243)), V((0.4802,0.097055)), V((0.4776,0.096011)), ),
    14818: (V((0.4981,0.080945)), V((0.5027,0.080324)), V((0.5055,0.095676)), V((0.4990,0.095747)), ),
    14819: (V((0.5649,0.097258)), V((0.5698,0.097671)), V((0.5691,0.108005)), V((0.5655,0.108099)), ),
    14820: (V((0.4990,0.095747)), V((0.4927,0.097184)), V((0.4916,0.084404)), V((0.4981,0.080945)), ),
    14821: (V((0.5120,0.080081)), V((0.5246,0.081666)), V((0.5217,0.097778)), V((0.5124,0.096177)), ),
    14822: (V((0.5843,0.109046)), V((0.5753,0.108169)), V((0.5756,0.097705)), V((0.5870,0.098026)), ),
    14823: (V((0.5171,0.117131)), V((0.5113,0.116882)), V((0.5116,0.107734)), V((0.5192,0.109249)), ),
    14824: (V((0.5124,0.096177)), V((0.5055,0.095676)), V((0.5027,0.080324)), V((0.5120,0.080081)), ),
    14825: (V((0.5870,0.098026)), V((0.6005,0.100803)), V((0.5952,0.111399)), V((0.5843,0.109046)), ),
    14826: (V((0.5907,0.129093)), V((0.5803,0.123278)), V((0.5818,0.118634)), V((0.5922,0.121788)), ),
    14827: (V((0.5803,0.123278)), V((0.5907,0.129093)), V((0.5846,0.128738)), V((0.5780,0.129154)), ),
    14828: (V((0.4537,0.108783)), V((0.4606,0.109346)), V((0.4565,0.120344)), V((0.4496,0.118334)), ),
    14829: (V((0.4565,0.124324)), V((0.4502,0.135334)), V((0.4496,0.118334)), V((0.4565,0.120344)), ),
    14830: (V((0.4583,0.128848)), V((0.4527,0.136501)), V((0.4502,0.135334)), V((0.4565,0.124324)), ),
    14831: (V((0.4564,0.139104)), V((0.4611,0.132099)), V((0.4654,0.135524)), V((0.4600,0.141118)), ),
    14832: (V((0.6026,0.113161)), V((0.5952,0.111399)), V((0.6005,0.100803)), V((0.6079,0.104186)), ),
    14833: (V((0.5326,0.100440)), V((0.5217,0.097778)), V((0.5246,0.081666)), V((0.5359,0.085200)), ),
    14834: (V((0.5599,0.108200)), V((0.5499,0.105036)), V((0.5525,0.091861)), V((0.5600,0.096715)), ),
    14835: (V((0.5698,0.097671)), V((0.5756,0.097705)), V((0.5753,0.108169)), V((0.5691,0.108005)), ),
    14836: (V((0.5419,0.102678)), V((0.5326,0.100440)), V((0.5359,0.085200)), V((0.5456,0.088969)), ),
    14837: (V((0.5013,0.107716)), V((0.4946,0.109459)), V((0.4927,0.097184)), V((0.4990,0.095747)), ),
    14838: (V((0.4990,0.095747)), V((0.5055,0.095676)), V((0.5058,0.107929)), V((0.5013,0.107716)), ),
    14839: (V((0.5171,0.117131)), V((0.5159,0.124670)), V((0.5110,0.125141)), V((0.5113,0.116882)), ),
    14840: (V((0.5159,0.124670)), V((0.5171,0.117131)), V((0.5243,0.117805)), V((0.5221,0.125540)), ),
    14841: (V((0.5113,0.116882)), V((0.5110,0.125141)), V((0.5065,0.126069)), V((0.5061,0.117875)), ),
    14842: (V((0.5021,0.127552)), V((0.5003,0.116609)), V((0.5061,0.117875)), V((0.5065,0.126069)), ),
    14843: (V((0.5221,0.125540)), V((0.5243,0.117805)), V((0.5323,0.120407)), V((0.5283,0.127597)), ),
    14844: (V((0.5393,0.123192)), V((0.5344,0.131017)), V((0.5283,0.127597)), V((0.5323,0.120407)), ),
    14845: (V((0.5408,0.136433)), V((0.5470,0.128114)), V((0.5531,0.135860)), V((0.5480,0.143107)), ),
    14846: (V((0.5630,0.136743)), V((0.5535,0.149837)), V((0.5480,0.143107)), V((0.5531,0.135860)), ),
    14847: (V((0.5680,0.143281)), V((0.5590,0.155636)), V((0.5535,0.149837)), V((0.5630,0.136743)), ),
    14848: (V((0.4987,0.129690)), V((0.4963,0.118214)), V((0.5003,0.116609)), V((0.5021,0.127552)), ),
    14849: (V((0.4946,0.132518)), V((0.4910,0.121080)), V((0.4963,0.118214)), V((0.4987,0.129690)), ),
    14850: (V((0.4910,0.121080)), V((0.4946,0.132518)), V((0.4896,0.133937)), V((0.4855,0.126947)), ),
    14851: (V((0.5877,0.168738)), V((0.5824,0.176152)), V((0.5782,0.172884)), V((0.5889,0.166670)), ),
    14852: (V((0.5889,0.166670)), V((0.5782,0.172884)), V((0.5733,0.169233)), V((0.5839,0.157228)), ),
    14853: (V((0.5590,0.155636)), V((0.5680,0.143281)), V((0.5734,0.150086)), V((0.5648,0.160987)), ),
    14854: (V((0.5839,0.157228)), V((0.5733,0.169233)), V((0.5681,0.164887)), V((0.5784,0.154007)), ),
    14855: (V((0.5972,0.123949)), V((0.5922,0.121788)), V((0.5952,0.111399)), V((0.6026,0.113161)), ),
    14856: (V((0.5577,0.117989)), V((0.5456,0.115101)), V((0.5499,0.105036)), V((0.5599,0.108200)), ),
    14857: (V((0.5843,0.109046)), V((0.5952,0.111399)), V((0.5922,0.121788)), V((0.5818,0.118634)), ),
    14858: (V((0.5818,0.118634)), V((0.5749,0.117738)), V((0.5753,0.108169)), V((0.5843,0.109046)), ),
    14859: (V((0.5365,0.112306)), V((0.5280,0.110719)), V((0.5326,0.100440)), V((0.5419,0.102678)), ),
    14860: (V((0.5655,0.108099)), V((0.5691,0.108005)), V((0.5692,0.117659)), V((0.5636,0.117476)), ),
    14861: (V((0.5456,0.115101)), V((0.5365,0.112306)), V((0.5419,0.102678)), V((0.5499,0.105036)), ),
    14862: (V((0.5691,0.108005)), V((0.5753,0.108169)), V((0.5749,0.117738)), V((0.5692,0.117659)), ),
    14863: (V((0.5280,0.110719)), V((0.5192,0.109249)), V((0.5217,0.097778)), V((0.5326,0.100440)), ),
    14864: (V((0.5124,0.096177)), V((0.5217,0.097778)), V((0.5192,0.109249)), V((0.5116,0.107734)), ),
    14865: (V((0.4776,0.096011)), V((0.4802,0.097055)), V((0.4772,0.107178)), V((0.4736,0.105581)), ),
    14866: (V((0.4841,0.098302)), V((0.4874,0.099621)), V((0.4857,0.110483)), V((0.4816,0.108838)), ),
    14867: (V((0.5116,0.107734)), V((0.5058,0.107929)), V((0.5055,0.095676)), V((0.5124,0.096177)), ),
    14868: (V((0.4946,0.109459)), V((0.4857,0.110483)), V((0.4874,0.099621)), V((0.4927,0.097184)), ),
    14869: (V((0.5344,0.131017)), V((0.5393,0.123192)), V((0.5470,0.128114)), V((0.5408,0.136433)), ),
    14870: (V((0.5456,0.115101)), V((0.5577,0.117989)), V((0.5470,0.128114)), V((0.5393,0.123192)), ),
    14871: (V((0.4703,0.043100)), V((0.4746,0.039864)), V((0.4735,0.042222)), V((0.4717,0.043711)), ),
    14872: (V((0.5611,0.050200)), V((0.5434,0.032300)), V((0.5436,0.031600)), V((0.5436,0.031600)), ),
    14873: (V((0.5096,0.023500)), V((0.4774,0.037100)), V((0.5077,0.023200)), V((0.5096,0.023500)), ),
    14874: (V((0.5430,0.030800)), V((0.5110,0.023300)), V((0.5110,0.023300)), V((0.5116,0.023300)), ),
    14875: (V((0.5096,0.023500)), V((0.5110,0.023300)), V((0.5110,0.023300)), V((0.5096,0.023500)), ),
    14876: (V((0.4746,0.039864)), V((0.4703,0.043100)), V((0.5077,0.023200)), V((0.4774,0.037100)), ),
    14877: (V((0.5436,0.031600)), V((0.5436,0.031600)), V((0.5430,0.030800)), V((0.5116,0.023300)), ),
    14878: (V((0.4729,0.036969)), V((0.4703,0.043100)), V((0.4717,0.043711)), V((0.4711,0.045706)), ),
    14879: (V((0.5611,0.050200)), V((0.5449,0.032000)), V((0.5461,0.033756)), V((0.5942,0.052867)), ),
    14880: (V((0.5110,0.023300)), V((0.5096,0.023500)), V((0.5077,0.023200)), V((0.5116,0.023300)), ),
    14881: (V((0.6208,0.054555)), V((0.5116,0.023300)), V((0.5077,0.023200)), V((0.6256,0.055655)), ),
    14882: (V((0.6208,0.054555)), V((0.5426,0.028546)), V((0.5461,0.033756)), V((0.5449,0.032000)), ),
    14883: (V((0.6401,0.060252)), V((0.6358,0.071775)), V((0.6253,0.055383)), V((0.6256,0.055655)), ),
    14884: (V((0.5784,0.154007)), V((0.5681,0.164887)), V((0.5648,0.160987)), V((0.5734,0.150086)), ),
    14885: (V((0.3798,0.766334)), V((0.3771,0.750769)), V((0.3953,0.749628)), V((0.4019,0.763821)), ),
    14886: (V((0.4019,0.763821)), V((0.3953,0.749628)), V((0.4089,0.747165)), V((0.4152,0.761587)), ),
    14887: (V((0.4152,0.761587)), V((0.4089,0.747165)), V((0.4214,0.743598)), V((0.4277,0.757746)), ),
    14888: (V((0.4277,0.757746)), V((0.4214,0.743598)), V((0.4331,0.736109)), V((0.4397,0.748376)), ),
    14889: (V((0.4982,0.889348)), V((0.5021,0.878895)), V((0.5085,0.881950)), V((0.5051,0.892721)), ),
    14890: (V((0.4946,0.900938)), V((0.4982,0.889348)), V((0.5051,0.892721)), V((0.5016,0.903557)), ),
    14891: (V((0.4998,0.856693)), V((0.4933,0.861967)), V((0.4873,0.856838)), V((0.4997,0.852230)), ),
    14892: (V((0.4873,0.856838)), V((0.4933,0.861967)), V((0.4876,0.870962)), V((0.4808,0.865217)), ),
    14893: (V((0.3551,0.765121)), V((0.3401,0.766020)), V((0.3401,0.751994)), V((0.3550,0.752023)), ),
    14894: (V((0.3736,0.740151)), V((0.3709,0.729813)), V((0.3849,0.728074)), V((0.3894,0.738529)), ),
    14895: (V((0.3894,0.738529)), V((0.3849,0.728074)), V((0.3977,0.725764)), V((0.4025,0.735920)), ),
    14896: (V((0.4025,0.735920)), V((0.3977,0.725764)), V((0.4099,0.721935)), V((0.4156,0.731724)), ),
    14897: (V((0.4156,0.731724)), V((0.4099,0.721935)), V((0.4220,0.718086)), V((0.4277,0.727251)), ),
    14898: (V((0.3550,0.741545)), V((0.3552,0.731569)), V((0.3709,0.729813)), V((0.3736,0.740151)), ),
    14899: (V((0.4297,0.814061)), V((0.4351,0.822796)), V((0.4258,0.828786)), V((0.4211,0.820527)), ),
    14900: (V((0.4351,0.822796)), V((0.4408,0.832453)), V((0.4315,0.836573)), V((0.4258,0.828786)), ),
    14901: (V((0.4408,0.832453)), V((0.4474,0.843547)), V((0.4391,0.848707)), V((0.4315,0.836573)), ),
    14902: (V((0.4834,0.880383)), V((0.4876,0.870962)), V((0.4943,0.875081)), V((0.4905,0.884912)), ),
    14903: (V((0.4721,0.660627)), V((0.4617,0.662040)), V((0.4607,0.654861)), V((0.4719,0.653607)), ),
    14904: (V((0.4770,0.893367)), V((0.4834,0.880383)), V((0.4905,0.884912)), V((0.4868,0.897851)), ),
    14905: (V((0.4252,0.802328)), V((0.4297,0.814061)), V((0.4211,0.820527)), V((0.4145,0.809033)), ),
    14906: (V((0.4405,0.807274)), V((0.4443,0.816389)), V((0.4351,0.822796)), V((0.4297,0.814061)), ),
    14907: (V((0.4443,0.816389)), V((0.4497,0.825998)), V((0.4408,0.832453)), V((0.4351,0.822796)), ),
    14908: (V((0.4497,0.825998)), V((0.4541,0.834920)), V((0.4474,0.843547)), V((0.4408,0.832453)), ),
    14909: (V((0.4540,0.800885)), V((0.4572,0.809403)), V((0.4443,0.816389)), V((0.4405,0.807274)), ),
    14910: (V((0.4783,0.700736)), V((0.4698,0.702832)), V((0.4666,0.697623)), V((0.4766,0.695793)), ),
    14911: (V((0.4572,0.809403)), V((0.4606,0.816900)), V((0.4497,0.825998)), V((0.4443,0.816389)), ),
    14912: (V((0.4606,0.816900)), V((0.4630,0.825178)), V((0.4541,0.834920)), V((0.4497,0.825998)), ),
    14913: (V((0.4671,0.795045)), V((0.4700,0.803691)), V((0.4572,0.809403)), V((0.4540,0.800885)), ),
    14914: (V((0.4700,0.803691)), V((0.4715,0.812450)), V((0.4606,0.816900)), V((0.4572,0.809403)), ),
    14915: (V((0.4715,0.812450)), V((0.4732,0.821440)), V((0.4630,0.825178)), V((0.4606,0.816900)), ),
    14916: (V((0.5084,0.667696)), V((0.5000,0.668685)), V((0.4998,0.663646)), V((0.5080,0.662818)), ),
    14917: (V((0.4813,0.790280)), V((0.4829,0.799416)), V((0.4700,0.803691)), V((0.4671,0.795045)), ),
    14918: (V((0.4829,0.799416)), V((0.4840,0.808270)), V((0.4715,0.812450)), V((0.4700,0.803691)), ),
    14919: (V((0.4840,0.808270)), V((0.4858,0.817137)), V((0.4732,0.821440)), V((0.4715,0.812450)), ),
    14920: (V((0.4430,0.729951)), V((0.4331,0.736109)), V((0.4277,0.727251)), V((0.4386,0.722135)), ),
    14921: (V((0.5046,0.783775)), V((0.5064,0.793038)), V((0.4965,0.795448)), V((0.4950,0.786347)), ),
    14922: (V((0.4799,0.707536)), V((0.4844,0.707527)), V((0.4844,0.720984)), V((0.4770,0.721380)), ),
    14923: (V((0.5064,0.793038)), V((0.5071,0.800863)), V((0.4961,0.804205)), V((0.4965,0.795448)), ),
    14924: (V((0.5071,0.800863)), V((0.5070,0.809878)), V((0.4963,0.813921)), V((0.4961,0.804205)), ),
    14925: (V((0.5164,0.780089)), V((0.5185,0.789548)), V((0.5064,0.793038)), V((0.5046,0.783775)), ),
    14926: (V((0.4844,0.707527)), V((0.4911,0.706336)), V((0.4925,0.719730)), V((0.4844,0.720984)), ),
    14927: (V((0.5185,0.789548)), V((0.5197,0.797466)), V((0.5071,0.800863)), V((0.5064,0.793038)), ),
    14928: (V((0.5197,0.797466)), V((0.5199,0.805344)), V((0.5070,0.809878)), V((0.5071,0.800863)), ),
    14929: (V((0.4156,0.731724)), V((0.4277,0.727251)), V((0.4331,0.736109)), V((0.4214,0.743598)), ),
    14930: (V((0.4214,0.743598)), V((0.4089,0.747165)), V((0.4025,0.735920)), V((0.4156,0.731724)), ),
    14931: (V((0.4089,0.747165)), V((0.3953,0.749628)), V((0.3894,0.738529)), V((0.4025,0.735920)), ),
    14932: (V((0.3997,0.697979)), V((0.4109,0.694143)), V((0.4133,0.701133)), V((0.4024,0.704762)), ),
    14933: (V((0.3953,0.749628)), V((0.3771,0.750769)), V((0.3736,0.740151)), V((0.3894,0.738529)), ),
    14934: (V((0.4397,0.748376)), V((0.4331,0.736109)), V((0.4430,0.729951)), V((0.4506,0.740258)), ),
    14935: (V((0.3550,0.752023)), V((0.3401,0.751994)), V((0.3401,0.741976)), V((0.3550,0.741545)), ),
    14936: (V((0.4277,0.727251)), V((0.4220,0.718086)), V((0.4344,0.713548)), V((0.4386,0.722135)), ),
    14937: (V((0.4357,0.796597)), V((0.4405,0.807274)), V((0.4297,0.814061)), V((0.4252,0.802328)), ),
    14938: (V((0.4486,0.790814)), V((0.4540,0.800885)), V((0.4405,0.807274)), V((0.4357,0.796597)), ),
    14939: (V((0.4540,0.800885)), V((0.4486,0.790814)), V((0.4629,0.785374)), V((0.4671,0.795045)), ),
    14940: (V((0.4774,0.779616)), V((0.4813,0.790280)), V((0.4671,0.795045)), V((0.4629,0.785374)), ),
    14941: (V((0.5004,0.770539)), V((0.5046,0.783775)), V((0.4950,0.786347)), V((0.4908,0.773564)), ),
    14942: (V((0.5046,0.783775)), V((0.5004,0.770539)), V((0.5119,0.766248)), V((0.5164,0.780089)), ),
    14943: (V((0.4997,0.852230)), V((0.4873,0.856838)), V((0.4767,0.849405)), V((0.4840,0.843806)), ),
    14944: (V((0.3538,0.704864)), V((0.3648,0.704920)), V((0.3665,0.712255)), V((0.3543,0.712956)), ),
    14945: (V((0.3648,0.704920)), V((0.3774,0.704145)), V((0.3792,0.710597)), V((0.3665,0.712255)), ),
    14946: (V((0.3774,0.704145)), V((0.3890,0.701238)), V((0.3923,0.707808)), V((0.3792,0.710597)), ),
    14947: (V((0.3890,0.701238)), V((0.3997,0.697979)), V((0.4024,0.704762)), V((0.3923,0.707808)), ),
    14948: (V((0.5012,0.703232)), V((0.5136,0.697645)), V((0.5182,0.713353)), V((0.5035,0.717055)), ),
    14949: (V((0.5423,0.780999)), V((0.5436,0.789459)), V((0.5325,0.792874)), V((0.5315,0.784932)), ),
    14950: (V((0.5436,0.789459)), V((0.5453,0.796558)), V((0.5339,0.800334)), V((0.5325,0.792874)), ),
    14951: (V((0.5364,0.757769)), V((0.5406,0.771940)), V((0.5292,0.775036)), V((0.5250,0.762285)), ),
    14952: (V((0.5217,0.874440)), V((0.5180,0.885587)), V((0.5085,0.881950)), V((0.5120,0.872037)), ),
    14953: (V((0.5406,0.771940)), V((0.5423,0.780999)), V((0.5315,0.784932)), V((0.5292,0.775036)), ),
    14954: (V((0.5533,0.785596)), V((0.5548,0.792610)), V((0.5453,0.796558)), V((0.5436,0.789459)), ),
    14955: (V((0.5466,0.755074)), V((0.5501,0.768522)), V((0.5406,0.771940)), V((0.5364,0.757769)), ),
    14956: (V((0.5501,0.768522)), V((0.5516,0.777155)), V((0.5423,0.780999)), V((0.5406,0.771940)), ),
    14957: (V((0.5136,0.697645)), V((0.5229,0.695458)), V((0.5297,0.710222)), V((0.5182,0.713353)), ),
    14958: (V((0.5516,0.777155)), V((0.5533,0.785596)), V((0.5436,0.789459)), V((0.5423,0.780999)), ),
    14959: (V((0.5082,0.669951)), V((0.5001,0.671547)), V((0.5000,0.668685)), V((0.5084,0.667696)), ),
    14960: (V((0.5001,0.671547)), V((0.4923,0.673057)), V((0.4920,0.669872)), V((0.5000,0.668685)), ),
    14961: (V((0.4823,0.665527)), V((0.4911,0.664595)), V((0.4920,0.669872)), V((0.4830,0.671129)), ),
    14962: (V((0.4757,0.677993)), V((0.4632,0.679669)), V((0.4633,0.673844)), V((0.4735,0.672535)), ),
    14963: (V((0.4085,0.816477)), V((0.4145,0.809033)), V((0.4211,0.820527)), V((0.4157,0.826415)), ),
    14964: (V((0.4211,0.833525)), V((0.4258,0.828786)), V((0.4315,0.836573)), V((0.4271,0.841986)), ),
    14965: (V((0.3489,0.664695)), V((0.3401,0.665634)), V((0.3401,0.649536)), V((0.3482,0.649261)), ),
    14966: (V((0.3551,0.765121)), V((0.3554,0.776830)), V((0.3401,0.776801)), V((0.3401,0.766020)), ),
    14967: (V((0.5620,0.781200)), V((0.5641,0.788251)), V((0.5548,0.792610)), V((0.5533,0.785596)), ),
    14968: (V((0.5552,0.752454)), V((0.5582,0.765095)), V((0.5501,0.768522)), V((0.5466,0.755074)), ),
    14969: (V((0.4109,0.694143)), V((0.4255,0.689342)), V((0.4268,0.695078)), V((0.4133,0.701133)), ),
    14970: (V((0.4823,0.665527)), V((0.4726,0.666670)), V((0.4721,0.660627)), V((0.4816,0.659603)), ),
    14971: (V((0.5582,0.765095)), V((0.5603,0.773440)), V((0.5516,0.777155)), V((0.5501,0.768522)), ),
    14972: (V((0.5315,0.692672)), V((0.5391,0.708159)), V((0.5297,0.710222)), V((0.5229,0.695458)), ),
    14973: (V((0.5603,0.773440)), V((0.5620,0.781200)), V((0.5533,0.785596)), V((0.5516,0.777155)), ),
    14974: (V((0.4830,0.671129)), V((0.4735,0.672535)), V((0.4726,0.666670)), V((0.4823,0.665527)), ),
    14975: (V((0.4991,0.866051)), V((0.5036,0.860107)), V((0.5087,0.862361)), V((0.5054,0.869412)), ),
    14976: (V((0.4879,0.416903)), V((0.4902,0.399316)), V((0.4992,0.399790)), V((0.4977,0.418082)), ),
    14977: (V((0.4755,0.690264)), V((0.4648,0.691719)), V((0.4637,0.685531)), V((0.4750,0.684138)), ),
    14978: (V((0.8273,0.896646)), V((0.8264,0.906152)), V((0.8097,0.901075)), V((0.8112,0.893406)), ),
    14979: (V((0.6682,0.724004)), V((0.6711,0.728292)), V((0.6563,0.739179)), V((0.6536,0.733769)), ),
    14980: (V((0.6536,0.733769)), V((0.6563,0.739179)), V((0.6455,0.749063)), V((0.6423,0.742338)), ),
    14981: (V((0.6337,0.759905)), V((0.6303,0.751661)), V((0.6423,0.742338)), V((0.6455,0.749063)), ),
    14982: (V((0.5849,0.752750)), V((0.5896,0.759821)), V((0.5806,0.764813)), V((0.5761,0.757899)), ),
    14983: (V((0.5599,0.687581)), V((0.5649,0.700303)), V((0.5563,0.702244)), V((0.5521,0.687339)), ),
    14984: (V((0.5896,0.759821)), V((0.5928,0.765850)), V((0.5848,0.770725)), V((0.5806,0.764813)), ),
    14985: (V((0.5928,0.765850)), V((0.5956,0.771558)), V((0.5879,0.776168)), V((0.5848,0.770725)), ),
    14986: (V((0.5780,0.745085)), V((0.5849,0.752750)), V((0.5761,0.757899)), V((0.5690,0.747959)), ),
    14987: (V((0.6303,0.751661)), V((0.6337,0.759905)), V((0.6200,0.767843)), V((0.6177,0.759795)), ),
    14988: (V((0.5679,0.814813)), V((0.5577,0.819277)), V((0.5571,0.811033)), V((0.5667,0.806414)), ),
    14989: (V((0.6177,0.759795)), V((0.6200,0.767843)), V((0.6078,0.774382)), V((0.6056,0.766635)), ),
    14990: (V((0.5255,0.208059)), V((0.5325,0.209308)), V((0.5297,0.233894)), V((0.5206,0.231831)), ),
    14991: (V((0.5704,0.687202)), V((0.5741,0.700354)), V((0.5649,0.700303)), V((0.5599,0.687581)), ),
    14992: (V((0.6000,0.755669)), V((0.6028,0.761122)), V((0.5928,0.765850)), V((0.5896,0.759821)), ),
    14993: (V((0.6028,0.761122)), V((0.6056,0.766635)), V((0.5956,0.771558)), V((0.5928,0.765850)), ),
    14994: (V((0.5898,0.742483)), V((0.5962,0.750157)), V((0.5849,0.752750)), V((0.5780,0.745085)), ),
    14995: (V((0.6078,0.774382)), V((0.5985,0.779055)), V((0.5956,0.771558)), V((0.6056,0.766635)), ),
    14996: (V((0.5559,0.801737)), V((0.5652,0.797165)), V((0.5667,0.806414)), V((0.5571,0.811033)), ),
    14997: (V((0.5985,0.779055)), V((0.5907,0.783856)), V((0.5879,0.776168)), V((0.5956,0.771558)), ),
    14998: (V((0.5206,0.231831)), V((0.5297,0.233894)), V((0.5272,0.251138)), V((0.5168,0.250367)), ),
    14999: (V((0.5168,0.250367)), V((0.5272,0.251138)), V((0.5242,0.266416)), V((0.5134,0.265702)), ),
    15000: (V((0.5962,0.750157)), V((0.6000,0.755669)), V((0.5896,0.759821)), V((0.5849,0.752750)), ),
    15001: (V((0.6156,0.754968)), V((0.6177,0.759795)), V((0.6056,0.766635)), V((0.6028,0.761122)), ),
    15002: (V((0.6038,0.737792)), V((0.6089,0.744132)), V((0.5962,0.750157)), V((0.5898,0.742483)), ),
    15003: (V((0.5453,0.814906)), V((0.5571,0.811033)), V((0.5577,0.819277)), V((0.5473,0.822324)), ),
    15004: (V((0.5521,0.687339)), V((0.5563,0.702244)), V((0.5473,0.704767)), V((0.5420,0.688729)), ),
    15005: (V((0.5134,0.265702)), V((0.5242,0.266416)), V((0.5215,0.281780)), V((0.5102,0.279830)), ),
    15006: (V((0.6089,0.744132)), V((0.6123,0.749439)), V((0.6000,0.755669)), V((0.5962,0.750157)), ),
    15007: (V((0.5849,0.685709)), V((0.5880,0.699782)), V((0.5741,0.700354)), V((0.5704,0.687202)), ),
    15008: (V((0.6123,0.749439)), V((0.6156,0.754968)), V((0.6028,0.761122)), V((0.6000,0.755669)), ),
    15009: (V((0.6181,0.730383)), V((0.6228,0.736949)), V((0.6089,0.744132)), V((0.6038,0.737792)), ),
    15010: (V((0.5571,0.811033)), V((0.5453,0.814906)), V((0.5452,0.805370)), V((0.5559,0.801737)), ),
    15011: (V((0.5057,0.304196)), V((0.5163,0.306278)), V((0.5151,0.315818)), V((0.5044,0.315343)), ),
    15012: (V((0.6228,0.736949)), V((0.6255,0.741577)), V((0.6123,0.749439)), V((0.6089,0.744132)), ),
    15013: (V((0.6011,0.685500)), V((0.6029,0.697285)), V((0.5880,0.699782)), V((0.5849,0.685709)), ),
    15014: (V((0.6255,0.741577)), V((0.6281,0.746384)), V((0.6156,0.754968)), V((0.6123,0.749439)), ),
    15015: (V((0.6281,0.746384)), V((0.6303,0.751661)), V((0.6177,0.759795)), V((0.6156,0.754968)), ),
    15016: (V((0.5473,0.822324)), V((0.5340,0.826454)), V((0.5332,0.819149)), V((0.5453,0.814906)), ),
    15017: (V((0.5652,0.797165)), V((0.5559,0.801737)), V((0.5548,0.792610)), V((0.5641,0.788251)), ),
    15018: (V((0.5044,0.315343)), V((0.5151,0.315818)), V((0.5124,0.326234)), V((0.5020,0.326332)), ),
    15019: (V((0.6361,0.728793)), V((0.6383,0.733461)), V((0.6255,0.741577)), V((0.6228,0.736949)), ),
    15020: (V((0.6173,0.684516)), V((0.6174,0.694838)), V((0.6029,0.697285)), V((0.6011,0.685500)), ),
    15021: (V((0.6383,0.733461)), V((0.6406,0.737567)), V((0.6281,0.746384)), V((0.6255,0.741577)), ),
    15022: (V((0.6406,0.737567)), V((0.6423,0.742338)), V((0.6303,0.751661)), V((0.6281,0.746384)), ),
    15023: (V((0.6321,0.722640)), V((0.6361,0.728793)), V((0.6228,0.736949)), V((0.6181,0.730383)), ),
    15024: (V((0.5559,0.801737)), V((0.5452,0.805370)), V((0.5453,0.796558)), V((0.5548,0.792610)), ),
    15025: (V((0.6477,0.720942)), V((0.6494,0.725711)), V((0.6383,0.733461)), V((0.6361,0.728793)), ),
    15026: (V((0.6290,0.682486)), V((0.6300,0.692097)), V((0.6174,0.694838)), V((0.6173,0.684516)), ),
    15027: (V((0.6494,0.725711)), V((0.6515,0.728913)), V((0.6406,0.737567)), V((0.6383,0.733461)), ),
    15028: (V((0.6515,0.728913)), V((0.6536,0.733769)), V((0.6423,0.742338)), V((0.6406,0.737567)), ),
    15029: (V((0.6441,0.715752)), V((0.6477,0.720942)), V((0.6361,0.728793)), V((0.6321,0.722640)), ),
    15030: (V((0.5452,0.805370)), V((0.5332,0.809721)), V((0.5339,0.800334)), V((0.5453,0.796558)), ),
    15031: (V((0.5453,0.814906)), V((0.5332,0.819149)), V((0.5332,0.809721)), V((0.5452,0.805370)), ),
    15032: (V((0.5012,0.703232)), V((0.5035,0.717055)), V((0.4925,0.719730)), V((0.4911,0.706336)), ),
    15033: (V((0.5114,0.830459)), V((0.5206,0.825436)), V((0.5237,0.830915)), V((0.5165,0.835213)), ),
    15034: (V((0.6618,0.712264)), V((0.6633,0.715447)), V((0.6494,0.725711)), V((0.6477,0.720942)), ),
    15035: (V((0.6472,0.680974)), V((0.6486,0.685740)), V((0.6300,0.692097)), V((0.6290,0.682486)), ),
    15036: (V((0.6633,0.715447)), V((0.6660,0.720030)), V((0.6515,0.728913)), V((0.6494,0.725711)), ),
    15037: (V((0.6660,0.720030)), V((0.6682,0.724004)), V((0.6536,0.733769)), V((0.6515,0.728913)), ),
    15038: (V((0.6590,0.707307)), V((0.6618,0.712264)), V((0.6477,0.720942)), V((0.6441,0.715752)), ),
    15039: (V((0.5206,0.825436)), V((0.5332,0.819149)), V((0.5340,0.826454)), V((0.5237,0.830915)), ),
    15040: (V((0.5332,0.819149)), V((0.5206,0.825436)), V((0.5191,0.815442)), V((0.5332,0.809721)), ),
    15041: (V((0.5070,0.809878)), V((0.5199,0.805344)), V((0.5191,0.815442)), V((0.5076,0.820025)), ),
    15042: (V((0.5017,0.834770)), V((0.5114,0.830459)), V((0.5165,0.835213)), V((0.5110,0.838626)), ),
    15043: (V((0.8061,0.807498)), V((0.8265,0.802302)), V((0.8055,0.822628)), V((0.8021,0.818823)), ),
    15044: (V((0.8287,0.875239)), V((0.8274,0.887863)), V((0.8119,0.885400)), V((0.8124,0.875778)), ),
    15045: (V((0.8274,0.887863)), V((0.8273,0.896646)), V((0.8112,0.893406)), V((0.8119,0.885400)), ),
    15046: (V((0.8285,0.856638)), V((0.8287,0.867109)), V((0.8128,0.869036)), V((0.8128,0.858357)), ),
    15047: (V((0.5076,0.820025)), V((0.4976,0.824662)), V((0.4963,0.813921)), V((0.5070,0.809878)), ),
    15048: (V((0.5339,0.800334)), V((0.5332,0.809721)), V((0.5191,0.815442)), V((0.5199,0.805344)), ),
    15049: (V((0.8287,0.867109)), V((0.8287,0.875239)), V((0.8124,0.875778)), V((0.8128,0.869036)), ),
    15050: (V((0.8111,0.836972)), V((0.8312,0.825972)), V((0.8282,0.844930)), V((0.8123,0.846631)), ),
    15051: (V((0.8087,0.828667)), V((0.8328,0.810050)), V((0.8312,0.825972)), V((0.8111,0.836972)), ),
    15052: (V((0.6562,0.701636)), V((0.6408,0.711188)), V((0.6353,0.703863)), V((0.6535,0.696662)), ),
    15053: (V((0.6226,0.708316)), V((0.6353,0.703863)), V((0.6408,0.711188)), V((0.6280,0.717422)), ),
    15054: (V((0.6317,0.697174)), V((0.6505,0.691313)), V((0.6535,0.696662)), V((0.6353,0.703863)), ),
    15055: (V((0.6192,0.700562)), V((0.6317,0.697174)), V((0.6353,0.703863)), V((0.6226,0.708316)), ),
    15056: (V((0.6226,0.708316)), V((0.6082,0.712868)), V((0.6048,0.703646)), V((0.6192,0.700562)), ),
    15057: (V((0.6082,0.712868)), V((0.6226,0.708316)), V((0.6280,0.717422)), V((0.6133,0.724272)), ),
    15058: (V((0.5898,0.706740)), V((0.6048,0.703646)), V((0.6082,0.712868)), V((0.5927,0.717185)), ),
    15059: (V((0.5760,0.709457)), V((0.5898,0.706740)), V((0.5927,0.717185)), V((0.5792,0.721889)), ),
    15060: (V((0.5665,0.710569)), V((0.5760,0.709457)), V((0.5792,0.721889)), V((0.5715,0.724179)), ),
    15061: (V((0.5612,0.712607)), V((0.5665,0.710569)), V((0.5715,0.724179)), V((0.5630,0.727853)), ),
    15062: (V((0.5797,0.800680)), V((0.5925,0.793637)), V((0.5932,0.799501)), V((0.5803,0.807100)), ),
    15063: (V((0.5927,0.717185)), V((0.6082,0.712868)), V((0.6133,0.724272)), V((0.5981,0.730995)), ),
    15064: (V((0.5796,0.789136)), V((0.5907,0.783856)), V((0.5925,0.793637)), V((0.5797,0.800680)), ),
    15065: (V((0.5792,0.721889)), V((0.5927,0.717185)), V((0.5981,0.730995)), V((0.5842,0.735371)), ),
    15066: (V((0.5715,0.724179)), V((0.5792,0.721889)), V((0.5842,0.735371)), V((0.5747,0.737744)), ),
    15067: (V((0.5747,0.737744)), V((0.5687,0.739307)), V((0.5630,0.727853)), V((0.5715,0.724179)), ),
    15068: (V((0.5879,0.776168)), V((0.5907,0.783856)), V((0.5796,0.789136)), V((0.5775,0.781791)), ),
    15069: (V((0.5848,0.770725)), V((0.5879,0.776168)), V((0.5775,0.781791)), V((0.5745,0.776070)), ),
    15070: (V((0.5344,0.720731)), V((0.5444,0.717059)), V((0.5497,0.729093)), V((0.5390,0.732771)), ),
    15071: (V((0.4658,0.868325)), V((0.4709,0.857857)), V((0.4808,0.865217)), V((0.4748,0.875137)), ),
    15072: (V((0.4622,0.878565)), V((0.4658,0.868325)), V((0.4748,0.875137)), V((0.4695,0.886041)), ),
    15073: (V((0.5005,0.339462)), V((0.5097,0.340075)), V((0.5073,0.352893)), V((0.4987,0.352268)), ),
    15074: (V((0.4859,0.433175)), V((0.4879,0.416903)), V((0.4977,0.418082)), V((0.4962,0.435003)), ),
    15075: (V((0.4821,0.458239)), V((0.4952,0.460067)), V((0.4951,0.470148)), V((0.4816,0.467705)), ),
    15076: (V((0.5071,0.499651)), V((0.4966,0.495586)), V((0.4968,0.482240)), V((0.5096,0.485725)), ),
    15077: (V((0.4792,0.576213)), V((0.4703,0.574101)), V((0.4730,0.561665)), V((0.4817,0.564044)), ),
    15078: (V((0.4809,0.653053)), V((0.4719,0.653607)), V((0.4712,0.645612)), V((0.4801,0.645220)), ),
    15079: (V((0.4799,0.636024)), V((0.4711,0.635320)), V((0.4705,0.623044)), V((0.4795,0.623582)), ),
    15080: (V((0.4801,0.645220)), V((0.4712,0.645612)), V((0.4711,0.635320)), V((0.4799,0.636024)), ),
    15081: (V((0.5054,0.869412)), V((0.5087,0.862361)), V((0.5149,0.864551)), V((0.5120,0.872037)), ),
    15082: (V((0.4933,0.861967)), V((0.4998,0.856693)), V((0.5036,0.860107)), V((0.4991,0.866051)), ),
    15083: (V((0.4816,0.659603)), V((0.4721,0.660627)), V((0.4719,0.653607)), V((0.4809,0.653053)), ),
    15084: (V((0.4830,0.674447)), V((0.4757,0.677993)), V((0.4735,0.672535)), V((0.4830,0.671129)), ),
    15085: (V((0.4698,0.702832)), V((0.4783,0.700736)), V((0.4783,0.703805)), V((0.4774,0.706944)), ),
    15086: (V((0.4873,0.856838)), V((0.4808,0.865217)), V((0.4709,0.857857)), V((0.4767,0.849405)), ),
    15087: (V((0.5233,0.724287)), V((0.5344,0.720731)), V((0.5390,0.732771)), V((0.5287,0.737107)), ),
    15088: (V((0.5080,0.727866)), V((0.5233,0.724287)), V((0.5287,0.737107)), V((0.5143,0.740974)), ),
    15089: (V((0.5325,0.792874)), V((0.5339,0.800334)), V((0.5199,0.805344)), V((0.5197,0.797466)), ),
    15090: (V((0.5315,0.784932)), V((0.5325,0.792874)), V((0.5197,0.797466)), V((0.5185,0.789548)), ),
    15091: (V((0.4808,0.732359)), V((0.4940,0.729832)), V((0.4990,0.744308)), V((0.4840,0.747179)), ),
    15092: (V((0.4840,0.747179)), V((0.4702,0.750538)), V((0.4663,0.734292)), V((0.4808,0.732359)), ),
    15093: (V((0.5390,0.732771)), V((0.5497,0.729093)), V((0.5539,0.742789)), V((0.5432,0.744831)), ),
    15094: (V((0.4615,0.754476)), V((0.4506,0.740258)), V((0.4663,0.734292)), V((0.4702,0.750538)), ),
    15095: (V((0.5287,0.737107)), V((0.5390,0.732771)), V((0.5432,0.744831)), V((0.5325,0.748439)), ),
    15096: (V((0.4615,0.754476)), V((0.4482,0.762077)), V((0.4397,0.748376)), V((0.4506,0.740258)), ),
    15097: (V((0.5143,0.740974)), V((0.5287,0.737107)), V((0.5325,0.748439)), V((0.5205,0.753324)), ),
    15098: (V((0.5292,0.775036)), V((0.5315,0.784932)), V((0.5185,0.789548)), V((0.5164,0.780089)), ),
    15099: (V((0.5250,0.762285)), V((0.5292,0.775036)), V((0.5164,0.780089)), V((0.5119,0.766248)), ),
    15100: (V((0.4840,0.747179)), V((0.4990,0.744308)), V((0.5068,0.756968)), V((0.4947,0.761746)), ),
    15101: (V((0.4277,0.757746)), V((0.4397,0.748376)), V((0.4482,0.762077)), V((0.4356,0.769774)), ),
    15102: (V((0.4947,0.761746)), V((0.4840,0.764792)), V((0.4702,0.750538)), V((0.4840,0.747179)), ),
    15103: (V((0.4356,0.769774)), V((0.4223,0.773935)), V((0.4152,0.761587)), V((0.4277,0.757746)), ),
    15104: (V((0.4717,0.769247)), V((0.4615,0.754476)), V((0.4702,0.750538)), V((0.4840,0.764792)), ),
    15105: (V((0.4717,0.769247)), V((0.4568,0.775158)), V((0.4482,0.762077)), V((0.4615,0.754476)), ),
    15106: (V((0.4356,0.769774)), V((0.4482,0.762077)), V((0.4568,0.775158)), V((0.4432,0.781154)), ),
    15107: (V((0.4980,0.651949)), V((0.4894,0.652473)), V((0.4883,0.644924)), V((0.4968,0.644495)), ),
    15108: (V((0.4719,0.653607)), V((0.4607,0.654861)), V((0.4600,0.645684)), V((0.4712,0.645612)), ),
    15109: (V((0.5066,0.651410)), V((0.4980,0.651949)), V((0.4968,0.644495)), V((0.5054,0.644164)), ),
    15110: (V((0.4968,0.644495)), V((0.4883,0.644924)), V((0.4875,0.635760)), V((0.4953,0.635380)), ),
    15111: (V((0.4712,0.645612)), V((0.4600,0.645684)), V((0.4603,0.634923)), V((0.4711,0.635320)), ),
    15112: (V((0.5054,0.644164)), V((0.4968,0.644495)), V((0.4953,0.635380)), V((0.5034,0.634968)), ),
    15113: (V((0.4953,0.635380)), V((0.4875,0.635760)), V((0.4863,0.623986)), V((0.4941,0.623924)), ),
    15114: (V((0.4711,0.635320)), V((0.4603,0.634923)), V((0.4595,0.622152)), V((0.4705,0.623044)), ),
    15115: (V((0.5034,0.634968)), V((0.4953,0.635380)), V((0.4941,0.623924)), V((0.5012,0.623892)), ),
    15116: (V((0.4174,0.626428)), V((0.4173,0.639495)), V((0.4012,0.641922)), V((0.4017,0.626959)), ),
    15117: (V((0.3904,0.659731)), V((0.3782,0.663459)), V((0.3769,0.646731)), V((0.3894,0.644674)), ),
    15118: (V((0.3894,0.644674)), V((0.3769,0.646731)), V((0.3764,0.629312)), V((0.3890,0.628354)), ),
    15119: (V((0.4173,0.639495)), V((0.4180,0.652879)), V((0.4025,0.656466)), V((0.4012,0.641922)), ),
    15120: (V((0.3660,0.647762)), V((0.3566,0.648789)), V((0.3559,0.631068)), V((0.3653,0.630583)), ),
    15121: (V((0.3482,0.649261)), V((0.3401,0.649536)), V((0.3401,0.631002)), V((0.3478,0.631158)), ),
    15122: (V((0.4004,0.672597)), V((0.4191,0.662671)), V((0.4206,0.670067)), V((0.4039,0.676947)), ),
    15123: (V((0.3673,0.662394)), V((0.3574,0.663829)), V((0.3566,0.648789)), V((0.3660,0.647762)), ),
    15124: (V((0.4223,0.773935)), V((0.4107,0.776863)), V((0.4019,0.763821)), V((0.4152,0.761587)), ),
    15125: (V((0.3904,0.659731)), V((0.3894,0.644674)), V((0.4012,0.641922)), V((0.4025,0.656466)), ),
    15126: (V((0.3890,0.628354)), V((0.4017,0.626959)), V((0.4012,0.641922)), V((0.3894,0.644674)), ),
    15127: (V((0.3673,0.662394)), V((0.3660,0.647762)), V((0.3769,0.646731)), V((0.3782,0.663459)), ),
    15128: (V((0.3769,0.646731)), V((0.3660,0.647762)), V((0.3653,0.630583)), V((0.3764,0.629312)), ),
    15129: (V((0.5003,0.610580)), V((0.4935,0.610414)), V((0.4940,0.595526)), V((0.5001,0.596749)), ),
    15130: (V((0.4935,0.610414)), V((0.4872,0.610667)), V((0.4861,0.592339)), V((0.4940,0.595526)), ),
    15131: (V((0.4786,0.608980)), V((0.4780,0.590381)), V((0.4861,0.592339)), V((0.4872,0.610667)), ),
    15132: (V((0.4690,0.589632)), V((0.4780,0.590381)), V((0.4786,0.608980)), V((0.4690,0.603467)), ),
    15133: (V((0.4690,0.603467)), V((0.4598,0.602447)), V((0.4597,0.587784)), V((0.4690,0.589632)), ),
    15134: (V((0.4159,0.606803)), V((0.4023,0.608553)), V((0.4023,0.590277)), V((0.4156,0.587550)), ),
    15135: (V((0.3900,0.590991)), V((0.4023,0.590277)), V((0.4023,0.608553)), V((0.3890,0.609657)), ),
    15136: (V((0.3771,0.591444)), V((0.3900,0.590991)), V((0.3890,0.609657)), V((0.3769,0.610967)), ),
    15137: (V((0.3653,0.591808)), V((0.3771,0.591444)), V((0.3769,0.610967)), V((0.3651,0.611347)), ),
    15138: (V((0.3551,0.592022)), V((0.3653,0.591808)), V((0.3651,0.611347)), V((0.3553,0.611647)), ),
    15139: (V((0.4029,0.574087)), V((0.3904,0.573836)), V((0.3911,0.557858)), V((0.4036,0.558818)), ),
    15140: (V((0.3658,0.573320)), V((0.3562,0.573303)), V((0.3561,0.555388)), V((0.3662,0.556285)), ),
    15141: (V((0.3904,0.573836)), V((0.3777,0.573403)), V((0.3784,0.556932)), V((0.3911,0.557858)), ),
    15142: (V((0.4156,0.573452)), V((0.4029,0.574087)), V((0.4036,0.558818)), V((0.4154,0.560024)), ),
    15143: (V((0.3777,0.573403)), V((0.3658,0.573320)), V((0.3662,0.556285)), V((0.3784,0.556932)), ),
    15144: (V((0.4156,0.587550)), V((0.4023,0.590277)), V((0.4029,0.574087)), V((0.4156,0.573452)), ),
    15145: (V((0.5017,0.583885)), V((0.4940,0.581072)), V((0.4962,0.570020)), V((0.5033,0.573246)), ),
    15146: (V((0.4940,0.581072)), V((0.4876,0.578575)), V((0.4894,0.566792)), V((0.4962,0.570020)), ),
    15147: (V((0.3904,0.573836)), V((0.4029,0.574087)), V((0.4023,0.590277)), V((0.3900,0.590991)), ),
    15148: (V((0.4703,0.574101)), V((0.4601,0.572584)), V((0.4614,0.560057)), V((0.4730,0.561665)), ),
    15149: (V((0.5330,0.508423)), V((0.5261,0.505872)), V((0.5361,0.488330)), V((0.5440,0.493195)), ),
    15150: (V((0.5261,0.505872)), V((0.5174,0.503464)), V((0.5215,0.489504)), V((0.5361,0.488330)), ),
    15151: (V((0.4966,0.495586)), V((0.4814,0.489965)), V((0.4818,0.477934)), V((0.4968,0.482240)), ),
    15152: (V((0.5399,0.526257)), V((0.5477,0.510521)), V((0.5585,0.509150)), V((0.5455,0.528912)), ),
    15153: (V((0.5265,0.522120)), V((0.5330,0.508423)), V((0.5409,0.510582)), V((0.5336,0.524661)), ),
    15154: (V((0.5265,0.522120)), V((0.5199,0.519953)), V((0.5261,0.505872)), V((0.5330,0.508423)), ),
    15155: (V((0.3481,0.494192)), V((0.3486,0.513331)), V((0.3401,0.511954)), V((0.3401,0.492831)), ),
    15156: (V((0.3467,0.477758)), V((0.3481,0.494192)), V((0.3401,0.492831)), V((0.3399,0.476496)), ),
    15157: (V((0.5199,0.519953)), V((0.5116,0.516686)), V((0.5174,0.503464)), V((0.5261,0.505872)), ),
    15158: (V((0.5032,0.513093)), V((0.5071,0.499651)), V((0.5174,0.503464)), V((0.5116,0.516686)), ),
    15159: (V((0.5221,0.569984)), V((0.5279,0.556694)), V((0.5317,0.558907)), V((0.5267,0.571636)), ),
    15160: (V((0.5088,0.561099)), V((0.5141,0.549053)), V((0.5207,0.552953)), V((0.5157,0.565114)), ),
    15161: (V((0.5088,0.561099)), V((0.5018,0.557306)), V((0.5074,0.545396)), V((0.5141,0.549053)), ),
    15162: (V((0.5018,0.557306)), V((0.4945,0.554093)), V((0.5000,0.541762)), V((0.5074,0.545396)), ),
    15163: (V((0.4864,0.551324)), V((0.4921,0.538893)), V((0.5000,0.541762)), V((0.4945,0.554093)), ),
    15164: (V((0.4834,0.536479)), V((0.4921,0.538893)), V((0.4864,0.551324)), V((0.4780,0.549236)), ),
    15165: (V((0.4780,0.549236)), V((0.4654,0.547516)), V((0.4694,0.534204)), V((0.4834,0.536479)), ),
    15166: (V((0.3562,0.497079)), V((0.3658,0.499988)), V((0.3663,0.519830)), V((0.3570,0.516146)), ),
    15167: (V((0.3658,0.499988)), V((0.3803,0.501977)), V((0.3793,0.521619)), V((0.3663,0.519830)), ),
    15168: (V((0.3803,0.501977)), V((0.3930,0.504917)), V((0.3926,0.523273)), V((0.3793,0.521619)), ),
    15169: (V((0.3930,0.504917)), V((0.4064,0.507054)), V((0.4055,0.524892)), V((0.3926,0.523273)), ),
    15170: (V((0.4213,0.508941)), V((0.4200,0.528172)), V((0.4055,0.524892)), V((0.4064,0.507054)), ),
    15171: (V((0.3533,0.478798)), V((0.3653,0.480300)), V((0.3658,0.499988)), V((0.3562,0.497079)), ),
    15172: (V((0.3653,0.480300)), V((0.3801,0.484800)), V((0.3803,0.501977)), V((0.3658,0.499988)), ),
    15173: (V((0.3801,0.484800)), V((0.3943,0.487800)), V((0.3930,0.504917)), V((0.3803,0.501977)), ),
    15174: (V((0.3943,0.487800)), V((0.4080,0.489438)), V((0.4064,0.507054)), V((0.3930,0.504917)), ),
    15175: (V((0.4064,0.507054)), V((0.4080,0.489438)), V((0.4241,0.491094)), V((0.4213,0.508941)), ),
    15176: (V((0.4966,0.495586)), V((0.5071,0.499651)), V((0.5032,0.513093)), V((0.4937,0.509380)), ),
    15177: (V((0.4937,0.509380)), V((0.4781,0.504084)), V((0.4814,0.489965)), V((0.4966,0.495586)), ),
    15178: (V((0.5169,0.579893)), V((0.5221,0.569984)), V((0.5267,0.571636)), V((0.5217,0.583806)), ),
    15179: (V((0.5033,0.573246)), V((0.5088,0.561099)), V((0.5157,0.565114)), V((0.5107,0.576772)), ),
    15180: (V((0.5033,0.573246)), V((0.4962,0.570020)), V((0.5018,0.557306)), V((0.5088,0.561099)), ),
    15181: (V((0.4882,0.828867)), V((0.4775,0.832776)), V((0.4732,0.821440)), V((0.4858,0.817137)), ),
    15182: (V((0.4962,0.570020)), V((0.4894,0.566792)), V((0.4945,0.554093)), V((0.5018,0.557306)), ),
    15183: (V((0.4817,0.564044)), V((0.4864,0.551324)), V((0.4945,0.554093)), V((0.4894,0.566792)), ),
    15184: (V((0.4780,0.549236)), V((0.4864,0.551324)), V((0.4817,0.564044)), V((0.4730,0.561665)), ),
    15185: (V((0.4730,0.561665)), V((0.4614,0.560057)), V((0.4654,0.547516)), V((0.4780,0.549236)), ),
    15186: (V((0.8328,0.810050)), V((0.8087,0.828667)), V((0.8055,0.822628)), V((0.8265,0.802302)), ),
    15187: (V((0.6505,0.691313)), V((0.6317,0.697174)), V((0.6300,0.692097)), V((0.6486,0.685740)), ),
    15188: (V((0.6317,0.697174)), V((0.6192,0.700562)), V((0.6174,0.694838)), V((0.6300,0.692097)), ),
    15189: (V((0.6192,0.700562)), V((0.6048,0.703646)), V((0.6029,0.697285)), V((0.6174,0.694838)), ),
    15190: (V((0.5880,0.699782)), V((0.6029,0.697285)), V((0.6048,0.703646)), V((0.5898,0.706740)), ),
    15191: (V((0.5741,0.700354)), V((0.5880,0.699782)), V((0.5898,0.706740)), V((0.5760,0.709457)), ),
    15192: (V((0.4775,0.832776)), V((0.4686,0.838264)), V((0.4630,0.825178)), V((0.4732,0.821440)), ),
    15193: (V((0.4876,0.870962)), V((0.4933,0.861967)), V((0.4991,0.866051)), V((0.4943,0.875081)), ),
    15194: (V((0.4894,0.652473)), V((0.4809,0.653053)), V((0.4801,0.645220)), V((0.4883,0.644924)), ),
    15195: (V((0.4883,0.644924)), V((0.4801,0.645220)), V((0.4799,0.636024)), V((0.4875,0.635760)), ),
    15196: (V((0.4875,0.635760)), V((0.4799,0.636024)), V((0.4795,0.623582)), V((0.4863,0.623986)), ),
    15197: (V((0.3476,0.591689)), V((0.3551,0.592022)), V((0.3553,0.611647)), V((0.3478,0.611486)), ),
    15198: (V((0.3777,0.573403)), V((0.3904,0.573836)), V((0.3900,0.590991)), V((0.3771,0.591444)), ),
    15199: (V((0.3658,0.573320)), V((0.3777,0.573403)), V((0.3771,0.591444)), V((0.3653,0.591808)), ),
    15200: (V((0.4876,0.578575)), V((0.4792,0.576213)), V((0.4817,0.564044)), V((0.4894,0.566792)), ),
    15201: (V((0.4834,0.536479)), V((0.4694,0.534204)), V((0.4739,0.518877)), V((0.4883,0.522923)), ),
    15202: (V((0.4883,0.522923)), V((0.4739,0.518877)), V((0.4781,0.504084)), V((0.4937,0.509380)), ),
    15203: (V((0.5096,0.485725)), V((0.5215,0.489504)), V((0.5174,0.503464)), V((0.5071,0.499651)), ),
    15204: (V((0.3868,0.458631)), V((0.4012,0.461968)), V((0.3973,0.475067)), V((0.3826,0.471426)), ),
    15205: (V((0.3826,0.471426)), V((0.3653,0.465748)), V((0.3737,0.454110)), V((0.3868,0.458631)), ),
    15206: (V((0.4257,0.477814)), V((0.4103,0.476780)), V((0.4154,0.464467)), V((0.4279,0.465715)), ),
    15207: (V((0.4012,0.461968)), V((0.4154,0.464467)), V((0.4103,0.476780)), V((0.3973,0.475067)), ),
    15208: (V((0.3546,0.439591)), V((0.3628,0.447298)), V((0.3582,0.455587)), V((0.3517,0.443458)), ),
    15209: (V((0.3504,0.432242)), V((0.3546,0.439591)), V((0.3517,0.443458)), V((0.3485,0.435363)), ),
    15210: (V((0.5516,0.482212)), V((0.5440,0.493195)), V((0.5361,0.488330)), V((0.5464,0.474936)), ),
    15211: (V((0.5182,0.470645)), V((0.5073,0.471446)), V((0.5056,0.459903)), V((0.5168,0.458566)), ),
    15212: (V((0.4952,0.460067)), V((0.5056,0.459903)), V((0.5073,0.471446)), V((0.4951,0.470148)), ),
    15213: (V((0.3971,0.433360)), V((0.4092,0.438690)), V((0.4048,0.450803)), V((0.3920,0.445994)), ),
    15214: (V((0.5760,0.709457)), V((0.5665,0.710569)), V((0.5649,0.700303)), V((0.5741,0.700354)), ),
    15215: (V((0.5305,0.467767)), V((0.5182,0.470645)), V((0.5168,0.458566)), V((0.5276,0.454079)), ),
    15216: (V((0.3688,0.414927)), V((0.3769,0.421764)), V((0.3706,0.434130)), V((0.3614,0.427784)), ),
    15217: (V((0.5665,0.710569)), V((0.5612,0.712607)), V((0.5563,0.702244)), V((0.5649,0.700303)), ),
    15218: (V((0.4092,0.438690)), V((0.4205,0.443439)), V((0.4168,0.453592)), V((0.4048,0.450803)), ),
    15219: (V((0.3597,0.409301)), V((0.3688,0.414927)), V((0.3614,0.427784)), V((0.3550,0.421391)), ),
    15220: (V((0.3920,0.445994)), V((0.3806,0.441249)), V((0.3869,0.428118)), V((0.3971,0.433360)), ),
    15221: (V((0.4309,0.456519)), V((0.4168,0.453592)), V((0.4205,0.443439)), V((0.4331,0.447734)), ),
    15222: (V((0.5417,0.461601)), V((0.5305,0.467767)), V((0.5276,0.454079)), V((0.5375,0.449759)), ),
    15223: (V((0.3796,0.392471)), V((0.3863,0.378260)), V((0.3951,0.384081)), V((0.3879,0.398466)), ),
    15224: (V((0.3711,0.387960)), V((0.3780,0.374201)), V((0.3863,0.378260)), V((0.3796,0.392471)), ),
    15225: (V((0.3711,0.387960)), V((0.3629,0.383770)), V((0.3699,0.370113)), V((0.3780,0.374201)), ),
    15226: (V((0.4962,0.435003)), V((0.4977,0.418082)), V((0.5076,0.417825)), V((0.5074,0.434931)), ),
    15227: (V((0.5473,0.704767)), V((0.5563,0.702244)), V((0.5612,0.712607)), V((0.5527,0.714009)), ),
    15228: (V((0.5444,0.717059)), V((0.5391,0.708159)), V((0.5473,0.704767)), V((0.5527,0.714009)), ),
    15229: (V((0.5297,0.710222)), V((0.5391,0.708159)), V((0.5444,0.717059)), V((0.5344,0.720731)), ),
    15230: (V((0.5344,0.720731)), V((0.5233,0.724287)), V((0.5182,0.713353)), V((0.5297,0.710222)), ),
    15231: (V((0.4399,0.325281)), V((0.4476,0.327934)), V((0.4440,0.340845)), V((0.4367,0.337250)), ),
    15232: (V((0.5035,0.717055)), V((0.5182,0.713353)), V((0.5233,0.724287)), V((0.5080,0.727866)), ),
    15233: (V((0.5326,0.354591)), V((0.5244,0.354187)), V((0.5279,0.342074)), V((0.5357,0.343868)), ),
    15234: (V((0.4166,0.311117)), V((0.4244,0.316643)), V((0.4199,0.327186)), V((0.4121,0.321606)), ),
    15235: (V((0.4925,0.719730)), V((0.5035,0.717055)), V((0.5080,0.727866)), V((0.4940,0.729832)), ),
    15236: (V((0.4476,0.327934)), V((0.4547,0.329816)), V((0.4520,0.343547)), V((0.4440,0.340845)), ),
    15237: (V((0.4082,0.307284)), V((0.4166,0.311117)), V((0.4121,0.321606)), V((0.4046,0.317270)), ),
    15238: (V((0.4367,0.337250)), V((0.4291,0.333220)), V((0.4331,0.322564)), V((0.4399,0.325281)), ),
    15239: (V((0.4614,0.345669)), V((0.4520,0.343547)), V((0.4547,0.329816)), V((0.4643,0.332929)), ),
    15240: (V((0.5416,0.355212)), V((0.5326,0.354591)), V((0.5357,0.343868)), V((0.5445,0.345835)), ),
    15241: (V((0.5244,0.354187)), V((0.5162,0.353223)), V((0.5191,0.341322)), V((0.5279,0.342074)), ),
    15242: (V((0.5097,0.340075)), V((0.5191,0.341322)), V((0.5162,0.353223)), V((0.5073,0.352893)), ),
    15243: (V((0.4399,0.325281)), V((0.4331,0.322564)), V((0.4377,0.308549)), V((0.4440,0.312762)), ),
    15244: (V((0.4377,0.308549)), V((0.4331,0.322564)), V((0.4244,0.316643)), V((0.4297,0.302107)), ),
    15245: (V((0.4219,0.296734)), V((0.4297,0.302107)), V((0.4244,0.316643)), V((0.4166,0.311117)), ),
    15246: (V((0.4150,0.291816)), V((0.4219,0.296734)), V((0.4166,0.311117)), V((0.4082,0.307284)), ),
    15247: (V((0.4001,0.303758)), V((0.4070,0.287311)), V((0.4150,0.291816)), V((0.4082,0.307284)), ),
    15248: (V((0.5640,0.334711)), V((0.5591,0.350805)), V((0.5520,0.348098)), V((0.5562,0.331868)), ),
    15249: (V((0.5562,0.331868)), V((0.5520,0.348098)), V((0.5445,0.345835)), V((0.5484,0.330081)), ),
    15250: (V((0.4189,0.280657)), V((0.4269,0.284880)), V((0.4219,0.296734)), V((0.4150,0.291816)), ),
    15251: (V((0.4440,0.312762)), V((0.4377,0.308549)), V((0.4419,0.297523)), V((0.4473,0.301015)), ),
    15252: (V((0.4684,0.320679)), V((0.4575,0.317951)), V((0.4596,0.306573)), V((0.4712,0.309279)), ),
    15253: (V((0.5484,0.330081)), V((0.5399,0.328998)), V((0.5430,0.318169)), V((0.5517,0.318712)), ),
    15254: (V((0.5314,0.328536)), V((0.5226,0.327678)), V((0.5252,0.316720)), V((0.5339,0.317337)), ),
    15255: (V((0.5151,0.315818)), V((0.5252,0.316720)), V((0.5226,0.327678)), V((0.5124,0.326234)), ),
    15256: (V((0.4473,0.301015)), V((0.4536,0.304374)), V((0.4509,0.315833)), V((0.4440,0.312762)), ),
    15257: (V((0.4844,0.720984)), V((0.4925,0.719730)), V((0.4940,0.729832)), V((0.4808,0.732359)), ),
    15258: (V((0.5399,0.328998)), V((0.5314,0.328536)), V((0.5339,0.317337)), V((0.5430,0.318169)), ),
    15259: (V((0.4269,0.284880)), V((0.4343,0.290226)), V((0.4297,0.302107)), V((0.4219,0.296734)), ),
    15260: (V((0.4808,0.732359)), V((0.4663,0.734292)), V((0.4770,0.721380)), V((0.4844,0.720984)), ),
    15261: (V((0.4536,0.304374)), V((0.4596,0.306573)), V((0.4575,0.317951)), V((0.4509,0.315833)), ),
    15262: (V((0.5163,0.306278)), V((0.5277,0.305977)), V((0.5252,0.316720)), V((0.5151,0.315818)), ),
    15263: (V((0.4505,0.287940)), V((0.4556,0.291952)), V((0.4536,0.304374)), V((0.4473,0.301015)), ),
    15264: (V((0.4663,0.734292)), V((0.4546,0.723485)), V((0.4651,0.714738)), V((0.4770,0.721380)), ),
    15265: (V((0.5430,0.318169)), V((0.5339,0.317337)), V((0.5370,0.306461)), V((0.5457,0.306224)), ),
    15266: (V((0.4316,0.272765)), V((0.4386,0.277832)), V((0.4343,0.290226)), V((0.4269,0.284880)), ),
    15267: (V((0.4546,0.723485)), V((0.4498,0.715388)), V((0.4600,0.707848)), V((0.4651,0.714738)), ),
    15268: (V((0.4556,0.291952)), V((0.4621,0.295385)), V((0.4596,0.306573)), V((0.4536,0.304374)), ),
    15269: (V((0.4239,0.268549)), V((0.4316,0.272765)), V((0.4269,0.284880)), V((0.4189,0.280657)), ),
    15270: (V((0.4473,0.301015)), V((0.4419,0.297523)), V((0.4453,0.283818)), V((0.4505,0.287940)), ),
    15271: (V((0.4712,0.309279)), V((0.4596,0.306573)), V((0.4621,0.295385)), V((0.4733,0.298412)), ),
    15272: (V((0.5517,0.318712)), V((0.5430,0.318169)), V((0.5457,0.306224)), V((0.5550,0.306344)), ),
    15273: (V((0.5339,0.317337)), V((0.5252,0.316720)), V((0.5277,0.305977)), V((0.5370,0.306461)), ),
    15274: (V((0.4498,0.715388)), V((0.4466,0.708121)), V((0.4570,0.701782)), V((0.4600,0.707848)), ),
    15275: (V((0.4570,0.701782)), V((0.4466,0.708121)), V((0.4444,0.699745)), V((0.4553,0.695295)), ),
    15276: (V((0.4542,0.688638)), V((0.4553,0.695295)), V((0.4444,0.699745)), V((0.4414,0.691602)), ),
    15277: (V((0.4399,0.684493)), V((0.4530,0.681971)), V((0.4542,0.688638)), V((0.4414,0.691602)), ),
    15278: (V((0.4399,0.684493)), V((0.4382,0.677980)), V((0.4514,0.675531)), V((0.4530,0.681971)), ),
    15279: (V((0.4671,0.249345)), V((0.4738,0.253388)), V((0.4693,0.269087)), V((0.4626,0.264432)), ),
    15280: (V((0.4435,0.231625)), V((0.4497,0.235090)), V((0.4429,0.247784)), V((0.4358,0.243862)), ),
    15281: (V((0.4578,0.260075)), V((0.4534,0.256122)), V((0.4586,0.241991)), V((0.4622,0.245330)), ),
    15282: (V((0.4787,0.273083)), V((0.4693,0.269087)), V((0.4738,0.253388)), V((0.4822,0.257654)), ),
    15283: (V((0.5594,0.280291)), V((0.5508,0.280448)), V((0.5526,0.266194)), V((0.5615,0.265997)), ),
    15284: (V((0.5428,0.281111)), V((0.5329,0.280938)), V((0.5349,0.267022)), V((0.5442,0.266781)), ),
    15285: (V((0.5242,0.266416)), V((0.5349,0.267022)), V((0.5329,0.280938)), V((0.5215,0.281780)), ),
    15286: (V((0.4622,0.245330)), V((0.4671,0.249345)), V((0.4626,0.264432)), V((0.4578,0.260075)), ),
    15287: (V((0.4514,0.675531)), V((0.4382,0.677980)), V((0.4367,0.671761)), V((0.4499,0.669353)), ),
    15288: (V((0.5508,0.280448)), V((0.5428,0.281111)), V((0.5442,0.266781)), V((0.5526,0.266194)), ),
    15289: (V((0.4497,0.235090)), V((0.4546,0.238612)), V((0.4488,0.251895)), V((0.4429,0.247784)), ),
    15290: (V((0.5615,0.265997)), V((0.5526,0.266194)), V((0.5539,0.251637)), V((0.5624,0.250771)), ),
    15291: (V((0.5442,0.266781)), V((0.5349,0.267022)), V((0.5375,0.252003)), V((0.5464,0.252108)), ),
    15292: (V((0.5272,0.251138)), V((0.5375,0.252003)), V((0.5349,0.267022)), V((0.5242,0.266416)), ),
    15293: (V((0.4674,0.230115)), V((0.4717,0.232970)), V((0.4671,0.249345)), V((0.4622,0.245330)), ),
    15294: (V((0.4355,0.665368)), V((0.4488,0.662907)), V((0.4499,0.669353)), V((0.4367,0.671761)), ),
    15295: (V((0.5526,0.266194)), V((0.5442,0.266781)), V((0.5464,0.252108)), V((0.5539,0.251637)), ),
    15296: (V((0.4563,0.221862)), V((0.4606,0.224945)), V((0.4546,0.238612)), V((0.4497,0.235090)), ),
    15297: (V((0.4472,0.655462)), V((0.4488,0.662907)), V((0.4355,0.665368)), V((0.4343,0.658048)), ),
    15298: (V((0.4717,0.232970)), V((0.4778,0.236545)), V((0.4738,0.253388)), V((0.4671,0.249345)), ),
    15299: (V((0.4511,0.218906)), V((0.4563,0.221862)), V((0.4497,0.235090)), V((0.4435,0.231625)), ),
    15300: (V((0.4622,0.245330)), V((0.4586,0.241991)), V((0.4641,0.227645)), V((0.4674,0.230115)), ),
    15301: (V((0.4822,0.257654)), V((0.4738,0.253388)), V((0.4778,0.236545)), V((0.4867,0.241326)), ),
    15302: (V((0.4636,0.208364)), V((0.4672,0.210629)), V((0.4606,0.224945)), V((0.4563,0.221862)), ),
    15303: (V((0.4343,0.658048)), V((0.4330,0.648796)), V((0.4467,0.646897)), V((0.4472,0.655462)), ),
    15304: (V((0.4770,0.216287)), V((0.4833,0.219130)), V((0.4778,0.236545)), V((0.4717,0.232970)), ),
    15305: (V((0.4583,0.205960)), V((0.4636,0.208364)), V((0.4563,0.221862)), V((0.4511,0.218906)), ),
    15306: (V((0.4674,0.230115)), V((0.4641,0.227645)), V((0.4702,0.212636)), V((0.4732,0.214467)), ),
    15307: (V((0.4867,0.241326)), V((0.4778,0.236545)), V((0.4833,0.219130)), V((0.4914,0.222790)), ),
    15308: (V((0.5624,0.250771)), V((0.5539,0.251637)), V((0.5556,0.235768)), V((0.5624,0.233786)), ),
    15309: (V((0.5464,0.252108)), V((0.5375,0.252003)), V((0.5402,0.235453)), V((0.5482,0.236264)), ),
    15310: (V((0.5297,0.233894)), V((0.5402,0.235453)), V((0.5375,0.252003)), V((0.5272,0.251138)), ),
    15311: (V((0.4732,0.214467)), V((0.4770,0.216287)), V((0.4717,0.232970)), V((0.4674,0.230115)), ),
    15312: (V((0.4475,0.635794)), V((0.4467,0.646897)), V((0.4330,0.648796)), V((0.4310,0.637305)), ),
    15313: (V((0.5539,0.251637)), V((0.5464,0.252108)), V((0.5482,0.236264)), V((0.5556,0.235768)), ),
    15314: (V((0.4914,0.222790)), V((0.4833,0.219130)), V((0.4894,0.201240)), V((0.4961,0.202110)), ),
    15315: (V((0.5624,0.233786)), V((0.5556,0.235768)), V((0.5544,0.216112)), V((0.5634,0.214274)), ),
    15316: (V((0.5482,0.236264)), V((0.5402,0.235453)), V((0.5415,0.211250)), V((0.5482,0.215251)), ),
    15317: (V((0.5325,0.209308)), V((0.5415,0.211250)), V((0.5402,0.235453)), V((0.5297,0.233894)), ),
    15318: (V((0.4807,0.197156)), V((0.4839,0.198298)), V((0.4770,0.216287)), V((0.4732,0.214467)), ),
    15319: (V((0.4472,0.625231)), V((0.4475,0.635794)), V((0.4310,0.637305)), V((0.4296,0.627759)), ),
    15320: (V((0.5556,0.235768)), V((0.5482,0.236264)), V((0.5482,0.215251)), V((0.5544,0.216112)), ),
    15321: (V((0.4708,0.193069)), V((0.4742,0.194722)), V((0.4672,0.210629)), V((0.4636,0.208364)), ),
    15322: (V((0.4839,0.198298)), V((0.4894,0.201240)), V((0.4833,0.219130)), V((0.4770,0.216287)), ),
    15323: (V((0.4654,0.190799)), V((0.4708,0.193069)), V((0.4636,0.208364)), V((0.4583,0.205960)), ),
    15324: (V((0.4732,0.214467)), V((0.4702,0.212636)), V((0.4775,0.195993)), V((0.4807,0.197156)), ),
    15325: (V((0.4308,0.604340)), V((0.4311,0.585421)), V((0.4463,0.587295)), V((0.4473,0.604804)), ),
    15326: (V((0.4311,0.585421)), V((0.4317,0.571890)), V((0.4468,0.573217)), V((0.4463,0.587295)), ),
    15327: (V((0.4317,0.571890)), V((0.4327,0.559427)), V((0.4485,0.559507)), V((0.4468,0.573217)), ),
    15328: (V((0.5617,0.187400)), V((0.5544,0.216112)), V((0.5482,0.215251)), V((0.5564,0.183515)), ),
    15329: (V((0.5662,0.190381)), V((0.5634,0.214274)), V((0.5544,0.216112)), V((0.5617,0.187400)), ),
    15330: (V((0.5767,0.205604)), V((0.5703,0.213373)), V((0.5705,0.193035)), V((0.5768,0.196718)), ),
    15331: (V((0.4708,0.193069)), V((0.5015,0.155465)), V((0.5056,0.152641)), V((0.4742,0.194722)), ),
    15332: (V((0.4327,0.559427)), V((0.4354,0.545085)), V((0.4515,0.545769)), V((0.4485,0.559507)), ),
    15333: (V((0.4551,0.531682)), V((0.4515,0.545769)), V((0.4354,0.545085)), V((0.4379,0.530616)), ),
    15334: (V((0.4702,0.212636)), V((0.4672,0.210629)), V((0.4742,0.194722)), V((0.4775,0.195993)), ),
    15335: (V((0.4379,0.530616)), V((0.4413,0.512016)), V((0.4587,0.515721)), V((0.4551,0.531682)), ),
    15336: (V((0.4413,0.512016)), V((0.4424,0.494855)), V((0.4597,0.499035)), V((0.4587,0.515721)), ),
    15337: (V((0.5775,0.230800)), V((0.5702,0.232207)), V((0.5703,0.213373)), V((0.5767,0.205604)), ),
    15338: (V((0.4882,0.828867)), V((0.4858,0.817137)), V((0.4963,0.813921)), V((0.4976,0.824662)), ),
    15339: (V((0.4961,0.804205)), V((0.4963,0.813921)), V((0.4858,0.817137)), V((0.4840,0.808270)), ),
    15340: (V((0.4672,0.210629)), V((0.4702,0.212636)), V((0.4641,0.227645)), V((0.4606,0.224945)), ),
    15341: (V((0.5702,0.232207)), V((0.5775,0.230800)), V((0.5785,0.247761)), V((0.5704,0.249136)), ),
    15342: (V((0.5792,0.264375)), V((0.5697,0.265431)), V((0.5704,0.249136)), V((0.5785,0.247761)), ),
    15343: (V((0.4586,0.241991)), V((0.4546,0.238612)), V((0.4606,0.224945)), V((0.4641,0.227645)), ),
    15344: (V((0.4534,0.256122)), V((0.4488,0.251895)), V((0.4546,0.238612)), V((0.4586,0.241991)), ),
    15345: (V((0.5784,0.280455)), V((0.5680,0.280554)), V((0.5697,0.265431)), V((0.5792,0.264375)), ),
    15346: (V((0.5634,0.307746)), V((0.5729,0.310335)), V((0.5680,0.323562)), V((0.5596,0.320356)), ),
    15347: (V((0.4419,0.297523)), V((0.4343,0.290226)), V((0.4386,0.277832)), V((0.4453,0.283818)), ),
    15348: (V((0.4377,0.308549)), V((0.4297,0.302107)), V((0.4343,0.290226)), V((0.4419,0.297523)), ),
    15349: (V((0.5640,0.334711)), V((0.5562,0.331868)), V((0.5596,0.320356)), V((0.5680,0.323562)), ),
    15350: (V((0.5445,0.345835)), V((0.5357,0.343868)), V((0.5399,0.328998)), V((0.5484,0.330081)), ),
    15351: (V((0.5357,0.343868)), V((0.5279,0.342074)), V((0.5314,0.328536)), V((0.5399,0.328998)), ),
    15352: (V((0.5279,0.342074)), V((0.5191,0.341322)), V((0.5226,0.327678)), V((0.5314,0.328536)), ),
    15353: (V((0.4291,0.333220)), V((0.4199,0.327186)), V((0.4244,0.316643)), V((0.4331,0.322564)), ),
    15354: (V((0.5124,0.326234)), V((0.5226,0.327678)), V((0.5191,0.341322)), V((0.5097,0.340075)), ),
    15355: (V((0.5520,0.348098)), V((0.5591,0.350805)), V((0.5568,0.359162)), V((0.5497,0.356957)), ),
    15356: (V((0.4965,0.795448)), V((0.4961,0.804205)), V((0.4840,0.808270)), V((0.4829,0.799416)), ),
    15357: (V((0.4424,0.494855)), V((0.4441,0.479703)), V((0.4616,0.483675)), V((0.4597,0.499035)), ),
    15358: (V((0.4441,0.479703)), V((0.4454,0.468498)), V((0.4621,0.472598)), V((0.4616,0.483675)), ),
    15359: (V((0.3806,0.441249)), V((0.3706,0.434130)), V((0.3769,0.421764)), V((0.3869,0.428118)), ),
    15360: (V((0.3653,0.465748)), V((0.3582,0.455587)), V((0.3628,0.447298)), V((0.3737,0.454110)), ),
    15361: (V((0.4154,0.560024)), V((0.4036,0.558818)), V((0.4041,0.543586)), V((0.4189,0.543722)), ),
    15362: (V((0.5107,0.576772)), V((0.5086,0.586836)), V((0.5017,0.583885)), V((0.5033,0.573246)), ),
    15363: (V((0.5610,0.450236)), V((0.5517,0.456059)), V((0.5467,0.444798)), V((0.5552,0.440106)), ),
    15364: (V((0.5582,0.469117)), V((0.5696,0.463734)), V((0.5737,0.469417)), V((0.5624,0.473712)), ),
    15365: (V((0.4419,0.889307)), V((0.4413,0.870973)), V((0.4505,0.869451)), V((0.4491,0.892759)), ),
    15366: (V((0.5703,0.213373)), V((0.5634,0.214274)), V((0.5662,0.190381)), V((0.5705,0.193035)), ),
    15367: (V((0.5634,0.214274)), V((0.5703,0.213373)), V((0.5702,0.232207)), V((0.5624,0.233786)), ),
    15368: (V((0.4583,0.205960)), V((0.4528,0.203449)), V((0.4629,0.189110)), V((0.4654,0.190799)), ),
    15369: (V((0.4511,0.218906)), V((0.4454,0.216143)), V((0.4528,0.203449)), V((0.4583,0.205960)), ),
    15370: (V((0.5624,0.233786)), V((0.5702,0.232207)), V((0.5704,0.249136)), V((0.5624,0.250771)), ),
    15371: (V((0.5624,0.250771)), V((0.5704,0.249136)), V((0.5697,0.265431)), V((0.5615,0.265997)), ),
    15372: (V((0.4435,0.231625)), V((0.4368,0.227828)), V((0.4454,0.216143)), V((0.4511,0.218906)), ),
    15373: (V((0.4358,0.243862)), V((0.4283,0.239625)), V((0.4368,0.227828)), V((0.4435,0.231625)), ),
    15374: (V((0.5615,0.265997)), V((0.5697,0.265431)), V((0.5680,0.280554)), V((0.5594,0.280291)), ),
    15375: (V((0.5596,0.320356)), V((0.5517,0.318712)), V((0.5550,0.306344)), V((0.5634,0.307746)), ),
    15376: (V((0.5517,0.318712)), V((0.5596,0.320356)), V((0.5562,0.331868)), V((0.5484,0.330081)), ),
    15377: (V((0.5097,0.340075)), V((0.5005,0.339462)), V((0.5020,0.326332)), V((0.5124,0.326234)), ),
    15378: (V((0.5020,0.326332)), V((0.5005,0.339462)), V((0.4895,0.337705)), V((0.4914,0.324739)), ),
    15379: (V((0.5445,0.345835)), V((0.5520,0.348098)), V((0.5497,0.356957)), V((0.5416,0.355212)), ),
    15380: (V((0.5517,0.456059)), V((0.5417,0.461601)), V((0.5375,0.449759)), V((0.5467,0.444798)), ),
    15381: (V((0.5624,0.473712)), V((0.5516,0.482212)), V((0.5464,0.474936)), V((0.5582,0.469117)), ),
    15382: (V((0.4622,0.878565)), V((0.4695,0.886041)), V((0.4659,0.900777)), V((0.4574,0.896529)), ),
    15383: (V((0.4770,0.893367)), V((0.4748,0.904853)), V((0.4659,0.900777)), V((0.4695,0.886041)), ),
    15384: (V((0.4770,0.893367)), V((0.4868,0.897851)), V((0.4834,0.908412)), V((0.4748,0.904853)), ),
    15385: (V((0.3456,0.424324)), V((0.3504,0.432242)), V((0.3485,0.435363)), V((0.3449,0.426706)), ),
    15386: (V((0.3550,0.421391)), V((0.3485,0.416170)), V((0.3520,0.405659)), V((0.3597,0.409301)), ),
    15387: (V((0.4183,0.415454)), V((0.4240,0.401680)), V((0.4332,0.406366)), V((0.4275,0.419689)), ),
    15388: (V((0.4079,0.409404)), V((0.4138,0.395630)), V((0.4240,0.401680)), V((0.4183,0.415454)), ),
    15389: (V((0.4046,0.317270)), V((0.3963,0.312832)), V((0.4001,0.303758)), V((0.4082,0.307284)), ),
    15390: (V((0.4466,0.460429)), V((0.4631,0.464369)), V((0.4621,0.472598)), V((0.4454,0.468498)), ),
    15391: (V((0.4647,0.455106)), V((0.4631,0.464369)), V((0.4466,0.460429)), V((0.4483,0.451150)), ),
    15392: (V((0.4150,0.291816)), V((0.4070,0.287311)), V((0.4112,0.276753)), V((0.4189,0.280657)), ),
    15393: (V((0.4189,0.280657)), V((0.4112,0.276753)), V((0.4160,0.264632)), V((0.4239,0.268549)), ),
    15394: (V((0.4575,0.361977)), V((0.4480,0.358787)), V((0.4520,0.343547)), V((0.4614,0.345669)), ),
    15395: (V((0.4950,0.786347)), V((0.4965,0.795448)), V((0.4829,0.799416)), V((0.4813,0.790280)), ),
    15396: (V((0.4908,0.773564)), V((0.4950,0.786347)), V((0.4813,0.790280)), V((0.4774,0.779616)), ),
    15397: (V((0.4138,0.395630)), V((0.4197,0.380693)), V((0.4293,0.386397)), V((0.4240,0.401680)), ),
    15398: (V((0.4240,0.401680)), V((0.4293,0.386397)), V((0.4377,0.390416)), V((0.4332,0.406366)), ),
    15399: (V((0.4486,0.393130)), V((0.4433,0.409629)), V((0.4332,0.406366)), V((0.4377,0.390416)), ),
    15400: (V((0.4977,0.418082)), V((0.4992,0.399790)), V((0.5083,0.399463)), V((0.5076,0.417825)), ),
    15401: (V((0.5165,0.398334)), V((0.5160,0.416092)), V((0.5076,0.417825)), V((0.5083,0.399463)), ),
    15402: (V((0.5245,0.397343)), V((0.5239,0.413811)), V((0.5160,0.416092)), V((0.5165,0.398334)), ),
    15403: (V((0.5329,0.396338)), V((0.5327,0.411446)), V((0.5239,0.413811)), V((0.5245,0.397343)), ),
    15404: (V((0.5411,0.395607)), V((0.5400,0.409562)), V((0.5327,0.411446)), V((0.5329,0.396338)), ),
    15405: (V((0.5400,0.409562)), V((0.5411,0.395607)), V((0.5476,0.396082)), V((0.5465,0.408811)), ),
    15406: (V((0.3699,0.370113)), V((0.3770,0.354679)), V((0.3853,0.358487)), V((0.3780,0.374201)), ),
    15407: (V((0.3780,0.374201)), V((0.3853,0.358487)), V((0.3935,0.363237)), V((0.3863,0.378260)), ),
    15408: (V((0.3863,0.378260)), V((0.3935,0.363237)), V((0.4019,0.369133)), V((0.3951,0.384081)), ),
    15409: (V((0.4105,0.375806)), V((0.4035,0.389665)), V((0.3951,0.384081)), V((0.4019,0.369133)), ),
    15410: (V((0.4197,0.380693)), V((0.4138,0.395630)), V((0.4035,0.389665)), V((0.4105,0.375806)), ),
    15411: (V((0.4138,0.395630)), V((0.4079,0.409404)), V((0.3982,0.404308)), V((0.4035,0.389665)), ),
    15412: (V((0.3951,0.384081)), V((0.4035,0.389665)), V((0.3982,0.404308)), V((0.3879,0.398466)), ),
    15413: (V((0.5400,0.409562)), V((0.5465,0.408811)), V((0.5479,0.420363)), V((0.5411,0.422244)), ),
    15414: (V((0.5327,0.411446)), V((0.5400,0.409562)), V((0.5411,0.422244)), V((0.5337,0.425190)), ),
    15415: (V((0.5327,0.411446)), V((0.5337,0.425190)), V((0.5253,0.428968)), V((0.5239,0.413811)), ),
    15416: (V((0.5239,0.413811)), V((0.5253,0.428968)), V((0.5167,0.432605)), V((0.5160,0.416092)), ),
    15417: (V((0.5160,0.416092)), V((0.5167,0.432605)), V((0.5074,0.434931)), V((0.5076,0.417825)), ),
    15418: (V((0.4432,0.781154)), V((0.4308,0.786064)), V((0.4223,0.773935)), V((0.4356,0.769774)), ),
    15419: (V((0.4308,0.786064)), V((0.4191,0.790446)), V((0.4107,0.776863)), V((0.4223,0.773935)), ),
    15420: (V((0.5160,0.205716)), V((0.5109,0.229121)), V((0.5009,0.226222)), V((0.5064,0.203960)), ),
    15421: (V((0.4433,0.409629)), V((0.4393,0.423956)), V((0.4275,0.419689)), V((0.4332,0.406366)), ),
    15422: (V((0.3623,0.685718)), V((0.3717,0.684739)), V((0.3738,0.691979)), V((0.3632,0.692679)), ),
    15423: (V((0.3673,0.662394)), V((0.3782,0.663459)), V((0.3802,0.675812)), V((0.3703,0.676901)), ),
    15424: (V((0.4191,0.790446)), V((0.4073,0.797284)), V((0.3959,0.780464)), V((0.4107,0.776863)), ),
    15425: (V((0.3998,0.806285)), V((0.3881,0.788143)), V((0.3959,0.780464)), V((0.4073,0.797284)), ),
    15426: (V((0.4834,0.908412)), V((0.4868,0.897851)), V((0.4946,0.900938)), V((0.4915,0.911395)), ),
    15427: (V((0.4984,0.913702)), V((0.4915,0.911395)), V((0.4946,0.900938)), V((0.5016,0.903557)), ),
    15428: (V((0.4686,0.838264)), V((0.4626,0.847288)), V((0.4541,0.834920)), V((0.4630,0.825178)), ),
    15429: (V((0.4474,0.843547)), V((0.4541,0.834920)), V((0.4626,0.847288)), V((0.4567,0.857984)), ),
    15430: (V((0.4982,0.889348)), V((0.4946,0.900938)), V((0.4868,0.897851)), V((0.4905,0.884912)), ),
    15431: (V((0.5021,0.878895)), V((0.4982,0.889348)), V((0.4905,0.884912)), V((0.4943,0.875081)), ),
    15432: (V((0.4943,0.875081)), V((0.4991,0.866051)), V((0.5054,0.869412)), V((0.5021,0.878895)), ),
    15433: (V((0.4766,0.695793)), V((0.4666,0.697623)), V((0.4648,0.691719)), V((0.4755,0.690264)), ),
    15434: (V((0.4107,0.776863)), V((0.3959,0.780464)), V((0.3798,0.766334)), V((0.4019,0.763821)), ),
    15435: (V((0.3959,0.780464)), V((0.3881,0.788143)), V((0.3735,0.775889)), V((0.3798,0.766334)), ),
    15436: (V((0.4962,0.245153)), V((0.5009,0.226222)), V((0.5109,0.229121)), V((0.5066,0.248453)), ),
    15437: (V((0.5066,0.248453)), V((0.5030,0.264425)), V((0.4921,0.261663)), V((0.4962,0.245153)), ),
    15438: (V((0.4344,0.713548)), V((0.4220,0.718086)), V((0.4173,0.709455)), V((0.4300,0.705230)), ),
    15439: (V((0.4056,0.712756)), V((0.4173,0.709455)), V((0.4220,0.718086)), V((0.4099,0.721935)), ),
    15440: (V((0.4099,0.721935)), V((0.3977,0.725764)), V((0.3944,0.714453)), V((0.4056,0.712756)), ),
    15441: (V((0.4157,0.826415)), V((0.4211,0.820527)), V((0.4258,0.828786)), V((0.4211,0.833525)), ),
    15442: (V((0.5082,0.669951)), V((0.5084,0.667696)), V((0.5165,0.667318)), V((0.5161,0.669119)), ),
    15443: (V((0.3546,0.720632)), V((0.3683,0.719462)), V((0.3709,0.729813)), V((0.3552,0.731569)), ),
    15444: (V((0.4271,0.841986)), V((0.4315,0.836573)), V((0.4391,0.848707)), V((0.4322,0.851525)), ),
    15445: (V((0.5162,0.662350)), V((0.5165,0.667318)), V((0.5084,0.667696)), V((0.5080,0.662818)), ),
    15446: (V((0.4887,0.276724)), V((0.4921,0.261663)), V((0.5030,0.264425)), V((0.4997,0.278675)), ),
    15447: (V((0.3517,0.685231)), V((0.3623,0.685718)), V((0.3632,0.692679)), V((0.3529,0.692872)), ),
    15448: (V((0.3919,0.681295)), V((0.4039,0.676947)), V((0.4057,0.682284)), V((0.3951,0.686706)), ),
    15449: (V((0.4989,0.658088)), V((0.4903,0.658845)), V((0.4894,0.652473)), V((0.4980,0.651949)), ),
    15450: (V((0.4506,0.740258)), V((0.4430,0.729951)), V((0.4546,0.723485)), V((0.4663,0.734292)), ),
    15451: (V((0.4039,0.676947)), V((0.4206,0.670067)), V((0.4222,0.676434)), V((0.4057,0.682284)), ),
    15452: (V((0.4816,0.659603)), V((0.4903,0.658845)), V((0.4911,0.664595)), V((0.4823,0.665527)), ),
    15453: (V((0.3574,0.663829)), V((0.3673,0.662394)), V((0.3703,0.676901)), V((0.3611,0.677844)), ),
    15454: (V((0.4570,0.701782)), V((0.4553,0.695295)), V((0.4648,0.691719)), V((0.4666,0.697623)), ),
    15455: (V((0.5075,0.657495)), V((0.4989,0.658088)), V((0.4980,0.651949)), V((0.5066,0.651410)), ),
    15456: (V((0.5075,0.657495)), V((0.5158,0.657007)), V((0.5162,0.662350)), V((0.5080,0.662818)), ),
    15457: (V((0.4735,0.672535)), V((0.4633,0.673844)), V((0.4619,0.668074)), V((0.4726,0.666670)), ),
    15458: (V((0.5000,0.668685)), V((0.4920,0.669872)), V((0.4911,0.664595)), V((0.4998,0.663646)), ),
    15459: (V((0.3825,0.683347)), V((0.3919,0.681295)), V((0.3951,0.686706)), V((0.3848,0.690013)), ),
    15460: (V((0.4903,0.658845)), V((0.4816,0.659603)), V((0.4809,0.653053)), V((0.4894,0.652473)), ),
    15461: (V((0.3849,0.728074)), V((0.3709,0.729813)), V((0.3683,0.719462)), V((0.3818,0.717852)), ),
    15462: (V((0.3977,0.725764)), V((0.3849,0.728074)), V((0.3818,0.717852)), V((0.3944,0.714453)), ),
    15463: (V((0.4133,0.701133)), V((0.4268,0.695078)), V((0.4300,0.705230)), V((0.4173,0.709455)), ),
    15464: (V((0.4600,0.707848)), V((0.4570,0.701782)), V((0.4666,0.697623)), V((0.4698,0.702832)), ),
    15465: (V((0.3717,0.684739)), V((0.3825,0.683347)), V((0.3848,0.690013)), V((0.3738,0.691979)), ),
    15466: (V((0.5147,0.650878)), V((0.5158,0.657007)), V((0.5075,0.657495)), V((0.5066,0.651410)), ),
    15467: (V((0.3782,0.663459)), V((0.3904,0.659731)), V((0.3910,0.674661)), V((0.3802,0.675812)), ),
    15468: (V((0.3489,0.664695)), V((0.3574,0.663829)), V((0.3611,0.677844)), V((0.3497,0.676129)), ),
    15469: (V((0.3904,0.659731)), V((0.4025,0.656466)), V((0.4004,0.672597)), V((0.3910,0.674661)), ),
    15470: (V((0.5066,0.651410)), V((0.5054,0.644164)), V((0.5131,0.643339)), V((0.5147,0.650878)), ),
    15471: (V((0.4949,0.302269)), V((0.4934,0.313740)), V((0.4815,0.311508)), V((0.4837,0.300648)), ),
    15472: (V((0.4025,0.656466)), V((0.4180,0.652879)), V((0.4191,0.662671)), V((0.4004,0.672597)), ),
    15473: (V((0.3479,0.554710)), V((0.3561,0.555388)), V((0.3562,0.573303)), V((0.3479,0.571530)), ),
    15474: (V((0.4057,0.682284)), V((0.4222,0.676434)), V((0.4241,0.682298)), V((0.4084,0.688032)), ),
    15475: (V((0.5061,0.842868)), V((0.4938,0.839255)), V((0.5017,0.834770)), V((0.5110,0.838626)), ),
    15476: (V((0.4793,0.322826)), V((0.4815,0.311508)), V((0.4934,0.313740)), V((0.4914,0.324739)), ),
    15477: (V((0.4774,0.335925)), V((0.4793,0.322826)), V((0.4914,0.324739)), V((0.4895,0.337705)), ),
    15478: (V((0.4698,0.702832)), V((0.4774,0.706944)), V((0.4651,0.714738)), V((0.4600,0.707848)), ),
    15479: (V((0.4799,0.707536)), V((0.4770,0.721380)), V((0.4651,0.714738)), V((0.4774,0.706944)), ),
    15480: (V((0.4726,0.666670)), V((0.4619,0.668074)), V((0.4617,0.662040)), V((0.4721,0.660627)), ),
    15481: (V((0.5120,0.872037)), V((0.5085,0.881950)), V((0.5021,0.878895)), V((0.5054,0.869412)), ),
    15482: (V((0.4998,0.663646)), V((0.4911,0.664595)), V((0.4903,0.658845)), V((0.4989,0.658088)), ),
    15483: (V((0.5080,0.662818)), V((0.4998,0.663646)), V((0.4989,0.658088)), V((0.5075,0.657495)), ),
    15484: (V((0.5054,0.644164)), V((0.5034,0.634968)), V((0.5112,0.634423)), V((0.5131,0.643339)), ),
    15485: (V((0.5034,0.634968)), V((0.5012,0.623892)), V((0.5087,0.623214)), V((0.5112,0.634423)), ),
    15486: (V((0.3951,0.686706)), V((0.4057,0.682284)), V((0.4084,0.688032)), V((0.3974,0.692209)), ),
    15487: (V((0.3923,0.707808)), V((0.4024,0.704762)), V((0.4056,0.712756)), V((0.3944,0.714453)), ),
    15488: (V((0.3792,0.710597)), V((0.3923,0.707808)), V((0.3944,0.714453)), V((0.3818,0.717852)), ),
    15489: (V((0.3665,0.712255)), V((0.3792,0.710597)), V((0.3818,0.717852)), V((0.3683,0.719462)), ),
    15490: (V((0.3543,0.712956)), V((0.3665,0.712255)), V((0.3683,0.719462)), V((0.3546,0.720632)), ),
    15491: (V((0.3910,0.674661)), V((0.4004,0.672597)), V((0.4039,0.676947)), V((0.3919,0.681295)), ),
    15492: (V((0.3848,0.690013)), V((0.3951,0.686706)), V((0.3974,0.692209)), V((0.3869,0.695253)), ),
    15493: (V((0.3738,0.691979)), V((0.3848,0.690013)), V((0.3869,0.695253)), V((0.3754,0.697790)), ),
    15494: (V((0.3632,0.692679)), V((0.3738,0.691979)), V((0.3754,0.697790)), V((0.3639,0.698405)), ),
    15495: (V((0.3529,0.692872)), V((0.3632,0.692679)), V((0.3639,0.698405)), V((0.3534,0.699317)), ),
    15496: (V((0.3703,0.676901)), V((0.3802,0.675812)), V((0.3825,0.683347)), V((0.3717,0.684739)), ),
    15497: (V((0.3497,0.676129)), V((0.3611,0.677844)), V((0.3623,0.685718)), V((0.3517,0.685231)), ),
    15498: (V((0.3802,0.675812)), V((0.3910,0.674661)), V((0.3919,0.681295)), V((0.3825,0.683347)), ),
    15499: (V((0.3611,0.677844)), V((0.3703,0.676901)), V((0.3717,0.684739)), V((0.3623,0.685718)), ),
    15500: (V((0.4024,0.704762)), V((0.4133,0.701133)), V((0.4173,0.709455)), V((0.4056,0.712756)), ),
    15501: (V((0.4567,0.857984)), V((0.4505,0.869451)), V((0.4391,0.848707)), V((0.4474,0.843547)), ),
    15502: (V((0.4322,0.851525)), V((0.4391,0.848707)), V((0.4505,0.869451)), V((0.4413,0.870973)), ),
    15503: (V((0.4997,0.852230)), V((0.4840,0.843806)), V((0.4938,0.839255)), V((0.5061,0.842868)), ),
    15504: (V((0.4808,0.865217)), V((0.4876,0.870962)), V((0.4834,0.880383)), V((0.4748,0.875137)), ),
    15505: (V((0.4695,0.886041)), V((0.4748,0.875137)), V((0.4834,0.880383)), V((0.4770,0.893367)), ),
    15506: (V((0.4380,0.901206)), V((0.4455,0.905541)), V((0.4412,0.914231)), V((0.4328,0.909032)), ),
    15507: (V((0.4541,0.908447)), V((0.4626,0.912022)), V((0.4593,0.922331)), V((0.4505,0.918838)), ),
    15508: (V((0.4714,0.915492)), V((0.4626,0.912022)), V((0.4659,0.900777)), V((0.4748,0.904853)), ),
    15509: (V((0.4714,0.915492)), V((0.4804,0.918606)), V((0.4775,0.928438)), V((0.4684,0.925606)), ),
    15510: (V((0.4804,0.918606)), V((0.4887,0.921179)), V((0.4862,0.930894)), V((0.4775,0.928438)), ),
    15511: (V((0.4959,0.923244)), V((0.4887,0.921179)), V((0.4915,0.911395)), V((0.4984,0.913702)), ),
    15512: (V((0.5244,0.667919)), V((0.5248,0.666551)), V((0.5357,0.669534)), V((0.5344,0.676173)), ),
    15513: (V((0.5243,0.661469)), V((0.5248,0.666551)), V((0.5165,0.667318)), V((0.5162,0.662350)), ),
    15514: (V((0.5243,0.661469)), V((0.5234,0.655982)), V((0.5312,0.654241)), V((0.5323,0.660542)), ),
    15515: (V((0.5222,0.649803)), V((0.5234,0.655982)), V((0.5158,0.657007)), V((0.5147,0.650878)), ),
    15516: (V((0.5222,0.649803)), V((0.5209,0.642436)), V((0.5276,0.640852)), V((0.5295,0.648105)), ),
    15517: (V((0.5209,0.642436)), V((0.5186,0.633277)), V((0.5253,0.632267)), V((0.5276,0.640852)), ),
    15518: (V((0.5186,0.633277)), V((0.5159,0.622297)), V((0.5227,0.620812)), V((0.5253,0.632267)), ),
    15519: (V((0.5142,0.610545)), V((0.5131,0.597948)), V((0.5202,0.598681)), V((0.5209,0.609637)), ),
    15520: (V((0.3562,0.573303)), V((0.3658,0.573320)), V((0.3653,0.591808)), V((0.3551,0.592022)), ),
    15521: (V((0.3479,0.571530)), V((0.3562,0.573303)), V((0.3551,0.592022)), V((0.3476,0.591689)), ),
    15522: (V((0.5144,0.588424)), V((0.5169,0.579893)), V((0.5217,0.583806)), V((0.5201,0.589820)), ),
    15523: (V((0.3916,0.542011)), V((0.4041,0.543586)), V((0.4036,0.558818)), V((0.3911,0.557858)), ),
    15524: (V((0.3789,0.540082)), V((0.3916,0.542011)), V((0.3911,0.557858)), V((0.3784,0.556932)), ),
    15525: (V((0.4041,0.543586)), V((0.4055,0.524892)), V((0.4200,0.528172)), V((0.4189,0.543722)), ),
    15526: (V((0.3926,0.523273)), V((0.4055,0.524892)), V((0.4041,0.543586)), V((0.3916,0.542011)), ),
    15527: (V((0.4883,0.522923)), V((0.4982,0.526111)), V((0.4921,0.538893)), V((0.4834,0.536479)), ),
    15528: (V((0.4921,0.538893)), V((0.4982,0.526111)), V((0.5063,0.529031)), V((0.5000,0.541762)), ),
    15529: (V((0.4937,0.509380)), V((0.5032,0.513093)), V((0.4982,0.526111)), V((0.4883,0.522923)), ),
    15530: (V((0.4982,0.526111)), V((0.5032,0.513093)), V((0.5116,0.516686)), V((0.5063,0.529031)), ),
    15531: (V((0.4241,0.491094)), V((0.4080,0.489438)), V((0.4103,0.476780)), V((0.4257,0.477814)), ),
    15532: (V((0.3973,0.475067)), V((0.4103,0.476780)), V((0.4080,0.489438)), V((0.3943,0.487800)), ),
    15533: (V((0.5585,0.496724)), V((0.5477,0.510521)), V((0.5409,0.510582)), V((0.5508,0.496080)), ),
    15534: (V((0.5681,0.490380)), V((0.5585,0.496724)), V((0.5508,0.496080)), V((0.5628,0.487651)), ),
    15535: (V((0.5681,0.490380)), V((0.5764,0.486105)), V((0.5795,0.489007)), V((0.5752,0.492322)), ),
    15536: (V((0.5848,0.481678)), V((0.5764,0.486105)), V((0.5739,0.484769)), V((0.5832,0.479151)), ),
    15537: (V((0.3414,0.428901)), V((0.3418,0.439304)), V((0.3401,0.440124)), V((0.3400,0.428711)), ),
    15538: (V((0.3418,0.439304)), V((0.3431,0.451442)), V((0.3401,0.451650)), V((0.3401,0.440124)), ),
    15539: (V((0.3445,0.463860)), V((0.3431,0.451442)), V((0.3453,0.450854)), V((0.3486,0.463180)), ),
    15540: (V((0.3457,0.471182)), V((0.3445,0.463860)), V((0.3486,0.463180)), V((0.3513,0.471943)), ),
    15541: (V((0.3467,0.477758)), V((0.3457,0.471182)), V((0.3513,0.471943)), V((0.3533,0.478798)), ),
    15542: (V((0.5134,0.532240)), V((0.5063,0.529031)), V((0.5116,0.516686)), V((0.5199,0.519953)), ),
    15543: (V((0.5203,0.535519)), V((0.5134,0.532240)), V((0.5199,0.519953)), V((0.5265,0.522120)), ),
    15544: (V((0.5074,0.545396)), V((0.5000,0.541762)), V((0.5063,0.529031)), V((0.5134,0.532240)), ),
    15545: (V((0.5141,0.549053)), V((0.5074,0.545396)), V((0.5134,0.532240)), V((0.5203,0.535519)), ),
    15546: (V((0.3793,0.521619)), V((0.3926,0.523273)), V((0.3916,0.542011)), V((0.3789,0.540082)), ),
    15547: (V((0.3663,0.519830)), V((0.3793,0.521619)), V((0.3789,0.540082)), V((0.3668,0.538398)), ),
    15548: (V((0.3668,0.538398)), V((0.3789,0.540082)), V((0.3784,0.556932)), V((0.3662,0.556285)), ),
    15549: (V((0.3569,0.536358)), V((0.3668,0.538398)), V((0.3662,0.556285)), V((0.3561,0.555388)), ),
    15550: (V((0.4690,0.589632)), V((0.4597,0.587784)), V((0.4601,0.572584)), V((0.4703,0.574101)), ),
    15551: (V((0.4703,0.574101)), V((0.4792,0.576213)), V((0.4780,0.590381)), V((0.4690,0.589632)), ),
    15552: (V((0.4792,0.576213)), V((0.4876,0.578575)), V((0.4861,0.592339)), V((0.4780,0.590381)), ),
    15553: (V((0.4876,0.578575)), V((0.4940,0.581072)), V((0.4940,0.595526)), V((0.4861,0.592339)), ),
    15554: (V((0.4940,0.581072)), V((0.5017,0.583885)), V((0.5001,0.596749)), V((0.4940,0.595526)), ),
    15555: (V((0.5003,0.610580)), V((0.5001,0.596749)), V((0.5076,0.597376)), V((0.5075,0.610548)), ),
    15556: (V((0.5017,0.583885)), V((0.5086,0.586836)), V((0.5076,0.597376)), V((0.5001,0.596749)), ),
    15557: (V((0.5131,0.597948)), V((0.5076,0.597376)), V((0.5086,0.586836)), V((0.5144,0.588424)), ),
    15558: (V((0.3483,0.534624)), V((0.3479,0.554710)), V((0.3401,0.554120)), V((0.3401,0.533877)), ),
    15559: (V((0.3570,0.516146)), V((0.3663,0.519830)), V((0.3668,0.538398)), V((0.3569,0.536358)), ),
    15560: (V((0.3486,0.513331)), V((0.3570,0.516146)), V((0.3569,0.536358)), V((0.3483,0.534624)), ),
    15561: (V((0.5141,0.549053)), V((0.5203,0.535519)), V((0.5270,0.538650)), V((0.5207,0.552953)), ),
    15562: (V((0.5279,0.556694)), V((0.5207,0.552953)), V((0.5270,0.538650)), V((0.5348,0.543037)), ),
    15563: (V((0.5203,0.535519)), V((0.5265,0.522120)), V((0.5336,0.524661)), V((0.5270,0.538650)), ),
    15564: (V((0.5399,0.526257)), V((0.5455,0.528912)), V((0.5375,0.544144)), V((0.5348,0.543037)), ),
    15565: (V((0.3826,0.471426)), V((0.3973,0.475067)), V((0.3943,0.487800)), V((0.3801,0.484800)), ),
    15566: (V((0.3653,0.465748)), V((0.3826,0.471426)), V((0.3801,0.484800)), V((0.3653,0.480300)), ),
    15567: (V((0.5508,0.496080)), V((0.5409,0.510582)), V((0.5330,0.508423)), V((0.5440,0.493195)), ),
    15568: (V((0.5628,0.487651)), V((0.5508,0.496080)), V((0.5440,0.493195)), V((0.5516,0.482212)), ),
    15569: (V((0.5739,0.484769)), V((0.5628,0.487651)), V((0.5516,0.482212)), V((0.5624,0.473712)), ),
    15570: (V((0.5832,0.479151)), V((0.5739,0.484769)), V((0.5624,0.473712)), V((0.5737,0.469417)), ),
    15571: (V((0.3449,0.426706)), V((0.3485,0.435363)), V((0.3450,0.439490)), V((0.3424,0.428975)), ),
    15572: (V((0.3485,0.435363)), V((0.3517,0.443458)), V((0.3453,0.450854)), V((0.3450,0.439490)), ),
    15573: (V((0.3517,0.443458)), V((0.3582,0.455587)), V((0.3486,0.463180)), V((0.3453,0.450854)), ),
    15574: (V((0.3513,0.471943)), V((0.3486,0.463180)), V((0.3582,0.455587)), V((0.3653,0.465748)), ),
    15575: (V((0.3513,0.471943)), V((0.3653,0.465748)), V((0.3653,0.480300)), V((0.3533,0.478798)), ),
    15576: (V((0.3798,0.766334)), V((0.3551,0.765121)), V((0.3550,0.752023)), V((0.3771,0.750769)), ),
    15577: (V((0.3401,0.741976)), V((0.3401,0.732653)), V((0.3552,0.731569)), V((0.3550,0.741545)), ),
    15578: (V((0.3771,0.750769)), V((0.3550,0.752023)), V((0.3550,0.741545)), V((0.3736,0.740151)), ),
    15579: (V((0.3405,0.704581)), V((0.3538,0.704864)), V((0.3543,0.712956)), V((0.3401,0.712648)), ),
    15580: (V((0.3574,0.663829)), V((0.3489,0.664695)), V((0.3482,0.649261)), V((0.3566,0.648789)), ),
    15581: (V((0.3798,0.766334)), V((0.3735,0.775889)), V((0.3554,0.776830)), V((0.3551,0.765121)), ),
    15582: (V((0.3566,0.648789)), V((0.3482,0.649261)), V((0.3478,0.631158)), V((0.3559,0.631068)), ),
    15583: (V((0.5336,0.524661)), V((0.5409,0.510582)), V((0.5477,0.510521)), V((0.5399,0.526257)), ),
    15584: (V((0.3562,0.497079)), V((0.3570,0.516146)), V((0.3486,0.513331)), V((0.3481,0.494192)), ),
    15585: (V((0.3533,0.478798)), V((0.3562,0.497079)), V((0.3481,0.494192)), V((0.3467,0.477758)), ),
    15586: (V((0.5157,0.565114)), V((0.5207,0.552953)), V((0.5279,0.556694)), V((0.5221,0.569984)), ),
    15587: (V((0.5107,0.576772)), V((0.5157,0.565114)), V((0.5221,0.569984)), V((0.5169,0.579893)), ),
    15588: (V((0.3388,0.592243)), V((0.3476,0.591689)), V((0.3478,0.611486)), V((0.3401,0.611631)), ),
    15589: (V((0.3401,0.720732)), V((0.3546,0.720632)), V((0.3552,0.731569)), V((0.3401,0.732653)), ),
    15590: (V((0.3401,0.684766)), V((0.3517,0.685231)), V((0.3529,0.692872)), V((0.3401,0.693350)), ),
    15591: (V((0.3401,0.665634)), V((0.3489,0.664695)), V((0.3497,0.676129)), V((0.3401,0.676685)), ),
    15592: (V((0.3401,0.554120)), V((0.3479,0.554710)), V((0.3479,0.571530)), V((0.3401,0.576364)), ),
    15593: (V((0.3401,0.712648)), V((0.3543,0.712956)), V((0.3546,0.720632)), V((0.3401,0.720732)), ),
    15594: (V((0.3401,0.693350)), V((0.3529,0.692872)), V((0.3534,0.699317)), V((0.3401,0.699559)), ),
    15595: (V((0.3401,0.676685)), V((0.3497,0.676129)), V((0.3517,0.685231)), V((0.3401,0.684766)), ),
    15596: (V((0.4419,0.889307)), V((0.4491,0.892759)), V((0.4455,0.905541)), V((0.4380,0.901206)), ),
    15597: (V((0.4574,0.896529)), V((0.4659,0.900777)), V((0.4626,0.912022)), V((0.4541,0.908447)), ),
    15598: (V((0.4684,0.925606)), V((0.4593,0.922331)), V((0.4626,0.912022)), V((0.4714,0.915492)), ),
    15599: (V((0.4748,0.904853)), V((0.4834,0.908412)), V((0.4804,0.918606)), V((0.4714,0.915492)), ),
    15600: (V((0.4834,0.908412)), V((0.4915,0.911395)), V((0.4887,0.921179)), V((0.4804,0.918606)), ),
    15601: (V((0.4937,0.932554)), V((0.4862,0.930894)), V((0.4887,0.921179)), V((0.4959,0.923244)), ),
    15602: (V((0.5161,0.669119)), V((0.5165,0.667318)), V((0.5248,0.666551)), V((0.5244,0.667919)), ),
    15603: (V((0.5323,0.660542)), V((0.5357,0.669534)), V((0.5248,0.666551)), V((0.5243,0.661469)), ),
    15604: (V((0.5162,0.662350)), V((0.5158,0.657007)), V((0.5234,0.655982)), V((0.5243,0.661469)), ),
    15605: (V((0.5295,0.648105)), V((0.5312,0.654241)), V((0.5234,0.655982)), V((0.5222,0.649803)), ),
    15606: (V((0.5147,0.650878)), V((0.5131,0.643339)), V((0.5209,0.642436)), V((0.5222,0.649803)), ),
    15607: (V((0.5131,0.643339)), V((0.5112,0.634423)), V((0.5186,0.633277)), V((0.5209,0.642436)), ),
    15608: (V((0.5112,0.634423)), V((0.5087,0.623214)), V((0.5159,0.622297)), V((0.5186,0.633277)), ),
    15609: (V((0.5075,0.610548)), V((0.5076,0.597376)), V((0.5131,0.597948)), V((0.5142,0.610545)), ),
    15610: (V((0.3401,0.576364)), V((0.3479,0.571530)), V((0.3476,0.591689)), V((0.3388,0.592243)), ),
    15611: (V((0.5086,0.586836)), V((0.5107,0.576772)), V((0.5169,0.579893)), V((0.5144,0.588424)), ),
    15612: (V((0.5632,0.498996)), V((0.5585,0.509150)), V((0.5477,0.510521)), V((0.5585,0.496724)), ),
    15613: (V((0.5752,0.492322)), V((0.5632,0.498996)), V((0.5585,0.496724)), V((0.5681,0.490380)), ),
    15614: (V((0.5628,0.487651)), V((0.5739,0.484769)), V((0.5764,0.486105)), V((0.5681,0.490380)), ),
    15615: (V((0.5853,0.484742)), V((0.5795,0.489007)), V((0.5764,0.486105)), V((0.5848,0.481678)), ),
    15616: (V((0.3424,0.428975)), V((0.3450,0.439490)), V((0.3418,0.439304)), V((0.3414,0.428901)), ),
    15617: (V((0.3450,0.439490)), V((0.3453,0.450854)), V((0.3431,0.451442)), V((0.3418,0.439304)), ),
    15618: (V((0.3401,0.464817)), V((0.3401,0.451650)), V((0.3431,0.451442)), V((0.3445,0.463860)), ),
    15619: (V((0.3401,0.470848)), V((0.3401,0.464817)), V((0.3445,0.463860)), V((0.3457,0.471182)), ),
    15620: (V((0.3399,0.476496)), V((0.3401,0.470848)), V((0.3457,0.471182)), V((0.3467,0.477758)), ),
    15621: (V((0.5202,0.598681)), V((0.5131,0.597948)), V((0.5144,0.588424)), V((0.5201,0.589820)), ),
    15622: (V((0.3569,0.536358)), V((0.3561,0.555388)), V((0.3479,0.554710)), V((0.3483,0.534624)), ),
    15623: (V((0.3401,0.511954)), V((0.3486,0.513331)), V((0.3483,0.534624)), V((0.3401,0.533877)), ),
    15624: (V((0.5317,0.558907)), V((0.5279,0.556694)), V((0.5348,0.543037)), V((0.5375,0.544144)), ),
    15625: (V((0.5336,0.524661)), V((0.5399,0.526257)), V((0.5348,0.543037)), V((0.5270,0.538650)), ),
    15626: (V((0.4430,0.729951)), V((0.4386,0.722135)), V((0.4498,0.715388)), V((0.4546,0.723485)), ),
    15627: (V((0.4386,0.722135)), V((0.4344,0.713548)), V((0.4466,0.708121)), V((0.4498,0.715388)), ),
    15628: (V((0.4344,0.713548)), V((0.4300,0.705230)), V((0.4444,0.699745)), V((0.4466,0.708121)), ),
    15629: (V((0.4414,0.691602)), V((0.4444,0.699745)), V((0.4300,0.705230)), V((0.4268,0.695078)), ),
    15630: (V((0.4255,0.689342)), V((0.4241,0.682298)), V((0.4382,0.677980)), V((0.4399,0.684493)), ),
    15631: (V((0.4367,0.671761)), V((0.4382,0.677980)), V((0.4241,0.682298)), V((0.4222,0.676434)), ),
    15632: (V((0.4222,0.676434)), V((0.4206,0.670067)), V((0.4355,0.665368)), V((0.4367,0.671761)), ),
    15633: (V((0.4343,0.658048)), V((0.4355,0.665368)), V((0.4206,0.670067)), V((0.4191,0.662671)), ),
    15634: (V((0.4191,0.662671)), V((0.4180,0.652879)), V((0.4330,0.648796)), V((0.4343,0.658048)), ),
    15635: (V((0.4180,0.652879)), V((0.4173,0.639495)), V((0.4310,0.637305)), V((0.4330,0.648796)), ),
    15636: (V((0.4173,0.639495)), V((0.4174,0.626428)), V((0.4296,0.627759)), V((0.4310,0.637305)), ),
    15637: (V((0.4159,0.606803)), V((0.4156,0.587550)), V((0.4311,0.585421)), V((0.4308,0.604340)), ),
    15638: (V((0.4156,0.587550)), V((0.4156,0.573452)), V((0.4317,0.571890)), V((0.4311,0.585421)), ),
    15639: (V((0.4156,0.573452)), V((0.4154,0.560024)), V((0.4327,0.559427)), V((0.4317,0.571890)), ),
    15640: (V((0.4154,0.560024)), V((0.4189,0.543722)), V((0.4354,0.545085)), V((0.4327,0.559427)), ),
    15641: (V((0.4379,0.530616)), V((0.4354,0.545085)), V((0.4189,0.543722)), V((0.4200,0.528172)), ),
    15642: (V((0.4200,0.528172)), V((0.4213,0.508941)), V((0.4413,0.512016)), V((0.4379,0.530616)), ),
    15643: (V((0.4213,0.508941)), V((0.4241,0.491094)), V((0.4424,0.494855)), V((0.4413,0.512016)), ),
    15644: (V((0.4241,0.491094)), V((0.4257,0.477814)), V((0.4441,0.479703)), V((0.4424,0.494855)), ),
    15645: (V((0.4257,0.477814)), V((0.4279,0.465715)), V((0.4454,0.468498)), V((0.4441,0.479703)), ),
    15646: (V((0.4309,0.456519)), V((0.4331,0.447734)), V((0.4483,0.451150)), V((0.4466,0.460429)), ),
    15647: (V((0.4393,0.423956)), V((0.4433,0.409629)), V((0.4581,0.411965)), V((0.4540,0.427130)), ),
    15648: (V((0.4433,0.409629)), V((0.4486,0.393130)), V((0.4629,0.395266)), V((0.4581,0.411965)), ),
    15649: (V((0.4614,0.345669)), V((0.4643,0.332929)), V((0.4774,0.335925)), V((0.4742,0.347998)), ),
    15650: (V((0.4643,0.332929)), V((0.4684,0.320679)), V((0.4793,0.322826)), V((0.4774,0.335925)), ),
    15651: (V((0.4643,0.332929)), V((0.4547,0.329816)), V((0.4575,0.317951)), V((0.4684,0.320679)), ),
    15652: (V((0.4684,0.320679)), V((0.4712,0.309279)), V((0.4815,0.311508)), V((0.4793,0.322826)), ),
    15653: (V((0.4712,0.309279)), V((0.4733,0.298412)), V((0.4837,0.300648)), V((0.4815,0.311508)), ),
    15654: (V((0.4787,0.273083)), V((0.4822,0.257654)), V((0.4921,0.261663)), V((0.4887,0.276724)), ),
    15655: (V((0.4997,0.278675)), V((0.5030,0.264425)), V((0.5134,0.265702)), V((0.5102,0.279830)), ),
    15656: (V((0.4934,0.313740)), V((0.4949,0.302269)), V((0.5057,0.304196)), V((0.5044,0.315343)), ),
    15657: (V((0.4914,0.324739)), V((0.4934,0.313740)), V((0.5044,0.315343)), V((0.5020,0.326332)), ),
    15658: (V((0.4509,0.315833)), V((0.4575,0.317951)), V((0.4547,0.329816)), V((0.4476,0.327934)), ),
    15659: (V((0.4440,0.312762)), V((0.4509,0.315833)), V((0.4476,0.327934)), V((0.4399,0.325281)), ),
    15660: (V((0.5005,0.339462)), V((0.4987,0.352268)), V((0.4873,0.350550)), V((0.4895,0.337705)), ),
    15661: (V((0.4367,0.337250)), V((0.4440,0.340845)), V((0.4399,0.355715)), V((0.4300,0.350603)), ),
    15662: (V((0.4733,0.413771)), V((0.4774,0.397671)), V((0.4902,0.399316)), V((0.4879,0.416903)), ),
    15663: (V((0.4698,0.429421)), V((0.4733,0.413771)), V((0.4879,0.416903)), V((0.4859,0.433175)), ),
    15664: (V((0.4631,0.464369)), V((0.4647,0.455106)), V((0.4821,0.458239)), V((0.4816,0.467705)), ),
    15665: (V((0.4616,0.483675)), V((0.4621,0.472598)), V((0.4818,0.477934)), V((0.4814,0.489965)), ),
    15666: (V((0.4597,0.499035)), V((0.4616,0.483675)), V((0.4814,0.489965)), V((0.4781,0.504084)), ),
    15667: (V((0.4587,0.515721)), V((0.4597,0.499035)), V((0.4781,0.504084)), V((0.4739,0.518877)), ),
    15668: (V((0.4551,0.531682)), V((0.4587,0.515721)), V((0.4739,0.518877)), V((0.4694,0.534204)), ),
    15669: (V((0.4694,0.534204)), V((0.4654,0.547516)), V((0.4515,0.545769)), V((0.4551,0.531682)), ),
    15670: (V((0.4485,0.559507)), V((0.4515,0.545769)), V((0.4654,0.547516)), V((0.4614,0.560057)), ),
    15671: (V((0.4468,0.573217)), V((0.4485,0.559507)), V((0.4614,0.560057)), V((0.4601,0.572584)), ),
    15672: (V((0.4463,0.587295)), V((0.4468,0.573217)), V((0.4601,0.572584)), V((0.4597,0.587784)), ),
    15673: (V((0.4473,0.604804)), V((0.4463,0.587295)), V((0.4597,0.587784)), V((0.4598,0.602447)), ),
    15674: (V((0.4595,0.622152)), V((0.4603,0.634923)), V((0.4475,0.635794)), V((0.4472,0.625231)), ),
    15675: (V((0.4603,0.634923)), V((0.4600,0.645684)), V((0.4467,0.646897)), V((0.4475,0.635794)), ),
    15676: (V((0.4472,0.655462)), V((0.4467,0.646897)), V((0.4600,0.645684)), V((0.4607,0.654861)), ),
    15677: (V((0.4607,0.654861)), V((0.4617,0.662040)), V((0.4488,0.662907)), V((0.4472,0.655462)), ),
    15678: (V((0.4499,0.669353)), V((0.4488,0.662907)), V((0.4617,0.662040)), V((0.4619,0.668074)), ),
    15679: (V((0.4619,0.668074)), V((0.4633,0.673844)), V((0.4514,0.675531)), V((0.4499,0.669353)), ),
    15680: (V((0.4530,0.681971)), V((0.4514,0.675531)), V((0.4633,0.673844)), V((0.4632,0.679669)), ),
    15681: (V((0.4637,0.685531)), V((0.4648,0.691719)), V((0.4553,0.695295)), V((0.4542,0.688638)), ),
    15682: (V((0.5806,0.764813)), V((0.5848,0.770725)), V((0.5745,0.776070)), V((0.5712,0.769456)), ),
    15683: (V((0.5761,0.757899)), V((0.5806,0.764813)), V((0.5712,0.769456)), V((0.5678,0.761575)), ),
    15684: (V((0.5907,0.783856)), V((0.5985,0.779055)), V((0.6011,0.788378)), V((0.5925,0.793637)), ),
    15685: (V((0.5985,0.779055)), V((0.6078,0.774382)), V((0.6106,0.783130)), V((0.6011,0.788378)), ),
    15686: (V((0.6078,0.774382)), V((0.6200,0.767843)), V((0.6231,0.777173)), V((0.6106,0.783130)), ),
    15687: (V((0.6200,0.767843)), V((0.6337,0.759905)), V((0.6369,0.768940)), V((0.6231,0.777173)), ),
    15688: (V((0.6337,0.759905)), V((0.6455,0.749063)), V((0.6509,0.757553)), V((0.6369,0.768940)), ),
    15689: (V((0.6455,0.749063)), V((0.6563,0.739179)), V((0.6621,0.746252)), V((0.6509,0.757553)), ),
    15690: (V((0.6563,0.739179)), V((0.6711,0.728292)), V((0.6755,0.735553)), V((0.6621,0.746252)), ),
    15691: (V((0.8097,0.901075)), V((0.8264,0.906152)), V((0.8230,0.910156)), V((0.8058,0.909964)), ),
    15692: (V((0.5690,0.747959)), V((0.5761,0.757899)), V((0.5678,0.761575)), V((0.5624,0.750234)), ),
    15693: (V((0.5616,0.740742)), V((0.5687,0.739307)), V((0.5690,0.747959)), V((0.5624,0.750234)), ),
    15694: (V((0.6022,0.794123)), V((0.5932,0.799501)), V((0.5925,0.793637)), V((0.6011,0.788378)), ),
    15695: (V((0.6011,0.788378)), V((0.6106,0.783130)), V((0.6123,0.789824)), V((0.6022,0.794123)), ),
    15696: (V((0.6258,0.784135)), V((0.6123,0.789824)), V((0.6106,0.783130)), V((0.6231,0.777173)), ),
    15697: (V((0.6404,0.775214)), V((0.6258,0.784135)), V((0.6231,0.777173)), V((0.6369,0.768940)), ),
    15698: (V((0.6542,0.763378)), V((0.6404,0.775214)), V((0.6369,0.768940)), V((0.6509,0.757553)), ),
    15699: (V((0.6638,0.753259)), V((0.6542,0.763378)), V((0.6509,0.757553)), V((0.6621,0.746252)), ),
    15700: (V((0.6779,0.740740)), V((0.6638,0.753259)), V((0.6621,0.746252)), V((0.6755,0.735553)), ),
    15701: (V((0.8058,0.909964)), V((0.8230,0.910156)), V((0.8186,0.916845)), V((0.8092,0.916113)), ),
    15702: (V((0.5068,0.756968)), V((0.5205,0.753324)), V((0.5250,0.762285)), V((0.5119,0.766248)), ),
    15703: (V((0.5206,0.825436)), V((0.5114,0.830459)), V((0.5076,0.820025)), V((0.5191,0.815442)), ),
    15704: (V((0.5114,0.830459)), V((0.5017,0.834770)), V((0.4976,0.824662)), V((0.5076,0.820025)), ),
    15705: (V((0.5017,0.834770)), V((0.4938,0.839255)), V((0.4882,0.828867)), V((0.4976,0.824662)), ),
    15706: (V((0.4938,0.839255)), V((0.4840,0.843806)), V((0.4775,0.832776)), V((0.4882,0.828867)), ),
    15707: (V((0.4840,0.843806)), V((0.4767,0.849405)), V((0.4686,0.838264)), V((0.4775,0.832776)), ),
    15708: (V((0.4767,0.849405)), V((0.4709,0.857857)), V((0.4626,0.847288)), V((0.4686,0.838264)), ),
    15709: (V((0.4567,0.857984)), V((0.4626,0.847288)), V((0.4709,0.857857)), V((0.4658,0.868325)), ),
    15710: (V((0.4505,0.869451)), V((0.4567,0.857984)), V((0.4658,0.868325)), V((0.4622,0.878565)), ),
    15711: (V((0.4622,0.878565)), V((0.4574,0.896529)), V((0.4491,0.892759)), V((0.4505,0.869451)), ),
    15712: (V((0.4455,0.905541)), V((0.4491,0.892759)), V((0.4574,0.896529)), V((0.4541,0.908447)), ),
    15713: (V((0.4541,0.908447)), V((0.4505,0.918838)), V((0.4412,0.914231)), V((0.4455,0.905541)), ),
    15714: (V((0.4822,0.257654)), V((0.4867,0.241326)), V((0.4962,0.245153)), V((0.4921,0.261663)), ),
    15715: (V((0.4867,0.241326)), V((0.4914,0.222790)), V((0.5009,0.226222)), V((0.4962,0.245153)), ),
    15716: (V((0.5064,0.203960)), V((0.5009,0.226222)), V((0.4914,0.222790)), V((0.4961,0.202110)), ),
    15717: (V((0.4145,0.809033)), V((0.4085,0.816477)), V((0.3998,0.806285)), V((0.4073,0.797284)), ),
    15718: (V((0.4252,0.802328)), V((0.4145,0.809033)), V((0.4073,0.797284)), V((0.4191,0.790446)), ),
    15719: (V((0.4357,0.796597)), V((0.4252,0.802328)), V((0.4191,0.790446)), V((0.4308,0.786064)), ),
    15720: (V((0.4486,0.790814)), V((0.4357,0.796597)), V((0.4308,0.786064)), V((0.4432,0.781154)), ),
    15721: (V((0.4432,0.781154)), V((0.4568,0.775158)), V((0.4629,0.785374)), V((0.4486,0.790814)), ),
    15722: (V((0.4774,0.779616)), V((0.4629,0.785374)), V((0.4568,0.775158)), V((0.4717,0.769247)), ),
    15723: (V((0.4908,0.773564)), V((0.4774,0.779616)), V((0.4717,0.769247)), V((0.4840,0.764792)), ),
    15724: (V((0.5004,0.770539)), V((0.4908,0.773564)), V((0.4840,0.764792)), V((0.4947,0.761746)), ),
    15725: (V((0.4947,0.761746)), V((0.5068,0.756968)), V((0.5119,0.766248)), V((0.5004,0.770539)), ),
    15726: (V((0.5080,0.727866)), V((0.5143,0.740974)), V((0.4990,0.744308)), V((0.4940,0.729832)), ),
    15727: (V((0.5068,0.756968)), V((0.4990,0.744308)), V((0.5143,0.740974)), V((0.5205,0.753324)), ),
    15728: (V((0.5205,0.753324)), V((0.5325,0.748439)), V((0.5364,0.757769)), V((0.5250,0.762285)), ),
    15729: (V((0.5325,0.748439)), V((0.5432,0.744831)), V((0.5466,0.755074)), V((0.5364,0.757769)), ),
    15730: (V((0.5432,0.744831)), V((0.5539,0.742789)), V((0.5552,0.752454)), V((0.5466,0.755074)), ),
    15731: (V((0.5616,0.740742)), V((0.5561,0.728468)), V((0.5630,0.727853)), V((0.5687,0.739307)), ),
    15732: (V((0.5612,0.712607)), V((0.5630,0.727853)), V((0.5561,0.728468)), V((0.5527,0.714009)), ),
    15733: (V((0.5780,0.745085)), V((0.5690,0.747959)), V((0.5687,0.739307)), V((0.5747,0.737744)), ),
    15734: (V((0.5747,0.737744)), V((0.5842,0.735371)), V((0.5898,0.742483)), V((0.5780,0.745085)), ),
    15735: (V((0.5842,0.735371)), V((0.5981,0.730995)), V((0.6038,0.737792)), V((0.5898,0.742483)), ),
    15736: (V((0.5981,0.730995)), V((0.6133,0.724272)), V((0.6181,0.730383)), V((0.6038,0.737792)), ),
    15737: (V((0.6321,0.722640)), V((0.6181,0.730383)), V((0.6133,0.724272)), V((0.6280,0.717422)), ),
    15738: (V((0.6441,0.715752)), V((0.6321,0.722640)), V((0.6280,0.717422)), V((0.6408,0.711188)), ),
    15739: (V((0.6590,0.707307)), V((0.6441,0.715752)), V((0.6408,0.711188)), V((0.6562,0.701636)), ),
    15740: (V((0.8123,0.846631)), V((0.8282,0.844930)), V((0.8285,0.856638)), V((0.8128,0.858357)), ),
    15741: (V((0.3868,0.458631)), V((0.3737,0.454110)), V((0.3806,0.441249)), V((0.3920,0.445994)), ),
    15742: (V((0.3920,0.445994)), V((0.4048,0.450803)), V((0.4012,0.461968)), V((0.3868,0.458631)), ),
    15743: (V((0.4048,0.450803)), V((0.4168,0.453592)), V((0.4154,0.464467)), V((0.4012,0.461968)), ),
    15744: (V((0.4279,0.465715)), V((0.4154,0.464467)), V((0.4168,0.453592)), V((0.4309,0.456519)), ),
    15745: (V((0.4454,0.468498)), V((0.4279,0.465715)), V((0.4309,0.456519)), V((0.4466,0.460429)), ),
    15746: (V((0.4895,0.337705)), V((0.4873,0.350550)), V((0.4742,0.347998)), V((0.4774,0.335925)), ),
    15747: (V((0.4742,0.347998)), V((0.4873,0.350550)), V((0.4848,0.365512)), V((0.4709,0.363460)), ),
    15748: (V((0.4818,0.477934)), V((0.4621,0.472598)), V((0.4631,0.464369)), V((0.4816,0.467705)), ),
    15749: (V((0.4968,0.482240)), V((0.4818,0.477934)), V((0.4816,0.467705)), V((0.4951,0.470148)), ),
    15750: (V((0.4951,0.470148)), V((0.5073,0.471446)), V((0.5096,0.485725)), V((0.4968,0.482240)), ),
    15751: (V((0.5215,0.489504)), V((0.5096,0.485725)), V((0.5073,0.471446)), V((0.5182,0.470645)), ),
    15752: (V((0.5361,0.488330)), V((0.5215,0.489504)), V((0.5182,0.470645)), V((0.5305,0.467767)), ),
    15753: (V((0.5464,0.474936)), V((0.5361,0.488330)), V((0.5305,0.467767)), V((0.5417,0.461601)), ),
    15754: (V((0.5582,0.469117)), V((0.5464,0.474936)), V((0.5417,0.461601)), V((0.5517,0.456059)), ),
    15755: (V((0.5517,0.456059)), V((0.5610,0.450236)), V((0.5696,0.463734)), V((0.5582,0.469117)), ),
    15756: (V((0.3485,0.416170)), V((0.3550,0.421391)), V((0.3504,0.432242)), V((0.3456,0.424324)), ),
    15757: (V((0.3550,0.421391)), V((0.3614,0.427784)), V((0.3546,0.439591)), V((0.3504,0.432242)), ),
    15758: (V((0.3614,0.427784)), V((0.3706,0.434130)), V((0.3628,0.447298)), V((0.3546,0.439591)), ),
    15759: (V((0.3706,0.434130)), V((0.3806,0.441249)), V((0.3737,0.454110)), V((0.3628,0.447298)), ),
    15760: (V((0.4440,0.340845)), V((0.4520,0.343547)), V((0.4480,0.358787)), V((0.4399,0.355715)), ),
    15761: (V((0.4709,0.363460)), V((0.4575,0.361977)), V((0.4614,0.345669)), V((0.4742,0.347998)), ),
    15762: (V((0.5044,0.367100)), V((0.4959,0.366554)), V((0.4987,0.352268)), V((0.5073,0.352893)), ),
    15763: (V((0.5210,0.367586)), V((0.5131,0.367355)), V((0.5162,0.353223)), V((0.5244,0.354187)), ),
    15764: (V((0.5377,0.367902)), V((0.5291,0.367290)), V((0.5326,0.354591)), V((0.5416,0.355212)), ),
    15765: (V((0.5497,0.356957)), V((0.5568,0.359162)), V((0.5537,0.371451)), V((0.5460,0.369688)), ),
    15766: (V((0.4046,0.317270)), V((0.4121,0.321606)), V((0.4068,0.335537)), V((0.3997,0.331019)), ),
    15767: (V((0.4199,0.327186)), V((0.4291,0.333220)), V((0.4226,0.347023)), V((0.4136,0.340806)), ),
    15768: (V((0.4300,0.350603)), V((0.4226,0.347023)), V((0.4291,0.333220)), V((0.4367,0.337250)), ),
    15769: (V((0.4121,0.321606)), V((0.4199,0.327186)), V((0.4136,0.340806)), V((0.4068,0.335537)), ),
    15770: (V((0.3963,0.312832)), V((0.4046,0.317270)), V((0.3997,0.331019)), V((0.3905,0.326481)), ),
    15771: (V((0.5460,0.369688)), V((0.5377,0.367902)), V((0.5416,0.355212)), V((0.5497,0.356957)), ),
    15772: (V((0.5291,0.367290)), V((0.5210,0.367586)), V((0.5244,0.354187)), V((0.5326,0.354591)), ),
    15773: (V((0.5073,0.352893)), V((0.5162,0.353223)), V((0.5131,0.367355)), V((0.5044,0.367100)), ),
    15774: (V((0.4873,0.350550)), V((0.4987,0.352268)), V((0.4959,0.366554)), V((0.4848,0.365512)), ),
    15775: (V((0.5030,0.264425)), V((0.5066,0.248453)), V((0.5168,0.250367)), V((0.5134,0.265702)), ),
    15776: (V((0.5066,0.248453)), V((0.5109,0.229121)), V((0.5206,0.231831)), V((0.5168,0.250367)), ),
    15777: (V((0.5255,0.208059)), V((0.5206,0.231831)), V((0.5109,0.229121)), V((0.5160,0.205716)), ),
    15778: (V((0.3974,0.692209)), V((0.4084,0.688032)), V((0.4109,0.694143)), V((0.3997,0.697979)), ),
    15779: (V((0.3534,0.699317)), V((0.3639,0.698405)), V((0.3648,0.704920)), V((0.3538,0.704864)), ),
    15780: (V((0.3639,0.698405)), V((0.3754,0.697790)), V((0.3774,0.704145)), V((0.3648,0.704920)), ),
    15781: (V((0.3754,0.697790)), V((0.3869,0.695253)), V((0.3890,0.701238)), V((0.3774,0.704145)), ),
    15782: (V((0.3869,0.695253)), V((0.3974,0.692209)), V((0.3997,0.697979)), V((0.3890,0.701238)), ),
    15783: (V((0.4830,0.671129)), V((0.4920,0.669872)), V((0.4923,0.673057)), V((0.4830,0.674447)), ),
    15784: (V((0.4581,0.411965)), V((0.4629,0.395266)), V((0.4774,0.397671)), V((0.4733,0.413771)), ),
    15785: (V((0.5016,0.903557)), V((0.5051,0.892721)), V((0.5145,0.896167)), V((0.5112,0.907247)), ),
    15786: (V((0.5051,0.892721)), V((0.5085,0.881950)), V((0.5180,0.885587)), V((0.5145,0.896167)), ),
    15787: (V((0.4750,0.684138)), V((0.4637,0.685531)), V((0.4632,0.679669)), V((0.4757,0.677993)), ),
    15788: (V((0.4540,0.427130)), V((0.4581,0.411965)), V((0.4733,0.413771)), V((0.4698,0.429421)), ),
    15789: (V((0.4084,0.688032)), V((0.4241,0.682298)), V((0.4255,0.689342)), V((0.4109,0.694143)), ),
    15790: (V((0.5120,0.872037)), V((0.5149,0.864551)), V((0.5213,0.866344)), V((0.5217,0.874440)), ),
    15791: (V((0.5016,0.903557)), V((0.5112,0.907247)), V((0.5081,0.916577)), V((0.4984,0.913702)), ),
    15792: (V((0.4959,0.923244)), V((0.5060,0.925460)), V((0.4997,0.933745)), V((0.4937,0.932554)), ),
    15793: (V((0.3401,0.699559)), V((0.3534,0.699317)), V((0.3538,0.704864)), V((0.3405,0.704581)), ),
    15794: (V((0.4984,0.913702)), V((0.5081,0.916577)), V((0.5060,0.925460)), V((0.4959,0.923244)), ),
    15795: (V((0.4268,0.695078)), V((0.4255,0.689342)), V((0.4399,0.684493)), V((0.4414,0.691602)), ),
    15796: (V((0.4542,0.688638)), V((0.4530,0.681971)), V((0.4632,0.679669)), V((0.4637,0.685531)), ),
    15797: (V((0.5539,0.742789)), V((0.5497,0.729093)), V((0.5561,0.728468)), V((0.5616,0.740742)), ),
    15798: (V((0.5527,0.714009)), V((0.5561,0.728468)), V((0.5497,0.729093)), V((0.5444,0.717059)), ),
    15799: (V((0.5552,0.752454)), V((0.5539,0.742789)), V((0.5616,0.740742)), V((0.5624,0.750234)), ),
    15800: (V((0.5624,0.750234)), V((0.5678,0.761575)), V((0.5582,0.765095)), V((0.5552,0.752454)), ),
    15801: (V((0.5678,0.761575)), V((0.5712,0.769456)), V((0.5603,0.773440)), V((0.5582,0.765095)), ),
    15802: (V((0.5712,0.769456)), V((0.5745,0.776070)), V((0.5620,0.781200)), V((0.5603,0.773440)), ),
    15803: (V((0.5745,0.776070)), V((0.5775,0.781791)), V((0.5641,0.788251)), V((0.5620,0.781200)), ),
    15804: (V((0.5775,0.781791)), V((0.5796,0.789136)), V((0.5652,0.797165)), V((0.5641,0.788251)), ),
    15805: (V((0.5796,0.789136)), V((0.5797,0.800680)), V((0.5667,0.806414)), V((0.5652,0.797165)), ),
    15806: (V((0.5679,0.814813)), V((0.5667,0.806414)), V((0.5797,0.800680)), V((0.5803,0.807100)), ),
    15807: (V((0.5420,0.688729)), V((0.5473,0.704767)), V((0.5391,0.708159)), V((0.5315,0.692672)), ),
    15808: (V((0.4328,0.909032)), V((0.4253,0.904159)), V((0.4292,0.896890)), V((0.4380,0.901206)), ),
    15809: (V((0.4322,0.851525)), V((0.4250,0.856576)), V((0.4189,0.846744)), V((0.4271,0.841986)), ),
    15810: (V((0.4380,0.901206)), V((0.4292,0.896890)), V((0.4320,0.885100)), V((0.4419,0.889307)), ),
    15811: (V((0.4413,0.870973)), V((0.4305,0.870796)), V((0.4250,0.856576)), V((0.4322,0.851525)), ),
    15812: (V((0.4419,0.889307)), V((0.4320,0.885100)), V((0.4305,0.870796)), V((0.4413,0.870973)), ),
    15813: (V((0.4253,0.904159)), V((0.4174,0.899668)), V((0.4201,0.892559)), V((0.4292,0.896890)), ),
    15814: (V((0.4250,0.856576)), V((0.4153,0.858705)), V((0.4103,0.850928)), V((0.4189,0.846744)), ),
    15815: (V((0.4292,0.896890)), V((0.4201,0.892559)), V((0.4219,0.881464)), V((0.4320,0.885100)), ),
    15816: (V((0.4320,0.885100)), V((0.4219,0.881464)), V((0.4197,0.868682)), V((0.4305,0.870796)), ),
    15817: (V((0.4305,0.870796)), V((0.4197,0.868682)), V((0.4153,0.858705)), V((0.4250,0.856576)), ),
    15818: (V((0.4174,0.899668)), V((0.4085,0.893509)), V((0.4111,0.887475)), V((0.4201,0.892559)), ),
    15819: (V((0.4153,0.858705)), V((0.4050,0.860140)), V((0.4004,0.854037)), V((0.4103,0.850928)), ),
    15820: (V((0.4201,0.892559)), V((0.4111,0.887475)), V((0.4119,0.877837)), V((0.4219,0.881464)), ),
    15821: (V((0.4219,0.881464)), V((0.4119,0.877837)), V((0.4091,0.868046)), V((0.4197,0.868682)), ),
    15822: (V((0.4197,0.868682)), V((0.4091,0.868046)), V((0.4050,0.860140)), V((0.4153,0.858705)), ),
    15823: (V((0.4085,0.893509)), V((0.4027,0.887159)), V((0.4031,0.882332)), V((0.4111,0.887475)), ),
    15824: (V((0.4050,0.860140)), V((0.3962,0.862863)), V((0.3920,0.857366)), V((0.4004,0.854037)), ),
    15825: (V((0.4111,0.887475)), V((0.4031,0.882332)), V((0.4034,0.875190)), V((0.4119,0.877837)), ),
    15826: (V((0.4119,0.877837)), V((0.4034,0.875190)), V((0.3992,0.867741)), V((0.4091,0.868046)), ),
    15827: (V((0.4091,0.868046)), V((0.3992,0.867741)), V((0.3962,0.862863)), V((0.4050,0.860140)), ),
    15828: (V((0.4027,0.887159)), V((0.3983,0.883420)), V((0.3982,0.880004)), V((0.4031,0.882332)), ),
    15829: (V((0.3962,0.862863)), V((0.3901,0.863251)), V((0.3871,0.859603)), V((0.3920,0.857366)), ),
    15830: (V((0.4031,0.882332)), V((0.3982,0.880004)), V((0.3971,0.875509)), V((0.4034,0.875190)), ),
    15831: (V((0.4034,0.875190)), V((0.3971,0.875509)), V((0.3942,0.869366)), V((0.3992,0.867741)), ),
    15832: (V((0.3992,0.867741)), V((0.3942,0.869366)), V((0.3901,0.863251)), V((0.3962,0.862863)), ),
    15833: (V((0.3735,0.775889)), V((0.3687,0.793247)), V((0.3546,0.789985)), V((0.3554,0.776830)), ),
    15834: (V((0.3998,0.806285)), V((0.3924,0.812772)), V((0.3802,0.801668)), V((0.3881,0.788143)), ),
    15835: (V((0.3881,0.788143)), V((0.3802,0.801668)), V((0.3687,0.793247)), V((0.3735,0.775889)), ),
    15836: (V((0.3554,0.776830)), V((0.3546,0.789985)), V((0.3396,0.791067)), V((0.3401,0.776801)), ),
    15837: (V((0.3687,0.793247)), V((0.3644,0.805903)), V((0.3530,0.802827)), V((0.3546,0.789985)), ),
    15838: (V((0.3546,0.789985)), V((0.3530,0.802827)), V((0.3401,0.803126)), V((0.3396,0.791067)), ),
    15839: (V((0.3924,0.812772)), V((0.3861,0.820020)), V((0.3772,0.812876)), V((0.3802,0.801668)), ),
    15840: (V((0.3802,0.801668)), V((0.3772,0.812876)), V((0.3644,0.805903)), V((0.3687,0.793247)), ),
    15841: (V((0.3861,0.820020)), V((0.3802,0.827675)), V((0.3731,0.821693)), V((0.3772,0.812876)), ),
    15842: (V((0.3772,0.812876)), V((0.3731,0.821693)), V((0.3631,0.817132)), V((0.3644,0.805903)), ),
    15843: (V((0.3644,0.805903)), V((0.3631,0.817132)), V((0.3521,0.814505)), V((0.3530,0.802827)), ),
    15844: (V((0.3530,0.802827)), V((0.3521,0.814505)), V((0.3401,0.813443)), V((0.3401,0.803126)), ),
    15845: (V((0.3631,0.817132)), V((0.3628,0.825029)), V((0.3509,0.822884)), V((0.3521,0.814505)), ),
    15846: (V((0.3521,0.814505)), V((0.3509,0.822884)), V((0.3401,0.821829)), V((0.3401,0.813443)), ),
    15847: (V((0.3802,0.827675)), V((0.3765,0.835509)), V((0.3707,0.830495)), V((0.3731,0.821693)), ),
    15848: (V((0.3731,0.821693)), V((0.3707,0.830495)), V((0.3628,0.825029)), V((0.3631,0.817132)), ),
    15849: (V((0.3707,0.830495)), V((0.3684,0.837073)), V((0.3618,0.830354)), V((0.3628,0.825029)), ),
    15850: (V((0.3628,0.825029)), V((0.3618,0.830354)), V((0.3511,0.827884)), V((0.3509,0.822884)), ),
    15851: (V((0.3509,0.822884)), V((0.3511,0.827884)), V((0.3401,0.829754)), V((0.3401,0.821829)), ),
    15852: (V((0.3765,0.835509)), V((0.3736,0.842370)), V((0.3684,0.837073)), V((0.3707,0.830495)), ),
    15853: (V((0.4211,0.833525)), V((0.4136,0.839572)), V((0.4078,0.830938)), V((0.4157,0.826415)), ),
    15854: (V((0.4157,0.826415)), V((0.4078,0.830938)), V((0.4006,0.822209)), V((0.4085,0.816477)), ),
    15855: (V((0.4136,0.839572)), V((0.4052,0.844157)), V((0.3992,0.836112)), V((0.4078,0.830938)), ),
    15856: (V((0.4078,0.830938)), V((0.3992,0.836112)), V((0.3935,0.827542)), V((0.4006,0.822209)), ),
    15857: (V((0.4052,0.844157)), V((0.3971,0.848612)), V((0.3923,0.842314)), V((0.3992,0.836112)), ),
    15858: (V((0.3992,0.836112)), V((0.3923,0.842314)), V((0.3868,0.834161)), V((0.3935,0.827542)), ),
    15859: (V((0.3971,0.848612)), V((0.3894,0.852467)), V((0.3866,0.847230)), V((0.3923,0.842314)), ),
    15860: (V((0.3923,0.842314)), V((0.3866,0.847230)), V((0.3828,0.842377)), V((0.3868,0.834161)), ),
    15861: (V((0.3894,0.852467)), V((0.3843,0.855373)), V((0.3813,0.851824)), V((0.3866,0.847230)), ),
    15862: (V((0.3866,0.847230)), V((0.3813,0.851824)), V((0.3781,0.847909)), V((0.3828,0.842377)), ),
    15863: (V((0.4006,0.822209)), V((0.3924,0.812772)), V((0.3998,0.806285)), V((0.4085,0.816477)), ),
    15864: (V((0.3861,0.820020)), V((0.3924,0.812772)), V((0.4006,0.822209)), V((0.3935,0.827542)), ),
    15865: (V((0.3802,0.827675)), V((0.3861,0.820020)), V((0.3935,0.827542)), V((0.3868,0.834161)), ),
    15866: (V((0.3765,0.835509)), V((0.3802,0.827675)), V((0.3868,0.834161)), V((0.3828,0.842377)), ),
    15867: (V((0.3736,0.842370)), V((0.3765,0.835509)), V((0.3828,0.842377)), V((0.3781,0.847909)), ),
    15868: (V((0.3920,0.857366)), V((0.3871,0.859603)), V((0.3843,0.855373)), V((0.3894,0.852467)), ),
    15869: (V((0.4004,0.854037)), V((0.3920,0.857366)), V((0.3894,0.852467)), V((0.3971,0.848612)), ),
    15870: (V((0.4103,0.850928)), V((0.4004,0.854037)), V((0.3971,0.848612)), V((0.4052,0.844157)), ),
    15871: (V((0.4189,0.846744)), V((0.4103,0.850928)), V((0.4052,0.844157)), V((0.4136,0.839572)), ),
    15872: (V((0.4211,0.833525)), V((0.4271,0.841986)), V((0.4189,0.846744)), V((0.4136,0.839572)), ),
    15873: (V((0.5463,0.162445)), V((0.5511,0.166484)), V((0.5448,0.175936)), V((0.5405,0.171352)), ),
    15874: (V((0.5617,0.187400)), V((0.5564,0.183515)), V((0.5618,0.174863)), V((0.5664,0.179633)), ),
    15875: (V((0.5025,0.145501)), V((0.5071,0.142485)), V((0.5056,0.152641)), V((0.5015,0.155465)), ),
    15876: (V((0.4977,0.148495)), V((0.5025,0.145501)), V((0.5015,0.155465)), V((0.4964,0.158376)), ),
    15877: (V((0.5662,0.190381)), V((0.5617,0.187400)), V((0.5664,0.179633)), V((0.5707,0.182519)), ),
    15878: (V((0.5564,0.183515)), V((0.5508,0.180197)), V((0.5566,0.171038)), V((0.5618,0.174863)), ),
    15879: (V((0.4881,0.150205)), V((0.4925,0.151062)), V((0.4899,0.161525)), V((0.4852,0.161446)), ),
    15880: (V((0.5071,0.142485)), V((0.5095,0.140991)), V((0.5082,0.150948)), V((0.5056,0.152641)), ),
    15881: (V((0.5707,0.182519)), V((0.5749,0.184637)), V((0.5705,0.193035)), V((0.5662,0.190381)), ),
    15882: (V((0.4964,0.158376)), V((0.4899,0.161525)), V((0.4925,0.151062)), V((0.4977,0.148495)), ),
    15883: (V((0.5463,0.162445)), V((0.5405,0.171352)), V((0.5337,0.165695)), V((0.5398,0.156144)), ),
    15884: (V((0.5255,0.208059)), V((0.5405,0.171352)), V((0.5448,0.175936)), V((0.5325,0.209308)), ),
    15885: (V((0.5325,0.209308)), V((0.5448,0.175936)), V((0.5508,0.180197)), V((0.5415,0.211250)), ),
    15886: (V((0.5564,0.183515)), V((0.5482,0.215251)), V((0.5415,0.211250)), V((0.5508,0.180197)), ),
    15887: (V((0.4654,0.190799)), V((0.4964,0.158376)), V((0.5015,0.155465)), V((0.4708,0.193069)), ),
    15888: (V((0.4775,0.195993)), V((0.4742,0.194722)), V((0.5056,0.152641)), V((0.5082,0.150948)), ),
    15889: (V((0.5222,0.155092)), V((0.4961,0.202110)), V((0.4894,0.201240)), V((0.5187,0.152999)), ),
    15890: (V((0.4839,0.198298)), V((0.5141,0.150232)), V((0.5187,0.152999)), V((0.4894,0.201240)), ),
    15891: (V((0.4807,0.197156)), V((0.5114,0.149945)), V((0.5141,0.150232)), V((0.4839,0.198298)), ),
    15892: (V((0.5114,0.149945)), V((0.4807,0.197156)), V((0.4775,0.195993)), V((0.5082,0.150948)), ),
    15893: (V((0.4654,0.190799)), V((0.4854,0.161590)), V((0.4899,0.161525)), V((0.4964,0.158376)), ),
    15894: (V((0.5064,0.203960)), V((0.5279,0.160207)), V((0.5337,0.165695)), V((0.5160,0.205716)), ),
    15895: (V((0.4961,0.202110)), V((0.5222,0.155092)), V((0.5279,0.160207)), V((0.5064,0.203960)), ),
    15896: (V((0.5160,0.205716)), V((0.5337,0.165695)), V((0.5405,0.171352)), V((0.5255,0.208059)), ),
    15897: (V((0.4723,0.111170)), V((0.4759,0.113594)), V((0.4703,0.119278)), V((0.4676,0.116235)), ),
    15898: (V((0.4710,0.047140)), V((0.4711,0.045706)), V((0.4743,0.051812)), V((0.4726,0.052957)), ),
    15899: (V((0.4776,0.087243)), V((0.4836,0.087309)), V((0.4841,0.098302)), V((0.4802,0.097055)), ),
    15900: (V((0.4534,0.146707)), V((0.4499,0.143773)), V((0.4527,0.136501)), V((0.4564,0.139104)), ),
    15901: (V((0.5116,0.023300)), V((0.6208,0.054555)), V((0.5449,0.032000)), V((0.5436,0.031600)), ),
    15902: (V((0.4726,0.052957)), V((0.4743,0.051812)), V((0.4800,0.064846)), V((0.4774,0.066370)), ),
    15903: (V((0.4774,0.066370)), V((0.4800,0.064846)), V((0.4824,0.075043)), V((0.4794,0.076005)), ),
    15904: (V((0.4676,0.116235)), V((0.4703,0.119278)), V((0.4639,0.124249)), V((0.4620,0.121754)), ),
    15905: (V((0.4493,0.156409)), V((0.4460,0.154208)), V((0.4499,0.143773)), V((0.4534,0.146707)), ),
    15906: (V((0.4802,0.097055)), V((0.4841,0.098302)), V((0.4816,0.108838)), V((0.4772,0.107178)), ),
    15907: (V((0.5716,0.059293)), V((0.5713,0.058700)), V((0.5715,0.066969)), V((0.5693,0.066394)), ),
    15908: (V((0.4794,0.076005)), V((0.4824,0.075043)), V((0.4836,0.087309)), V((0.4776,0.087243)), ),
    15909: (V((0.5623,0.081551)), V((0.5655,0.083210)), V((0.5649,0.097258)), V((0.5600,0.096715)), ),
    15910: (V((0.4611,0.132099)), V((0.4583,0.128848)), V((0.4639,0.124249)), V((0.4667,0.127338)), ),
    15911: (V((0.5611,0.050200)), V((0.5436,0.031600)), V((0.5449,0.032000)), V((0.5611,0.050200)), ),
    15912: (V((0.5693,0.066394)), V((0.5715,0.066969)), V((0.5655,0.083210)), V((0.5623,0.081551)), ),
    15913: (V((0.5611,0.050200)), V((0.5611,0.050200)), V((0.5713,0.058700)), V((0.5716,0.059293)), ),
    15914: (V((0.5599,0.108200)), V((0.5655,0.108099)), V((0.5636,0.117476)), V((0.5577,0.117989)), ),
    15915: (V((0.4703,0.043100)), V((0.4729,0.036969)), V((0.4830,0.027798)), V((0.5077,0.023200)), ),
    15916: (V((0.5600,0.096715)), V((0.5649,0.097258)), V((0.5655,0.108099)), V((0.5599,0.108200)), ),
    15917: (V((0.4772,0.107178)), V((0.4816,0.108838)), V((0.4759,0.113594)), V((0.4723,0.111170)), ),
    15918: (V((0.5577,0.117989)), V((0.5636,0.117476)), V((0.5654,0.124988)), V((0.5616,0.126028)), ),
    15919: (V((0.4611,0.132099)), V((0.4564,0.139104)), V((0.4527,0.136501)), V((0.4583,0.128848)), ),
    15920: (V((0.5426,0.028546)), V((0.6208,0.054555)), V((0.6256,0.055655)), V((0.6253,0.055383)), ),
    15921: (V((0.4673,0.046028)), V((0.4729,0.036969)), V((0.4711,0.045706)), V((0.4710,0.047140)), ),
    15922: (V((0.5616,0.126028)), V((0.5654,0.124988)), V((0.5674,0.129747)), V((0.5642,0.129636)), ),
    15923: (V((0.3553,0.611647)), V((0.3651,0.611347)), V((0.3653,0.630583)), V((0.3559,0.631068)), ),
    15924: (V((0.3478,0.611486)), V((0.3553,0.611647)), V((0.3559,0.631068)), V((0.3478,0.631158)), ),
    15925: (V((0.3478,0.631158)), V((0.3401,0.631002)), V((0.3401,0.611631)), V((0.3478,0.611486)), ),
    15926: (V((0.5142,0.610545)), V((0.5209,0.609637)), V((0.5227,0.620812)), V((0.5159,0.622297)), ),
    15927: (V((0.5159,0.622297)), V((0.5087,0.623214)), V((0.5075,0.610548)), V((0.5142,0.610545)), ),
    15928: (V((0.5087,0.623214)), V((0.5012,0.623892)), V((0.5003,0.610580)), V((0.5075,0.610548)), ),
    15929: (V((0.5012,0.623892)), V((0.4941,0.623924)), V((0.4935,0.610414)), V((0.5003,0.610580)), ),
    15930: (V((0.4941,0.623924)), V((0.4863,0.623986)), V((0.4872,0.610667)), V((0.4935,0.610414)), ),
    15931: (V((0.4786,0.608980)), V((0.4872,0.610667)), V((0.4863,0.623986)), V((0.4795,0.623582)), ),
    15932: (V((0.4690,0.603467)), V((0.4786,0.608980)), V((0.4795,0.623582)), V((0.4705,0.623044)), ),
    15933: (V((0.4705,0.623044)), V((0.4595,0.622152)), V((0.4598,0.602447)), V((0.4690,0.603467)), ),
    15934: (V((0.4595,0.622152)), V((0.4472,0.625231)), V((0.4473,0.604804)), V((0.4598,0.602447)), ),
    15935: (V((0.4308,0.604340)), V((0.4473,0.604804)), V((0.4472,0.625231)), V((0.4296,0.627759)), ),
    15936: (V((0.4296,0.627759)), V((0.4174,0.626428)), V((0.4159,0.606803)), V((0.4308,0.604340)), ),
    15937: (V((0.4174,0.626428)), V((0.4017,0.626959)), V((0.4023,0.608553)), V((0.4159,0.606803)), ),
    15938: (V((0.3890,0.609657)), V((0.4023,0.608553)), V((0.4017,0.626959)), V((0.3890,0.628354)), ),
    15939: (V((0.3769,0.610967)), V((0.3890,0.609657)), V((0.3890,0.628354)), V((0.3764,0.629312)), ),
    15940: (V((0.3764,0.629312)), V((0.3653,0.630583)), V((0.3651,0.611347)), V((0.3769,0.610967)), ),
    15941: (V((0.5370,0.306461)), V((0.5277,0.305977)), V((0.5329,0.280938)), V((0.5428,0.281111)), ),
    15942: (V((0.5508,0.280448)), V((0.5457,0.306224)), V((0.5370,0.306461)), V((0.5428,0.281111)), ),
    15943: (V((0.5594,0.280291)), V((0.5550,0.306344)), V((0.5457,0.306224)), V((0.5508,0.280448)), ),
    15944: (V((0.5550,0.306344)), V((0.5594,0.280291)), V((0.5680,0.280554)), V((0.5634,0.307746)), ),
    15945: (V((0.5784,0.280455)), V((0.5729,0.310335)), V((0.5634,0.307746)), V((0.5680,0.280554)), ),
    15946: (V((0.4160,0.264632)), V((0.4283,0.239625)), V((0.4358,0.243862)), V((0.4239,0.268549)), ),
    15947: (V((0.4316,0.272765)), V((0.4239,0.268549)), V((0.4358,0.243862)), V((0.4429,0.247784)), ),
    15948: (V((0.2068,0.298412)), V((0.2014,0.273083)), V((0.2108,0.269087)), V((0.2180,0.295385)), ),
    15949: (V((0.1964,0.300648)), V((0.1914,0.276724)), V((0.2014,0.273083)), V((0.2068,0.298412)), ),
    15950: (V((0.1852,0.302269)), V((0.1804,0.278675)), V((0.1914,0.276724)), V((0.1964,0.300648)), ),
    15951: (V((0.1804,0.278675)), V((0.1852,0.302269)), V((0.1744,0.304196)), V((0.1699,0.279830)), ),
    15952: (V((0.1638,0.306278)), V((0.1586,0.281780)), V((0.1699,0.279830)), V((0.1744,0.304196)), ),
    15953: (V((0.1586,0.281780)), V((0.1638,0.306278)), V((0.1524,0.305977)), V((0.1472,0.280938)), ),
    15954: (V((0.1431,0.306461)), V((0.1373,0.281111)), V((0.1472,0.280938)), V((0.1524,0.305977)), ),
    15955: (V((0.1344,0.306224)), V((0.1293,0.280448)), V((0.1373,0.281111)), V((0.1431,0.306461)), ),
    15956: (V((0.1251,0.306344)), V((0.1207,0.280291)), V((0.1293,0.280448)), V((0.1344,0.306224)), ),
    15957: (V((0.1207,0.280291)), V((0.1251,0.306344)), V((0.1167,0.307746)), V((0.1121,0.280554)), ),
    15958: (V((0.1072,0.310335)), V((0.1017,0.280455)), V((0.1121,0.280554)), V((0.1167,0.307746)), ),
    15959: (V((0.2519,0.239625)), V((0.2641,0.264632)), V((0.2562,0.268549)), V((0.2443,0.243862)), ),
    15960: (V((0.2443,0.243862)), V((0.2562,0.268549)), V((0.2485,0.272765)), V((0.2372,0.247784)), ),
    15961: (V((0.2372,0.247784)), V((0.2485,0.272765)), V((0.2415,0.277832)), V((0.2314,0.251895)), ),
    15962: (V((0.2348,0.283818)), V((0.2267,0.256122)), V((0.2314,0.251895)), V((0.2415,0.277832)), ),
    15963: (V((0.2296,0.287940)), V((0.2223,0.260075)), V((0.2267,0.256122)), V((0.2348,0.283818)), ),
    15964: (V((0.2223,0.260075)), V((0.2296,0.287940)), V((0.2245,0.291952)), V((0.2176,0.264432)), ),
    15965: (V((0.2176,0.264432)), V((0.2245,0.291952)), V((0.2180,0.295385)), V((0.2108,0.269087)), ),
    15966: (V((0.4377,0.390416)), V((0.4293,0.386397)), V((0.4399,0.355715)), V((0.4480,0.358787)), ),
    15967: (V((0.4197,0.380693)), V((0.4300,0.350603)), V((0.4399,0.355715)), V((0.4293,0.386397)), ),
    15968: (V((0.4300,0.350603)), V((0.4197,0.380693)), V((0.4105,0.375806)), V((0.4226,0.347023)), ),
    15969: (V((0.4019,0.369133)), V((0.4136,0.340806)), V((0.4226,0.347023)), V((0.4105,0.375806)), ),
    15970: (V((0.3935,0.363237)), V((0.4068,0.335537)), V((0.4136,0.340806)), V((0.4019,0.369133)), ),
    15971: (V((0.3853,0.358487)), V((0.3997,0.331019)), V((0.4068,0.335537)), V((0.3935,0.363237)), ),
    15972: (V((0.3770,0.354679)), V((0.3905,0.326481)), V((0.3997,0.331019)), V((0.3853,0.358487)), ),
    15973: (V((0.1424,0.367902)), V((0.1472,0.396338)), V((0.1390,0.395607)), V((0.1341,0.369688)), ),
    15974: (V((0.1464,0.425190)), V((0.1426,0.449759)), V((0.1334,0.444798)), V((0.1390,0.422244)), ),
    15975: (V((0.1426,0.449759)), V((0.1464,0.425190)), V((0.1548,0.428968)), V((0.1525,0.454079)), ),
    15976: (V((0.1472,0.396338)), V((0.1424,0.367902)), V((0.1510,0.367290)), V((0.1556,0.397343)), ),
    15977: (V((0.1556,0.397343)), V((0.1510,0.367290)), V((0.1591,0.367586)), V((0.1636,0.398334)), ),
    15978: (V((0.1525,0.454079)), V((0.1548,0.428968)), V((0.1634,0.432605)), V((0.1634,0.458566)), ),
    15979: (V((0.1636,0.398334)), V((0.1591,0.367586)), V((0.1670,0.367355)), V((0.1718,0.399463)), ),
    15980: (V((0.1757,0.367100)), V((0.1810,0.399791)), V((0.1718,0.399463)), V((0.1670,0.367355)), ),
    15981: (V((0.1634,0.458566)), V((0.1634,0.432605)), V((0.1727,0.434931)), V((0.1745,0.459903)), ),
    15982: (V((0.1839,0.435003)), V((0.1849,0.460067)), V((0.1745,0.459903)), V((0.1727,0.434931)), ),
    15983: (V((0.1849,0.460067)), V((0.1839,0.435003)), V((0.1942,0.433175)), V((0.1980,0.458239)), ),
    15984: (V((0.1980,0.458239)), V((0.1942,0.433175)), V((0.2103,0.429421)), V((0.2154,0.455106)), ),
    15985: (V((0.1810,0.399791)), V((0.1757,0.367100)), V((0.1843,0.366554)), V((0.1900,0.399316)), ),
    15986: (V((0.1953,0.365512)), V((0.2027,0.397671)), V((0.1900,0.399316)), V((0.1843,0.366554)), ),
    15987: (V((0.2092,0.363460)), V((0.2172,0.395266)), V((0.2027,0.397671)), V((0.1953,0.365512)), ),
    15988: (V((0.2154,0.455106)), V((0.2103,0.429421)), V((0.2261,0.427130)), V((0.2318,0.451150)), ),
    15989: (V((0.2318,0.451150)), V((0.2261,0.427130)), V((0.2408,0.423956)), V((0.2470,0.447734)), ),
    15990: (V((0.2226,0.361977)), V((0.2316,0.393130)), V((0.2172,0.395266)), V((0.2092,0.363460)), ),
    15991: (V((0.2470,0.447734)), V((0.2408,0.423956)), V((0.2526,0.419689)), V((0.2596,0.443439)), ),
    15992: (V((0.2316,0.393130)), V((0.2226,0.361977)), V((0.2321,0.358787)), V((0.2424,0.390416)), ),
    15993: (V((0.2402,0.355715)), V((0.2509,0.386397)), V((0.2424,0.390416)), V((0.2321,0.358787)), ),
    15994: (V((0.2618,0.415454)), V((0.2709,0.438690)), V((0.2596,0.443439)), V((0.2526,0.419689)), ),
    15995: (V((0.2722,0.409404)), V((0.2830,0.433360)), V((0.2709,0.438690)), V((0.2618,0.415454)), ),
    15996: (V((0.2830,0.433360)), V((0.2722,0.409404)), V((0.2819,0.404308)), V((0.2933,0.428118)), ),
    15997: (V((0.2933,0.428118)), V((0.2819,0.404308)), V((0.2922,0.398466)), V((0.3032,0.421764)), ),
    15998: (V((0.3005,0.392471)), V((0.3113,0.414927)), V((0.3032,0.421764)), V((0.2922,0.398466)), ),
    15999: (V((0.3090,0.387960)), V((0.3204,0.409301)), V((0.3113,0.414927)), V((0.3005,0.392471)), ),
    16000: (V((0.3172,0.383770)), V((0.3281,0.405659)), V((0.3204,0.409301)), V((0.3090,0.387960)), ),
    16001: (V((0.1249,0.440106)), V((0.1322,0.420363)), V((0.1390,0.422244)), V((0.1334,0.444798)), ),
    16002: (V((0.1341,0.369688)), V((0.1390,0.395607)), V((0.1325,0.396082)), V((0.1264,0.371451)), ),
    16003: (V((0.2897,0.326481)), V((0.3031,0.354679)), V((0.2948,0.358487)), V((0.2804,0.331019)), ),
    16004: (V((0.2804,0.331019)), V((0.2948,0.358487)), V((0.2866,0.363237)), V((0.2733,0.335537)), ),
    16005: (V((0.2733,0.335537)), V((0.2866,0.363237)), V((0.2782,0.369133)), V((0.2666,0.340806)), ),
    16006: (V((0.2666,0.340806)), V((0.2782,0.369133)), V((0.2696,0.375806)), V((0.2575,0.347023)), ),
    16007: (V((0.2605,0.380693)), V((0.2501,0.350603)), V((0.2575,0.347023)), V((0.2696,0.375806)), ),
    16008: (V((0.2501,0.350603)), V((0.2605,0.380693)), V((0.2509,0.386397)), V((0.2402,0.355715)), ),
    16009: (V((0.3971,0.433360)), V((0.4079,0.409404)), V((0.4183,0.415454)), V((0.4092,0.438690)), ),
    16010: (V((0.4092,0.438690)), V((0.4183,0.415454)), V((0.4275,0.419689)), V((0.4205,0.443439)), ),
    16011: (V((0.4393,0.423956)), V((0.4331,0.447734)), V((0.4205,0.443439)), V((0.4275,0.419689)), ),
    16012: (V((0.4079,0.409404)), V((0.3971,0.433360)), V((0.3869,0.428118)), V((0.3982,0.404308)), ),
    16013: (V((0.3982,0.404308)), V((0.3869,0.428118)), V((0.3769,0.421764)), V((0.3879,0.398466)), ),
    16014: (V((0.3688,0.414927)), V((0.3796,0.392471)), V((0.3879,0.398466)), V((0.3769,0.421764)), ),
    16015: (V((0.3597,0.409301)), V((0.3711,0.387960)), V((0.3796,0.392471)), V((0.3688,0.414927)), ),
    16016: (V((0.3520,0.405659)), V((0.3629,0.383770)), V((0.3711,0.387960)), V((0.3597,0.409301)), ),
    16017: (V((0.5479,0.420363)), V((0.5552,0.440106)), V((0.5467,0.444798)), V((0.5411,0.422244)), ),
    16018: (V((0.5375,0.449759)), V((0.5337,0.425190)), V((0.5411,0.422244)), V((0.5467,0.444798)), ),
    16019: (V((0.5337,0.425190)), V((0.5375,0.449759)), V((0.5276,0.454079)), V((0.5253,0.428968)), ),
    16020: (V((0.5253,0.428968)), V((0.5276,0.454079)), V((0.5168,0.458566)), V((0.5167,0.432605)), ),
    16021: (V((0.5167,0.432605)), V((0.5168,0.458566)), V((0.5056,0.459903)), V((0.5074,0.434931)), ),
    16022: (V((0.4952,0.460067)), V((0.4962,0.435003)), V((0.5074,0.434931)), V((0.5056,0.459903)), ),
    16023: (V((0.4962,0.435003)), V((0.4952,0.460067)), V((0.4821,0.458239)), V((0.4859,0.433175)), ),
    16024: (V((0.4859,0.433175)), V((0.4821,0.458239)), V((0.4647,0.455106)), V((0.4698,0.429421)), ),
    16025: (V((0.4698,0.429421)), V((0.4647,0.455106)), V((0.4483,0.451150)), V((0.4540,0.427130)), ),
    16026: (V((0.4540,0.427130)), V((0.4483,0.451150)), V((0.4331,0.447734)), V((0.4393,0.423956)), ),
    16771: (V((0.1634,0.580224)), V((0.1584,0.583501)), V((0.1524,0.569407)), V((0.1585,0.567320)), ),
    16772: (V((0.1765,0.573921)), V((0.1696,0.577039)), V((0.1654,0.563267)), V((0.1715,0.560521)), ),
    16773: (V((0.1765,0.573921)), V((0.1715,0.560521)), V((0.1785,0.557532)), V((0.1838,0.570592)), ),
    16774: (V((0.1838,0.570592)), V((0.1785,0.557532)), V((0.1862,0.554174)), V((0.1908,0.567038)), ),
    16775: (V((0.1983,0.564293)), V((0.1908,0.567038)), V((0.1862,0.554174)), V((0.1933,0.551262)), ),
    16776: (V((0.2034,0.548813)), V((0.2070,0.561551)), V((0.1983,0.564293)), V((0.1933,0.551262)), ),
    16777: (V((0.2070,0.561551)), V((0.2034,0.548813)), V((0.2160,0.547034)), V((0.2183,0.560466)), ),
    16778: (V((0.2475,0.559002)), V((0.2320,0.559549)), V((0.2306,0.544844)), V((0.2463,0.544553)), ),
    16779: (V((0.2635,0.559432)), V((0.2613,0.543750)), V((0.2761,0.543656)), V((0.2766,0.558741)), ),
    16780: (V((0.2886,0.542126)), V((0.2890,0.557937)), V((0.2766,0.558741)), V((0.2761,0.543656)), ),
    16781: (V((0.2999,0.540798)), V((0.3014,0.557189)), V((0.2890,0.557937)), V((0.2886,0.542126)), ),
    16782: (V((0.3127,0.540187)), V((0.3139,0.556315)), V((0.3014,0.557189)), V((0.2999,0.540798)), ),
    16783: (V((0.3233,0.539688)), V((0.3240,0.555480)), V((0.3139,0.556315)), V((0.3127,0.540187)), ),
    16784: (V((0.3318,0.539445)), V((0.3401,0.539808)), V((0.3401,0.554011)), V((0.3321,0.554810)), ),
    16785: (V((0.1696,0.577039)), V((0.1634,0.580224)), V((0.1585,0.567320)), V((0.1654,0.563267)), ),
    16786: (V((0.3233,0.539688)), V((0.3318,0.539445)), V((0.3321,0.554810)), V((0.3240,0.555480)), ),
    16787: (V((0.2635,0.559432)), V((0.2475,0.559002)), V((0.2463,0.544553)), V((0.2613,0.543750)), ),
    16788: (V((0.2320,0.559549)), V((0.2183,0.560466)), V((0.2160,0.547034)), V((0.2306,0.544844)), ),
    16789: (V((0.5036,0.573921)), V((0.5086,0.560521)), V((0.5147,0.563267)), V((0.5105,0.577039)), ),
    16790: (V((0.5036,0.573921)), V((0.4963,0.570592)), V((0.5016,0.557532)), V((0.5086,0.560521)), ),
    16791: (V((0.4963,0.570592)), V((0.4894,0.567038)), V((0.4940,0.554174)), V((0.5016,0.557532)), ),
    16792: (V((0.4818,0.564293)), V((0.4868,0.551262)), V((0.4940,0.554174)), V((0.4894,0.567038)), ),
    16793: (V((0.4767,0.548813)), V((0.4868,0.551262)), V((0.4818,0.564293)), V((0.4731,0.561551)), ),
    16794: (V((0.4731,0.561551)), V((0.4619,0.560466)), V((0.4642,0.547034)), V((0.4767,0.548813)), ),
    16795: (V((0.4326,0.559002)), V((0.4338,0.544553)), V((0.4495,0.544844)), V((0.4482,0.559549)), ),
    16796: (V((0.4166,0.559432)), V((0.4036,0.558741)), V((0.4041,0.543656)), V((0.4188,0.543750)), ),
    16797: (V((0.3915,0.542126)), V((0.4041,0.543656)), V((0.4036,0.558741)), V((0.3912,0.557937)), ),
    16798: (V((0.3802,0.540798)), V((0.3915,0.542126)), V((0.3912,0.557937)), V((0.3787,0.557189)), ),
    16799: (V((0.3674,0.540187)), V((0.3802,0.540798)), V((0.3787,0.557189)), V((0.3662,0.556315)), ),
    16800: (V((0.3568,0.539688)), V((0.3674,0.540187)), V((0.3662,0.556315)), V((0.3561,0.555480)), ),
    16801: (V((0.5105,0.577039)), V((0.5147,0.563267)), V((0.5216,0.567320)), V((0.5167,0.580224)), ),
    16802: (V((0.3483,0.539445)), V((0.3480,0.554810)), V((0.3401,0.554011)), V((0.3401,0.539808)), ),
    16803: (V((0.3568,0.539688)), V((0.3561,0.555480)), V((0.3480,0.554810)), V((0.3483,0.539445)), ),
    16804: (V((0.5167,0.580224)), V((0.5216,0.567320)), V((0.5277,0.569407)), V((0.5218,0.583501)), ),
    16805: (V((0.4166,0.559432)), V((0.4188,0.543750)), V((0.4338,0.544553)), V((0.4326,0.559002)), ),
    16806: (V((0.4482,0.559549)), V((0.4495,0.544844)), V((0.4642,0.547034)), V((0.4619,0.560466)), ),
    16807: (V((0.3915,0.542126)), V((0.3802,0.540798)), V((0.3795,0.520869)), V((0.3916,0.521549)), ),
    16808: (V((0.3401,0.539808)), V((0.3318,0.539445)), V((0.3320,0.519961)), V((0.3401,0.520470)), ),
    16809: (V((0.2999,0.540798)), V((0.2886,0.542126)), V((0.2885,0.521549)), V((0.3006,0.520869)), ),
    16810: (V((0.5016,0.557532)), V((0.4940,0.554174)), V((0.4999,0.539978)), V((0.5070,0.543036)), ),
    16811: (V((0.1585,0.567320)), V((0.1524,0.569407)), V((0.1468,0.554446)), V((0.1541,0.551422)), ),
    16812: (V((0.1785,0.557532)), V((0.1715,0.560521)), V((0.1667,0.545861)), V((0.1732,0.543036)), ),
    16813: (V((0.4642,0.547034)), V((0.4495,0.544844)), V((0.4523,0.528949)), V((0.4670,0.531439)), ),
    16814: (V((0.5216,0.567320)), V((0.5147,0.563267)), V((0.5194,0.548345)), V((0.5260,0.551422)), ),
    16815: (V((0.4041,0.543656)), V((0.3915,0.542126)), V((0.3916,0.521549)), V((0.4047,0.523269)), ),
    16816: (V((0.2886,0.542126)), V((0.2761,0.543656)), V((0.2754,0.523269)), V((0.2885,0.521549)), ),
    16817: (V((0.5277,0.569407)), V((0.5216,0.567320)), V((0.5260,0.551422)), V((0.5333,0.554446)), ),
    16818: (V((0.4940,0.554174)), V((0.4868,0.551262)), V((0.4917,0.536749)), V((0.4999,0.539978)), ),
    16819: (V((0.2306,0.544844)), V((0.2160,0.547034)), V((0.2131,0.531439)), V((0.2278,0.528949)), ),
    16820: (V((0.1933,0.551262)), V((0.1862,0.554174)), V((0.1802,0.539978)), V((0.1884,0.536749)), ),
    16821: (V((0.3674,0.540187)), V((0.3568,0.539688)), V((0.3567,0.519868)), V((0.3668,0.520177)), ),
    16822: (V((0.1654,0.563267)), V((0.1585,0.567320)), V((0.1541,0.551422)), V((0.1607,0.548345)), ),
    16823: (V((0.3233,0.539688)), V((0.3127,0.540187)), V((0.3133,0.520177)), V((0.3234,0.519868)), ),
    16824: (V((0.3568,0.539688)), V((0.3483,0.539445)), V((0.3481,0.519961)), V((0.3567,0.519868)), ),
    16825: (V((0.1862,0.554174)), V((0.1785,0.557532)), V((0.1732,0.543036)), V((0.1802,0.539978)), ),
    16826: (V((0.4338,0.544553)), V((0.4188,0.543750)), V((0.4202,0.525801)), V((0.4358,0.527853)), ),
    16827: (V((0.4188,0.543750)), V((0.4041,0.543656)), V((0.4047,0.523269)), V((0.4202,0.525801)), ),
    16828: (V((0.2761,0.543656)), V((0.2613,0.543750)), V((0.2599,0.525801)), V((0.2754,0.523269)), ),
    16829: (V((0.4495,0.544844)), V((0.4338,0.544553)), V((0.4358,0.527853)), V((0.4523,0.528949)), ),
    16830: (V((0.4767,0.548813)), V((0.4642,0.547034)), V((0.4670,0.531439)), V((0.4805,0.534010)), ),
    16831: (V((0.2463,0.544553)), V((0.2306,0.544844)), V((0.2278,0.528949)), V((0.2443,0.527853)), ),
    16832: (V((0.3802,0.540798)), V((0.3674,0.540187)), V((0.3668,0.520177)), V((0.3795,0.520869)), ),
    16833: (V((0.3127,0.540187)), V((0.2999,0.540798)), V((0.3006,0.520869)), V((0.3133,0.520177)), ),
    16834: (V((0.5086,0.560521)), V((0.5016,0.557532)), V((0.5070,0.543036)), V((0.5135,0.545861)), ),
    16835: (V((0.3318,0.539445)), V((0.3233,0.539688)), V((0.3234,0.519868)), V((0.3320,0.519961)), ),
    16836: (V((0.2613,0.543750)), V((0.2463,0.544553)), V((0.2443,0.527853)), V((0.2599,0.525801)), ),
    16837: (V((0.3483,0.539445)), V((0.3401,0.539808)), V((0.3401,0.520470)), V((0.3481,0.519961)), ),
    16838: (V((0.1715,0.560521)), V((0.1654,0.563267)), V((0.1607,0.548345)), V((0.1667,0.545861)), ),
    16839: (V((0.4868,0.551262)), V((0.4767,0.548813)), V((0.4805,0.534010)), V((0.4917,0.536749)), ),
    16840: (V((0.2034,0.548813)), V((0.1933,0.551262)), V((0.1884,0.536749)), V((0.1996,0.534010)), ),
    16841: (V((0.2160,0.547034)), V((0.2034,0.548813)), V((0.1996,0.534010)), V((0.2131,0.531439)), ),
    16842: (V((0.5147,0.563267)), V((0.5086,0.560521)), V((0.5135,0.545861)), V((0.5194,0.548345)), ),
    16843: (V((0.4523,0.528949)), V((0.4358,0.527853)), V((0.4389,0.508557)), V((0.4546,0.512251)), ),
    16844: (V((0.2443,0.527853)), V((0.2278,0.528949)), V((0.2255,0.512251)), V((0.2412,0.508557)), ),
    16845: (V((0.3567,0.519868)), V((0.3481,0.519961)), V((0.3481,0.500881)), V((0.3573,0.500658)), ),
    16846: (V((0.3320,0.519961)), V((0.3234,0.519868)), V((0.3228,0.500658)), V((0.3320,0.500881)), ),
    16847: (V((0.5135,0.545861)), V((0.5070,0.543036)), V((0.5118,0.529070)), V((0.5183,0.531258)), ),
    16848: (V((0.1732,0.543036)), V((0.1667,0.545861)), V((0.1618,0.531258)), V((0.1683,0.529070)), ),
    16849: (V((0.4917,0.536749)), V((0.4805,0.534010)), V((0.4846,0.519427)), V((0.4962,0.522793)), ),
    16850: (V((0.1996,0.534010)), V((0.1884,0.536749)), V((0.1839,0.522793)), V((0.1955,0.519427)), ),
    16851: (V((0.3481,0.519961)), V((0.3401,0.520470)), V((0.3401,0.501034)), V((0.3481,0.500881)), ),
    16852: (V((0.3401,0.520470)), V((0.3320,0.519961)), V((0.3320,0.500881)), V((0.3401,0.501034)), ),
    16853: (V((0.4670,0.531439)), V((0.4523,0.528949)), V((0.4546,0.512251)), V((0.4707,0.515623)), ),
    16854: (V((0.2278,0.528949)), V((0.2131,0.531439)), V((0.2094,0.515623)), V((0.2255,0.512251)), ),
    16855: (V((0.3668,0.520177)), V((0.3567,0.519868)), V((0.3573,0.500658)), V((0.3690,0.501281)), ),
    16856: (V((0.3234,0.519868)), V((0.3133,0.520177)), V((0.3111,0.501281)), V((0.3228,0.500658)), ),
    16857: (V((0.4999,0.539978)), V((0.4917,0.536749)), V((0.4962,0.522793)), V((0.5045,0.526510)), ),
    16858: (V((0.1884,0.536749)), V((0.1802,0.539978)), V((0.1756,0.526510)), V((0.1839,0.522793)), ),
    16859: (V((0.5333,0.554446)), V((0.5260,0.551422)), V((0.5305,0.536074)), V((0.5392,0.540697)), ),
    16860: (V((0.1541,0.551422)), V((0.1468,0.554446)), V((0.1409,0.540697)), V((0.1496,0.536074)), ),
    16861: (V((0.5070,0.543036)), V((0.4999,0.539978)), V((0.5045,0.526510)), V((0.5118,0.529070)), ),
    16862: (V((0.1802,0.539978)), V((0.1732,0.543036)), V((0.1683,0.529070)), V((0.1756,0.526510)), ),
    16863: (V((0.3795,0.520869)), V((0.3668,0.520177)), V((0.3690,0.501281)), V((0.3810,0.499959)), ),
    16864: (V((0.3133,0.520177)), V((0.3006,0.520869)), V((0.2991,0.499959)), V((0.3111,0.501281)), ),
    16865: (V((0.5260,0.551422)), V((0.5194,0.548345)), V((0.5245,0.533951)), V((0.5305,0.536074)), ),
    16866: (V((0.1607,0.548345)), V((0.1541,0.551422)), V((0.1496,0.536074)), V((0.1556,0.533951)), ),
    16867: (V((0.4358,0.527853)), V((0.4202,0.525801)), V((0.4221,0.505297)), V((0.4389,0.508557)), ),
    16868: (V((0.2599,0.525801)), V((0.2443,0.527853)), V((0.2412,0.508557)), V((0.2581,0.505297)), ),
    16869: (V((0.4047,0.523269)), V((0.3916,0.521549)), V((0.3933,0.500881)), V((0.4076,0.503008)), ),
    16870: (V((0.2885,0.521549)), V((0.2754,0.523269)), V((0.2725,0.503008)), V((0.2868,0.500881)), ),
    16871: (V((0.4202,0.525801)), V((0.4047,0.523269)), V((0.4076,0.503008)), V((0.4221,0.505297)), ),
    16872: (V((0.2754,0.523269)), V((0.2599,0.525801)), V((0.2581,0.505297)), V((0.2725,0.503008)), ),
    16873: (V((0.5194,0.548345)), V((0.5135,0.545861)), V((0.5183,0.531258)), V((0.5245,0.533951)), ),
    16874: (V((0.1667,0.545861)), V((0.1607,0.548345)), V((0.1556,0.533951)), V((0.1618,0.531258)), ),
    16875: (V((0.4805,0.534010)), V((0.4670,0.531439)), V((0.4707,0.515623)), V((0.4846,0.519427)), ),
    16876: (V((0.2131,0.531439)), V((0.1996,0.534010)), V((0.1955,0.519427)), V((0.2094,0.515623)), ),
    16877: (V((0.3916,0.521549)), V((0.3795,0.520869)), V((0.3810,0.499959)), V((0.3933,0.500881)), ),
    16878: (V((0.3006,0.520869)), V((0.2885,0.521549)), V((0.2868,0.500881)), V((0.2991,0.499959)), ),
    16879: (V((0.4221,0.505297)), V((0.4076,0.503008)), V((0.4095,0.483115)), V((0.4261,0.485438)), ),
    16880: (V((0.2725,0.503008)), V((0.2581,0.505297)), V((0.2540,0.485438)), V((0.2706,0.483115)), ),
    16881: (V((0.5245,0.533951)), V((0.5183,0.531258)), V((0.5224,0.517813)), V((0.5293,0.520056)), ),
    16882: (V((0.1618,0.531258)), V((0.1556,0.533951)), V((0.1509,0.520056)), V((0.1577,0.517813)), ),
    16883: (V((0.4846,0.519427)), V((0.4707,0.515623)), V((0.4753,0.499350)), V((0.4892,0.504664)), ),
    16884: (V((0.2094,0.515623)), V((0.1955,0.519427)), V((0.1909,0.504664)), V((0.2048,0.499350)), ),
    16885: (V((0.3933,0.500881)), V((0.3810,0.499959)), V((0.3838,0.480806)), V((0.3953,0.481846)), ),
    16886: (V((0.2991,0.499959)), V((0.2868,0.500881)), V((0.2848,0.481846)), V((0.2963,0.480806)), ),
    16887: (V((0.4546,0.512251)), V((0.4389,0.508557)), V((0.4411,0.489977)), V((0.4571,0.495154)), ),
    16888: (V((0.2412,0.508557)), V((0.2255,0.512251)), V((0.2230,0.495154)), V((0.2390,0.489977)), ),
    16889: (V((0.3573,0.500658)), V((0.3481,0.500881)), V((0.3471,0.485114)), V((0.3568,0.484694)), ),
    16890: (V((0.3320,0.500881)), V((0.3228,0.500658)), V((0.3234,0.484694)), V((0.3330,0.485114)), ),
    16891: (V((0.5183,0.531258)), V((0.5118,0.529070)), V((0.5154,0.515013)), V((0.5224,0.517813)), ),
    16892: (V((0.1683,0.529070)), V((0.1618,0.531258)), V((0.1577,0.517813)), V((0.1647,0.515013)), ),
    16893: (V((0.4962,0.522793)), V((0.4846,0.519427)), V((0.4892,0.504664)), V((0.5002,0.509449)), ),
    16894: (V((0.1955,0.519427)), V((0.1839,0.522793)), V((0.1799,0.509449)), V((0.1909,0.504664)), ),
    16895: (V((0.3481,0.500881)), V((0.3401,0.501034)), V((0.3401,0.485152)), V((0.3471,0.485114)), ),
    16896: (V((0.3401,0.501034)), V((0.3320,0.500881)), V((0.3330,0.485114)), V((0.3401,0.485152)), ),
    16897: (V((0.4707,0.515623)), V((0.4546,0.512251)), V((0.4571,0.495154)), V((0.4753,0.499350)), ),
    16898: (V((0.2255,0.512251)), V((0.2094,0.515623)), V((0.2048,0.499350)), V((0.2230,0.495154)), ),
    16899: (V((0.3690,0.501281)), V((0.3573,0.500658)), V((0.3568,0.484694)), V((0.3746,0.479322)), ),
    16900: (V((0.3228,0.500658)), V((0.3111,0.501281)), V((0.3055,0.479322)), V((0.3234,0.484694)), ),
    16901: (V((0.5045,0.526510)), V((0.4962,0.522793)), V((0.5002,0.509449)), V((0.5074,0.512162)), ),
    16902: (V((0.1839,0.522793)), V((0.1756,0.526510)), V((0.1727,0.512162)), V((0.1799,0.509449)), ),
    16903: (V((0.5392,0.540697)), V((0.5305,0.536074)), V((0.5345,0.522261)), V((0.5451,0.529743)), ),
    16904: (V((0.1496,0.536074)), V((0.1409,0.540697)), V((0.1350,0.529743)), V((0.1456,0.522261)), ),
    16905: (V((0.5118,0.529070)), V((0.5045,0.526510)), V((0.5074,0.512162)), V((0.5154,0.515013)), ),
    16906: (V((0.1756,0.526510)), V((0.1683,0.529070)), V((0.1647,0.515013)), V((0.1727,0.512162)), ),
    16907: (V((0.3810,0.499959)), V((0.3690,0.501281)), V((0.3746,0.479322)), V((0.3838,0.480806)), ),
    16908: (V((0.3111,0.501281)), V((0.2991,0.499959)), V((0.2963,0.480806)), V((0.3055,0.479322)), ),
    16909: (V((0.5305,0.536074)), V((0.5245,0.533951)), V((0.5293,0.520056)), V((0.5345,0.522261)), ),
    16910: (V((0.1556,0.533951)), V((0.1496,0.536074)), V((0.1456,0.522261)), V((0.1509,0.520056)), ),
    16911: (V((0.4389,0.508557)), V((0.4221,0.505297)), V((0.4261,0.485438)), V((0.4411,0.489977)), ),
    16912: (V((0.2581,0.505297)), V((0.2412,0.508557)), V((0.2390,0.489977)), V((0.2540,0.485438)), ),
    16913: (V((0.4076,0.503008)), V((0.3933,0.500881)), V((0.3953,0.481846)), V((0.4095,0.483115)), ),
    16914: (V((0.2868,0.500881)), V((0.2725,0.503008)), V((0.2706,0.483115)), V((0.2848,0.481846)), ),
    16915: (V((0.4261,0.485438)), V((0.4095,0.483115)), V((0.4134,0.464845)), V((0.4298,0.468673)), ),
    16916: (V((0.2706,0.483115)), V((0.2540,0.485438)), V((0.2503,0.468673)), V((0.2667,0.464845)), ),
    16917: (V((0.5293,0.520056)), V((0.5224,0.517813)), V((0.5269,0.502742)), V((0.5330,0.506062)), ),
    16918: (V((0.1577,0.517813)), V((0.1509,0.520056)), V((0.1471,0.506062)), V((0.1532,0.502742)), ),
    16919: (V((0.4892,0.504664)), V((0.4753,0.499350)), V((0.4803,0.483738)), V((0.4939,0.489072)), ),
    16920: (V((0.2048,0.499350)), V((0.1909,0.504664)), V((0.1862,0.489072)), V((0.1999,0.483738)), ),
    16921: (V((0.3953,0.481846)), V((0.3838,0.480806)), V((0.3879,0.461313)), V((0.4000,0.462960)), ),
    16922: (V((0.2963,0.480806)), V((0.2848,0.481846)), V((0.2801,0.462960)), V((0.2922,0.461313)), ),
    16923: (V((0.4571,0.495154)), V((0.4411,0.489977)), V((0.4432,0.474481)), V((0.4616,0.480358)), ),
    16924: (V((0.2390,0.489977)), V((0.2230,0.495154)), V((0.2185,0.480358)), V((0.2369,0.474481)), ),
    16925: (V((0.3568,0.484694)), V((0.3471,0.485114)), V((0.3559,0.450188)), V((0.3705,0.459117)), ),
    16926: (V((0.3330,0.485114)), V((0.3234,0.484694)), V((0.3096,0.459117)), V((0.3286,0.456060)), ),
    16927: (V((0.5224,0.517813)), V((0.5154,0.515013)), V((0.5194,0.500168)), V((0.5269,0.502742)), ),
    16928: (V((0.1647,0.515013)), V((0.1577,0.517813)), V((0.1532,0.502742)), V((0.1607,0.500168)), ),
    16929: (V((0.5002,0.509449)), V((0.4892,0.504664)), V((0.4939,0.489072)), V((0.5045,0.494314)), ),
    16930: (V((0.1909,0.504664)), V((0.1799,0.509449)), V((0.1756,0.494314)), V((0.1862,0.489072)), ),
    16931: (V((0.3471,0.485114)), V((0.3401,0.485152)), V((0.3399,0.428728)), V((0.3559,0.450188)), ),
    16932: (V((0.3401,0.485152)), V((0.3330,0.485114)), V((0.3286,0.456060)), V((0.3399,0.428728)), ),
    16933: (V((0.4753,0.499350)), V((0.4571,0.495154)), V((0.4616,0.480358)), V((0.4803,0.483738)), ),
    16934: (V((0.2230,0.495154)), V((0.2048,0.499350)), V((0.1999,0.483738)), V((0.2185,0.480358)), ),
    16935: (V((0.3746,0.479322)), V((0.3568,0.484694)), V((0.3705,0.459117)), V((0.3799,0.460386)), ),
    16936: (V((0.3234,0.484694)), V((0.3055,0.479322)), V((0.3002,0.460386)), V((0.3096,0.459117)), ),
    16937: (V((0.5074,0.512162)), V((0.5002,0.509449)), V((0.5045,0.494314)), V((0.5128,0.497504)), ),
    16938: (V((0.1799,0.509449)), V((0.1727,0.512162)), V((0.1673,0.497504)), V((0.1756,0.494314)), ),
    16939: (V((0.5451,0.529743)), V((0.5345,0.522261)), V((0.5382,0.509145)), V((0.5522,0.517378)), ),
    16940: (V((0.1456,0.522261)), V((0.1350,0.529743)), V((0.1279,0.517378)), V((0.1419,0.509145)), ),
    16941: (V((0.5154,0.515013)), V((0.5074,0.512162)), V((0.5128,0.497504)), V((0.5194,0.500168)), ),
    16942: (V((0.1727,0.512162)), V((0.1647,0.515013)), V((0.1607,0.500168)), V((0.1673,0.497504)), ),
    16943: (V((0.3838,0.480806)), V((0.3746,0.479322)), V((0.3799,0.460386)), V((0.3879,0.461313)), ),
    16944: (V((0.3055,0.479322)), V((0.2963,0.480806)), V((0.2922,0.461313)), V((0.3002,0.460386)), ),
    16945: (V((0.5345,0.522261)), V((0.5293,0.520056)), V((0.5330,0.506062)), V((0.5382,0.509145)), ),
    16946: (V((0.1509,0.520056)), V((0.1456,0.522261)), V((0.1419,0.509145)), V((0.1471,0.506062)), ),
    16947: (V((0.4411,0.489977)), V((0.4261,0.485438)), V((0.4298,0.468673)), V((0.4432,0.474481)), ),
    16948: (V((0.2540,0.485438)), V((0.2390,0.489977)), V((0.2369,0.474481)), V((0.2503,0.468673)), ),
    16949: (V((0.4095,0.483115)), V((0.3953,0.481846)), V((0.4000,0.462960)), V((0.4134,0.464845)), ),
    16950: (V((0.2848,0.481846)), V((0.2706,0.483115)), V((0.2667,0.464845)), V((0.2801,0.462960)), ),
    16951: (V((0.5330,0.506062)), V((0.5269,0.502742)), V((0.5281,0.485901)), V((0.5340,0.491126)), ),
    16952: (V((0.1532,0.502742)), V((0.1471,0.506062)), V((0.1461,0.491126)), V((0.1520,0.485901)), ),
    16953: (V((0.4939,0.489072)), V((0.4803,0.483738)), V((0.4823,0.467396)), V((0.4958,0.470281)), ),
    16954: (V((0.1999,0.483738)), V((0.1862,0.489072)), V((0.1843,0.470281)), V((0.1978,0.467396)), ),
    16955: (V((0.4000,0.462960)), V((0.3879,0.461313)), V((0.3930,0.442497)), V((0.4062,0.444870)), ),
    16956: (V((0.2922,0.461313)), V((0.2801,0.462960)), V((0.2739,0.444870)), V((0.2871,0.442497)), ),
    16957: (V((0.4616,0.480358)), V((0.4432,0.474481)), V((0.4474,0.458700)), V((0.4649,0.464837)), ),
    16958: (V((0.2369,0.474481)), V((0.2185,0.480358)), V((0.2152,0.464837)), V((0.2327,0.458700)), ),
    16959: (V((0.3705,0.459117)), V((0.3559,0.450188)), V((0.3634,0.435687)), V((0.3765,0.440693)), ),
    16960: (V((0.3286,0.456060)), V((0.3096,0.459117)), V((0.3084,0.438517)), V((0.3208,0.435818)), ),
    16961: (V((0.5269,0.502742)), V((0.5194,0.500168)), V((0.5208,0.483803)), V((0.5281,0.485901)), ),
    16962: (V((0.1607,0.500168)), V((0.1532,0.502742)), V((0.1520,0.485901)), V((0.1593,0.483803)), ),
    16963: (V((0.5045,0.494314)), V((0.4939,0.489072)), V((0.4958,0.470281)), V((0.5070,0.475101)), ),
    16964: (V((0.1862,0.489072)), V((0.1756,0.494314)), V((0.1731,0.475101)), V((0.1843,0.470281)), ),
    16965: (V((0.3559,0.450188)), V((0.3399,0.428728)), V((0.3395,0.428787)), V((0.3634,0.435687)), ),
    16966: (V((0.3399,0.428728)), V((0.3286,0.456060)), V((0.3208,0.435818)), V((0.3395,0.428787)), ),
    16967: (V((0.4803,0.483738)), V((0.4616,0.480358)), V((0.4649,0.464837)), V((0.4823,0.467396)), ),
    16968: (V((0.2185,0.480358)), V((0.1999,0.483738)), V((0.1978,0.467396)), V((0.2152,0.464837)), ),
    16969: (V((0.3799,0.460386)), V((0.3705,0.459117)), V((0.3765,0.440693)), V((0.3844,0.441590)), ),
    16970: (V((0.3096,0.459117)), V((0.3002,0.460386)), V((0.2957,0.441590)), V((0.3084,0.438517)), ),
    16971: (V((0.5128,0.497504)), V((0.5045,0.494314)), V((0.5070,0.475101)), V((0.5177,0.480778)), ),
    16972: (V((0.1756,0.494314)), V((0.1673,0.497504)), V((0.1624,0.480778)), V((0.1731,0.475101)), ),
    16973: (V((0.5522,0.517378)), V((0.5382,0.509145)), V((0.5419,0.496116)), V((0.5582,0.508120)), ),
    16974: (V((0.1419,0.509145)), V((0.1279,0.517378)), V((0.1219,0.508120)), V((0.1382,0.496116)), ),
    16975: (V((0.5194,0.500168)), V((0.5128,0.497504)), V((0.5177,0.480778)), V((0.5208,0.483803)), ),
    16976: (V((0.1673,0.497504)), V((0.1607,0.500168)), V((0.1593,0.483803)), V((0.1624,0.480778)), ),
    16977: (V((0.3879,0.461313)), V((0.3799,0.460386)), V((0.3844,0.441590)), V((0.3930,0.442497)), ),
    16978: (V((0.3002,0.460386)), V((0.2922,0.461313)), V((0.2871,0.442497)), V((0.2957,0.441590)), ),
    16979: (V((0.5382,0.509145)), V((0.5330,0.506062)), V((0.5340,0.491126)), V((0.5419,0.496116)), ),
    16980: (V((0.1471,0.506062)), V((0.1419,0.509145)), V((0.1382,0.496116)), V((0.1461,0.491126)), ),
    16981: (V((0.4432,0.474481)), V((0.4298,0.468673)), V((0.4344,0.452746)), V((0.4474,0.458700)), ),
    16982: (V((0.2503,0.468673)), V((0.2369,0.474481)), V((0.2327,0.458700)), V((0.2457,0.452746)), ),
    16983: (V((0.4134,0.464845)), V((0.4000,0.462960)), V((0.4062,0.444870)), V((0.4205,0.448049)), ),
    16984: (V((0.2801,0.462960)), V((0.2667,0.464845)), V((0.2596,0.448049)), V((0.2739,0.444870)), ),
    16985: (V((0.4298,0.468673)), V((0.4134,0.464845)), V((0.4205,0.448049)), V((0.4344,0.452746)), ),
    16986: (V((0.2667,0.464845)), V((0.2503,0.468673)), V((0.2457,0.452746)), V((0.2596,0.448049)), ),
    16987: (V((0.1520,0.485901)), V((0.1461,0.491126)), V((0.1478,0.463404)), V((0.1506,0.461231)), ),
    16988: (V((0.4958,0.470281)), V((0.4823,0.467396)), V((0.4840,0.450322)), V((0.4979,0.452625)), ),
    16989: (V((0.1978,0.467396)), V((0.1843,0.470281)), V((0.1822,0.452625)), V((0.1961,0.450322)), ),
    16990: (V((0.4062,0.444870)), V((0.3930,0.442497)), V((0.4016,0.423308)), V((0.4118,0.426035)), ),
    16991: (V((0.2871,0.442497)), V((0.2739,0.444870)), V((0.2683,0.426035)), V((0.2785,0.423308)), ),
    16992: (V((0.4649,0.464837)), V((0.4474,0.458700)), V((0.4509,0.441995)), V((0.4681,0.447123)), ),
    16993: (V((0.2327,0.458700)), V((0.2152,0.464837)), V((0.2120,0.447123)), V((0.2293,0.441995)), ),
    16994: (V((0.3765,0.440693)), V((0.3634,0.435687)), V((0.3690,0.414521)), V((0.3811,0.420345)), ),
    16995: (V((0.3208,0.435818)), V((0.3084,0.438517)), V((0.3039,0.418170)), V((0.3152,0.414653)), ),
    16996: (V((0.5281,0.485901)), V((0.5208,0.483803)), V((0.5211,0.457394)), V((0.5296,0.461231)), ),
    16997: (V((0.1593,0.483803)), V((0.1520,0.485901)), V((0.1506,0.461231)), V((0.1590,0.457394)), ),
    16998: (V((0.5070,0.475101)), V((0.4958,0.470281)), V((0.4979,0.452625)), V((0.5083,0.454355)), ),
    16999: (V((0.1843,0.470281)), V((0.1731,0.475101)), V((0.1718,0.454355)), V((0.1822,0.452625)), ),
    17000: (V((0.3634,0.435687)), V((0.3395,0.428787)), V((0.3494,0.413419)), V((0.3690,0.414521)), ),
    17001: (V((0.3395,0.428787)), V((0.3208,0.435818)), V((0.3152,0.414653)), V((0.3385,0.414258)), ),
    17002: (V((0.4823,0.467396)), V((0.4649,0.464837)), V((0.4681,0.447123)), V((0.4840,0.450322)), ),
    17003: (V((0.2152,0.464837)), V((0.1978,0.467396)), V((0.1961,0.450322)), V((0.2120,0.447123)), ),
    17004: (V((0.3844,0.441590)), V((0.3765,0.440693)), V((0.3811,0.420345)), V((0.3894,0.422420)), ),
    17005: (V((0.3084,0.438517)), V((0.2957,0.441590)), V((0.2908,0.422420)), V((0.3039,0.418170)), ),
    17006: (V((0.5177,0.480778)), V((0.5070,0.475101)), V((0.5083,0.454355)), V((0.5169,0.461200)), ),
    17007: (V((0.1731,0.475101)), V((0.1624,0.480778)), V((0.1632,0.461200)), V((0.1718,0.454355)), ),
    17008: (V((0.5582,0.508120)), V((0.5419,0.496116)), V((0.5396,0.463648)), V((0.5503,0.471765)), ),
    17009: (V((0.1382,0.496116)), V((0.1219,0.508120)), V((0.1173,0.502567)), V((0.1406,0.463648)), ),
    17010: (V((0.5208,0.483803)), V((0.5177,0.480778)), V((0.5169,0.461200)), V((0.5211,0.457394)), ),
    17011: (V((0.1624,0.480778)), V((0.1593,0.483803)), V((0.1590,0.457394)), V((0.1632,0.461200)), ),
    17012: (V((0.3930,0.442497)), V((0.3844,0.441590)), V((0.3894,0.422420)), V((0.4016,0.423308)), ),
    17013: (V((0.2957,0.441590)), V((0.2871,0.442497)), V((0.2785,0.423308)), V((0.2908,0.422420)), ),
    17014: (V((0.5419,0.496116)), V((0.5340,0.491126)), V((0.5324,0.463404)), V((0.5396,0.463648)), ),
    17015: (V((0.1461,0.491126)), V((0.1382,0.496116)), V((0.1406,0.463648)), V((0.1478,0.463404)), ),
    17016: (V((0.4474,0.458700)), V((0.4344,0.452746)), V((0.4385,0.436683)), V((0.4509,0.441995)), ),
    17017: (V((0.2457,0.452746)), V((0.2327,0.458700)), V((0.2293,0.441995)), V((0.2416,0.436683)), ),
    17018: (V((0.4205,0.448049)), V((0.4062,0.444870)), V((0.4118,0.426035)), V((0.4253,0.430296)), ),
    17019: (V((0.2739,0.444870)), V((0.2596,0.448049)), V((0.2549,0.430296)), V((0.2683,0.426035)), ),
    17020: (V((0.4344,0.452746)), V((0.4205,0.448049)), V((0.4253,0.430296)), V((0.4385,0.436683)), ),
    17021: (V((0.2596,0.448049)), V((0.2457,0.452746)), V((0.2416,0.436683)), V((0.2549,0.430296)), ),
    17022: (V((0.5340,0.491126)), V((0.5281,0.485901)), V((0.5296,0.461231)), V((0.5324,0.463404)), ),
    17023: (V((0.4979,0.452625)), V((0.4840,0.450322)), V((0.4867,0.431442)), V((0.5006,0.433915)), ),
    17024: (V((0.1961,0.450322)), V((0.1822,0.452625)), V((0.1795,0.433915)), V((0.1934,0.431442)), ),
    17025: (V((0.4118,0.426035)), V((0.4016,0.423308)), V((0.4066,0.404588)), V((0.4166,0.407963)), ),
    17026: (V((0.2785,0.423308)), V((0.2683,0.426035)), V((0.2635,0.407963)), V((0.2735,0.404588)), ),
    17027: (V((0.4681,0.447123)), V((0.4509,0.441995)), V((0.4556,0.424700)), V((0.4707,0.428397)), ),
    17028: (V((0.2293,0.441995)), V((0.2120,0.447123)), V((0.2094,0.428397)), V((0.2245,0.424700)), ),
    17029: (V((0.3811,0.420345)), V((0.3690,0.414521)), V((0.3743,0.395636)), V((0.3875,0.401170)), ),
    17030: (V((0.3152,0.414653)), V((0.3039,0.418170)), V((0.2974,0.398994)), V((0.3099,0.395767)), ),
    17031: (V((0.5296,0.461231)), V((0.5211,0.457394)), V((0.5229,0.439189)), V((0.5258,0.441005)), ),
    17032: (V((0.1590,0.457394)), V((0.1506,0.461231)), V((0.1543,0.441005)), V((0.1572,0.439189)), ),
    17033: (V((0.5083,0.454355)), V((0.4979,0.452625)), V((0.5006,0.433915)), V((0.5102,0.435846)), ),
    17034: (V((0.1822,0.452625)), V((0.1718,0.454355)), V((0.1700,0.435846)), V((0.1795,0.433915)), ),
    17035: (V((0.3690,0.414521)), V((0.3494,0.413419)), V((0.3588,0.391126)), V((0.3743,0.395636)), ),
    17036: (V((0.3385,0.414258)), V((0.3152,0.414653)), V((0.3099,0.395767)), V((0.3336,0.396841)), ),
    17037: (V((0.4840,0.450322)), V((0.4681,0.447123)), V((0.4707,0.428397)), V((0.4867,0.431442)), ),
    17038: (V((0.2120,0.447123)), V((0.1961,0.450322)), V((0.1934,0.431442)), V((0.2094,0.428397)), ),
    17039: (V((0.3894,0.422420)), V((0.3811,0.420345)), V((0.3875,0.401170)), V((0.3998,0.403399)), ),
    17040: (V((0.3039,0.418170)), V((0.2908,0.422420)), V((0.2861,0.401302)), V((0.2974,0.398994)), ),
    17041: (V((0.5169,0.461200)), V((0.5083,0.454355)), V((0.5102,0.435846)), V((0.5154,0.437805)), ),
    17042: (V((0.1718,0.454355)), V((0.1632,0.461200)), V((0.1647,0.437805)), V((0.1700,0.435846)), ),
    17043: (V((0.5503,0.471765)), V((0.5396,0.463648)), V((0.5356,0.439300)), V((0.5529,0.434732)), ),
    17044: (V((0.1406,0.463648)), V((0.1173,0.502567)), V((0.1276,0.459535)), V((0.1445,0.439300)), ),
    17045: (V((0.5211,0.457394)), V((0.5169,0.461200)), V((0.5154,0.437805)), V((0.5229,0.439189)), ),
    17046: (V((0.1632,0.461200)), V((0.1590,0.457394)), V((0.1572,0.439189)), V((0.1647,0.437805)), ),
    17047: (V((0.4016,0.423308)), V((0.3894,0.422420)), V((0.3998,0.403399)), V((0.4066,0.404588)), ),
    17048: (V((0.2908,0.422420)), V((0.2785,0.423308)), V((0.2735,0.404588)), V((0.2861,0.401302)), ),
    17049: (V((0.5396,0.463648)), V((0.5324,0.463404)), V((0.5319,0.441023)), V((0.5356,0.439300)), ),
    17050: (V((0.1478,0.463404)), V((0.1406,0.463648)), V((0.1445,0.439300)), V((0.1482,0.441023)), ),
    17051: (V((0.4509,0.441995)), V((0.4385,0.436683)), V((0.4430,0.419791)), V((0.4556,0.424700)), ),
    17052: (V((0.2416,0.436683)), V((0.2293,0.441995)), V((0.2245,0.424700)), V((0.2372,0.419791)), ),
    17053: (V((0.4253,0.430296)), V((0.4118,0.426035)), V((0.4166,0.407963)), V((0.4298,0.413221)), ),
    17054: (V((0.2683,0.426035)), V((0.2549,0.430296)), V((0.2504,0.413221)), V((0.2635,0.407963)), ),
    17055: (V((0.4385,0.436683)), V((0.4253,0.430296)), V((0.4298,0.413221)), V((0.4430,0.419791)), ),
    17056: (V((0.2549,0.430296)), V((0.2416,0.436683)), V((0.2372,0.419791)), V((0.2504,0.413221)), ),
    17057: (V((0.5324,0.463404)), V((0.5296,0.461231)), V((0.5258,0.441005)), V((0.5319,0.441023)), ),
    17058: (V((0.1506,0.461231)), V((0.1478,0.463404)), V((0.1482,0.441023)), V((0.1543,0.441005)), ),
    17059: (V((0.1934,0.431442)), V((0.1795,0.433915)), V((0.1768,0.415608)), V((0.1915,0.413379)), ),
    17060: (V((0.4166,0.407963)), V((0.4066,0.404588)), V((0.4096,0.384642)), V((0.4214,0.389564)), ),
    17061: (V((0.2735,0.404588)), V((0.2635,0.407963)), V((0.2588,0.389564)), V((0.2706,0.384642)), ),
    17062: (V((0.4707,0.428397)), V((0.4556,0.424700)), V((0.4591,0.406808)), V((0.4740,0.410245)), ),
    17063: (V((0.2245,0.424700)), V((0.2094,0.428397)), V((0.2061,0.410245)), V((0.2210,0.406808)), ),
    17064: (V((0.3875,0.401170)), V((0.3743,0.395636)), V((0.3869,0.379814)), V((0.4017,0.383296)), ),
    17065: (V((0.3099,0.395767)), V((0.2974,0.398994)), V((0.2884,0.377844)), V((0.2994,0.373774)), ),
    17066: (V((0.5258,0.441005)), V((0.5229,0.439189)), V((0.5258,0.420393)), V((0.5283,0.421882)), ),
    17067: (V((0.1572,0.439189)), V((0.1543,0.441005)), V((0.1540,0.422150)), V((0.1543,0.420393)), ),
    17068: (V((0.5102,0.435846)), V((0.5006,0.433915)), V((0.5033,0.415608)), V((0.5129,0.417517)), ),
    17069: (V((0.1795,0.433915)), V((0.1700,0.435846)), V((0.1673,0.417517)), V((0.1768,0.415608)), ),
    17070: (V((0.3743,0.395636)), V((0.3588,0.391126)), V((0.3693,0.371327)), V((0.3869,0.379814)), ),
    17071: (V((0.3336,0.396841)), V((0.3099,0.395767)), V((0.2994,0.373774)), V((0.3201,0.368050)), ),
    17072: (V((0.4867,0.431442)), V((0.4707,0.428397)), V((0.4740,0.410245)), V((0.4886,0.413379)), ),
    17073: (V((0.2094,0.428397)), V((0.1934,0.431442)), V((0.1915,0.413379)), V((0.2061,0.410245)), ),
    17074: (V((0.3998,0.403399)), V((0.3875,0.401170)), V((0.4017,0.383296)), V((0.4077,0.384598)), ),
    17075: (V((0.2974,0.398994)), V((0.2861,0.401302)), V((0.2783,0.382501)), V((0.2884,0.377844)), ),
    17076: (V((0.5154,0.437805)), V((0.5102,0.435846)), V((0.5129,0.417517)), V((0.5184,0.418901)), ),
    17077: (V((0.1700,0.435846)), V((0.1647,0.437805)), V((0.1618,0.418901)), V((0.1673,0.417517)), ),
    17078: (V((0.5529,0.434732)), V((0.5356,0.439300)), V((0.5401,0.423589)), V((0.5488,0.422973)), ),
    17079: (V((0.1445,0.439300)), V((0.1276,0.459535)), V((0.1344,0.428454)), V((0.1464,0.425200)), ),
    17080: (V((0.5229,0.439189)), V((0.5154,0.437805)), V((0.5184,0.418901)), V((0.5258,0.420393)), ),
    17081: (V((0.1647,0.437805)), V((0.1572,0.439189)), V((0.1543,0.420393)), V((0.1618,0.418901)), ),
    17082: (V((0.4066,0.404588)), V((0.3998,0.403399)), V((0.4077,0.384598)), V((0.4096,0.384642)), ),
    17083: (V((0.2861,0.401302)), V((0.2735,0.404588)), V((0.2706,0.384642)), V((0.2783,0.382501)), ),
    17084: (V((0.5356,0.439300)), V((0.5319,0.441023)), V((0.5323,0.423659)), V((0.5401,0.423589)), ),
    17085: (V((0.1482,0.441023)), V((0.1445,0.439300)), V((0.1464,0.425200)), V((0.1478,0.423659)), ),
    17086: (V((0.4556,0.424700)), V((0.4430,0.419791)), V((0.4462,0.402473)), V((0.4591,0.406808)), ),
    17087: (V((0.2372,0.419791)), V((0.2245,0.424700)), V((0.2210,0.406808)), V((0.2339,0.402473)), ),
    17088: (V((0.4298,0.413221)), V((0.4166,0.407963)), V((0.4214,0.389564)), V((0.4349,0.395764)), ),
    17089: (V((0.2635,0.407963)), V((0.2504,0.413221)), V((0.2453,0.395764)), V((0.2588,0.389564)), ),
    17090: (V((0.4430,0.419791)), V((0.4298,0.413221)), V((0.4349,0.395764)), V((0.4462,0.402473)), ),
    17091: (V((0.2504,0.413221)), V((0.2372,0.419791)), V((0.2339,0.402473)), V((0.2453,0.395764)), ),
    17092: (V((0.5319,0.441023)), V((0.5258,0.441005)), V((0.5283,0.421882)), V((0.5323,0.423659)), ),
    17093: (V((0.1543,0.441005)), V((0.1482,0.441023)), V((0.1478,0.423659)), V((0.1540,0.422150)), ),
    17094: (V((0.5006,0.433915)), V((0.4867,0.431442)), V((0.4886,0.413379)), V((0.5033,0.415608)), ),
    17095: (V((0.4214,0.389564)), V((0.4096,0.384642)), V((0.4141,0.365640)), V((0.4263,0.370299)), ),
    17096: (V((0.2706,0.384642)), V((0.2588,0.389564)), V((0.2538,0.370299)), V((0.2660,0.365640)), ),
    17097: (V((0.4740,0.410245)), V((0.4591,0.406808)), V((0.4627,0.386835)), V((0.4782,0.391435)), ),
    17098: (V((0.2210,0.406808)), V((0.2061,0.410245)), V((0.2019,0.391435)), V((0.2174,0.386835)), ),
    17099: (V((0.4017,0.383296)), V((0.3869,0.379814)), V((0.3958,0.362560)), V((0.4067,0.364807)), ),
    17100: (V((0.2994,0.373774)), V((0.2884,0.377844)), V((0.2834,0.359355)), V((0.2949,0.355849)), ),
    17101: (V((0.5283,0.421882)), V((0.5258,0.420393)), V((0.5281,0.400760)), V((0.5300,0.404043)), ),
    17102: (V((0.1543,0.420393)), V((0.1540,0.422150)), V((0.1520,0.406996)), V((0.1520,0.400760)), ),
    17103: (V((0.5129,0.417517)), V((0.5033,0.415608)), V((0.5078,0.394138)), V((0.5163,0.396109)), ),
    17104: (V((0.1768,0.415608)), V((0.1673,0.417517)), V((0.1638,0.396109)), V((0.1723,0.394138)), ),
    17105: (V((0.3869,0.379814)), V((0.3693,0.371327)), V((0.3873,0.356676)), V((0.3958,0.362560)), ),
    17106: (V((0.3201,0.368050)), V((0.2994,0.373774)), V((0.2949,0.355849)), V((0.3022,0.352836)), ),
    17107: (V((0.4886,0.413379)), V((0.4740,0.410245)), V((0.4782,0.391435)), V((0.4914,0.392346)), ),
    17108: (V((0.2061,0.410245)), V((0.1915,0.413379)), V((0.1887,0.392346)), V((0.2019,0.391435)), ),
    17109: (V((0.4077,0.384598)), V((0.4017,0.383296)), V((0.4067,0.364807)), V((0.4106,0.366145)), ),
    17110: (V((0.2884,0.377844)), V((0.2783,0.382501)), V((0.2754,0.364048)), V((0.2834,0.359355)), ),
    17111: (V((0.5184,0.418901)), V((0.5129,0.417517)), V((0.5163,0.396109)), V((0.5219,0.401140)), ),
    17112: (V((0.1673,0.417517)), V((0.1618,0.418901)), V((0.1582,0.401140)), V((0.1638,0.396109)), ),
    17113: (V((0.5488,0.422973)), V((0.5401,0.423589)), V((0.5454,0.409889)), V((0.5595,0.406412)), ),
    17114: (V((0.1464,0.425200)), V((0.1344,0.428454)), V((0.1335,0.407078)), V((0.1473,0.411500)), ),
    17115: (V((0.5258,0.420393)), V((0.5184,0.418901)), V((0.5219,0.401140)), V((0.5281,0.400760)), ),
    17116: (V((0.1618,0.418901)), V((0.1543,0.420393)), V((0.1520,0.400760)), V((0.1582,0.401140)), ),
    17117: (V((0.4096,0.384642)), V((0.4077,0.384598)), V((0.4106,0.366145)), V((0.4141,0.365640)), ),
    17118: (V((0.2783,0.382501)), V((0.2706,0.384642)), V((0.2660,0.365640)), V((0.2754,0.364048)), ),
    17119: (V((0.5401,0.423589)), V((0.5323,0.423659)), V((0.5328,0.404605)), V((0.5454,0.409889)), ),
    17120: (V((0.1478,0.423659)), V((0.1464,0.425200)), V((0.1473,0.411500)), V((0.1473,0.404605)), ),
    17121: (V((0.4591,0.406808)), V((0.4462,0.402473)), V((0.4510,0.382354)), V((0.4627,0.386835)), ),
    17122: (V((0.2339,0.402473)), V((0.2210,0.406808)), V((0.2174,0.386835)), V((0.2292,0.382354)), ),
    17123: (V((0.4349,0.395764)), V((0.4214,0.389564)), V((0.4263,0.370299)), V((0.4398,0.376977)), ),
    17124: (V((0.2588,0.389564)), V((0.2453,0.395764)), V((0.2403,0.376977)), V((0.2538,0.370299)), ),
    17125: (V((0.4462,0.402473)), V((0.4349,0.395764)), V((0.4398,0.376977)), V((0.4510,0.382354)), ),
    17126: (V((0.2453,0.395764)), V((0.2339,0.402473)), V((0.2292,0.382354)), V((0.2403,0.376977)), ),
    17127: (V((0.5323,0.423659)), V((0.5283,0.421882)), V((0.5300,0.404043)), V((0.5328,0.404605)), ),
    17128: (V((0.1540,0.422150)), V((0.1478,0.423659)), V((0.1473,0.404605)), V((0.1520,0.406996)), ),
    17129: (V((0.5033,0.415608)), V((0.4886,0.413379)), V((0.4914,0.392346)), V((0.5078,0.394138)), ),
    17130: (V((0.1915,0.413379)), V((0.1768,0.415608)), V((0.1723,0.394138)), V((0.1887,0.392346)), ),
    17131: (V((0.4782,0.391435)), V((0.4627,0.386835)), V((0.4659,0.365188)), V((0.4809,0.367507)), ),
    17132: (V((0.2174,0.386835)), V((0.2019,0.391435)), V((0.1992,0.367507)), V((0.2142,0.365188)), ),
    17133: (V((0.4067,0.364807)), V((0.3958,0.362560)), V((0.4026,0.345482)), V((0.4080,0.353200)), ),
    17134: (V((0.2949,0.355849)), V((0.2834,0.359355)), V((0.2763,0.345231)), V((0.2815,0.347433)), ),
    17135: (V((0.5300,0.404043)), V((0.5281,0.400760)), V((0.5294,0.384681)), V((0.5333,0.387294)), ),
    17136: (V((0.1520,0.400760)), V((0.1520,0.406996)), V((0.1468,0.387294)), V((0.1464,0.384681)), ),
    17137: (V((0.5163,0.396109)), V((0.5078,0.394138)), V((0.5118,0.372170)), V((0.5214,0.373413)), ),
    17138: (V((0.1723,0.394138)), V((0.1638,0.396109)), V((0.1587,0.373413)), V((0.1683,0.372170)), ),
    17139: (V((0.3958,0.362560)), V((0.3873,0.356676)), V((0.3991,0.335944)), V((0.4026,0.345482)), ),
    17140: (V((0.3022,0.352836)), V((0.2949,0.355849)), V((0.2815,0.347433)), V((0.2935,0.334664)), ),
    17141: (V((0.4914,0.392346)), V((0.4782,0.391435)), V((0.4809,0.367507)), V((0.4964,0.369674)), ),
    17142: (V((0.2019,0.391435)), V((0.1887,0.392346)), V((0.1838,0.369674)), V((0.1992,0.367507)), ),
    17143: (V((0.4106,0.366145)), V((0.4067,0.364807)), V((0.4080,0.353200)), V((0.4125,0.345193)), ),
    17144: (V((0.2834,0.359355)), V((0.2754,0.364048)), V((0.2676,0.345193)), V((0.2763,0.345231)), ),
    17145: (V((0.5219,0.401140)), V((0.5163,0.396109)), V((0.5214,0.373413)), V((0.5271,0.376368)), ),
    17146: (V((0.1638,0.396109)), V((0.1582,0.401140)), V((0.1530,0.376368)), V((0.1587,0.373413)), ),
    17147: (V((0.5595,0.406412)), V((0.5454,0.409889)), V((0.5462,0.390661)), V((0.5657,0.384457)), ),
    17148: (V((0.1473,0.411500)), V((0.1335,0.407078)), V((0.1318,0.393059)), V((0.1466,0.391466)), ),
    17149: (V((0.5281,0.400760)), V((0.5219,0.401140)), V((0.5271,0.376368)), V((0.5294,0.384681)), ),
    17150: (V((0.1582,0.401140)), V((0.1520,0.400760)), V((0.1464,0.384681)), V((0.1530,0.376368)), ),
    17151: (V((0.4141,0.365640)), V((0.4106,0.366145)), V((0.4125,0.345193)), V((0.4227,0.348953)), ),
    17152: (V((0.2754,0.364048)), V((0.2660,0.365640)), V((0.2574,0.348953)), V((0.2676,0.345193)), ),
    17153: (V((0.5454,0.409889)), V((0.5328,0.404605)), V((0.5384,0.391568)), V((0.5462,0.390661)), ),
    17154: (V((0.1473,0.404605)), V((0.1473,0.411500)), V((0.1466,0.391466)), V((0.1473,0.396400)), ),
    17155: (V((0.4627,0.386835)), V((0.4510,0.382354)), V((0.4557,0.363394)), V((0.4659,0.365188)), ),
    17156: (V((0.2292,0.382354)), V((0.2174,0.386835)), V((0.2142,0.365188)), V((0.2244,0.363394)), ),
    17157: (V((0.4398,0.376977)), V((0.4263,0.370299)), V((0.4342,0.345397)), V((0.4441,0.353145)), ),
    17158: (V((0.2538,0.370299)), V((0.2403,0.376977)), V((0.2360,0.353145)), V((0.2459,0.345397)), ),
    17159: (V((0.4510,0.382354)), V((0.4398,0.376977)), V((0.4441,0.353145)), V((0.4557,0.363394)), ),
    17160: (V((0.2403,0.376977)), V((0.2292,0.382354)), V((0.2244,0.363394)), V((0.2360,0.353145)), ),
    17161: (V((0.5328,0.404605)), V((0.5300,0.404043)), V((0.5333,0.387294)), V((0.5384,0.391568)), ),
    17162: (V((0.1520,0.406996)), V((0.1473,0.404605)), V((0.1473,0.396400)), V((0.1468,0.387294)), ),
    17163: (V((0.5078,0.394138)), V((0.4914,0.392346)), V((0.4964,0.369674)), V((0.5118,0.372170)), ),
    17164: (V((0.1887,0.392346)), V((0.1723,0.394138)), V((0.1683,0.372170)), V((0.1838,0.369674)), ),
    17165: (V((0.4263,0.370299)), V((0.4141,0.365640)), V((0.4227,0.348953)), V((0.4342,0.345397)), ),
    17166: (V((0.2660,0.365640)), V((0.2538,0.370299)), V((0.2459,0.345397)), V((0.2574,0.348953)), ),
    17167: (V((0.4809,0.367507)), V((0.4659,0.365188)), V((0.4742,0.337879)), V((0.4859,0.341065)), ),
    17168: (V((0.2142,0.365188)), V((0.1992,0.367507)), V((0.1942,0.341065)), V((0.2059,0.337879)), ),
    17169: (V((0.4080,0.353200)), V((0.4026,0.345482)), V((0.4143,0.316540)), V((0.4188,0.317161)), ),
    17170: (V((0.2815,0.347433)), V((0.2763,0.345231)), V((0.2619,0.318000)), V((0.2700,0.317693)), ),
    17171: (V((0.5333,0.387294)), V((0.5294,0.384681)), V((0.5316,0.359600)), V((0.5340,0.358855)), ),
    17172: (V((0.1464,0.384681)), V((0.1468,0.387294)), V((0.1461,0.358855)), V((0.1485,0.359600)), ),
    17173: (V((0.5214,0.373413)), V((0.5118,0.372170)), V((0.5182,0.345133)), V((0.5289,0.348145)), ),
    17174: (V((0.1683,0.372170)), V((0.1587,0.373413)), V((0.1512,0.348145)), V((0.1619,0.345133)), ),
    17175: (V((0.4026,0.345482)), V((0.3991,0.335944)), V((0.4044,0.325006)), V((0.4143,0.316540)), ),
    17176: (V((0.2935,0.334664)), V((0.2815,0.347433)), V((0.2700,0.317693)), V((0.2847,0.314766)), ),
    17177: (V((0.4964,0.369674)), V((0.4809,0.367507)), V((0.4859,0.341065)), V((0.5024,0.343472)), ),
    17178: (V((0.1992,0.367507)), V((0.1838,0.369674)), V((0.1777,0.343472)), V((0.1942,0.341065)), ),
    17179: (V((0.4125,0.345193)), V((0.4080,0.353200)), V((0.4188,0.317161)), V((0.4250,0.319185)), ),
    17180: (V((0.2763,0.345231)), V((0.2676,0.345193)), V((0.2551,0.319185)), V((0.2619,0.318000)), ),
    17181: (V((0.5271,0.376368)), V((0.5214,0.373413)), V((0.5289,0.348145)), V((0.5319,0.354562)), ),
    17182: (V((0.1587,0.373413)), V((0.1530,0.376368)), V((0.1482,0.354562)), V((0.1512,0.348145)), ),
    17183: (V((0.5657,0.384457)), V((0.5462,0.390661)), V((0.5528,0.368865)), V((0.5741,0.362648)), ),
    17184: (V((0.1466,0.391466)), V((0.1318,0.393059)), V((0.1248,0.364925)), V((0.1313,0.365161)), ),
    17185: (V((0.5294,0.384681)), V((0.5271,0.376368)), V((0.5319,0.354562)), V((0.5316,0.359600)), ),
    17186: (V((0.1530,0.376368)), V((0.1464,0.384681)), V((0.1485,0.359600)), V((0.1482,0.354562)), ),
    17187: (V((0.4227,0.348953)), V((0.4125,0.345193)), V((0.4250,0.319185)), V((0.4334,0.324910)), ),
    17188: (V((0.2676,0.345193)), V((0.2574,0.348953)), V((0.2467,0.324910)), V((0.2551,0.319185)), ),
    17189: (V((0.5462,0.390661)), V((0.5384,0.391568)), V((0.5401,0.360387)), V((0.5528,0.368865)), ),
    17190: (V((0.1473,0.396400)), V((0.1466,0.391466)), V((0.1313,0.365161)), V((0.1361,0.360387)), ),
    17191: (V((0.4659,0.365188)), V((0.4557,0.363394)), V((0.4624,0.333400)), V((0.4742,0.337879)), ),
    17192: (V((0.2244,0.363394)), V((0.2142,0.365188)), V((0.2059,0.337879)), V((0.2177,0.333400)), ),
    17193: (V((0.4441,0.353145)), V((0.4342,0.345397)), V((0.4396,0.325303)), V((0.4487,0.327468)), ),
    17194: (V((0.2459,0.345397)), V((0.2360,0.353145)), V((0.2314,0.327468)), V((0.2405,0.325303)), ),
    17195: (V((0.4557,0.363394)), V((0.4441,0.353145)), V((0.4487,0.327468)), V((0.4624,0.333400)), ),
    17196: (V((0.2360,0.353145)), V((0.2244,0.363394)), V((0.2177,0.333400)), V((0.2314,0.327468)), ),
    17197: (V((0.5384,0.391568)), V((0.5333,0.387294)), V((0.5340,0.358855)), V((0.5401,0.360387)), ),
    17198: (V((0.1468,0.387294)), V((0.1473,0.396400)), V((0.1361,0.360387)), V((0.1461,0.358855)), ),
    17199: (V((0.5118,0.372170)), V((0.4964,0.369674)), V((0.5024,0.343472)), V((0.5182,0.345133)), ),
    17200: (V((0.1838,0.369674)), V((0.1683,0.372170)), V((0.1619,0.345133)), V((0.1777,0.343472)), ),
    17201: (V((0.4342,0.345397)), V((0.4227,0.348953)), V((0.4334,0.324910)), V((0.4396,0.325303)), ),
    17202: (V((0.2574,0.348953)), V((0.2459,0.345397)), V((0.2405,0.325303)), V((0.2467,0.324910)), ),
    17203: (V((0.4188,0.317161)), V((0.4143,0.316540)), V((0.4177,0.301455)), V((0.4247,0.311024)), ),
    17204: (V((0.2700,0.317693)), V((0.2619,0.318000)), V((0.2650,0.306829)), V((0.2709,0.303447)), ),
    17205: (V((0.5340,0.358855)), V((0.5316,0.359600)), V((0.5402,0.323046)), V((0.5426,0.325074)), ),
    17206: (V((0.1485,0.359600)), V((0.1461,0.358855)), V((0.1375,0.325074)), V((0.1399,0.323046)), ),
    17207: (V((0.5289,0.348145)), V((0.5182,0.345133)), V((0.5223,0.317249)), V((0.5342,0.317600)), ),
    17208: (V((0.1619,0.345133)), V((0.1512,0.348145)), V((0.1459,0.317600)), V((0.1578,0.317249)), ),
    17209: (V((0.4143,0.316540)), V((0.4044,0.325006)), V((0.4094,0.307717)), V((0.4177,0.301455)), ),
    17210: (V((0.2847,0.314766)), V((0.2700,0.317693)), V((0.2709,0.303447)), V((0.2782,0.300037)), ),
    17211: (V((0.5024,0.343472)), V((0.4859,0.341065)), V((0.4897,0.310574)), V((0.5067,0.314283)), ),
    17212: (V((0.1942,0.341065)), V((0.1777,0.343472)), V((0.1734,0.314283)), V((0.1904,0.310574)), ),
    17213: (V((0.4250,0.319185)), V((0.4188,0.317161)), V((0.4247,0.311024)), V((0.4261,0.307123)), ),
    17214: (V((0.2619,0.318000)), V((0.2551,0.319185)), V((0.2541,0.307123)), V((0.2650,0.306829)), ),
    17215: (V((0.5319,0.354562)), V((0.5289,0.348145)), V((0.5342,0.317600)), V((0.5427,0.322662)), ),
    17216: (V((0.1512,0.348145)), V((0.1482,0.354562)), V((0.1374,0.322662)), V((0.1459,0.317600)), ),
    17217: (V((0.5741,0.362648)), V((0.5528,0.368865)), V((0.5600,0.339495)), V((0.5728,0.342238)), ),
    17218: (V((0.1313,0.365161)), V((0.1248,0.364925)), V((0.1211,0.351125)), V((0.1211,0.335082)), ),
    17219: (V((0.5316,0.359600)), V((0.5319,0.354562)), V((0.5427,0.322662)), V((0.5402,0.323046)), ),
    17220: (V((0.1482,0.354562)), V((0.1485,0.359600)), V((0.1399,0.323046)), V((0.1374,0.322662)), ),
    17221: (V((0.4334,0.324910)), V((0.4250,0.319185)), V((0.4261,0.307123)), V((0.4370,0.307551)), ),
    17222: (V((0.2551,0.319185)), V((0.2467,0.324910)), V((0.2431,0.307551)), V((0.2541,0.307123)), ),
    17223: (V((0.5528,0.368865)), V((0.5401,0.360387)), V((0.5485,0.330100)), V((0.5600,0.339495)), ),
    17224: (V((0.1361,0.360387)), V((0.1313,0.365161)), V((0.1211,0.335082)), V((0.1251,0.329928)), ),
    17225: (V((0.4742,0.337879)), V((0.4624,0.333400)), V((0.4662,0.309603)), V((0.4776,0.309669)), ),
    17226: (V((0.2177,0.333400)), V((0.2059,0.337879)), V((0.2025,0.309669)), V((0.2140,0.309603)), ),
    17227: (V((0.4487,0.327468)), V((0.4396,0.325303)), V((0.4448,0.308948)), V((0.4533,0.304800)), ),
    17228: (V((0.2405,0.325303)), V((0.2314,0.327468)), V((0.2268,0.304800)), V((0.2354,0.308948)), ),
    17229: (V((0.4624,0.333400)), V((0.4487,0.327468)), V((0.4533,0.304800)), V((0.4662,0.309603)), ),
    17230: (V((0.2314,0.327468)), V((0.2177,0.333400)), V((0.2140,0.309603)), V((0.2268,0.304800)), ),
    17231: (V((0.5401,0.360387)), V((0.5340,0.358855)), V((0.5426,0.325074)), V((0.5485,0.330100)), ),
    17232: (V((0.1461,0.358855)), V((0.1361,0.360387)), V((0.1251,0.329928)), V((0.1375,0.325074)), ),
    17233: (V((0.5182,0.345133)), V((0.5024,0.343472)), V((0.5067,0.314283)), V((0.5223,0.317249)), ),
    17234: (V((0.1777,0.343472)), V((0.1619,0.345133)), V((0.1578,0.317249)), V((0.1734,0.314283)), ),
    17235: (V((0.4396,0.325303)), V((0.4334,0.324910)), V((0.4370,0.307551)), V((0.4448,0.308948)), ),
    17236: (V((0.2467,0.324910)), V((0.2405,0.325303)), V((0.2354,0.308948)), V((0.2431,0.307551)), ),
    17237: (V((0.4859,0.341065)), V((0.4742,0.337879)), V((0.4776,0.309669)), V((0.4897,0.310574)), ),
    17238: (V((0.2059,0.337879)), V((0.1942,0.341065)), V((0.1904,0.310574)), V((0.2025,0.309669)), ),
    17239: (V((0.4247,0.311024)), V((0.4177,0.301455)), V((0.4254,0.278375)), V((0.4295,0.285994)), ),
    17240: (V((0.2709,0.303447)), V((0.2650,0.306829)), V((0.2567,0.287776)), V((0.2615,0.281625)), ),
    17241: (V((0.5426,0.325074)), V((0.5402,0.323046)), V((0.5505,0.297138)), V((0.5532,0.298485)), ),
    17242: (V((0.1399,0.323046)), V((0.1375,0.325074)), V((0.1243,0.298216)), V((0.1296,0.297138)), ),
    17243: (V((0.5342,0.317600)), V((0.5223,0.317249)), V((0.5276,0.292572)), V((0.5424,0.296035)), ),
    17244: (V((0.1578,0.317249)), V((0.1459,0.317600)), V((0.1377,0.296035)), V((0.1525,0.292572)), ),
    17245: (V((0.4177,0.301455)), V((0.4094,0.307717)), V((0.4151,0.266784)), V((0.4254,0.278375)), ),
    17246: (V((0.2782,0.300037)), V((0.2709,0.303447)), V((0.2615,0.281625)), V((0.2718,0.276615)), ),
    17247: (V((0.5067,0.314283)), V((0.4897,0.310574)), V((0.4945,0.287913)), V((0.5108,0.290418)), ),
    17248: (V((0.1904,0.310574)), V((0.1734,0.314283)), V((0.1693,0.290418)), V((0.1856,0.287913)), ),
    17249: (V((0.4261,0.307123)), V((0.4247,0.311024)), V((0.4295,0.285994)), V((0.4343,0.290200)), ),
    17250: (V((0.2650,0.306829)), V((0.2541,0.307123)), V((0.2459,0.290200)), V((0.2567,0.287776)), ),
    17251: (V((0.5427,0.322662)), V((0.5342,0.317600)), V((0.5424,0.296035)), V((0.5487,0.293400)), ),
    17252: (V((0.1459,0.317600)), V((0.1374,0.322662)), V((0.1314,0.293400)), V((0.1377,0.296035)), ),
    17253: (V((0.5728,0.342238)), V((0.5600,0.339495)), V((0.5659,0.306416)), V((0.5711,0.315140)), ),
    17254: (V((0.1211,0.335082)), V((0.1211,0.351125)), V((0.1103,0.300982)), V((0.1152,0.295518)), ),
    17255: (V((0.5402,0.323046)), V((0.5427,0.322662)), V((0.5487,0.293400)), V((0.5505,0.297138)), ),
    17256: (V((0.1374,0.322662)), V((0.1399,0.323046)), V((0.1296,0.297138)), V((0.1314,0.293400)), ),
    17257: (V((0.4370,0.307551)), V((0.4261,0.307123)), V((0.4343,0.290200)), V((0.4399,0.281299)), ),
    17258: (V((0.2541,0.307123)), V((0.2431,0.307551)), V((0.2402,0.281299)), V((0.2459,0.290200)), ),
    17259: (V((0.5600,0.339495)), V((0.5485,0.330100)), V((0.5600,0.302658)), V((0.5659,0.306416)), ),
    17260: (V((0.1251,0.329928)), V((0.1211,0.335082)), V((0.1152,0.295518)), V((0.1175,0.293972)), ),
    17261: (V((0.4776,0.309669)), V((0.4662,0.309603)), V((0.4699,0.286300)), V((0.4824,0.284445)), ),
    17262: (V((0.2140,0.309603)), V((0.2025,0.309669)), V((0.1977,0.284445)), V((0.2102,0.286300)), ),
    17263: (V((0.4533,0.304800)), V((0.4448,0.308948)), V((0.4490,0.280671)), V((0.4587,0.277551)), ),
    17264: (V((0.2354,0.308948)), V((0.2268,0.304800)), V((0.2214,0.277551)), V((0.2311,0.280671)), ),
    17265: (V((0.4662,0.309603)), V((0.4533,0.304800)), V((0.4587,0.277551)), V((0.4699,0.286300)), ),
    17266: (V((0.2268,0.304800)), V((0.2140,0.309603)), V((0.2102,0.286300)), V((0.2214,0.277551)), ),
    17267: (V((0.5485,0.330100)), V((0.5426,0.325074)), V((0.5532,0.298485)), V((0.5600,0.302658)), ),
    17268: (V((0.1375,0.325074)), V((0.1251,0.329928)), V((0.1175,0.293972)), V((0.1243,0.298216)), ),
    17269: (V((0.5223,0.317249)), V((0.5067,0.314283)), V((0.5108,0.290418)), V((0.5276,0.292572)), ),
    17270: (V((0.1734,0.314283)), V((0.1578,0.317249)), V((0.1525,0.292572)), V((0.1693,0.290418)), ),
    17271: (V((0.4448,0.308948)), V((0.4370,0.307551)), V((0.4399,0.281299)), V((0.4490,0.280671)), ),
    17272: (V((0.2431,0.307551)), V((0.2354,0.308948)), V((0.2311,0.280671)), V((0.2402,0.281299)), ),
    17273: (V((0.4897,0.310574)), V((0.4776,0.309669)), V((0.4824,0.284445)), V((0.4945,0.287913)), ),
    17274: (V((0.2025,0.309669)), V((0.1904,0.310574)), V((0.1856,0.287913)), V((0.1977,0.284445)), ),
    17275: (V((0.4295,0.285994)), V((0.4254,0.278375)), V((0.4360,0.256793)), V((0.4445,0.252743)), ),
    17276: (V((0.2615,0.281625)), V((0.2567,0.287776)), V((0.2417,0.249073)), V((0.2554,0.259205)), ),
    17277: (V((0.5532,0.298485)), V((0.5505,0.297138)), V((0.5528,0.280410)), V((0.5584,0.280337)), ),
    17278: (V((0.1296,0.297138)), V((0.1243,0.298216)), V((0.1207,0.276310)), V((0.1273,0.280410)), ),
    17279: (V((0.5424,0.296035)), V((0.5276,0.292572)), V((0.5321,0.270931)), V((0.5422,0.274232)), ),
    17280: (V((0.1525,0.292572)), V((0.1377,0.296035)), V((0.1379,0.274232)), V((0.1480,0.270931)), ),
    17281: (V((0.4254,0.278375)), V((0.4151,0.266784)), V((0.4273,0.241347)), V((0.4360,0.256793)), ),
    17282: (V((0.2718,0.276615)), V((0.2615,0.281625)), V((0.2554,0.259205)), V((0.2709,0.263466)), ),
    17283: (V((0.5108,0.290418)), V((0.4945,0.287913)), V((0.4969,0.265224)), V((0.5146,0.267679)), ),
    17284: (V((0.1856,0.287913)), V((0.1693,0.290418)), V((0.1655,0.267679)), V((0.1832,0.265224)), ),
    17285: (V((0.4343,0.290200)), V((0.4295,0.285994)), V((0.4445,0.252743)), V((0.4484,0.252466)), ),
    17286: (V((0.2567,0.287776)), V((0.2459,0.290200)), V((0.2317,0.254143)), V((0.2417,0.249073)), ),
    17287: (V((0.5487,0.293400)), V((0.5424,0.296035)), V((0.5422,0.274232)), V((0.5508,0.280400)), ),
    17288: (V((0.1377,0.296035)), V((0.1314,0.293400)), V((0.1293,0.280400)), V((0.1379,0.274232)), ),
    17289: (V((0.5711,0.315140)), V((0.5659,0.306416)), V((0.5699,0.286742)), V((0.5766,0.292811)), ),
    17290: (V((0.1152,0.295518)), V((0.1103,0.300982)), V((0.1105,0.279097)), V((0.1137,0.279964)), ),
    17291: (V((0.5505,0.297138)), V((0.5487,0.293400)), V((0.5508,0.280400)), V((0.5528,0.280410)), ),
    17292: (V((0.1314,0.293400)), V((0.1296,0.297138)), V((0.1273,0.280410)), V((0.1293,0.280400)), ),
    17293: (V((0.4399,0.281299)), V((0.4343,0.290200)), V((0.4484,0.252466)), V((0.4544,0.248983)), ),
    17294: (V((0.2459,0.290200)), V((0.2402,0.281299)), V((0.2258,0.248983)), V((0.2317,0.254143)), ),
    17295: (V((0.5659,0.306416)), V((0.5600,0.302658)), V((0.5632,0.287011)), V((0.5699,0.286742)), ),
    17296: (V((0.1175,0.293972)), V((0.1152,0.295518)), V((0.1137,0.279964)), V((0.1167,0.278614)), ),
    17297: (V((0.4824,0.284445)), V((0.4699,0.286300)), V((0.4739,0.254658)), V((0.4890,0.261823)), ),
    17298: (V((0.2102,0.286300)), V((0.1977,0.284445)), V((0.1912,0.261822)), V((0.2062,0.254658)), ),
    17299: (V((0.4587,0.277551)), V((0.4490,0.280671)), V((0.4630,0.249605)), V((0.4663,0.252201)), ),
    17300: (V((0.2311,0.280671)), V((0.2214,0.277551)), V((0.2139,0.252201)), V((0.2171,0.249605)), ),
    17301: (V((0.4699,0.286300)), V((0.4587,0.277551)), V((0.4663,0.252201)), V((0.4739,0.254658)), ),
    17302: (V((0.2214,0.277551)), V((0.2102,0.286300)), V((0.2062,0.254658)), V((0.2139,0.252201)), ),
    17303: (V((0.5600,0.302658)), V((0.5532,0.298485)), V((0.5584,0.280337)), V((0.5632,0.287011)), ),
    17304: (V((0.1243,0.298216)), V((0.1175,0.293972)), V((0.1167,0.278614)), V((0.1207,0.276310)), ),
    17305: (V((0.5276,0.292572)), V((0.5108,0.290418)), V((0.5146,0.267679)), V((0.5321,0.270931)), ),
    17306: (V((0.1693,0.290418)), V((0.1525,0.292572)), V((0.1480,0.270931)), V((0.1655,0.267679)), ),
    17307: (V((0.4490,0.280671)), V((0.4399,0.281299)), V((0.4544,0.248983)), V((0.4630,0.249605)), ),
    17308: (V((0.2402,0.281299)), V((0.2311,0.280671)), V((0.2171,0.249605)), V((0.2258,0.248983)), ),
    17309: (V((0.4945,0.287913)), V((0.4824,0.284445)), V((0.4890,0.261823)), V((0.4969,0.265224)), ),
    17310: (V((0.1977,0.284445)), V((0.1856,0.287913)), V((0.1832,0.265224)), V((0.1912,0.261822)), ),
    17311: (V((0.5321,0.270931)), V((0.5146,0.267679)), V((0.5191,0.245115)), V((0.5367,0.248521)), ),
    17312: (V((0.1655,0.267679)), V((0.1480,0.270931)), V((0.1435,0.248521)), V((0.1611,0.245115)), ),
    17313: (V((0.4630,0.249605)), V((0.4544,0.248983)), V((0.4636,0.227700)), V((0.4694,0.223352)), ),
    17314: (V((0.2258,0.248983)), V((0.2171,0.249605)), V((0.2107,0.223352)), V((0.2165,0.227700)), ),
    17315: (V((0.4969,0.265224)), V((0.4890,0.261823)), V((0.4939,0.237683)), V((0.5002,0.240956)), ),
    17316: (V((0.1912,0.261822)), V((0.1832,0.265224)), V((0.1799,0.240956)), V((0.1862,0.237683)), ),
    17317: (V((0.4445,0.252743)), V((0.4360,0.256793)), V((0.4497,0.228217)), V((0.4561,0.228875)), ),
    17318: (V((0.2554,0.259205)), V((0.2417,0.249073)), V((0.2329,0.225205)), V((0.2429,0.225596)), ),
    17319: (V((0.5584,0.280337)), V((0.5528,0.280410)), V((0.5571,0.264609)), V((0.5603,0.269089)), ),
    17320: (V((0.1273,0.280410)), V((0.1207,0.276310)), V((0.1198,0.265997)), V((0.1229,0.263914)), ),
    17321: (V((0.5422,0.274232)), V((0.5321,0.270931)), V((0.5367,0.248521)), V((0.5518,0.252732)), ),
    17322: (V((0.1480,0.270931)), V((0.1379,0.274232)), V((0.1347,0.252463)), V((0.1435,0.248521)), ),
    17323: (V((0.4360,0.256793)), V((0.4273,0.241347)), V((0.4356,0.229449)), V((0.4497,0.228217)), ),
    17324: (V((0.2709,0.263466)), V((0.2554,0.259205)), V((0.2429,0.225596)), V((0.2579,0.229449)), ),
    17325: (V((0.5146,0.267679)), V((0.4969,0.265224)), V((0.5002,0.240956)), V((0.5191,0.245115)), ),
    17326: (V((0.1832,0.265224)), V((0.1655,0.267679)), V((0.1611,0.245115)), V((0.1799,0.240956)), ),
    17327: (V((0.4484,0.252466)), V((0.4445,0.252743)), V((0.4561,0.228875)), V((0.4620,0.223625)), ),
    17328: (V((0.2417,0.249073)), V((0.2317,0.254143)), V((0.2181,0.223625)), V((0.2329,0.225205)), ),
    17329: (V((0.5508,0.280400)), V((0.5422,0.274232)), V((0.5518,0.252732)), V((0.5525,0.257580)), ),
    17330: (V((0.1379,0.274232)), V((0.1293,0.280400)), V((0.1276,0.257580)), V((0.1347,0.252463)), ),
    17331: (V((0.5766,0.292811)), V((0.5699,0.286742)), V((0.5715,0.266406)), V((0.5786,0.276358)), ),
    17332: (V((0.1137,0.279964)), V((0.1105,0.279097)), V((0.1102,0.266102)), V((0.1143,0.264473)), ),
    17333: (V((0.5528,0.280410)), V((0.5508,0.280400)), V((0.5525,0.257580)), V((0.5571,0.264609)), ),
    17334: (V((0.1293,0.280400)), V((0.1273,0.280410)), V((0.1229,0.263914)), V((0.1276,0.257580)), ),
    17335: (V((0.4544,0.248983)), V((0.4484,0.252466)), V((0.4620,0.223625)), V((0.4636,0.227700)), ),
    17336: (V((0.2317,0.254143)), V((0.2258,0.248983)), V((0.2165,0.227700)), V((0.2181,0.223625)), ),
    17337: (V((0.5699,0.286742)), V((0.5632,0.287011)), V((0.5619,0.268621)), V((0.5715,0.266406)), ),
    17338: (V((0.1167,0.278614)), V((0.1137,0.279964)), V((0.1143,0.264473)), V((0.1161,0.263930)), ),
    17339: (V((0.4890,0.261823)), V((0.4739,0.254658)), V((0.4833,0.231792)), V((0.4939,0.237683)), ),
    17340: (V((0.2062,0.254658)), V((0.1912,0.261822)), V((0.1862,0.237683)), V((0.1968,0.231792)), ),
    17341: (V((0.4663,0.252201)), V((0.4630,0.249605)), V((0.4694,0.223352)), V((0.4741,0.235700)), ),
    17342: (V((0.2171,0.249605)), V((0.2139,0.252201)), V((0.2060,0.235700)), V((0.2107,0.223352)), ),
    17343: (V((0.4739,0.254658)), V((0.4663,0.252201)), V((0.4741,0.235700)), V((0.4833,0.231792)), ),
    17344: (V((0.2139,0.252201)), V((0.2062,0.254658)), V((0.1968,0.231792)), V((0.2060,0.235700)), ),
    17345: (V((0.5632,0.287011)), V((0.5584,0.280337)), V((0.5603,0.269089)), V((0.5619,0.268621)), ),
    17346: (V((0.1207,0.276310)), V((0.1167,0.278614)), V((0.1161,0.263930)), V((0.1198,0.265997)), ),
    17347: (V((0.4694,0.223352)), V((0.4636,0.227700)), V((0.4742,0.199829)), V((0.4772,0.197891)), ),
    17348: (V((0.2165,0.227700)), V((0.2107,0.223352)), V((0.2029,0.197891)), V((0.2059,0.199829)), ),
    17349: (V((0.5002,0.240956)), V((0.4939,0.237683)), V((0.5008,0.212451)), V((0.5059,0.215302)), ),
    17350: (V((0.1862,0.237683)), V((0.1799,0.240956)), V((0.1742,0.215302)), V((0.1793,0.212451)), ),
    17351: (V((0.4561,0.228875)), V((0.4497,0.228217)), V((0.4566,0.197539)), V((0.4613,0.200370)), ),
    17352: (V((0.2429,0.225596)), V((0.2329,0.225205)), V((0.2151,0.203830)), V((0.2172,0.198587)), ),
    17353: (V((0.5603,0.269089)), V((0.5571,0.264609)), V((0.5600,0.245991)), V((0.5624,0.250800)), ),
    17354: (V((0.1229,0.263914)), V((0.1198,0.265997)), V((0.1177,0.250800)), V((0.1201,0.245991)), ),
    17355: (V((0.5518,0.252732)), V((0.5367,0.248521)), V((0.5400,0.221920)), V((0.5552,0.229237)), ),
    17356: (V((0.1435,0.248521)), V((0.1347,0.252463)), V((0.1308,0.224673)), V((0.1402,0.221920)), ),
    17357: (V((0.4497,0.228217)), V((0.4356,0.229449)), V((0.4358,0.201091)), V((0.4566,0.197539)), ),
    17358: (V((0.2579,0.229449)), V((0.2429,0.225596)), V((0.2172,0.198587)), V((0.2309,0.195479)), ),
    17359: (V((0.5191,0.245115)), V((0.5002,0.240956)), V((0.5059,0.215302)), V((0.5232,0.218730)), ),
    17360: (V((0.1799,0.240956)), V((0.1611,0.245115)), V((0.1569,0.218730)), V((0.1742,0.215302)), ),
    17361: (V((0.4620,0.223625)), V((0.4561,0.228875)), V((0.4613,0.200370)), V((0.4700,0.200221)), ),
    17362: (V((0.2329,0.225205)), V((0.2181,0.223625)), V((0.2101,0.200221)), V((0.2151,0.203830)), ),
    17363: (V((0.5525,0.257580)), V((0.5518,0.252732)), V((0.5552,0.229237)), V((0.5551,0.235369)), ),
    17364: (V((0.1347,0.252463)), V((0.1276,0.257580)), V((0.1229,0.236711)), V((0.1308,0.224673)), ),
    17365: (V((0.5786,0.276358)), V((0.5715,0.266406)), V((0.5729,0.251444)), V((0.5802,0.260506)), ),
    17366: (V((0.1143,0.264473)), V((0.1102,0.266102)), V((0.1091,0.251832)), V((0.1123,0.247445)), ),
    17367: (V((0.5571,0.264609)), V((0.5525,0.257580)), V((0.5551,0.235369)), V((0.5600,0.245991)), ),
    17368: (V((0.1276,0.257580)), V((0.1229,0.263914)), V((0.1201,0.245991)), V((0.1229,0.236711)), ),
    17369: (V((0.4636,0.227700)), V((0.4620,0.223625)), V((0.4700,0.200221)), V((0.4742,0.199829)), ),
    17370: (V((0.2181,0.223625)), V((0.2165,0.227700)), V((0.2059,0.199829)), V((0.2101,0.200221)), ),
    17371: (V((0.5715,0.266406)), V((0.5619,0.268621)), V((0.5680,0.251659)), V((0.5729,0.251444)), ),
    17372: (V((0.1161,0.263930)), V((0.1143,0.264473)), V((0.1123,0.247445)), V((0.1151,0.250644)), ),
    17373: (V((0.4939,0.237683)), V((0.4833,0.231792)), V((0.4923,0.206973)), V((0.5008,0.212451)), ),
    17374: (V((0.1968,0.231792)), V((0.1862,0.237683)), V((0.1793,0.212451)), V((0.1878,0.206973)), ),
    17375: (V((0.4741,0.235700)), V((0.4694,0.223352)), V((0.4772,0.197891)), V((0.4846,0.200402)), ),
    17376: (V((0.2107,0.223352)), V((0.2060,0.235700)), V((0.1955,0.200402)), V((0.2029,0.197891)), ),
    17377: (V((0.4833,0.231792)), V((0.4741,0.235700)), V((0.4846,0.200402)), V((0.4923,0.206973)), ),
    17378: (V((0.2060,0.235700)), V((0.1968,0.231792)), V((0.1878,0.206973)), V((0.1955,0.200402)), ),
    17379: (V((0.5619,0.268621)), V((0.5603,0.269089)), V((0.5624,0.250800)), V((0.5680,0.251659)), ),
    17380: (V((0.1198,0.265997)), V((0.1161,0.263930)), V((0.1151,0.250644)), V((0.1177,0.250800)), ),
    17381: (V((0.5367,0.248521)), V((0.5191,0.245115)), V((0.5232,0.218730)), V((0.5400,0.221920)), ),
    17382: (V((0.1611,0.245115)), V((0.1435,0.248521)), V((0.1402,0.221920)), V((0.1569,0.218730)), ),
    17383: (V((0.4772,0.197891)), V((0.4742,0.199829)), V((0.4990,0.091298)), V((0.5087,0.101583)), ),
    17384: (V((0.2059,0.199829)), V((0.2029,0.197891)), V((0.1670,0.098282)), V((0.1769,0.088007)), ),
    17385: (V((0.5059,0.215302)), V((0.5008,0.212451)), V((0.5246,0.162418)), V((0.5272,0.167067)), ),
    17386: (V((0.1793,0.212451)), V((0.1742,0.215302)), V((0.1487,0.163786)), V((0.1513,0.159118)), ),
    17387: (V((0.4613,0.200370)), V((0.4566,0.197539)), V((0.4858,0.067900)), V((0.4917,0.073800)), ),
    17388: (V((0.2172,0.198587)), V((0.2151,0.203830)), V((0.1842,0.070500)), V((0.1901,0.064600)), ),
    17389: (V((0.5624,0.250800)), V((0.5600,0.245991)), V((0.5566,0.216435)), V((0.5635,0.205700)), ),
    17390: (V((0.1201,0.245991)), V((0.1177,0.250800)), V((0.1151,0.215661)), V((0.1192,0.218582)), ),
    17391: (V((0.5552,0.229237)), V((0.5400,0.221920)), V((0.5515,0.185213)), V((0.5589,0.192799)), ),
    17392: (V((0.1402,0.221920)), V((0.1308,0.224673)), V((0.1218,0.188956)), V((0.1244,0.181960)), ),
    17393: (V((0.4566,0.197539)), V((0.4358,0.201091)), V((0.4405,0.171859)), V((0.4858,0.067900)), ),
    17394: (V((0.2309,0.195479)), V((0.2172,0.198587)), V((0.1901,0.064600)), V((0.2216,0.173203)), ),
    17395: (V((0.5232,0.218730)), V((0.5059,0.215302)), V((0.5272,0.167067)), V((0.5382,0.175971)), ),
    17396: (V((0.1742,0.215302)), V((0.1569,0.218730)), V((0.1377,0.172702)), V((0.1487,0.163786)), ),
    17397: (V((0.4700,0.200221)), V((0.4613,0.200370)), V((0.4917,0.073800)), V((0.4965,0.081466)), ),
    17398: (V((0.2151,0.203830)), V((0.2101,0.200221)), V((0.1794,0.078166)), V((0.1842,0.070500)), ),
    17399: (V((0.5551,0.235369)), V((0.5552,0.229237)), V((0.5589,0.192799)), V((0.5526,0.211546)), ),
    17400: (V((0.1308,0.224673)), V((0.1229,0.236711)), V((0.1227,0.209130)), V((0.1218,0.188956)), ),
    17401: (V((0.5802,0.260506)), V((0.5729,0.251444)), V((0.5767,0.236151)), V((0.5863,0.234221)), ),
    17402: (V((0.1123,0.247445)), V((0.1091,0.251832)), V((0.1050,0.221583)), V((0.1085,0.217784)), ),
    17403: (V((0.5600,0.245991)), V((0.5551,0.235369)), V((0.5526,0.211546)), V((0.5566,0.216435)), ),
    17404: (V((0.1229,0.236711)), V((0.1201,0.245991)), V((0.1192,0.218582)), V((0.1227,0.209130)), ),
    17405: (V((0.4742,0.199829)), V((0.4700,0.200221)), V((0.4965,0.081466)), V((0.4990,0.091298)), ),
    17406: (V((0.2101,0.200221)), V((0.2059,0.199829)), V((0.1769,0.088007)), V((0.1794,0.078166)), ),
    17407: (V((0.5729,0.251444)), V((0.5680,0.251659)), V((0.5681,0.228420)), V((0.5767,0.236151)), ),
    17408: (V((0.1151,0.250644)), V((0.1123,0.247445)), V((0.1085,0.217784)), V((0.1128,0.215557)), ),
    17409: (V((0.5008,0.212451)), V((0.4923,0.206973)), V((0.4938,0.193500)), V((0.5246,0.162418)), ),
    17410: (V((0.1878,0.206973)), V((0.1793,0.212451)), V((0.1513,0.159118)), V((0.1615,0.159946)), ),
    17411: (V((0.4846,0.200402)), V((0.4772,0.197891)), V((0.5087,0.101583)), V((0.5153,0.148926)), ),
    17412: (V((0.2029,0.197891)), V((0.1955,0.200402)), V((0.1709,0.139966)), V((0.1670,0.098282)), ),
    17413: (V((0.4923,0.206973)), V((0.4846,0.200402)), V((0.5153,0.148926)), V((0.4938,0.193500)), ),
    17414: (V((0.1955,0.200402)), V((0.1878,0.206973)), V((0.1615,0.159946)), V((0.1709,0.139966)), ),
    17415: (V((0.5680,0.251659)), V((0.5624,0.250800)), V((0.5635,0.205700)), V((0.5681,0.228420)), ),
    17416: (V((0.1177,0.250800)), V((0.1151,0.250644)), V((0.1128,0.215557)), V((0.1151,0.215661)), ),
    17417: (V((0.5400,0.221920)), V((0.5232,0.218730)), V((0.5382,0.175971)), V((0.5515,0.185213)), ),
    17418: (V((0.1569,0.218730)), V((0.1402,0.221920)), V((0.1244,0.181960)), V((0.1377,0.172702)), ),
    17419: (V((0.5272,0.167067)), V((0.5246,0.162418)), V((0.5313,0.142608)), V((0.5386,0.150497)), ),
    17420: (V((0.1513,0.159118)), V((0.1487,0.163786)), V((0.1373,0.147255)), V((0.1446,0.139354)), ),
    17421: (V((0.4917,0.073800)), V((0.4858,0.067900)), V((0.4774,0.070521)), V((0.4858,0.067900)), ),
    17422: (V((0.1901,0.064600)), V((0.1842,0.070500)), V((0.1901,0.064600)), V((0.1901,0.064600)), ),
    17423: (V((0.5635,0.205700)), V((0.5566,0.216435)), V((0.5674,0.182221)), V((0.5707,0.182400)), ),
    17424: (V((0.1192,0.218582)), V((0.1151,0.215661)), V((0.1082,0.184737)), V((0.1085,0.178921)), ),
    17425: (V((0.5589,0.192799)), V((0.5515,0.185213)), V((0.5638,0.169189)), V((0.5679,0.176111)), ),
    17426: (V((0.1244,0.181960)), V((0.1218,0.188956)), V((0.1080,0.172811)), V((0.1121,0.165891)), ),
    17427: (V((0.4858,0.067900)), V((0.4405,0.171859)), V((0.4493,0.122486)), V((0.4774,0.070521)), ),
    17428: (V((0.2216,0.173203)), V((0.1901,0.064600)), V((0.1901,0.064600)), V((0.1989,0.080467)), ),
    17429: (V((0.5382,0.175971)), V((0.5272,0.167067)), V((0.5386,0.150497)), V((0.5493,0.160119)), ),
    17430: (V((0.1487,0.163786)), V((0.1377,0.172702)), V((0.1266,0.156862)), V((0.1373,0.147255)), ),
    17431: (V((0.4965,0.081466)), V((0.4917,0.073800)), V((0.4858,0.067900)), V((0.4891,0.073037)), ),
    17432: (V((0.1842,0.070500)), V((0.1794,0.078166)), V((0.1868,0.069737)), V((0.1901,0.064600)), ),
    17433: (V((0.5526,0.211546)), V((0.5589,0.192799)), V((0.5679,0.176111)), V((0.5666,0.179600)), ),
    17434: (V((0.1218,0.188956)), V((0.1227,0.209130)), V((0.1093,0.176300)), V((0.1080,0.172811)), ),
    17435: (V((0.5863,0.234221)), V((0.5767,0.236151)), V((0.5707,0.182400)), V((0.5875,0.205745)), ),
    17436: (V((0.1085,0.217784)), V((0.1050,0.221583)), V((0.1068,0.212892)), V((0.1087,0.212386)), ),
    17437: (V((0.5566,0.216435)), V((0.5526,0.211546)), V((0.5666,0.179600)), V((0.5674,0.182221)), ),
    17438: (V((0.1227,0.209130)), V((0.1192,0.218582)), V((0.1085,0.178921)), V((0.1093,0.176300)), ),
    17439: (V((0.4990,0.091298)), V((0.4965,0.081466)), V((0.4891,0.073037)), V((0.4971,0.078051)), ),
    17440: (V((0.1794,0.078166)), V((0.1769,0.088007)), V((0.1787,0.074751)), V((0.1868,0.069737)), ),
    17441: (V((0.5767,0.236151)), V((0.5681,0.228420)), V((0.5707,0.182400)), V((0.5707,0.182400)), ),
    17442: (V((0.1128,0.215557)), V((0.1085,0.217784)), V((0.1087,0.212386)), V((0.1119,0.211312)), ),
    17443: (V((0.5246,0.162418)), V((0.4938,0.193500)), V((0.5260,0.136668)), V((0.5313,0.142608)), ),
    17444: (V((0.1615,0.159946)), V((0.1513,0.159118)), V((0.1446,0.139354)), V((0.1499,0.133368)), ),
    17445: (V((0.5153,0.148926)), V((0.5087,0.101583)), V((0.5008,0.083223)), V((0.5089,0.095415)), ),
    17446: (V((0.1670,0.098282)), V((0.1709,0.139966)), V((0.1669,0.092115)), V((0.1750,0.079989)), ),
    17447: (V((0.4938,0.193500)), V((0.5153,0.148926)), V((0.5089,0.095415)), V((0.5260,0.136668)), ),
    17448: (V((0.1709,0.139966)), V((0.1615,0.159946)), V((0.1499,0.133368)), V((0.1669,0.092115)), ),
    17449: (V((0.5681,0.228420)), V((0.5635,0.205700)), V((0.5707,0.182400)), V((0.5707,0.182400)), ),
    17450: (V((0.1151,0.215661)), V((0.1128,0.215557)), V((0.1119,0.211312)), V((0.1082,0.184737)), ),
    17451: (V((0.5515,0.185213)), V((0.5382,0.175971)), V((0.5493,0.160119)), V((0.5638,0.169189)), ),
    17452: (V((0.1377,0.172702)), V((0.1244,0.181960)), V((0.1121,0.165891)), V((0.1266,0.156862)), ),
    17453: (V((0.5087,0.101583)), V((0.4990,0.091298)), V((0.4971,0.078051)), V((0.5008,0.083223)), ),
    17454: (V((0.1769,0.088007)), V((0.1670,0.098282)), V((0.1750,0.079989)), V((0.1787,0.074751)), ),
    17455: (V((0.6939,0.348000)), V((0.7077,0.348000)), V((0.7117,0.364177)), V((0.6942,0.353735)), ),
    17456: (V((0.7117,0.364177)), V((0.7077,0.348000)), V((0.7256,0.348972)), V((0.7284,0.369874)), ),
    17457: (V((0.7284,0.369874)), V((0.7256,0.348972)), V((0.7419,0.349553)), V((0.7435,0.373936)), ),
    17458: (V((0.7435,0.373936)), V((0.7419,0.349553)), V((0.7607,0.349685)), V((0.7616,0.380163)), ),
    17459: (V((0.7616,0.380163)), V((0.7607,0.349685)), V((0.7914,0.348664)), V((0.7902,0.385672)), ),
    17460: (V((0.7902,0.385672)), V((0.7914,0.348664)), V((0.8329,0.353842)), V((0.8344,0.394286)), ),
    17461: (V((0.8344,0.394286)), V((0.8329,0.353842)), V((0.8745,0.353706)), V((0.8824,0.387246)), ),
    17462: (V((0.8824,0.387246)), V((0.8745,0.353706)), V((0.9374,0.356251)), V((0.9419,0.383228)), ),
    17463: (V((0.6900,0.349339)), V((0.7117,0.364844)), V((0.7106,0.378446)), V((0.6847,0.350741)), ),
    17464: (V((0.7106,0.378446)), V((0.7117,0.364844)), V((0.7286,0.370556)), V((0.7272,0.390340)), ),
    17465: (V((0.7272,0.390340)), V((0.7286,0.370556)), V((0.7438,0.374570)), V((0.7429,0.402124)), ),
    17466: (V((0.7429,0.402124)), V((0.7438,0.374570)), V((0.7626,0.382108)), V((0.7614,0.411773)), ),
    17467: (V((0.7614,0.411773)), V((0.7626,0.382108)), V((0.7908,0.387170)), V((0.7909,0.421414)), ),
    17468: (V((0.7909,0.421414)), V((0.7908,0.387170)), V((0.8340,0.394332)), V((0.8422,0.427415)), ),
    17469: (V((0.8422,0.427415)), V((0.8340,0.394332)), V((0.8818,0.387792)), V((0.8959,0.419947)), ),
    17470: (V((0.8959,0.419947)), V((0.8818,0.387792)), V((0.9435,0.380546)), V((0.9407,0.405908)), ),
    17471: (V((0.6706,0.351667)), V((0.6996,0.394713)), V((0.6854,0.412398)), V((0.6522,0.370892)), ),
    17472: (V((0.6854,0.412398)), V((0.6996,0.394713)), V((0.7181,0.407634)), V((0.6965,0.432625)), ),
    17473: (V((0.6965,0.432625)), V((0.7181,0.407634)), V((0.7338,0.420419)), V((0.7157,0.451348)), ),
    17474: (V((0.7157,0.451348)), V((0.7338,0.420419)), V((0.7528,0.432440)), V((0.7352,0.469311)), ),
    17475: (V((0.7352,0.469311)), V((0.7528,0.432440)), V((0.7912,0.454959)), V((0.7973,0.502680)), ),
    17476: (V((0.7973,0.502680)), V((0.7912,0.454959)), V((0.8470,0.466553)), V((0.8262,0.499333)), ),
    17477: (V((0.8262,0.499333)), V((0.8470,0.466553)), V((0.8947,0.458885)), V((0.9002,0.500652)), ),
    17478: (V((0.9002,0.500652)), V((0.8947,0.458885)), V((0.9606,0.455931)), V((0.9252,0.490649)), ),
    17479: (V((0.3545,0.847283)), V((0.3523,0.840377)), V((0.3741,0.782334)), V((0.3958,0.784036)), ),
    17480: (V((0.3958,0.784036)), V((0.3741,0.782334)), V((0.3657,0.752959)), V((0.3839,0.754518)), ),
    17481: (V((0.3839,0.754518)), V((0.3657,0.752959)), V((0.3573,0.724255)), V((0.3783,0.725692)), ),
    17482: (V((0.3783,0.725692)), V((0.3573,0.724255)), V((0.3512,0.698350)), V((0.3735,0.698317)), ),
    17483: (V((0.3735,0.698317)), V((0.3512,0.698350)), V((0.3481,0.675959)), V((0.3729,0.679562)), ),
    17484: (V((0.3729,0.679562)), V((0.3481,0.675959)), V((0.3480,0.651159)), V((0.3693,0.650863)), ),
    17485: (V((0.3693,0.650863)), V((0.3480,0.651159)), V((0.3466,0.626769)), V((0.3686,0.627048)), ),
    17486: (V((0.6826,0.348000)), V((0.7096,0.378771)), V((0.7007,0.393752)), V((0.6726,0.349960)), ),
    17487: (V((0.7007,0.393752)), V((0.7096,0.378771)), V((0.7273,0.390822)), V((0.7184,0.407283)), ),
    17488: (V((0.7184,0.407283)), V((0.7273,0.390822)), V((0.7423,0.400210)), V((0.7354,0.420400)), ),
    17489: (V((0.7354,0.420400)), V((0.7423,0.400210)), V((0.7607,0.411681)), V((0.7525,0.432841)), ),
    17490: (V((0.7525,0.432841)), V((0.7607,0.411681)), V((0.7924,0.423069)), V((0.7925,0.453387)), ),
    17491: (V((0.7925,0.453387)), V((0.7924,0.423069)), V((0.8416,0.427967)), V((0.8479,0.464646)), ),
    17492: (V((0.8479,0.464646)), V((0.8416,0.427967)), V((0.8973,0.422141)), V((0.8960,0.459243)), ),
    17493: (V((0.8960,0.459243)), V((0.8973,0.422141)), V((0.9420,0.409308)), V((0.9417,0.440833)), ),
    17494: (V((0.6540,0.371606)), V((0.6856,0.414465)), V((0.6701,0.433587)), V((0.6525,0.388892)), ),
    17495: (V((0.6701,0.433587)), V((0.6856,0.414465)), V((0.6956,0.433813)), V((0.6792,0.457368)), ),
    17496: (V((0.6792,0.457368)), V((0.6956,0.433813)), V((0.7140,0.451477)), V((0.6894,0.477423)), ),
    17497: (V((0.6894,0.477423)), V((0.7140,0.451477)), V((0.7345,0.468950)), V((0.7066,0.499920)), ),
    17498: (V((0.7066,0.499920)), V((0.7345,0.468950)), V((0.7975,0.502784)), V((0.7297,0.538036)), ),
    17499: (V((0.7297,0.538036)), V((0.7975,0.502784)), V((0.8366,0.499180)), V((0.7563,0.594016)), ),
    17500: (V((0.3740,0.850953)), V((0.3744,0.835970)), V((0.3647,0.844864)), V((0.3678,0.872916)), ),
    17501: (V((0.3678,0.872916)), V((0.3647,0.844864)), V((0.3546,0.848146)), V((0.3538,0.860547)), ),
    17502: (V((0.3538,0.860547)), V((0.3546,0.848146)), V((0.3976,0.782588)), V((0.4193,0.789780)), ),
    17503: (V((0.4193,0.789780)), V((0.3976,0.782588)), V((0.3851,0.755992)), V((0.4137,0.758217)), ),
    17504: (V((0.4137,0.758217)), V((0.3851,0.755992)), V((0.3804,0.725681)), V((0.4056,0.724158)), ),
    17505: (V((0.4056,0.724158)), V((0.3804,0.725681)), V((0.3762,0.696265)), V((0.3978,0.694866)), ),
    17506: (V((0.3978,0.694866)), V((0.3762,0.696265)), V((0.3748,0.677568)), V((0.3935,0.679735)), ),
    17507: (V((0.3935,0.679735)), V((0.3748,0.677568)), V((0.3721,0.649416)), V((0.3933,0.645014)), ),
    17508: (V((0.3933,0.645014)), V((0.3721,0.649416)), V((0.3707,0.625942)), V((0.3944,0.623371)), ),
    17509: (V((0.6371,0.310472)), V((0.6691,0.434713)), V((0.6579,0.443175)), V((0.6292,0.297396)), ),
    17510: (V((0.6579,0.443175)), V((0.6691,0.434713)), V((0.6781,0.457381)), V((0.6568,0.475785)), ),
    17511: (V((0.6568,0.475785)), V((0.6781,0.457381)), V((0.6896,0.477584)), V((0.6634,0.499239)), ),
    17512: (V((0.6634,0.499239)), V((0.6896,0.477584)), V((0.7073,0.501779)), V((0.6712,0.525888)), ),
    17513: (V((0.6712,0.525888)), V((0.7073,0.501779)), V((0.7291,0.539795)), V((0.6868,0.557029)), ),
    17514: (V((0.6868,0.557029)), V((0.7291,0.539795)), V((0.7555,0.594636)), V((0.7211,0.613153)), ),
    17515: (V((0.3694,0.895396)), V((0.3559,0.884739)), V((0.3707,0.875767)), V((0.3769,0.884668)), ),
    17516: (V((0.3769,0.884668)), V((0.3707,0.875767)), V((0.3623,0.889790)), V((0.3708,0.886006)), ),
    17517: (V((0.4032,0.887670)), V((0.3623,0.889790)), V((0.4484,0.836381)), V((0.4379,0.863026)), ),
    17518: (V((0.4379,0.863026)), V((0.4484,0.836381)), V((0.4695,0.848105)), V((0.4596,0.873503)), ),
    17519: (V((0.4596,0.873503)), V((0.4695,0.848105)), V((0.4913,0.862459)), V((0.4844,0.881875)), ),
    17520: (V((0.5045,0.695981)), V((0.4857,0.697614)), V((0.4842,0.678578)), V((0.4990,0.668866)), ),
    17521: (V((0.4990,0.668866)), V((0.4842,0.678578)), V((0.4752,0.644440)), V((0.4924,0.641732)), ),
    17522: (V((0.4924,0.641732)), V((0.4752,0.644440)), V((0.4655,0.598929)), V((0.4916,0.611070)), ),
    17523: (V((0.4916,0.611070)), V((0.4655,0.598929)), V((0.4683,0.572204)), V((0.4904,0.575153)), ),
    17524: (V((0.6197,0.281676)), V((0.6338,0.453132)), V((0.6088,0.248049)), V((0.6160,0.272383)), ),
    17525: (V((0.6088,0.248049)), V((0.6338,0.453132)), V((0.6321,0.477926)), V((0.6036,0.218308)), ),
    17526: (V((0.6036,0.218308)), V((0.6321,0.477926)), V((0.6368,0.505584)), V((0.6042,0.185645)), ),
    17527: (V((0.6042,0.185645)), V((0.6368,0.505584)), V((0.6398,0.536747)), V((0.6114,0.151733)), ),
    17528: (V((0.6114,0.151733)), V((0.6398,0.536747)), V((0.6563,0.573256)), V((0.6278,0.109528)), ),
    17529: (V((0.6278,0.109528)), V((0.6563,0.573256)), V((0.6966,0.627946)), V((0.6827,0.510643)), ),
    17530: (V((0.3561,0.898269)), V((0.3786,0.901044)), V((0.3839,0.887286)), V((0.3679,0.892304)), ),
    17531: (V((0.3679,0.892304)), V((0.3839,0.887286)), V((0.3779,0.883927)), V((0.3660,0.886695)), ),
    17532: (V((0.4027,0.887121)), V((0.4029,0.887333)), V((0.4269,0.885137)), V((0.4178,0.906498)), ),
    17533: (V((0.4178,0.906498)), V((0.4269,0.885137)), V((0.4486,0.900824)), V((0.4426,0.914391)), ),
    17534: (V((0.4426,0.914391)), V((0.4486,0.900824)), V((0.4750,0.911297)), V((0.4580,0.918045)), ),
    17535: (V((0.5335,0.705289)), V((0.5188,0.696917)), V((0.5169,0.664804)), V((0.5302,0.663373)), ),
    17536: (V((0.5302,0.663373)), V((0.5169,0.664804)), V((0.5120,0.637065)), V((0.5246,0.634413)), ),
    17537: (V((0.5246,0.634413)), V((0.5120,0.637065)), V((0.5087,0.610805)), V((0.5194,0.607079)), ),
    17538: (V((0.5194,0.607079)), V((0.5087,0.610805)), V((0.5104,0.582849)), V((0.5207,0.585400)), ),
    17539: (V((0.6288,0.296649)), V((0.6572,0.444226)), V((0.6342,0.452504)), V((0.6205,0.282889)), ),
    17540: (V((0.6342,0.452504)), V((0.6572,0.444226)), V((0.6563,0.475601)), V((0.6328,0.477591)), ),
    17541: (V((0.6328,0.477591)), V((0.6563,0.475601)), V((0.6623,0.499468)), V((0.6376,0.504437)), ),
    17542: (V((0.6376,0.504437)), V((0.6623,0.499468)), V((0.6707,0.526008)), V((0.6403,0.534765)), ),
    17543: (V((0.6403,0.534765)), V((0.6707,0.526008)), V((0.6870,0.558272)), V((0.6561,0.571153)), ),
    17544: (V((0.6561,0.571153)), V((0.6870,0.558272)), V((0.7187,0.614283)), V((0.6969,0.627437)), ),
    17545: (V((0.3785,0.900962)), V((0.3703,0.895984)), V((0.3770,0.883702)), V((0.3826,0.889273)), ),
    17546: (V((0.3826,0.889273)), V((0.3770,0.883702)), V((0.3864,0.884686)), V((0.3905,0.889609)), ),
    17547: (V((0.4028,0.887268)), V((0.4019,0.886389)), V((0.4365,0.863526)), V((0.4273,0.884621)), ),
    17548: (V((0.4273,0.884621)), V((0.4365,0.863526)), V((0.4598,0.873635)), V((0.4492,0.899945)), ),
    17549: (V((0.4492,0.899945)), V((0.4598,0.873635)), V((0.4833,0.882735)), V((0.4749,0.911124)), ),
    17550: (V((0.5204,0.698725)), V((0.5052,0.695964)), V((0.4983,0.669666)), V((0.5162,0.665058)), ),
    17551: (V((0.5162,0.665058)), V((0.4983,0.669666)), V((0.4936,0.641362)), V((0.5128,0.637520)), ),
    17552: (V((0.5128,0.637520)), V((0.4936,0.641362)), V((0.4924,0.611339)), V((0.5086,0.610838)), ),
    17553: (V((0.5086,0.610838)), V((0.4924,0.611339)), V((0.4917,0.575657)), V((0.5102,0.583316)), ),
    17554: (V((0.6939,0.348000)), V((0.6942,0.342265)), V((0.7117,0.331823)), V((0.7077,0.348000)), ),
    17555: (V((0.7117,0.331823)), V((0.7284,0.326104)), V((0.7256,0.347028)), V((0.7077,0.348000)), ),
    17556: (V((0.7284,0.326104)), V((0.7435,0.322064)), V((0.7419,0.346424)), V((0.7256,0.347028)), ),
    17557: (V((0.7435,0.322064)), V((0.7616,0.315748)), V((0.7607,0.346315)), V((0.7419,0.346424)), ),
    17558: (V((0.7616,0.315748)), V((0.7902,0.310328)), V((0.7914,0.347336)), V((0.7607,0.346315)), ),
    17559: (V((0.7902,0.310328)), V((0.8344,0.301714)), V((0.8329,0.342158)), V((0.7914,0.347336)), ),
    17560: (V((0.8344,0.301714)), V((0.8824,0.308690)), V((0.8745,0.342292)), V((0.8329,0.342158)), ),
    17561: (V((0.8824,0.308690)), V((0.9419,0.312772)), V((0.9374,0.339749)), V((0.8745,0.342292)), ),
    17562: (V((0.6900,0.346661)), V((0.6847,0.345259)), V((0.7106,0.317522)), V((0.7117,0.331156)), ),
    17563: (V((0.7106,0.317522)), V((0.7272,0.305660)), V((0.7286,0.325423)), V((0.7117,0.331156)), ),
    17564: (V((0.7272,0.305660)), V((0.7429,0.293876)), V((0.7438,0.321430)), V((0.7286,0.325423)), ),
    17565: (V((0.7429,0.293876)), V((0.7614,0.284182)), V((0.7626,0.313791)), V((0.7438,0.321430)), ),
    17566: (V((0.7614,0.284182)), V((0.7909,0.274586)), V((0.7908,0.308830)), V((0.7626,0.313791)), ),
    17567: (V((0.7909,0.274586)), V((0.8422,0.268585)), V((0.8340,0.301668)), V((0.7908,0.308830)), ),
    17568: (V((0.8422,0.268585)), V((0.8959,0.276053)), V((0.8818,0.308140)), V((0.8340,0.301668)), ),
    17569: (V((0.8959,0.276053)), V((0.9407,0.290092)), V((0.9435,0.315454)), V((0.8818,0.308140)), ),
    17570: (V((0.6706,0.344333)), V((0.6522,0.325108)), V((0.6854,0.283553)), V((0.6996,0.301261)), ),
    17571: (V((0.6854,0.283553)), V((0.6965,0.263368)), V((0.7181,0.288366)), V((0.6996,0.301261)), ),
    17572: (V((0.6965,0.263368)), V((0.7157,0.244652)), V((0.7338,0.275581)), V((0.7181,0.288366)), ),
    17573: (V((0.7157,0.244652)), V((0.7352,0.226689)), V((0.7528,0.263560)), V((0.7338,0.275581)), ),
    17574: (V((0.7352,0.226689)), V((0.7973,0.193320)), V((0.7912,0.241001)), V((0.7528,0.263560)), ),
    17575: (V((0.7973,0.193320)), V((0.8262,0.196668)), V((0.8470,0.229447)), V((0.7912,0.241001)), ),
    17576: (V((0.8262,0.196668)), V((0.9002,0.195348)), V((0.8947,0.237061)), V((0.8470,0.229447)), ),
    17577: (V((0.9002,0.195348)), V((0.9252,0.205351)), V((0.9606,0.240069)), V((0.8947,0.237061)), ),
    17578: (V((0.3256,0.847283)), V((0.2843,0.784036)), V((0.3060,0.782334)), V((0.3278,0.840377)), ),
    17579: (V((0.2843,0.784036)), V((0.2962,0.754518)), V((0.3144,0.752959)), V((0.3060,0.782334)), ),
    17580: (V((0.2962,0.754518)), V((0.3018,0.725692)), V((0.3228,0.724255)), V((0.3144,0.752959)), ),
    17581: (V((0.3018,0.725692)), V((0.3066,0.698317)), V((0.3289,0.698350)), V((0.3228,0.724255)), ),
    17582: (V((0.3066,0.698317)), V((0.3072,0.679562)), V((0.3320,0.675959)), V((0.3289,0.698350)), ),
    17583: (V((0.3072,0.679562)), V((0.3108,0.650863)), V((0.3321,0.651159)), V((0.3320,0.675959)), ),
    17584: (V((0.3108,0.650863)), V((0.3115,0.627048)), V((0.3335,0.626769)), V((0.3321,0.651159)), ),
    17585: (V((0.6826,0.348000)), V((0.6726,0.346040)), V((0.7007,0.302214)), V((0.7096,0.317186)), ),
    17586: (V((0.7007,0.302214)), V((0.7184,0.288717)), V((0.7273,0.305178)), V((0.7096,0.317186)), ),
    17587: (V((0.7184,0.288717)), V((0.7354,0.275600)), V((0.7423,0.295790)), V((0.7273,0.305178)), ),
    17588: (V((0.7354,0.275600)), V((0.7525,0.263159)), V((0.7607,0.284264)), V((0.7423,0.295790)), ),
    17589: (V((0.7525,0.263159)), V((0.7925,0.242578)), V((0.7924,0.272931)), V((0.7607,0.284264)), ),
    17590: (V((0.7925,0.242578)), V((0.8479,0.231354)), V((0.8416,0.268033)), V((0.7924,0.272931)), ),
    17591: (V((0.8479,0.231354)), V((0.8960,0.236699)), V((0.8973,0.273859)), V((0.8416,0.268033)), ),
    17592: (V((0.8960,0.236699)), V((0.9417,0.255167)), V((0.9420,0.286692)), V((0.8973,0.273859)), ),
    17593: (V((0.6494,0.322445)), V((0.6389,0.310356)), V((0.6701,0.262413)), V((0.6856,0.281497)), ),
    17594: (V((0.6701,0.262413)), V((0.6792,0.238632)), V((0.6956,0.262177)), V((0.6856,0.281497)), ),
    17595: (V((0.6792,0.238632)), V((0.6894,0.218577)), V((0.7140,0.244523)), V((0.6956,0.262177)), ),
    17596: (V((0.6894,0.218577)), V((0.7066,0.196080)), V((0.7345,0.227050)), V((0.7140,0.244523)), ),
    17597: (V((0.7066,0.196080)), V((0.7297,0.157963)), V((0.7975,0.193216)), V((0.7345,0.227050)), ),
    17598: (V((0.7297,0.157963)), V((0.7563,0.101984)), V((0.8366,0.196820)), V((0.7975,0.193216)), ),
    17599: (V((0.3246,0.884439)), V((0.3123,0.872916)), V((0.3416,0.823099)), V((0.3379,0.870072)), ),
    17600: (V((0.3123,0.872916)), V((0.3263,0.860547)), V((0.3307,0.853343)), V((0.3416,0.823099)), ),
    17601: (V((0.2749,0.808823)), V((0.2609,0.789780)), V((0.2825,0.782588)), V((0.2849,0.801535)), ),
    17602: (V((0.2609,0.789780)), V((0.2664,0.758217)), V((0.2950,0.755992)), V((0.2825,0.782588)), ),
    17603: (V((0.2664,0.758217)), V((0.2745,0.724158)), V((0.2997,0.725681)), V((0.2950,0.755992)), ),
    17604: (V((0.2745,0.724158)), V((0.2823,0.694866)), V((0.3039,0.696265)), V((0.2997,0.725681)), ),
    17605: (V((0.2823,0.694866)), V((0.2866,0.679735)), V((0.3053,0.677568)), V((0.3039,0.696265)), ),
    17606: (V((0.2866,0.679735)), V((0.2868,0.645014)), V((0.3081,0.649416)), V((0.3053,0.677568)), ),
    17607: (V((0.2868,0.645014)), V((0.2857,0.623371)), V((0.3094,0.625942)), V((0.3081,0.649416)), ),
    17608: (V((0.6371,0.310472)), V((0.6292,0.297396)), V((0.6579,0.252816)), V((0.6691,0.261287)), ),
    17609: (V((0.6579,0.252816)), V((0.6568,0.220150)), V((0.6781,0.238619)), V((0.6691,0.261287)), ),
    17610: (V((0.6568,0.220150)), V((0.6634,0.196761)), V((0.6896,0.218416)), V((0.6781,0.238619)), ),
    17611: (V((0.6634,0.196761)), V((0.6712,0.170112)), V((0.7073,0.194221)), V((0.6896,0.218416)), ),
    17612: (V((0.6712,0.170112)), V((0.6868,0.138891)), V((0.7291,0.156205)), V((0.7073,0.194221)), ),
    17613: (V((0.6868,0.138891)), V((0.7211,0.082847)), V((0.7555,0.101364)), V((0.7291,0.156205)), ),
    17614: (V((0.3108,0.895396)), V((0.3077,0.889564)), V((0.3094,0.875767)), V((0.3242,0.884739)), ),
    17615: (V((0.3077,0.889564)), V((0.3008,0.887031)), V((0.3025,0.880424)), V((0.3094,0.875767)), ),
    17616: (V((0.2769,0.887670)), V((0.2422,0.863026)), V((0.2317,0.836381)), V((0.3178,0.889790)), ),
    17617: (V((0.2422,0.863026)), V((0.2205,0.873503)), V((0.2106,0.848105)), V((0.2317,0.836381)), ),
    17618: (V((0.2205,0.873503)), V((0.1967,0.880316)), V((0.1888,0.862459)), V((0.2106,0.848105)), ),
    17619: (V((0.1811,0.694357)), V((0.1811,0.668866)), V((0.2040,0.673706)), V((0.2017,0.698426)), ),
    17620: (V((0.1811,0.668866)), V((0.1877,0.641732)), V((0.2050,0.644440)), V((0.2040,0.673706)), ),
    17621: (V((0.1877,0.641732)), V((0.1885,0.611070)), V((0.2147,0.598929)), V((0.2050,0.644440)), ),
    17622: (V((0.1885,0.611070)), V((0.1898,0.575153)), V((0.2118,0.572204)), V((0.2147,0.598929)), ),
    17623: (V((0.6197,0.281676)), V((0.6160,0.272383)), V((0.6088,0.248049)), V((0.6338,0.242868)), ),
    17624: (V((0.6088,0.248049)), V((0.6036,0.218308)), V((0.6321,0.218048)), V((0.6338,0.242868)), ),
    17625: (V((0.6036,0.218308)), V((0.6042,0.185645)), V((0.6368,0.190327)), V((0.6321,0.218048)), ),
    17626: (V((0.6042,0.185645)), V((0.6114,0.151733)), V((0.6398,0.159257)), V((0.6368,0.190327)), ),
    17627: (V((0.6114,0.151733)), V((0.6278,0.109528)), V((0.6563,0.122692)), V((0.6398,0.159257)), ),
    17628: (V((0.6278,0.109528)), V((0.6557,0.061647)), V((0.6966,0.068054)), V((0.6563,0.122692)), ),
    17629: (V((0.2911,0.896645)), V((0.2864,0.891452)), V((0.2930,0.884093)), V((0.3015,0.901044)), ),
    17630: (V((0.2864,0.891452)), V((0.2774,0.887121)), V((0.2772,0.887333)), V((0.2930,0.884093)), ),
    17631: (V((0.2774,0.887121)), V((0.2595,0.901423)), V((0.2532,0.885137)), V((0.2772,0.887333)), ),
    17632: (V((0.2595,0.901423)), V((0.2375,0.914391)), V((0.2315,0.900824)), V((0.2532,0.885137)), ),
    17633: (V((0.2375,0.914391)), V((0.2178,0.916421)), V((0.2051,0.911297)), V((0.2315,0.900824)), ),
    17634: (V((0.1513,0.688236)), V((0.1499,0.663373)), V((0.1632,0.664804)), V((0.1678,0.688634)), ),
    17635: (V((0.1499,0.663373)), V((0.1555,0.634413)), V((0.1681,0.637065)), V((0.1632,0.664804)), ),
    17636: (V((0.1555,0.634413)), V((0.1607,0.607079)), V((0.1714,0.610805)), V((0.1681,0.637065)), ),
    17637: (V((0.1607,0.607079)), V((0.1594,0.585400)), V((0.1698,0.582849)), V((0.1714,0.610805)), ),
    17638: (V((0.6288,0.296649)), V((0.6205,0.282889)), V((0.6342,0.243496)), V((0.6572,0.251762)), ),
    17639: (V((0.6342,0.243496)), V((0.6328,0.218386)), V((0.6563,0.220330)), V((0.6572,0.251762)), ),
    17640: (V((0.6328,0.218386)), V((0.6376,0.191471)), V((0.6623,0.196532)), V((0.6563,0.220330)), ),
    17641: (V((0.6376,0.191471)), V((0.6403,0.161232)), V((0.6707,0.169992)), V((0.6623,0.196532)), ),
    17642: (V((0.6403,0.161232)), V((0.6561,0.124792)), V((0.6870,0.137651)), V((0.6707,0.169992)), ),
    17643: (V((0.6561,0.124792)), V((0.6969,0.068563)), V((0.7187,0.081717)), V((0.6870,0.137651)), ),
    17644: (V((0.3016,0.900962)), V((0.2941,0.889060)), V((0.3031,0.883702)), V((0.3099,0.895984)), ),
    17645: (V((0.2941,0.889060)), V((0.2892,0.886629)), V((0.2956,0.883621)), V((0.3031,0.883702)), ),
    17646: (V((0.2773,0.887268)), V((0.2528,0.884621)), V((0.2436,0.863526)), V((0.2782,0.886389)), ),
    17647: (V((0.2528,0.884621)), V((0.2309,0.899945)), V((0.2203,0.873635)), V((0.2436,0.863526)), ),
    17648: (V((0.2309,0.899945)), V((0.2044,0.909857)), V((0.1968,0.882735)), V((0.2203,0.873635)), ),
    17649: (V((0.1670,0.689792)), V((0.1639,0.665059)), V((0.1818,0.669666)), V((0.1814,0.693527)), ),
    17650: (V((0.1639,0.665059)), V((0.1673,0.637520)), V((0.1865,0.641362)), V((0.1818,0.669666)), ),
    17651: (V((0.1673,0.637520)), V((0.1715,0.610838)), V((0.1877,0.611339)), V((0.1865,0.641362)), ),
    17652: (V((0.1715,0.610838)), V((0.1700,0.583316)), V((0.1884,0.575657)), V((0.1877,0.611339)), ),
    17793: (V((0.3360,0.447079)), V((0.3343,0.441873)), V((0.3343,0.438732)), V((0.3366,0.443504)), ),
    17794: (V((0.3173,0.447807)), V((0.3181,0.459612)), V((0.3172,0.460517)), V((0.3157,0.446946)), ),
    17795: (V((0.3217,0.448846)), V((0.3230,0.449590)), V((0.3219,0.458973)), V((0.3209,0.458246)), ),
    17796: (V((0.3306,0.436062)), V((0.3309,0.441272)), V((0.3287,0.438546)), V((0.3283,0.434180)), ),
    17797: (V((0.3473,0.447076)), V((0.3467,0.443501)), V((0.3490,0.438728)), V((0.3490,0.441870)), ),
    17798: (V((0.3660,0.447801)), V((0.3676,0.446938)), V((0.3661,0.460517)), V((0.3652,0.459612)), ),
    17799: (V((0.3616,0.448842)), V((0.3624,0.458246)), V((0.3614,0.458974)), V((0.3603,0.449588)), ),
    17800: (V((0.3527,0.436056)), V((0.3550,0.434172)), V((0.3546,0.438541)), V((0.3524,0.441267)), ),
    17801: (V((0.3397,0.442212)), V((0.3378,0.435824)), V((0.3416,0.436819)), V((0.3416,0.441208)), ),
    17802: (V((0.3387,0.444846)), V((0.3371,0.440731)), V((0.3378,0.435824)), V((0.3397,0.442212)), ),
    17803: (V((0.3371,0.440731)), V((0.3344,0.435448)), V((0.3343,0.433004)), V((0.3378,0.435824)), ),
    17804: (V((0.3376,0.452125)), V((0.3360,0.447079)), V((0.3366,0.443504)), V((0.3381,0.448001)), ),
    17805: (V((0.3370,0.456267)), V((0.3355,0.451519)), V((0.3360,0.447079)), V((0.3376,0.452125)), ),
    17806: (V((0.3355,0.451519)), V((0.3340,0.447054)), V((0.3343,0.441873)), V((0.3360,0.447079)), ),
    17807: (V((0.3576,0.407299)), V((0.3538,0.416316)), V((0.3538,0.412902)), V((0.3570,0.404361)), ),
    17808: (V((0.3543,0.421596)), V((0.3538,0.416316)), V((0.3576,0.407299)), V((0.3579,0.414488)), ),
    17809: (V((0.3189,0.448192)), V((0.3194,0.458719)), V((0.3181,0.459612)), V((0.3173,0.447807)), ),
    17810: (V((0.3209,0.446981)), V((0.3217,0.448846)), V((0.3209,0.458246)), V((0.3203,0.458011)), ),
    17811: (V((0.3246,0.437697)), V((0.3250,0.438973)), V((0.3217,0.448846)), V((0.3209,0.446981)), ),
    17812: (V((0.3250,0.438973)), V((0.3261,0.441448)), V((0.3230,0.449590)), V((0.3217,0.448846)), ),
    17813: (V((0.3305,0.432297)), V((0.3306,0.436062)), V((0.3283,0.434180)), V((0.3281,0.430618)), ),
    17814: (V((0.3343,0.438732)), V((0.3343,0.441873)), V((0.3306,0.436062)), V((0.3305,0.432297)), ),
    17815: (V((0.3343,0.441873)), V((0.3340,0.447054)), V((0.3309,0.441272)), V((0.3306,0.436062)), ),
    17816: (V((0.3307,0.428217)), V((0.3310,0.423619)), V((0.3343,0.433004)), V((0.3344,0.435448)), ),
    17817: (V((0.3290,0.421608)), V((0.3295,0.416329)), V((0.3310,0.423619)), V((0.3307,0.428217)), ),
    17818: (V((0.3295,0.416329)), V((0.3295,0.412917)), V((0.3299,0.413255)), V((0.3310,0.423619)), ),
    17819: (V((0.3462,0.440729)), V((0.3455,0.435822)), V((0.3490,0.432999)), V((0.3489,0.435443)), ),
    17820: (V((0.3446,0.444844)), V((0.3436,0.442211)), V((0.3455,0.435822)), V((0.3462,0.440729)), ),
    17821: (V((0.3436,0.442211)), V((0.3416,0.441208)), V((0.3416,0.436819)), V((0.3455,0.435822)), ),
    17822: (V((0.3478,0.451517)), V((0.3473,0.447076)), V((0.3490,0.441870)), V((0.3493,0.447051)), ),
    17823: (V((0.3463,0.456266)), V((0.3457,0.452123)), V((0.3473,0.447076)), V((0.3478,0.451517)), ),
    17824: (V((0.3457,0.452123)), V((0.3452,0.448000)), V((0.3467,0.443501)), V((0.3473,0.447076)), ),
    17825: (V((0.3644,0.448186)), V((0.3660,0.447801)), V((0.3652,0.459612)), V((0.3639,0.458719)), ),
    17826: (V((0.3644,0.448186)), V((0.3624,0.446976)), V((0.3637,0.425112)), V((0.3655,0.425414)), ),
    17827: (V((0.3295,0.416329)), V((0.3257,0.407319)), V((0.3263,0.404383)), V((0.3295,0.412917)), ),
    17828: (V((0.3583,0.438966)), V((0.3616,0.448842)), V((0.3603,0.449588)), V((0.3572,0.441443)), ),
    17829: (V((0.3587,0.437690)), V((0.3624,0.446976)), V((0.3616,0.448842)), V((0.3583,0.438966)), ),
    17830: (V((0.3624,0.446976)), V((0.3630,0.458011)), V((0.3624,0.458246)), V((0.3616,0.448842)), ),
    17831: (V((0.3490,0.441870)), V((0.3527,0.436056)), V((0.3524,0.441267)), V((0.3493,0.447051)), ),
    17832: (V((0.3490,0.438728)), V((0.3528,0.432290)), V((0.3527,0.436056)), V((0.3490,0.441870)), ),
    17833: (V((0.3528,0.432290)), V((0.3552,0.430609)), V((0.3550,0.434172)), V((0.3527,0.436056)), ),
    17834: (V((0.3538,0.416316)), V((0.3523,0.423610)), V((0.3534,0.413242)), V((0.3538,0.412902)), ),
    17835: (V((0.3543,0.421596)), V((0.3526,0.428209)), V((0.3523,0.423610)), V((0.3538,0.416316)), ),
    17836: (V((0.3526,0.428209)), V((0.3489,0.435443)), V((0.3490,0.432999)), V((0.3523,0.423610)), ),
    17837: (V((0.3157,0.427495)), V((0.3173,0.447807)), V((0.3157,0.446946)), V((0.3145,0.427679)), ),
    17838: (V((0.3603,0.409693)), V((0.3601,0.401661)), V((0.3630,0.403459)), V((0.3620,0.407484)), ),
    17839: (V((0.3246,0.437697)), V((0.3209,0.446981)), V((0.3196,0.425128)), V((0.3219,0.424496)), ),
    17840: (V((0.3587,0.437690)), V((0.3552,0.430609)), V((0.3589,0.419910)), V((0.3614,0.424481)), ),
    17841: (V((0.3688,0.427662)), V((0.3676,0.446938)), V((0.3660,0.447801)), V((0.3676,0.427478)), ),
    17842: (V((0.3159,0.407168)), V((0.3181,0.401311)), V((0.3183,0.403548)), V((0.3169,0.409305)), ),
    17843: (V((0.3290,0.421608)), V((0.3281,0.430618)), V((0.3244,0.419925)), V((0.3254,0.414505)), ),
    17844: (V((0.3189,0.448192)), V((0.3173,0.447807)), V((0.3157,0.427495)), V((0.3178,0.425431)), ),
    17845: (V((0.3654,0.414646)), V((0.3645,0.415338)), V((0.3645,0.410941)), V((0.3648,0.410381)), ),
    17846: (V((0.3179,0.414667)), V((0.3169,0.409305)), V((0.3184,0.409062)), V((0.3185,0.410404)), ),
    17847: (V((0.3230,0.409714)), V((0.3223,0.414040)), V((0.3210,0.411260)), V((0.3213,0.407507)), ),
    17848: (V((0.3652,0.401282)), V((0.3674,0.407141)), V((0.3664,0.409280)), V((0.3650,0.403521)), ),
    17849: (V((0.3625,0.418236)), V((0.3610,0.414020)), V((0.3623,0.411239)), V((0.3633,0.414397)), ),
    17850: (V((0.3176,0.419432)), V((0.3157,0.417883)), V((0.3169,0.409305)), V((0.3179,0.414667)), ),
    17851: (V((0.3657,0.419413)), V((0.3643,0.419533)), V((0.3645,0.415338)), V((0.3654,0.414646)), ),
    17852: (V((0.3208,0.418255)), V((0.3190,0.419552)), V((0.3188,0.415359)), V((0.3200,0.414418)), ),
    17853: (V((0.3191,0.409010)), V((0.3185,0.410404)), V((0.3184,0.409062)), V((0.3187,0.406996)), ),
    17854: (V((0.3642,0.408986)), V((0.3646,0.406971)), V((0.3649,0.409038)), V((0.3648,0.410381)), ),
    17855: (V((0.3200,0.414418)), V((0.3188,0.415359)), V((0.3188,0.410964)), V((0.3194,0.411133)), ),
    17856: (V((0.3620,0.407484)), V((0.3630,0.403459)), V((0.3638,0.406328)), V((0.3633,0.407846)), ),
    17857: (V((0.3650,0.403521)), V((0.3664,0.409280)), V((0.3649,0.409038)), V((0.3646,0.406971)), ),
    17858: (V((0.3213,0.407507)), V((0.3210,0.411260)), V((0.3199,0.409981)), V((0.3200,0.407870)), ),
    17859: (V((0.3183,0.403548)), V((0.3203,0.403485)), V((0.3195,0.406353)), V((0.3187,0.406996)), ),
    17860: (V((0.3633,0.414397)), V((0.3623,0.411239)), V((0.3634,0.409958)), V((0.3639,0.411110)), ),
    17861: (V((0.3552,0.430609)), V((0.3543,0.421596)), V((0.3579,0.414488)), V((0.3589,0.419910)), ),
    17862: (V((0.3467,0.443501)), V((0.3462,0.440729)), V((0.3489,0.435443)), V((0.3490,0.438728)), ),
    17863: (V((0.3452,0.448000)), V((0.3446,0.444844)), V((0.3462,0.440729)), V((0.3467,0.443501)), ),
    17864: (V((0.3624,0.446976)), V((0.3644,0.448186)), V((0.3639,0.458719)), V((0.3630,0.458011)), ),
    17865: (V((0.3660,0.447801)), V((0.3644,0.448186)), V((0.3655,0.425414)), V((0.3676,0.427478)), ),
    17866: (V((0.3552,0.430609)), V((0.3528,0.432290)), V((0.3526,0.428209)), V((0.3543,0.421596)), ),
    17867: (V((0.3528,0.432290)), V((0.3490,0.438728)), V((0.3489,0.435443)), V((0.3526,0.428209)), ),
    17868: (V((0.3610,0.414020)), V((0.3603,0.409693)), V((0.3620,0.407484)), V((0.3623,0.411239)), ),
    17869: (V((0.3664,0.409280)), V((0.3654,0.414646)), V((0.3648,0.410381)), V((0.3649,0.409038)), ),
    17870: (V((0.3676,0.417862)), V((0.3657,0.419413)), V((0.3654,0.414646)), V((0.3664,0.409280)), ),
    17871: (V((0.3639,0.411110)), V((0.3642,0.408986)), V((0.3648,0.410381)), V((0.3645,0.410941)), ),
    17872: (V((0.3623,0.411239)), V((0.3620,0.407484)), V((0.3633,0.407846)), V((0.3634,0.409958)), ),
    17873: (V((0.3190,0.419552)), V((0.3176,0.419432)), V((0.3179,0.414667)), V((0.3188,0.415359)), ),
    17874: (V((0.3209,0.446981)), V((0.3189,0.448192)), V((0.3178,0.425431)), V((0.3196,0.425128)), ),
    17875: (V((0.3281,0.430618)), V((0.3283,0.434180)), V((0.3250,0.438973)), V((0.3246,0.437697)), ),
    17876: (V((0.3283,0.434180)), V((0.3287,0.438546)), V((0.3261,0.441448)), V((0.3250,0.438973)), ),
    17877: (V((0.3223,0.414040)), V((0.3208,0.418255)), V((0.3200,0.414418)), V((0.3210,0.411260)), ),
    17878: (V((0.3630,0.403459)), V((0.3650,0.403521)), V((0.3646,0.406971)), V((0.3638,0.406328)), ),
    17879: (V((0.3183,0.403548)), V((0.3181,0.401311)), V((0.3206,0.398292)), V((0.3203,0.403485)), ),
    17880: (V((0.3200,0.407870)), V((0.3191,0.409010)), V((0.3187,0.406996)), V((0.3195,0.406353)), ),
    17881: (V((0.3188,0.415359)), V((0.3179,0.414667)), V((0.3185,0.410404)), V((0.3188,0.410964)), ),
    17882: (V((0.3295,0.416329)), V((0.3290,0.421608)), V((0.3254,0.414505)), V((0.3257,0.407319)), ),
    17883: (V((0.3203,0.403485)), V((0.3213,0.407507)), V((0.3200,0.407870)), V((0.3195,0.406353)), ),
    17884: (V((0.3281,0.430618)), V((0.3290,0.421608)), V((0.3307,0.428217)), V((0.3305,0.432297)), ),
    17885: (V((0.3194,0.411133)), V((0.3188,0.410964)), V((0.3185,0.410404)), V((0.3191,0.409010)), ),
    17886: (V((0.3199,0.409981)), V((0.3194,0.411133)), V((0.3191,0.409010)), V((0.3200,0.407870)), ),
    17887: (V((0.3232,0.401686)), V((0.3230,0.409714)), V((0.3213,0.407507)), V((0.3203,0.403485)), ),
    17888: (V((0.3305,0.432297)), V((0.3307,0.428217)), V((0.3344,0.435448)), V((0.3343,0.438732)), ),
    17889: (V((0.3366,0.443504)), V((0.3343,0.438732)), V((0.3344,0.435448)), V((0.3371,0.440731)), ),
    17890: (V((0.3652,0.401282)), V((0.3650,0.403521)), V((0.3630,0.403459)), V((0.3627,0.398263)), ),
    17891: (V((0.3634,0.409958)), V((0.3633,0.407846)), V((0.3642,0.408986)), V((0.3639,0.411110)), ),
    17892: (V((0.3147,0.416339)), V((0.3159,0.407168)), V((0.3169,0.409305)), V((0.3157,0.417883)), ),
    17893: (V((0.3169,0.409305)), V((0.3183,0.403548)), V((0.3187,0.406996)), V((0.3184,0.409062)), ),
    17894: (V((0.3209,0.446981)), V((0.3203,0.458011)), V((0.3194,0.458719)), V((0.3189,0.448192)), ),
    17895: (V((0.3281,0.430618)), V((0.3246,0.437697)), V((0.3219,0.424496)), V((0.3244,0.419925)), ),
    17896: (V((0.3381,0.448001)), V((0.3366,0.443504)), V((0.3371,0.440731)), V((0.3387,0.444846)), ),
    17897: (V((0.3601,0.401661)), V((0.3601,0.398859)), V((0.3627,0.398263)), V((0.3630,0.403459)), ),
    17898: (V((0.3232,0.398886)), V((0.3232,0.401686)), V((0.3203,0.403485)), V((0.3206,0.398292)), ),
    17899: (V((0.3686,0.416317)), V((0.3688,0.427662)), V((0.3676,0.427478)), V((0.3676,0.417862)), ),
    17900: (V((0.3552,0.430609)), V((0.3587,0.437690)), V((0.3583,0.438966)), V((0.3550,0.434172)), ),
    17901: (V((0.3210,0.411260)), V((0.3200,0.414418)), V((0.3194,0.411133)), V((0.3199,0.409981)), ),
    17902: (V((0.3633,0.407846)), V((0.3638,0.406328)), V((0.3646,0.406971)), V((0.3642,0.408986)), ),
    17903: (V((0.3550,0.434172)), V((0.3583,0.438966)), V((0.3572,0.441443)), V((0.3546,0.438541)), ),
    17904: (V((0.3645,0.415338)), V((0.3633,0.414397)), V((0.3639,0.411110)), V((0.3645,0.410941)), ),
    17905: (V((0.3624,0.446976)), V((0.3587,0.437690)), V((0.3614,0.424481)), V((0.3637,0.425112)), ),
    17906: (V((0.3643,0.419533)), V((0.3625,0.418236)), V((0.3633,0.414397)), V((0.3645,0.415338)), ),
    17907: (V((0.3534,0.413242)), V((0.3523,0.423610)), V((0.3490,0.410792)), V((0.3507,0.404266)), ),
    17908: (V((0.3490,0.432999)), V((0.3455,0.435822)), V((0.3444,0.419000)), V((0.3465,0.415755)), ),
    17909: (V((0.3523,0.423610)), V((0.3490,0.432999)), V((0.3465,0.415755)), V((0.3490,0.410792)), ),
    17910: (V((0.3455,0.435822)), V((0.3416,0.436819)), V((0.3416,0.419992)), V((0.3444,0.419000)), ),
    17911: (V((0.3343,0.433004)), V((0.3310,0.423619)), V((0.3343,0.410800)), V((0.3367,0.415760)), ),
    17912: (V((0.3416,0.436819)), V((0.3378,0.435824)), V((0.3389,0.419003)), V((0.3416,0.419992)), ),
    17913: (V((0.3310,0.423619)), V((0.3299,0.413255)), V((0.3326,0.404278)), V((0.3343,0.410800)), ),
    17914: (V((0.3378,0.435824)), V((0.3343,0.433004)), V((0.3367,0.415760)), V((0.3389,0.419003)), ),
    17915: (V((0.3444,0.419000)), V((0.3416,0.419992)), V((0.3416,0.407218)), V((0.3436,0.406822)), ),
    17916: (V((0.3389,0.419003)), V((0.3367,0.415760)), V((0.3382,0.404769)), V((0.3397,0.406824)), ),
    17917: (V((0.3465,0.415755)), V((0.3444,0.419000)), V((0.3436,0.406822)), V((0.3451,0.404764)), ),
    17918: (V((0.3490,0.410792)), V((0.3465,0.415755)), V((0.3451,0.404764)), V((0.3469,0.400870)), ),
    17919: (V((0.3416,0.419992)), V((0.3389,0.419003)), V((0.3397,0.406824)), V((0.3416,0.407218)), ),
    17920: (V((0.3343,0.410800)), V((0.3326,0.404278)), V((0.3346,0.395081)), V((0.3364,0.400877)), ),
    17921: (V((0.3507,0.404266)), V((0.3490,0.410792)), V((0.3469,0.400870)), V((0.3487,0.395070)), ),
    17922: (V((0.3367,0.415760)), V((0.3343,0.410800)), V((0.3364,0.400877)), V((0.3382,0.404769)), ),
    17923: (V((0.3487,0.395070)), V((0.3469,0.400870)), V((0.3453,0.393556)), V((0.3466,0.386964)), ),
    17924: (V((0.3382,0.404769)), V((0.3364,0.400877)), V((0.3380,0.393561)), V((0.3393,0.397201)), ),
    17925: (V((0.3436,0.406822)), V((0.3416,0.407218)), V((0.3416,0.399185)), V((0.3429,0.398661)), ),
    17926: (V((0.3397,0.406824)), V((0.3382,0.404769)), V((0.3393,0.397201)), V((0.3404,0.398662)), ),
    17927: (V((0.3451,0.404764)), V((0.3436,0.406822)), V((0.3429,0.398661)), V((0.3440,0.397198)), ),
    17928: (V((0.3469,0.400870)), V((0.3451,0.404764)), V((0.3440,0.397198)), V((0.3453,0.393556)), ),
    17929: (V((0.3416,0.407218)), V((0.3397,0.406824)), V((0.3404,0.398662)), V((0.3416,0.399185)), ),
    17930: (V((0.3364,0.400877)), V((0.3346,0.395081)), V((0.3367,0.386972)), V((0.3380,0.393561)), ),
    17931: (V((0.3433,0.388771)), V((0.3428,0.392401)), V((0.3424,0.391639)), V((0.3427,0.388686)), ),
    17932: (V((0.3416,0.394568)), V((0.3410,0.393978)), V((0.3412,0.392913)), V((0.3416,0.393298)), ),
    17933: (V((0.3400,0.388773)), V((0.3402,0.382130)), V((0.3416,0.382914)), V((0.3406,0.388688)), ),
    17934: (V((0.3431,0.382128)), V((0.3433,0.388771)), V((0.3427,0.388686)), V((0.3416,0.382914)), ),
    17935: (V((0.3405,0.392402)), V((0.3400,0.388773)), V((0.3406,0.388688)), V((0.3409,0.391640)), ),
    17936: (V((0.3423,0.393977)), V((0.3416,0.394568)), V((0.3416,0.393298)), V((0.3421,0.392912)), ),
    17937: (V((0.3410,0.393978)), V((0.3405,0.392402)), V((0.3409,0.391640)), V((0.3412,0.392913)), ),
    17938: (V((0.3428,0.392401)), V((0.3423,0.393977)), V((0.3421,0.392912)), V((0.3424,0.391639)), ),
    17939: (V((0.3412,0.392913)), V((0.3409,0.391640)), V((0.3415,0.391013)), V((0.3415,0.391364)), ),
    17940: (V((0.3424,0.391639)), V((0.3421,0.392912)), V((0.3418,0.391364)), V((0.3418,0.391012)), ),
    17941: (V((0.3427,0.388686)), V((0.3424,0.391639)), V((0.3418,0.391012)), V((0.3418,0.390502)), ),
    17942: (V((0.3416,0.393298)), V((0.3412,0.392913)), V((0.3415,0.391364)), V((0.3416,0.391476)), ),
    17943: (V((0.3406,0.388688)), V((0.3416,0.382914)), V((0.3416,0.390354)), V((0.3415,0.390502)), ),
    17944: (V((0.3416,0.382914)), V((0.3427,0.388686)), V((0.3418,0.390502)), V((0.3416,0.390354)), ),
    17945: (V((0.3409,0.391640)), V((0.3406,0.388688)), V((0.3415,0.390502)), V((0.3415,0.391013)), ),
    17946: (V((0.3421,0.392912)), V((0.3416,0.393298)), V((0.3416,0.391476)), V((0.3418,0.391364)), ),
    17947: (V((0.3579,0.414488)), V((0.3576,0.407299)), V((0.3601,0.401661)), V((0.3603,0.409693)), ),
    17948: (V((0.3254,0.414505)), V((0.3244,0.419925)), V((0.3223,0.414040)), V((0.3230,0.409714)), ),
    17949: (V((0.3614,0.424481)), V((0.3589,0.419910)), V((0.3610,0.414020)), V((0.3625,0.418236)), ),
    17950: (V((0.3178,0.425431)), V((0.3157,0.427495)), V((0.3157,0.417883)), V((0.3176,0.419432)), ),
    17951: (V((0.3655,0.425414)), V((0.3637,0.425112)), V((0.3643,0.419533)), V((0.3657,0.419413)), ),
    17952: (V((0.3219,0.424496)), V((0.3196,0.425128)), V((0.3190,0.419552)), V((0.3208,0.418255)), ),
    17953: (V((0.3589,0.419910)), V((0.3579,0.414488)), V((0.3603,0.409693)), V((0.3610,0.414020)), ),
    17954: (V((0.3676,0.427478)), V((0.3655,0.425414)), V((0.3657,0.419413)), V((0.3676,0.417862)), ),
    17955: (V((0.3196,0.425128)), V((0.3178,0.425431)), V((0.3176,0.419432)), V((0.3190,0.419552)), ),
    17956: (V((0.3244,0.419925)), V((0.3219,0.424496)), V((0.3208,0.418255)), V((0.3223,0.414040)), ),
    17957: (V((0.3257,0.407319)), V((0.3254,0.414505)), V((0.3230,0.409714)), V((0.3232,0.401686)), ),
    17958: (V((0.3145,0.427679)), V((0.3147,0.416339)), V((0.3157,0.417883)), V((0.3157,0.427495)), ),
    17959: (V((0.3576,0.407299)), V((0.3570,0.404361)), V((0.3601,0.398859)), V((0.3601,0.401661)), ),
    17960: (V((0.3263,0.404383)), V((0.3257,0.407319)), V((0.3232,0.401686)), V((0.3232,0.398886)), ),
    17961: (V((0.3674,0.407141)), V((0.3686,0.416317)), V((0.3676,0.417862)), V((0.3664,0.409280)), ),
    17962: (V((0.3637,0.425112)), V((0.3614,0.424481)), V((0.3625,0.418236)), V((0.3643,0.419533)), ),
    17963: (V((0.3418,0.391364)), V((0.3416,0.391476)), V((0.3416,0.390977)), V((0.3418,0.391012)), ),
    17964: (V((0.3415,0.391364)), V((0.3415,0.391013)), V((0.3416,0.390977)), V((0.3416,0.391476)), ),
    17965: (V((0.3418,0.390502)), V((0.3418,0.391012)), V((0.3416,0.390977)), V((0.3416,0.390354)), ),
    17966: (V((0.3415,0.390502)), V((0.3416,0.390354)), V((0.3416,0.390977)), V((0.3415,0.391013)), ),
    17967: (V((0.3453,0.393556)), V((0.3440,0.397198)), V((0.3428,0.392401)), V((0.3433,0.388771)), ),
    17968: (V((0.3416,0.399185)), V((0.3404,0.398662)), V((0.3410,0.393978)), V((0.3416,0.394568)), ),
    17969: (V((0.3380,0.393561)), V((0.3367,0.386972)), V((0.3402,0.382130)), V((0.3400,0.388773)), ),
    17970: (V((0.3466,0.386964)), V((0.3453,0.393556)), V((0.3433,0.388771)), V((0.3431,0.382128)), ),
    17971: (V((0.3393,0.397201)), V((0.3380,0.393561)), V((0.3400,0.388773)), V((0.3405,0.392402)), ),
    17972: (V((0.3429,0.398661)), V((0.3416,0.399185)), V((0.3416,0.394568)), V((0.3423,0.393977)), ),
    17973: (V((0.3404,0.398662)), V((0.3393,0.397201)), V((0.3405,0.392402)), V((0.3410,0.393978)), ),
    17974: (V((0.3440,0.397198)), V((0.3429,0.398661)), V((0.3423,0.393977)), V((0.3428,0.392401)), ),
    18479: (V((0.5476,0.396082)), V((0.5411,0.395607)), V((0.5460,0.369688)), V((0.5537,0.371451)), ),
}
