LAMMPS (23 Oct 2015)
# Al2O3 crystal, qeq on, minimizes, then calculates elastic constants

variable T_depart equal 300
variable dt equal 0.0002

#Constante
variable rac3 equal sqrt(3.0)
variable rac1_2 equal sqrt(0.5)
variable rac3_2 equal sqrt(1.5)

#Structure
variable a equal 4.05

variable nx equal 10
variable ny equal 7
variable nz equal 4

variable bx equal ${a}*${nx}*${rac1_2}
variable bx equal 4.05*${nx}*${rac1_2}
variable bx equal 4.05*10*${rac1_2}
variable bx equal 4.05*10*0.707106781186548
variable by equal ${a}*${ny}*${rac3_2}
variable by equal 4.05*${ny}*${rac3_2}
variable by equal 4.05*7*${rac3_2}
variable by equal 4.05*7*1.22474487139159
variable bz equal ${a}*${nz}*${rac3}
variable bz equal 4.05*${nz}*${rac3}
variable bz equal 4.05*4*${rac3}
variable bz equal 4.05*4*1.73205080756888
# =======================================================================

units		metal
atom_style	charge
dimension       3
boundary        p p p


lattice		sc 1.0
Lattice spacing in x,y,z = 1 1 1
region          box_vide prism 0 ${bx} 0 ${by} 0 ${bz} 0.0 0.0 0.0
region          box_vide prism 0 28.6378246380552 0 ${by} 0 ${bz} 0.0 0.0 0.0
region          box_vide prism 0 28.6378246380552 0 34.7215171039516 0 ${bz} 0.0 0.0 0.0
region          box_vide prism 0 28.6378246380552 0 34.7215171039516 0 28.0592230826159 0.0 0.0 0.0
create_box      1 box_vide
Created triclinic box = (0 0 0) to (28.6378 34.7215 28.0592) with tilt (0 0 0)
  1 by 1 by 1 MPI processor grid

# Aluminium atoms z = [111]
lattice custom ${a} a1 ${rac1_2}  0.0      0.0                     a2   0.0   ${rac3_2}   0.0                     a3   0.0      0.0    ${rac3}                         basis 0.0 0.0 0.0                         basis 0.5 0.5 0.0                         basis 0.5 0.166666667 0.33333                         basis 0.0 0.666666667 0.33333                         basis 0.0 0.333333333 0.66667                         basis 0.5 0.833333333 0.66667
lattice custom 4.05 a1 ${rac1_2}  0.0      0.0                     a2   0.0   ${rac3_2}   0.0                     a3   0.0      0.0    ${rac3}                         basis 0.0 0.0 0.0                         basis 0.5 0.5 0.0                         basis 0.5 0.166666667 0.33333                         basis 0.0 0.666666667 0.33333                         basis 0.0 0.333333333 0.66667                         basis 0.5 0.833333333 0.66667
lattice custom 4.05 a1 0.707106781186548  0.0      0.0                     a2   0.0   ${rac3_2}   0.0                     a3   0.0      0.0    ${rac3}                         basis 0.0 0.0 0.0                         basis 0.5 0.5 0.0                         basis 0.5 0.166666667 0.33333                         basis 0.0 0.666666667 0.33333                         basis 0.0 0.333333333 0.66667                         basis 0.5 0.833333333 0.66667
lattice custom 4.05 a1 0.707106781186548  0.0      0.0                     a2   0.0   1.22474487139159   0.0                     a3   0.0      0.0    ${rac3}                         basis 0.0 0.0 0.0                         basis 0.5 0.5 0.0                         basis 0.5 0.166666667 0.33333                         basis 0.0 0.666666667 0.33333                         basis 0.0 0.333333333 0.66667                         basis 0.5 0.833333333 0.66667
lattice custom 4.05 a1 0.707106781186548  0.0      0.0                     a2   0.0   1.22474487139159   0.0                     a3   0.0      0.0    1.73205080756888                         basis 0.0 0.0 0.0                         basis 0.5 0.5 0.0                         basis 0.5 0.166666667 0.33333                         basis 0.0 0.666666667 0.33333                         basis 0.0 0.333333333 0.66667                         basis 0.5 0.833333333 0.66667
Lattice spacing in x,y,z = 2.86378 4.96022 7.01481

create_atoms 	1 region box_vide
Created 1680 atoms

mass		1 26.98

velocity	all create ${T_depart} 277387
velocity	all create 300 277387

pair_style	smtbq
pair_coeff	* * ffield.smtbq.Al Al

neighbor	0.5 bin
neigh_modify	every 20 delay 0 check yes

timestep        ${dt}
timestep        0.0002

thermo_style    custom step temp press pe ke etotal lx ly lz vol
thermo_modify	flush yes
thermo		1


#dump            5 all custom 1 box_Al.lammpstrj id type q x y z

fix		3 all nve
run		10
Neighbor list info ...
  1 neighbor list requests
  update every 20 steps, delay 0 steps, check yes
  max neighbors/atom: 2000, page size: 100000
  master list distance cutoff = 11.6714
  ghost atom cutoff = 11.6714
  binsize = 5.8357 -> bins = 5 6 5
Memory usage per processor = 4.52298 Mbytes
Step Temp Press PotEng KinEng TotEng Lx Ly Lz Volume 
       0          300    729.26605   -5600.8541    65.108335   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       1    299.98323    729.90439   -5600.8505    65.104695   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       2    299.93288    731.82072   -5600.8395    65.093767   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       3    299.84896    735.01448   -5600.8213    65.075556   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       4     299.7315    739.48472   -5600.7958    65.050064   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       5    299.58053    745.23012   -5600.7631    65.017299   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       6    299.39609    752.24896    -5600.723    64.977269   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       7    299.17822     760.5391   -5600.6757    64.929985   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       8    298.92698      770.098   -5600.6212    64.875459   -5535.7458    28.637825    34.721517    28.059223    27900.653 
       9    298.64244    780.92261   -5600.5595    64.813707   -5535.7458    28.637825    34.721517    28.059223    27900.653 
      10    298.32468    793.00943   -5600.4905    64.744743   -5535.7458    28.637825    34.721517    28.059223    27900.653 
Loop time of 5.10336 on 1 procs for 10 steps with 1680 atoms

Performance: 0.034 ns/day, 708.800 hours/ns, 1.959 timesteps/s
99.9% CPU use with 1 MPI tasks x no OpenMP threads

MPI task timing breakdown:
Section |  min time  |  avg time  |  max time  |%varavg| %total
---------------------------------------------------------------
Pair    | 5.1023     | 5.1023     | 5.1023     |   0.0 | 99.98
Neigh   | 0          | 0          | 0          |   0.0 |  0.00
Comm    | 0.00045538 | 0.00045538 | 0.00045538 |   0.0 |  0.01
Output  | 0.00024509 | 0.00024509 | 0.00024509 |   0.0 |  0.00
Modify  | 0.00026131 | 0.00026131 | 0.00026131 |   0.0 |  0.01
Other   |            | 0.0001056  |            |       |  0.00

Nlocal:    1680 ave 1680 max 1680 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Nghost:    7518 ave 7518 max 7518 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Neighs:    0 ave 0 max 0 min
Histogram: 1 0 0 0 0 0 0 0 0 0
FullNghs:  638400 ave 638400 max 638400 min
Histogram: 1 0 0 0 0 0 0 0 0 0

Total # of neighbors = 638400
Ave neighs/atom = 380
Neighbor list builds = 0
Dangerous builds = 0

unfix		3
#thermo		15
fix             1 all box/relax tri 0.0 vmax 0.001
minimize        1.0e-8 1.0e-10 1000 10000
WARNING: Resetting reneighboring criteria during minimization (../min.cpp:168)
Neighbor list info ...
  1 neighbor list requests
  update every 1 steps, delay 0 steps, check yes
  max neighbors/atom: 2000, page size: 100000
  master list distance cutoff = 11.6714
  ghost atom cutoff = 11.6714
  binsize = 5.8357 -> bins = 5 6 5
Memory usage per processor = 5.64798 Mbytes
Step Temp Press PotEng KinEng TotEng Lx Ly Lz Volume 
      10    298.32468    793.00943   -5600.4905    64.744743   -5535.7458    28.637825    34.721517    28.059223    27900.653 
      11    298.32468    2483.3228   -5600.5212    64.744743   -5535.7764    28.617938    34.697425    28.039771    27842.617 
      12    298.32468    3102.6624   -5600.6242    64.744743   -5535.8795    28.594201     34.68783    28.048729    27820.715 
      13    298.32468    1681.0688   -5600.6477    64.744743    -5535.903    28.619779    34.708131    28.055945    27869.065 
      14    298.32468    949.90841   -5600.6635    64.744743   -5535.9187    28.648416    34.718691    28.044409    27893.966 
      15    298.32468    2009.1662   -5600.7072    64.744743   -5535.9625    28.652241    34.703261     28.01635    27857.391 
      16    298.32468    2867.1434   -5600.7192    64.744743   -5535.9744    28.626861     34.69005    28.022309    27828.038 
      17    298.32468    2480.3207   -5600.7238    64.744743   -5535.9791    28.618046    34.695106    28.040113      27841.2 
      18    298.32468    2482.4906   -5600.7249    64.744743   -5535.9802    28.614169    34.704237    28.036452    27841.119 
      19    298.32468    2495.6209   -5600.7261    64.744743   -5535.9813    28.616207    34.697481    28.039453    27840.662 
      20    298.32468    2210.2897   -5600.7271    64.744743   -5535.9823    28.620852    34.699678    28.042926    27850.393 
      21    298.32468     2464.137    -5600.734    64.744743   -5535.9893    28.625239    34.687085    28.040022     27841.67 
      22    298.32468    3091.7034   -5600.7471    64.744743   -5536.0024    28.623565    34.674943     28.02983    27820.181 
      23    298.32468    2334.9443   -5600.7598    64.744743   -5536.0151    28.634413    34.684598    28.037298    27845.891 
      24    298.32468    2462.2836   -5600.7767    64.744743    -5536.032    28.615834    34.692433    28.044664    27841.422 
      25    298.32468      2652.08   -5600.7914    64.744743   -5536.0466     28.61528    34.695645    28.035991     27834.85 
      26    298.32468    2365.4126   -5600.7923    64.744743   -5536.0476    28.618526    34.699347    28.039662    27844.623 
      27    298.32468    2334.9429   -5600.7934    64.744743   -5536.0486     28.61826    34.698136    28.041941    27845.656 
      28    298.32468    2501.1598   -5600.7937    64.744743   -5536.0489    28.616356    34.695993    28.039825    27839.982 
      29    298.32468    2506.0962    -5600.794    64.744743   -5536.0493    28.617255    34.699031    28.036317    27839.811 
      30    298.32468    2400.7588   -5600.7942    64.744743   -5536.0495    28.618372    34.698464    28.039299    27843.404 
      31    298.32468    2499.8528   -5600.7945    64.744743   -5536.0497     28.61702     34.69385    28.040945    27840.021 
      32    298.32468    2629.5393   -5600.7967    64.744743   -5536.0519    28.619399    34.691546    28.036003     27835.58 
      33    298.32468    2397.5939   -5600.7973    64.744743   -5536.0526    28.621863     34.69535     28.03848    27843.488 
      34    298.32468    2222.7714   -5600.8007    64.744743    -5536.056    28.609815    34.705091    28.048395    27849.426 
      35    298.32468    2748.5871   -5600.8042    64.744743   -5536.0594    28.600322      34.6998    28.043876    27831.457 
      36    298.32468    2661.1018   -5600.8166    64.744743   -5536.0719    28.615123    34.696499    28.034947    27834.344 
      37    298.32468    2255.4994   -5600.8185    64.744743   -5536.0737    28.618919    34.702261    28.040497    27848.173 
      38    298.32468     2260.815   -5600.8239    64.744743   -5536.0791    28.614993     34.70246    28.043972    27847.962 
      39    298.32468    2549.2876   -5600.8248    64.744743   -5536.0801    28.612892    34.697988    28.039725    27838.113 
      40    298.32468    2488.3825   -5600.8266    64.744743   -5536.0819    28.623347    34.695524    28.033557    27840.182 
      41    298.32468    2400.9714   -5600.8283    64.744743   -5536.0835    28.619176    34.695733    28.040468    27843.155 
      42    298.32468    2496.6566   -5600.8284    64.744743   -5536.0837    28.617629    34.694692    28.039536     27839.89 
      43    298.32468    2486.2773   -5600.8285    64.744743   -5536.0838    28.617585    34.697413    28.037736    27840.243 
      44    298.32468    2446.3916   -5600.8287    64.744743   -5536.0839    28.617115    34.696389    28.040393    27841.603 
      45    298.32468    2547.2311   -5600.8288    64.744743   -5536.0841    28.615267    34.694882    28.039956    27838.161 
      46    298.32468    2479.9982   -5600.8321    64.744743   -5536.0874    28.603008     34.71581    28.037344    27840.427 
      47    298.32468     2449.645   -5600.8444    64.744743   -5536.0997    28.612743    34.683541    28.054837    27841.375 
      48    298.32468    2682.7109   -5600.8695    64.744743   -5536.1248    28.617414    34.683477    28.042139    27833.265 
      49    298.32468    2350.1707   -5600.8711    64.744743   -5536.1263    28.619236    34.694213    28.043092      27844.6 
      50    298.32468    2486.1481   -5600.8719    64.744743   -5536.1271    28.615167    34.699435    28.038181    27839.955 
      51    298.32468    2498.3384   -5600.8721    64.744743   -5536.1274    28.616069    34.696071    28.039596    27839.537 
      52    298.32468    2443.1247   -5600.8722    64.744743   -5536.1274    28.617616    34.696737    28.039439    27841.421 
Loop time of 36.9389 on 1 procs for 42 steps with 1680 atoms

99.9% CPU use with 1 MPI tasks x no OpenMP threads

Minimization stats:
  Stopping criterion = energy tolerance
  Energy initial, next-to-last, final = 
        -5600.49050006     -5600.87213771     -5600.87218615
  Force two-norm initial, final = 50.879 1.39888
  Force max component initial, final = 29.3783 0.749036
  Final line search alpha, max atom move = 0.0013373 0.00100168
  Iterations, force evaluations = 42 71

MPI task timing breakdown:
Section |  min time  |  avg time  |  max time  |%varavg| %total
---------------------------------------------------------------
Pair    | 36.918     | 36.918     | 36.918     |   0.0 | 99.94
Neigh   | 0          | 0          | 0          |   0.0 |  0.00
Comm    | 0.0033035  | 0.0033035  | 0.0033035  |   0.0 |  0.01
Output  | 0.0011785  | 0.0011785  | 0.0011785  |   0.0 |  0.00
Modify  | 0          | 0          | 0          |   0.0 |  0.00
Other   |            | 0.01603    |            |       |  0.04

Nlocal:    1680 ave 1680 max 1680 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Nghost:    7518 ave 7518 max 7518 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Neighs:    0 ave 0 max 0 min
Histogram: 1 0 0 0 0 0 0 0 0 0
FullNghs:  638400 ave 638400 max 638400 min
Histogram: 1 0 0 0 0 0 0 0 0 0

Total # of neighbors = 638400
Ave neighs/atom = 380
Neighbor list builds = 0
Dangerous builds = 0

unfix		1
thermo		1
fix             3 all nve
run             10
Neighbor list info ...
  1 neighbor list requests
  update every 20 steps, delay 0 steps, check yes
  max neighbors/atom: 2000, page size: 100000
  master list distance cutoff = 11.6714
  ghost atom cutoff = 11.6714
  binsize = 5.8357 -> bins = 5 6 5
Memory usage per processor = 4.52298 Mbytes
Step Temp Press PotEng KinEng TotEng Lx Ly Lz Volume 
      52    298.32468    2443.1247   -5600.8722    64.744743   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      53    298.28341    2444.4342   -5600.8632    64.735788   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      54    298.20852     2447.019    -5600.847    64.719534   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      55        298.1    2450.8786   -5600.8234    64.695982   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      56    297.95788    2456.0119   -5600.7926    64.665139   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      57     297.7822    2462.4173   -5600.7545     64.62701   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      58    297.57298    2470.0928    -5600.709    64.581604   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      59    297.33028    2479.0363   -5600.6564    64.528932   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      60    297.05416     2489.245   -5600.5964    64.469006   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      61    296.74469    2500.7159   -5600.5293    64.401842   -5536.1274    28.617616    34.696737    28.039439    27841.421 
      62    296.40194    2513.4457   -5600.4549    64.327455   -5536.1274    28.617616    34.696737    28.039439    27841.421 
Loop time of 5.13028 on 1 procs for 10 steps with 1680 atoms

Performance: 0.034 ns/day, 712.539 hours/ns, 1.949 timesteps/s
99.9% CPU use with 1 MPI tasks x no OpenMP threads

MPI task timing breakdown:
Section |  min time  |  avg time  |  max time  |%varavg| %total
---------------------------------------------------------------
Pair    | 5.1292     | 5.1292     | 5.1292     |   0.0 | 99.98
Neigh   | 0          | 0          | 0          |   0.0 |  0.00
Comm    | 0.00045729 | 0.00045729 | 0.00045729 |   0.0 |  0.01
Output  | 0.00024509 | 0.00024509 | 0.00024509 |   0.0 |  0.00
Modify  | 0.00026488 | 0.00026488 | 0.00026488 |   0.0 |  0.01
Other   |            | 0.0001016  |            |       |  0.00

Nlocal:    1680 ave 1680 max 1680 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Nghost:    7518 ave 7518 max 7518 min
Histogram: 1 0 0 0 0 0 0 0 0 0
Neighs:    0 ave 0 max 0 min
Histogram: 1 0 0 0 0 0 0 0 0 0
FullNghs:  638400 ave 638400 max 638400 min
Histogram: 1 0 0 0 0 0 0 0 0 0

Total # of neighbors = 638400
Ave neighs/atom = 380
Neighbor list builds = 0
Dangerous builds = 0

Total wall time: 0:00:49
