/*****************************************************************************
 * Copyright (C) 2000 Shie Erlich <erlich@users.sourceforge.net>             *
 * Copyright (C) 2000 Rafi Yanai <yanai@users.sourceforge.net>               *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "kicons.h"
#include "krglobal.h"
#include "defaults.h"
#include <QtCore/QString>
#include <QPixmap>
#include <QStyle>

QPixmap FL_LOADICON(QString name)
{
    KConfigGroup group(krConfig, "Look&Feel");
    int size = (group.readEntry("Filelist Icon Size", _FilelistIconSize)).toInt();
    return krLoader->loadIcon(name, KIconLoader::Desktop, size);
}

const char * no_xpm[] = {
    "14 14 5 1",
    "  c None",
    ". c #F70713",
    "+ c #800309",
    "@ c #7F0309",
    "# c #EC0612",
    "              ",
    "  ..       .. ",
    "  ...     ... ",
    "   ...   ...  ",
    "    ... ...   ",
    "     .....    ",
    "      ...     ",
    "     .....    ",
    "    ....#..   ",
    "   ...  ...   ",
    "  ...    ...  ",
    " ...      ... ",
    " ..        .. ",
    "              "
};

const char * yes_xpm[] = {
    "14 14 4 1",
    "  c None",
    ". c #07F907",
    "+ c #06F806",
    "@ c #06F706",
    "              ",
    "             .",
    "           ...",
    "          ....",
    "         ...  ",
    "        ...   ",
    "        ..    ",
    "..     ..     ",
    "....  ...     ",
    "  .. ...      ",
    "   ....       ",
    "   ...+       ",
    "    ..        ",
    "    @.        "
};

const char * link_xpm[] = {
    "32 32 28 1",
    "  c None",
    ". c #000000",
    "+ c #FEFEFE",
    "@ c #FFFFFF",
    "# c #D7D7D7",
    "$ c #F6F6F6",
    "% c #646464",
    "& c #373737",
    "* c #2B2B2B",
    "= c #BEBEBE",
    "- c #393939",
    "; c #363636",
    "> c #F0F0F0",
    ", c #AFAFAF",
    "' c #2A2A2A",
    ") c #606060",
    "! c #474747",
    "~ c #868686",
    "{ c #262626",
    "] c #1E1E1E",
    "^ c #DEDEDE",
    "/ c #666666",
    "( c #222222",
    "_ c #1C1C1C",
    ": c #DCDCDC",
    "< c #4F4F4F",
    "[ c #1A1A1A",
    "} c #525252",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".+@##$++@.                      ",
    ".@%&*#+++.                      ",
    ".@=@-;@@+.                      ",
    ".@>@,')!+.                      ",
    ".@@~!*{]@.                      ",
    ".@@^/'(_@.                      ",
    ".@@@:<][@.                      ",
    ".++++:}[+.                      ",
    ".@@@@@@#@.                      ",
    "..........                      "
};

const char * black_xpm[] = {
    "32 32 2 1",
    "  c None",
    ". c #000000",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      ",
    "..........                      "
};

const char * yellow_xpm[] = {
    "32 32 3 1",
    "  c None",
    ". c #000000",
    "+ c #FFEE00",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    "..........                      "
};

const char * red_xpm[] = {
    "32 32 3 1",
    "  c None",
    ". c #000000",
    "+ c #FF0000",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    "..........                      "
};

const char * white_xpm[] = {
    "32 32 3 1",
    "  c None",
    ". c #000000",
    "+ c #FFFFFF",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    "..........                      "
};

const char * green_xpm[] = {
    "32 32 3 1",
    "  c None",
    ". c #000000",
    "+ c #15FF00",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    "..........                      "
};

const char * blue_xpm[] = {
    "32 32 3 1",
    "  c None",
    ". c #000000",
    "+ c #1100FF",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "                                ",
    "..........                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    ".++++++++.                      ",
    "..........                      "
};

