//*****************************************************************************
//                                  ChoUnits.hpp                              *
//                                 --------------                             *
//                                                                            *
// Description : This class is intended to provide useful functionality for   *
//               managing the units associated with some variable. It is      *
//               particular aimed at parameters to do with electronics.       *
// Started     : 27/03/2004                                                   *
// Last Update : 08/04/2011                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CHOUNITS_HPP
#define CHOUNITS_HPP

// System Includes

#include <iostream>
#include <cmath>
#include <cfloat>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/string.h>
#include <wx/wxchar.h>

// Application Includes

#include "TypeDefs.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations


//*****************************************************************************

class ChoUnits : public wxChoice
{
  private :

    eUnitsType  m_eUnitsType;

  public :

    eUnitsType  m_eDefUType;
    wxString    m_osDefUnits;

    ChoUnits( void );
   ~ChoUnits( );

    bool  bCreate   ( wxWindow * poWin, wxWindowID oWinID, int iWidth=-1 );
    bool  bIsCreated( void ) { return( GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bClear( void );
    bool  bSetDefaults( void );

    bool  bSetUnitsType( eUnitsType eUType );
    bool  bSetUnits    ( const wxString rosUnits );
    bool  bSetUnits    ( int iExponent );

          eUnitsType   eGetUnitsType( void ) { return( m_eUnitsType ); }
    const wxString & rosGetUnits    ( void );
          int          iGetUnits    ( void );

    // Take a value and return it combined with the currently selected units
          long        liGetValue( float fValue );
          double      dfGetValue( float fValue );
    const wxString & rosGetValue( float fValue );
};

//*****************************************************************************

#endif // CHOUNITS_HPP
