# Can be removed once vcpkg speexdsp package has gained a proper cmake-wrapper.
set(_VCPKG_ARCH_DIR "${VCPKG_INSTALLED_DIR}/${VCPKG_TARGET_TRIPLET}")
find_path(SPEEXDSP_INCLUDE_DIR NAMES speex/speexdsp_types.h PATHS "${_VCPKG_ARCH_DIR}/include" NO_DEFAULT_PATH REQUIRED)
find_library(SPEEXDSP_LIB_RELEASE NAMES speexdsp PATHS "${_VCPKG_ARCH_DIR}/lib" NO_DEFAULT_PATH)
find_library(SPEEXDSP_LIB_DEBUG NAMES speexdsp PATHS "${_VCPKG_ARCH_DIR}/debug/lib" NO_DEFAULT_PATH)
if(NOT SPEEXDSP_LIB_RELEASE AND NOT SPEEXDSP_LIB_DEBUG)
    message(FATAL_ERROR "SpeexDSP library not found")
endif()
add_library(SPEEX::SPEEXDSP STATIC IMPORTED)
set_target_properties(SPEEX::SPEEXDSP PROPERTIES
        IMPORTED_CONFIGURATIONS "Debug;Release"
        IMPORTED_LOCATION_RELEASE "${SPEEXDSP_LIB_RELEASE}"
        IMPORTED_LOCATION_DEBUG "${SPEEXDSP_LIB_DEBUG}"
        INTERFACE_INCLUDE_DIRECTORIES "${SPEEXDSP_INCLUDE_DIR}"
)