//
// File: PanelSaisieParametresImageSortie.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 24 20:42:55 2006
//

#include "PanelSaisieParametresImageSortie.h"


PanelSaisieParametresImageSortie::PanelSaisieParametresImageSortie(wxString label,bool redimensionnement, wxString prefixe, bool modifprefixeposssible, 
                                                                                                                        wxString chemin, bool choixcheminpossible, wxWindow* parent, int id):wxPanel(parent, id)
{
    sizer_panel_saisie_parametres_image_sortie_staticbox = new wxStaticBox(this, -1, label);
    sizer_panel_saisie_parametres_image_sortie= new wxStaticBoxSizer(sizer_panel_saisie_parametres_image_sortie_staticbox, wxVERTICAL);
    
    wxBoxSizer* sizer_nom_sous_repertoire= new wxBoxSizer(wxHORIZONTAL);
    label_nom_sr= new wxStaticText(this, -1, wxT("Nom du sous-répertoire: "));
    if (choixcheminpossible) text_ctrl_nom_sous_repertoire= new wxTextCtrl(this, -1, chemin);
    else text_ctrl_nom_sous_repertoire = new wxTextCtrl(this, -1, chemin,wxDefaultPosition, wxDefaultSize, wxTE_READONLY);      
    sizer_nom_sous_repertoire->Add(label_nom_sr, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_nom_sous_repertoire->Add(text_ctrl_nom_sous_repertoire, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_parametres_image_sortie->Add(sizer_nom_sous_repertoire, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);    

    wxBoxSizer* sizer_prefixe_fichier = new wxBoxSizer(wxHORIZONTAL);
    prefixe_fichier = new wxStaticText(this, -1, wxT("Préfixe des fichiers encadrés: "));
    if (modifprefixeposssible) text_ctrl_prefixe_fichier = new wxTextCtrl(this, -1, prefixe);
    else text_ctrl_prefixe_fichier = new wxTextCtrl(this, -1, prefixe,wxDefaultPosition, wxDefaultSize, wxTE_READONLY);      
    sizer_prefixe_fichier->Add(prefixe_fichier, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_prefixe_fichier->Add(text_ctrl_prefixe_fichier, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_parametres_image_sortie->Add(sizer_prefixe_fichier, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);

    panel_saisie_qualite_enregistrement = new PanelSaisieSlider(this,-1,wxT("Qualité d'enregistrement (%) : "),1,100,100,0);
    sizer_panel_saisie_parametres_image_sortie->Add(panel_saisie_qualite_enregistrement, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);

    checkbox_redimensionnement= new wxCheckBox(this, -1, wxT("Redimensionnement"));
    sizer_panel_saisie_parametres_image_sortie->Add(checkbox_redimensionnement, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    
    if (redimensionnement)
    {    
        checkbox_redimensionnement->SetValue(true);
        panel_saisie_taille_redimensionnement=new PanelSaisieSlider(this,-1,wxT("Taille maximum du grand côté: "),100,3000,500,0);
        sizer_panel_saisie_parametres_image_sortie->Add(panel_saisie_taille_redimensionnement, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    }

    SetSizer(sizer_panel_saisie_parametres_image_sortie);
    
    // on connecte les évènements
   	Connect(checkbox_redimensionnement->GetId( ), wxEVT_COMMAND_CHECKBOX_CLICKED, 
										(wxObjectEventFunction) &PanelSaisieParametresImageSortie::on_click_checkbox_redimensionnement);

}


PanelSaisieParametresImageSortie::~PanelSaisieParametresImageSortie()
{
	// TODO: put destructor code here
}

wxString PanelSaisieParametresImageSortie::GetNomSortie()
{
    return sizer_panel_saisie_parametres_image_sortie_staticbox->GetLabel();
}    

wxString PanelSaisieParametresImageSortie::GetRepertoireDestination()
{
    return text_ctrl_nom_sous_repertoire->GetValue();
}    

wxString PanelSaisieParametresImageSortie::GetPrefixeFichier()
{
    return text_ctrl_prefixe_fichier->GetValue();
}

int PanelSaisieParametresImageSortie::GetQualiteEnregistrement()
{
    return (panel_saisie_qualite_enregistrement->GetValeurEntiere());
}

int PanelSaisieParametresImageSortie::GetTailleRedimensionement()
{
    if (checkbox_redimensionnement->IsChecked())
        return (panel_saisie_taille_redimensionnement->GetValeurEntiere());
    else
        return (0);
}   


void PanelSaisieParametresImageSortie::on_click_checkbox_redimensionnement(wxCommandEvent& event)
{
   if (checkbox_redimensionnement->IsChecked())
   {
       checkbox_redimensionnement->SetValue(true);
       panel_saisie_taille_redimensionnement=new PanelSaisieSlider(this,-1,wxT("Taille maximum du grand côté: "),100,3000,500,0);
       sizer_panel_saisie_parametres_image_sortie->Add(panel_saisie_taille_redimensionnement, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
       sizer_panel_saisie_parametres_image_sortie->Layout();
   } else {
        checkbox_redimensionnement->SetValue(false);
       delete panel_saisie_taille_redimensionnement;
   }       
}
