# Upgrading to 0.19

To make the process as smooth as possible, this document outlines all the things you need to do to upgrade to 0.19.

- [Command Line](#command-line)
- [`elm.json`](#elmjson)
- [Changes](#changes)
- [`--optimize`](#--optimize)
- [Compiler Performance](#compiler-performance)
- [Parse Errors](#parse-errors)
- [Stricter Record Update Syntax](#stricter-record-update-syntax)
- [Removed User-Defined Operators](#removed-user-defined-operators)

> **Note:** You can try out [`elm-upgrade`](https://github.com/avh4/elm-upgrade#elm-upgrade--) which automates some of the 0.18 to 0.19 changes. It is also in an alpha stage, and Aaron has said it makes sense to talk things through [here](https://github.com/avh4/elm-upgrade/issues).

<br>


## Command Line

There is now just one `elm` binary at the command line. The terminal commands are now:

```bash
# 0.19         # 0.18
elm make       # elm-make
elm repl       # elm-repl
elm reactor    # elm-reactor
elm install    # elm-package install
elm publish    # elm-package publish
elm bump       # elm-package bump
elm diff       # elm-package diff
```


<br>


## `elm.json`

`elm-package.json` becomes `elm.json` which is specialized for applications and packages. For example, it helps you lock your dependencies in applications and get broad dependency ranges in packages.

See the full outlines here:

  - `elm.json` for [applications](https://github.com/elm/compiler/blob/master/docs/elm.json/application.md)
  - `elm.json` for [packages](https://github.com/elm/compiler/blob/master/docs/elm.json/package.md)

Both are quite similar to the `elm-package.json` format, and `elm-upgrade` can help you with this.

<br>


## Changes

#### Functions Changed

- `String.toInt : String -> Maybe Int` (not `Result` anymore)
- `String.toFloat : String -> Maybe Float` (not `Result` anymore)
- `Basics.toString` becomes [`Debug.toString`](https://package.elm-lang.org/packages/elm/core/latest/Debug#toString), [`String.fromInt`](https://package.elm-lang.org/packages/elm/core/latest/String#fromInt), and [`String.fromFloat`](https://package.elm-lang.org/packages/elm/core/latest/String#fromFloat).
- `Basics.rem 451 10` becomes [`remainderBy 10 451`](https://package.elm-lang.org/packages/elm/core/latest/Basics#remainderBy)
- `451 % 10` becomes [`modBy 10 451`](https://package.elm-lang.org/packages/elm/core/latest/Basics#modBy)
- `(,)` becomes [`Tuple.pair`](https://package.elm-lang.org/packages/elm/core/latest/Tuple#pair)
- `style : List (String, String) -> Attribute msg` becomes `String -> String -> Attribute msg`
- `Html.beginnerProgram` becomes [`Browser.sandbox`](https://package.elm-lang.org/packages/elm/browser/latest/Browser#sandbox).
- `Html.program` becomes [`Browser.element`](https://package.elm-lang.org/packages/elm/browser/latest/Browser#element) and [`Browser.document`](https://package.elm-lang.org/packages/elm/browser/latest/Browser#document).


#### Modules Moved

- `Json.Encode` and `Json.Decode` moved to [`elm/json`](https://package.elm-lang.org/packages/elm/json/latest)
- `Time` and `Date` moved to [`elm/time`](https://package.elm-lang.org/packages/elm/time/latest/) with a significantly improved API
- `Random` moved to [`elm/random`](https://package.elm-lang.org/packages/elm/random/latest/) with a better implementation and a few new functions
- `Regex` moved to [`elm/regex`](https://package.elm-lang.org/packages/elm/regex/latest) with a much clearer README


#### Packages Moved

- `elm-lang/*` moved to `elm/*`
- `evancz/url-parser` moved to [`elm/url`](https://package.elm-lang.org/packages/elm/url/latest) with a simpler and more flexible API
- `elm-tools/elm-parser` moved to [`elm/parser`](https://package.elm-lang.org/packages/elm/parser/latest) with speed boost when compiling with the `--optimize` flag
- [`elm/browser`](https://package.elm-lang.org/packages/elm/browser/latest) combines and simplifies the following 0.18 packages:
  - `elm-lang/navigation` with smoother APIs
  - `elm-lang/dom` with ability to get node positions and dimensions.
  - `elm-lang/mouse` with decoders
  - `elm-lang/window`
  - `elm-lang/keyboard` uses decoders like [this](https://github.com/elm/browser/blob/master/notes/keyboard.md)
  - `elm-lang/page-visibility`
  - `elm-lang/animation-frame`


#### Functions Removed

- `uncurry`
- `curry`
- `flip`
- `(!)`

Prefer named helper functions in these cases.

<br>

## `--optimize`

You can now compile with `elm make --optimize` which enables things like:

- Reliable field name shortening in compiled assets
- Unbox things like `type Height = Height Float` to just be a float at runtime
- Unbox `Char` values
- Use more compact names for `type` constructors in compiled assets.

Some of these optimizations require "forgetting information" that is useful while debugging, so the `Debug` module becomes unavailable when you add the `--optimize` flag. The idea being that you want to be shipping code with this flag (like `-O2` in C) but not compiling with it all day in development.

<br>


## Compiler Performance

I did a bunch of performance optimizations for the compiler itself. For example:

- I rewrote the parser to be very significantly faster (partly by allocating very little!)
- I revamped how type inference looks up the type of foreign variables to be `O(1)` rather than `O(log(n))`
- I redid how code is generated to allow DCE with declarations as the level of granuality
- Packages are downloaded once per user and saved in `~/.elm/`
- Packages are built once for any given set of dependencies, so they do not contribute to build times of fresh projects.

Point is, the compiler is very significantly faster!


<br>


## Parse Errors

Part of rewriting the parser was making nicer parse errors. Many people only really see them when getting started, and rather than saying "man, these are terrible" they think "man, programming is hard" leading to a big underreporting of quality issues here. Anyway, please explore that a bit and see if you run into anything odd!

<br>


## Stricter Record Update Syntax

It used to be possible for `{ r | x = v }` to change the type of field `x`. This is no longer possible. This greatly improves the quality of error messages in many cases.

You can still change the type of a field, but you must reconstruct the record with the record literal syntax, or with a record constructor.

The idea is that 99.9% of uses get a much better experience with type errors, whereas 0.1% of uses become somewhat more verbose. As someone who had a bit of code that changed record types, I have found this to be a really excellent trade.

<br>


## Removed User-Defined Operators

It is no longer possible to define custom operators. For example, someone defined:

```elm
(|-~->) : (a -> a1_1 -> a3) -> (a2 -> a1_1) -> a -> a2 -> a3
```

They are still able to define that function, but it will need a human readable name that explains what it is meant to do. The reasoning behind this decision is outlined in detail in [this document](https://gist.github.com/evancz/769bba8abb9ddc3bf81d69fa80cc76b1).

<br>


## Notes:

- `toString` &mdash; A relatively common bug was to show an `Int` in the UI, and then later that value changes to something else. `toString` would just show wrong information until someone noticed. The new `String.fromInt` and `String.fromFloat` ensure that cannot happen. Furthermore, more elaborate types almost certainly need localization or internationalization, which should be handled differently anyway.
