// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=parameter, header=Parameter.h)
%feature("docstring")  dolfin::Parameter "
Base class for parameters.
";

%feature("docstring")  dolfin::Parameter::Parameter "
Create parameter for given key
";

%feature("docstring")  dolfin::Parameter::key "
Return parameter key
";

%feature("docstring")  dolfin::Parameter::description "
Return parameter description
";

%feature("docstring")  dolfin::Parameter::is_set "
Return true if parameter is set, return false otherwise
";

%feature("docstring")  dolfin::Parameter::reset "
Reset the parameter to empty, so that is_set() returns false.
";

%feature("docstring")  dolfin::Parameter::access_count "
Return access count (number of times parameter has been accessed)
";

%feature("docstring")  dolfin::Parameter::change_count "
Return change count (number of times parameter has been changed)
";

%feature("docstring")  dolfin::Parameter::set_range "
**Overloaded versions**

* set_range\ (min_value, max_value)

  Set range for int-valued parameter

* set_range\ (min_value, max_value)

  Set range for double-valued parameter

* set_range\ (range)

  Set range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::get_range "
**Overloaded versions**

* get_range\ (min_value, max_value)

  Get range for int-valued parameter

* get_range\ (min_value, max_value)

  Get range for double-valued parameter

* get_range\ (range)

  Get range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::operator= "
**Overloaded versions**

* operator=\ (value)

  Assignment from int

* operator=\ (value)

  Assignment from double

* operator=\ (value)

  Assignment from string

* operator=\ (value)

  Assignment from string

* operator=\ (value)

  Assignment from bool
";

%feature("docstring")  dolfin::Parameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::Parameter::operator std::size_t "
Cast parameter to std::size_t
";

%feature("docstring")  dolfin::Parameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::Parameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::Parameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::Parameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::Parameter::value_str "
Return value string
";

%feature("docstring")  dolfin::Parameter::range_str "
Return range string
";

%feature("docstring")  dolfin::Parameter::str "
Return short string description
";

%feature("docstring")  dolfin::IntParameter "
Parameter with value type int
";

%feature("docstring")  dolfin::IntParameter::IntParameter "
**Overloaded versions**

* IntParameter\ (key)

  Create unset int-valued

* IntParameter\ (key, value)

  Create int-valued parameter
";

%feature("docstring")  dolfin::IntParameter::set_range "
Set range
";

%feature("docstring")  dolfin::IntParameter::get_range "
Get range
";

%feature("docstring")  dolfin::IntParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::IntParameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::IntParameter::operator std::size_t "
Cast parameter to std::size_t
";

%feature("docstring")  dolfin::IntParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::IntParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::IntParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::IntParameter::str "
Return short string description
";

%feature("docstring")  dolfin::DoubleParameter "
Parameter with value type double
";

%feature("docstring")  dolfin::DoubleParameter::DoubleParameter "
**Overloaded versions**

* DoubleParameter\ (key)

  Create unset double-valued parameter

* DoubleParameter\ (key, value)

  Create double-valued parameter
";

%feature("docstring")  dolfin::DoubleParameter::set_range "
Set range
";

%feature("docstring")  dolfin::DoubleParameter::get_range "
Get range
";

%feature("docstring")  dolfin::DoubleParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::DoubleParameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::DoubleParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::DoubleParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::DoubleParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::DoubleParameter::str "
Return short string description
";

%feature("docstring")  dolfin::StringParameter "
Parameter with value type string
";

%feature("docstring")  dolfin::StringParameter::StringParameter "
**Overloaded versions**

* StringParameter\ (key)

  Create unset string-valued parameter

* StringParameter\ (key, value)

  Create string-valued parameter
";

%feature("docstring")  dolfin::StringParameter::set_range "
Set range
";

%feature("docstring")  dolfin::StringParameter::get_range "
Get range
";

%feature("docstring")  dolfin::StringParameter::operator= "
**Overloaded versions**

* operator=\ (value)

  Assignment

* operator=\ (value)

  Assignment
";

%feature("docstring")  dolfin::StringParameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::StringParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::StringParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::StringParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::StringParameter::str "
Return short string description
";

%feature("docstring")  dolfin::BoolParameter "
Parameter with value type bool
";

%feature("docstring")  dolfin::BoolParameter::BoolParameter "
**Overloaded versions**

* BoolParameter\ (key)

  Create unset bool-valued parameter

* BoolParameter\ (key, value)

  Create bool-valued parameter
";

%feature("docstring")  dolfin::BoolParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::BoolParameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::BoolParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::BoolParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::BoolParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::BoolParameter::str "
Return short string description
";

// Documentation extracted from: (module=parameter, header=Parameters.h)
%feature("docstring")  dolfin::Parameters "
This class stores a set of parameters. Each parameter is
identified by a unique string (the key) and a value of some
given value type. Parameter sets can be nested at arbitrary
depths.

A parameter may be either int, double, string or boolean valued.

Parameters may be added as follows:

  Parameters p(\"my_parameters\");
  p.add(\"relative_tolerance\",  1e-15);
  p.add(\"absolute_tolerance\",  1e-15);
  p.add(\"gmres_restart\",       30);
  p.add(\"monitor_convergence\", false);

Parameters may be changed as follows:

  p[\"gmres_restart\"] = 50;

Parameter values may be retrieved as follows:

  int gmres_restart = p[\"gmres_restart\"];

Parameter sets may be nested as follows:

  Parameters q(\"nested_parameters\");
  p.add(q);

Nested parameters may then be accessed by

  p(\"nested_parameters\")[\"...\"]

Parameters may be nested at arbitrary depths.

Parameters may be parsed from the command-line as follows:

  p.parse(argc, argv);

Note: spaces in parameter keys are not allowed (to simplify
usage from command-line).
";

%feature("docstring")  dolfin::Parameters::Parameters "
**Overloaded versions**

* Parameters\ (\"parameters\")

  Create empty parameter set

* Parameters\ (parameters)

  Copy constructor
";

%feature("docstring")  dolfin::Parameters::name "
Return name for parameter set
";

%feature("docstring")  dolfin::Parameters::rename "
Rename parameter set
";

%feature("docstring")  dolfin::Parameters::clear "
Clear parameter set
";

%feature("docstring")  dolfin::Parameters::add "
**Overloaded versions**

* add\ (key)

  Add an unset parameter of type T. For example, to create a unset
  parameter of type bool, do parameters.add<bool>(\"my_setting\")

* add\ (key, min, max)

  Add an unset parameter of type T with allows parameters. For
  example, to create a unset parameter of type bool, do
  parameters.add<bool>(\"my_setting\")

* add\ (key, valid_values)

  Add an unset parameter of type T with allows parameters. For
  example, to create a unset parameter of type bool, do
  parameters.add<bool>(\"my_setting\")

* add\ (key, value)

  Add int-valued parameter

* add\ (key, value, min_value, max_value)

  Add int-valued parameter with given range

* add\ (key, value)

  Add double-valued parameter

* add\ (key, value, min_value, max_value)

  Add double-valued parameter with given range

* add\ (key, value)

  Add string-valued parameter

* add\ (key, value)

  Add string-valued parameter

* add\ (key, value, range)

  Add string-valued parameter with given range

* add\ (key, value, range)

  Add string-valued parameter with given range

* add\ (key, value)

  Add bool-valued parameter

* add\ (parameters)

  Add nested parameter set
";

%feature("docstring")  dolfin::Parameters::remove "
Remove parameter or parameter set with given key
";

%feature("docstring")  dolfin::Parameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::Parameters::update "
Update parameters with another set of parameters
";

%feature("docstring")  dolfin::Parameters::operator[] "
**Overloaded versions**

* operator[]\ (key)

  Return parameter for given key

* operator[]\ (key)

  Return parameter for given key (const version)
";

%feature("docstring")  dolfin::Parameters::operator "
**Overloaded versions**

* operator\ (key)

  Return nested parameter set for given key

* operator\ (key)

  Return nested parameter set for given key (const)
";

%feature("docstring")  dolfin::Parameters::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Parameters::has_key "
Check if parameter set has key (parameter or nested parameter set)
";

%feature("docstring")  dolfin::Parameters::has_parameter "
Check if parameter set has given parameter
";

%feature("docstring")  dolfin::Parameters::has_parameter_set "
Check if parameter set has given nested parameter set
";

%feature("docstring")  dolfin::Parameters::get_parameter_keys "
Return a vector of parameter keys
";

%feature("docstring")  dolfin::Parameters::get_parameter_set_keys "
Return a vector of parameter set keys
";

%feature("docstring")  dolfin::Parameters::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Parameters::parse_common "
Parse filtered options (everything except PETSc options)
";

%feature("docstring")  dolfin::Parameters::parse_petsc "
Parse filtered options (only PETSc options)
";

// Documentation extracted from: (module=parameter, header=GlobalParameters.h)
%feature("docstring")  dolfin::GlobalParameters "
This class defines the global DOLFIN parameter database.
";

%feature("docstring")  dolfin::GlobalParameters::GlobalParameters "
Constructor
";

%feature("docstring")  dolfin::GlobalParameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::GlobalParameters::default_parameters "
Default parameter values
";

