//
// C++ Interface: backendconnection
//
//
// Author: rilleb and mickyg
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BACKENDCONNECTION_H
#define BACKENDCONNECTION_H
#include <string>
#include <QObject>
#include <QVariant>
#include <QPair>
#include "global.h"
#include <boost/shared_ptr.hpp>
#include <rpcdriver.h>
#include "rpctypes.h"

class SearchEntry;

/** 
	Simply the RPC interface.
	Converts ordinary method calls to RPC calls which are sent to the other side.
	BIG NOTE: The RPC Driver does not accept values of type int64. Therefore, use int64
	from rpcdriver/types.h (this applies to x86_64 only).
*/
class BackendConnection : public QObject
{
Q_OBJECT

public:
	BackendConnection(boost::shared_ptr< rpc::RpcClientDriver > aDriver) : driver(aDriver) {}
	~BackendConnection();
	
public slots:

	void authenticate( const QString& password );
	void createSession( const QString& url );
    void getSharedDirs();
    void addShare(const QString& name,const QString& dir);
    void delShare(const QString& name);
 	void getHubList(bool refresh);
	void getFavouriteHubs();
	void getSettings(QList<QString> keys);
	void setSettings(QList<QPair<QString,QVariant> > );
    void sendChat(int session,const QString& msg);
	void sendSearch(int session, int64 size, int sizeMode, int typeMode, const QString& search);
    void requestRunningSessions();
    void downloadFile( const SearchEntry& file );
    void downloadFileTo( const SearchEntry& file, const QString& dir );
	void downloadFile( int uId, const QString& file, int64 size, const QString& tth );
	void downloadFileTo( int uId, const QString& file, int64 size, const QString& tth, const QString& dir );
    void tellBackendToDie();
    void getUserFileList( int userId );
    void addFavouriteHub(const rpc_types::FavouriteHub&);
    void removeFavouriteHub(const QString& server);
	void closeSession( int session );
	void sendPassword( int session, const QString& );
	void removeQueueItem(int id);
	void forceConnectionAttempt(int userId);
	void removeSource(int qid, int uid);
	void die();
	
private:
    boost::shared_ptr< rpc::RpcClientDriver > driver;
};

typedef boost::shared_ptr<BackendConnection> BackendConnectionPtr;

#endif

