/*
 *  Copyright (C) 2010  Giorgio Wicklein <g.wicklein@giowisys.com>
 *
 *  This file is part of DaemonFS.
 *
 *  DaemonFS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DaemonFS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DaemonFS.  If not, see <http://www.gnu.org/licenses/>.
 */

//-----------------------------------------------------------------------------
// Hearders
//-----------------------------------------------------------------------------

#include <QFileDialog>

#include "filewidget.h"
#include "ui_filewidget.h"


//-----------------------------------------------------------------------------
// Public
//-----------------------------------------------------------------------------

FileWidget::FileWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FileWidget)
{
    ui->setupUi(this);

    connect(ui->backButton, SIGNAL(clicked()),
            this, SIGNAL(backButtonClicked()));
    connect(ui->startButton, SIGNAL(clicked()),
            this, SIGNAL(startButtonClicked()));
    connect(ui->addFileButton, SIGNAL(clicked()),
            this, SLOT(addFileSlot()));
    connect(ui->addDirButton, SIGNAL(clicked()),
            this, SLOT(addDirSlot()));
    connect(ui->resetButton, SIGNAL(clicked()),
            this, SLOT(resetSlot()));
}

FileWidget::~FileWidget()
{
    delete ui;
}

QStringList FileWidget::getFilesList()
{
    QStringList items;

    for (int i = 0; i < ui->filesListWidget->count(); i++) {
        items.append(ui->filesListWidget->item(i)->text());
    }

    return items;
}


//-----------------------------------------------------------------------------
// PrivateSlot
//-----------------------------------------------------------------------------

void FileWidget::addFileSlot()
{
    QStringList files = QFileDialog::getOpenFileNames(this, QString(), QDir::homePath());
    bool emptyList = files.isEmpty();

    ui->startButton->setEnabled(!emptyList || ui->filesListWidget->count());

    if (emptyList)
        return;

    for (int i = 0; i < files.size(); i++) {
        ui->filesListWidget->addItem(files.at(i));
    }
}

void FileWidget::addDirSlot()
{
    QString dir = QFileDialog::getExistingDirectory(this, QString(), QDir::homePath());
    bool empty = dir.isEmpty();

    ui->startButton->setEnabled(!empty || ui->filesListWidget->count());

    if (empty)
        return;

    ui->filesListWidget->addItem(dir);
}

void FileWidget::resetSlot()
{
    ui->filesListWidget->clear();
    ui->startButton->setEnabled(false);
}
