/*
 * Copyright (c) 2003-2012
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 */

#ifndef lint
static const char copyright[] =
"Copyright (c) 2003-2012\n\
Distributed Systems Software.  All rights reserved.";
static const char revid[] =
  "$Id: dacsjni.c 2594 2012-10-19 17:28:49Z brachman $";
#endif

#include <jni.h>
#include <stdlib.h>
#include <stdio.h>

#include "ca_dss_dacs_DACSCHECK.h"
#include "ca_dss_dacs_DACSAUTH.h"

static char *log_module_name = "dacsjni";

#ifdef NOTDEF
#endif
int
dacscheck_mainx(int argc, char **argv)
{
  int i;

printf("dacscheck_main\n");
printf("argc = %d\n", argc);
for (i = 0; i < argc; i++)
 printf("argv[%d] = \"%s\"\n", i, argv[i]);
if (argv[argc] != NULL)
  printf("argv[argc]??\n");
else
  printf("argv[%d] = NULL\n", i);
}

typedef struct Cargs {
	int argc;
	char **argv;
} Cargs;

static Cargs *
make_cargs(JNIEnv *jenv, jobjectArray oarr)
{
    int i;
	Cargs *cargs;
    jsize argc;

	cargs = (Cargs *) malloc(sizeof(Cargs));
    cargs->argc = (*jenv)->GetArrayLength(jenv, oarr) + 1;
    cargs->argv = (char **) malloc(sizeof(char *) * (cargs->argc + 1));

   cargs->argv[0] = "";
   for (i = 1; i < cargs->argc; i++) {
      jobject myObject = (*jenv)->GetObjectArrayElement(jenv, oarr, i - 1);
      const char *str = (*jenv)->GetStringUTFChars(jenv, myObject, 0);

      cargs->argv[i] = (char *) (*jenv)->GetStringUTFChars(jenv, myObject, 0);
   }
   cargs->argv[cargs->argc] = NULL;

  return(cargs);
}

JNIEXPORT jint JNICALL 
Java_ca_dss_dacs_DACSCHECK_dacscheck(JNIEnv *jenv, jobject job,
	jobjectArray oarr)
{
    Cargs *cargs = make_cargs(jenv, oarr);
    extern int dacscheck_main(int argc, char **argv);

   return(dacscheck_main(cargs->argc, cargs->argv));

//  (*jenv)->ReleaseStringUTFChars(jenv, myObject, str); 

}

JNIEXPORT jint JNICALL 
Java_ca_dss_dacs_DACSAUTH_dacsauth(JNIEnv *jenv, jobject job, jobjectArray oarr)
{
    Cargs *cargs = make_cargs(jenv, oarr);
    extern int dacsauth_main(int argc, char **argv);

   return(dacsauth_main(cargs->argc, cargs->argv));

//  (*jenv)->ReleaseStringUTFChars(jenv, myObject, str); 

}

