#include "webinterface"
#include "balancer/balancer"

void Webinterface::execute() {
    Threadlist::desc("Web interface");

    // Create the server socket, or retry infinitely.
    // This is maybe a too big precaution - previous xr's are responsible
    // for killing off their web interfaces. But we don't want a new xr
    // start to croak and cause downtime just because the web interface,
    // so we just retry for a bit.
    while (true) {
	try {
	    msg ("Starting web interface\n");
	    sfd = serversocket (config.webinterfaceip(),
				config.webinterfaceport(),
				"web interface", Servertype::t_tcp);
	} catch (Error const &e) {
	    cerr << e.what() << "(webinterface, retrying in a sec)\n";
	    sleep (1);
	    continue;
	}
	break;
    }

    msg ((Mstr("Web interface started on socket ") + sfd) + "\n");
    while (!balancer.terminate()) {
	try {
	    Fdset fdset(0);
	    fdset.add (sfd);
	    fdset.wait_r();
	    if (fdset.readable(sfd)) {
		int size;
		struct sockaddr_in clname;
		if ( (cfd = accept (sfd, (struct sockaddr *) &clname,
				    (socklen_t *)&size)) < 0 )
		    warnmsg(Mstr("Web interface: failed to accept "
				 "network connection: ") +
			    Mstr(strerror(errno)) + "\n");
		else {
		    serve ();
		    socketclose(cfd);
		}
	    }
	} catch (Error const &e) {
	    cerr <<  e.what() << " (webinterface)\n";
	    ostringstream m;
	    m <<
		"<h1>Web interface error</h1>\n"
		"XR's web interface could not handle your request.<p/>\n"
		"<i>" << e.what() << "</i>\n";
	    ostringstream o;
	    o <<
		"HTTP/1.0 500 Server Error\r\n"
		"X-Reason: " << e.what() << "\r\n"
		"Content-Length: " << m.str().length() << "\r\n"
		"\r\n" <<
		m.str();
	    Netbuffer buf(o.str());
	    buf.netwrite(cfd, config.client_write_timeout());
	    socketclose(cfd);
	}
    }
    msg ("Web interface stopping.\n");
    socketclose(sfd);
}
