/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : cif.g
 *     -                            On : 2013-04-16 18:47:22
 *     -                for the parser : cifParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "cifParser.h"
/* ----------------------------------------- */

/** CIF Version 1.1 Working specification grammar

Translated from the grammar defined at

http://www.iucr.org/resources/cif/spec/version1.1/cifsyntax#bnf

A compiled version of the parser, with C language target, but contains
C++ code in the actions, therefore the output files must be renamed to *.cpp

Richard Gildea
April 2010
*/




/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define         CTX     ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef  SCOPE_TYPE
#undef  SCOPE_STACK
#undef  SCOPE_TOP
#define SCOPE_TYPE(scope)   pcifParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pcifParser_##scope##Stack
#define SCOPE_TOP(scope)    ctx->pcifParser_##scope##Top
#define SCOPE_SIZE(scope)               ctx->pcifParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)        (ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef      PARSER
#undef      RECOGNIZER
#undef      HAVEPARSEDRULE
#undef          MEMOIZE
#undef      INPUT
#undef      STRSTREAM
#undef      HASEXCEPTION
#undef      EXCEPTION
#undef      MATCHT
#undef      MATCHANYT
#undef      FOLLOWSTACK
#undef      FOLLOWPUSH
#undef      FOLLOWPOP
#undef      PRECOVER
#undef      PREPORTERROR
#undef      LA
#undef      LT
#undef      CONSTRUCTEX
#undef      CONSUME
#undef      MARK
#undef      REWIND
#undef      REWINDLAST
#undef      PERRORRECOVERY
#undef      HASFAILED
#undef      FAILEDFLAG
#undef      RECOVERFROMMISMATCHEDSET
#undef      RECOVERFROMMISMATCHEDELEMENT
#undef          INDEX
#undef      ADAPTOR
#undef          SEEK
#undef      RULEMEMO
#undef          DBG

#define     PARSER                              ctx->pParser
#define     RECOGNIZER                          PARSER->rec
#define     PSRSTATE                            RECOGNIZER->state
#define     HAVEPARSEDRULE(r)                   RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define     MEMOIZE(ri,si)                      RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define     INPUT                               PARSER->tstream
#define     STRSTREAM                           INPUT
#define     ISTREAM                             INPUT->istream
#define     INDEX()                             ISTREAM->index(INPUT->istream)
#define     HASEXCEPTION()                      (PSRSTATE->error == ANTLR3_TRUE)
#define     EXCEPTION                           PSRSTATE->exception
#define     MATCHT(t, fs)                       RECOGNIZER->match(RECOGNIZER, t, fs)
#define     MATCHANYT()                         RECOGNIZER->matchAny(RECOGNIZER)
#define     FOLLOWSTACK                         PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define     FOLLOWPUSH(x)
#define     FOLLOWPOP()
#else
#define     FOLLOWPUSH(x)                       FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define     FOLLOWPOP()                         FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define     PRECOVER()                          RECOGNIZER->recover(RECOGNIZER)
#define     PREPORTERROR()                      RECOGNIZER->reportError(RECOGNIZER)
#define     LA(n)                               INPUT->istream->_LA(ISTREAM, n)
#define     LT(n)                               INPUT->_LT(INPUT, n)
#define     CONSTRUCTEX()                       RECOGNIZER->exConstruct(RECOGNIZER)
#define     CONSUME()                           ISTREAM->consume(ISTREAM)
#define     MARK()                              ISTREAM->mark(ISTREAM)
#define     REWIND(m)                           ISTREAM->rewind(ISTREAM, m)
#define     REWINDLAST()                        ISTREAM->rewindLast(ISTREAM)
#define     SEEK(n)                             ISTREAM->seek(ISTREAM, n)
#define     PERRORRECOVERY                      PSRSTATE->errorRecovery
#define     FAILEDFLAG                          PSRSTATE->failed
#define     HASFAILED()                         (FAILEDFLAG == ANTLR3_TRUE)
#define     BACKTRACKING                        PSRSTATE->backtracking
#define     RECOVERFROMMISMATCHEDSET(s)         RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define     RECOVERFROMMISMATCHEDELEMENT(e)     RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define         RULEMEMO                                                PSRSTATE->ruleMemo
#define         DBG                                                             RECOGNIZER->debugger


#define         TOKTEXT(tok, txt)                               tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define     UP      ANTLR3_TOKEN_UP
#define     DOWN    ANTLR3_TOKEN_DOWN
#define     EOR     ANTLR3_TOKEN_EOR
#define     INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */

/* ruleAttributeScopeFuncDecl(scope)
 */
/* -----------------------------------------------------------------------------
 * Function declarations for creating a cifParser_parse scope set
 */
static pcifParser_parse_SCOPE   pcifParser_parsePush(pcifParser ctx);
static void ANTLR3_CDECL parseFree(pcifParser_parse_SCOPE scope);
/* ----------------------------------------------------------------------------- */


/* ruleAttributeScopeFuncs(scope)
 */
/* attributeFuncs(scope)
 */

static void ANTLR3_CDECL parseFree(pcifParser_parse_SCOPE scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Allocate initial memory for a cifParser parse scope variable stack entry and
 *         add it to the top of the stack.
 *
 * \remark
 * By default the structure is freed with ANTLR_FREE(), but you can use the
 * the \@init action to install a pointer to a custom free() routine by
 * adding the code:
 * \code
 *   ctx->pcifParser_parseTop->free = myroutine;
 * \endcode
 *
 * With lots of comments of course! The routine should be declared in
 * \@members { } as:
 * \code
 *   void ANTLR3_CDECL myfunc( pcifParser_parse_SCOPE ptr).
 * \endcode
 *
 * It should perform any custom freeing stuff that you need (call ANTLR_FREE3, not free()
 * NB: It should not free the pointer it is given, which is the scope stack entry itself
 * and will be freed by the function that calls your custom free routine.
 *
 */
static pcifParser_parse_SCOPE
pcifParser_parsePush(pcifParser ctx)
{
    /* Pointer used to create a new set of attributes
     */
    pcifParser_parse_SCOPE      newAttributes;

    /* Allocate the memory for a new structure if we need one.
     */
    if (ctx->pcifParser_parseStack->size(ctx->pcifParser_parseStack) > ctx->pcifParser_parseStack_limit)
    {
        // The current limit value was less than the number of scopes available on the stack so
        // we can just reuse one. Our limit tracks the stack count, so the index of the entry we want
        // is one less than that, or conveniently, the current value of limit.
        //
        newAttributes = (pcifParser_parse_SCOPE)ctx->pcifParser_parseStack->get(ctx->pcifParser_parseStack, ctx->pcifParser_parseStack_limit);
    }
    else
    {
        // Need a new allocation
        //
        newAttributes = (pcifParser_parse_SCOPE) ANTLR3_MALLOC(sizeof(cifParser_parse_SCOPE));
        if  (newAttributes != NULL)
        {
            /* Standard ANTLR3 library implementation
             */
            ctx->pcifParser_parseStack->push(ctx->pcifParser_parseStack, newAttributes, (void (*)(void *))parseFree);
        }
    }

    // Blank out any previous free pointer, the user might or might install a new one.
    //
    newAttributes->free = NULL;

    // Indicate the position in the available stack that the current level is at
    //
    ctx->pcifParser_parseStack_limit++;

        /* Return value is the pointer to the new entry, which may be used locally
         * without de-referencing via the context.
     */
    return  newAttributes;
}




/* ruleAttributeScopeFuncDecl(scope)
 */
/* -----------------------------------------------------------------------------
 * Function declarations for creating a cifParser_loop_body scope set
 */
static pcifParser_loop_body_SCOPE   pcifParser_loop_bodyPush(pcifParser ctx);
static void ANTLR3_CDECL loop_bodyFree(pcifParser_loop_body_SCOPE scope);
/* ----------------------------------------------------------------------------- */


/* ruleAttributeScopeFuncs(scope)
 */
/* attributeFuncs(scope)
 */

static void ANTLR3_CDECL loop_bodyFree(pcifParser_loop_body_SCOPE scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Allocate initial memory for a cifParser loop_body scope variable stack entry and
 *         add it to the top of the stack.
 *
 * \remark
 * By default the structure is freed with ANTLR_FREE(), but you can use the
 * the \@init action to install a pointer to a custom free() routine by
 * adding the code:
 * \code
 *   ctx->pcifParser_loop_bodyTop->free = myroutine;
 * \endcode
 *
 * With lots of comments of course! The routine should be declared in
 * \@members { } as:
 * \code
 *   void ANTLR3_CDECL myfunc( pcifParser_loop_body_SCOPE ptr).
 * \endcode
 *
 * It should perform any custom freeing stuff that you need (call ANTLR_FREE3, not free()
 * NB: It should not free the pointer it is given, which is the scope stack entry itself
 * and will be freed by the function that calls your custom free routine.
 *
 */
static pcifParser_loop_body_SCOPE
pcifParser_loop_bodyPush(pcifParser ctx)
{
    /* Pointer used to create a new set of attributes
     */
    pcifParser_loop_body_SCOPE      newAttributes;

    /* Allocate the memory for a new structure if we need one.
     */
    if (ctx->pcifParser_loop_bodyStack->size(ctx->pcifParser_loop_bodyStack) > ctx->pcifParser_loop_bodyStack_limit)
    {
        // The current limit value was less than the number of scopes available on the stack so
        // we can just reuse one. Our limit tracks the stack count, so the index of the entry we want
        // is one less than that, or conveniently, the current value of limit.
        //
        newAttributes = (pcifParser_loop_body_SCOPE)ctx->pcifParser_loop_bodyStack->get(ctx->pcifParser_loop_bodyStack, ctx->pcifParser_loop_bodyStack_limit);
    }
    else
    {
        // Need a new allocation
        //
        newAttributes = (pcifParser_loop_body_SCOPE) ANTLR3_MALLOC(sizeof(cifParser_loop_body_SCOPE));
        if  (newAttributes != NULL)
        {
            /* Standard ANTLR3 library implementation
             */
            ctx->pcifParser_loop_bodyStack->push(ctx->pcifParser_loop_bodyStack, newAttributes, (void (*)(void *))loop_bodyFree);
        }
    }

    // Blank out any previous free pointer, the user might or might install a new one.
    //
    newAttributes->free = NULL;

    // Indicate the position in the available stack that the current level is at
    //
    ctx->pcifParser_loop_bodyStack_limit++;

        /* Return value is the pointer to the new entry, which may be used locally
         * without de-referencing via the context.
     */
    return  newAttributes;
}




/* ruleAttributeScopeFuncDecl(scope)
 */
/* -----------------------------------------------------------------------------
 * Function declarations for creating a cifParser_data_items scope set
 */
static pcifParser_data_items_SCOPE   pcifParser_data_itemsPush(pcifParser ctx);
static void ANTLR3_CDECL data_itemsFree(pcifParser_data_items_SCOPE scope);
/* ----------------------------------------------------------------------------- */


/* ruleAttributeScopeFuncs(scope)
 */
/* attributeFuncs(scope)
 */

static void ANTLR3_CDECL data_itemsFree(pcifParser_data_items_SCOPE scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Allocate initial memory for a cifParser data_items scope variable stack entry and
 *         add it to the top of the stack.
 *
 * \remark
 * By default the structure is freed with ANTLR_FREE(), but you can use the
 * the \@init action to install a pointer to a custom free() routine by
 * adding the code:
 * \code
 *   ctx->pcifParser_data_itemsTop->free = myroutine;
 * \endcode
 *
 * With lots of comments of course! The routine should be declared in
 * \@members { } as:
 * \code
 *   void ANTLR3_CDECL myfunc( pcifParser_data_items_SCOPE ptr).
 * \endcode
 *
 * It should perform any custom freeing stuff that you need (call ANTLR_FREE3, not free()
 * NB: It should not free the pointer it is given, which is the scope stack entry itself
 * and will be freed by the function that calls your custom free routine.
 *
 */
static pcifParser_data_items_SCOPE
pcifParser_data_itemsPush(pcifParser ctx)
{
    /* Pointer used to create a new set of attributes
     */
    pcifParser_data_items_SCOPE      newAttributes;

    /* Allocate the memory for a new structure if we need one.
     */
    if (ctx->pcifParser_data_itemsStack->size(ctx->pcifParser_data_itemsStack) > ctx->pcifParser_data_itemsStack_limit)
    {
        // The current limit value was less than the number of scopes available on the stack so
        // we can just reuse one. Our limit tracks the stack count, so the index of the entry we want
        // is one less than that, or conveniently, the current value of limit.
        //
        newAttributes = (pcifParser_data_items_SCOPE)ctx->pcifParser_data_itemsStack->get(ctx->pcifParser_data_itemsStack, ctx->pcifParser_data_itemsStack_limit);
    }
    else
    {
        // Need a new allocation
        //
        newAttributes = (pcifParser_data_items_SCOPE) ANTLR3_MALLOC(sizeof(cifParser_data_items_SCOPE));
        if  (newAttributes != NULL)
        {
            /* Standard ANTLR3 library implementation
             */
            ctx->pcifParser_data_itemsStack->push(ctx->pcifParser_data_itemsStack, newAttributes, (void (*)(void *))data_itemsFree);
        }
    }

    // Blank out any previous free pointer, the user might or might install a new one.
    //
    newAttributes->free = NULL;

    // Indicate the position in the available stack that the current level is at
    //
    ctx->pcifParser_data_itemsStack_limit++;

        /* Return value is the pointer to the new entry, which may be used locally
         * without de-referencing via the context.
     */
    return  newAttributes;
}







/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   cifParserTokenNames[34+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ANY_PRINT_CHAR",
        (pANTLR3_UINT8) "CHAR_STRING",
        (pANTLR3_UINT8) "COMMENTS",
        (pANTLR3_UINT8) "DATA_",
        (pANTLR3_UINT8) "DATA_BLOCK_HEADING",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DOUBLE_QUOTE",
        (pANTLR3_UINT8) "DOUBLE_QUOTED_STRING",
        (pANTLR3_UINT8) "EOL",
        (pANTLR3_UINT8) "EXPONENT",
        (pANTLR3_UINT8) "FLOAT",
        (pANTLR3_UINT8) "GLOBAL_",
        (pANTLR3_UINT8) "INAPPLICABLE",
        (pANTLR3_UINT8) "INTEGER",
        (pANTLR3_UINT8) "LOOP_",
        (pANTLR3_UINT8) "NON_BLANK_CHAR",
        (pANTLR3_UINT8) "NON_BLANK_CHAR_",
        (pANTLR3_UINT8) "NUMBER",
        (pANTLR3_UINT8) "NUMERIC",
        (pANTLR3_UINT8) "ORDINARY_CHAR",
        (pANTLR3_UINT8) "SAVE",
        (pANTLR3_UINT8) "SAVE_",
        (pANTLR3_UINT8) "SAVE_FRAME_HEADING",
        (pANTLR3_UINT8) "SEMI_COLON_TEXT_FIELD",
        (pANTLR3_UINT8) "SINGLE_QUOTE",
        (pANTLR3_UINT8) "SINGLE_QUOTED_STRING",
        (pANTLR3_UINT8) "STOP_",
        (pANTLR3_UINT8) "TAG",
        (pANTLR3_UINT8) "TEXT_LEAD_CHAR",
        (pANTLR3_UINT8) "UNKNOWN",
        (pANTLR3_UINT8) "UNQUOTED_STRING",
        (pANTLR3_UINT8) "UNSIGNED_INTEGER",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "'\\u001a'"
       };


/* ruleAttributeScopeFuncMacro(scope)
 */
/** Function for popping the top value from a pcifParser_parseStack
 */
void
pcifParser_parsePop(pcifParser ctx)
{
    // First see if the user defined a function they want to be called when a
    // scope is popped/freed.
    //
        // If the user supplied the scope entries with a free function,then call it first
        //
    if  (SCOPE_TOP(parse)->free != NULL)
        {
        SCOPE_TOP(parse)->free(SCOPE_TOP(parse));
        }

    // Now we decrement the scope's upper limit bound. We do not actually pop the scope as
    // we want to reuse scope entries if we do continuous push and pops. Most scopes don't
    // next too far so we don't want to keep freeing and allocating them
    //
    ctx->pcifParser_parseStack_limit--;
    SCOPE_TOP(parse) = (pcifParser_parse_SCOPE)(ctx->pcifParser_parseStack->get(ctx->pcifParser_parseStack, ctx->pcifParser_parseStack_limit - 1));
}


/* ruleAttributeScopeFuncMacro(scope)
 */
/** Function for popping the top value from a pcifParser_loop_bodyStack
 */
void
pcifParser_loop_bodyPop(pcifParser ctx)
{
    // First see if the user defined a function they want to be called when a
    // scope is popped/freed.
    //
        // If the user supplied the scope entries with a free function,then call it first
        //
    if  (SCOPE_TOP(loop_body)->free != NULL)
        {
        SCOPE_TOP(loop_body)->free(SCOPE_TOP(loop_body));
        }

    // Now we decrement the scope's upper limit bound. We do not actually pop the scope as
    // we want to reuse scope entries if we do continuous push and pops. Most scopes don't
    // next too far so we don't want to keep freeing and allocating them
    //
    ctx->pcifParser_loop_bodyStack_limit--;
    SCOPE_TOP(loop_body) = (pcifParser_loop_body_SCOPE)(ctx->pcifParser_loop_bodyStack->get(ctx->pcifParser_loop_bodyStack, ctx->pcifParser_loop_bodyStack_limit - 1));
}


/* ruleAttributeScopeFuncMacro(scope)
 */
/** Function for popping the top value from a pcifParser_data_itemsStack
 */
void
pcifParser_data_itemsPop(pcifParser ctx)
{
    // First see if the user defined a function they want to be called when a
    // scope is popped/freed.
    //
        // If the user supplied the scope entries with a free function,then call it first
        //
    if  (SCOPE_TOP(data_items)->free != NULL)
        {
        SCOPE_TOP(data_items)->free(SCOPE_TOP(data_items));
        }

    // Now we decrement the scope's upper limit bound. We do not actually pop the scope as
    // we want to reuse scope entries if we do continuous push and pops. Most scopes don't
    // next too far so we don't want to keep freeing and allocating them
    //
    ctx->pcifParser_data_itemsStack_limit--;
    SCOPE_TOP(data_items) = (pcifParser_data_items_SCOPE)(ctx->pcifParser_data_itemsStack->get(ctx->pcifParser_data_itemsStack, ctx->pcifParser_data_itemsStack_limit - 1));
}



// Forward declare the locally static matching functions we have generated.
//
static
 void
        parse    (pcifParser ctx, ucif::builder_base* builder_, bool strict_);
static
 void
        cif    (pcifParser ctx);
static
 void
        loop_body    (pcifParser ctx);
static
 void
        save_frame    (pcifParser ctx);
static
 void
        data_items    (pcifParser ctx);
static
 void
        data_block    (pcifParser ctx);
static
 void
        loop_header    (pcifParser ctx);
static
 cifParser_value_return
        value    (pcifParser ctx);
static
 void
        char_string    (pcifParser ctx);
static
 void
        text_field    (pcifParser ctx);
static void     cifParserFree(pcifParser ctx);
static void     cifParserReset (pcifParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static  void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "cif.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
        return fileName;
}
/** \brief Create a new cifParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pcifParser
cifParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
        // See if we can create a new parser with the standard constructor
        //
        return cifParserNewSSD(instream, NULL);
}

/** \brief Create a new cifParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pcifParser
cifParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pcifParser ctx;         /* Context structure we will build and return   */

    ctx = (pcifParser) ANTLR3_CALLOC(1, sizeof(cifParser));

    if  (ctx == NULL)
    {
                // Failed to allocate memory for parser context
                //
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in cifParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser            = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our cifParser interface
     */
    ctx->parse  = parse;
    ctx->cif    = cif;
    ctx->loop_body      = loop_body;
    ctx->save_frame     = save_frame;
    ctx->data_items     = data_items;
    ctx->data_block     = data_block;
    ctx->loop_header    = loop_header;
    ctx->value  = value;
    ctx->char_string    = char_string;
    ctx->text_field     = text_field;
    ctx->free                   = cifParserFree;
    ctx->reset                  = cifParserReset;
    ctx->getGrammarFileName     = getGrammarFileName;

    /* Install the scope pushing methods.
     */
    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_parsePush     = pcifParser_parsePush;
    ctx->pcifParser_parseStack    = antlr3StackNew(0);
    ctx->pcifParser_parseStack_limit    = 0;
    ctx->pcifParser_parseTop      = NULL;


    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_loop_bodyPush     = pcifParser_loop_bodyPush;
    ctx->pcifParser_loop_bodyStack    = antlr3StackNew(0);
    ctx->pcifParser_loop_bodyStack_limit    = 0;
    ctx->pcifParser_loop_bodyTop      = NULL;


    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_data_itemsPush     = pcifParser_data_itemsPush;
    ctx->pcifParser_data_itemsStack    = antlr3StackNew(0);
    ctx->pcifParser_data_itemsStack_limit    = 0;
    ctx->pcifParser_data_itemsTop      = NULL;





      PARSER->super = (void *)ctx;

    /* Install the token table
     */
    PSRSTATE->tokenNames   = cifParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
cifParserReset (pcifParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 cifParserFree(pcifParser ctx)
 {
    /* Free any scope memory
     */
    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_parseStack->free(ctx->pcifParser_parseStack);


    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_loop_bodyStack->free(ctx->pcifParser_loop_bodyStack);


    /* ruleAttributeScope(scope)
     */
    ctx->pcifParser_data_itemsStack->free(ctx->pcifParser_data_itemsStack);



        // Free this parser
        //
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return cifParserTokenNames;
}


    std::string to_std_string(pANTLR3_COMMON_TOKEN token) {
      ANTLR3_MARKER start = token->start;
      ANTLR3_MARKER stop = token->stop;
      std::string str((const char*)start, stop-start+1);
      if ((str[0] == '\'' && str[str.size()-1] == '\'') ||
        (str[0] == '"' && str[str.size()-1] == '"'))
      { str = str.substr(1, str.size()-2); }
      return str;
    }


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cif_in_parse95  */
static  ANTLR3_BITWORD FOLLOW_cif_in_parse95_bits[]     = { ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cif_in_parse95        = { FOLLOW_cif_in_parse95_bits, 1       };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_parse97  */
static  ANTLR3_BITWORD FOLLOW_set_in_parse97_bits[]     = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_parse97        = { FOLLOW_set_in_parse97_bits, 1       };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMENTS_in_cif118  */
static  ANTLR3_BITWORD FOLLOW_COMMENTS_in_cif118_bits[] = { ANTLR3_UINT64_LIT(0x0000000000008102) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMENTS_in_cif118    = { FOLLOW_COMMENTS_in_cif118_bits, 1   };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_block_in_cif121  */
static  ANTLR3_BITWORD FOLLOW_data_block_in_cif121_bits[]       = { ANTLR3_UINT64_LIT(0x0000000000008102) };
static  ANTLR3_BITSET_LIST FOLLOW_data_block_in_cif121  = { FOLLOW_data_block_in_cif121_bits, 1 };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_value_in_loop_body146  */
static  ANTLR3_BITWORD FOLLOW_value_in_loop_body146_bits[]      = { ANTLR3_UINT64_LIT(0x0000000208410022) };
static  ANTLR3_BITSET_LIST FOLLOW_value_in_loop_body146 = { FOLLOW_value_in_loop_body146_bits, 1        };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_value_in_loop_body156  */
static  ANTLR3_BITWORD FOLLOW_value_in_loop_body156_bits[]      = { ANTLR3_UINT64_LIT(0x0000000208410022) };
static  ANTLR3_BITSET_LIST FOLLOW_value_in_loop_body156 = { FOLLOW_value_in_loop_body156_bits, 1        };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SAVE_FRAME_HEADING_in_save_frame174  */
static  ANTLR3_BITWORD FOLLOW_SAVE_FRAME_HEADING_in_save_frame174_bits[]        = { ANTLR3_UINT64_LIT(0x0000000080040000) };
static  ANTLR3_BITSET_LIST FOLLOW_SAVE_FRAME_HEADING_in_save_frame174   = { FOLLOW_SAVE_FRAME_HEADING_in_save_frame174_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_items_in_save_frame182  */
static  ANTLR3_BITWORD FOLLOW_data_items_in_save_frame182_bits[]        = { ANTLR3_UINT64_LIT(0x0000000081040000) };
static  ANTLR3_BITSET_LIST FOLLOW_data_items_in_save_frame182   = { FOLLOW_data_items_in_save_frame182_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SAVE_in_save_frame187  */
static  ANTLR3_BITWORD FOLLOW_SAVE_in_save_frame187_bits[]      = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SAVE_in_save_frame187 = { FOLLOW_SAVE_in_save_frame187_bits, 1        };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TAG_in_data_items216  */
static  ANTLR3_BITWORD FOLLOW_TAG_in_data_items216_bits[]       = { ANTLR3_UINT64_LIT(0x0000000208410020) };
static  ANTLR3_BITSET_LIST FOLLOW_TAG_in_data_items216  = { FOLLOW_TAG_in_data_items216_bits, 1 };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_value_in_data_items218  */
static  ANTLR3_BITWORD FOLLOW_value_in_data_items218_bits[]     = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_value_in_data_items218        = { FOLLOW_value_in_data_items218_bits, 1       };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_loop_header_in_data_items226  */
static  ANTLR3_BITWORD FOLLOW_loop_header_in_data_items226_bits[]       = { ANTLR3_UINT64_LIT(0x0000000208410020) };
static  ANTLR3_BITSET_LIST FOLLOW_loop_header_in_data_items226  = { FOLLOW_loop_header_in_data_items226_bits, 1 };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_loop_body_in_data_items228  */
static  ANTLR3_BITWORD FOLLOW_loop_body_in_data_items228_bits[] = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_loop_body_in_data_items228    = { FOLLOW_loop_body_in_data_items228_bits, 1   };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATA_BLOCK_HEADING_in_data_block245  */
static  ANTLR3_BITWORD FOLLOW_DATA_BLOCK_HEADING_in_data_block245_bits[]        = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATA_BLOCK_HEADING_in_data_block245   = { FOLLOW_DATA_BLOCK_HEADING_in_data_block245_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_items_in_data_block255  */
static  ANTLR3_BITWORD FOLLOW_data_items_in_data_block255_bits[]        = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_data_items_in_data_block255   = { FOLLOW_data_items_in_data_block255_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_save_frame_in_data_block259  */
static  ANTLR3_BITWORD FOLLOW_save_frame_in_data_block259_bits[]        = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_save_frame_in_data_block259   = { FOLLOW_save_frame_in_data_block259_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GLOBAL__in_data_block278  */
static  ANTLR3_BITWORD FOLLOW_GLOBAL__in_data_block278_bits[]   = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_GLOBAL__in_data_block278      = { FOLLOW_GLOBAL__in_data_block278_bits, 1     };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_items_in_data_block284  */
static  ANTLR3_BITWORD FOLLOW_data_items_in_data_block284_bits[]        = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_data_items_in_data_block284   = { FOLLOW_data_items_in_data_block284_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_save_frame_in_data_block288  */
static  ANTLR3_BITWORD FOLLOW_save_frame_in_data_block288_bits[]        = { ANTLR3_UINT64_LIT(0x0000000084040002) };
static  ANTLR3_BITSET_LIST FOLLOW_save_frame_in_data_block288   = { FOLLOW_save_frame_in_data_block288_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOOP__in_loop_header307  */
static  ANTLR3_BITWORD FOLLOW_LOOP__in_loop_header307_bits[]    = { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LOOP__in_loop_header307       = { FOLLOW_LOOP__in_loop_header307_bits, 1      };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TAG_in_loop_header311  */
static  ANTLR3_BITWORD FOLLOW_TAG_in_loop_header311_bits[]      = { ANTLR3_UINT64_LIT(0x0000000080000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TAG_in_loop_header311 = { FOLLOW_TAG_in_loop_header311_bits, 1        };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INAPPLICABLE_in_value333  */
static  ANTLR3_BITWORD FOLLOW_INAPPLICABLE_in_value333_bits[]   = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INAPPLICABLE_in_value333      = { FOLLOW_INAPPLICABLE_in_value333_bits, 1     };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNKNOWN_in_value337  */
static  ANTLR3_BITWORD FOLLOW_UNKNOWN_in_value337_bits[]        = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNKNOWN_in_value337   = { FOLLOW_UNKNOWN_in_value337_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMERIC_in_value341  */
static  ANTLR3_BITWORD FOLLOW_NUMERIC_in_value341_bits[]        = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMERIC_in_value341   = { FOLLOW_NUMERIC_in_value341_bits, 1  };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_char_string_in_value345  */
static  ANTLR3_BITWORD FOLLOW_char_string_in_value345_bits[]    = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_char_string_in_value345       = { FOLLOW_char_string_in_value345_bits, 1      };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_text_field_in_value349  */
static  ANTLR3_BITWORD FOLLOW_text_field_in_value349_bits[]     = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_text_field_in_value349        = { FOLLOW_text_field_in_value349_bits, 1       };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHAR_STRING_in_char_string362  */
static  ANTLR3_BITWORD FOLLOW_CHAR_STRING_in_char_string362_bits[]      = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHAR_STRING_in_char_string362 = { FOLLOW_CHAR_STRING_in_char_string362_bits, 1        };
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMI_COLON_TEXT_FIELD_in_text_field373  */
static  ANTLR3_BITWORD FOLLOW_SEMI_COLON_TEXT_FIELD_in_text_field373_bits[]     = { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMI_COLON_TEXT_FIELD_in_text_field373        = { FOLLOW_SEMI_COLON_TEXT_FIELD_in_text_field373_bits, 1       };


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parse
 * cif.g:66:1: parse[ucif::builder_base* builder_, bool strict_] : cif ( EOF | '\\u001a' ) ;
 */
static void
parse(pcifParser ctx, ucif::builder_base* builder_, bool strict_)
{
    /* Initialize rule variables
     */
    ctx->pcifParser_parseTop = pcifParser_parsePush(ctx);

      (SCOPE_TOP(parse))->builder= builder_;
      (SCOPE_TOP(parse))->strict= strict_;

    {
        // cif.g:75:3: ( cif ( EOF | '\\u001a' ) )
        // cif.g:75:5: cif ( EOF | '\\u001a' )
        {
            FOLLOWPUSH(FOLLOW_cif_in_parse95);
            cif(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparseEx;
            }


            if ( LA(1) == EOF || LA(1) == 37 )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
            }
            else
            {
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto ruleparseEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparseEx; /* Prevent compiler warnings */
    ruleparseEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    pcifParser_parsePop(ctx);

    return ;
}
/* $ANTLR end parse */

/**
 * $ANTLR start cif
 * cif.g:80:1: cif : ( COMMENTS )? ( data_block )* ;
 */
static void
cif(pcifParser ctx)
{
    /* Initialize rule variables
     */

    {
        // cif.g:81:3: ( ( COMMENTS )? ( data_block )* )
        // cif.g:81:5: ( COMMENTS )? ( data_block )*
        {
            // cif.g:81:5: ( COMMENTS )?
            {
                int alt1=2;
                switch ( LA(1) )
                {
                    case COMMENTS:
                        {
                                alt1=1;
                        }
                        break;
                }

                switch (alt1)
                {
                case 1:
                    // cif.g:81:5: COMMENTS
                    {
                         MATCHT(COMMENTS, &FOLLOW_COMMENTS_in_cif118);
                        if  (HASEXCEPTION())
                        {
                            goto rulecifEx;
                        }


                    }
                    break;

                }
            }

            // cif.g:81:15: ( data_block )*

            for (;;)
            {
                int alt2=2;
                {
                   /* dfaLoopbackState(k,edges,eotPredictsAlt,description,stateNumber,semPredState)
                    */
                    int LA2_0 = LA(1);
                    if ( (LA2_0 == DATA_BLOCK_HEADING))
                    {
                        alt2=1;
                    }
                    else if ( ((!(SCOPE_TOP(parse))->strict)) && (LA2_0 == GLOBAL_))
                    {
                        alt2=1;
                    }

                }
                switch (alt2)
                {
                case 1:
                    // cif.g:81:15: data_block
                    {
                        FOLLOWPUSH(FOLLOW_data_block_in_cif121);
                        data_block(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto rulecifEx;
                        }


                    }
                    break;

                default:
                    goto loop2; /* break out of the loop */
                    break;
                }
            }
            loop2: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecifEx; /* Prevent compiler warnings */
    rulecifEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end cif */

/**
 * $ANTLR start loop_body
 * cif.g:84:1: loop_body : v1= value (v2= value )* ;
 */
static void
loop_body(pcifParser ctx)
{
    cifParser_value_return v1;
    #undef      RETURN_TYPE_v1
    #define     RETURN_TYPE_v1 cifParser_value_return

    cifParser_value_return v2;
    #undef      RETURN_TYPE_v2
    #define     RETURN_TYPE_v2 cifParser_value_return

    /* Initialize rule variables
     */
    ctx->pcifParser_loop_bodyTop = pcifParser_loop_bodyPush(ctx);

      (SCOPE_TOP(loop_body))->column_cntr= 0;

    {
        // cif.g:91:3: (v1= value (v2= value )* )
        // cif.g:91:5: v1= value (v2= value )*
        {
            FOLLOWPUSH(FOLLOW_value_in_loop_body146);
            v1=value(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleloop_bodyEx;
            }


            {

                  if (((SCOPE_TOP(data_items))->curr_loop_values)->size() > 0) {
                    (*((SCOPE_TOP(data_items))->curr_loop_values))[0]->push_back(to_std_string((v1.start)));
                  }

            }


            // cif.g:97:3: (v2= value )*

            for (;;)
            {
                int alt3=2;
                switch ( LA(1) )
                {
                case CHAR_STRING:
                case INAPPLICABLE:
                case NUMERIC:
                case SEMI_COLON_TEXT_FIELD:
                case UNKNOWN:
                        {
                                alt3=1;
                        }
                    break;

                }

                switch (alt3)
                {
                case 1:
                    // cif.g:97:5: v2= value
                    {
                        FOLLOWPUSH(FOLLOW_value_in_loop_body156);
                        v2=value(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto ruleloop_bodyEx;
                        }


                        {

                              (SCOPE_TOP(loop_body))->column_cntr++;
                              if ((SCOPE_TOP(loop_body))->column_cntr == ((SCOPE_TOP(data_items))->curr_loop_headers)->size()) {
                                (SCOPE_TOP(loop_body))->column_cntr= 0;
                              }
                              (*((SCOPE_TOP(data_items))->curr_loop_values))[(SCOPE_TOP(loop_body))->column_cntr]->push_back(to_std_string((v2.start)));

                        }


                    }
                    break;

                default:
                    goto loop3; /* break out of the loop */
                    break;
                }
            }
            loop3: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleloop_bodyEx; /* Prevent compiler warnings */
    ruleloop_bodyEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    pcifParser_loop_bodyPop(ctx);

    return ;
}
/* $ANTLR end loop_body */

/**
 * $ANTLR start save_frame
 * cif.g:108:1: save_frame : SAVE_FRAME_HEADING ( data_items )+ SAVE ;
 */
static void
save_frame(pcifParser ctx)
{
    pANTLR3_COMMON_TOKEN    SAVE_FRAME_HEADING1;

    /* Initialize rule variables
     */

    SAVE_FRAME_HEADING1       = NULL;

    {
        // cif.g:109:3: ( SAVE_FRAME_HEADING ( data_items )+ SAVE )
        // cif.g:109:5: SAVE_FRAME_HEADING ( data_items )+ SAVE
        {
            SAVE_FRAME_HEADING1 = (pANTLR3_COMMON_TOKEN) MATCHT(SAVE_FRAME_HEADING, &FOLLOW_SAVE_FRAME_HEADING_in_save_frame174);
            if  (HASEXCEPTION())
            {
                goto rulesave_frameEx;
            }


            {
                 ((SCOPE_TOP(parse))->builder)->start_save_frame(to_std_string(SAVE_FRAME_HEADING1));
            }


            // cif.g:111:3: ( data_items )+
            {
                int cnt4=0;

                for (;;)
                {
                    int alt4=2;
                switch ( LA(1) )
                {
                case LOOP_:
                case TAG:
                        {
                                alt4=1;
                        }
                    break;

                }

                switch (alt4)
                {
                    case 1:
                        // cif.g:111:5: data_items
                        {
                            FOLLOWPUSH(FOLLOW_data_items_in_save_frame182);
                            data_items(ctx);

                            FOLLOWPOP();
                            if  (HASEXCEPTION())
                            {
                                goto rulesave_frameEx;
                            }


                        }
                        break;

                    default:

                        if ( cnt4 >= 1 )
                        {
                            goto loop4;
                        }
                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto rulesave_frameEx;
                }
                cnt4++;
                }
                loop4: ;        /* Jump to here if this rule does not match */
            }

             MATCHT(SAVE, &FOLLOW_SAVE_in_save_frame187);
            if  (HASEXCEPTION())
            {
                goto rulesave_frameEx;
            }


            {
                 ((SCOPE_TOP(parse))->builder)->end_save_frame();
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesave_frameEx; /* Prevent compiler warnings */
    rulesave_frameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end save_frame */

/**
 * $ANTLR start data_items
 * cif.g:115:1: data_items : ( TAG value | loop_header loop_body );
 */
static void
data_items(pcifParser ctx)
{
    pANTLR3_COMMON_TOKEN    TAG3;
    cifParser_value_return value2;
    #undef      RETURN_TYPE_value2
    #define     RETURN_TYPE_value2 cifParser_value_return

    /* Initialize rule variables
     */
    ctx->pcifParser_data_itemsTop = pcifParser_data_itemsPush(ctx);

      (SCOPE_TOP(data_items))->curr_loop_values= new std::vector<ucif::array_wrapper_base*>();
      (SCOPE_TOP(data_items))->curr_loop_headers= ((SCOPE_TOP(parse))->builder)->new_array();

    TAG3       = NULL;

    {
        {
            //  cif.g:131:3: ( TAG value | loop_header loop_body )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case TAG:
                {
                        alt5=1;
                }
                break;
            case LOOP_:
                {
                        alt5=2;
                }
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto ruledata_itemsEx;

            }

            switch (alt5)
            {
                case 1:
                    // cif.g:131:5: TAG value
                    {
                        TAG3 = (pANTLR3_COMMON_TOKEN) MATCHT(TAG, &FOLLOW_TAG_in_data_items216);
                        if  (HASEXCEPTION())
                        {
                            goto ruledata_itemsEx;
                        }


                        FOLLOWPUSH(FOLLOW_value_in_data_items218);
                        value2=value(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto ruledata_itemsEx;
                        }


                        {

                              if (((value2.start))->type != EOF) {
                                ((SCOPE_TOP(parse))->builder)->add_data_item(
                                  to_std_string(TAG3),
                                  to_std_string((value2.start)));
                              }

                        }


                    }
                    break;
                case 2:
                    // cif.g:139:5: loop_header loop_body
                    {
                        FOLLOWPUSH(FOLLOW_loop_header_in_data_items226);
                        loop_header(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto ruledata_itemsEx;
                        }


                        FOLLOWPUSH(FOLLOW_loop_body_in_data_items228);
                        loop_body(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto ruledata_itemsEx;
                        }


                        {

                              std::vector<ucif::array_wrapper_base*> values = *((SCOPE_TOP(data_items))->curr_loop_values);
                              std::size_t n_cols = (SCOPE_TOP(data_items))->curr_loop_headers->size();
                              if (n_cols > 0) {
                                std::size_t n_rows = values[0]->size();
                                bool loop_is_good = true;
                                for (std::size_t i=1; i<n_cols; i++) {
                                  if (values[i]->size() != n_rows) {
                                    std::string msg = "Wrong number of data items for loop containing ";
                                    msg += (*(SCOPE_TOP(data_items))->curr_loop_headers)[0];
                                    CTX->errors->push_back(msg);
                                    loop_is_good = false;
                                    break;
                                  }
                                }
                                if (loop_is_good) {
                                  ((SCOPE_TOP(parse))->builder)->add_loop(*(SCOPE_TOP(data_items))->curr_loop_headers, values);
                                }
                              }

                        }


                    }
                    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledata_itemsEx; /* Prevent compiler warnings */
    ruledata_itemsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      for (std::size_t i=0; i<((SCOPE_TOP(data_items))->curr_loop_values)->size(); i++) {
                        delete (*((SCOPE_TOP(data_items))->curr_loop_values))[i];
                      }
                      delete (SCOPE_TOP(data_items))->curr_loop_values;
                      delete (SCOPE_TOP(data_items))->curr_loop_headers;

                }
            }


    pcifParser_data_itemsPop(ctx);

    return ;
}
/* $ANTLR end data_items */

/**
 * $ANTLR start data_block
 * cif.g:162:1: data_block : ( ( DATA_BLOCK_HEADING ( ( data_items | save_frame ) )* ) | ({...}? => GLOBAL_ ( ( data_items | save_frame ) )* ) );
 */
static void
data_block(pcifParser ctx)
{
    pANTLR3_COMMON_TOKEN    DATA_BLOCK_HEADING4;

    /* Initialize rule variables
     */

    DATA_BLOCK_HEADING4       = NULL;

    {
        {
            //  cif.g:163:3: ( ( DATA_BLOCK_HEADING ( ( data_items | save_frame ) )* ) | ({...}? => GLOBAL_ ( ( data_items | save_frame ) )* ) )

            ANTLR3_UINT32 alt10;

            alt10=2;

            {
                int LA10_0 = LA(1);
                if ( (LA10_0 == DATA_BLOCK_HEADING))
                {
                    alt10=1;
                }
                else if ( ((!(SCOPE_TOP(parse))->strict)) && (LA10_0 == GLOBAL_))
                {
                    alt10=2;
                }
                else
                {

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 10;
                    EXCEPTION->state        = 0;


                    goto ruledata_blockEx;

                }
            }
            switch (alt10)
            {
                case 1:
                    // cif.g:163:5: ( DATA_BLOCK_HEADING ( ( data_items | save_frame ) )* )
                    {
                        // cif.g:163:5: ( DATA_BLOCK_HEADING ( ( data_items | save_frame ) )* )
                        // cif.g:163:7: DATA_BLOCK_HEADING ( ( data_items | save_frame ) )*
                        {
                            DATA_BLOCK_HEADING4 = (pANTLR3_COMMON_TOKEN) MATCHT(DATA_BLOCK_HEADING, &FOLLOW_DATA_BLOCK_HEADING_in_data_block245);
                            if  (HASEXCEPTION())
                            {
                                goto ruledata_blockEx;
                            }


                            {
                                 ((SCOPE_TOP(parse))->builder)->add_data_block(to_std_string(DATA_BLOCK_HEADING4));
                            }


                            // cif.g:165:3: ( ( data_items | save_frame ) )*

                            for (;;)
                            {
                                int alt7=2;
                                switch ( LA(1) )
                                {
                                case LOOP_:
                                case SAVE_FRAME_HEADING:
                                case TAG:
                                        {
                                                alt7=1;
                                        }
                                    break;

                                }

                                switch (alt7)
                                {
                                case 1:
                                    // cif.g:165:5: ( data_items | save_frame )
                                    {
                                        // cif.g:165:5: ( data_items | save_frame )
                                        {
                                            int alt6=2;
                                            switch ( LA(1) )
                                            {
                                            case LOOP_:
                                            case TAG:
                                                {
                                                        alt6=1;
                                                }
                                                break;
                                            case SAVE_FRAME_HEADING:
                                                {
                                                        alt6=2;
                                                }
                                                break;

                                            default:
                                                CONSTRUCTEX();
                                                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                                                EXCEPTION->message      = (void *)"";
                                                EXCEPTION->decisionNum  = 6;
                                                EXCEPTION->state        = 0;


                                                goto ruledata_blockEx;

                                            }

                                            switch (alt6)
                                            {
                                                case 1:
                                                    // cif.g:165:7: data_items
                                                    {
                                                        FOLLOWPUSH(FOLLOW_data_items_in_data_block255);
                                                        data_items(ctx);

                                                        FOLLOWPOP();
                                                        if  (HASEXCEPTION())
                                                        {
                                                            goto ruledata_blockEx;
                                                        }


                                                    }
                                                    break;
                                                case 2:
                                                    // cif.g:165:20: save_frame
                                                    {
                                                        FOLLOWPUSH(FOLLOW_save_frame_in_data_block259);
                                                        save_frame(ctx);

                                                        FOLLOWPOP();
                                                        if  (HASEXCEPTION())
                                                        {
                                                            goto ruledata_blockEx;
                                                        }


                                                    }
                                                    break;

                                            }
                                        }

                                    }
                                    break;

                                default:
                                    goto loop7; /* break out of the loop */
                                    break;
                                }
                            }
                            loop7: ; /* Jump out to here if this rule does not match */


                        }


                    }
                    break;
                case 2:
                    // cif.g:167:5: ({...}? => GLOBAL_ ( ( data_items | save_frame ) )* )
                    {
                        // cif.g:167:5: ({...}? => GLOBAL_ ( ( data_items | save_frame ) )* )
                        // cif.g:167:7: {...}? => GLOBAL_ ( ( data_items | save_frame ) )*
                        {
                            if ( !((!(SCOPE_TOP(parse))->strict)) )
                            {
                                    CONSTRUCTEX();
                                    EXCEPTION->type         = ANTLR3_FAILED_PREDICATE_EXCEPTION;
                                    EXCEPTION->message      = (void *)"!$parse::strict";
                                    EXCEPTION->ruleName  = (void *)"data_block";


                            }

                             MATCHT(GLOBAL_, &FOLLOW_GLOBAL__in_data_block278);
                            if  (HASEXCEPTION())
                            {
                                goto ruledata_blockEx;
                            }


                            // cif.g:167:35: ( ( data_items | save_frame ) )*

                            for (;;)
                            {
                                int alt9=2;
                                switch ( LA(1) )
                                {
                                case LOOP_:
                                case SAVE_FRAME_HEADING:
                                case TAG:
                                        {
                                                alt9=1;
                                        }
                                    break;

                                }

                                switch (alt9)
                                {
                                case 1:
                                    // cif.g:167:37: ( data_items | save_frame )
                                    {
                                        // cif.g:167:37: ( data_items | save_frame )
                                        {
                                            int alt8=2;
                                            switch ( LA(1) )
                                            {
                                            case LOOP_:
                                            case TAG:
                                                {
                                                        alt8=1;
                                                }
                                                break;
                                            case SAVE_FRAME_HEADING:
                                                {
                                                        alt8=2;
                                                }
                                                break;

                                            default:
                                                CONSTRUCTEX();
                                                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                                                EXCEPTION->message      = (void *)"";
                                                EXCEPTION->decisionNum  = 8;
                                                EXCEPTION->state        = 0;


                                                goto ruledata_blockEx;

                                            }

                                            switch (alt8)
                                            {
                                                case 1:
                                                    // cif.g:167:39: data_items
                                                    {
                                                        FOLLOWPUSH(FOLLOW_data_items_in_data_block284);
                                                        data_items(ctx);

                                                        FOLLOWPOP();
                                                        if  (HASEXCEPTION())
                                                        {
                                                            goto ruledata_blockEx;
                                                        }


                                                    }
                                                    break;
                                                case 2:
                                                    // cif.g:167:52: save_frame
                                                    {
                                                        FOLLOWPUSH(FOLLOW_save_frame_in_data_block288);
                                                        save_frame(ctx);

                                                        FOLLOWPOP();
                                                        if  (HASEXCEPTION())
                                                        {
                                                            goto ruledata_blockEx;
                                                        }


                                                    }
                                                    break;

                                            }
                                        }

                                    }
                                    break;

                                default:
                                    goto loop9; /* break out of the loop */
                                    break;
                                }
                            }
                            loop9: ; /* Jump out to here if this rule does not match */


                        }


                    }
                    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledata_blockEx; /* Prevent compiler warnings */
    ruledata_blockEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end data_block */

/**
 * $ANTLR start loop_header
 * cif.g:170:1: loop_header : LOOP_ ( TAG )+ ;
 */
static void
loop_header(pcifParser ctx)
{
    pANTLR3_COMMON_TOKEN    TAG5;

    /* Initialize rule variables
     */

    TAG5       = NULL;

    {
        // cif.g:171:3: ( LOOP_ ( TAG )+ )
        // cif.g:171:5: LOOP_ ( TAG )+
        {
             MATCHT(LOOP_, &FOLLOW_LOOP__in_loop_header307);
            if  (HASEXCEPTION())
            {
                goto ruleloop_headerEx;
            }


            // cif.g:171:11: ( TAG )+
            {
                int cnt11=0;

                for (;;)
                {
                    int alt11=2;
                switch ( LA(1) )
                {
                case TAG:
                        {
                                alt11=1;
                        }
                    break;

                }

                switch (alt11)
                {
                    case 1:
                        // cif.g:171:13: TAG
                        {
                            TAG5 = (pANTLR3_COMMON_TOKEN) MATCHT(TAG, &FOLLOW_TAG_in_loop_header311);
                            if  (HASEXCEPTION())
                            {
                                goto ruleloop_headerEx;
                            }


                            {

                                  ((SCOPE_TOP(data_items))->curr_loop_headers)->push_back(to_std_string(TAG5));
                                  ((SCOPE_TOP(data_items))->curr_loop_values)->push_back(((SCOPE_TOP(parse))->builder)->new_array());

                            }


                        }
                        break;

                    default:

                        if ( cnt11 >= 1 )
                        {
                            goto loop11;
                        }
                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleloop_headerEx;
                }
                cnt11++;
                }
                loop11: ;       /* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruleloop_headerEx; /* Prevent compiler warnings */
    ruleloop_headerEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end loop_header */

/**
 * $ANTLR start value
 * cif.g:184:1: value : ( INAPPLICABLE | UNKNOWN | NUMERIC | char_string | text_field );
 */
static cifParser_value_return
value(pcifParser ctx)
{
    cifParser_value_return retval;


    /* Initialize rule variables
     */

    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  cif.g:185:3: ( INAPPLICABLE | UNKNOWN | NUMERIC | char_string | text_field )

            ANTLR3_UINT32 alt12;

            alt12=5;

            switch ( LA(1) )
            {
            case INAPPLICABLE:
                {
                        alt12=1;
                }
                break;
            case UNKNOWN:
                {
                        alt12=2;
                }
                break;
            case NUMERIC:
                {
                        alt12=3;
                }
                break;
            case CHAR_STRING:
                {
                        alt12=4;
                }
                break;
            case SEMI_COLON_TEXT_FIELD:
                {
                        alt12=5;
                }
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 12;
                EXCEPTION->state        = 0;


                goto rulevalueEx;

            }

            switch (alt12)
            {
                case 1:
                    // cif.g:185:5: INAPPLICABLE
                    {
                         MATCHT(INAPPLICABLE, &FOLLOW_INAPPLICABLE_in_value333);
                        if  (HASEXCEPTION())
                        {
                            goto rulevalueEx;
                        }


                    }
                    break;
                case 2:
                    // cif.g:185:20: UNKNOWN
                    {
                         MATCHT(UNKNOWN, &FOLLOW_UNKNOWN_in_value337);
                        if  (HASEXCEPTION())
                        {
                            goto rulevalueEx;
                        }


                    }
                    break;
                case 3:
                    // cif.g:185:30: NUMERIC
                    {
                         MATCHT(NUMERIC, &FOLLOW_NUMERIC_in_value341);
                        if  (HASEXCEPTION())
                        {
                            goto rulevalueEx;
                        }


                    }
                    break;
                case 4:
                    // cif.g:185:40: char_string
                    {
                        FOLLOWPUSH(FOLLOW_char_string_in_value345);
                        char_string(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto rulevalueEx;
                        }


                    }
                    break;
                case 5:
                    // cif.g:185:54: text_field
                    {
                        FOLLOWPUSH(FOLLOW_text_field_in_value349);
                        text_field(ctx);

                        FOLLOWPOP();
                        if  (HASEXCEPTION())
                        {
                            goto rulevalueEx;
                        }


                    }
                    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulevalueEx; /* Prevent compiler warnings */
    rulevalueEx: ;
    retval.stop = LT(-1);


            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end value */

/**
 * $ANTLR start char_string
 * cif.g:188:1: char_string : CHAR_STRING ;
 */
static void
char_string(pcifParser ctx)
{
    /* Initialize rule variables
     */

    {
        // cif.g:189:3: ( CHAR_STRING )
        // cif.g:189:5: CHAR_STRING
        {
             MATCHT(CHAR_STRING, &FOLLOW_CHAR_STRING_in_char_string362);
            if  (HASEXCEPTION())
            {
                goto rulechar_stringEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulechar_stringEx; /* Prevent compiler warnings */
    rulechar_stringEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end char_string */

/**
 * $ANTLR start text_field
 * cif.g:191:1: text_field : SEMI_COLON_TEXT_FIELD ;
 */
static void
text_field(pcifParser ctx)
{
    /* Initialize rule variables
     */

    {
        // cif.g:192:3: ( SEMI_COLON_TEXT_FIELD )
        // cif.g:192:5: SEMI_COLON_TEXT_FIELD
        {
             MATCHT(SEMI_COLON_TEXT_FIELD, &FOLLOW_SEMI_COLON_TEXT_FIELD_in_text_field373);
            if  (HASEXCEPTION())
            {
                goto ruletext_fieldEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletext_fieldEx; /* Prevent compiler warnings */
    ruletext_fieldEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end text_field */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
