/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import mso.generator.JavaParserGenerator;
import mso.generator.QtApiGenerator;
import mso.generator.QtParserGenerator;
import mso.generator.utils.MSO;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ParserGeneratorRunner {
    public static void main(String[] stringArray) throws Exception {
        ParserGeneratorRunner parserGeneratorRunner = new ParserGeneratorRunner();
        new File("src/mso/javaparser").mkdirs();
        Validator validator = parserGeneratorRunner.createValidator("mso.xsd");
        parserGeneratorRunner.generate(validator, "mso.xml", "MSO", "cpp");
    }

    void generate(Validator validator, String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException, Exception {
        validator.validate(new StreamSource(this.open(string)));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.open(string));
        MSO mSO = new MSO(document);
        new File(string3).mkdirs();
        this.generateJavaParser(mSO, string2);
        this.generateQtParser(mSO, "", "generatedclasses", string3);
        this.generateSimpleQtParser(mSO, string2, "simpleParser", string3);
        this.generateApi(mSO, string2, "api", string3);
    }

    void generateJavaParser(MSO mSO, String string) throws IOException {
        JavaParserGenerator javaParserGenerator = new JavaParserGenerator();
        String string2 = string.toLowerCase();
        String string3 = string.substring(0, 1) + string2.substring(1);
        javaParserGenerator.generate(mSO, "src", string2 + ".javaparser", "Generated" + string3 + "Parser");
    }

    void generateQtParser(MSO mSO, String string, String string2, String string3) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator();
        qtParserGenerator.config.namespace = string;
        qtParserGenerator.config.basename = string2;
        qtParserGenerator.config.outputdir = string3;
        qtParserGenerator.config.createHeader = false;
        qtParserGenerator.config.enableIntrospection = true;
        qtParserGenerator.config.enableXml = true;
        qtParserGenerator.config.enableWriting = true;
        qtParserGenerator.config.enableToString = true;
        qtParserGenerator.config.enableStyleTextPropAtomFix = false;
        qtParserGenerator.generate(mSO);
    }

    void generateSimpleQtParser(MSO mSO, String string, String string2, String string3) throws IOException {
        QtParserGenerator qtParserGenerator = new QtParserGenerator();
        qtParserGenerator.config.namespace = string;
        qtParserGenerator.config.basename = string2;
        qtParserGenerator.config.outputdir = string3;
        qtParserGenerator.config.createHeader = true;
        qtParserGenerator.config.enableIntrospection = false;
        qtParserGenerator.config.enableXml = false;
        qtParserGenerator.config.enableWriting = false;
        qtParserGenerator.config.enableToString = false;
        qtParserGenerator.config.enableStyleTextPropAtomFix = true;
        qtParserGenerator.generate(mSO);
    }

    void generateApi(MSO mSO, String string, String string2, String string3) throws IOException {
        QtApiGenerator qtApiGenerator = new QtApiGenerator();
        qtApiGenerator.config.namespace = string;
        qtApiGenerator.config.basename = string2;
        qtApiGenerator.config.outputdir = string3;
        qtApiGenerator.config.createHeader = true;
        qtApiGenerator.generate(mSO);
    }

    InputStream open(String string) throws Exception {
        File file = new File(string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        file = new File("src/" + string);
        if (file.canRead()) {
            System.out.println("Reading " + file.getAbsolutePath());
            return new FileInputStream(file.getAbsolutePath());
        }
        System.out.println("Reading " + string + " from jar file.");
        return this.getClass().getResourceAsStream("/" + string);
    }

    Validator createValidator(String string) throws Exception {
        String string2 = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
        Source[] sourceArray = new Source[]{new StreamSource(this.open(string))};
        Schema schema = schemaFactory.newSchema(sourceArray);
        return schema.newValidator();
    }
}

